/* Chromium Unity integration extension
 * 
 *   Copyright 2012 Canonical Ltd.
 *
 *   This program is free software: you can redistribute it and/or modify it 
 *   under the terms of the GNU General Public License version 3, as published 
 *   by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but 
 *   WITHOUT ANY WARRANTY; without even the implied warranties of 
 *   MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 *   PURPOSE.  See the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along 
 *   with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

(function () {
   var performContentScriptInitialization = function (loggerf) {
     
     // TODO mmh bad ... 
     // TODO properly refactor that & isolate somewhere before the bloat gets worse
     UnityContentScriptApi = {
       getTabInfo: function (callback) {
	 chrome.runtime.sendMessage ({method: "get_tab_info"}, callback);
       },
       killTabWithId: function (tabInfo) {
	 chrome.extension.sendMessage ({method: "kill_this_tab"
                                        , tabId: tabInfo.tabId
                                        , windowId: tabInfo.windowId});
       },
       raiseTabWithId: function (tabInfo) {
	 chrome.runtime.sendMessage ({method: "raise_this_tab"
                                        , tabId: tabInfo.tabId
                                        , windowId: tabInfo.windowId});
       },
       getBaseDomain: function (url, callback) {
	 chrome.runtime.sendMessage ({method: "get_base_domain", url: url}
				       , function (response) {
					 if (! response) {
					   // TODO log
					   return;
					 }
					 
					 if (response.error) {
					   // TODO log
					   return;
					 }
					 
					 callback (response);
				       });
       },
       toDataURL: function (url, callback) {
	 chrome.runtime.sendMessage ({method: "get_data_url_from", url: url}
				       , function (response) {
					 if (! response) {
					   // TODO log
					   return;
					 }
					 
					 if (response.error) {
					   // TODO log
					   return;
					 }
					 
					 callback (response.flag, response.dataUrl);
				       });
       },
       // TODO complete w/ infobar when available
       requestUnityIntegration: function (message, details, callback) {
	 chrome.runtime.sendMessage ({method: "request_user_integration"
					, message: message
                                        , details: details
				       }
				       , function (response) {
					 if (response && response.error) {
					   // TODO log
					   return;
					 }
					 
					 callback (response);
				       });
       },
       getExtensionSettings: function (callback) {
	 chrome.runtime.sendMessage ({method: "get_extension_settings"}
				       , function (response) {
					 if (response && response.error) {
					   // TODO log
					   return;
					 }
					 
					 callback (response);
				       });
       },
       takeSnapshot: function (callback) {
	 chrome.runtime.sendMessage ({method: "take_snapshot"}
				       , function (response) {
					 if (response && response.error) {
					   // TODO log
					   return;
					 }
					 
					 callback (response);
				       });
       },
       addIntegrationScriptForTab: function (contextname, domain, interest_id) {
	 chrome.runtime.sendMessage ({method: "add_integrationscript_for_tabid"
                                        , name: contextname
                                        , domain: domain
                                        , interest_id: interest_id});
       }
     };
     
     
     // 
     // Initialize if needed
     // 
     var initializeIntegrationScriptIfNeededForUrl = function (loggerf) {
       
       var logger = loggerf || function (m) {};
       
       // does the unity script injection + user script if necessary
       logger ('Base content script, started on url: ' + document.URL);

       var addPluginNode = function () {
	 var element = document.createElement ('embed');
	 element.type = 'application/x-unity-webapps-npapi';
	 element.id = 'unityChromiumExtensionId';
	 element.height = 0;
	 element.width = 0;
         element.style.setProperty("display", "block", "important");
	 document.getElementsByTagName("body")[0].appendChild (element);
       };
       
       var getUserScriptContent = function (url) {
	 var content = null;
	 var xhr = new XMLHttpRequest();

	 xhr.onreadystatechange = function() {
	   if (xhr.readyState == 4) {
	     content = xhr.responseText;
	   }
	 };
	 // mmh blocking
	 xhr.open("GET", url, false);

	 try {
	   xhr.send();
	 } catch(e) {
	   logger ('Could not load user script content from: ' + url);
	 }
	 return content;
       };
       
       /**
        * Injects a given javascript file in the current content script
        * 
        * @param path path *in the current extension* of the required file
        */
       var require = function (path) {
	 try {
	   eval.call (window, getUserScriptContent (chrome.runtime.getURL (path)));
	 }
	 catch (e) {
	   logger ('Failed to add required dependancy: ' + path + ', ' + e);
	 }
       };
       
       var injectSource = function (source) {
	 try {
	   eval.call (window, source);
	 }
	 catch (e) {
	   logger ('Failed to inject plain source: ' + e.toString());
	 }
       };
       
       // Initiate communication w/ background page.
       /**
	* We send our URL and potentially receive something (scripts to insert)
	* 
	*/
       UnityContentScriptApi.getExtensionSettings (
	 function (settings) {
	   
           // Bail out if in incognito mode.
           if (settings && settings.incognito) {
             return;
           }

	   // plugin is added in the current document/environment (content script page)
	   // 
	   // Note: the plugin node is injected in each supported integration script
	   //  this is a bit costly but putting it in the background page would
	   //  require some proper serialization of the NPAPI structure or
	   //  using connect() w/ back and forth com between the content script & background
	   //  page, the Unity object only being a proxy between.
           // 
           // The plugin node is made available no matter what to support web application
           // binding.
	   
           // TODO: to remove, only there bc of some FF compatibility reasons.
	   consoleService = {
	     logStringMessage: function (msg) {
	       if (settings && settings.logging) {
		 console.log (msg);
	       }
	     }
	   };

	   /**
	    * Setup the environment
	    *
	    */
           try {
             // NPAPI entry point
	     addPluginNode ();
           }
           catch (e) {
             // plain exit
             logger('Could not add the plugin node to an iframe frame/window: ' + e);
             return;
           }

	   // TODO: temporary FF & misc compatibility tools
	   require ('content/unity-misc-utils.js');
	   require ('extension-tools.js');
	   require ("unity-api.js");
           require ('webkitnotif-wrapper-builder.js');
	   require ("unity-webapps-binding.js");
	   require ("browser.js");

           /**
            * Do we need to inject an integration script for this page?
            * (only for the top window)
            */ 
           if (top === self) {
             var isValidUserscriptRetrievalResponse = function (response) {
	         return response != null
                   && response instanceof Array
                   && 0 !== response.length;
             };
             var injectUserScripts = function (scripts) {
               scripts.forEach (function (script) {
		 var injected = '(function () { ';
                 
		 // inject the script & its dependancies (dependancies first)
		 if (script.requires) {
		   injected += script.requires;
		 }
                 
		 injected += script.userscript;
                 injected += ' }) ();';
                 
		 logger ('Injecting userscript');
                 injectSource (injected);
               });
             };

             var url = document.URL;
             UnityContentScriptApi.getBaseDomain (url, function (domain) {
  	       chrome.runtime.sendMessage (
	         {method: "get_unity_script", url: document.URL, domain: domain}
	         , function (response) {
	         
	           if (isValidUserscriptRetrievalResponse(response)) {
		     if (! external.getUnityObject) {
		       logger ('Failed to inject external.getUnityObject function');
		     }
		     else {
		       logger ('external.getUnityObject function has been injected');
                     
                       injectUserScripts(response);
                     }
	           } // if (isValidUserscriptRetrievalResponse)
	         }
	       ); // sendRequest
             }); // getBaseDomain

           } // if (top === self) {

	 } // function (settings) {

       ); //  getExtensionSettings
       
     }; // initializeIntegrationScriptIfNeededForUrl
     
     
     // plain init call
     initializeIntegrationScriptIfNeededForUrl (loggerf);
     
   }; // performContentScriptInitialization
   
   // only do it for the top window, not the iframes
   performContentScriptInitialization (
     function (msg) {
       if (top === self) {
         console.log ("Content script: " + msg);
       }
     }
   );

 }
) ();

