function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        this._browser.injectScript('(' + function () {
            document.evaluate('//div[@class="b-track b-track_type_title js-track js-track-33273"]/div/div[@class="b-play__i"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.click();
        } + ')();');

        setTimeout(function () {
            this._browser.finish();
        }.bind(this), 3000);
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        var i, correctTrack = false;
        for (i = 0; i < log.length; i++) {
            if (log[i].func === 'Unity.MediaPlayer.setTrack' && log[i].args[0].title === 'Sweet Dreams (Are Made Of This)' && log[i].args[0].artist === 'Marilyn Manson') {
                correctTrack = true;
            }
        }

        assertTrue('correctTrack', correctTrack);
    },

    scriptName: 'yandexmusic.user.js'
};
