# Copyright (C) 2007  Lars Wirzenius <liw@iki.fi>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


"""Unperish plugin for releasing upstream parts."""


import os

import unperishlib


class CreateTarball(unperishlib.Operation):

    """Create upstream tarball.
    
    This operation doesn't actually do anything, it just adds the
    --upstream-tarball option to the parser, and requires it to be set.
    This way, some other plugin will do all the hard work. This is good,
    because the way to generate a tarball is dependent, for example, on
    the version control system being used.
    
    """

    name = "create-tarball"
    
    required_options = ["upstream_tarball"]
    
    def add_options(self, parser):
        parser.add_public_option("--upstream-tarball", metavar="FILE", 
                                 help="Name the release tarball FILE.")
