/* 
   Copyright (C) 2004  Jeroen Dekkers <jeroen@dekkers.cx>
   Copyright (C) 2000-2002  Christian Scheurer (www.ChristianScheurer.ch)
   Copyright (C) 2000-2002  Johannes Winkelmann (jw@tks6.net)
   RAR decompression code:
   Copyright (c) 1993-2002  Eugene Roshal

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "unrarlib.h"
#include "unrar29.h"

void Unpack29(FILE *inputfile,int DestUnpSize, int UnpPackedSize, int Flags) {
  FILE *ofile;
  static unpack_data_t *unpack_data=NULL;
  static int i=0;
  int filepos,intfd,c;
  char tmpfilename[100];
  extern unsigned char *temp_output_buffer;
  extern unsigned long *temp_output_buffer_offset;

  filepos = ftell(inputfile);
  snprintf(tmpfilename,sizeof(tmpfilename)-1,"/tmp/unrartmpf%d",i);
  i++;
  ofile = tmpfile();
  /*ofile = fopen(tmpfilename,"w+b");*/
  
  if (ofile==NULL) {
    #ifdef _DEBUG_LOG
    fprintf(stderr,"Fatal! Cannot open tmp file!\n");
    #endif
    return;
  }
  
  if (unpack_data==NULL) {
    unpack_data = malloc(sizeof(unpack_data_t));
    ppm_constructor(&unpack_data->ppm_data);
  }
  unpack_data->rarvm_data.mem = NULL;
  unpack_data->old_filter_lengths = NULL;
  unpack_data->PrgStack.array = NULL;
  unpack_data->Filters.array = NULL;
  unpack_data->PrgStack.num_items = 0;
  unpack_data->Filters.num_items = 0;
  unpack_data->unp_crc = 0xffffffff;
  unpack_data->dest_unp_size = DestUnpSize;
  unpack_data->pack_size = UnpPackedSize;
  unpack_data->ofd = fileno(ofile);
  intfd = fileno(inputfile);
  lseek(intfd,filepos,SEEK_SET);
  rar_unpack29(intfd,Flags&LHD_SOLID,unpack_data);
  fflush(ofile);
  if (temp_output_buffer != NULL) {
    fseek(ofile,0,SEEK_SET);
    while (!feof(ofile)) {
      if ((*temp_output_buffer_offset) > DestUnpSize) {
        #ifdef _DEBUG_LOG
        fprintf(stderr,"Fatal! Buffer overrun during compression!\n");
        #endif
        break;
      }
      c = fgetc(ofile);
      if (c==EOF) {
        break;
      }
      temp_output_buffer[(*temp_output_buffer_offset)] = c;
      (*temp_output_buffer_offset)++;
    }
  }
  fseek(inputfile,filepos+UnpPackedSize,SEEK_SET);
  fclose(ofile);
}
