#!/usr/local/bin/perl
# changepass.cgi
# Change the user's password now, using PAM and the passwd service

require './changepass-lib.pl';
&error_setup($text{'change_err'});
&ReadParse();

# Validate inputs
$in{'new1'} ne '' || &error($text{'change_enew1'});
$in{'new1'} eq $in{'new2'} || &error($text{'change_enew2'});

eval "use Authen::PAM";
$has_pam++ if (!$@);

if ($config{'passwd_cmd'} || !$has_pam) {
	# Call passwd program to do the change
	if ($config{'passwd_cmd'}) {
		$passwd_cmd = $config{'passwd_cmd'};
		}
	else {
		$passwd_cmd = &has_command("passwd");
		$passwd_cmd ||
			&error(&text('change_epasswd', "<tt>passwd</tt>"));
		}
	&foreign_require("proc", "proc-lib.pl");
	$ENV{'USER'} = $ENV{'LOGNAME'} = $remote_user;
	@uinfo = getpwnam($remote_user);
	$ENV{'HOME'} = $uinfo[7];
	chdir($uinfo[7]);
	local ($fh, $fpid) = &proc::pty_process_exec($passwd_cmd,
						     $uinfo[2], $uinfo[3]);
	chdir($module_root_directory);
	while(1) {
		local $rv = &wait_for($fh, '(new|re-enter).*:',
					   '(old|current|login).*:',
					   'pick a password');
		$out .= $wait_for_input;
		sleep(1);
		if ($rv == 0) {
			syswrite($fh, $in{'new1'}."\n", length($in{'new1'})+1);
			}
		elsif ($rv == 1) {
			syswrite($fh, $in{'old'}."\n", length($in{'old'})+1);
			}
		elsif ($rv == 2) {
			syswrite($fh, "1\n", 2);
			}
		else {
			last;
			}
		last if (++$count > 10);
		}
	$crv = close($fh);
	sleep(1);
	waitpid($fpid, 1);
	&error(&text('change_ecmd', "<tt>$passwd_cmd</tt>", "<pre>$out</pre>")) if ($? || $count > 10 || $out =~ /bad\s+password|error|failed/i);
	}
else {
	# Check if the old password is correct
	&get_miniserv_config(\%miniserv);
	$service = $miniserv{'pam'} ? $miniserv{'pam'} : "webmin";
	$pamh = new Authen::PAM($service, $remote_user, \&pam_check_func);
	$rv = $pamh->pam_authenticate();
	$rv == PAM_SUCCESS || &error($text{'change_eold'});
	$pamh = undef;

	# Change the password with PAM
	$pamh = new Authen::PAM("passwd", $remote_user, \&pam_change_func);
	$rv = $pamh->pam_chauthtok();
	$rv == PAM_SUCCESS || &error(&text('change_epam2', $pamh->pam_strerror($rv)));
	$pamh = undef;
	}

# Change samba password as well
if (&has_command($config{'smbpasswd'})) {
	$in{'new1'} =~ s/\\/\\\\/g;
	$in{'new1'} =~ s/\'/\\'/g;
	$smbout = `$config{'smbpasswd'} '$remote_user' '$in{'new1'}' 2>&1 </dev/null`;
	}

# Change matching stored POP3 passwords in read mail module
if (&foreign_check("mailbox")) {
	&foreign_require("mailbox", "mailbox-lib.pl");
	foreach $f (&mailbox::list_folders()) {
		if (($f->{'type'} == 2 || $f->{'type'} == 4) &&
		    $f->{'user'} eq $remote_user &&
		    $f->{'pass'} eq $in{'old'}) {
			# Found one to change
			local $type = $f->{'type'} == 2 ? "pop3" : "imap";
			if ($f->{'inbox'}) {
				# Need to change special inbox password file
				$file = "$mailbox::user_module_config_directory/inbox";
				push(@pc, &text('change_inbox', uc($type)));
				}
			else {
				# Need to change folder's file
				$file = "$mailbox::user_module_config_directory/$f->{'id'}";
				push(@pc, &text('change_folder', uc($type), $f->{'server'}));
				}
			$file .= ".".$type;
			local %data;
			&read_file($file, \%data);
			$data{'pass'} = $in{'new1'};
			&write_file($file, \%data);
			}
		}
	}

&header($text{'change_title'}, "");
print "<hr>\n";
print "<p>",&text('change_ok', "<tt>$remote_user</tt>"),"<p>\n";
if ($smbout =~ /changed/) {
	print "<p>",&text('change_samba'),"<p>\n";
	}
elsif ($smbout) {
	print "<p>",&text('change_samba2', "<pre>$smbout</pre>"),"<p>\n";
	}
foreach $pc (@pc) {
	print "$pc<br>\n";
	}
print "<hr>\n";
&footer("", $text{'index_return'});

sub pam_check_func
{
my @res;
while ( @_ ) {
	my $code = shift;
	my $msg = shift;
	my $ans = "";

	$ans = $remote_user if ($code == PAM_PROMPT_ECHO_ON());
	$ans = $in{'old'} if ($code == PAM_PROMPT_ECHO_OFF());

	push @res, PAM_SUCCESS();
	push @res, $ans;
	}
push @res, PAM_SUCCESS();
return @res;
}

sub pam_change_func
{
my @res;
while ( @_ ) {
	my $code = shift;
	my $msg = shift;
	my $ans = "";

	$ans = $remote_user if ($code == PAM_PROMPT_ECHO_ON());
	$ans = $in{'new1'} if ($code == PAM_PROMPT_ECHO_OFF());

	push @res, PAM_SUCCESS();
	push @res, $ans;
	}
push @res, PAM_SUCCESS();
return @res;

}

