# linux-lib.pl
# Functions for changing user details on linux

# change_details(realname, office, ophone, hphone, shell)
sub change_details
{
foreach $a (@_) {
	$a =~ s/\\//g;
	$a =~ s/'//g;
	}

# What version of chfn are we running?
local $out = `chfn -v 2>&1`;
local $cmd;
if ($out =~ /pwdutils/i || $out =~ /-r/) {
	# Change details using chfn from pwdutils syntax
	$cmd = "chfn -f '$_[0]'";
	local @ruser = getpwnam($remote_user);
	local @uinfo = split(/,/, $ruser[6]);
	$cmd .= " -r '$_[1]'" if ($_[1] || $uinfo[1]);
	$cmd .= " -w '$_[2]'" if ($_[2] || $uinfo[2]);
	$cmd .= " -h '$_[3]'" if ($_[3] || $uinfo[3]);
	$cmd .= " $remote_user";
	}
else {
	# Change details using chfn from util-linux syntax
	$cmd = "chfn -f '$_[0]'";
	local @ruser = getpwnam($remote_user);
	local @uinfo = split(/,/, $ruser[6]);
	$cmd .= " -o '$_[1]'" if ($_[1] || $uinfo[1]);
	$cmd .= " -p '$_[2]'" if ($_[2] || $uinfo[2]);
	$cmd .= " -h '$_[3]'" if ($_[3] || $uinfo[3]);
	$cmd .= " $remote_user";
	}
local $out = `$cmd 2>&1`;
return $out if ($?);

# Change shell
$cmd = "chsh -s '$_[4]' $remote_user";
$out = `$cmd 2>&1`;
return $? ? $out : undef;
}

1;

