#!/usr/local/bin/perl
# index.cgi
# List the mail messages for the user

require './mailbox-lib.pl';
&ReadParse();

dbmopen(%read, "$user_module_config_directory/read", 0600);

print "Refresh: $userconfig{'refresh'}\r\n"
	if ($userconfig{'refresh'});
&header($text{'mail_title'}, "", undef, 1, 1);
print "<hr>\n";
@folders = &list_folders();
if (!defined($in{'folder'}) && $userconfig{'default_folder'}) {
	($df) = grep { $_->{'file'} eq $userconfig{'default_folder'} ||
		       $_->{'server'} eq $userconfig{'default_folder'} }
		     @folders;
	$in{'folder'} = $df->{'index'} if ($df);
	}
$folder = $folders[$in{'folder'}];

# Check if this is a POP3 or IMAP inbox with no login set
if (($folder->{'type'} == 2 || $folder->{'type'} == 4) &&
    $folder->{'mode'} == 3 && !defined($folder->{'user'})) {
	print "<form action=inbox_login.cgi method=post>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'mail_loginheader'}</b></td> </tr>\n";
	print "<tr $cb> <td align=middle>",&text('mail_logindesc',
			"<tt>$folder->{'server'}</tt>"),"\n";
	print "<table>\n";

	print "<tr> <td><b>$text{'mail_loginuser'}</b></td>\n";
	print "<td><input name=user size=30 value='$remote_user'></td> </tr>\n";
	print "<tr> <td><b>$text{'mail_loginpass'}</b></td>\n";
	print "<td><input type=password name=pass size=30></td> </tr>\n";
	if ($folder->{'type'} == 4) {
		print "<tr> <td valign=top><b>$text{'mail_loginmailbox'}",
		      "</b></td> <td>\n";
		printf"<input type=radio name=mailbox_def value=1 %s> %s<br>\n",
			"checked", $text{'edit_imapinbox'};
		printf"<input type=radio name=mailbox_def value=0> %s\n",
			$text{'edit_imapother'};
		print "<input name=mailbox size=20></td> </tr>\n";
		}

	print "<tr> <td colspan=2 align=center>\n";
	print "<input type=submit value='$text{'mail_login'}'>\n";
	print "<input type=reset value='$text{'mail_reset'}'></td> </tr>\n";
	print "</table></td></tr></table></form>\n";

	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

$sel = "<select name=folder>\n";
foreach $f (@folders) {
	$sel .= sprintf "<option value=%d %s>%s\n",
		$f->{'index'}, $f eq $folder ? "selected" : "",
		$f->{'name'};
	}
$sel .= "</select>\n";

# View mail from the most recent
$perpage = $folder->{'perpage'} || $userconfig{'perpage'};
@mail = reverse(&mailbox_list_mails(-$in{'start'},
				    -$in{'start'}-$perpage+1,
				    $folder, 1, \@error));
print "<center>\n";
print "<form action=index.cgi><font size=+1>\n";
if ($in{'start'}+$perpage < @mail) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		$in{'start'}+$perpage, $in{'folder'},
		'<img src=/images/left.gif border=0 align=middle>';
	}

local $s = @mail-$in{'start'};
local $e = @mail-$in{'start'}-$perpage+1;
if (@mail) {
	print &text('mail_pos', $s, $e < 1 ? 1 : $e, scalar(@mail), $sel);
	}
else {
	print &text('mail_none', $sel);
	}
print "</font><input type=submit value='$text{'mail_fchange'}'>\n";

if ($in{'start'}) {
	printf "<a href='index.cgi?start=%d&folder=%d'>%s</a>\n",
		$in{'start'}-$perpage, $in{'folder'},
		'<img src=/images/right.gif border=0 align=middle>';
	}
print "</form></center>\n";

print "<form action=delete_mail.cgi>\n";
print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
if ($userconfig{'top_buttons'} && @mail) {
	&show_buttons(1);
	print "<a href='' onClick='document.forms[1].d.checked = true; for(i=0; i<document.forms[1].d.length; i++) { document.forms[1].d[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[1].d.checked = !document.forms[1].d.checked; for(i=0; i<document.forms[1].d.length; i++) { document.forms[1].d[i].checked = !document.forms[1].d[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;\n";
	}

$showto = $folder->{'sent'} || $folder->{'drafts'};
if (@mail) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td>&nbsp;</td> ",
	      $showto ? "<td><b>$text{'mail_to'}</b></td>"
		       : "<td><b>$text{'mail_from'}</b></td> ",
	      $userconfig{'show_to'} ? $showto ?
			"<td><b>$text{'mail_from'}</b></td>" :
			"<td><b>$text{'mail_to'}</b></td>" : "",
	      "<td><b>$text{'mail_date'}</b></td> ",
	      "<td><b>$text{'mail_size'}</b></td> ",
	      "<td><b>$text{'mail_subject'}</b></td> </tr>\n";
	}
if (@error) {
	print "<center><b><font color=#ff0000>\n";
	print &text('mail_err', $error[0] == 0 ? $error[1] :
			      &text('save_elogin', $error[1])),"\n";
	print "</font></b></center>\n";
	}
elsif (@error && $error[0] == 2) {
	}

for($i=$in{'start'}; $i<@mail && $i<$in{'start'}+$perpage; $i++) {
	&notes_decode($mail[$i], $folder);
	local $idx = $mail[$i]->{'idx'};
	print "<tr $cb>\n";
	print "<td><input type=checkbox name=d value=$idx></td>\n";
	print "<td nowrap><a href='view_mail.cgi?idx=$idx&folder=$folder->{'index'}'>",
              &simplify_from($mail[$i]->{'header'}->{$showto ? 'to' : 'from'}),
	      "</td>\n";
	if ($userconfig{'show_to'}) {
		print "<td nowrap>",&simplify_from(
	   		$mail[$i]->{'header'}->{$showto ? 'from' : 'to'}),
			"</td>\n";
		}
	print "<td nowrap>",&simplify_date($mail[$i]->{'header'}->{'date'}),
	      "</td>\n";
	print "<td nowrap>",int($mail[$i]->{'size'}/1000)+1," kB","</td>\n";
	print "<td><table border=0 cellpadding=0 cellspacing=0 width=100%>",
	      "<tr><td>",&simplify_subject($mail[$i]->{'header'}->{'subject'}),
	      "</td> <td align=right>";
	if ($mail[$i]->{'header'}->{'content-type'} =~ /multipart\/\S+/i) {
		print "<img src=images/attach.gif>";
		}
	local $p = int($mail[$i]->{'header'}->{'x-priority'});
	if ($p == 1) {
		print "&nbsp;<img src=images/p1.gif>";
		}
	elsif ($p == 2) {
		print "&nbsp;<img src=images/p2.gif>";
		}
	if (!$showto) {
		if ($read{$mail[$i]->{'header'}->{'message-id'}} == 2) {
			print "&nbsp;<img src=images/special.gif>";
			}
		elsif ($read{$mail[$i]->{'header'}->{'message-id'}} == 1) {
			print "&nbsp;<img src=images/read.gif>";
			}
		}
	print "</td></tr></table></td> </tr>\n";
	}
if (@mail) {
	print "</table>\n";
	print "<a href='' onClick='document.forms[1].d.checked = true; for(i=0; i<document.forms[1].d.length; i++) { document.forms[1].d[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[1].d.checked = !document.forms[1].d.checked; for(i=0; i<document.forms[1].d.length; i++) { document.forms[1].d[i].checked = !document.forms[1].d[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;\n";
	}

&show_buttons(2);
print "</form>\n";

print "<hr>\n";
print "<table width=100%><tr>\n";
print "<form action=mail_search.cgi>\n";
print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
print "<td><b>$text{'mail_search'}</b>\n";
print "<select name=field>\n";
foreach $f ('from', 'subject', 'to', 'cc', 'date', 'body', 'size',
    '!from', '!subject', '!to', '!cc', '!date', '!body', '!size') {
	printf "<option value=%s>%s\n", $f, $text{"match_$f"};
	}
print "</select>\n";
print "<input name=match size=20>\n";
print "&nbsp;<input type=submit value='$text{'mail_ok'}'></td>\n";
print "</form>\n";
print "</table><p>\n";

# Show various buttons for the address book, folders, sig and logging out
print "<table width=100%><tr>\n";

print "<form action=list_addresses.cgi>\n";
print "<td align=left><input type=submit value='$text{'mail_addresses'}'></td>\n";
print "</form>\n";

print "<form action=list_folders.cgi>\n";
print "<td align=center><input type=submit value='$text{'mail_folders'}'></td>\n";
print "</form>\n";

$logout = ($folder->{'type'} == 2 || $folder->{'type'} == 4) &&
	  $folder->{'mode'} == 3 && defined($folder->{'user'});
if (&get_signature_file()) {
	print "<form action=edit_sig.cgi>\n";
	print "<td align=",$logout ? "center" : "right",
	      "><input type=submit value='$text{'mail_sig'}'></td>\n";
	print "</form>\n";
	}

if ($logout) {
	# Add button for logging out of inbox
	print "<form action=inbox_logout.cgi>\n";
	print "<input type=hidden name=folder value='$folder->{'index'}'>\n";
	print "<td align=right><input type=submit value='",
		$folder->{'type'} == 2 ? $text{'mail_logout'} :
					 $text{'mail_logout2'},"'></td>\n";
	print "</form>\n";
	}

print "</tr></table>\n";

print "<hr>\n";
&footer("/", $text{'index'});
&pop3_logout();

# show_buttons(number)
sub show_buttons
{
print "<table width=100%> <tr>\n";
if (@mail) {
	print "<td>\n";
	print "<input type=submit name=delete value=\"$text{'mail_delete'}\">\n";
	print "</td>\n";

	print "<td>\n";
	print "<input type=submit name=mark$_[0] value=\"$text{'mail_mark'}\">\n";
	print "<select name=mode$_[0]>\n";
	print "<option value=1 checked>$text{'mail_mark1'}\n";
	print "<option value=0>$text{'mail_mark0'}\n";
	print "<option value=2>$text{'mail_mark2'}\n";
	print "</select></td>\n";

	if (@folders > 1) {
		print "<td>",&move_select($_[0], \@folders, $folder),"</td>\n";
		}

	print "<td><input type=submit name=forward value=\"$text{'mail_forward'}\"></td>\n";

	}
print "<td align=right><input type=submit name=new ",
      "value=\"$text{'mail_compose'}\"></td>\n";
print "</tr></table>\n";
}

