#!/usr/local/bin/perl
# backup_db.cgi
# Do the actual backup

require './mysql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
$access{'edonly'} && &error($text{'dbase_ecannot'});
$access{'buser'} || &error($text{'dbase_ecannot'});
&error_setup($text{'backup_err'});

if (!$in{'save'} || $in{'sched'}) {
	$in{'file'} =~ /^\/\S+$/ || &error($text{'backup_efile'});
	$in{'where_def'} || $in{'where'} || &error($text{'backup_ewhere'});
	if (!&is_under_directory($access{'bpath'}, $in{'file'})) {
		&error($text{'backup_epath'}."<br>".
		       &text('backup_eunder', "<tt>$access{'bpath'}</tt>"));
		}
	}
$drop = $in{'drop'} ? "--add-drop-table" : "";
$where = $in{'where_def'} ? "" : "\"--where=$in{'where'}\"";
if (&supports_quoting()) {
	$quoting = " --quote-names";
	}
$cron = !$module_info{'usermin'} && $access{'buser'} eq 'root' &&
	!$access{'user'} && &foreign_installed("cron");
if ($cron) {
	$config{'backup_before_'.$in{'db'}} = $in{'before'};
	$config{'backup_after_'.$in{'db'}} = $in{'after'};

	&foreign_require("cron", "cron-lib.pl");
	@jobs = &cron::list_cron_jobs();
	($job) = grep { $_->{'command'} eq "$cron_cmd $in{'db'}" } @jobs;
	$oldjob = $job;
	$job ||= { 'command' => "$cron_cmd $in{'db'}",
		   'user' => 'root',
		   'active' => 1 };
	&cron::parse_times_input($job, \%in);
	}

# Save choices for next time the form is visited (and for the cron job)
if ($module_info{'usermin'}) {
	$userconfig{'backup_'.$in{'db'}} = $in{'file'};
	$userconfig{'backup_where_'.$in{'db'}} =
		$in{'where_def'} ? undef : $in{'where'};
	$userconfig{'backup_drop_'.$in{'db'}} = $in{'drop'};
	&write_file("$user_module_config_directory/config", \%userconfig);
	}
else {
	$config{'backup_'.$in{'db'}} = $in{'file'};
	$config{'backup_where_'.$in{'db'}} =
		$in{'where_def'} ? undef : $in{'where'};
	$config{'backup_drop_'.$in{'db'}} = $in{'drop'};
	&write_file("$module_config_directory/config", \%config);
	}

&header($text{'backup_title'}, "");
print "<hr>\n";
print "<p>\n";
if (!$in{'save'}) {
	# Actually execute the backup now
	$file = &date_subs($in{'file'});
	&execute_before($in{'db'}, STDOUT, 1, $file) if ($cron);
	unlink($file);
	if ($access{'buser'} eq 'root') {
		$out = &backquote_logged("$config{'mysqldump'} $authstr $drop $where $quoting ".quotemeta($in{'db'})." 2>&1 >$file");
		}
	else {
		$out = &backquote_logged("su $access{'buser'} -c ".quotemeta("$config{'mysqldump'} $authstr $drop $where $quoting ".quotemeta($in{'db'})." >$file")." 2>&1");
		}
	if ($? || $out) {
		print "$whatfailed : ",
		      &text('backup_ebackup', "<pre>$out</pre>"),"<p>\n";
		}
	else {
		@st = stat($file);
		print &text('backup_done', "<tt>$in{'db'}</tt>",
			    "<tt>$file</tt>", $st[7]),"<p>\n";
		}
	&execute_after($in{'db'}, STDOUT, 1, $file) if ($cron);
	}

if ($cron) {
	&lock_file($cron_cmd);
	&cron::create_wrapper($cron_cmd, $module_name, "backup.pl");
	&unlock_file($cron_cmd);

	&lock_file(&cron::cron_file($job));
	if ($in{'sched'} && !$oldjob) {
		&cron::create_cron_job($job);
		$what = "backup_ccron";
		}
	elsif (!$in{'sched'} && $oldjob) {
		# Need to delete cron job
		&cron::delete_cron_job($job);
		$what = "backup_dcron";
		}
	elsif ($in{'sched'} && $oldjob) {
		# Need to update cron job
		&cron::change_cron_job($job);
		$what = "backup_ucron";
		}
        else {
                $what = "backup_ncron";
                }
	&unlock_file(&cron::cron_file($job));

	# Tell the user what was done
	print $text{$what},"<p>\n" if ($what);
	}

&webmin_log("backup", undef, $in{'db'}, \%in);
print "<hr>\n";
&footer("edit_dbase.cgi?db=$in{'db'}", $text{'dbase_return'},
	"", $text{'index_return'});

