#!/usr/local/bin/perl
# save_pop3.cgi
# Create, modify or delete a POP3 folder

require './mailbox-lib.pl';
&ReadParse();
@folders = &list_folders();
$folder = $folders[$in{'idx'}] if (!$in{'new'});
&error_setup($text{'save_err'});
$folder_types{'pop3'} || &error($text{'save_ecannot'});

if ($in{'delete'}) {
	# Just delete this folder and cache
	unlink("$user_module_config_directory/$folder->{'id'}.pop3");
	system("rm -rf $user_module_config_directory/$folder->{'id'}.cache");
	}
else {
	# Validate inputs
	$in{'name'} =~ /\S/ || &error($text{'save_ename'});
	gethostbyname($in{'server'}) || &check_ipaddress($in{'server'}) ||
		&error($text{'save_eserver'});
	$in{'port_def'} || $in{'port'} =~ /^\d+$/ ||
		&error($text{'save_eport'});
	$in{'user'} =~ /\S/ || &error($text{'save_euser'});
	$in{'perpage_def'} || $in{'perpage'} =~ /^\d+$/ ||
		&error($text{'save_eperpage'});
	$in{'fromaddr_def'} || $in{'fromaddr'} =~ /\S/ ||
		&error($text{'save_efromaddr'});

	# Save the folder
	$pop3{'id'} = $folder->{'id'} || time();
	$pop3{'name'} = $in{'name'};
	$pop3{'server'} = $in{'server'};
	$pop3{'port'} = $in{'port_def'} ? undef : $in{'port'};
	$pop3{'user'} = $in{'user'};
	$pop3{'pass'} = $in{'pass'};
	$pop3{'perpage'} = $in{'perpage_def'} ? undef : $in{'perpage'};
	$pop3{'fromaddr'} = $in{'fromaddr_def'} ? undef : $in{'fromaddr'};
	$pop3{'sent'} = $in{'sent'};
	local @err = &pop3_login(\%pop3);
	if ($err[0] == 0) {
		&error($err[1]);
		}
	elsif ($err[0] == 2) {
		&error(&text('save_elogin', $err[1]));
		}
	else {
		&pop3_logout($err[1]);
		}
	&write_file("$user_module_config_directory/$pop3{'id'}.pop3", \%pop3);
	chmod(0700, "$user_module_config_directory/$pop3{'id'}.pop3");
	}
&redirect("list_folders.cgi");

