#!/usr/local/bin/perl
# list_folders.cgi
# Display a list of all folders and allows additional and deletion

require './mailbox-lib.pl';
&ui_print_header(undef, $text{'folders_title'}, "");

print "$text{'folders_desc2'}<br>\n";
print "<ul>\n";
foreach $ft ('sys', 'local', 'ext', 'pop3', 'imap', 'comp', 'virt') {
	print "<li>",$text{'folders_desc'.$ft},"\n"
		if ($ft eq "sys" || $folder_types{$ft});
	}
print "</ul>\n";

@folders = &list_folders_sorted();
print &ui_form_start("newfolder.cgi");
print "<table border>\n";
print "<tr $tb> <td><b>$text{'folders_name'}</b></td> ",
      "<td><b>$text{'folders_path'}</b></td> ",
      "<td><b>$text{'folders_type'}</b></td> ",
      "<td><b>$text{'folders_size'}</b></td> </tr>\n";
foreach $f (@folders) {
	print "<tr $cb>\n";
	if ($f->{'inbox'} || $f->{'drafts'}) {
		# Inbox or drafs folder which cannot be edited
		print "<td>$f->{'name'}</td>\n";
		}
	elsif ($f->{'type'} == 2) {
		# Link for editing POP3 folder
		print "<td><a href='edit_pop3.cgi?idx=$f->{'index'}'>",
		      "$f->{'name'}</a></td>\n";
		}
	elsif ($f->{'type'} == 4) {
		# Link for editing IMAP folder
		print "<td><a href='edit_imap.cgi?idx=$f->{'index'}'>",
		      "$f->{'name'}</a></td>\n";
		}
	elsif ($f->{'mode'} == 2 && !$folder_types{'ext'}) {
		# Sent mail folder can only be changed if external folders
		# are allowed
		print "<td>$f->{'name'}</td>\n";
		}
	elsif ($f->{'type'} == 5) {
		# Link for editing composite folder
		print "<td><a href='edit_comp.cgi?idx=$f->{'index'}'>",
		      "$f->{'name'}</a></td>\n";
		}
	elsif ($f->{'type'} == 6) {
		# Link for editing virtual folder
		print "<td><a href='edit_virt.cgi?idx=$f->{'index'}'>",
		      "$f->{'name'}</a></td>\n";
		}
	else {
		# Link for editing local or external folder
		print "<td><a href='edit_folder.cgi?idx=$f->{'index'}'>",
		      "$f->{'name'}</a></td>\n";
		}
	if ($f->{'type'} == 2 || $f->{'type'} == 4) {
		# Show mail server
		print "<td>",&text(
			$f->{'port'} ? 'folders_servp' : 'folders_serv',
			"<tt>$f->{'user'}</tt>", "<tt>$f->{'server'}</tt>",
			"<tt>$f->{'port'}</tt>"),"</td>\n";
		print "<td>",$f->{'type'} == 2 ? "POP3" : "IMAP","</td>\n";
		print "<td><br></td>\n";
		}
	elsif ($f->{'type'} == 5) {
		# Show number of sub-folders and total size
		print "<td>",&text('folders_num',
				   scalar(@{$f->{'subfolders'}}),
				   &mailbox_folder_size($f)),"</td>\n";
		print "<td>",$text{'folders_comp'},"</td>\n";
		print "<td>",&nice_size(&folder_size($f)),"</td>\n";
		}
	elsif ($f->{'type'} == 6) {
		# Show number of messages
		print "<td>",&text('folders_vnum',
				   &mailbox_folder_size($f)),"</td>\n";
		print "<td>",$text{'folders_virt'},"</td>\n";
		print "<td><br></td>\n";
		}
	else {
		# Show folder directory and size
		local $mf = &folder_file($f);
		print "<td>$mf</td>\n";
		print "<td>",$f->{'type'} == 1 ? $text{'folders_maildir'} :
			     $f->{'type'} == 3 ? $text{'folders_mhdir'} :
				      $text{'folders_mbox'},"</td>\n";
		print "<td>",&nice_size(&folder_size($f)),"</td>\n";
		}
	print "</tr>\n";
	}
print "</table>\n";
@folder_progs = ( [ "edit_folder.cgi?new=1&mode=0", "local" ],
		  [ "edit_folder.cgi?new=1&mode=1", "ext" ],
		  [ "edit_pop3.cgi?new=1", "pop3" ],
		  [ "edit_imap.cgi?new=1", "imap" ],
		  [ "edit_comp.cgi?new=1", "comp" ],
		  [ "edit_virt.cgi?new=1", "virt" ] );
@can_folder_progs = grep { $folder_types{$_->[1]} } @folder_progs;
if (@can_folder_progs) {
	print &ui_submit($text{'folders_newfolder'}),"\n";
	print &ui_select("prog", $can_folder_progs[0]->[0],
			 [ map { [ $_->[0], $text{'folders_type_'.$_->[1]} ] }
			       @can_folder_progs ]),"\n";
	print "<br>\n";
	}
print &ui_form_end();

&ui_print_footer("", $text{'index'});

