#!/usr/local/bin/perl
# Delete multiple tables

require './postgresql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
@tables = split(/\0/, $in{'d'});
@tables || &error($text{'tdrops_enone'});

if ($in{'confirm'}) {
	# Drop the table
	&error_setup($text{'tdrops_err'});
	foreach $t (@tables) {
		$qt = &quote_table($t);
		&execute_sql_logged($in{'db'}, "drop table $qt");
		}
	&webmin_log("delete", "tables", scalar(@tables), \%in);
	&redirect("edit_dbase.cgi?db=$in{'db'}");
	}
else {
	# Ask the user if he is sure..
	&ui_print_header(undef, $text{'tdrops_title'}, "");
	foreach $t (@tables) {
		$qt = &quote_table($t);
		$d = &execute_sql_safe($in{'db'}, "select count(*) from $qt");
		$rows += $d->{'data'}->[0]->[0];
		}

	print "<center><b>", &text('tdrops_rusure', scalar(@tables),
				   "<tt>$in{'db'}</tt>", $rows),"</b><p>\n";
	print "<form action=drop_tables.cgi>\n";
	print "<input type=hidden name=db value='$in{'db'}'>\n";
	foreach $t (@tables) {
		print &ui_hidden("d", $t),"\n";
		}
	print "<input type=submit name=confirm value='$text{'tdrops_ok'}'>\n";
	print "</form></center>\n";
	&ui_print_footer("edit_table.cgi?db=$in{'db'}&table=$in{'table'}",
		$text{'table_return'});
	}

