// $Id: syscall_netremove-net.hc,v 1.3 2006/01/18 23:40:15 ensc Exp $    --*- c -*--

// Copyright (C) 2004 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

static inline ALWAYSINLINE int
vc_net_remove_net(nid_t nid, struct vc_net_nx const *info)
{
  struct vcmd_net_addr_v0		k_info;
  size_t				i;

  k_info.type      = NETTYPE_USER2KERNEL(info->type);
  k_info.count     = info->count;
  for (i = 0; i < sizeof(k_info.ip) / sizeof(*k_info.ip); i++)
    k_info.ip[i]   = info->ip[i];
  for (i = 0; i < sizeof(k_info.mask) / sizeof(*k_info.mask); i++)
    k_info.mask[i] = info->mask[i];
  
  return vserver(VCMD_net_remove, NID_USER2KERNEL(nid), &k_info);
}
