/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#ifndef UTOUCH_QML_TOUCH_H_
#define UTOUCH_QML_TOUCH_H_

#include <QDeclarativeItem>

#include <geis/geis.h>

/**
 * An item that provides information about a touch point.
 */

class Touch : public QDeclarativeItem {
  Q_OBJECT
  /**
   * This property holds the ID of the touch.
   */
  Q_PROPERTY(int id READ id)

  /**
   * This property holds the coordinates of the touch.
   *
   * For Indirect and Independent devices, the value is in device coordinates.
   * For Direct devices, the value is in screen coordinates.
   */
  Q_PROPERTY(QPointF location READ location)

  /**
   * This property holds a variant map of attributes of the touch.
   *
   * All uTouch touch attributes are available in this property. The keys may
   * be referenced in the geis.h header file.
   */
  Q_PROPERTY(const QVariantMap attributes READ attributes)

 public:
  Touch();

  void Initialize(GeisTouch touch);
  int id() const { return id_; }
  QPointF location() const { return location_; }
  const QVariantMap attributes() const { return attributes_; }

 private:
  int id_;
  QPointF location_;
  QVariantMap attributes_;

  Q_DISABLE_COPY(Touch)
};

QML_DECLARE_TYPE(Touch)

#endif  // UTOUCH_QML_TOUCH_H_
