

-- UUAGC 0.9.37.2 (Transform.ag)
module Transform where
{-# LINE 8 "Transform.ag" #-}

import Control.Monad(mplus,mzero)
import List (partition, elem, nub,intersperse)
import Data.Maybe
import qualified Data.Map as Map
import Data.Map (Map)
import Data.Set as Set (Set, member, union, toList, fromList, empty, singleton, member, unions, size, fold, intersection, difference, insert)
import qualified Data.Sequence as Seq
import Data.Sequence(Seq, empty, (><),fromList)
import Data.Foldable(toList)
import UU.Scanner.Position(noPos)

import ConcreteSyntax
import AbstractSyntax
import ErrorMessages
import Patterns (Patterns(..),Pattern(..))
import Expression (Expression(..))
import HsToken

import Options
import CommonTypes
import RhsCheck
{-# LINE 29 "../src-derived/Transform.hs" #-}

{-# LINE 2 "./ConcreteSyntax.ag" #-}

import UU.Scanner.Position (Pos)
import Patterns   (Pattern)
import Expression (Expression)
import CommonTypes
{-# LINE 37 "../src-derived/Transform.hs" #-}

{-# LINE 2 "./Patterns.ag" #-}

-- Patterns.ag imports
import UU.Scanner.Position(Pos)
import CommonTypes (ConstructorIdent,Identifier)
{-# LINE 44 "../src-derived/Transform.hs" #-}
{-# LINE 101 "Transform.ag" #-}
type DefinedSets = Map Identifier (Set NontermIdent) 
{-# LINE 47 "../src-derived/Transform.hs" #-}

{-# LINE 121 "Transform.ag" #-}
type FieldMap  = [(Identifier, Type)] 
{-# LINE 51 "../src-derived/Transform.hs" #-}

{-# LINE 122 "Transform.ag" #-}
type DataTypes = Map.Map NontermIdent (Map.Map ConstructorIdent FieldMap) 
{-# LINE 55 "../src-derived/Transform.hs" #-}

{-# LINE 142 "Transform.ag" #-}
type AttrName   = (Identifier,Identifier) 
{-# LINE 59 "../src-derived/Transform.hs" #-}

{-# LINE 143 "Transform.ag" #-}
type RuleInfo   = (Maybe Identifier, [AttrName]->Pattern, Expression, [AttrName], Bool, String) 
{-# LINE 63 "../src-derived/Transform.hs" #-}

{-# LINE 144 "Transform.ag" #-}
type SigInfo    = (Identifier,Type) 
{-# LINE 67 "../src-derived/Transform.hs" #-}

{-# LINE 145 "Transform.ag" #-}
type UniqueInfo = (Identifier,Identifier) 
{-# LINE 71 "../src-derived/Transform.hs" #-}

{-# LINE 146 "Transform.ag" #-}
type AugmentInfo = (Identifier,Expression)
{-# LINE 75 "../src-derived/Transform.hs" #-}

{-# LINE 147 "Transform.ag" #-}
type AroundInfo  = (Identifier,Expression)
{-# LINE 79 "../src-derived/Transform.hs" #-}

{-# LINE 148 "Transform.ag" #-}
type MergeInfo   = (Identifier, Identifier, [Identifier], Expression)
{-# LINE 83 "../src-derived/Transform.hs" #-}

{-# LINE 202 "Transform.ag" #-}


checkDuplicate :: (Identifier -> Identifier -> Error)
               -> Identifier -> val -> Map Identifier val -> (Map Identifier val,Seq Error)
checkDuplicate dupError key val m
  = case Map.lookupIndex key m of
     Just ix -> let (key',_) = Map.elemAt ix m
                in  (m,Seq.singleton (dupError key key'))
     Nothing -> (Map.insert key val m,Seq.empty)

checkDuplicates :: (Identifier -> Identifier -> Error)
                -> [(Identifier, val)] -> Map Identifier val -> (Map Identifier val,Seq Error)
checkDuplicates dupError new m = foldErrors check m new
 where  check = uncurry (checkDuplicate dupError)

foldErrors f e xs = foldl g (e,Seq.empty) xs
  where g ~(e,es) x = let (e',es') = f x e
                      in (e', es >< es')


checkForDuplicates :: (Identifier -> Identifier -> Error)  ->  [Identifier]  ->  [Error]
checkForDuplicates err [] = []
checkForDuplicates err (x:xs) = let (same,other) = List.partition (equalId x) xs
                                in  map (err x) same ++ checkForDuplicates err other

equalId :: Identifier -> Identifier -> Bool
equalId x y = getName x == getName y

{-# LINE 114 "../src-derived/Transform.hs" #-}

{-# LINE 338 "Transform.ag" #-}

type RulesAndErrors = ([Rule], Seq Error)
type SigsAndErrors  = ([TypeSig], Seq Error)
type InstsAndErrors = ([(Identifier, Type)], Seq Error)
type UniquesAndErrors = (Map Identifier Identifier, Seq Error)
type AugmentsAndErrors = (Map Identifier [Expression], Seq Error)
type AroundsAndErrors = (Map Identifier [Expression], Seq Error)
type MergesAndErrors  = (Map Identifier (Identifier, [Identifier], Expression), Seq Error)
type AttrOverwrite  = Map AttrName Bool
type AccumRuleCheck = (RulesAndErrors, AttrOverwrite)
type AccumDefiCheck = (Seq Error, AttrOverwrite, [AttrName], [AttrName])

checkRules :: Map NontermIdent (Attributes, Attributes) -> Map NontermIdent (Map ConstructorIdent FieldMap) ->
              Map NontermIdent (Map ConstructorIdent [Identifier]) -> Map NontermIdent (Map ConstructorIdent [SigInfo]) ->
              Map NontermIdent (Map ConstructorIdent [MergeInfo]) ->
              NontermIdent -> ConstructorIdent -> [RuleInfo] -> RulesAndErrors
checkRules attributes fields allinsts allsigs allmerges nt con rs
  = let fieldmap :: FieldMap
        fieldmap = (_LHS,NT nt undefined) : (_LOC,NT undefined undefined) : (_INST, NT undefined undefined) : (_FIRST, NT undefined undefined) : (_LAST, NT undefined undefined)
                 : Map.findWithDefault [] con (Map.findWithDefault Map.empty nt fields)
                 ++ mapMaybe (\instNm -> lookup instNm sigs >>= \tp -> return (instNm, tp)) (Map.findWithDefault [] con (Map.findWithDefault Map.empty nt allinsts))
                 --   merged children are not allowed to have any inherited attrs defined: do not include
        
        sigs = Map.findWithDefault [] con (Map.findWithDefault Map.empty nt allsigs)

        hasAttrib f tp attr  = Map.member attr (f (Map.findWithDefault (Map.empty,Map.empty) tp attributes))
  
        checkRule :: RuleInfo -> AccumRuleCheck -> AccumRuleCheck
        checkRule (mbNm, pat,exp,as,owrt,str) ((r1,e1),m1) 
          = let (e2,m2,u2,b2) = foldr (checkDefi owrt) (e1,m1,[],[]) as
            in  ( (Rule mbNm (pat u2) exp owrt str True : r1, e2), m2)

        checkDefi :: Bool -> AttrName -> AccumDefiCheck -> AccumDefiCheck
        checkDefi owrt fa@(field,attr) (e,m,u,bs)
         = case lookup field fieldmap
            of  Just (NT tp _) -> 
                  let tp' = maybe tp id (deforestedNt tp)
                  in              if field == _LOC || field == _INST || field == _FIRST || field == _LAST
                                     || hasAttrib (if getName field==getName _LHS then snd else fst) tp' attr
                                  then case Map.lookupIndex fa m of
                                           Just ix -> let ((_,attr2),b) = Map.elemAt ix m
                                                       in  if b && not (fa `elem` bs)
                                                           then (                                             e, Map.insert fa owrt m, fa:u, fa:bs)
                                                           else (((Seq.<|)) (DupRule nt con field attr2 attr)   e,                    m, fa:u,    bs)
                                           Nothing ->           (                                             e, Map.insert fa owrt m,    u, fa:bs)
                                  else                          (((Seq.<|)) (SuperfluousRule nt con field attr) e,                    m, fa:u,    bs)
                _              ->                               (((Seq.<|)) (UndefChild nt con field)           e,                    m, fa:u,    bs )

    in  fst (foldr checkRule (([],Seq.empty),Map.empty) rs)

checkRuleNames :: NontermIdent -> ConstructorIdent -> [RuleInfo] -> Seq Error
checkRuleNames nt con
  = fst . foldr checkRule (Seq.empty, Set.empty)
  where
    checkRule (Just nm,_,_,_,_,_) (errs, nms)
      | nm `Set.member` nms = (DupRuleName nt con nm Seq.<| errs, nms)
      | otherwise           = (errs, Set.insert nm nms)
    checkRule (Nothing,_,_,_,_,_) inp = inp

checkSigs :: NontermIdent -> ConstructorIdent -> [SigInfo] -> SigsAndErrors
checkSigs nt con sis 
  = let checkSig (ide,typ) (sigs,errs)
         = if   ide `elem` map (\(TypeSig n t)-> n) sigs
           then (sigs, ((Seq.<|)) (DupSig nt con ide) errs)
           -- else if not (ide `elem` locattrdefs)
           -- then (sigs, ((Seq.<|)) (SupSig nt con ide) errs)
           else (TypeSig ide typ:sigs, errs)
    in  foldr checkSig ([],Seq.empty) sis

checkInsts :: Set NontermIdent -> Map NontermIdent (Map ConstructorIdent [SigInfo]) -> Map NontermIdent (Map ConstructorIdent [(Identifier, Type)]) -> NontermIdent -> ConstructorIdent -> [Identifier] -> InstsAndErrors
checkInsts allNts sigMap fieldMap nt con
  = foldr (\inst (insts, errs) ->
              maybe (insts, Seq.singleton (MissingInstSig nt con inst) >< errs)
                    (\info@(k, NT nm _) ->
                      case findInst k insts of
                        Just k' -> (insts, Seq.singleton (DupChild nt con k k') >< errs)
                        Nothing -> case nm `Set.member` allNts of
                                             True  -> (info : insts, errs)
                                             False | take 2 (getName nm) == "T_" -> let nm' = Ident (drop 2 (getName nm)) (getPos nm)
                                                                                    in case nm' `Set.member` allNts of
                                                                                         True  -> (info : insts, errs)
                                                                                         False -> (insts, Seq.singleton (UndefNont nm') >< errs)
                                                   | otherwise                   -> (insts, Seq.singleton (UndefNont nm) >< errs)
                    ) 
                  $ findSig inst
          ) ([], Seq.empty)
  where
    sigs = Map.findWithDefault [] con (Map.findWithDefault Map.empty nt sigMap)
    
    findSig name
      = do tp@(NT _ _) <- lookup name sigs
           return (name, tp)
    
    findInst _ [] = Nothing
    findInst k ((k', _): r)
      | k == k'   = Just k'
      | otherwise = findInst k r

checkUniques :: Map NontermIdent (Attributes, Attributes) -> NontermIdent -> ConstructorIdent -> [UniqueInfo] -> UniquesAndErrors
checkUniques allAttrs nt con uniques
  = let checkUnique (ident,ref) (us,errs)
          = if ident `Map.member` us
            then (us, ((Seq.<|)) (DupUnique nt con ident) errs)
            else if Map.member ref inhs && Map.member ref syns
                 then (Map.insert ident ref us, errs)
                 else (us, ((Seq.<|)) (MissingUnique nt ref) errs)

        (inhs,syns) = Map.findWithDefault (Map.empty,Map.empty) nt allAttrs
    in foldr checkUnique (Map.empty, Seq.empty) uniques

checkAugments :: Map NontermIdent (Attributes, Attributes) -> NontermIdent -> ConstructorIdent -> [AugmentInfo] -> AugmentsAndErrors
checkAugments allAttrs nt con augments
  = let checkAugment (ident,expr) (as,errs)
          = if ident `Map.member` as
            then (Map.update (\vs -> Just (vs ++ [expr])) ident as, errs)
            else if Map.member ident syns
                 then (Map.insert ident [expr] as, errs)
                 else (as, ((Seq.<|)) (MissingSyn nt ident) errs)

        (inhs,syns) = Map.findWithDefault (Map.empty,Map.empty) nt allAttrs
    in foldr checkAugment (Map.empty, Seq.empty) augments

checkArounds :: Map NontermIdent (Map ConstructorIdent [(Identifier, Type)]) -> NontermIdent -> ConstructorIdent -> [AroundInfo] -> AroundsAndErrors
checkArounds fieldMap nt con arounds
  = let checkAround (ident,expr) (as,errs)
          = if ident `Map.member` as
            then (Map.update (\vs -> Just (vs ++ [expr])) ident as, errs)
            else case lookup ident fields of
                   Just (NT _ _) -> (Map.insert ident [expr] as, errs)
                   _             -> (as, ((Seq.<|)) (UndefChild nt con ident) errs)
        fields = Map.findWithDefault [] con (Map.findWithDefault Map.empty nt fieldMap)
    in foldr checkAround (Map.empty, Seq.empty) arounds

checkMerges :: Set NontermIdent -> Map NontermIdent (Map ConstructorIdent [Identifier]) -> Map NontermIdent (Map ConstructorIdent [(Identifier, Type)]) -> NontermIdent -> ConstructorIdent -> [MergeInfo] -> MergesAndErrors
checkMerges allNts allInsts fieldMap nt con merges
  = let checkMerge (target,nt,sources,expr) (m,errs)
          = let fields = Map.findWithDefault [] con (Map.findWithDefault Map.empty nt fieldMap)
                insts  = Map.findWithDefault [] con (Map.findWithDefault Map.empty nt allInsts)
                allFields = insts ++ map fst fields   -- note: sources of merge may not contain a target (for simplicity)
            in if target `Map.member` m   -- check for duplicate with self
               then (m, DupChild nt con target (fst $ Map.elemAt (Map.findIndex target m) m) Seq.<| errs)
               else if target `elem` allFields
                     then (m, DupChild nt con target (head $ filter (== target) allFields) Seq.<| errs)
                     else let missing = filter (\s -> not (s `elem` allFields)) sources
                          in if null missing
                             then if nt `Set.member` allNts   -- check if the nonterm is defined
                                  then (Map.insert target (nt, sources, expr) m, errs) -- all ok..
                                  else (m, UndefNont nt Seq.<| errs)
                             else (m, (Seq.fromList $ map (UndefChild nt con) missing) Seq.>< errs)
    in foldr checkMerge (Map.empty, Seq.empty) merges

unionunionplusplus = Map.unionWith (Map.unionWith (++))
{-# LINE 269 "../src-derived/Transform.hs" #-}

{-# LINE 493 "Transform.ag" #-}

mkUniqueRules :: Options -> Map NontermIdent (Map ConstructorIdent [(Identifier, Type)]) -> Map NontermIdent (Map ConstructorIdent [(Identifier, Type)]) -> Map NontermIdent (Attributes,Attributes) -> NontermIdent -> ConstructorIdent -> Map Identifier Identifier -> [Rule]
mkUniqueRules opts allFields allInsts allAttrDecls nt con usMap
  = map apply groups
  where
    fields = Map.findWithDefault [] con (Map.findWithDefault Map.empty nt allFields)
             ++ Map.findWithDefault [] con (Map.findWithDefault Map.empty nt allInsts)
             -- may have duplicates

    groups = Map.assocs $ Map.foldrWithKey (\i r m -> Map.insertWith (++) r [i] m) Map.empty usMap
    apply (ref,us) = mkRule ref (findOutField ref) us
    findOutField ref = case [ chld | (chld,NT tp _) <- fields, tp `hasSyn` ref] of
                         []    -> _LHS
                         (x:_) -> x
    hasSyn tp ref = Map.member ref $ snd $ Map.findWithDefault (Map.empty,Map.empty) tp allAttrDecls
    mkRule ref outFld locAttrs
      = let pat = Product noPos (attr outFld ref : [attr _LOC u | u <- locAttrs ])
            rhs = Expression noPos $ wrap ref $ foldr gencase (finalout locAttrs) locAttrs
                     -- [HsToken ("mkUniques" ++ show (length locAttrs) ++ " ") noPos, AGField _LHS ref noPos Nothing]
        in Rule Nothing pat rhs False "-- generated by the unique rule mechanism." False
    attr fld a = Alias fld a (Underscore noPos) []
    gencase nm outp
      = h ("case " ++ uniqueDispenser opts ++ " __cont of { (__cont, " ++ getName nm ++ ") -> ") ++ outp ++ h "}"
    h s = [HsToken s noPos]
    finalout us = h ("(__cont, " ++ concat (intersperse "," (map getName us)) ++ ")")
    wrap ref inp = h "case " ++ [AGField _LHS ref noPos Nothing] ++ h " of { __cont | __cont `seq` True -> " ++ inp ++ h "}"
{-# LINE 298 "../src-derived/Transform.hs" #-}

{-# LINE 691 "Transform.ag" #-}

flattenDatas :: DataTypes -> Map NontermIdent (Set NontermIdent)
flattenDatas ds = Map.map flatten ds
  where flatten cs =  Set.fromList [ nt | (_,NT nt _) <- concatMap snd (Map.toList cs)]

reachableFrom :: Map NontermIdent (Set NontermIdent) -> Set NontermIdent -> Set NontermIdent
reachableFrom table nts = reach nts
  where reach nts = let nts' = Set.unions (nts : [ ns  | nt <- Set.toList nts
                                                 , let ns = Map.findWithDefault Set.empty nt table ])
                    in if Set.size nts' > Set.size nts
                          then reach nts'
                          else nts
invert :: Map NontermIdent (Set NontermIdent) -> Map NontermIdent (Set NontermIdent)
invert m = foldr inv Map.empty (Map.toList m)
  where inv (x,ns) m = fold (\n m -> Map.insertWith Set.union n (Set.singleton x) m) m ns

path :: Map NontermIdent (Set NontermIdent) -> NontermIdent -> NontermIdent -> Set NontermIdent
path table from to = let children = Map.findWithDefault Set.empty from table
                         forward  = reachableFrom table children
                         backward = reachableFrom (invert table)
                                                  (Set.singleton to)
                     in  Set.intersection forward backward
{-# LINE 323 "../src-derived/Transform.hs" #-}

{-# LINE 808 "Transform.ag" #-}

pragmaMapUnion :: PragmaMap -> PragmaMap -> PragmaMap
pragmaMapUnion = Map.unionWith (Map.unionWith Set.union)

pragmaMapSingle :: NontermIdent -> ConstructorIdent -> Set Identifier -> PragmaMap
pragmaMapSingle nt con nms = Map.singleton nt (Map.singleton con nms)
{-# LINE 332 "../src-derived/Transform.hs" #-}

{-# LINE 840 "Transform.ag" #-}

orderMapUnion :: AttrOrderMap -> AttrOrderMap -> AttrOrderMap
orderMapUnion = Map.unionWith (Map.unionWith Set.union)

orderMapSingle :: NontermIdent -> ConstructorIdent -> Set Dependency -> AttrOrderMap
orderMapSingle nt con deps = Map.singleton nt (Map.singleton con deps)
{-# LINE 341 "../src-derived/Transform.hs" #-}

{-# LINE 866 "Transform.ag" #-}

mergeParams :: ParamMap -> ParamMap -> ParamMap
mergeParams = Map.unionWith (++)
{-# LINE 347 "../src-derived/Transform.hs" #-}

{-# LINE 889 "Transform.ag" #-}

mergeCtx :: ContextMap -> ContextMap -> ContextMap
mergeCtx
  = Map.unionWith nubconcat
  where nubconcat a b = nub (a ++ b)
{-# LINE 355 "../src-derived/Transform.hs" #-}

{-# LINE 902 "Transform.ag" #-}

mergeDerivings m1 m2 = foldr (\(n,cs) m -> Map.insertWith Set.union n cs m) m2 (Map.toList m1)
{-# LINE 360 "../src-derived/Transform.hs" #-}

{-# LINE 913 "Transform.ag" #-}

merge x y = foldr f y (Map.toList x)
 where f ~(k,v) m = Map.insertWith (Map.union) k v m
{-# LINE 366 "../src-derived/Transform.hs" #-}

{-# LINE 954 "Transform.ag" #-}

checkAttrs allFields nts inherited synthesized decls = foldErrors check decls nts where
  check nt decls | not (nt `Map.member` allFields) = (decls,Seq.singleton(UndefNont nt))
                 | otherwise = let (inh,syn) = Map.findWithDefault (Map.empty,Map.empty) nt decls
                                   (inh',einh) = checkDuplicates (DupInhAttr nt) inherited   inh
                                   (syn',esyn) = checkDuplicates (DupSynAttr nt) synthesized syn
                               in (Map.insert nt (inh',syn') decls,einh >< esyn)
{-# LINE 376 "../src-derived/Transform.hs" #-}

{-# LINE 965 "Transform.ag" #-}

addSelf name atMap = let (eInh,eSyn) = Map.findWithDefault(Map.empty,Map.empty) name atMap
                     in  Map.insert name (eInh, Map.insert (Ident "self" noPos) (NT _SELF []) eSyn)atMap
{-# LINE 382 "../src-derived/Transform.hs" #-}

{-# LINE 1106 "Transform.ag" #-}

makeType :: Set NontermIdent -> Type -> Type
makeType nts tp@(NT x _) | x == _SELF       = tp
                         | Set.member x nts = tp
                         | otherwise        = Haskell (typeToHaskellString Nothing [] tp)
makeType _   tp                             = tp
{-# LINE 391 "../src-derived/Transform.hs" #-}

{-# LINE 1113 "Transform.ag" #-}

constructGrammar ::    Set NontermIdent
                    -> ParamMap
                    -> DataTypes
                    -> Map NontermIdent (Attributes, Attributes)
                    -> Map NontermIdent (Map Identifier (String, String, String))
                    -> Derivings
                    -> Set NontermIdent
                    -> Map NontermIdent (Map ConstructorIdent [Rule])
                    -> Map NontermIdent (Map ConstructorIdent [TypeSig])
                    -> Map NontermIdent (Map ConstructorIdent [(Identifier, Type)])
                    -> TypeSyns
                    -> PragmaMap
                    -> AttrOrderMap
                    -> ContextMap
                    -> UniqueMap
                    -> Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))
                    -> Map NontermIdent (Map ConstructorIdent (Map Identifier [Expression]))
                    -> Map NontermIdent (Map ConstructorIdent (Map Identifier (Identifier, [Identifier], Expression)))
                    -> Grammar

constructGrammar nts ntParams gram attrs uses derivings wrappers allrules tsigs allinsts tsyns pragmaMap orderMap contextMap uniqueMap augmentsMap aroundsMap mergeMap =
   let gr = [ (nt,Map.toList alts) | (nt,alts) <- Map.toList gram]
       nonts = map nont gr
       nont (nt,alts) =  let (inh,syn) = Map.findWithDefault (Map.empty,Map.empty) nt attrs
                             rmap      = Map.findWithDefault Map.empty             nt allrules
                             tsmap     = Map.findWithDefault Map.empty             nt tsigs
                             instsmap  = Map.findWithDefault Map.empty             nt allinsts
                             params    = Map.findWithDefault []                    nt ntParams
                             mergemap  = Map.findWithDefault Map.empty             nt mergeMap
                             alt (con,flds) =
                                   let rules = maybe [] id (Map.lookup con rmap)
                                       tsigs = maybe [] id (Map.lookup con tsmap)
                                       insts = maybe [] id (Map.lookup con instsmap)
                                       merges = [ (n, NT t []) | (n, (t, _, _)) <- Map.assocs $ maybe Map.empty id (Map.lookup con mergemap) ]

                                       -- important: keep order of children
                                       cldrn = map child (flds ++ filter (not . existsAsField) insts ++ merges)
                                       child (nm, tp) =
                                          let tpI = if existsAsInst nm
                                                    then fromJust $ lookup nm insts
                                                    else tp
                                              (inh,syn) = case tpI of
                                                 NT nt _ -> let nt' = maybe nt id (deforestedNt nt)
                                                            in Map.findWithDefault (Map.empty,Map.empty) nt' attrs
                                                 _       -> (Map.empty,Map.empty)
                                              virt = if existsAsInst nm
                                                     then case lookup nm flds of
                                                            Just tp' -> Just (Just tp')
                                                            Nothing  -> Just Nothing
                                                     else if existsAsMerge nm
                                                          then (Just Nothing)
                                                          else Nothing
                                          in Child nm tpI inh syn virt
                                       existsAsInst nm = maybe False (const True) (lookup nm insts)
                                       existsAsField (nm,_) = maybe False (const True) (lookup nm flds)
                                       existsAsMerge nm = maybe False (const True) (lookup nm merges)
                                   in Production con cldrn rules tsigs
                            in Nonterminal nt params inh syn (map alt alts)
   in Grammar tsyns uses derivings wrappers nonts pragmaMap orderMap ntParams contextMap uniqueMap augmentsMap aroundsMap mergeMap
{-# LINE 454 "../src-derived/Transform.hs" #-}

{-# LINE 1175 "Transform.ag" #-}

mapUnionWithSetUnion = Map.unionWith Set.union
mapUnionWithPlusPlus = Map.unionWith (++)
{-# LINE 460 "../src-derived/Transform.hs" #-}
-- AG ----------------------------------------------------------
{-
   visit 0:
      inherited attribute:
         options              : Options
      synthesized attributes:
         blocks               : Blocks
         errors               : Seq Error
         moduleDecl           : Maybe (String,String,String)
         output               : Grammar
         pragmas              : Options -> Options
   alternatives:
      alternative AG:
         child elems          : Elems 
         visit 0:
            local allFields   : _
            local allConstrs  : _
            local allRules    : _
            local allSigs     : _
            local allInsts    : _
            local allUniques  : _
            local allAugments : _
            local allArounds  : _
            local allMerges   : _
            local augmentSigs : _
            local allRulesErrs : _
            local allNamesErrs : _
            local allSigsErrs : _
            local allInstsErrs : _
            local allUniquesErrs : _
            local allAugmentErrs : _
            local allAroundsErrs : _
            local allMergesErrs : _
            local checkedRulesPre : _
            local checkedSigs : _
            local checkedInsts : _
            local checkedUniques : _
            local checkedAugments : _
            local checkedArounds : _
            local checkedRules : _
            local checkedMerges : _
            local errs1       : _
            local errs2       : _
            local errs3       : _
            local errs4       : _
            local errs5       : _
            local errs6       : _
            local errs7       : _
            local errs8       : _
            local errs9       : _
            local errs10      : _
            local errs11      : _
            local allNonterminals : _
            local allAttrDecls : _
-}
-- cata
sem_AG :: AG  ->
          T_AG 
sem_AG (AG _elems )  =
    (sem_AG_AG (sem_Elems _elems ) )
-- semantic domain
newtype T_AG  = T_AG (Options ->
                      ( Blocks,(Seq Error),(Maybe (String,String,String)),Grammar,(Options -> Options)))
data Inh_AG  = Inh_AG {options_Inh_AG :: !(Options)}
data Syn_AG  = Syn_AG {blocks_Syn_AG :: !(Blocks),errors_Syn_AG :: !((Seq Error)),moduleDecl_Syn_AG :: !((Maybe (String,String,String))),output_Syn_AG :: !(Grammar),pragmas_Syn_AG :: !((Options -> Options))}
wrap_AG :: T_AG  ->
           Inh_AG  ->
           Syn_AG 
wrap_AG (T_AG sem ) (Inh_AG _lhsIoptions )  =
    (let ( _lhsOblocks,_lhsOerrors,_lhsOmoduleDecl,_lhsOoutput,_lhsOpragmas) = sem _lhsIoptions 
     in  (Syn_AG _lhsOblocks _lhsOerrors _lhsOmoduleDecl _lhsOoutput _lhsOpragmas ))
sem_AG_AG :: T_Elems  ->
             T_AG 
sem_AG_AG (T_Elems elems_ )  =
    (T_AG (\ _lhsIoptions ->
               (let _lhsOoutput :: Grammar
                    _lhsOerrors :: (Seq Error)
                    _elemsOallConstructors :: (Map NontermIdent (Set ConstructorIdent))
                    _elemsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                    _elemsOdefinedSets :: DefinedSets
                    _elemsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                    _lhsOblocks :: Blocks
                    _lhsOmoduleDecl :: (Maybe (String,String,String))
                    _lhsOpragmas :: (Options -> Options)
                    _elemsOallAttrDecls :: (Map NontermIdent (Attributes, Attributes))
                    _elemsOallFields :: DataTypes
                    _elemsOallNonterminals :: (Set NontermIdent)
                    _elemsOoptions :: Options
                    _elemsIattrDecls :: (Map NontermIdent (Attributes, Attributes))
                    _elemsIattrOrderCollect :: AttrOrderMap
                    _elemsIblocks :: Blocks
                    _elemsIcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                    _elemsIcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                    _elemsIcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                    _elemsIcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                    _elemsIcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                    _elemsIcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                    _elemsIcollectedNames :: (Set Identifier)
                    _elemsIcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                    _elemsIcollectedSetNames :: (Set Identifier)
                    _elemsIcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                    _elemsIcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                    _elemsIctxCollect :: ContextMap
                    _elemsIdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                    _elemsIderivings :: Derivings
                    _elemsIerrors :: (Seq Error)
                    _elemsImoduleDecl :: (Maybe (String,String,String))
                    _elemsIparamsCollect :: ParamMap
                    _elemsIpragmas :: (Options -> Options)
                    _elemsIsemPragmasCollect :: PragmaMap
                    _elemsItypeSyns :: TypeSyns
                    _elemsIuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                    _elemsIwrappers :: (Set NontermIdent)
                    -- "Transform.ag"(line 52, column 8)
                    _lhsOoutput =
                        ({-# LINE 52 "Transform.ag" #-}
                         constructGrammar _allNonterminals
                                          _elemsIparamsCollect
                                          _allFields
                                          _allAttrDecls
                                          _elemsIuseMap
                                          _elemsIderivings
                                          (if wrappers _lhsIoptions then _allNonterminals     else _elemsIwrappers)
                                          _checkedRules
                                          _checkedSigs
                                          _checkedInsts
                                          _elemsItypeSyns
                                          _elemsIsemPragmasCollect
                                          _elemsIattrOrderCollect
                                          _elemsIctxCollect
                                          _checkedUniques
                                          _checkedAugments
                                          _checkedArounds
                                          _checkedMerges
                         {-# LINE 595 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 253, column 10)
                    _allFields =
                        ({-# LINE 253 "Transform.ag" #-}
                         let f (nt,con,fm) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con fm)
                         in  foldr f (Map.empty) _elemsIcollectedFields
                         {-# LINE 602 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 256, column 10)
                    _allConstrs =
                        ({-# LINE 256 "Transform.ag" #-}
                         let f (nt,con,_) = Map.insertWith (++) nt [con]
                         in  foldr f (Map.empty) _elemsIcollectedFields
                         {-# LINE 609 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 259, column 10)
                    _allRules =
                        ({-# LINE 259 "Transform.ag" #-}
                         let f (nt,con,r) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con [r])
                         in  foldr f (Map.empty) _elemsIcollectedRules
                         {-# LINE 616 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 262, column 10)
                    _allSigs =
                        ({-# LINE 262 "Transform.ag" #-}
                         let f (nt,con,t) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con [t])
                             typeof nt r = Map.findWithDefault (Haskell "<unknown>") r $ fst $ Map.findWithDefault (Map.empty,Map.empty) nt _allAttrDecls
                         in  foldr f (Map.empty) ( _elemsIcollectedSigs
                                                 ++ [ (nt, con, (ident,typeof nt ref))  | (nt, con, us) <- _elemsIcollectedUniques, (ident,ref) <- us ]
                                                 )
                         {-# LINE 626 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 268, column 10)
                    _allInsts =
                        ({-# LINE 268 "Transform.ag" #-}
                         let f (nt,con,is) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con is)
                         in  foldr f (Map.empty) _elemsIcollectedInsts
                         {-# LINE 633 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 271, column 10)
                    _allUniques =
                        ({-# LINE 271 "Transform.ag" #-}
                         let f (nt,con,us) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con us)
                         in foldr f (Map.empty) _elemsIcollectedUniques
                         {-# LINE 640 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 273, column 10)
                    _allAugments =
                        ({-# LINE 273 "Transform.ag" #-}
                         let f (nt,con,as) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con as)
                         in foldr f Map.empty _elemsIcollectedAugments
                         {-# LINE 647 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 275, column 10)
                    _allArounds =
                        ({-# LINE 275 "Transform.ag" #-}
                         let f (nt,con,as) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con as)
                         in foldr f Map.empty _elemsIcollectedArounds
                         {-# LINE 654 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 277, column 10)
                    _allMerges =
                        ({-# LINE 277 "Transform.ag" #-}
                         let f (nt,con,as) = Map.insertWith (Map.unionWith (++)) nt (Map.singleton con as)
                          in foldr f Map.empty _elemsIcollectedMerges
                         {-# LINE 661 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 280, column 10)
                    _augmentSigs =
                        ({-# LINE 280 "Transform.ag" #-}
                         let gen mp = []
                         in Map.map (Map.map gen) _allAugments
                         {-# LINE 668 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 283, column 10)
                    _allRulesErrs =
                        ({-# LINE 283 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . (checkRules _allAttrDecls _allFields _allInsts _allSigs     _allMerges    )) _allRules
                         {-# LINE 674 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 284, column 10)
                    _allNamesErrs =
                        ({-# LINE 284 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . checkRuleNames) _allRules
                         {-# LINE 680 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 285, column 10)
                    _allSigsErrs =
                        ({-# LINE 285 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . (checkSigs                                                 )) _allSigs
                         {-# LINE 686 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 286, column 10)
                    _allInstsErrs =
                        ({-# LINE 286 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . (checkInsts _allNonterminals     _allSigs     _allFields   )) _allInsts
                         {-# LINE 692 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 287, column 10)
                    _allUniquesErrs =
                        ({-# LINE 287 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . (checkUniques _allAttrDecls                                )) _allUniques
                         {-# LINE 698 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 288, column 10)
                    _allAugmentErrs =
                        ({-# LINE 288 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . (checkAugments _allAttrDecls                               )) _allAugments
                         {-# LINE 704 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 289, column 10)
                    _allAroundsErrs =
                        ({-# LINE 289 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . (checkArounds _allFields    )) _allArounds
                         {-# LINE 710 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 290, column 10)
                    _allMergesErrs =
                        ({-# LINE 290 "Transform.ag" #-}
                         Map.mapWithKey (Map.mapWithKey . (checkMerges _allNonterminals     _allInsts     _allFields    )) _allMerges
                         {-# LINE 716 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 292, column 10)
                    _checkedRulesPre =
                        ({-# LINE 292 "Transform.ag" #-}
                         Map.map (Map.map fst) _allRulesErrs
                         {-# LINE 722 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 293, column 10)
                    _checkedSigs =
                        ({-# LINE 293 "Transform.ag" #-}
                         Map.map (Map.map fst) _allSigsErrs     `unionunionplusplus` _augmentSigs
                         {-# LINE 728 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 294, column 10)
                    _checkedInsts =
                        ({-# LINE 294 "Transform.ag" #-}
                         Map.map (Map.map fst) _allInstsErrs
                         {-# LINE 734 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 295, column 10)
                    _checkedUniques =
                        ({-# LINE 295 "Transform.ag" #-}
                         Map.map (Map.map fst) _allUniquesErrs
                         {-# LINE 740 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 296, column 10)
                    _checkedAugments =
                        ({-# LINE 296 "Transform.ag" #-}
                         Map.map (Map.map fst) _allAugmentErrs
                         {-# LINE 746 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 297, column 10)
                    _checkedArounds =
                        ({-# LINE 297 "Transform.ag" #-}
                         Map.map (Map.map fst) _allAroundsErrs
                         {-# LINE 752 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 298, column 10)
                    _checkedRules =
                        ({-# LINE 298 "Transform.ag" #-}
                         Map.unionWith (Map.unionWith (++)) _checkedRulesPre     (Map.mapWithKey (Map.mapWithKey . (mkUniqueRules _lhsIoptions _allFields     _checkedInsts     _allAttrDecls    )) _checkedUniques    )
                         {-# LINE 758 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 299, column 10)
                    _checkedMerges =
                        ({-# LINE 299 "Transform.ag" #-}
                         Map.map (Map.map fst) _allMergesErrs
                         {-# LINE 764 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 301, column 10)
                    _errs1 =
                        ({-# LINE 301 "Transform.ag" #-}
                         let f = checkForDuplicates (DupSynonym)
                         in  Seq.fromList . f . map fst $ _elemsItypeSyns
                         {-# LINE 771 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 304, column 10)
                    _errs2 =
                        ({-# LINE 304 "Transform.ag" #-}
                         let g nt (con,fm) = checkForDuplicates (DupChild nt con) (map fst fm)
                             f (nt,cfm)    = concat . map (g nt) . Map.toList $ cfm
                         in  Seq.fromList . concat . map f . Map.toList $ _allFields
                         {-# LINE 779 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 308, column 10)
                    _errs3 =
                        ({-# LINE 308 "Transform.ag" #-}
                         let f (nt,cons) = checkForDuplicates (DupAlt nt) cons
                         in   Seq.empty
                         {-# LINE 786 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 312, column 10)
                    _errs4 =
                        ({-# LINE 312 "Transform.ag" #-}
                         let  f m s = Map.fold ((><) . snd) s m
                         in Map.fold f Seq.empty _allRulesErrs
                         {-# LINE 793 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 315, column 10)
                    _errs5 =
                        ({-# LINE 315 "Transform.ag" #-}
                         let  f m s = Map.fold ((><) . snd) s m
                         in Map.fold f Seq.empty _allSigsErrs
                         {-# LINE 800 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 318, column 10)
                    _errs6 =
                        ({-# LINE 318 "Transform.ag" #-}
                         let  f m s = Map.fold ((><) . snd) s m
                         in Map.fold f Seq.empty _allInstsErrs
                         {-# LINE 807 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 321, column 10)
                    _errs7 =
                        ({-# LINE 321 "Transform.ag" #-}
                         let  f m s = Map.fold ((><) . snd) s m
                         in Map.fold f Seq.empty _allUniquesErrs
                         {-# LINE 814 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 324, column 10)
                    _errs8 =
                        ({-# LINE 324 "Transform.ag" #-}
                         let  f m s = Map.fold ((><) . snd) s m
                         in Map.fold f Seq.empty _allAugmentErrs
                         {-# LINE 821 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 327, column 10)
                    _errs9 =
                        ({-# LINE 327 "Transform.ag" #-}
                         let  f m s = Map.fold ((><) . snd) s m
                         in Map.fold f Seq.empty _allAroundsErrs
                         {-# LINE 828 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 330, column 10)
                    _errs10 =
                        ({-# LINE 330 "Transform.ag" #-}
                         let  f m s = Map.fold ((><)) s m
                         in Map.fold f Seq.empty _allNamesErrs
                         {-# LINE 835 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 333, column 10)
                    _errs11 =
                        ({-# LINE 333 "Transform.ag" #-}
                         let f m s = Map.fold ((><) . snd) s m
                         in Map.fold f Seq.empty _allMergesErrs
                         {-# LINE 842 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 336, column 10)
                    _lhsOerrors =
                        ({-# LINE 336 "Transform.ag" #-}
                         _elemsIerrors >< _errs1 >< _errs2 >< _errs3 >< _errs4 >< _errs5 >< _errs6 >< _errs7 >< _errs8 >< _errs9 >< _errs10 >< _errs11
                         {-# LINE 848 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 560, column 10)
                    _allNonterminals =
                        ({-# LINE 560 "Transform.ag" #-}
                         _elemsIcollectedNames `Set.difference` _elemsIcollectedSetNames
                         {-# LINE 854 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 580, column 8)
                    _elemsOallConstructors =
                        ({-# LINE 580 "Transform.ag" #-}
                         _elemsIcollectedConstructorsMap
                         {-# LINE 860 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 653, column 8)
                    _elemsOdefSets =
                        ({-# LINE 653 "Transform.ag" #-}
                         Map.fromList (map (\x->(x,(Set.singleton x, Set.empty))) (Set.toList _allNonterminals    ))
                         {-# LINE 866 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 654, column 8)
                    _elemsOdefinedSets =
                        ({-# LINE 654 "Transform.ag" #-}
                         Map.map fst _elemsIdefSets
                         {-# LINE 872 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 919, column 8)
                    _elemsOattrDecls =
                        ({-# LINE 919 "Transform.ag" #-}
                         Map.empty
                         {-# LINE 878 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 972, column 9)
                    _allAttrDecls =
                        ({-# LINE 972 "Transform.ag" #-}
                         if withSelf _lhsIoptions
                          then foldr addSelf _elemsIattrDecls (Set.toList _allNonterminals    )
                          else               _elemsIattrDecls
                         {-# LINE 886 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 45, column 19)
                    _lhsOblocks =
                        ({-# LINE 45 "Transform.ag" #-}
                         _elemsIblocks
                         {-# LINE 892 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1096, column 37)
                    _lhsOmoduleDecl =
                        ({-# LINE 1096 "Transform.ag" #-}
                         _elemsImoduleDecl
                         {-# LINE 898 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 746, column 34)
                    _lhsOpragmas =
                        ({-# LINE 746 "Transform.ag" #-}
                         _elemsIpragmas
                         {-# LINE 904 "Transform.hs" #-}
                         )
                    -- copy rule (from local)
                    _elemsOallAttrDecls =
                        ({-# LINE 821 "Transform.ag" #-}
                         _allAttrDecls
                         {-# LINE 910 "Transform.hs" #-}
                         )
                    -- copy rule (from local)
                    _elemsOallFields =
                        ({-# LINE 128 "Transform.ag" #-}
                         _allFields
                         {-# LINE 916 "Transform.hs" #-}
                         )
                    -- copy rule (from local)
                    _elemsOallNonterminals =
                        ({-# LINE 88 "Transform.ag" #-}
                         _allNonterminals
                         {-# LINE 922 "Transform.hs" #-}
                         )
                    -- copy rule (down)
                    _elemsOoptions =
                        ({-# LINE 39 "Transform.ag" #-}
                         _lhsIoptions
                         {-# LINE 928 "Transform.hs" #-}
                         )
                    ( _elemsIattrDecls,_elemsIattrOrderCollect,_elemsIblocks,_elemsIcollectedArounds,_elemsIcollectedAugments,_elemsIcollectedConstructorsMap,_elemsIcollectedFields,_elemsIcollectedInsts,_elemsIcollectedMerges,_elemsIcollectedNames,_elemsIcollectedRules,_elemsIcollectedSetNames,_elemsIcollectedSigs,_elemsIcollectedUniques,_elemsIctxCollect,_elemsIdefSets,_elemsIderivings,_elemsIerrors,_elemsImoduleDecl,_elemsIparamsCollect,_elemsIpragmas,_elemsIsemPragmasCollect,_elemsItypeSyns,_elemsIuseMap,_elemsIwrappers) =
                        elems_ _elemsOallAttrDecls _elemsOallConstructors _elemsOallFields _elemsOallNonterminals _elemsOattrDecls _elemsOdefSets _elemsOdefinedSets _elemsOoptions 
                in  ( _lhsOblocks,_lhsOerrors,_lhsOmoduleDecl,_lhsOoutput,_lhsOpragmas))) )
-- Alt ---------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allConstructors      : Map NontermIdent (Set ConstructorIdent)
         allNonterminals      : Set NontermIdent
         nts                  : Set NontermIdent
      synthesized attributes:
         collectedConstructorNames : Set ConstructorIdent
         collectedFields      : [(NontermIdent, ConstructorIdent, FieldMap)]
   alternatives:
      alternative Alt:
         child pos            : {Pos}
         child names          : ConstructorSet 
         child fields         : {Fields}
-}
-- cata
sem_Alt :: Alt  ->
           T_Alt 
sem_Alt (Alt _pos _names _fields )  =
    (sem_Alt_Alt _pos (sem_ConstructorSet _names ) _fields )
-- semantic domain
newtype T_Alt  = T_Alt ((Map NontermIdent (Set ConstructorIdent)) ->
                        (Set NontermIdent) ->
                        (Set NontermIdent) ->
                        ( (Set ConstructorIdent),([(NontermIdent, ConstructorIdent, FieldMap)])))
data Inh_Alt  = Inh_Alt {allConstructors_Inh_Alt :: !((Map NontermIdent (Set ConstructorIdent))),allNonterminals_Inh_Alt :: !((Set NontermIdent)),nts_Inh_Alt :: !((Set NontermIdent))}
data Syn_Alt  = Syn_Alt {collectedConstructorNames_Syn_Alt :: !((Set ConstructorIdent)),collectedFields_Syn_Alt :: !(([(NontermIdent, ConstructorIdent, FieldMap)]))}
wrap_Alt :: T_Alt  ->
            Inh_Alt  ->
            Syn_Alt 
wrap_Alt (T_Alt sem ) (Inh_Alt _lhsIallConstructors _lhsIallNonterminals _lhsInts )  =
    (let ( _lhsOcollectedConstructorNames,_lhsOcollectedFields) = sem _lhsIallConstructors _lhsIallNonterminals _lhsInts 
     in  (Syn_Alt _lhsOcollectedConstructorNames _lhsOcollectedFields ))
sem_Alt_Alt :: Pos ->
               T_ConstructorSet  ->
               Fields ->
               T_Alt 
sem_Alt_Alt pos_ (T_ConstructorSet names_ ) fields_  =
    (T_Alt (\ _lhsIallConstructors
              _lhsIallNonterminals
              _lhsInts ->
                (let _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                     _lhsOcollectedConstructorNames :: (Set ConstructorIdent)
                     _namesIcollectedConstructorNames :: (Set ConstructorIdent)
                     _namesIconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                     _namesIerrors :: (Seq Error)
                     -- "Transform.ag"(line 238, column 10)
                     _lhsOcollectedFields =
                         ({-# LINE 238 "Transform.ag" #-}
                          let fieldTable =
                               [ (attr, makeType _lhsIallNonterminals tp)
                               | (attr, tp) <- fields_
                               ]
                          in   [ (nt, con, fieldTable)
                               | nt  <- Set.toList _lhsInts
                               , con <- Set.toList (_namesIconstructors (Map.findWithDefault Set.empty nt _lhsIallConstructors))
                               ]
                          {-# LINE 991 "Transform.hs" #-}
                          )
                     -- use rule "Transform.ag"(line 93, column 62)
                     _lhsOcollectedConstructorNames =
                         ({-# LINE 93 "Transform.ag" #-}
                          _namesIcollectedConstructorNames
                          {-# LINE 997 "Transform.hs" #-}
                          )
                     ( _namesIcollectedConstructorNames,_namesIconstructors,_namesIerrors) =
                         names_ 
                 in  ( _lhsOcollectedConstructorNames,_lhsOcollectedFields))) )
-- Alts --------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allConstructors      : Map NontermIdent (Set ConstructorIdent)
         allNonterminals      : Set NontermIdent
         nts                  : Set NontermIdent
      synthesized attributes:
         collectedConstructorNames : Set ConstructorIdent
         collectedFields      : [(NontermIdent, ConstructorIdent, FieldMap)]
   alternatives:
      alternative Cons:
         child hd             : Alt 
         child tl             : Alts 
      alternative Nil:
-}
-- cata
sem_Alts :: Alts  ->
            T_Alts 
sem_Alts list  =
    (Prelude.foldr sem_Alts_Cons sem_Alts_Nil (Prelude.map sem_Alt list) )
-- semantic domain
newtype T_Alts  = T_Alts ((Map NontermIdent (Set ConstructorIdent)) ->
                          (Set NontermIdent) ->
                          (Set NontermIdent) ->
                          ( (Set ConstructorIdent),([(NontermIdent, ConstructorIdent, FieldMap)])))
data Inh_Alts  = Inh_Alts {allConstructors_Inh_Alts :: !((Map NontermIdent (Set ConstructorIdent))),allNonterminals_Inh_Alts :: !((Set NontermIdent)),nts_Inh_Alts :: !((Set NontermIdent))}
data Syn_Alts  = Syn_Alts {collectedConstructorNames_Syn_Alts :: !((Set ConstructorIdent)),collectedFields_Syn_Alts :: !(([(NontermIdent, ConstructorIdent, FieldMap)]))}
wrap_Alts :: T_Alts  ->
             Inh_Alts  ->
             Syn_Alts 
wrap_Alts (T_Alts sem ) (Inh_Alts _lhsIallConstructors _lhsIallNonterminals _lhsInts )  =
    (let ( _lhsOcollectedConstructorNames,_lhsOcollectedFields) = sem _lhsIallConstructors _lhsIallNonterminals _lhsInts 
     in  (Syn_Alts _lhsOcollectedConstructorNames _lhsOcollectedFields ))
sem_Alts_Cons :: T_Alt  ->
                 T_Alts  ->
                 T_Alts 
sem_Alts_Cons (T_Alt hd_ ) (T_Alts tl_ )  =
    (T_Alts (\ _lhsIallConstructors
               _lhsIallNonterminals
               _lhsInts ->
                 (let _lhsOcollectedConstructorNames :: (Set ConstructorIdent)
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _hdOallConstructors :: (Map NontermIdent (Set ConstructorIdent))
                      _hdOallNonterminals :: (Set NontermIdent)
                      _hdOnts :: (Set NontermIdent)
                      _tlOallConstructors :: (Map NontermIdent (Set ConstructorIdent))
                      _tlOallNonterminals :: (Set NontermIdent)
                      _tlOnts :: (Set NontermIdent)
                      _hdIcollectedConstructorNames :: (Set ConstructorIdent)
                      _hdIcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _tlIcollectedConstructorNames :: (Set ConstructorIdent)
                      _tlIcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      -- use rule "Transform.ag"(line 93, column 62)
                      _lhsOcollectedConstructorNames =
                          ({-# LINE 93 "Transform.ag" #-}
                           _hdIcollectedConstructorNames `Set.union` _tlIcollectedConstructorNames
                           {-# LINE 1059 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           _hdIcollectedFields ++ _tlIcollectedFields
                           {-# LINE 1065 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _hdOallConstructors =
                          ({-# LINE 96 "Transform.ag" #-}
                           _lhsIallConstructors
                           {-# LINE 1071 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _hdOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 1077 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _hdOnts =
                          ({-# LINE 167 "Transform.ag" #-}
                           _lhsInts
                           {-# LINE 1083 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _tlOallConstructors =
                          ({-# LINE 96 "Transform.ag" #-}
                           _lhsIallConstructors
                           {-# LINE 1089 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _tlOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 1095 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _tlOnts =
                          ({-# LINE 167 "Transform.ag" #-}
                           _lhsInts
                           {-# LINE 1101 "Transform.hs" #-}
                           )
                      ( _hdIcollectedConstructorNames,_hdIcollectedFields) =
                          hd_ _hdOallConstructors _hdOallNonterminals _hdOnts 
                      ( _tlIcollectedConstructorNames,_tlIcollectedFields) =
                          tl_ _tlOallConstructors _tlOallNonterminals _tlOnts 
                  in  ( _lhsOcollectedConstructorNames,_lhsOcollectedFields))) )
sem_Alts_Nil :: T_Alts 
sem_Alts_Nil  =
    (T_Alts (\ _lhsIallConstructors
               _lhsIallNonterminals
               _lhsInts ->
                 (let _lhsOcollectedConstructorNames :: (Set ConstructorIdent)
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      -- use rule "Transform.ag"(line 93, column 62)
                      _lhsOcollectedConstructorNames =
                          ({-# LINE 93 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 1119 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 1125 "Transform.hs" #-}
                           )
                  in  ( _lhsOcollectedConstructorNames,_lhsOcollectedFields))) )
-- Attrs -------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allFields            : DataTypes
         allNonterminals      : Set NontermIdent
         nts                  : Set NontermIdent
         options              : Options
      chained attribute:
         attrDecls            : Map NontermIdent (Attributes, Attributes)
      synthesized attributes:
         errors               : Seq Error
         useMap               : Map NontermIdent (Map Identifier (String,String,String))
   alternatives:
      alternative Attrs:
         child pos            : {Pos}
         child inh            : {AttrNames}
         child chn            : {AttrNames}
         child syn            : {AttrNames}
         visit 0:
            local _tup1       : _
            local attrDecls   : _
            local errors      : _
            local _tup2       : _
            local inherited   : _
            local synthesized : _
            local useMap      : _
            local errors1     : _
-}
-- cata
sem_Attrs :: Attrs  ->
             T_Attrs 
sem_Attrs (Attrs _pos _inh _chn _syn )  =
    (sem_Attrs_Attrs _pos _inh _chn _syn )
-- semantic domain
newtype T_Attrs  = T_Attrs (DataTypes ->
                            (Set NontermIdent) ->
                            (Map NontermIdent (Attributes, Attributes)) ->
                            (Set NontermIdent) ->
                            Options ->
                            ( (Map NontermIdent (Attributes, Attributes)),(Seq Error),(Map NontermIdent (Map Identifier (String,String,String)))))
data Inh_Attrs  = Inh_Attrs {allFields_Inh_Attrs :: !(DataTypes),allNonterminals_Inh_Attrs :: !((Set NontermIdent)),attrDecls_Inh_Attrs :: !((Map NontermIdent (Attributes, Attributes))),nts_Inh_Attrs :: !((Set NontermIdent)),options_Inh_Attrs :: !(Options)}
data Syn_Attrs  = Syn_Attrs {attrDecls_Syn_Attrs :: !((Map NontermIdent (Attributes, Attributes))),errors_Syn_Attrs :: !((Seq Error)),useMap_Syn_Attrs :: !((Map NontermIdent (Map Identifier (String,String,String))))}
wrap_Attrs :: T_Attrs  ->
              Inh_Attrs  ->
              Syn_Attrs 
wrap_Attrs (T_Attrs sem ) (Inh_Attrs _lhsIallFields _lhsIallNonterminals _lhsIattrDecls _lhsInts _lhsIoptions )  =
    (let ( _lhsOattrDecls,_lhsOerrors,_lhsOuseMap) = sem _lhsIallFields _lhsIallNonterminals _lhsIattrDecls _lhsInts _lhsIoptions 
     in  (Syn_Attrs _lhsOattrDecls _lhsOerrors _lhsOuseMap ))
sem_Attrs_Attrs :: Pos ->
                   AttrNames ->
                   AttrNames ->
                   AttrNames ->
                   T_Attrs 
sem_Attrs_Attrs pos_ inh_ chn_ syn_  =
    (T_Attrs (\ _lhsIallFields
                _lhsIallNonterminals
                _lhsIattrDecls
                _lhsInts
                _lhsIoptions ->
                  (let _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                       _lhsOerrors :: (Seq Error)
                       _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                       -- "Transform.ag"(line 927, column 15)
                       __tup1 =
                           ({-# LINE 927 "Transform.ag" #-}
                            checkAttrs _lhsIallFields (Set.toList _lhsInts) _inherited _synthesized _lhsIattrDecls
                            {-# LINE 1195 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 927, column 15)
                       (_attrDecls,_) =
                           ({-# LINE 927 "Transform.ag" #-}
                            __tup1
                            {-# LINE 1201 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 927, column 15)
                       (_,_errors) =
                           ({-# LINE 927 "Transform.ag" #-}
                            __tup1
                            {-# LINE 1207 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 929, column 15)
                       __tup2 =
                           ({-# LINE 929 "Transform.ag" #-}
                            let splitAttrs xs = unzip [ ((n,makeType _lhsIallNonterminals t),(n,ud))
                                                      | (n,t,ud) <- xs
                                                      ]
                                (inh,_)     = splitAttrs inh_
                                (chn,uses1) = splitAttrs chn_
                                (syn,uses2) = splitAttrs syn_
                                isUse (n,(e1,e2,_)) = not (null e1 || null e2)
                            in (inh++chn,chn++syn, Map.fromList (Prelude.filter isUse (uses1++uses2)))
                            {-# LINE 1220 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 929, column 15)
                       (_inherited,_,_) =
                           ({-# LINE 929 "Transform.ag" #-}
                            __tup2
                            {-# LINE 1226 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 929, column 15)
                       (_,_synthesized,_) =
                           ({-# LINE 929 "Transform.ag" #-}
                            __tup2
                            {-# LINE 1232 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 929, column 15)
                       (_,_,_useMap) =
                           ({-# LINE 929 "Transform.ag" #-}
                            __tup2
                            {-# LINE 1238 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 937, column 11)
                       _lhsOuseMap =
                           ({-# LINE 937 "Transform.ag" #-}
                            Map.fromList (zip (Set.toList _lhsInts) (repeat _useMap))
                            {-# LINE 1244 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 939, column 11)
                       _errors1 =
                           ({-# LINE 939 "Transform.ag" #-}
                            if checkParseTy _lhsIoptions
                            then let attrs  = inh_ ++ syn_ ++ chn_
                                     items = map (\(ident,tp,_) -> (getPos ident, tp)) attrs
                                     errs  = map check items
                                     check (pos,Haskell s) =
                                       let exp = Expression pos tks
                                           tks = [tk]
                                           tk  = HsToken s pos
                                       in Seq.fromList $ checkTy exp
                                     check _ = Seq.empty
                                 in foldr (Seq.><) Seq.empty errs
                            else Seq.empty
                            {-# LINE 1261 "Transform.hs" #-}
                            )
                       -- "Transform.ag"(line 951, column 11)
                       _lhsOerrors =
                           ({-# LINE 951 "Transform.ag" #-}
                            _errors     Seq.>< _errors1
                            {-# LINE 1267 "Transform.hs" #-}
                            )
                       -- copy rule (from local)
                       _lhsOattrDecls =
                           ({-# LINE 136 "Transform.ag" #-}
                            _attrDecls
                            {-# LINE 1273 "Transform.hs" #-}
                            )
                   in  ( _lhsOattrDecls,_lhsOerrors,_lhsOuseMap))) )
-- ConstructorSet ----------------------------------------------
{-
   visit 0:
      synthesized attributes:
         collectedConstructorNames : Set ConstructorIdent
         constructors         : (Set ConstructorIdent->Set ConstructorIdent)
         errors               : Seq Error
   alternatives:
      alternative CAll:
      alternative CDifference:
         child set1           : ConstructorSet 
         child set2           : ConstructorSet 
      alternative CName:
         child name           : {ConstructorIdent}
      alternative CUnion:
         child set1           : ConstructorSet 
         child set2           : ConstructorSet 
-}
-- cata
sem_ConstructorSet :: ConstructorSet  ->
                      T_ConstructorSet 
sem_ConstructorSet (CAll )  =
    (sem_ConstructorSet_CAll )
sem_ConstructorSet (CDifference _set1 _set2 )  =
    (sem_ConstructorSet_CDifference (sem_ConstructorSet _set1 ) (sem_ConstructorSet _set2 ) )
sem_ConstructorSet (CName _name )  =
    (sem_ConstructorSet_CName _name )
sem_ConstructorSet (CUnion _set1 _set2 )  =
    (sem_ConstructorSet_CUnion (sem_ConstructorSet _set1 ) (sem_ConstructorSet _set2 ) )
-- semantic domain
newtype T_ConstructorSet  = T_ConstructorSet (( (Set ConstructorIdent),((Set ConstructorIdent->Set ConstructorIdent)),(Seq Error)))
data Inh_ConstructorSet  = Inh_ConstructorSet {}
data Syn_ConstructorSet  = Syn_ConstructorSet {collectedConstructorNames_Syn_ConstructorSet :: !((Set ConstructorIdent)),constructors_Syn_ConstructorSet :: !(((Set ConstructorIdent->Set ConstructorIdent))),errors_Syn_ConstructorSet :: !((Seq Error))}
wrap_ConstructorSet :: T_ConstructorSet  ->
                       Inh_ConstructorSet  ->
                       Syn_ConstructorSet 
wrap_ConstructorSet (T_ConstructorSet sem ) (Inh_ConstructorSet )  =
    (let ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors) = sem 
     in  (Syn_ConstructorSet _lhsOcollectedConstructorNames _lhsOconstructors _lhsOerrors ))
sem_ConstructorSet_CAll :: T_ConstructorSet 
sem_ConstructorSet_CAll  =
    (T_ConstructorSet (let _lhsOconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _lhsOcollectedConstructorNames :: (Set ConstructorIdent)
                           _lhsOerrors :: (Seq Error)
                           -- "Transform.ag"(line 724, column 17)
                           _lhsOconstructors =
                               ({-# LINE 724 "Transform.ag" #-}
                                \ds -> ds
                                {-# LINE 1324 "Transform.hs" #-}
                                )
                           -- use rule "Transform.ag"(line 93, column 62)
                           _lhsOcollectedConstructorNames =
                               ({-# LINE 93 "Transform.ag" #-}
                                Set.empty
                                {-# LINE 1330 "Transform.hs" #-}
                                )
                           -- use rule "Transform.ag"(line 43, column 19)
                           _lhsOerrors =
                               ({-# LINE 43 "Transform.ag" #-}
                                Seq.empty
                                {-# LINE 1336 "Transform.hs" #-}
                                )
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)) )
sem_ConstructorSet_CDifference :: T_ConstructorSet  ->
                                  T_ConstructorSet  ->
                                  T_ConstructorSet 
sem_ConstructorSet_CDifference (T_ConstructorSet set1_ ) (T_ConstructorSet set2_ )  =
    (T_ConstructorSet (let _lhsOconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _lhsOcollectedConstructorNames :: (Set ConstructorIdent)
                           _lhsOerrors :: (Seq Error)
                           _set1IcollectedConstructorNames :: (Set ConstructorIdent)
                           _set1Iconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _set1Ierrors :: (Seq Error)
                           _set2IcollectedConstructorNames :: (Set ConstructorIdent)
                           _set2Iconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _set2Ierrors :: (Seq Error)
                           -- "Transform.ag"(line 723, column 17)
                           _lhsOconstructors =
                               ({-# LINE 723 "Transform.ag" #-}
                                \ds -> _set1Iconstructors ds `Set.difference` _set2Iconstructors ds
                                {-# LINE 1356 "Transform.hs" #-}
                                )
                           -- use rule "Transform.ag"(line 93, column 62)
                           _lhsOcollectedConstructorNames =
                               ({-# LINE 93 "Transform.ag" #-}
                                _set1IcollectedConstructorNames `Set.union` _set2IcollectedConstructorNames
                                {-# LINE 1362 "Transform.hs" #-}
                                )
                           -- use rule "Transform.ag"(line 43, column 19)
                           _lhsOerrors =
                               ({-# LINE 43 "Transform.ag" #-}
                                _set1Ierrors Seq.>< _set2Ierrors
                                {-# LINE 1368 "Transform.hs" #-}
                                )
                           ( _set1IcollectedConstructorNames,_set1Iconstructors,_set1Ierrors) =
                               set1_ 
                           ( _set2IcollectedConstructorNames,_set2Iconstructors,_set2Ierrors) =
                               set2_ 
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)) )
sem_ConstructorSet_CName :: ConstructorIdent ->
                            T_ConstructorSet 
sem_ConstructorSet_CName name_  =
    (T_ConstructorSet (let _lhsOcollectedConstructorNames :: (Set ConstructorIdent)
                           _lhsOconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _lhsOerrors :: (Seq Error)
                           -- "Transform.ag"(line 568, column 11)
                           _lhsOcollectedConstructorNames =
                               ({-# LINE 568 "Transform.ag" #-}
                                Set.singleton name_
                                {-# LINE 1385 "Transform.hs" #-}
                                )
                           -- "Transform.ag"(line 721, column 17)
                           _lhsOconstructors =
                               ({-# LINE 721 "Transform.ag" #-}
                                \ds -> Set.singleton name_
                                {-# LINE 1391 "Transform.hs" #-}
                                )
                           -- use rule "Transform.ag"(line 43, column 19)
                           _lhsOerrors =
                               ({-# LINE 43 "Transform.ag" #-}
                                Seq.empty
                                {-# LINE 1397 "Transform.hs" #-}
                                )
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)) )
sem_ConstructorSet_CUnion :: T_ConstructorSet  ->
                             T_ConstructorSet  ->
                             T_ConstructorSet 
sem_ConstructorSet_CUnion (T_ConstructorSet set1_ ) (T_ConstructorSet set2_ )  =
    (T_ConstructorSet (let _lhsOconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _lhsOcollectedConstructorNames :: (Set ConstructorIdent)
                           _lhsOerrors :: (Seq Error)
                           _set1IcollectedConstructorNames :: (Set ConstructorIdent)
                           _set1Iconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _set1Ierrors :: (Seq Error)
                           _set2IcollectedConstructorNames :: (Set ConstructorIdent)
                           _set2Iconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                           _set2Ierrors :: (Seq Error)
                           -- "Transform.ag"(line 722, column 17)
                           _lhsOconstructors =
                               ({-# LINE 722 "Transform.ag" #-}
                                \ds -> _set1Iconstructors ds `Set.union`      _set2Iconstructors ds
                                {-# LINE 1417 "Transform.hs" #-}
                                )
                           -- use rule "Transform.ag"(line 93, column 62)
                           _lhsOcollectedConstructorNames =
                               ({-# LINE 93 "Transform.ag" #-}
                                _set1IcollectedConstructorNames `Set.union` _set2IcollectedConstructorNames
                                {-# LINE 1423 "Transform.hs" #-}
                                )
                           -- use rule "Transform.ag"(line 43, column 19)
                           _lhsOerrors =
                               ({-# LINE 43 "Transform.ag" #-}
                                _set1Ierrors Seq.>< _set2Ierrors
                                {-# LINE 1429 "Transform.hs" #-}
                                )
                           ( _set1IcollectedConstructorNames,_set1Iconstructors,_set1Ierrors) =
                               set1_ 
                           ( _set2IcollectedConstructorNames,_set2Iconstructors,_set2Ierrors) =
                               set2_ 
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)) )
-- Elem --------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allAttrDecls         : Map NontermIdent (Attributes, Attributes)
         allConstructors      : Map NontermIdent (Set ConstructorIdent)
         allFields            : DataTypes
         allNonterminals      : Set NontermIdent
         definedSets          : DefinedSets
         options              : Options
      chained attributes:
         attrDecls            : Map NontermIdent (Attributes, Attributes)
         defSets              : Map Identifier (Set NontermIdent,Set Identifier)
      synthesized attributes:
         attrOrderCollect     : AttrOrderMap
         blocks               : Blocks
         collectedArounds     : [ (NontermIdent, ConstructorIdent, [AroundInfo])  ]
         collectedAugments    : [ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]
         collectedConstructorsMap : Map NontermIdent (Set ConstructorIdent)
         collectedFields      : [(NontermIdent, ConstructorIdent, FieldMap)]
         collectedInsts       : [ (NontermIdent, ConstructorIdent, [Identifier]) ]
         collectedMerges      : [ (NontermIdent, ConstructorIdent, [MergeInfo])   ]
         collectedNames       : Set Identifier
         collectedRules       : [ (NontermIdent, ConstructorIdent, RuleInfo)]
         collectedSetNames    : Set Identifier
         collectedSigs        : [ (NontermIdent, ConstructorIdent, SigInfo) ]
         collectedUniques     : [ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]
         ctxCollect           : ContextMap
         derivings            : Derivings
         errors               : Seq Error
         moduleDecl           : Maybe (String,String,String)
         paramsCollect        : ParamMap
         pragmas              : Options -> Options
         semPragmasCollect    : PragmaMap
         typeSyns             : TypeSyns
         useMap               : Map NontermIdent (Map Identifier (String,String,String))
         wrappers             : Set NontermIdent
   alternatives:
      alternative Attr:
         child pos            : {Pos}
         child ctx            : {ClassContext}
         child names          : NontSet 
         child attrs          : Attrs 
      alternative Data:
         child pos            : {Pos}
         child ctx            : {ClassContext}
         child names          : NontSet 
         child params         : {[Identifier]}
         child attrs          : Attrs 
         child alts           : Alts 
         child ext            : {Bool}
      alternative Deriving:
         child pos            : {Pos}
         child set            : NontSet 
         child classes        : {[NontermIdent]}
      alternative Module:
         child pos            : {Pos}
         child name           : {String}
         child exports        : {String}
         child imports        : {String}
      alternative Nocatas:
         child pos            : {Pos}
         child set            : NontSet 
      alternative Pragma:
         child pos            : {Pos}
         child names          : {[NontermIdent]}
      alternative Sem:
         child pos            : {Pos}
         child ctx            : {ClassContext}
         child names          : NontSet 
         child attrs          : Attrs 
         child alts           : SemAlts 
      alternative Set:
         child pos            : {Pos}
         child name           : {NontermIdent}
         child merge          : {Bool}
         child set            : NontSet 
         visit 0:
            local _tup3       : _
            local defSets2    : _
            local errs        : _
      alternative Txt:
         child pos            : {Pos}
         child name           : {Identifier}
         child mbNt           : {Maybe NontermIdent}
         child lines          : {[String]}
         visit 0:
            local blockInfo   : _
            local blockValue  : _
      alternative Type:
         child pos            : {Pos}
         child ctx            : {ClassContext}
         child name           : {NontermIdent}
         child params         : {[Identifier]}
         child type           : {ComplexType}
         visit 0:
            local expanded    : _
            local argType     : _
      alternative Wrapper:
         child pos            : {Pos}
         child set            : NontSet 
-}
-- cata
sem_Elem :: Elem  ->
            T_Elem 
sem_Elem (Attr _pos _ctx _names _attrs )  =
    (sem_Elem_Attr _pos _ctx (sem_NontSet _names ) (sem_Attrs _attrs ) )
sem_Elem (Data _pos _ctx _names _params _attrs _alts _ext )  =
    (sem_Elem_Data _pos _ctx (sem_NontSet _names ) _params (sem_Attrs _attrs ) (sem_Alts _alts ) _ext )
sem_Elem (Deriving _pos _set _classes )  =
    (sem_Elem_Deriving _pos (sem_NontSet _set ) _classes )
sem_Elem (Module _pos _name _exports _imports )  =
    (sem_Elem_Module _pos _name _exports _imports )
sem_Elem (Nocatas _pos _set )  =
    (sem_Elem_Nocatas _pos (sem_NontSet _set ) )
sem_Elem (Pragma _pos _names )  =
    (sem_Elem_Pragma _pos _names )
sem_Elem (Sem _pos _ctx _names _attrs _alts )  =
    (sem_Elem_Sem _pos _ctx (sem_NontSet _names ) (sem_Attrs _attrs ) (sem_SemAlts _alts ) )
sem_Elem (Set _pos _name _merge _set )  =
    (sem_Elem_Set _pos _name _merge (sem_NontSet _set ) )
sem_Elem (Txt _pos _name _mbNt _lines )  =
    (sem_Elem_Txt _pos _name _mbNt _lines )
sem_Elem (Type _pos _ctx _name _params _type )  =
    (sem_Elem_Type _pos _ctx _name _params _type )
sem_Elem (Wrapper _pos _set )  =
    (sem_Elem_Wrapper _pos (sem_NontSet _set ) )
-- semantic domain
newtype T_Elem  = T_Elem ((Map NontermIdent (Attributes, Attributes)) ->
                          (Map NontermIdent (Set ConstructorIdent)) ->
                          DataTypes ->
                          (Set NontermIdent) ->
                          (Map NontermIdent (Attributes, Attributes)) ->
                          (Map Identifier (Set NontermIdent,Set Identifier)) ->
                          DefinedSets ->
                          Options ->
                          ( (Map NontermIdent (Attributes, Attributes)),AttrOrderMap,Blocks,([ (NontermIdent, ConstructorIdent, [AroundInfo])  ]),([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]),(Map NontermIdent (Set ConstructorIdent)),([(NontermIdent, ConstructorIdent, FieldMap)]),([ (NontermIdent, ConstructorIdent, [Identifier]) ]),([ (NontermIdent, ConstructorIdent, [MergeInfo])   ]),(Set Identifier),([ (NontermIdent, ConstructorIdent, RuleInfo)]),(Set Identifier),([ (NontermIdent, ConstructorIdent, SigInfo) ]),([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]),ContextMap,(Map Identifier (Set NontermIdent,Set Identifier)),Derivings,(Seq Error),(Maybe (String,String,String)),ParamMap,(Options -> Options),PragmaMap,TypeSyns,(Map NontermIdent (Map Identifier (String,String,String))),(Set NontermIdent)))
data Inh_Elem  = Inh_Elem {allAttrDecls_Inh_Elem :: !((Map NontermIdent (Attributes, Attributes))),allConstructors_Inh_Elem :: !((Map NontermIdent (Set ConstructorIdent))),allFields_Inh_Elem :: !(DataTypes),allNonterminals_Inh_Elem :: !((Set NontermIdent)),attrDecls_Inh_Elem :: !((Map NontermIdent (Attributes, Attributes))),defSets_Inh_Elem :: !((Map Identifier (Set NontermIdent,Set Identifier))),definedSets_Inh_Elem :: !(DefinedSets),options_Inh_Elem :: !(Options)}
data Syn_Elem  = Syn_Elem {attrDecls_Syn_Elem :: !((Map NontermIdent (Attributes, Attributes))),attrOrderCollect_Syn_Elem :: !(AttrOrderMap),blocks_Syn_Elem :: !(Blocks),collectedArounds_Syn_Elem :: !(([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])),collectedAugments_Syn_Elem :: !(([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])),collectedConstructorsMap_Syn_Elem :: !((Map NontermIdent (Set ConstructorIdent))),collectedFields_Syn_Elem :: !(([(NontermIdent, ConstructorIdent, FieldMap)])),collectedInsts_Syn_Elem :: !(([ (NontermIdent, ConstructorIdent, [Identifier]) ])),collectedMerges_Syn_Elem :: !(([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])),collectedNames_Syn_Elem :: !((Set Identifier)),collectedRules_Syn_Elem :: !(([ (NontermIdent, ConstructorIdent, RuleInfo)])),collectedSetNames_Syn_Elem :: !((Set Identifier)),collectedSigs_Syn_Elem :: !(([ (NontermIdent, ConstructorIdent, SigInfo) ])),collectedUniques_Syn_Elem :: !(([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])),ctxCollect_Syn_Elem :: !(ContextMap),defSets_Syn_Elem :: !((Map Identifier (Set NontermIdent,Set Identifier))),derivings_Syn_Elem :: !(Derivings),errors_Syn_Elem :: !((Seq Error)),moduleDecl_Syn_Elem :: !((Maybe (String,String,String))),paramsCollect_Syn_Elem :: !(ParamMap),pragmas_Syn_Elem :: !((Options -> Options)),semPragmasCollect_Syn_Elem :: !(PragmaMap),typeSyns_Syn_Elem :: !(TypeSyns),useMap_Syn_Elem :: !((Map NontermIdent (Map Identifier (String,String,String)))),wrappers_Syn_Elem :: !((Set NontermIdent))}
wrap_Elem :: T_Elem  ->
             Inh_Elem  ->
             Syn_Elem 
wrap_Elem (T_Elem sem ) (Inh_Elem _lhsIallAttrDecls _lhsIallConstructors _lhsIallFields _lhsIallNonterminals _lhsIattrDecls _lhsIdefSets _lhsIdefinedSets _lhsIoptions )  =
    (let ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers) = sem _lhsIallAttrDecls _lhsIallConstructors _lhsIallFields _lhsIallNonterminals _lhsIattrDecls _lhsIdefSets _lhsIdefinedSets _lhsIoptions 
     in  (Syn_Elem _lhsOattrDecls _lhsOattrOrderCollect _lhsOblocks _lhsOcollectedArounds _lhsOcollectedAugments _lhsOcollectedConstructorsMap _lhsOcollectedFields _lhsOcollectedInsts _lhsOcollectedMerges _lhsOcollectedNames _lhsOcollectedRules _lhsOcollectedSetNames _lhsOcollectedSigs _lhsOcollectedUniques _lhsOctxCollect _lhsOdefSets _lhsOderivings _lhsOerrors _lhsOmoduleDecl _lhsOparamsCollect _lhsOpragmas _lhsOsemPragmasCollect _lhsOtypeSyns _lhsOuseMap _lhsOwrappers ))
sem_Elem_Attr :: Pos ->
                 ClassContext ->
                 T_NontSet  ->
                 T_Attrs  ->
                 T_Elem 
sem_Elem_Attr pos_ ctx_ (T_NontSet names_ ) (T_Attrs attrs_ )  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOctxCollect :: ContextMap
                      _attrsOnts :: (Set NontermIdent)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      _namesOallFields :: DataTypes
                      _namesOallNonterminals :: (Set NontermIdent)
                      _namesOdefinedSets :: DefinedSets
                      _attrsOallFields :: DataTypes
                      _attrsOallNonterminals :: (Set NontermIdent)
                      _attrsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _attrsOoptions :: Options
                      _namesIcollectedNames :: (Set Identifier)
                      _namesIerrors :: (Seq Error)
                      _namesInontSet :: (Set NontermIdent)
                      _attrsIattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _attrsIerrors :: (Seq Error)
                      _attrsIuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      -- "Transform.ag"(line 879, column 7)
                      _lhsOctxCollect =
                          ({-# LINE 879 "Transform.ag" #-}
                           if null ctx_
                           then Map.empty
                           else Map.fromList [(nt, ctx_) | nt <- Set.toList _namesInontSet]
                           {-# LINE 1640 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 923, column 10)
                      _attrsOnts =
                          ({-# LINE 923 "Transform.ag" #-}
                           _namesInontSet
                           {-# LINE 1646 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1652 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1658 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 1664 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 1670 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1676 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 1682 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 1688 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 1694 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           _namesIcollectedNames
                           {-# LINE 1700 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 1706 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 1712 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 1718 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 1724 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1730 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           _namesIerrors Seq.>< _attrsIerrors
                           {-# LINE 1736 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 1742 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1748 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 1754 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1760 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 1766 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           _attrsIuseMap
                           {-# LINE 1772 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 1778 "Transform.hs" #-}
                           )
                      -- copy rule (up)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _attrsIattrDecls
                           {-# LINE 1784 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 1790 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 1796 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 1802 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOdefinedSets =
                          ({-# LINE 107 "Transform.ag" #-}
                           _lhsIdefinedSets
                           {-# LINE 1808 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 1814 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 1820 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 1826 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOoptions =
                          ({-# LINE 39 "Transform.ag" #-}
                           _lhsIoptions
                           {-# LINE 1832 "Transform.hs" #-}
                           )
                      ( _namesIcollectedNames,_namesIerrors,_namesInontSet) =
                          names_ _namesOallFields _namesOallNonterminals _namesOdefinedSets 
                      ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                          attrs_ _attrsOallFields _attrsOallNonterminals _attrsOattrDecls _attrsOnts _attrsOoptions 
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Data :: Pos ->
                 ClassContext ->
                 T_NontSet  ->
                 ([Identifier]) ->
                 T_Attrs  ->
                 T_Alts  ->
                 Bool ->
                 T_Elem 
sem_Elem_Data pos_ ctx_ (T_NontSet names_ ) params_ (T_Attrs attrs_ ) (T_Alts alts_ ) ext_  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _altsOnts :: (Set NontermIdent)
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOctxCollect :: ContextMap
                      _attrsOnts :: (Set NontermIdent)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      _namesOallFields :: DataTypes
                      _namesOallNonterminals :: (Set NontermIdent)
                      _namesOdefinedSets :: DefinedSets
                      _attrsOallFields :: DataTypes
                      _attrsOallNonterminals :: (Set NontermIdent)
                      _attrsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _attrsOoptions :: Options
                      _altsOallConstructors :: (Map NontermIdent (Set ConstructorIdent))
                      _altsOallNonterminals :: (Set NontermIdent)
                      _namesIcollectedNames :: (Set Identifier)
                      _namesIerrors :: (Seq Error)
                      _namesInontSet :: (Set NontermIdent)
                      _attrsIattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _attrsIerrors :: (Seq Error)
                      _attrsIuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _altsIcollectedConstructorNames :: (Set ConstructorIdent)
                      _altsIcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      -- "Transform.ag"(line 170, column 10)
                      _altsOnts =
                          ({-# LINE 170 "Transform.ag" #-}
                           _namesInontSet
                           {-# LINE 1904 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 574, column 11)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 574 "Transform.ag" #-}
                           Map.fromList
                           [ (n, _altsIcollectedConstructorNames)
                           | n <- Set.toList _namesInontSet
                           ]
                           {-# LINE 1913 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 856, column 7)
                      _lhsOparamsCollect =
                          ({-# LINE 856 "Transform.ag" #-}
                           if null params_
                           then Map.empty
                           else Map.fromList [(nt, params_) | nt <- Set.toList _namesInontSet]
                           {-# LINE 1921 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 879, column 7)
                      _lhsOctxCollect =
                          ({-# LINE 879 "Transform.ag" #-}
                           if null ctx_
                           then Map.empty
                           else Map.fromList [(nt, ctx_) | nt <- Set.toList _namesInontSet]
                           {-# LINE 1929 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 922, column 10)
                      _attrsOnts =
                          ({-# LINE 922 "Transform.ag" #-}
                           _namesInontSet
                           {-# LINE 1935 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1941 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 1947 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 1953 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 1959 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           _altsIcollectedFields
                           {-# LINE 1965 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 1971 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 1977 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           _namesIcollectedNames
                           {-# LINE 1983 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 1989 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 1995 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 2001 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 2007 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2013 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           _namesIerrors Seq.>< _attrsIerrors
                           {-# LINE 2019 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 2025 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 2031 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2037 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 2043 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           _attrsIuseMap
                           {-# LINE 2049 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2055 "Transform.hs" #-}
                           )
                      -- copy rule (up)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _attrsIattrDecls
                           {-# LINE 2061 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 2067 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 2073 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 2079 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOdefinedSets =
                          ({-# LINE 107 "Transform.ag" #-}
                           _lhsIdefinedSets
                           {-# LINE 2085 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 2091 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 2097 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 2103 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOoptions =
                          ({-# LINE 39 "Transform.ag" #-}
                           _lhsIoptions
                           {-# LINE 2109 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _altsOallConstructors =
                          ({-# LINE 96 "Transform.ag" #-}
                           _lhsIallConstructors
                           {-# LINE 2115 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _altsOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 2121 "Transform.hs" #-}
                           )
                      ( _namesIcollectedNames,_namesIerrors,_namesInontSet) =
                          names_ _namesOallFields _namesOallNonterminals _namesOdefinedSets 
                      ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                          attrs_ _attrsOallFields _attrsOallNonterminals _attrsOattrDecls _attrsOnts _attrsOoptions 
                      ( _altsIcollectedConstructorNames,_altsIcollectedFields) =
                          alts_ _altsOallConstructors _altsOallNonterminals _altsOnts 
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Deriving :: Pos ->
                     T_NontSet  ->
                     ([NontermIdent]) ->
                     T_Elem 
sem_Elem_Deriving pos_ (T_NontSet set_ ) classes_  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOderivings :: Derivings
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOctxCollect :: ContextMap
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      _setOallFields :: DataTypes
                      _setOallNonterminals :: (Set NontermIdent)
                      _setOdefinedSets :: DefinedSets
                      _setIcollectedNames :: (Set Identifier)
                      _setIerrors :: (Seq Error)
                      _setInontSet :: (Set NontermIdent)
                      -- "Transform.ag"(line 907, column 14)
                      _lhsOderivings =
                          ({-# LINE 907 "Transform.ag" #-}
                           Map.fromList [(nt,Set.fromList classes_) | nt <- Set.toList _setInontSet]
                           {-# LINE 2178 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2184 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2190 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 2196 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 2202 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2208 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 2214 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 2220 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 2226 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           _setIcollectedNames
                           {-# LINE 2232 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 2238 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2244 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 2250 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 2256 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 875, column 34)
                      _lhsOctxCollect =
                          ({-# LINE 875 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2262 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           _setIerrors
                           {-# LINE 2268 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 2274 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2280 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 2286 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2292 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 2298 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2304 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2310 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 2316 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 2322 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 2328 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 2334 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOdefinedSets =
                          ({-# LINE 107 "Transform.ag" #-}
                           _lhsIdefinedSets
                           {-# LINE 2340 "Transform.hs" #-}
                           )
                      ( _setIcollectedNames,_setIerrors,_setInontSet) =
                          set_ _setOallFields _setOallNonterminals _setOdefinedSets 
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Module :: Pos ->
                   String ->
                   String ->
                   String ->
                   T_Elem 
sem_Elem_Module pos_ name_ exports_ imports_  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOctxCollect :: ContextMap
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOparamsCollect :: ParamMap
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      -- "Transform.ag"(line 1100, column 7)
                      _lhsOmoduleDecl =
                          ({-# LINE 1100 "Transform.ag" #-}
                           Just (name_, exports_, imports_)
                           {-# LINE 2388 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2394 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2400 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 2406 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 2412 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2418 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 2424 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 2430 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 2436 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2442 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 2448 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2454 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 2460 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 2466 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 875, column 34)
                      _lhsOctxCollect =
                          ({-# LINE 875 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2472 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2478 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           Seq.empty
                           {-# LINE 2484 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2490 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 2496 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2502 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 2508 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2514 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2520 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 2526 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 2532 "Transform.hs" #-}
                           )
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Nocatas :: Pos ->
                    T_NontSet  ->
                    T_Elem 
sem_Elem_Nocatas pos_ (T_NontSet set_ )  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOpragmas :: (Options -> Options)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOctxCollect :: ContextMap
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      _setOallFields :: DataTypes
                      _setOallNonterminals :: (Set NontermIdent)
                      _setOdefinedSets :: DefinedSets
                      _setIcollectedNames :: (Set Identifier)
                      _setIerrors :: (Seq Error)
                      _setInontSet :: (Set NontermIdent)
                      -- "Transform.ag"(line 740, column 14)
                      _lhsOpragmas =
                          ({-# LINE 740 "Transform.ag" #-}
                           \o -> o { nocatas = _setInontSet `Set.union` nocatas o }
                           {-# LINE 2582 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2588 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2594 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 2600 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 2606 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2612 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 2618 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 2624 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 2630 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           _setIcollectedNames
                           {-# LINE 2636 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 2642 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2648 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 2654 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 2660 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 875, column 34)
                      _lhsOctxCollect =
                          ({-# LINE 875 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2666 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2672 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           _setIerrors
                           {-# LINE 2678 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 2684 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2690 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2696 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 2702 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2708 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2714 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 2720 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 2726 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 2732 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 2738 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOdefinedSets =
                          ({-# LINE 107 "Transform.ag" #-}
                           _lhsIdefinedSets
                           {-# LINE 2744 "Transform.hs" #-}
                           )
                      ( _setIcollectedNames,_setIerrors,_setInontSet) =
                          set_ _setOallFields _setOallNonterminals _setOdefinedSets 
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Pragma :: Pos ->
                   ([NontermIdent]) ->
                   T_Elem 
sem_Elem_Pragma pos_ names_  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOpragmas :: (Options -> Options)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOctxCollect :: ContextMap
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      -- "Transform.ag"(line 749, column 13)
                      _lhsOpragmas =
                          ({-# LINE 749 "Transform.ag" #-}
                           let mk n o = case getName n of
                                          "gencatas"     -> o { folds       = True  }
                                          "nogencatas"   -> o { folds       = False }
                                          "gendatas"     -> o { dataTypes   = True  }
                                          "nogendatas"   -> o { dataTypes   = False }
                                          "gensems"      -> o { semfuns     = True  }
                                          "nogensems"    -> o { semfuns     = False }
                                          "gentypesigs"  -> o { typeSigs    = True  }
                                          "nogentypesigs"-> o { typeSigs    = False }
                                          "nocycle"      -> o { withCycle   = False }
                                          "cycle"        -> o { withCycle   = True  }
                                          "nostrictdata" -> o { strictData  = False }
                                          "strictdata"   -> o { strictData  = True  }
                                          "nostrictcase" -> o { strictCases = False }
                                          "strictcase"   -> o { strictCases = True  }
                                          "strictercase" -> o { strictCases = True, stricterCases = True }
                                          "nostrictwrap" -> o { strictWrap  = False }
                                          "strictwrap"   -> o { strictWrap  = True  }
                                          "novisit"      -> o { visit       = False }
                                          "visit"        -> o { visit       = True  }
                                          "nocase"       -> o { cases       = False }
                                          "case"         -> o { cases       = True  }
                                          "noseq"        -> o { withSeq     = False }
                                          "seq"          -> o { withSeq     = True  }
                                          "nounbox"      -> o { unbox       = False }
                                          "unbox"        -> o { unbox       = True  }
                                          "bangpats"     -> o { bangpats    = True  }
                                          "breadthfirst" -> o { breadthFirst = True }
                                          "breadthfirstStrict" -> o { breadthFirstStrict = True }
                                          "nooptimize"   -> o { cases = False , visit = False }
                                          "optimize"     -> o { cases = True  , visit = True  }
                                          "strictsem"    -> o { strictSems = True }
                                          "gentraces"    -> o { genTraces = True }
                                          "genusetraces" -> o { genUseTraces = True }
                                          "splitsems"    -> o { splitSems = True }
                                          "gencostcentres" -> o { genCostCentres = True }
                                          "sepsemmods"   -> o { sepSemMods = True }
                                          "genlinepragmas" -> o { genLinePragmas = True }
                                          "newtypes"       -> o { newtypes = True }
                                          "nonewtypes"     -> o { newtypes = False }
                                          _              -> o
                           in \o -> foldr mk o names_
                           {-# LINE 2831 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2837 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2843 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 2849 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 2855 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2861 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 2867 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 2873 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 2879 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2885 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 2891 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2897 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 2903 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 2909 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 875, column 34)
                      _lhsOctxCollect =
                          ({-# LINE 875 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2915 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2921 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           Seq.empty
                           {-# LINE 2927 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 2933 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2939 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2945 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 2951 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 2957 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 2963 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 2969 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 2975 "Transform.hs" #-}
                           )
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Sem :: Pos ->
                ClassContext ->
                T_NontSet  ->
                T_Attrs  ->
                T_SemAlts  ->
                T_Elem 
sem_Elem_Sem pos_ ctx_ (T_NontSet names_ ) (T_Attrs attrs_ ) (T_SemAlts alts_ )  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _altsOnts :: (Set NontermIdent)
                      _lhsOctxCollect :: ContextMap
                      _attrsOnts :: (Set NontermIdent)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      _namesOallFields :: DataTypes
                      _namesOallNonterminals :: (Set NontermIdent)
                      _namesOdefinedSets :: DefinedSets
                      _attrsOallFields :: DataTypes
                      _attrsOallNonterminals :: (Set NontermIdent)
                      _attrsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _attrsOoptions :: Options
                      _altsOallAttrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _altsOallFields :: DataTypes
                      _altsOoptions :: Options
                      _namesIcollectedNames :: (Set Identifier)
                      _namesIerrors :: (Seq Error)
                      _namesInontSet :: (Set NontermIdent)
                      _attrsIattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _attrsIerrors :: (Seq Error)
                      _attrsIuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _altsIattrOrderCollect :: AttrOrderMap
                      _altsIcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _altsIcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _altsIcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _altsIcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _altsIcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _altsIcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _altsIcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _altsIerrors :: (Seq Error)
                      _altsIsemPragmasCollect :: PragmaMap
                      -- "Transform.ag"(line 171, column 10)
                      _altsOnts =
                          ({-# LINE 171 "Transform.ag" #-}
                           _namesInontSet
                           {-# LINE 3050 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 879, column 7)
                      _lhsOctxCollect =
                          ({-# LINE 879 "Transform.ag" #-}
                           if null ctx_
                           then Map.empty
                           else Map.fromList [(nt, ctx_) | nt <- Set.toList _namesInontSet]
                           {-# LINE 3058 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 924, column 10)
                      _attrsOnts =
                          ({-# LINE 924 "Transform.ag" #-}
                           _namesInontSet
                           {-# LINE 3064 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           _altsIattrOrderCollect
                           {-# LINE 3070 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3076 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           _altsIcollectedArounds
                           {-# LINE 3082 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           _altsIcollectedAugments
                           {-# LINE 3088 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3094 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 3100 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           _altsIcollectedInsts
                           {-# LINE 3106 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           _altsIcollectedMerges
                           {-# LINE 3112 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           _namesIcollectedNames
                           {-# LINE 3118 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           _altsIcollectedRules
                           {-# LINE 3124 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3130 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           _altsIcollectedSigs
                           {-# LINE 3136 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           _altsIcollectedUniques
                           {-# LINE 3142 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3148 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           _namesIerrors Seq.>< _attrsIerrors Seq.>< _altsIerrors
                           {-# LINE 3154 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 3160 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3166 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 3172 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           _altsIsemPragmasCollect
                           {-# LINE 3178 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 3184 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           _attrsIuseMap
                           {-# LINE 3190 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3196 "Transform.hs" #-}
                           )
                      -- copy rule (up)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _attrsIattrDecls
                           {-# LINE 3202 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 3208 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 3214 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 3220 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _namesOdefinedSets =
                          ({-# LINE 107 "Transform.ag" #-}
                           _lhsIdefinedSets
                           {-# LINE 3226 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 3232 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 3238 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 3244 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _attrsOoptions =
                          ({-# LINE 39 "Transform.ag" #-}
                           _lhsIoptions
                           {-# LINE 3250 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _altsOallAttrDecls =
                          ({-# LINE 821 "Transform.ag" #-}
                           _lhsIallAttrDecls
                           {-# LINE 3256 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _altsOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 3262 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _altsOoptions =
                          ({-# LINE 39 "Transform.ag" #-}
                           _lhsIoptions
                           {-# LINE 3268 "Transform.hs" #-}
                           )
                      ( _namesIcollectedNames,_namesIerrors,_namesInontSet) =
                          names_ _namesOallFields _namesOallNonterminals _namesOdefinedSets 
                      ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                          attrs_ _attrsOallFields _attrsOallNonterminals _attrsOattrDecls _attrsOnts _attrsOoptions 
                      ( _altsIattrOrderCollect,_altsIcollectedArounds,_altsIcollectedAugments,_altsIcollectedInsts,_altsIcollectedMerges,_altsIcollectedRules,_altsIcollectedSigs,_altsIcollectedUniques,_altsIerrors,_altsIsemPragmasCollect) =
                          alts_ _altsOallAttrDecls _altsOallFields _altsOnts _altsOoptions 
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Set :: Pos ->
                NontermIdent ->
                Bool ->
                T_NontSet  ->
                T_Elem 
sem_Elem_Set pos_ name_ merge_ (T_NontSet set_ )  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      _lhsOerrors :: (Seq Error)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOctxCollect :: ContextMap
                      _lhsOderivings :: Derivings
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _setOallFields :: DataTypes
                      _setOallNonterminals :: (Set NontermIdent)
                      _setOdefinedSets :: DefinedSets
                      _setIcollectedNames :: (Set Identifier)
                      _setIerrors :: (Seq Error)
                      _setInontSet :: (Set NontermIdent)
                      -- "Transform.ag"(line 551, column 10)
                      _lhsOcollectedSetNames =
                          ({-# LINE 551 "Transform.ag" #-}
                           Set.singleton name_
                           {-# LINE 3326 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 658, column 13)
                      __tup3 =
                          ({-# LINE 658 "Transform.ag" #-}
                           let allUsedNames = Set.unions [ maybe (Set.singleton n)
                                                                 snd
                                                                 (Map.lookup n _lhsIdefSets)
                                                         | n <- Set.toList _setIcollectedNames
                                                         ]
                               (nontSet,e1) | Set.member name_ allUsedNames
                                                        = (Set.empty, Seq.singleton(CyclicSet name_))
                                            | otherwise = (_setInontSet, Seq.empty)
                               (res, e2) = let toAdd = (nontSet,Set.insert name_ allUsedNames)
                                               union (a,b) (c,d) = (a `Set.union` c, b `Set.union` d)
                                           in if Set.member name_ _lhsIallNonterminals || not merge_
                                              then checkDuplicate DupSet name_ toAdd _lhsIdefSets
                                              else (Map.insertWith union name_ toAdd _lhsIdefSets, Seq.empty)
                           in (res, e1 Seq.>< e2)
                           {-# LINE 3345 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 658, column 13)
                      (_defSets2,_) =
                          ({-# LINE 658 "Transform.ag" #-}
                           __tup3
                           {-# LINE 3351 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 658, column 13)
                      (_,_errs) =
                          ({-# LINE 658 "Transform.ag" #-}
                           __tup3
                           {-# LINE 3357 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 672, column 9)
                      _lhsOdefSets =
                          ({-# LINE 672 "Transform.ag" #-}
                           _defSets2
                           {-# LINE 3363 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 672, column 9)
                      _lhsOerrors =
                          ({-# LINE 673 "Transform.ag" #-}
                           _errs >< _setIerrors
                           {-# LINE 3369 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3375 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3381 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 3387 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 3393 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3399 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 3405 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 3411 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 3417 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           _setIcollectedNames
                           {-# LINE 3423 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 3429 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 3435 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 3441 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 875, column 34)
                      _lhsOctxCollect =
                          ({-# LINE 875 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3447 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3453 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 3459 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3465 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 3471 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3477 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 3483 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3489 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3495 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 3501 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 3507 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 3513 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOdefinedSets =
                          ({-# LINE 107 "Transform.ag" #-}
                           _lhsIdefinedSets
                           {-# LINE 3519 "Transform.hs" #-}
                           )
                      ( _setIcollectedNames,_setIerrors,_setInontSet) =
                          set_ _setOallFields _setOallNonterminals _setOdefinedSets 
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Txt :: Pos ->
                Identifier ->
                (Maybe NontermIdent) ->
                ([String]) ->
                T_Elem 
sem_Elem_Txt pos_ name_ mbNt_ lines_  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOblocks :: Blocks
                      _lhsOerrors :: (Seq Error)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOctxCollect :: ContextMap
                      _lhsOderivings :: Derivings
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      -- "Transform.ag"(line 180, column 10)
                      _blockInfo =
                          ({-# LINE 180 "Transform.ag" #-}
                           ( let nm = getName name_
                             in if nm == "imports"
                                then BlockImport
                                else if nm == "optpragmas"
                                     then BlockPragma
                                     else BlockOther
                           , mbNt_
                           )
                           {-# LINE 3574 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 188, column 10)
                      _blockValue =
                          ({-# LINE 188 "Transform.ag" #-}
                           [(lines_, pos_)]
                           {-# LINE 3580 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 189, column 10)
                      _lhsOblocks =
                          ({-# LINE 189 "Transform.ag" #-}
                           Map.singleton _blockInfo     _blockValue
                           {-# LINE 3586 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 190, column 10)
                      _lhsOerrors =
                          ({-# LINE 190 "Transform.ag" #-}
                           if checkParseBlock _lhsIoptions
                           then let exp = Expression pos_ tks
                                    tks = [tk]
                                    tk  = HsToken (unlines lines_) pos_
                                in Seq.fromList $ checkBlock $ exp
                           else Seq.empty
                           {-# LINE 3597 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3603 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 3609 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 3615 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3621 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 3627 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 3633 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 3639 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3645 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 3651 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3657 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 3663 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 3669 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 875, column 34)
                      _lhsOctxCollect =
                          ({-# LINE 875 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3675 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3681 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 3687 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3693 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 3699 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3705 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 3711 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3717 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3723 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 3729 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 3735 "Transform.hs" #-}
                           )
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Type :: Pos ->
                 ClassContext ->
                 NontermIdent ->
                 ([Identifier]) ->
                 ComplexType ->
                 T_Elem 
sem_Elem_Type pos_ ctx_ name_ params_ type_  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOparamsCollect :: ParamMap
                      _lhsOctxCollect :: ContextMap
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      -- "Transform.ag"(line 248, column 10)
                      _lhsOcollectedFields =
                          ({-# LINE 248 "Transform.ag" #-}
                           map (\(x,y)->(name_, x, y)) _expanded
                           {-# LINE 3782 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 554, column 11)
                      _lhsOcollectedNames =
                          ({-# LINE 554 "Transform.ag" #-}
                           Set.singleton name_
                           {-# LINE 3788 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 608, column 11)
                      _expanded =
                          ({-# LINE 608 "Transform.ag" #-}
                           case _argType of
                                   List tp -> [(Ident "Cons" pos_, [(Ident "hd" pos_, tp)
                                                                   ,(Ident "tl" pos_, NT name_ (map getName params_))
                                                                   ]
                                               )
                                              ,(Ident "Nil" pos_,  [])
                                              ]
                                   Maybe tp -> [(Ident "Just" pos_, [(Ident "just" pos_, tp)
                                                                   ]
                                               )
                                              ,(Ident "Nothing" pos_,  [])
                                              ]
                                   Either tp1 tp2 -> [
                                                (Ident "Left"    pos_,  [(Ident "left"  pos_, tp1) ])
                                              , (Ident "Right"   pos_,  [(Ident "right" pos_, tp2) ])
                                              ]
                                   Map tp1 tp2 -> [ (Ident "Entry" pos_, [ (Ident "key" pos_, tp1)
                                                                         , (Ident "val" pos_, tp2)
                                                                         , (Ident "tl" pos_, NT name_ (map getName params_))
                                                                         ])
                                                  , (Ident "Nil" pos_, [])
                                                  ]
                                   IntMap tp   -> [ (Ident "Entry" pos_, [ (Ident "key" pos_, Haskell "Int")
                                                                         , (Ident "val" pos_, tp)
                                                                         , (Ident "tl" pos_, NT name_ (map getName params_))
                                                                         ])
                                                  , (Ident "Nil" pos_, [])
                                                  ]
                                   Tuple xs -> [(Ident "Tuple" pos_, xs)]
                           {-# LINE 3822 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 637, column 11)
                      _argType =
                          ({-# LINE 637 "Transform.ag" #-}
                           case type_ of
                            Maybe tp       -> Maybe  (  makeType _lhsIallNonterminals tp)
                            Either tp1 tp2 -> Either (  makeType _lhsIallNonterminals tp1) (makeType _lhsIallNonterminals tp2)
                            List tp        -> List   (  makeType _lhsIallNonterminals tp)
                            Tuple xs       -> Tuple [(f,makeType _lhsIallNonterminals tp) | (f,tp) <- xs]
                            Map tp1 tp2    -> Map    (  makeType _lhsIallNonterminals tp1) (makeType _lhsIallNonterminals tp2)
                            IntMap tp      -> IntMap (  makeType _lhsIallNonterminals tp)
                           {-# LINE 3834 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 644, column 11)
                      _lhsOtypeSyns =
                          ({-# LINE 644 "Transform.ag" #-}
                           [(name_,_argType)]
                           {-# LINE 3840 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 862, column 7)
                      _lhsOparamsCollect =
                          ({-# LINE 862 "Transform.ag" #-}
                           if null params_
                           then Map.empty
                           else Map.singleton name_ params_
                           {-# LINE 3848 "Transform.hs" #-}
                           )
                      -- "Transform.ag"(line 885, column 7)
                      _lhsOctxCollect =
                          ({-# LINE 885 "Transform.ag" #-}
                           if null ctx_
                           then Map.empty
                           else Map.singleton name_ ctx_
                           {-# LINE 3856 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3862 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3868 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 3874 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 3880 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3886 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 3892 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 3898 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 3904 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3910 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 3916 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 3922 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3928 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           Seq.empty
                           {-# LINE 3934 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 3940 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 3946 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3952 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 3958 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 730, column 32)
                      _lhsOwrappers =
                          ({-# LINE 730 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 3964 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 3970 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 3976 "Transform.hs" #-}
                           )
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elem_Wrapper :: Pos ->
                    T_NontSet  ->
                    T_Elem 
sem_Elem_Wrapper pos_ (T_NontSet set_ )  =
    (T_Elem (\ _lhsIallAttrDecls
               _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsIoptions ->
                 (let _lhsOwrappers :: (Set NontermIdent)
                      _lhsOattrOrderCollect :: AttrOrderMap
                      _lhsOblocks :: Blocks
                      _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                      _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                      _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                      _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                      _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                      _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                      _lhsOcollectedNames :: (Set Identifier)
                      _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Identifier)
                      _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                      _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                      _lhsOctxCollect :: ContextMap
                      _lhsOderivings :: Derivings
                      _lhsOerrors :: (Seq Error)
                      _lhsOmoduleDecl :: (Maybe (String,String,String))
                      _lhsOparamsCollect :: ParamMap
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOsemPragmasCollect :: PragmaMap
                      _lhsOtypeSyns :: TypeSyns
                      _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                      _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                      _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                      _setOallFields :: DataTypes
                      _setOallNonterminals :: (Set NontermIdent)
                      _setOdefinedSets :: DefinedSets
                      _setIcollectedNames :: (Set Identifier)
                      _setIerrors :: (Seq Error)
                      _setInontSet :: (Set NontermIdent)
                      -- "Transform.ag"(line 733, column 13)
                      _lhsOwrappers =
                          ({-# LINE 733 "Transform.ag" #-}
                           _setInontSet
                           {-# LINE 4026 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 820, column 55)
                      _lhsOattrOrderCollect =
                          ({-# LINE 820 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4032 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 45, column 19)
                      _lhsOblocks =
                          ({-# LINE 45 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4038 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 156, column 32)
                      _lhsOcollectedArounds =
                          ({-# LINE 156 "Transform.ag" #-}
                           []
                           {-# LINE 4044 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 155, column 32)
                      _lhsOcollectedAugments =
                          ({-# LINE 155 "Transform.ag" #-}
                           []
                           {-# LINE 4050 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 94, column 48)
                      _lhsOcollectedConstructorsMap =
                          ({-# LINE 94 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4056 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 125, column 28)
                      _lhsOcollectedFields =
                          ({-# LINE 125 "Transform.ag" #-}
                           []
                           {-# LINE 4062 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 153, column 32)
                      _lhsOcollectedInsts =
                          ({-# LINE 153 "Transform.ag" #-}
                           []
                           {-# LINE 4068 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 157, column 32)
                      _lhsOcollectedMerges =
                          ({-# LINE 157 "Transform.ag" #-}
                           []
                           {-# LINE 4074 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 86, column 50)
                      _lhsOcollectedNames =
                          ({-# LINE 86 "Transform.ag" #-}
                           _setIcollectedNames
                           {-# LINE 4080 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 151, column 32)
                      _lhsOcollectedRules =
                          ({-# LINE 151 "Transform.ag" #-}
                           []
                           {-# LINE 4086 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 85, column 50)
                      _lhsOcollectedSetNames =
                          ({-# LINE 85 "Transform.ag" #-}
                           Set.empty
                           {-# LINE 4092 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 152, column 32)
                      _lhsOcollectedSigs =
                          ({-# LINE 152 "Transform.ag" #-}
                           []
                           {-# LINE 4098 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 154, column 32)
                      _lhsOcollectedUniques =
                          ({-# LINE 154 "Transform.ag" #-}
                           []
                           {-# LINE 4104 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 875, column 34)
                      _lhsOctxCollect =
                          ({-# LINE 875 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4110 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 900, column 33)
                      _lhsOderivings =
                          ({-# LINE 900 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4116 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 43, column 19)
                      _lhsOerrors =
                          ({-# LINE 43 "Transform.ag" #-}
                           _setIerrors
                           {-# LINE 4122 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 1096, column 37)
                      _lhsOmoduleDecl =
                          ({-# LINE 1096 "Transform.ag" #-}
                           mzero
                           {-# LINE 4128 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 852, column 37)
                      _lhsOparamsCollect =
                          ({-# LINE 852 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4134 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 746, column 34)
                      _lhsOpragmas =
                          ({-# LINE 746 "Transform.ag" #-}
                           id
                           {-# LINE 4140 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 792, column 56)
                      _lhsOsemPragmasCollect =
                          ({-# LINE 792 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4146 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 595, column 32)
                      _lhsOtypeSyns =
                          ({-# LINE 595 "Transform.ag" #-}
                           []
                           {-# LINE 4152 "Transform.hs" #-}
                           )
                      -- use rule "Transform.ag"(line 137, column 15)
                      _lhsOuseMap =
                          ({-# LINE 137 "Transform.ag" #-}
                           Map.empty
                           {-# LINE 4158 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOattrDecls =
                          ({-# LINE 136 "Transform.ag" #-}
                           _lhsIattrDecls
                           {-# LINE 4164 "Transform.hs" #-}
                           )
                      -- copy rule (chain)
                      _lhsOdefSets =
                          ({-# LINE 104 "Transform.ag" #-}
                           _lhsIdefSets
                           {-# LINE 4170 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallFields =
                          ({-# LINE 128 "Transform.ag" #-}
                           _lhsIallFields
                           {-# LINE 4176 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOallNonterminals =
                          ({-# LINE 88 "Transform.ag" #-}
                           _lhsIallNonterminals
                           {-# LINE 4182 "Transform.hs" #-}
                           )
                      -- copy rule (down)
                      _setOdefinedSets =
                          ({-# LINE 107 "Transform.ag" #-}
                           _lhsIdefinedSets
                           {-# LINE 4188 "Transform.hs" #-}
                           )
                      ( _setIcollectedNames,_setIerrors,_setInontSet) =
                          set_ _setOallFields _setOallNonterminals _setOdefinedSets 
                  in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
-- Elems -------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allAttrDecls         : Map NontermIdent (Attributes, Attributes)
         allConstructors      : Map NontermIdent (Set ConstructorIdent)
         allFields            : DataTypes
         allNonterminals      : Set NontermIdent
         definedSets          : DefinedSets
         options              : Options
      chained attributes:
         attrDecls            : Map NontermIdent (Attributes, Attributes)
         defSets              : Map Identifier (Set NontermIdent,Set Identifier)
      synthesized attributes:
         attrOrderCollect     : AttrOrderMap
         blocks               : Blocks
         collectedArounds     : [ (NontermIdent, ConstructorIdent, [AroundInfo])  ]
         collectedAugments    : [ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]
         collectedConstructorsMap : Map NontermIdent (Set ConstructorIdent)
         collectedFields      : [(NontermIdent, ConstructorIdent, FieldMap)]
         collectedInsts       : [ (NontermIdent, ConstructorIdent, [Identifier]) ]
         collectedMerges      : [ (NontermIdent, ConstructorIdent, [MergeInfo])   ]
         collectedNames       : Set Identifier
         collectedRules       : [ (NontermIdent, ConstructorIdent, RuleInfo)]
         collectedSetNames    : Set Identifier
         collectedSigs        : [ (NontermIdent, ConstructorIdent, SigInfo) ]
         collectedUniques     : [ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]
         ctxCollect           : ContextMap
         derivings            : Derivings
         errors               : Seq Error
         moduleDecl           : Maybe (String,String,String)
         paramsCollect        : ParamMap
         pragmas              : Options -> Options
         semPragmasCollect    : PragmaMap
         typeSyns             : TypeSyns
         useMap               : Map NontermIdent (Map Identifier (String,String,String))
         wrappers             : Set NontermIdent
   alternatives:
      alternative Cons:
         child hd             : Elem 
         child tl             : Elems 
      alternative Nil:
-}
-- cata
sem_Elems :: Elems  ->
             T_Elems 
sem_Elems list  =
    (Prelude.foldr sem_Elems_Cons sem_Elems_Nil (Prelude.map sem_Elem list) )
-- semantic domain
newtype T_Elems  = T_Elems ((Map NontermIdent (Attributes, Attributes)) ->
                            (Map NontermIdent (Set ConstructorIdent)) ->
                            DataTypes ->
                            (Set NontermIdent) ->
                            (Map NontermIdent (Attributes, Attributes)) ->
                            (Map Identifier (Set NontermIdent,Set Identifier)) ->
                            DefinedSets ->
                            Options ->
                            ( (Map NontermIdent (Attributes, Attributes)),AttrOrderMap,Blocks,([ (NontermIdent, ConstructorIdent, [AroundInfo])  ]),([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]),(Map NontermIdent (Set ConstructorIdent)),([(NontermIdent, ConstructorIdent, FieldMap)]),([ (NontermIdent, ConstructorIdent, [Identifier]) ]),([ (NontermIdent, ConstructorIdent, [MergeInfo])   ]),(Set Identifier),([ (NontermIdent, ConstructorIdent, RuleInfo)]),(Set Identifier),([ (NontermIdent, ConstructorIdent, SigInfo) ]),([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]),ContextMap,(Map Identifier (Set NontermIdent,Set Identifier)),Derivings,(Seq Error),(Maybe (String,String,String)),ParamMap,(Options -> Options),PragmaMap,TypeSyns,(Map NontermIdent (Map Identifier (String,String,String))),(Set NontermIdent)))
data Inh_Elems  = Inh_Elems {allAttrDecls_Inh_Elems :: !((Map NontermIdent (Attributes, Attributes))),allConstructors_Inh_Elems :: !((Map NontermIdent (Set ConstructorIdent))),allFields_Inh_Elems :: !(DataTypes),allNonterminals_Inh_Elems :: !((Set NontermIdent)),attrDecls_Inh_Elems :: !((Map NontermIdent (Attributes, Attributes))),defSets_Inh_Elems :: !((Map Identifier (Set NontermIdent,Set Identifier))),definedSets_Inh_Elems :: !(DefinedSets),options_Inh_Elems :: !(Options)}
data Syn_Elems  = Syn_Elems {attrDecls_Syn_Elems :: !((Map NontermIdent (Attributes, Attributes))),attrOrderCollect_Syn_Elems :: !(AttrOrderMap),blocks_Syn_Elems :: !(Blocks),collectedArounds_Syn_Elems :: !(([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])),collectedAugments_Syn_Elems :: !(([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])),collectedConstructorsMap_Syn_Elems :: !((Map NontermIdent (Set ConstructorIdent))),collectedFields_Syn_Elems :: !(([(NontermIdent, ConstructorIdent, FieldMap)])),collectedInsts_Syn_Elems :: !(([ (NontermIdent, ConstructorIdent, [Identifier]) ])),collectedMerges_Syn_Elems :: !(([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])),collectedNames_Syn_Elems :: !((Set Identifier)),collectedRules_Syn_Elems :: !(([ (NontermIdent, ConstructorIdent, RuleInfo)])),collectedSetNames_Syn_Elems :: !((Set Identifier)),collectedSigs_Syn_Elems :: !(([ (NontermIdent, ConstructorIdent, SigInfo) ])),collectedUniques_Syn_Elems :: !(([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])),ctxCollect_Syn_Elems :: !(ContextMap),defSets_Syn_Elems :: !((Map Identifier (Set NontermIdent,Set Identifier))),derivings_Syn_Elems :: !(Derivings),errors_Syn_Elems :: !((Seq Error)),moduleDecl_Syn_Elems :: !((Maybe (String,String,String))),paramsCollect_Syn_Elems :: !(ParamMap),pragmas_Syn_Elems :: !((Options -> Options)),semPragmasCollect_Syn_Elems :: !(PragmaMap),typeSyns_Syn_Elems :: !(TypeSyns),useMap_Syn_Elems :: !((Map NontermIdent (Map Identifier (String,String,String)))),wrappers_Syn_Elems :: !((Set NontermIdent))}
wrap_Elems :: T_Elems  ->
              Inh_Elems  ->
              Syn_Elems 
wrap_Elems (T_Elems sem ) (Inh_Elems _lhsIallAttrDecls _lhsIallConstructors _lhsIallFields _lhsIallNonterminals _lhsIattrDecls _lhsIdefSets _lhsIdefinedSets _lhsIoptions )  =
    (let ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers) = sem _lhsIallAttrDecls _lhsIallConstructors _lhsIallFields _lhsIallNonterminals _lhsIattrDecls _lhsIdefSets _lhsIdefinedSets _lhsIoptions 
     in  (Syn_Elems _lhsOattrDecls _lhsOattrOrderCollect _lhsOblocks _lhsOcollectedArounds _lhsOcollectedAugments _lhsOcollectedConstructorsMap _lhsOcollectedFields _lhsOcollectedInsts _lhsOcollectedMerges _lhsOcollectedNames _lhsOcollectedRules _lhsOcollectedSetNames _lhsOcollectedSigs _lhsOcollectedUniques _lhsOctxCollect _lhsOdefSets _lhsOderivings _lhsOerrors _lhsOmoduleDecl _lhsOparamsCollect _lhsOpragmas _lhsOsemPragmasCollect _lhsOtypeSyns _lhsOuseMap _lhsOwrappers ))
sem_Elems_Cons :: T_Elem  ->
                  T_Elems  ->
                  T_Elems 
sem_Elems_Cons (T_Elem hd_ ) (T_Elems tl_ )  =
    (T_Elems (\ _lhsIallAttrDecls
                _lhsIallConstructors
                _lhsIallFields
                _lhsIallNonterminals
                _lhsIattrDecls
                _lhsIdefSets
                _lhsIdefinedSets
                _lhsIoptions ->
                  (let _lhsOattrOrderCollect :: AttrOrderMap
                       _lhsOblocks :: Blocks
                       _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                       _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                       _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                       _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                       _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                       _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                       _lhsOcollectedNames :: (Set Identifier)
                       _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                       _lhsOcollectedSetNames :: (Set Identifier)
                       _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                       _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                       _lhsOctxCollect :: ContextMap
                       _lhsOderivings :: Derivings
                       _lhsOerrors :: (Seq Error)
                       _lhsOmoduleDecl :: (Maybe (String,String,String))
                       _lhsOparamsCollect :: ParamMap
                       _lhsOpragmas :: (Options -> Options)
                       _lhsOsemPragmasCollect :: PragmaMap
                       _lhsOtypeSyns :: TypeSyns
                       _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                       _lhsOwrappers :: (Set NontermIdent)
                       _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                       _hdOallAttrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _hdOallConstructors :: (Map NontermIdent (Set ConstructorIdent))
                       _hdOallFields :: DataTypes
                       _hdOallNonterminals :: (Set NontermIdent)
                       _hdOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _hdOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                       _hdOdefinedSets :: DefinedSets
                       _hdOoptions :: Options
                       _tlOallAttrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _tlOallConstructors :: (Map NontermIdent (Set ConstructorIdent))
                       _tlOallFields :: DataTypes
                       _tlOallNonterminals :: (Set NontermIdent)
                       _tlOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _tlOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                       _tlOdefinedSets :: DefinedSets
                       _tlOoptions :: Options
                       _hdIattrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _hdIattrOrderCollect :: AttrOrderMap
                       _hdIblocks :: Blocks
                       _hdIcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                       _hdIcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                       _hdIcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                       _hdIcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                       _hdIcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                       _hdIcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                       _hdIcollectedNames :: (Set Identifier)
                       _hdIcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                       _hdIcollectedSetNames :: (Set Identifier)
                       _hdIcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                       _hdIcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                       _hdIctxCollect :: ContextMap
                       _hdIdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                       _hdIderivings :: Derivings
                       _hdIerrors :: (Seq Error)
                       _hdImoduleDecl :: (Maybe (String,String,String))
                       _hdIparamsCollect :: ParamMap
                       _hdIpragmas :: (Options -> Options)
                       _hdIsemPragmasCollect :: PragmaMap
                       _hdItypeSyns :: TypeSyns
                       _hdIuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                       _hdIwrappers :: (Set NontermIdent)
                       _tlIattrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _tlIattrOrderCollect :: AttrOrderMap
                       _tlIblocks :: Blocks
                       _tlIcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                       _tlIcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                       _tlIcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                       _tlIcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                       _tlIcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                       _tlIcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                       _tlIcollectedNames :: (Set Identifier)
                       _tlIcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                       _tlIcollectedSetNames :: (Set Identifier)
                       _tlIcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                       _tlIcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                       _tlIctxCollect :: ContextMap
                       _tlIdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                       _tlIderivings :: Derivings
                       _tlIerrors :: (Seq Error)
                       _tlImoduleDecl :: (Maybe (String,String,String))
                       _tlIparamsCollect :: ParamMap
                       _tlIpragmas :: (Options -> Options)
                       _tlIsemPragmasCollect :: PragmaMap
                       _tlItypeSyns :: TypeSyns
                       _tlIuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                       _tlIwrappers :: (Set NontermIdent)
                       -- use rule "Transform.ag"(line 820, column 55)
                       _lhsOattrOrderCollect =
                           ({-# LINE 820 "Transform.ag" #-}
                            _hdIattrOrderCollect `orderMapUnion` _tlIattrOrderCollect
                            {-# LINE 4366 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 45, column 19)
                       _lhsOblocks =
                           ({-# LINE 45 "Transform.ag" #-}
                            _hdIblocks `mapUnionWithPlusPlus` _tlIblocks
                            {-# LINE 4372 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 156, column 32)
                       _lhsOcollectedArounds =
                           ({-# LINE 156 "Transform.ag" #-}
                            _hdIcollectedArounds ++ _tlIcollectedArounds
                            {-# LINE 4378 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 155, column 32)
                       _lhsOcollectedAugments =
                           ({-# LINE 155 "Transform.ag" #-}
                            _hdIcollectedAugments ++ _tlIcollectedAugments
                            {-# LINE 4384 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 94, column 48)
                       _lhsOcollectedConstructorsMap =
                           ({-# LINE 94 "Transform.ag" #-}
                            _hdIcollectedConstructorsMap `mapUnionWithSetUnion` _tlIcollectedConstructorsMap
                            {-# LINE 4390 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 125, column 28)
                       _lhsOcollectedFields =
                           ({-# LINE 125 "Transform.ag" #-}
                            _hdIcollectedFields ++ _tlIcollectedFields
                            {-# LINE 4396 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 153, column 32)
                       _lhsOcollectedInsts =
                           ({-# LINE 153 "Transform.ag" #-}
                            _hdIcollectedInsts ++ _tlIcollectedInsts
                            {-# LINE 4402 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 157, column 32)
                       _lhsOcollectedMerges =
                           ({-# LINE 157 "Transform.ag" #-}
                            _hdIcollectedMerges ++ _tlIcollectedMerges
                            {-# LINE 4408 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 86, column 50)
                       _lhsOcollectedNames =
                           ({-# LINE 86 "Transform.ag" #-}
                            _hdIcollectedNames `Set.union` _tlIcollectedNames
                            {-# LINE 4414 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 151, column 32)
                       _lhsOcollectedRules =
                           ({-# LINE 151 "Transform.ag" #-}
                            _hdIcollectedRules ++ _tlIcollectedRules
                            {-# LINE 4420 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 85, column 50)
                       _lhsOcollectedSetNames =
                           ({-# LINE 85 "Transform.ag" #-}
                            _hdIcollectedSetNames `Set.union` _tlIcollectedSetNames
                            {-# LINE 4426 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 152, column 32)
                       _lhsOcollectedSigs =
                           ({-# LINE 152 "Transform.ag" #-}
                            _hdIcollectedSigs ++ _tlIcollectedSigs
                            {-# LINE 4432 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 154, column 32)
                       _lhsOcollectedUniques =
                           ({-# LINE 154 "Transform.ag" #-}
                            _hdIcollectedUniques ++ _tlIcollectedUniques
                            {-# LINE 4438 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 875, column 34)
                       _lhsOctxCollect =
                           ({-# LINE 875 "Transform.ag" #-}
                            _hdIctxCollect `mergeCtx` _tlIctxCollect
                            {-# LINE 4444 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 900, column 33)
                       _lhsOderivings =
                           ({-# LINE 900 "Transform.ag" #-}
                            _hdIderivings `mergeDerivings` _tlIderivings
                            {-# LINE 4450 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 43, column 19)
                       _lhsOerrors =
                           ({-# LINE 43 "Transform.ag" #-}
                            _hdIerrors Seq.>< _tlIerrors
                            {-# LINE 4456 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 1096, column 37)
                       _lhsOmoduleDecl =
                           ({-# LINE 1096 "Transform.ag" #-}
                            _hdImoduleDecl `mplus` _tlImoduleDecl
                            {-# LINE 4462 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 852, column 37)
                       _lhsOparamsCollect =
                           ({-# LINE 852 "Transform.ag" #-}
                            _hdIparamsCollect `mergeParams` _tlIparamsCollect
                            {-# LINE 4468 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 746, column 34)
                       _lhsOpragmas =
                           ({-# LINE 746 "Transform.ag" #-}
                            _hdIpragmas . _tlIpragmas
                            {-# LINE 4474 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 792, column 56)
                       _lhsOsemPragmasCollect =
                           ({-# LINE 792 "Transform.ag" #-}
                            _hdIsemPragmasCollect `pragmaMapUnion` _tlIsemPragmasCollect
                            {-# LINE 4480 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 595, column 32)
                       _lhsOtypeSyns =
                           ({-# LINE 595 "Transform.ag" #-}
                            _hdItypeSyns ++ _tlItypeSyns
                            {-# LINE 4486 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 137, column 15)
                       _lhsOuseMap =
                           ({-# LINE 137 "Transform.ag" #-}
                            _hdIuseMap `merge` _tlIuseMap
                            {-# LINE 4492 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 730, column 32)
                       _lhsOwrappers =
                           ({-# LINE 730 "Transform.ag" #-}
                            _hdIwrappers `Set.union` _tlIwrappers
                            {-# LINE 4498 "Transform.hs" #-}
                            )
                       -- copy rule (up)
                       _lhsOattrDecls =
                           ({-# LINE 136 "Transform.ag" #-}
                            _tlIattrDecls
                            {-# LINE 4504 "Transform.hs" #-}
                            )
                       -- copy rule (up)
                       _lhsOdefSets =
                           ({-# LINE 104 "Transform.ag" #-}
                            _tlIdefSets
                            {-# LINE 4510 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOallAttrDecls =
                           ({-# LINE 821 "Transform.ag" #-}
                            _lhsIallAttrDecls
                            {-# LINE 4516 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOallConstructors =
                           ({-# LINE 96 "Transform.ag" #-}
                            _lhsIallConstructors
                            {-# LINE 4522 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOallFields =
                           ({-# LINE 128 "Transform.ag" #-}
                            _lhsIallFields
                            {-# LINE 4528 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOallNonterminals =
                           ({-# LINE 88 "Transform.ag" #-}
                            _lhsIallNonterminals
                            {-# LINE 4534 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOattrDecls =
                           ({-# LINE 136 "Transform.ag" #-}
                            _lhsIattrDecls
                            {-# LINE 4540 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOdefSets =
                           ({-# LINE 104 "Transform.ag" #-}
                            _lhsIdefSets
                            {-# LINE 4546 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOdefinedSets =
                           ({-# LINE 107 "Transform.ag" #-}
                            _lhsIdefinedSets
                            {-# LINE 4552 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _hdOoptions =
                           ({-# LINE 39 "Transform.ag" #-}
                            _lhsIoptions
                            {-# LINE 4558 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOallAttrDecls =
                           ({-# LINE 821 "Transform.ag" #-}
                            _lhsIallAttrDecls
                            {-# LINE 4564 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOallConstructors =
                           ({-# LINE 96 "Transform.ag" #-}
                            _lhsIallConstructors
                            {-# LINE 4570 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOallFields =
                           ({-# LINE 128 "Transform.ag" #-}
                            _lhsIallFields
                            {-# LINE 4576 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOallNonterminals =
                           ({-# LINE 88 "Transform.ag" #-}
                            _lhsIallNonterminals
                            {-# LINE 4582 "Transform.hs" #-}
                            )
                       -- copy rule (chain)
                       _tlOattrDecls =
                           ({-# LINE 136 "Transform.ag" #-}
                            _hdIattrDecls
                            {-# LINE 4588 "Transform.hs" #-}
                            )
                       -- copy rule (chain)
                       _tlOdefSets =
                           ({-# LINE 104 "Transform.ag" #-}
                            _hdIdefSets
                            {-# LINE 4594 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOdefinedSets =
                           ({-# LINE 107 "Transform.ag" #-}
                            _lhsIdefinedSets
                            {-# LINE 4600 "Transform.hs" #-}
                            )
                       -- copy rule (down)
                       _tlOoptions =
                           ({-# LINE 39 "Transform.ag" #-}
                            _lhsIoptions
                            {-# LINE 4606 "Transform.hs" #-}
                            )
                       ( _hdIattrDecls,_hdIattrOrderCollect,_hdIblocks,_hdIcollectedArounds,_hdIcollectedAugments,_hdIcollectedConstructorsMap,_hdIcollectedFields,_hdIcollectedInsts,_hdIcollectedMerges,_hdIcollectedNames,_hdIcollectedRules,_hdIcollectedSetNames,_hdIcollectedSigs,_hdIcollectedUniques,_hdIctxCollect,_hdIdefSets,_hdIderivings,_hdIerrors,_hdImoduleDecl,_hdIparamsCollect,_hdIpragmas,_hdIsemPragmasCollect,_hdItypeSyns,_hdIuseMap,_hdIwrappers) =
                           hd_ _hdOallAttrDecls _hdOallConstructors _hdOallFields _hdOallNonterminals _hdOattrDecls _hdOdefSets _hdOdefinedSets _hdOoptions 
                       ( _tlIattrDecls,_tlIattrOrderCollect,_tlIblocks,_tlIcollectedArounds,_tlIcollectedAugments,_tlIcollectedConstructorsMap,_tlIcollectedFields,_tlIcollectedInsts,_tlIcollectedMerges,_tlIcollectedNames,_tlIcollectedRules,_tlIcollectedSetNames,_tlIcollectedSigs,_tlIcollectedUniques,_tlIctxCollect,_tlIdefSets,_tlIderivings,_tlIerrors,_tlImoduleDecl,_tlIparamsCollect,_tlIpragmas,_tlIsemPragmasCollect,_tlItypeSyns,_tlIuseMap,_tlIwrappers) =
                           tl_ _tlOallAttrDecls _tlOallConstructors _tlOallFields _tlOallNonterminals _tlOattrDecls _tlOdefSets _tlOdefinedSets _tlOoptions 
                   in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
sem_Elems_Nil :: T_Elems 
sem_Elems_Nil  =
    (T_Elems (\ _lhsIallAttrDecls
                _lhsIallConstructors
                _lhsIallFields
                _lhsIallNonterminals
                _lhsIattrDecls
                _lhsIdefSets
                _lhsIdefinedSets
                _lhsIoptions ->
                  (let _lhsOattrOrderCollect :: AttrOrderMap
                       _lhsOblocks :: Blocks
                       _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                       _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                       _lhsOcollectedConstructorsMap :: (Map NontermIdent (Set ConstructorIdent))
                       _lhsOcollectedFields :: ([(NontermIdent, ConstructorIdent, FieldMap)])
                       _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                       _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                       _lhsOcollectedNames :: (Set Identifier)
                       _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                       _lhsOcollectedSetNames :: (Set Identifier)
                       _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                       _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                       _lhsOctxCollect :: ContextMap
                       _lhsOderivings :: Derivings
                       _lhsOerrors :: (Seq Error)
                       _lhsOmoduleDecl :: (Maybe (String,String,String))
                       _lhsOparamsCollect :: ParamMap
                       _lhsOpragmas :: (Options -> Options)
                       _lhsOsemPragmasCollect :: PragmaMap
                       _lhsOtypeSyns :: TypeSyns
                       _lhsOuseMap :: (Map NontermIdent (Map Identifier (String,String,String)))
                       _lhsOwrappers :: (Set NontermIdent)
                       _lhsOattrDecls :: (Map NontermIdent (Attributes, Attributes))
                       _lhsOdefSets :: (Map Identifier (Set NontermIdent,Set Identifier))
                       -- use rule "Transform.ag"(line 820, column 55)
                       _lhsOattrOrderCollect =
                           ({-# LINE 820 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4652 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 45, column 19)
                       _lhsOblocks =
                           ({-# LINE 45 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4658 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 156, column 32)
                       _lhsOcollectedArounds =
                           ({-# LINE 156 "Transform.ag" #-}
                            []
                            {-# LINE 4664 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 155, column 32)
                       _lhsOcollectedAugments =
                           ({-# LINE 155 "Transform.ag" #-}
                            []
                            {-# LINE 4670 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 94, column 48)
                       _lhsOcollectedConstructorsMap =
                           ({-# LINE 94 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4676 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 125, column 28)
                       _lhsOcollectedFields =
                           ({-# LINE 125 "Transform.ag" #-}
                            []
                            {-# LINE 4682 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 153, column 32)
                       _lhsOcollectedInsts =
                           ({-# LINE 153 "Transform.ag" #-}
                            []
                            {-# LINE 4688 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 157, column 32)
                       _lhsOcollectedMerges =
                           ({-# LINE 157 "Transform.ag" #-}
                            []
                            {-# LINE 4694 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 86, column 50)
                       _lhsOcollectedNames =
                           ({-# LINE 86 "Transform.ag" #-}
                            Set.empty
                            {-# LINE 4700 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 151, column 32)
                       _lhsOcollectedRules =
                           ({-# LINE 151 "Transform.ag" #-}
                            []
                            {-# LINE 4706 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 85, column 50)
                       _lhsOcollectedSetNames =
                           ({-# LINE 85 "Transform.ag" #-}
                            Set.empty
                            {-# LINE 4712 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 152, column 32)
                       _lhsOcollectedSigs =
                           ({-# LINE 152 "Transform.ag" #-}
                            []
                            {-# LINE 4718 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 154, column 32)
                       _lhsOcollectedUniques =
                           ({-# LINE 154 "Transform.ag" #-}
                            []
                            {-# LINE 4724 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 875, column 34)
                       _lhsOctxCollect =
                           ({-# LINE 875 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4730 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 900, column 33)
                       _lhsOderivings =
                           ({-# LINE 900 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4736 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 43, column 19)
                       _lhsOerrors =
                           ({-# LINE 43 "Transform.ag" #-}
                            Seq.empty
                            {-# LINE 4742 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 1096, column 37)
                       _lhsOmoduleDecl =
                           ({-# LINE 1096 "Transform.ag" #-}
                            mzero
                            {-# LINE 4748 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 852, column 37)
                       _lhsOparamsCollect =
                           ({-# LINE 852 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4754 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 746, column 34)
                       _lhsOpragmas =
                           ({-# LINE 746 "Transform.ag" #-}
                            id
                            {-# LINE 4760 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 792, column 56)
                       _lhsOsemPragmasCollect =
                           ({-# LINE 792 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4766 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 595, column 32)
                       _lhsOtypeSyns =
                           ({-# LINE 595 "Transform.ag" #-}
                            []
                            {-# LINE 4772 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 137, column 15)
                       _lhsOuseMap =
                           ({-# LINE 137 "Transform.ag" #-}
                            Map.empty
                            {-# LINE 4778 "Transform.hs" #-}
                            )
                       -- use rule "Transform.ag"(line 730, column 32)
                       _lhsOwrappers =
                           ({-# LINE 730 "Transform.ag" #-}
                            Set.empty
                            {-# LINE 4784 "Transform.hs" #-}
                            )
                       -- copy rule (chain)
                       _lhsOattrDecls =
                           ({-# LINE 136 "Transform.ag" #-}
                            _lhsIattrDecls
                            {-# LINE 4790 "Transform.hs" #-}
                            )
                       -- copy rule (chain)
                       _lhsOdefSets =
                           ({-# LINE 104 "Transform.ag" #-}
                            _lhsIdefSets
                            {-# LINE 4796 "Transform.hs" #-}
                            )
                   in  ( _lhsOattrDecls,_lhsOattrOrderCollect,_lhsOblocks,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOctxCollect,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOmoduleDecl,_lhsOparamsCollect,_lhsOpragmas,_lhsOsemPragmasCollect,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers))) )
-- NontSet -----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allFields            : DataTypes
         allNonterminals      : Set NontermIdent
         definedSets          : DefinedSets
      synthesized attributes:
         collectedNames       : Set Identifier
         errors               : Seq Error
         nontSet              : Set NontermIdent
   alternatives:
      alternative All:
      alternative Difference:
         child set1           : NontSet 
         child set2           : NontSet 
      alternative Intersect:
         child set1           : NontSet 
         child set2           : NontSet 
      alternative NamedSet:
         child name           : {NontermIdent}
         visit 0:
            local _tup4       : _
            local nontSet     : _
            local errors      : _
      alternative Path:
         child from           : {NontermIdent}
         child to             : {NontermIdent}
      alternative Union:
         child set1           : NontSet 
         child set2           : NontSet 
-}
-- cata
sem_NontSet :: NontSet  ->
               T_NontSet 
sem_NontSet (All )  =
    (sem_NontSet_All )
sem_NontSet (Difference _set1 _set2 )  =
    (sem_NontSet_Difference (sem_NontSet _set1 ) (sem_NontSet _set2 ) )
sem_NontSet (Intersect _set1 _set2 )  =
    (sem_NontSet_Intersect (sem_NontSet _set1 ) (sem_NontSet _set2 ) )
sem_NontSet (NamedSet _name )  =
    (sem_NontSet_NamedSet _name )
sem_NontSet (Path _from _to )  =
    (sem_NontSet_Path _from _to )
sem_NontSet (Union _set1 _set2 )  =
    (sem_NontSet_Union (sem_NontSet _set1 ) (sem_NontSet _set2 ) )
-- semantic domain
newtype T_NontSet  = T_NontSet (DataTypes ->
                                (Set NontermIdent) ->
                                DefinedSets ->
                                ( (Set Identifier),(Seq Error),(Set NontermIdent)))
data Inh_NontSet  = Inh_NontSet {allFields_Inh_NontSet :: !(DataTypes),allNonterminals_Inh_NontSet :: !((Set NontermIdent)),definedSets_Inh_NontSet :: !(DefinedSets)}
data Syn_NontSet  = Syn_NontSet {collectedNames_Syn_NontSet :: !((Set Identifier)),errors_Syn_NontSet :: !((Seq Error)),nontSet_Syn_NontSet :: !((Set NontermIdent))}
wrap_NontSet :: T_NontSet  ->
                Inh_NontSet  ->
                Syn_NontSet 
wrap_NontSet (T_NontSet sem ) (Inh_NontSet _lhsIallFields _lhsIallNonterminals _lhsIdefinedSets )  =
    (let ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet) = sem _lhsIallFields _lhsIallNonterminals _lhsIdefinedSets 
     in  (Syn_NontSet _lhsOcollectedNames _lhsOerrors _lhsOnontSet ))
sem_NontSet_All :: T_NontSet 
sem_NontSet_All  =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    (let _lhsOnontSet :: (Set NontermIdent)
                         _lhsOcollectedNames :: (Set Identifier)
                         _lhsOerrors :: (Seq Error)
                         -- "Transform.ag"(line 676, column 16)
                         _lhsOnontSet =
                             ({-# LINE 676 "Transform.ag" #-}
                              _lhsIallNonterminals
                              {-# LINE 4871 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 86, column 50)
                         _lhsOcollectedNames =
                             ({-# LINE 86 "Transform.ag" #-}
                              Set.empty
                              {-# LINE 4877 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              Seq.empty
                              {-# LINE 4883 "Transform.hs" #-}
                              )
                     in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet))) )
sem_NontSet_Difference :: T_NontSet  ->
                          T_NontSet  ->
                          T_NontSet 
sem_NontSet_Difference (T_NontSet set1_ ) (T_NontSet set2_ )  =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    (let _lhsOnontSet :: (Set NontermIdent)
                         _lhsOcollectedNames :: (Set Identifier)
                         _lhsOerrors :: (Seq Error)
                         _set1OallFields :: DataTypes
                         _set1OallNonterminals :: (Set NontermIdent)
                         _set1OdefinedSets :: DefinedSets
                         _set2OallFields :: DataTypes
                         _set2OallNonterminals :: (Set NontermIdent)
                         _set2OdefinedSets :: DefinedSets
                         _set1IcollectedNames :: (Set Identifier)
                         _set1Ierrors :: (Seq Error)
                         _set1InontSet :: (Set NontermIdent)
                         _set2IcollectedNames :: (Set Identifier)
                         _set2Ierrors :: (Seq Error)
                         _set2InontSet :: (Set NontermIdent)
                         -- "Transform.ag"(line 682, column 16)
                         _lhsOnontSet =
                             ({-# LINE 682 "Transform.ag" #-}
                              Set.difference    _set1InontSet _set2InontSet
                              {-# LINE 4912 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 86, column 50)
                         _lhsOcollectedNames =
                             ({-# LINE 86 "Transform.ag" #-}
                              _set1IcollectedNames `Set.union` _set2IcollectedNames
                              {-# LINE 4918 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              _set1Ierrors Seq.>< _set2Ierrors
                              {-# LINE 4924 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 4930 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OallNonterminals =
                             ({-# LINE 88 "Transform.ag" #-}
                              _lhsIallNonterminals
                              {-# LINE 4936 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OdefinedSets =
                             ({-# LINE 107 "Transform.ag" #-}
                              _lhsIdefinedSets
                              {-# LINE 4942 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 4948 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OallNonterminals =
                             ({-# LINE 88 "Transform.ag" #-}
                              _lhsIallNonterminals
                              {-# LINE 4954 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OdefinedSets =
                             ({-# LINE 107 "Transform.ag" #-}
                              _lhsIdefinedSets
                              {-# LINE 4960 "Transform.hs" #-}
                              )
                         ( _set1IcollectedNames,_set1Ierrors,_set1InontSet) =
                             set1_ _set1OallFields _set1OallNonterminals _set1OdefinedSets 
                         ( _set2IcollectedNames,_set2Ierrors,_set2InontSet) =
                             set2_ _set2OallFields _set2OallNonterminals _set2OdefinedSets 
                     in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet))) )
sem_NontSet_Intersect :: T_NontSet  ->
                         T_NontSet  ->
                         T_NontSet 
sem_NontSet_Intersect (T_NontSet set1_ ) (T_NontSet set2_ )  =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    (let _lhsOnontSet :: (Set NontermIdent)
                         _lhsOcollectedNames :: (Set Identifier)
                         _lhsOerrors :: (Seq Error)
                         _set1OallFields :: DataTypes
                         _set1OallNonterminals :: (Set NontermIdent)
                         _set1OdefinedSets :: DefinedSets
                         _set2OallFields :: DataTypes
                         _set2OallNonterminals :: (Set NontermIdent)
                         _set2OdefinedSets :: DefinedSets
                         _set1IcollectedNames :: (Set Identifier)
                         _set1Ierrors :: (Seq Error)
                         _set1InontSet :: (Set NontermIdent)
                         _set2IcollectedNames :: (Set Identifier)
                         _set2Ierrors :: (Seq Error)
                         _set2InontSet :: (Set NontermIdent)
                         -- "Transform.ag"(line 681, column 16)
                         _lhsOnontSet =
                             ({-# LINE 681 "Transform.ag" #-}
                              Set.intersection  _set1InontSet _set2InontSet
                              {-# LINE 4993 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 86, column 50)
                         _lhsOcollectedNames =
                             ({-# LINE 86 "Transform.ag" #-}
                              _set1IcollectedNames `Set.union` _set2IcollectedNames
                              {-# LINE 4999 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              _set1Ierrors Seq.>< _set2Ierrors
                              {-# LINE 5005 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 5011 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OallNonterminals =
                             ({-# LINE 88 "Transform.ag" #-}
                              _lhsIallNonterminals
                              {-# LINE 5017 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OdefinedSets =
                             ({-# LINE 107 "Transform.ag" #-}
                              _lhsIdefinedSets
                              {-# LINE 5023 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 5029 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OallNonterminals =
                             ({-# LINE 88 "Transform.ag" #-}
                              _lhsIallNonterminals
                              {-# LINE 5035 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OdefinedSets =
                             ({-# LINE 107 "Transform.ag" #-}
                              _lhsIdefinedSets
                              {-# LINE 5041 "Transform.hs" #-}
                              )
                         ( _set1IcollectedNames,_set1Ierrors,_set1InontSet) =
                             set1_ _set1OallFields _set1OallNonterminals _set1OdefinedSets 
                         ( _set2IcollectedNames,_set2Ierrors,_set2InontSet) =
                             set2_ _set2OallFields _set2OallNonterminals _set2OdefinedSets 
                     in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet))) )
sem_NontSet_NamedSet :: NontermIdent ->
                        T_NontSet 
sem_NontSet_NamedSet name_  =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    (let _lhsOcollectedNames :: (Set Identifier)
                         _lhsOerrors :: (Seq Error)
                         _lhsOnontSet :: (Set NontermIdent)
                         -- "Transform.ag"(line 557, column 14)
                         _lhsOcollectedNames =
                             ({-# LINE 557 "Transform.ag" #-}
                              Set.singleton name_
                              {-# LINE 5061 "Transform.hs" #-}
                              )
                         -- "Transform.ag"(line 677, column 20)
                         __tup4 =
                             ({-# LINE 677 "Transform.ag" #-}
                              case Map.lookup name_ _lhsIdefinedSets of
                                           Nothing  -> (Set.empty, Seq.singleton (UndefNont name_))
                                           Just set -> (set, Seq.empty)
                              {-# LINE 5069 "Transform.hs" #-}
                              )
                         -- "Transform.ag"(line 677, column 20)
                         (_nontSet,_) =
                             ({-# LINE 677 "Transform.ag" #-}
                              __tup4
                              {-# LINE 5075 "Transform.hs" #-}
                              )
                         -- "Transform.ag"(line 677, column 20)
                         (_,_errors) =
                             ({-# LINE 677 "Transform.ag" #-}
                              __tup4
                              {-# LINE 5081 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              _errors
                              {-# LINE 5087 "Transform.hs" #-}
                              )
                         -- copy rule (from local)
                         _lhsOnontSet =
                             ({-# LINE 112 "Transform.ag" #-}
                              _nontSet
                              {-# LINE 5093 "Transform.hs" #-}
                              )
                     in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet))) )
sem_NontSet_Path :: NontermIdent ->
                    NontermIdent ->
                    T_NontSet 
sem_NontSet_Path from_ to_  =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    (let _lhsOnontSet :: (Set NontermIdent)
                         _lhsOerrors :: (Seq Error)
                         _lhsOcollectedNames :: (Set Identifier)
                         -- "Transform.ag"(line 683, column 16)
                         _lhsOnontSet =
                             ({-# LINE 683 "Transform.ag" #-}
                              let table = flattenDatas _lhsIallFields
                              in path table from_ to_
                              {-# LINE 5111 "Transform.hs" #-}
                              )
                         -- "Transform.ag"(line 685, column 16)
                         _lhsOerrors =
                             ({-# LINE 685 "Transform.ag" #-}
                              let check name | Set.member name _lhsIallNonterminals
                                                         = Seq.empty
                                             | otherwise = Seq.singleton (UndefNont name)
                              in check from_ >< check to_
                              {-# LINE 5120 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 86, column 50)
                         _lhsOcollectedNames =
                             ({-# LINE 86 "Transform.ag" #-}
                              Set.empty
                              {-# LINE 5126 "Transform.hs" #-}
                              )
                     in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet))) )
sem_NontSet_Union :: T_NontSet  ->
                     T_NontSet  ->
                     T_NontSet 
sem_NontSet_Union (T_NontSet set1_ ) (T_NontSet set2_ )  =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    (let _lhsOnontSet :: (Set NontermIdent)
                         _lhsOcollectedNames :: (Set Identifier)
                         _lhsOerrors :: (Seq Error)
                         _set1OallFields :: DataTypes
                         _set1OallNonterminals :: (Set NontermIdent)
                         _set1OdefinedSets :: DefinedSets
                         _set2OallFields :: DataTypes
                         _set2OallNonterminals :: (Set NontermIdent)
                         _set2OdefinedSets :: DefinedSets
                         _set1IcollectedNames :: (Set Identifier)
                         _set1Ierrors :: (Seq Error)
                         _set1InontSet :: (Set NontermIdent)
                         _set2IcollectedNames :: (Set Identifier)
                         _set2Ierrors :: (Seq Error)
                         _set2InontSet :: (Set NontermIdent)
                         -- "Transform.ag"(line 680, column 16)
                         _lhsOnontSet =
                             ({-# LINE 680 "Transform.ag" #-}
                              Set.union         _set1InontSet _set2InontSet
                              {-# LINE 5155 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 86, column 50)
                         _lhsOcollectedNames =
                             ({-# LINE 86 "Transform.ag" #-}
                              _set1IcollectedNames `Set.union` _set2IcollectedNames
                              {-# LINE 5161 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              _set1Ierrors Seq.>< _set2Ierrors
                              {-# LINE 5167 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 5173 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OallNonterminals =
                             ({-# LINE 88 "Transform.ag" #-}
                              _lhsIallNonterminals
                              {-# LINE 5179 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set1OdefinedSets =
                             ({-# LINE 107 "Transform.ag" #-}
                              _lhsIdefinedSets
                              {-# LINE 5185 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 5191 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OallNonterminals =
                             ({-# LINE 88 "Transform.ag" #-}
                              _lhsIallNonterminals
                              {-# LINE 5197 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _set2OdefinedSets =
                             ({-# LINE 107 "Transform.ag" #-}
                              _lhsIdefinedSets
                              {-# LINE 5203 "Transform.hs" #-}
                              )
                         ( _set1IcollectedNames,_set1Ierrors,_set1InontSet) =
                             set1_ _set1OallFields _set1OallNonterminals _set1OdefinedSets 
                         ( _set2IcollectedNames,_set2Ierrors,_set2InontSet) =
                             set2_ _set2OallFields _set2OallNonterminals _set2OdefinedSets 
                     in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet))) )
-- Pattern -----------------------------------------------------
{-
   visit 0:
      synthesized attributes:
         copy                 : SELF 
         definedAttrs         : [AttrName]
         definedInsts         : [Identifier]
         patunder             : [AttrName]->Pattern
         stpos                : Pos
   alternatives:
      alternative Alias:
         child field          : {Identifier}
         child attr           : {Identifier}
         child pat            : Pattern 
         child parts          : Patterns 
         visit 0:
            local copy        : _
      alternative Constr:
         child name           : {ConstructorIdent}
         child pats           : Patterns 
         visit 0:
            local copy        : _
      alternative Irrefutable:
         child pat            : Pattern 
         visit 0:
            local copy        : _
      alternative Product:
         child pos            : {Pos}
         child pats           : Patterns 
         visit 0:
            local copy        : _
      alternative Underscore:
         child pos            : {Pos}
         visit 0:
            local copy        : _
-}
-- cata
sem_Pattern :: Pattern  ->
               T_Pattern 
sem_Pattern (Alias _field _attr _pat _parts )  =
    (sem_Pattern_Alias _field _attr (sem_Pattern _pat ) (sem_Patterns _parts ) )
sem_Pattern (Constr _name _pats )  =
    (sem_Pattern_Constr _name (sem_Patterns _pats ) )
sem_Pattern (Irrefutable _pat )  =
    (sem_Pattern_Irrefutable (sem_Pattern _pat ) )
sem_Pattern (Product _pos _pats )  =
    (sem_Pattern_Product _pos (sem_Patterns _pats ) )
sem_Pattern (Underscore _pos )  =
    (sem_Pattern_Underscore _pos )
-- semantic domain
newtype T_Pattern  = T_Pattern (( Pattern ,([AttrName]),([Identifier]),([AttrName]->Pattern),Pos))
data Inh_Pattern  = Inh_Pattern {}
data Syn_Pattern  = Syn_Pattern {copy_Syn_Pattern :: !(Pattern ),definedAttrs_Syn_Pattern :: !(([AttrName])),definedInsts_Syn_Pattern :: !(([Identifier])),patunder_Syn_Pattern :: !(([AttrName]->Pattern)),stpos_Syn_Pattern :: !(Pos)}
wrap_Pattern :: T_Pattern  ->
                Inh_Pattern  ->
                Syn_Pattern 
wrap_Pattern (T_Pattern sem ) (Inh_Pattern )  =
    (let ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder,_lhsOstpos) = sem 
     in  (Syn_Pattern _lhsOcopy _lhsOdefinedAttrs _lhsOdefinedInsts _lhsOpatunder _lhsOstpos ))
sem_Pattern_Alias :: Identifier ->
                     Identifier ->
                     T_Pattern  ->
                     T_Patterns  ->
                     T_Pattern 
sem_Pattern_Alias field_ attr_ (T_Pattern pat_ ) (T_Patterns parts_ )  =
    (T_Pattern (let _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOdefinedInsts :: ([Identifier])
                    _lhsOstpos :: Pos
                    _lhsOcopy :: Pattern 
                    _patIcopy :: Pattern 
                    _patIdefinedAttrs :: ([AttrName])
                    _patIdefinedInsts :: ([Identifier])
                    _patIpatunder :: ([AttrName]->Pattern)
                    _patIstpos :: Pos
                    _partsIcopy :: Patterns 
                    _partsIdefinedAttrs :: ([AttrName])
                    _partsIdefinedInsts :: ([Identifier])
                    _partsIpatunder :: ([AttrName]->Patterns)
                    -- "Transform.ag"(line 1072, column 11)
                    _lhsOdefinedAttrs =
                        ({-# LINE 1072 "Transform.ag" #-}
                         (field_, attr_) : _patIdefinedAttrs
                         {-# LINE 5293 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 1073, column 11)
                    _lhsOpatunder =
                        ({-# LINE 1073 "Transform.ag" #-}
                         \us -> if ((field_,attr_) `elem` us) then Underscore noPos else _copy
                         {-# LINE 5299 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 1074, column 11)
                    _lhsOdefinedInsts =
                        ({-# LINE 1074 "Transform.ag" #-}
                         (if field_ == _INST then [attr_] else []) ++ _patIdefinedInsts
                         {-# LINE 5305 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 1089, column 16)
                    _lhsOstpos =
                        ({-# LINE 1089 "Transform.ag" #-}
                         getPos field_
                         {-# LINE 5311 "Transform.hs" #-}
                         )
                    -- self rule
                    _copy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         Alias field_ attr_ _patIcopy _partsIcopy
                         {-# LINE 5317 "Transform.hs" #-}
                         )
                    -- self rule
                    _lhsOcopy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         _copy
                         {-# LINE 5323 "Transform.hs" #-}
                         )
                    ( _patIcopy,_patIdefinedAttrs,_patIdefinedInsts,_patIpatunder,_patIstpos) =
                        pat_ 
                    ( _partsIcopy,_partsIdefinedAttrs,_partsIdefinedInsts,_partsIpatunder) =
                        parts_ 
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder,_lhsOstpos)) )
sem_Pattern_Constr :: ConstructorIdent ->
                      T_Patterns  ->
                      T_Pattern 
sem_Pattern_Constr name_ (T_Patterns pats_ )  =
    (T_Pattern (let _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOstpos :: Pos
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOdefinedInsts :: ([Identifier])
                    _lhsOcopy :: Pattern 
                    _patsIcopy :: Patterns 
                    _patsIdefinedAttrs :: ([AttrName])
                    _patsIdefinedInsts :: ([Identifier])
                    _patsIpatunder :: ([AttrName]->Patterns)
                    -- "Transform.ag"(line 1076, column 12)
                    _lhsOpatunder =
                        ({-# LINE 1076 "Transform.ag" #-}
                         \us -> Constr name_ (_patsIpatunder us)
                         {-# LINE 5347 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 1087, column 16)
                    _lhsOstpos =
                        ({-# LINE 1087 "Transform.ag" #-}
                         getPos name_
                         {-# LINE 5353 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1067, column 42)
                    _lhsOdefinedAttrs =
                        ({-# LINE 1067 "Transform.ag" #-}
                         _patsIdefinedAttrs
                         {-# LINE 5359 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1066, column 55)
                    _lhsOdefinedInsts =
                        ({-# LINE 1066 "Transform.ag" #-}
                         _patsIdefinedInsts
                         {-# LINE 5365 "Transform.hs" #-}
                         )
                    -- self rule
                    _copy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         Constr name_ _patsIcopy
                         {-# LINE 5371 "Transform.hs" #-}
                         )
                    -- self rule
                    _lhsOcopy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         _copy
                         {-# LINE 5377 "Transform.hs" #-}
                         )
                    ( _patsIcopy,_patsIdefinedAttrs,_patsIdefinedInsts,_patsIpatunder) =
                        pats_ 
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder,_lhsOstpos)) )
sem_Pattern_Irrefutable :: T_Pattern  ->
                           T_Pattern 
sem_Pattern_Irrefutable (T_Pattern pat_ )  =
    (T_Pattern (let _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOdefinedInsts :: ([Identifier])
                    _lhsOcopy :: Pattern 
                    _lhsOstpos :: Pos
                    _patIcopy :: Pattern 
                    _patIdefinedAttrs :: ([AttrName])
                    _patIdefinedInsts :: ([Identifier])
                    _patIpatunder :: ([AttrName]->Pattern)
                    _patIstpos :: Pos
                    -- "Transform.ag"(line 1078, column 17)
                    _lhsOpatunder =
                        ({-# LINE 1078 "Transform.ag" #-}
                         \us -> Irrefutable (_patIpatunder us)
                         {-# LINE 5399 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1067, column 42)
                    _lhsOdefinedAttrs =
                        ({-# LINE 1067 "Transform.ag" #-}
                         _patIdefinedAttrs
                         {-# LINE 5405 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1066, column 55)
                    _lhsOdefinedInsts =
                        ({-# LINE 1066 "Transform.ag" #-}
                         _patIdefinedInsts
                         {-# LINE 5411 "Transform.hs" #-}
                         )
                    -- self rule
                    _copy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         Irrefutable _patIcopy
                         {-# LINE 5417 "Transform.hs" #-}
                         )
                    -- self rule
                    _lhsOcopy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         _copy
                         {-# LINE 5423 "Transform.hs" #-}
                         )
                    -- copy rule (up)
                    _lhsOstpos =
                        ({-# LINE 1084 "Transform.ag" #-}
                         _patIstpos
                         {-# LINE 5429 "Transform.hs" #-}
                         )
                    ( _patIcopy,_patIdefinedAttrs,_patIdefinedInsts,_patIpatunder,_patIstpos) =
                        pat_ 
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder,_lhsOstpos)) )
sem_Pattern_Product :: Pos ->
                       T_Patterns  ->
                       T_Pattern 
sem_Pattern_Product pos_ (T_Patterns pats_ )  =
    (T_Pattern (let _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOstpos :: Pos
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOdefinedInsts :: ([Identifier])
                    _lhsOcopy :: Pattern 
                    _patsIcopy :: Patterns 
                    _patsIdefinedAttrs :: ([AttrName])
                    _patsIdefinedInsts :: ([Identifier])
                    _patsIpatunder :: ([AttrName]->Patterns)
                    -- "Transform.ag"(line 1077, column 13)
                    _lhsOpatunder =
                        ({-# LINE 1077 "Transform.ag" #-}
                         \us -> Product pos_ (_patsIpatunder us)
                         {-# LINE 5451 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 1088, column 16)
                    _lhsOstpos =
                        ({-# LINE 1088 "Transform.ag" #-}
                         pos_
                         {-# LINE 5457 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1067, column 42)
                    _lhsOdefinedAttrs =
                        ({-# LINE 1067 "Transform.ag" #-}
                         _patsIdefinedAttrs
                         {-# LINE 5463 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1066, column 55)
                    _lhsOdefinedInsts =
                        ({-# LINE 1066 "Transform.ag" #-}
                         _patsIdefinedInsts
                         {-# LINE 5469 "Transform.hs" #-}
                         )
                    -- self rule
                    _copy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         Product pos_ _patsIcopy
                         {-# LINE 5475 "Transform.hs" #-}
                         )
                    -- self rule
                    _lhsOcopy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         _copy
                         {-# LINE 5481 "Transform.hs" #-}
                         )
                    ( _patsIcopy,_patsIdefinedAttrs,_patsIdefinedInsts,_patsIpatunder) =
                        pats_ 
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder,_lhsOstpos)) )
sem_Pattern_Underscore :: Pos ->
                          T_Pattern 
sem_Pattern_Underscore pos_  =
    (T_Pattern (let _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOstpos :: Pos
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOdefinedInsts :: ([Identifier])
                    _lhsOcopy :: Pattern 
                    -- "Transform.ag"(line 1075, column 16)
                    _lhsOpatunder =
                        ({-# LINE 1075 "Transform.ag" #-}
                         \us -> _copy
                         {-# LINE 5498 "Transform.hs" #-}
                         )
                    -- "Transform.ag"(line 1090, column 16)
                    _lhsOstpos =
                        ({-# LINE 1090 "Transform.ag" #-}
                         pos_
                         {-# LINE 5504 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1067, column 42)
                    _lhsOdefinedAttrs =
                        ({-# LINE 1067 "Transform.ag" #-}
                         []
                         {-# LINE 5510 "Transform.hs" #-}
                         )
                    -- use rule "Transform.ag"(line 1066, column 55)
                    _lhsOdefinedInsts =
                        ({-# LINE 1066 "Transform.ag" #-}
                         []
                         {-# LINE 5516 "Transform.hs" #-}
                         )
                    -- self rule
                    _copy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         Underscore pos_
                         {-# LINE 5522 "Transform.hs" #-}
                         )
                    -- self rule
                    _lhsOcopy =
                        ({-# LINE 23 "./Patterns.ag" #-}
                         _copy
                         {-# LINE 5528 "Transform.hs" #-}
                         )
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder,_lhsOstpos)) )
-- Patterns ----------------------------------------------------
{-
   visit 0:
      synthesized attributes:
         copy                 : SELF 
         definedAttrs         : [AttrName]
         definedInsts         : [Identifier]
         patunder             : [AttrName]->Patterns
   alternatives:
      alternative Cons:
         child hd             : Pattern 
         child tl             : Patterns 
         visit 0:
            local copy        : _
      alternative Nil:
         visit 0:
            local copy        : _
-}
-- cata
sem_Patterns :: Patterns  ->
                T_Patterns 
sem_Patterns list  =
    (Prelude.foldr sem_Patterns_Cons sem_Patterns_Nil (Prelude.map sem_Pattern list) )
-- semantic domain
newtype T_Patterns  = T_Patterns (( Patterns ,([AttrName]),([Identifier]),([AttrName]->Patterns)))
data Inh_Patterns  = Inh_Patterns {}
data Syn_Patterns  = Syn_Patterns {copy_Syn_Patterns :: !(Patterns ),definedAttrs_Syn_Patterns :: !(([AttrName])),definedInsts_Syn_Patterns :: !(([Identifier])),patunder_Syn_Patterns :: !(([AttrName]->Patterns))}
wrap_Patterns :: T_Patterns  ->
                 Inh_Patterns  ->
                 Syn_Patterns 
wrap_Patterns (T_Patterns sem ) (Inh_Patterns )  =
    (let ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder) = sem 
     in  (Syn_Patterns _lhsOcopy _lhsOdefinedAttrs _lhsOdefinedInsts _lhsOpatunder ))
sem_Patterns_Cons :: T_Pattern  ->
                     T_Patterns  ->
                     T_Patterns 
sem_Patterns_Cons (T_Pattern hd_ ) (T_Patterns tl_ )  =
    (T_Patterns (let _lhsOpatunder :: ([AttrName]->Patterns)
                     _lhsOdefinedAttrs :: ([AttrName])
                     _lhsOdefinedInsts :: ([Identifier])
                     _lhsOcopy :: Patterns 
                     _hdIcopy :: Pattern 
                     _hdIdefinedAttrs :: ([AttrName])
                     _hdIdefinedInsts :: ([Identifier])
                     _hdIpatunder :: ([AttrName]->Pattern)
                     _hdIstpos :: Pos
                     _tlIcopy :: Patterns 
                     _tlIdefinedAttrs :: ([AttrName])
                     _tlIdefinedInsts :: ([Identifier])
                     _tlIpatunder :: ([AttrName]->Patterns)
                     -- "Transform.ag"(line 1082, column 10)
                     _lhsOpatunder =
                         ({-# LINE 1082 "Transform.ag" #-}
                          \us -> (_hdIpatunder us) : (_tlIpatunder us)
                          {-# LINE 5585 "Transform.hs" #-}
                          )
                     -- use rule "Transform.ag"(line 1067, column 42)
                     _lhsOdefinedAttrs =
                         ({-# LINE 1067 "Transform.ag" #-}
                          _hdIdefinedAttrs ++ _tlIdefinedAttrs
                          {-# LINE 5591 "Transform.hs" #-}
                          )
                     -- use rule "Transform.ag"(line 1066, column 55)
                     _lhsOdefinedInsts =
                         ({-# LINE 1066 "Transform.ag" #-}
                          _hdIdefinedInsts ++ _tlIdefinedInsts
                          {-# LINE 5597 "Transform.hs" #-}
                          )
                     -- self rule
                     _copy =
                         ({-# LINE 23 "./Patterns.ag" #-}
                          (:) _hdIcopy _tlIcopy
                          {-# LINE 5603 "Transform.hs" #-}
                          )
                     -- self rule
                     _lhsOcopy =
                         ({-# LINE 23 "./Patterns.ag" #-}
                          _copy
                          {-# LINE 5609 "Transform.hs" #-}
                          )
                     ( _hdIcopy,_hdIdefinedAttrs,_hdIdefinedInsts,_hdIpatunder,_hdIstpos) =
                         hd_ 
                     ( _tlIcopy,_tlIdefinedAttrs,_tlIdefinedInsts,_tlIpatunder) =
                         tl_ 
                 in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder)) )
sem_Patterns_Nil :: T_Patterns 
sem_Patterns_Nil  =
    (T_Patterns (let _lhsOpatunder :: ([AttrName]->Patterns)
                     _lhsOdefinedAttrs :: ([AttrName])
                     _lhsOdefinedInsts :: ([Identifier])
                     _lhsOcopy :: Patterns 
                     -- "Transform.ag"(line 1081, column 9)
                     _lhsOpatunder =
                         ({-# LINE 1081 "Transform.ag" #-}
                          \us ->  []
                          {-# LINE 5626 "Transform.hs" #-}
                          )
                     -- use rule "Transform.ag"(line 1067, column 42)
                     _lhsOdefinedAttrs =
                         ({-# LINE 1067 "Transform.ag" #-}
                          []
                          {-# LINE 5632 "Transform.hs" #-}
                          )
                     -- use rule "Transform.ag"(line 1066, column 55)
                     _lhsOdefinedInsts =
                         ({-# LINE 1066 "Transform.ag" #-}
                          []
                          {-# LINE 5638 "Transform.hs" #-}
                          )
                     -- self rule
                     _copy =
                         ({-# LINE 23 "./Patterns.ag" #-}
                          []
                          {-# LINE 5644 "Transform.hs" #-}
                          )
                     -- self rule
                     _lhsOcopy =
                         ({-# LINE 23 "./Patterns.ag" #-}
                          _copy
                          {-# LINE 5650 "Transform.hs" #-}
                          )
                 in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOdefinedInsts,_lhsOpatunder)) )
-- SemAlt ------------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allAttrDecls         : Map NontermIdent (Attributes, Attributes)
         allFields            : DataTypes
         nts                  : Set NontermIdent
         options              : Options
      synthesized attributes:
         attrOrderCollect     : AttrOrderMap
         collectedArounds     : [ (NontermIdent, ConstructorIdent, [AroundInfo])  ]
         collectedAugments    : [ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]
         collectedInsts       : [ (NontermIdent, ConstructorIdent, [Identifier]) ]
         collectedMerges      : [ (NontermIdent, ConstructorIdent, [MergeInfo])   ]
         collectedRules       : [ (NontermIdent, ConstructorIdent, RuleInfo)]
         collectedSigs        : [ (NontermIdent, ConstructorIdent, SigInfo) ]
         collectedUniques     : [ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]
         errors               : Seq Error
         semPragmasCollect    : PragmaMap
   alternatives:
      alternative SemAlt:
         child pos            : {Pos}
         child constructorSet : ConstructorSet 
         child rules          : SemDefs 
         visit 0:
            local pragmaNames : _
            local attrOrders  : _
            local coninfo     : _
-}
-- cata
sem_SemAlt :: SemAlt  ->
              T_SemAlt 
sem_SemAlt (SemAlt _pos _constructorSet _rules )  =
    (sem_SemAlt_SemAlt _pos (sem_ConstructorSet _constructorSet ) (sem_SemDefs _rules ) )
-- semantic domain
newtype T_SemAlt  = T_SemAlt ((Map NontermIdent (Attributes, Attributes)) ->
                              DataTypes ->
                              (Set NontermIdent) ->
                              Options ->
                              ( AttrOrderMap,([ (NontermIdent, ConstructorIdent, [AroundInfo])  ]),([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]),([ (NontermIdent, ConstructorIdent, [Identifier]) ]),([ (NontermIdent, ConstructorIdent, [MergeInfo])   ]),([ (NontermIdent, ConstructorIdent, RuleInfo)]),([ (NontermIdent, ConstructorIdent, SigInfo) ]),([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]),(Seq Error),PragmaMap))
data Inh_SemAlt  = Inh_SemAlt {allAttrDecls_Inh_SemAlt :: !((Map NontermIdent (Attributes, Attributes))),allFields_Inh_SemAlt :: !(DataTypes),nts_Inh_SemAlt :: !((Set NontermIdent)),options_Inh_SemAlt :: !(Options)}
data Syn_SemAlt  = Syn_SemAlt {attrOrderCollect_Syn_SemAlt :: !(AttrOrderMap),collectedArounds_Syn_SemAlt :: !(([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])),collectedAugments_Syn_SemAlt :: !(([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])),collectedInsts_Syn_SemAlt :: !(([ (NontermIdent, ConstructorIdent, [Identifier]) ])),collectedMerges_Syn_SemAlt :: !(([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])),collectedRules_Syn_SemAlt :: !(([ (NontermIdent, ConstructorIdent, RuleInfo)])),collectedSigs_Syn_SemAlt :: !(([ (NontermIdent, ConstructorIdent, SigInfo) ])),collectedUniques_Syn_SemAlt :: !(([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])),errors_Syn_SemAlt :: !((Seq Error)),semPragmasCollect_Syn_SemAlt :: !(PragmaMap)}
wrap_SemAlt :: T_SemAlt  ->
               Inh_SemAlt  ->
               Syn_SemAlt 
wrap_SemAlt (T_SemAlt sem ) (Inh_SemAlt _lhsIallAttrDecls _lhsIallFields _lhsInts _lhsIoptions )  =
    (let ( _lhsOattrOrderCollect,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedRules,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOerrors,_lhsOsemPragmasCollect) = sem _lhsIallAttrDecls _lhsIallFields _lhsInts _lhsIoptions 
     in  (Syn_SemAlt _lhsOattrOrderCollect _lhsOcollectedArounds _lhsOcollectedAugments _lhsOcollectedInsts _lhsOcollectedMerges _lhsOcollectedRules _lhsOcollectedSigs _lhsOcollectedUniques _lhsOerrors _lhsOsemPragmasCollect ))
sem_SemAlt_SemAlt :: Pos ->
                     T_ConstructorSet  ->
                     T_SemDefs  ->
                     T_SemAlt 
sem_SemAlt_SemAlt pos_ (T_ConstructorSet constructorSet_ ) (T_SemDefs rules_ )  =
    (T_SemAlt (\ _lhsIallAttrDecls
                 _lhsIallFields
                 _lhsInts
                 _lhsIoptions ->
                   (let _lhsOsemPragmasCollect :: PragmaMap
                        _lhsOattrOrderCollect :: AttrOrderMap
                        _lhsOerrors :: (Seq Error)
                        _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                        _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                        _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                        _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                        _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                        _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                        _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                        _rulesOoptions :: Options
                        _constructorSetIcollectedConstructorNames :: (Set ConstructorIdent)
                        _constructorSetIconstructors :: ((Set ConstructorIdent->Set ConstructorIdent))
                        _constructorSetIerrors :: (Seq Error)
                        _rulesIaroundInfos :: ([AroundInfo])
                        _rulesIaugmentInfos :: ([AugmentInfo])
                        _rulesIdefinedInsts :: ([Identifier])
                        _rulesIerrors :: (Seq Error)
                        _rulesImergeInfos :: ([MergeInfo])
                        _rulesIorderDepsCollect :: (Set Dependency)
                        _rulesIpragmaNamesCollect :: ([Identifier])
                        _rulesIruleInfos :: ([RuleInfo])
                        _rulesIsigInfos :: ([SigInfo])
                        _rulesIuniqueInfos :: ([UniqueInfo])
                        -- "Transform.ag"(line 796, column 7)
                        _pragmaNames =
                            ({-# LINE 796 "Transform.ag" #-}
                             Set.fromList _rulesIpragmaNamesCollect
                             {-# LINE 5738 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 797, column 7)
                        _lhsOsemPragmasCollect =
                            ({-# LINE 797 "Transform.ag" #-}
                             foldr pragmaMapUnion Map.empty [ pragmaMapSingle nt con _pragmaNames
                                                            | (nt, conset, _) <- _coninfo
                                                            , con <- Set.toList conset
                                                            ]
                             {-# LINE 5747 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 825, column 7)
                        _attrOrders =
                            ({-# LINE 825 "Transform.ag" #-}
                             [ orderMapSingle nt con _rulesIorderDepsCollect
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             ]
                             {-# LINE 5756 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 831, column 7)
                        _lhsOattrOrderCollect =
                            ({-# LINE 831 "Transform.ag" #-}
                             foldr orderMapUnion Map.empty _attrOrders
                             {-# LINE 5762 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 991, column 12)
                        _coninfo =
                            ({-# LINE 991 "Transform.ag" #-}
                             [ (nt, conset, conkeys)
                             | nt  <- Set.toList _lhsInts
                             , let conmap = Map.findWithDefault Map.empty nt _lhsIallFields
                             , let conkeys = Set.fromList (Map.keys conmap)
                             , let conset  = _constructorSetIconstructors conkeys
                             ]
                             {-# LINE 5773 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 998, column 12)
                        _lhsOerrors =
                            ({-# LINE 998 "Transform.ag" #-}
                             Seq.fromList
                                [ UndefAlt nt con
                                | (nt, conset, conkeys) <- _coninfo
                                , con <- Set.toList (Set.difference conset conkeys)
                                ]
                             Seq.>< _rulesIerrors
                             {-# LINE 5784 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1004, column 12)
                        _lhsOcollectedRules =
                            ({-# LINE 1004 "Transform.ag" #-}
                             [ (nt,con,r)
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             , r <- _rulesIruleInfos
                             ]
                             {-# LINE 5794 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1010, column 12)
                        _lhsOcollectedSigs =
                            ({-# LINE 1010 "Transform.ag" #-}
                             [ (nt,con,ts)
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             , ts <- _rulesIsigInfos
                             ]
                             {-# LINE 5804 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1017, column 12)
                        _lhsOcollectedInsts =
                            ({-# LINE 1017 "Transform.ag" #-}
                             [ (nt,con,_rulesIdefinedInsts)
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             ]
                             {-# LINE 5813 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1023, column 12)
                        _lhsOcollectedUniques =
                            ({-# LINE 1023 "Transform.ag" #-}
                             [ (nt,con,_rulesIuniqueInfos)
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             ]
                             {-# LINE 5822 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1029, column 12)
                        _lhsOcollectedAugments =
                            ({-# LINE 1029 "Transform.ag" #-}
                             [ (nt, con, _rulesIaugmentInfos)
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             ]
                             {-# LINE 5831 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1035, column 12)
                        _lhsOcollectedArounds =
                            ({-# LINE 1035 "Transform.ag" #-}
                             [ (nt, con, _rulesIaroundInfos)
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             ]
                             {-# LINE 5840 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1041, column 12)
                        _lhsOcollectedMerges =
                            ({-# LINE 1041 "Transform.ag" #-}
                             [ (nt, con, _rulesImergeInfos)
                             | (nt, conset, _) <- _coninfo
                             , con <- Set.toList conset
                             ]
                             {-# LINE 5849 "Transform.hs" #-}
                             )
                        -- copy rule (down)
                        _rulesOoptions =
                            ({-# LINE 39 "Transform.ag" #-}
                             _lhsIoptions
                             {-# LINE 5855 "Transform.hs" #-}
                             )
                        ( _constructorSetIcollectedConstructorNames,_constructorSetIconstructors,_constructorSetIerrors) =
                            constructorSet_ 
                        ( _rulesIaroundInfos,_rulesIaugmentInfos,_rulesIdefinedInsts,_rulesIerrors,_rulesImergeInfos,_rulesIorderDepsCollect,_rulesIpragmaNamesCollect,_rulesIruleInfos,_rulesIsigInfos,_rulesIuniqueInfos) =
                            rules_ _rulesOoptions 
                    in  ( _lhsOattrOrderCollect,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedRules,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOerrors,_lhsOsemPragmasCollect))) )
-- SemAlts -----------------------------------------------------
{-
   visit 0:
      inherited attributes:
         allAttrDecls         : Map NontermIdent (Attributes, Attributes)
         allFields            : DataTypes
         nts                  : Set NontermIdent
         options              : Options
      synthesized attributes:
         attrOrderCollect     : AttrOrderMap
         collectedArounds     : [ (NontermIdent, ConstructorIdent, [AroundInfo])  ]
         collectedAugments    : [ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]
         collectedInsts       : [ (NontermIdent, ConstructorIdent, [Identifier]) ]
         collectedMerges      : [ (NontermIdent, ConstructorIdent, [MergeInfo])   ]
         collectedRules       : [ (NontermIdent, ConstructorIdent, RuleInfo)]
         collectedSigs        : [ (NontermIdent, ConstructorIdent, SigInfo) ]
         collectedUniques     : [ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]
         errors               : Seq Error
         semPragmasCollect    : PragmaMap
   alternatives:
      alternative Cons:
         child hd             : SemAlt 
         child tl             : SemAlts 
      alternative Nil:
-}
-- cata
sem_SemAlts :: SemAlts  ->
               T_SemAlts 
sem_SemAlts list  =
    (Prelude.foldr sem_SemAlts_Cons sem_SemAlts_Nil (Prelude.map sem_SemAlt list) )
-- semantic domain
newtype T_SemAlts  = T_SemAlts ((Map NontermIdent (Attributes, Attributes)) ->
                                DataTypes ->
                                (Set NontermIdent) ->
                                Options ->
                                ( AttrOrderMap,([ (NontermIdent, ConstructorIdent, [AroundInfo])  ]),([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ]),([ (NontermIdent, ConstructorIdent, [Identifier]) ]),([ (NontermIdent, ConstructorIdent, [MergeInfo])   ]),([ (NontermIdent, ConstructorIdent, RuleInfo)]),([ (NontermIdent, ConstructorIdent, SigInfo) ]),([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ]),(Seq Error),PragmaMap))
data Inh_SemAlts  = Inh_SemAlts {allAttrDecls_Inh_SemAlts :: !((Map NontermIdent (Attributes, Attributes))),allFields_Inh_SemAlts :: !(DataTypes),nts_Inh_SemAlts :: !((Set NontermIdent)),options_Inh_SemAlts :: !(Options)}
data Syn_SemAlts  = Syn_SemAlts {attrOrderCollect_Syn_SemAlts :: !(AttrOrderMap),collectedArounds_Syn_SemAlts :: !(([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])),collectedAugments_Syn_SemAlts :: !(([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])),collectedInsts_Syn_SemAlts :: !(([ (NontermIdent, ConstructorIdent, [Identifier]) ])),collectedMerges_Syn_SemAlts :: !(([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])),collectedRules_Syn_SemAlts :: !(([ (NontermIdent, ConstructorIdent, RuleInfo)])),collectedSigs_Syn_SemAlts :: !(([ (NontermIdent, ConstructorIdent, SigInfo) ])),collectedUniques_Syn_SemAlts :: !(([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])),errors_Syn_SemAlts :: !((Seq Error)),semPragmasCollect_Syn_SemAlts :: !(PragmaMap)}
wrap_SemAlts :: T_SemAlts  ->
                Inh_SemAlts  ->
                Syn_SemAlts 
wrap_SemAlts (T_SemAlts sem ) (Inh_SemAlts _lhsIallAttrDecls _lhsIallFields _lhsInts _lhsIoptions )  =
    (let ( _lhsOattrOrderCollect,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedRules,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOerrors,_lhsOsemPragmasCollect) = sem _lhsIallAttrDecls _lhsIallFields _lhsInts _lhsIoptions 
     in  (Syn_SemAlts _lhsOattrOrderCollect _lhsOcollectedArounds _lhsOcollectedAugments _lhsOcollectedInsts _lhsOcollectedMerges _lhsOcollectedRules _lhsOcollectedSigs _lhsOcollectedUniques _lhsOerrors _lhsOsemPragmasCollect ))
sem_SemAlts_Cons :: T_SemAlt  ->
                    T_SemAlts  ->
                    T_SemAlts 
sem_SemAlts_Cons (T_SemAlt hd_ ) (T_SemAlts tl_ )  =
    (T_SemAlts (\ _lhsIallAttrDecls
                  _lhsIallFields
                  _lhsInts
                  _lhsIoptions ->
                    (let _lhsOattrOrderCollect :: AttrOrderMap
                         _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                         _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                         _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                         _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                         _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                         _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                         _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                         _lhsOerrors :: (Seq Error)
                         _lhsOsemPragmasCollect :: PragmaMap
                         _hdOallAttrDecls :: (Map NontermIdent (Attributes, Attributes))
                         _hdOallFields :: DataTypes
                         _hdOnts :: (Set NontermIdent)
                         _hdOoptions :: Options
                         _tlOallAttrDecls :: (Map NontermIdent (Attributes, Attributes))
                         _tlOallFields :: DataTypes
                         _tlOnts :: (Set NontermIdent)
                         _tlOoptions :: Options
                         _hdIattrOrderCollect :: AttrOrderMap
                         _hdIcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                         _hdIcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                         _hdIcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                         _hdIcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                         _hdIcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                         _hdIcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                         _hdIcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                         _hdIerrors :: (Seq Error)
                         _hdIsemPragmasCollect :: PragmaMap
                         _tlIattrOrderCollect :: AttrOrderMap
                         _tlIcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                         _tlIcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                         _tlIcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                         _tlIcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                         _tlIcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                         _tlIcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                         _tlIcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                         _tlIerrors :: (Seq Error)
                         _tlIsemPragmasCollect :: PragmaMap
                         -- use rule "Transform.ag"(line 820, column 55)
                         _lhsOattrOrderCollect =
                             ({-# LINE 820 "Transform.ag" #-}
                              _hdIattrOrderCollect `orderMapUnion` _tlIattrOrderCollect
                              {-# LINE 5956 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 156, column 32)
                         _lhsOcollectedArounds =
                             ({-# LINE 156 "Transform.ag" #-}
                              _hdIcollectedArounds ++ _tlIcollectedArounds
                              {-# LINE 5962 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 155, column 32)
                         _lhsOcollectedAugments =
                             ({-# LINE 155 "Transform.ag" #-}
                              _hdIcollectedAugments ++ _tlIcollectedAugments
                              {-# LINE 5968 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 153, column 32)
                         _lhsOcollectedInsts =
                             ({-# LINE 153 "Transform.ag" #-}
                              _hdIcollectedInsts ++ _tlIcollectedInsts
                              {-# LINE 5974 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 157, column 32)
                         _lhsOcollectedMerges =
                             ({-# LINE 157 "Transform.ag" #-}
                              _hdIcollectedMerges ++ _tlIcollectedMerges
                              {-# LINE 5980 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 151, column 32)
                         _lhsOcollectedRules =
                             ({-# LINE 151 "Transform.ag" #-}
                              _hdIcollectedRules ++ _tlIcollectedRules
                              {-# LINE 5986 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 152, column 32)
                         _lhsOcollectedSigs =
                             ({-# LINE 152 "Transform.ag" #-}
                              _hdIcollectedSigs ++ _tlIcollectedSigs
                              {-# LINE 5992 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 154, column 32)
                         _lhsOcollectedUniques =
                             ({-# LINE 154 "Transform.ag" #-}
                              _hdIcollectedUniques ++ _tlIcollectedUniques
                              {-# LINE 5998 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              _hdIerrors Seq.>< _tlIerrors
                              {-# LINE 6004 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 792, column 56)
                         _lhsOsemPragmasCollect =
                             ({-# LINE 792 "Transform.ag" #-}
                              _hdIsemPragmasCollect `pragmaMapUnion` _tlIsemPragmasCollect
                              {-# LINE 6010 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _hdOallAttrDecls =
                             ({-# LINE 821 "Transform.ag" #-}
                              _lhsIallAttrDecls
                              {-# LINE 6016 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _hdOallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 6022 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _hdOnts =
                             ({-# LINE 167 "Transform.ag" #-}
                              _lhsInts
                              {-# LINE 6028 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _hdOoptions =
                             ({-# LINE 39 "Transform.ag" #-}
                              _lhsIoptions
                              {-# LINE 6034 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _tlOallAttrDecls =
                             ({-# LINE 821 "Transform.ag" #-}
                              _lhsIallAttrDecls
                              {-# LINE 6040 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _tlOallFields =
                             ({-# LINE 128 "Transform.ag" #-}
                              _lhsIallFields
                              {-# LINE 6046 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _tlOnts =
                             ({-# LINE 167 "Transform.ag" #-}
                              _lhsInts
                              {-# LINE 6052 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _tlOoptions =
                             ({-# LINE 39 "Transform.ag" #-}
                              _lhsIoptions
                              {-# LINE 6058 "Transform.hs" #-}
                              )
                         ( _hdIattrOrderCollect,_hdIcollectedArounds,_hdIcollectedAugments,_hdIcollectedInsts,_hdIcollectedMerges,_hdIcollectedRules,_hdIcollectedSigs,_hdIcollectedUniques,_hdIerrors,_hdIsemPragmasCollect) =
                             hd_ _hdOallAttrDecls _hdOallFields _hdOnts _hdOoptions 
                         ( _tlIattrOrderCollect,_tlIcollectedArounds,_tlIcollectedAugments,_tlIcollectedInsts,_tlIcollectedMerges,_tlIcollectedRules,_tlIcollectedSigs,_tlIcollectedUniques,_tlIerrors,_tlIsemPragmasCollect) =
                             tl_ _tlOallAttrDecls _tlOallFields _tlOnts _tlOoptions 
                     in  ( _lhsOattrOrderCollect,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedRules,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOerrors,_lhsOsemPragmasCollect))) )
sem_SemAlts_Nil :: T_SemAlts 
sem_SemAlts_Nil  =
    (T_SemAlts (\ _lhsIallAttrDecls
                  _lhsIallFields
                  _lhsInts
                  _lhsIoptions ->
                    (let _lhsOattrOrderCollect :: AttrOrderMap
                         _lhsOcollectedArounds :: ([ (NontermIdent, ConstructorIdent, [AroundInfo])  ])
                         _lhsOcollectedAugments :: ([ (NontermIdent, ConstructorIdent, [AugmentInfo]) ])
                         _lhsOcollectedInsts :: ([ (NontermIdent, ConstructorIdent, [Identifier]) ])
                         _lhsOcollectedMerges :: ([ (NontermIdent, ConstructorIdent, [MergeInfo])   ])
                         _lhsOcollectedRules :: ([ (NontermIdent, ConstructorIdent, RuleInfo)])
                         _lhsOcollectedSigs :: ([ (NontermIdent, ConstructorIdent, SigInfo) ])
                         _lhsOcollectedUniques :: ([ (NontermIdent, ConstructorIdent, [UniqueInfo]) ])
                         _lhsOerrors :: (Seq Error)
                         _lhsOsemPragmasCollect :: PragmaMap
                         -- use rule "Transform.ag"(line 820, column 55)
                         _lhsOattrOrderCollect =
                             ({-# LINE 820 "Transform.ag" #-}
                              Map.empty
                              {-# LINE 6085 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 156, column 32)
                         _lhsOcollectedArounds =
                             ({-# LINE 156 "Transform.ag" #-}
                              []
                              {-# LINE 6091 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 155, column 32)
                         _lhsOcollectedAugments =
                             ({-# LINE 155 "Transform.ag" #-}
                              []
                              {-# LINE 6097 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 153, column 32)
                         _lhsOcollectedInsts =
                             ({-# LINE 153 "Transform.ag" #-}
                              []
                              {-# LINE 6103 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 157, column 32)
                         _lhsOcollectedMerges =
                             ({-# LINE 157 "Transform.ag" #-}
                              []
                              {-# LINE 6109 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 151, column 32)
                         _lhsOcollectedRules =
                             ({-# LINE 151 "Transform.ag" #-}
                              []
                              {-# LINE 6115 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 152, column 32)
                         _lhsOcollectedSigs =
                             ({-# LINE 152 "Transform.ag" #-}
                              []
                              {-# LINE 6121 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 154, column 32)
                         _lhsOcollectedUniques =
                             ({-# LINE 154 "Transform.ag" #-}
                              []
                              {-# LINE 6127 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              Seq.empty
                              {-# LINE 6133 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 792, column 56)
                         _lhsOsemPragmasCollect =
                             ({-# LINE 792 "Transform.ag" #-}
                              Map.empty
                              {-# LINE 6139 "Transform.hs" #-}
                              )
                     in  ( _lhsOattrOrderCollect,_lhsOcollectedArounds,_lhsOcollectedAugments,_lhsOcollectedInsts,_lhsOcollectedMerges,_lhsOcollectedRules,_lhsOcollectedSigs,_lhsOcollectedUniques,_lhsOerrors,_lhsOsemPragmasCollect))) )
-- SemDef ------------------------------------------------------
{-
   visit 0:
      inherited attribute:
         options              : Options
      synthesized attributes:
         aroundInfos          : [AroundInfo]
         augmentInfos         : [AugmentInfo]
         definedInsts         : [Identifier]
         errors               : Seq Error
         mergeInfos           : [MergeInfo]
         orderDepsCollect     : Set Dependency
         pragmaNamesCollect   : [Identifier]
         ruleInfos            : [RuleInfo]
         sigInfos             : [SigInfo]
         uniqueInfos          : [UniqueInfo]
   alternatives:
      alternative AroundDef:
         child ident          : {Identifier}
         child rhs            : {Expression}
      alternative AttrOrderBefore:
         child before         : {[Occurrence]}
         child after          : {[Occurrence]}
         visit 0:
            local dependency  : _
      alternative AugmentDef:
         child ident          : {Identifier}
         child rhs            : {Expression}
      alternative Def:
         child pos            : {Pos}
         child mbName         : {Maybe Identifier}
         child pattern        : Pattern 
         child rhs            : {Expression}
         child owrt           : {Bool}
      alternative MergeDef:
         child target         : {Identifier}
         child nt             : {Identifier}
         child sources        : {[Identifier]}
         child rhs            : {Expression}
      alternative SemPragma:
         child names          : {[NontermIdent]}
      alternative TypeDef:
         child pos            : {Pos}
         child ident          : {Identifier}
         child tp             : {Type}
      alternative UniqueDef:
         child ident          : {Identifier}
         child ref            : {Identifier}
-}
-- cata
sem_SemDef :: SemDef  ->
              T_SemDef 
sem_SemDef (AroundDef _ident _rhs )  =
    (sem_SemDef_AroundDef _ident _rhs )
sem_SemDef (AttrOrderBefore _before _after )  =
    (sem_SemDef_AttrOrderBefore _before _after )
sem_SemDef (AugmentDef _ident _rhs )  =
    (sem_SemDef_AugmentDef _ident _rhs )
sem_SemDef (Def _pos _mbName _pattern _rhs _owrt )  =
    (sem_SemDef_Def _pos _mbName (sem_Pattern _pattern ) _rhs _owrt )
sem_SemDef (MergeDef _target _nt _sources _rhs )  =
    (sem_SemDef_MergeDef _target _nt _sources _rhs )
sem_SemDef (SemPragma _names )  =
    (sem_SemDef_SemPragma _names )
sem_SemDef (TypeDef _pos _ident _tp )  =
    (sem_SemDef_TypeDef _pos _ident _tp )
sem_SemDef (UniqueDef _ident _ref )  =
    (sem_SemDef_UniqueDef _ident _ref )
-- semantic domain
newtype T_SemDef  = T_SemDef (Options ->
                              ( ([AroundInfo]),([AugmentInfo]),([Identifier]),(Seq Error),([MergeInfo]),(Set Dependency),([Identifier]),([RuleInfo]),([SigInfo]),([UniqueInfo])))
data Inh_SemDef  = Inh_SemDef {options_Inh_SemDef :: !(Options)}
data Syn_SemDef  = Syn_SemDef {aroundInfos_Syn_SemDef :: !(([AroundInfo])),augmentInfos_Syn_SemDef :: !(([AugmentInfo])),definedInsts_Syn_SemDef :: !(([Identifier])),errors_Syn_SemDef :: !((Seq Error)),mergeInfos_Syn_SemDef :: !(([MergeInfo])),orderDepsCollect_Syn_SemDef :: !((Set Dependency)),pragmaNamesCollect_Syn_SemDef :: !(([Identifier])),ruleInfos_Syn_SemDef :: !(([RuleInfo])),sigInfos_Syn_SemDef :: !(([SigInfo])),uniqueInfos_Syn_SemDef :: !(([UniqueInfo]))}
wrap_SemDef :: T_SemDef  ->
               Inh_SemDef  ->
               Syn_SemDef 
wrap_SemDef (T_SemDef sem ) (Inh_SemDef _lhsIoptions )  =
    (let ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos) = sem _lhsIoptions 
     in  (Syn_SemDef _lhsOaroundInfos _lhsOaugmentInfos _lhsOdefinedInsts _lhsOerrors _lhsOmergeInfos _lhsOorderDepsCollect _lhsOpragmaNamesCollect _lhsOruleInfos _lhsOsigInfos _lhsOuniqueInfos ))
sem_SemDef_AroundDef :: Identifier ->
                        Expression ->
                        T_SemDef 
sem_SemDef_AroundDef ident_ rhs_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOerrors :: (Seq Error)
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOsigInfos :: ([SigInfo])
                        _lhsOuniqueInfos :: ([UniqueInfo])
                        -- "Transform.ag"(line 1060, column 17)
                        _lhsOaroundInfos =
                            ({-# LINE 1060 "Transform.ag" #-}
                             [ (ident_, rhs_) ]
                             {-# LINE 6240 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 984, column 40)
                        _lhsOaugmentInfos =
                            ({-# LINE 984 "Transform.ag" #-}
                             []
                             {-# LINE 6246 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             []
                             {-# LINE 6252 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 43, column 19)
                        _lhsOerrors =
                            ({-# LINE 43 "Transform.ag" #-}
                             Seq.empty
                             {-# LINE 6258 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 986, column 40)
                        _lhsOmergeInfos =
                            ({-# LINE 986 "Transform.ag" #-}
                             []
                             {-# LINE 6264 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 833, column 44)
                        _lhsOorderDepsCollect =
                            ({-# LINE 833 "Transform.ag" #-}
                             Set.empty
                             {-# LINE 6270 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 802, column 46)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 802 "Transform.ag" #-}
                             []
                             {-# LINE 6276 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 981, column 40)
                        _lhsOruleInfos =
                            ({-# LINE 981 "Transform.ag" #-}
                             []
                             {-# LINE 6282 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 982, column 40)
                        _lhsOsigInfos =
                            ({-# LINE 982 "Transform.ag" #-}
                             []
                             {-# LINE 6288 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 983, column 40)
                        _lhsOuniqueInfos =
                            ({-# LINE 983 "Transform.ag" #-}
                             []
                             {-# LINE 6294 "Transform.hs" #-}
                             )
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDef_AttrOrderBefore :: ([Occurrence]) ->
                              ([Occurrence]) ->
                              T_SemDef 
sem_SemDef_AttrOrderBefore before_ after_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOerrors :: (Seq Error)
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOsigInfos :: ([SigInfo])
                        _lhsOuniqueInfos :: ([UniqueInfo])
                        -- "Transform.ag"(line 837, column 7)
                        _dependency =
                            ({-# LINE 837 "Transform.ag" #-}
                             [ Dependency b a | b <- before_, a <- after_ ]
                             {-# LINE 6316 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 838, column 7)
                        _lhsOorderDepsCollect =
                            ({-# LINE 838 "Transform.ag" #-}
                             Set.fromList _dependency
                             {-# LINE 6322 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 985, column 40)
                        _lhsOaroundInfos =
                            ({-# LINE 985 "Transform.ag" #-}
                             []
                             {-# LINE 6328 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 984, column 40)
                        _lhsOaugmentInfos =
                            ({-# LINE 984 "Transform.ag" #-}
                             []
                             {-# LINE 6334 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             []
                             {-# LINE 6340 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 43, column 19)
                        _lhsOerrors =
                            ({-# LINE 43 "Transform.ag" #-}
                             Seq.empty
                             {-# LINE 6346 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 986, column 40)
                        _lhsOmergeInfos =
                            ({-# LINE 986 "Transform.ag" #-}
                             []
                             {-# LINE 6352 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 802, column 46)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 802 "Transform.ag" #-}
                             []
                             {-# LINE 6358 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 981, column 40)
                        _lhsOruleInfos =
                            ({-# LINE 981 "Transform.ag" #-}
                             []
                             {-# LINE 6364 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 982, column 40)
                        _lhsOsigInfos =
                            ({-# LINE 982 "Transform.ag" #-}
                             []
                             {-# LINE 6370 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 983, column 40)
                        _lhsOuniqueInfos =
                            ({-# LINE 983 "Transform.ag" #-}
                             []
                             {-# LINE 6376 "Transform.hs" #-}
                             )
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDef_AugmentDef :: Identifier ->
                         Expression ->
                         T_SemDef 
sem_SemDef_AugmentDef ident_ rhs_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOerrors :: (Seq Error)
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOsigInfos :: ([SigInfo])
                        _lhsOuniqueInfos :: ([UniqueInfo])
                        -- "Transform.ag"(line 1057, column 17)
                        _lhsOaugmentInfos =
                            ({-# LINE 1057 "Transform.ag" #-}
                             [ (ident_, rhs_) ]
                             {-# LINE 6398 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 985, column 40)
                        _lhsOaroundInfos =
                            ({-# LINE 985 "Transform.ag" #-}
                             []
                             {-# LINE 6404 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             []
                             {-# LINE 6410 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 43, column 19)
                        _lhsOerrors =
                            ({-# LINE 43 "Transform.ag" #-}
                             Seq.empty
                             {-# LINE 6416 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 986, column 40)
                        _lhsOmergeInfos =
                            ({-# LINE 986 "Transform.ag" #-}
                             []
                             {-# LINE 6422 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 833, column 44)
                        _lhsOorderDepsCollect =
                            ({-# LINE 833 "Transform.ag" #-}
                             Set.empty
                             {-# LINE 6428 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 802, column 46)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 802 "Transform.ag" #-}
                             []
                             {-# LINE 6434 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 981, column 40)
                        _lhsOruleInfos =
                            ({-# LINE 981 "Transform.ag" #-}
                             []
                             {-# LINE 6440 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 982, column 40)
                        _lhsOsigInfos =
                            ({-# LINE 982 "Transform.ag" #-}
                             []
                             {-# LINE 6446 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 983, column 40)
                        _lhsOuniqueInfos =
                            ({-# LINE 983 "Transform.ag" #-}
                             []
                             {-# LINE 6452 "Transform.hs" #-}
                             )
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDef_Def :: Pos ->
                  (Maybe Identifier) ->
                  T_Pattern  ->
                  Expression ->
                  Bool ->
                  T_SemDef 
sem_SemDef_Def pos_ mbName_ (T_Pattern pattern_ ) rhs_ owrt_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOerrors :: (Seq Error)
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOsigInfos :: ([SigInfo])
                        _lhsOuniqueInfos :: ([UniqueInfo])
                        _patternIcopy :: Pattern 
                        _patternIdefinedAttrs :: ([AttrName])
                        _patternIdefinedInsts :: ([Identifier])
                        _patternIpatunder :: ([AttrName]->Pattern)
                        _patternIstpos :: Pos
                        -- "Transform.ag"(line 527, column 3)
                        _lhsOerrors =
                            ({-# LINE 527 "Transform.ag" #-}
                             if checkParseRhs _lhsIoptions
                             then Seq.fromList $ checkRhs rhs_
                             else Seq.empty
                             {-# LINE 6484 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1048, column 10)
                        _lhsOruleInfos =
                            ({-# LINE 1048 "Transform.ag" #-}
                             [ (mbName_, _patternIpatunder, rhs_, _patternIdefinedAttrs, owrt_, show _patternIstpos) ]
                             {-# LINE 6490 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 985, column 40)
                        _lhsOaroundInfos =
                            ({-# LINE 985 "Transform.ag" #-}
                             []
                             {-# LINE 6496 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 984, column 40)
                        _lhsOaugmentInfos =
                            ({-# LINE 984 "Transform.ag" #-}
                             []
                             {-# LINE 6502 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             _patternIdefinedInsts
                             {-# LINE 6508 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 986, column 40)
                        _lhsOmergeInfos =
                            ({-# LINE 986 "Transform.ag" #-}
                             []
                             {-# LINE 6514 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 833, column 44)
                        _lhsOorderDepsCollect =
                            ({-# LINE 833 "Transform.ag" #-}
                             Set.empty
                             {-# LINE 6520 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 802, column 46)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 802 "Transform.ag" #-}
                             []
                             {-# LINE 6526 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 982, column 40)
                        _lhsOsigInfos =
                            ({-# LINE 982 "Transform.ag" #-}
                             []
                             {-# LINE 6532 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 983, column 40)
                        _lhsOuniqueInfos =
                            ({-# LINE 983 "Transform.ag" #-}
                             []
                             {-# LINE 6538 "Transform.hs" #-}
                             )
                        ( _patternIcopy,_patternIdefinedAttrs,_patternIdefinedInsts,_patternIpatunder,_patternIstpos) =
                            pattern_ 
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDef_MergeDef :: Identifier ->
                       Identifier ->
                       ([Identifier]) ->
                       Expression ->
                       T_SemDef 
sem_SemDef_MergeDef target_ nt_ sources_ rhs_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOerrors :: (Seq Error)
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOsigInfos :: ([SigInfo])
                        _lhsOuniqueInfos :: ([UniqueInfo])
                        -- "Transform.ag"(line 527, column 3)
                        _lhsOerrors =
                            ({-# LINE 527 "Transform.ag" #-}
                             if checkParseRhs _lhsIoptions
                             then Seq.fromList $ checkRhs rhs_
                             else Seq.empty
                             {-# LINE 6566 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1063, column 17)
                        _lhsOmergeInfos =
                            ({-# LINE 1063 "Transform.ag" #-}
                             [ (target_, nt_, sources_, rhs_) ]
                             {-# LINE 6572 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 985, column 40)
                        _lhsOaroundInfos =
                            ({-# LINE 985 "Transform.ag" #-}
                             []
                             {-# LINE 6578 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 984, column 40)
                        _lhsOaugmentInfos =
                            ({-# LINE 984 "Transform.ag" #-}
                             []
                             {-# LINE 6584 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             []
                             {-# LINE 6590 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 833, column 44)
                        _lhsOorderDepsCollect =
                            ({-# LINE 833 "Transform.ag" #-}
                             Set.empty
                             {-# LINE 6596 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 802, column 46)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 802 "Transform.ag" #-}
                             []
                             {-# LINE 6602 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 981, column 40)
                        _lhsOruleInfos =
                            ({-# LINE 981 "Transform.ag" #-}
                             []
                             {-# LINE 6608 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 982, column 40)
                        _lhsOsigInfos =
                            ({-# LINE 982 "Transform.ag" #-}
                             []
                             {-# LINE 6614 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 983, column 40)
                        _lhsOuniqueInfos =
                            ({-# LINE 983 "Transform.ag" #-}
                             []
                             {-# LINE 6620 "Transform.hs" #-}
                             )
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDef_SemPragma :: ([NontermIdent]) ->
                        T_SemDef 
sem_SemDef_SemPragma names_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOerrors :: (Seq Error)
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOsigInfos :: ([SigInfo])
                        _lhsOuniqueInfos :: ([UniqueInfo])
                        -- "Transform.ag"(line 806, column 7)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 806 "Transform.ag" #-}
                             names_
                             {-# LINE 6641 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 985, column 40)
                        _lhsOaroundInfos =
                            ({-# LINE 985 "Transform.ag" #-}
                             []
                             {-# LINE 6647 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 984, column 40)
                        _lhsOaugmentInfos =
                            ({-# LINE 984 "Transform.ag" #-}
                             []
                             {-# LINE 6653 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             []
                             {-# LINE 6659 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 43, column 19)
                        _lhsOerrors =
                            ({-# LINE 43 "Transform.ag" #-}
                             Seq.empty
                             {-# LINE 6665 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 986, column 40)
                        _lhsOmergeInfos =
                            ({-# LINE 986 "Transform.ag" #-}
                             []
                             {-# LINE 6671 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 833, column 44)
                        _lhsOorderDepsCollect =
                            ({-# LINE 833 "Transform.ag" #-}
                             Set.empty
                             {-# LINE 6677 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 981, column 40)
                        _lhsOruleInfos =
                            ({-# LINE 981 "Transform.ag" #-}
                             []
                             {-# LINE 6683 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 982, column 40)
                        _lhsOsigInfos =
                            ({-# LINE 982 "Transform.ag" #-}
                             []
                             {-# LINE 6689 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 983, column 40)
                        _lhsOuniqueInfos =
                            ({-# LINE 983 "Transform.ag" #-}
                             []
                             {-# LINE 6695 "Transform.hs" #-}
                             )
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDef_TypeDef :: Pos ->
                      Identifier ->
                      Type ->
                      T_SemDef 
sem_SemDef_TypeDef pos_ ident_ tp_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOerrors :: (Seq Error)
                        _lhsOsigInfos :: ([SigInfo])
                        _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOuniqueInfos :: ([UniqueInfo])
                        -- "Transform.ag"(line 534, column 3)
                        _lhsOerrors =
                            ({-# LINE 534 "Transform.ag" #-}
                             if checkParseTy _lhsIoptions
                             then case tp_ of
                                    Haskell s -> let exp = Expression pos_ tks
                                                     tks = [tk]
                                                     tk  = HsToken s pos_
                                                 in Seq.fromList $ checkTy exp
                                    _ -> Seq.empty
                             else Seq.empty
                             {-# LINE 6725 "Transform.hs" #-}
                             )
                        -- "Transform.ag"(line 1051, column 14)
                        _lhsOsigInfos =
                            ({-# LINE 1051 "Transform.ag" #-}
                             [ (ident_, tp_) ]
                             {-# LINE 6731 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 985, column 40)
                        _lhsOaroundInfos =
                            ({-# LINE 985 "Transform.ag" #-}
                             []
                             {-# LINE 6737 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 984, column 40)
                        _lhsOaugmentInfos =
                            ({-# LINE 984 "Transform.ag" #-}
                             []
                             {-# LINE 6743 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             []
                             {-# LINE 6749 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 986, column 40)
                        _lhsOmergeInfos =
                            ({-# LINE 986 "Transform.ag" #-}
                             []
                             {-# LINE 6755 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 833, column 44)
                        _lhsOorderDepsCollect =
                            ({-# LINE 833 "Transform.ag" #-}
                             Set.empty
                             {-# LINE 6761 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 802, column 46)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 802 "Transform.ag" #-}
                             []
                             {-# LINE 6767 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 981, column 40)
                        _lhsOruleInfos =
                            ({-# LINE 981 "Transform.ag" #-}
                             []
                             {-# LINE 6773 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 983, column 40)
                        _lhsOuniqueInfos =
                            ({-# LINE 983 "Transform.ag" #-}
                             []
                             {-# LINE 6779 "Transform.hs" #-}
                             )
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDef_UniqueDef :: Identifier ->
                        Identifier ->
                        T_SemDef 
sem_SemDef_UniqueDef ident_ ref_  =
    (T_SemDef (\ _lhsIoptions ->
                   (let _lhsOuniqueInfos :: ([UniqueInfo])
                        _lhsOaroundInfos :: ([AroundInfo])
                        _lhsOaugmentInfos :: ([AugmentInfo])
                        _lhsOdefinedInsts :: ([Identifier])
                        _lhsOerrors :: (Seq Error)
                        _lhsOmergeInfos :: ([MergeInfo])
                        _lhsOorderDepsCollect :: (Set Dependency)
                        _lhsOpragmaNamesCollect :: ([Identifier])
                        _lhsOruleInfos :: ([RuleInfo])
                        _lhsOsigInfos :: ([SigInfo])
                        -- "Transform.ag"(line 1054, column 16)
                        _lhsOuniqueInfos =
                            ({-# LINE 1054 "Transform.ag" #-}
                             [ (ident_, ref_) ]
                             {-# LINE 6801 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 985, column 40)
                        _lhsOaroundInfos =
                            ({-# LINE 985 "Transform.ag" #-}
                             []
                             {-# LINE 6807 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 984, column 40)
                        _lhsOaugmentInfos =
                            ({-# LINE 984 "Transform.ag" #-}
                             []
                             {-# LINE 6813 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 1066, column 55)
                        _lhsOdefinedInsts =
                            ({-# LINE 1066 "Transform.ag" #-}
                             []
                             {-# LINE 6819 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 43, column 19)
                        _lhsOerrors =
                            ({-# LINE 43 "Transform.ag" #-}
                             Seq.empty
                             {-# LINE 6825 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 986, column 40)
                        _lhsOmergeInfos =
                            ({-# LINE 986 "Transform.ag" #-}
                             []
                             {-# LINE 6831 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 833, column 44)
                        _lhsOorderDepsCollect =
                            ({-# LINE 833 "Transform.ag" #-}
                             Set.empty
                             {-# LINE 6837 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 802, column 46)
                        _lhsOpragmaNamesCollect =
                            ({-# LINE 802 "Transform.ag" #-}
                             []
                             {-# LINE 6843 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 981, column 40)
                        _lhsOruleInfos =
                            ({-# LINE 981 "Transform.ag" #-}
                             []
                             {-# LINE 6849 "Transform.hs" #-}
                             )
                        -- use rule "Transform.ag"(line 982, column 40)
                        _lhsOsigInfos =
                            ({-# LINE 982 "Transform.ag" #-}
                             []
                             {-# LINE 6855 "Transform.hs" #-}
                             )
                    in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
-- SemDefs -----------------------------------------------------
{-
   visit 0:
      inherited attribute:
         options              : Options
      synthesized attributes:
         aroundInfos          : [AroundInfo]
         augmentInfos         : [AugmentInfo]
         definedInsts         : [Identifier]
         errors               : Seq Error
         mergeInfos           : [MergeInfo]
         orderDepsCollect     : Set Dependency
         pragmaNamesCollect   : [Identifier]
         ruleInfos            : [RuleInfo]
         sigInfos             : [SigInfo]
         uniqueInfos          : [UniqueInfo]
   alternatives:
      alternative Cons:
         child hd             : SemDef 
         child tl             : SemDefs 
      alternative Nil:
-}
-- cata
sem_SemDefs :: SemDefs  ->
               T_SemDefs 
sem_SemDefs list  =
    (Prelude.foldr sem_SemDefs_Cons sem_SemDefs_Nil (Prelude.map sem_SemDef list) )
-- semantic domain
newtype T_SemDefs  = T_SemDefs (Options ->
                                ( ([AroundInfo]),([AugmentInfo]),([Identifier]),(Seq Error),([MergeInfo]),(Set Dependency),([Identifier]),([RuleInfo]),([SigInfo]),([UniqueInfo])))
data Inh_SemDefs  = Inh_SemDefs {options_Inh_SemDefs :: !(Options)}
data Syn_SemDefs  = Syn_SemDefs {aroundInfos_Syn_SemDefs :: !(([AroundInfo])),augmentInfos_Syn_SemDefs :: !(([AugmentInfo])),definedInsts_Syn_SemDefs :: !(([Identifier])),errors_Syn_SemDefs :: !((Seq Error)),mergeInfos_Syn_SemDefs :: !(([MergeInfo])),orderDepsCollect_Syn_SemDefs :: !((Set Dependency)),pragmaNamesCollect_Syn_SemDefs :: !(([Identifier])),ruleInfos_Syn_SemDefs :: !(([RuleInfo])),sigInfos_Syn_SemDefs :: !(([SigInfo])),uniqueInfos_Syn_SemDefs :: !(([UniqueInfo]))}
wrap_SemDefs :: T_SemDefs  ->
                Inh_SemDefs  ->
                Syn_SemDefs 
wrap_SemDefs (T_SemDefs sem ) (Inh_SemDefs _lhsIoptions )  =
    (let ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos) = sem _lhsIoptions 
     in  (Syn_SemDefs _lhsOaroundInfos _lhsOaugmentInfos _lhsOdefinedInsts _lhsOerrors _lhsOmergeInfos _lhsOorderDepsCollect _lhsOpragmaNamesCollect _lhsOruleInfos _lhsOsigInfos _lhsOuniqueInfos ))
sem_SemDefs_Cons :: T_SemDef  ->
                    T_SemDefs  ->
                    T_SemDefs 
sem_SemDefs_Cons (T_SemDef hd_ ) (T_SemDefs tl_ )  =
    (T_SemDefs (\ _lhsIoptions ->
                    (let _lhsOaroundInfos :: ([AroundInfo])
                         _lhsOaugmentInfos :: ([AugmentInfo])
                         _lhsOdefinedInsts :: ([Identifier])
                         _lhsOerrors :: (Seq Error)
                         _lhsOmergeInfos :: ([MergeInfo])
                         _lhsOorderDepsCollect :: (Set Dependency)
                         _lhsOpragmaNamesCollect :: ([Identifier])
                         _lhsOruleInfos :: ([RuleInfo])
                         _lhsOsigInfos :: ([SigInfo])
                         _lhsOuniqueInfos :: ([UniqueInfo])
                         _hdOoptions :: Options
                         _tlOoptions :: Options
                         _hdIaroundInfos :: ([AroundInfo])
                         _hdIaugmentInfos :: ([AugmentInfo])
                         _hdIdefinedInsts :: ([Identifier])
                         _hdIerrors :: (Seq Error)
                         _hdImergeInfos :: ([MergeInfo])
                         _hdIorderDepsCollect :: (Set Dependency)
                         _hdIpragmaNamesCollect :: ([Identifier])
                         _hdIruleInfos :: ([RuleInfo])
                         _hdIsigInfos :: ([SigInfo])
                         _hdIuniqueInfos :: ([UniqueInfo])
                         _tlIaroundInfos :: ([AroundInfo])
                         _tlIaugmentInfos :: ([AugmentInfo])
                         _tlIdefinedInsts :: ([Identifier])
                         _tlIerrors :: (Seq Error)
                         _tlImergeInfos :: ([MergeInfo])
                         _tlIorderDepsCollect :: (Set Dependency)
                         _tlIpragmaNamesCollect :: ([Identifier])
                         _tlIruleInfos :: ([RuleInfo])
                         _tlIsigInfos :: ([SigInfo])
                         _tlIuniqueInfos :: ([UniqueInfo])
                         -- use rule "Transform.ag"(line 985, column 40)
                         _lhsOaroundInfos =
                             ({-# LINE 985 "Transform.ag" #-}
                              _hdIaroundInfos ++ _tlIaroundInfos
                              {-# LINE 6937 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 984, column 40)
                         _lhsOaugmentInfos =
                             ({-# LINE 984 "Transform.ag" #-}
                              _hdIaugmentInfos ++ _tlIaugmentInfos
                              {-# LINE 6943 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 1066, column 55)
                         _lhsOdefinedInsts =
                             ({-# LINE 1066 "Transform.ag" #-}
                              _hdIdefinedInsts ++ _tlIdefinedInsts
                              {-# LINE 6949 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              _hdIerrors Seq.>< _tlIerrors
                              {-# LINE 6955 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 986, column 40)
                         _lhsOmergeInfos =
                             ({-# LINE 986 "Transform.ag" #-}
                              _hdImergeInfos ++ _tlImergeInfos
                              {-# LINE 6961 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 833, column 44)
                         _lhsOorderDepsCollect =
                             ({-# LINE 833 "Transform.ag" #-}
                              _hdIorderDepsCollect `Set.union` _tlIorderDepsCollect
                              {-# LINE 6967 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 802, column 46)
                         _lhsOpragmaNamesCollect =
                             ({-# LINE 802 "Transform.ag" #-}
                              _hdIpragmaNamesCollect ++ _tlIpragmaNamesCollect
                              {-# LINE 6973 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 981, column 40)
                         _lhsOruleInfos =
                             ({-# LINE 981 "Transform.ag" #-}
                              _hdIruleInfos ++ _tlIruleInfos
                              {-# LINE 6979 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 982, column 40)
                         _lhsOsigInfos =
                             ({-# LINE 982 "Transform.ag" #-}
                              _hdIsigInfos ++ _tlIsigInfos
                              {-# LINE 6985 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 983, column 40)
                         _lhsOuniqueInfos =
                             ({-# LINE 983 "Transform.ag" #-}
                              _hdIuniqueInfos ++ _tlIuniqueInfos
                              {-# LINE 6991 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _hdOoptions =
                             ({-# LINE 39 "Transform.ag" #-}
                              _lhsIoptions
                              {-# LINE 6997 "Transform.hs" #-}
                              )
                         -- copy rule (down)
                         _tlOoptions =
                             ({-# LINE 39 "Transform.ag" #-}
                              _lhsIoptions
                              {-# LINE 7003 "Transform.hs" #-}
                              )
                         ( _hdIaroundInfos,_hdIaugmentInfos,_hdIdefinedInsts,_hdIerrors,_hdImergeInfos,_hdIorderDepsCollect,_hdIpragmaNamesCollect,_hdIruleInfos,_hdIsigInfos,_hdIuniqueInfos) =
                             hd_ _hdOoptions 
                         ( _tlIaroundInfos,_tlIaugmentInfos,_tlIdefinedInsts,_tlIerrors,_tlImergeInfos,_tlIorderDepsCollect,_tlIpragmaNamesCollect,_tlIruleInfos,_tlIsigInfos,_tlIuniqueInfos) =
                             tl_ _tlOoptions 
                     in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )
sem_SemDefs_Nil :: T_SemDefs 
sem_SemDefs_Nil  =
    (T_SemDefs (\ _lhsIoptions ->
                    (let _lhsOaroundInfos :: ([AroundInfo])
                         _lhsOaugmentInfos :: ([AugmentInfo])
                         _lhsOdefinedInsts :: ([Identifier])
                         _lhsOerrors :: (Seq Error)
                         _lhsOmergeInfos :: ([MergeInfo])
                         _lhsOorderDepsCollect :: (Set Dependency)
                         _lhsOpragmaNamesCollect :: ([Identifier])
                         _lhsOruleInfos :: ([RuleInfo])
                         _lhsOsigInfos :: ([SigInfo])
                         _lhsOuniqueInfos :: ([UniqueInfo])
                         -- use rule "Transform.ag"(line 985, column 40)
                         _lhsOaroundInfos =
                             ({-# LINE 985 "Transform.ag" #-}
                              []
                              {-# LINE 7027 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 984, column 40)
                         _lhsOaugmentInfos =
                             ({-# LINE 984 "Transform.ag" #-}
                              []
                              {-# LINE 7033 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 1066, column 55)
                         _lhsOdefinedInsts =
                             ({-# LINE 1066 "Transform.ag" #-}
                              []
                              {-# LINE 7039 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 43, column 19)
                         _lhsOerrors =
                             ({-# LINE 43 "Transform.ag" #-}
                              Seq.empty
                              {-# LINE 7045 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 986, column 40)
                         _lhsOmergeInfos =
                             ({-# LINE 986 "Transform.ag" #-}
                              []
                              {-# LINE 7051 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 833, column 44)
                         _lhsOorderDepsCollect =
                             ({-# LINE 833 "Transform.ag" #-}
                              Set.empty
                              {-# LINE 7057 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 802, column 46)
                         _lhsOpragmaNamesCollect =
                             ({-# LINE 802 "Transform.ag" #-}
                              []
                              {-# LINE 7063 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 981, column 40)
                         _lhsOruleInfos =
                             ({-# LINE 981 "Transform.ag" #-}
                              []
                              {-# LINE 7069 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 982, column 40)
                         _lhsOsigInfos =
                             ({-# LINE 982 "Transform.ag" #-}
                              []
                              {-# LINE 7075 "Transform.hs" #-}
                              )
                         -- use rule "Transform.ag"(line 983, column 40)
                         _lhsOuniqueInfos =
                             ({-# LINE 983 "Transform.ag" #-}
                              []
                              {-# LINE 7081 "Transform.hs" #-}
                              )
                     in  ( _lhsOaroundInfos,_lhsOaugmentInfos,_lhsOdefinedInsts,_lhsOerrors,_lhsOmergeInfos,_lhsOorderDepsCollect,_lhsOpragmaNamesCollect,_lhsOruleInfos,_lhsOsigInfos,_lhsOuniqueInfos))) )