-- do not edit; automatically generated by UU.AG
module PrintCode where

import Char (isAlphaNum)
import UU.Pretty
import Code
import Patterns
import Options (Options,nest)
import CommonTypes (attrname, _LOC, getName, nullIdent)

import UU.Pretty(PP_Doc)
import Patterns
import Data.List(partition)

-- Patterns.ag imports
import UU.Scanner.Position(Pos)
import CommonTypes (Constructor,Name)

type PP_Docs = [PP_Doc]


reallySimple :: String -> Bool
reallySimple = and . map (\x -> isAlphaNum x || x=='_')

ppTuple True  pps = "(" >|< pp_block " " (replicate (length pps `max` 1) ')') ",(" pps
ppTuple False pps = "(" >|< pp_block " " ")" "," pps
ppUnboxedTuple True pps  = "(# " >|< pp_block " " (concat $ replicate (length pps `max` 1) " #)") ",(# " pps
ppUnboxedTuple False pps = "(# " >|< pp_block " " " #)" "," pps


locname' n = "_loc_" ++ getName n

-- Unboxed tuples
--   unbox  Whether unboxed tuples are wanted or not
--   inh    The inherited attributes. 
--          If there are none, no unboxing can take place, 
--          because in that case the semantic function (a top-level identifier) would have an unboxed type.
-- Of course we can't have an unboxed 1-tuple
mkTupleExpr :: Bool -> [a] -> Exprs -> Expr
mkTupleExpr unbox inh exprs | not unbox || null inh || length exprs == 1 = TupleExpr exprs
                            | otherwise                                  = UnboxedTupleExpr exprs
mkTupleType :: Bool -> [a] -> Types -> Type
mkTupleType unbox inh tps | not unbox || null inh || length tps == 1 = TupleType tps
                          | otherwise                                = UnboxedTupleType tps
mkTupleLhs :: Bool -> [a] -> [String] -> Lhs
mkTupleLhs  unbox inh comps | not unbox || null inh || length comps == 1 = TupleLhs comps
                            | otherwise                                  = UnboxedTupleLhs comps
-- CaseAlt -----------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pps                  : PP_Docs

-}
{-
   local variables for CaseAlt.CaseAlt:

-}
-- semantic domain
newtype T_CaseAlt = T_CaseAlt ((Bool) ->
                               ( (PP_Docs)))
-- cata
sem_CaseAlt :: (CaseAlt) ->
               (T_CaseAlt)
sem_CaseAlt ((CaseAlt (_left) (_expr))) =
    (sem_CaseAlt_CaseAlt ((sem_Lhs (_left))) ((sem_Expr (_expr))))
data Inh_CaseAlt = Inh_CaseAlt {nested_Inh_CaseAlt :: Bool}
data Syn_CaseAlt = Syn_CaseAlt {pps_Syn_CaseAlt :: PP_Docs}
wrap_CaseAlt :: (T_CaseAlt) ->
                (Inh_CaseAlt) ->
                (Syn_CaseAlt)
wrap_CaseAlt ((T_CaseAlt (sem))) ((Inh_CaseAlt (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_CaseAlt (s1))
sem_CaseAlt_CaseAlt :: (T_Lhs) ->
                       (T_Expr) ->
                       (T_CaseAlt)
sem_CaseAlt_CaseAlt ((T_Lhs (left_))) ((T_Expr (expr_))) =
    (T_CaseAlt (\ _lhsInested ->
                    let _lhsOpps :: (PP_Docs)
                        _leftIpp :: (PP_Doc)
                        _leftOnested :: (Bool)
                        _exprIpp :: (PP_Doc)
                        _exprOnested :: (Bool)
                        ( _leftIpp) =
                            (left_ (_leftOnested))
                        ( _exprIpp) =
                            (expr_ (_exprOnested))
                        -- "PrintCode.ag"(line 91, column 16)
                        (_lhsOpps@_) =
                            ["{" >#< _leftIpp >#< "->", _exprIpp >#< "}"]
                        -- copy rule (down)
                        (_leftOnested@_) =
                            _lhsInested
                        -- copy rule (down)
                        (_exprOnested@_) =
                            _lhsInested
                    in  ( _lhsOpps)))
-- CaseAlts ----------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pps                  : PP_Docs

-}
{-
   local variables for CaseAlts.Cons:

-}
{-
   local variables for CaseAlts.Nil:

-}
-- semantic domain
newtype T_CaseAlts = T_CaseAlts ((Bool) ->
                                 ( (PP_Docs)))
-- cata
sem_CaseAlts :: (CaseAlts) ->
                (T_CaseAlts)
sem_CaseAlts (list) =
    (Prelude.foldr (sem_CaseAlts_Cons) (sem_CaseAlts_Nil) ((Prelude.map sem_CaseAlt list)))
data Inh_CaseAlts = Inh_CaseAlts {nested_Inh_CaseAlts :: Bool}
data Syn_CaseAlts = Syn_CaseAlts {pps_Syn_CaseAlts :: PP_Docs}
wrap_CaseAlts :: (T_CaseAlts) ->
                 (Inh_CaseAlts) ->
                 (Syn_CaseAlts)
wrap_CaseAlts ((T_CaseAlts (sem))) ((Inh_CaseAlts (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_CaseAlts (s1))
sem_CaseAlts_Cons :: (T_CaseAlt) ->
                     (T_CaseAlts) ->
                     (T_CaseAlts)
sem_CaseAlts_Cons ((T_CaseAlt (hd_))) ((T_CaseAlts (tl_))) =
    (T_CaseAlts (\ _lhsInested ->
                     let _lhsOpps :: (PP_Docs)
                         _hdIpps :: (PP_Docs)
                         _hdOnested :: (Bool)
                         _tlIpps :: (PP_Docs)
                         _tlOnested :: (Bool)
                         ( _hdIpps) =
                             (hd_ (_hdOnested))
                         ( _tlIpps) =
                             (tl_ (_tlOnested))
                         -- "PrintCode.ag"(line 34, column 10)
                         (_lhsOpps@_) =
                             _hdIpps ++ _tlIpps
                         -- copy rule (down)
                         (_hdOnested@_) =
                             _lhsInested
                         -- copy rule (down)
                         (_tlOnested@_) =
                             _lhsInested
                     in  ( _lhsOpps)))
sem_CaseAlts_Nil :: (T_CaseAlts)
sem_CaseAlts_Nil  =
    (T_CaseAlts (\ _lhsInested ->
                     let _lhsOpps :: (PP_Docs)
                         -- "PrintCode.ag"(line 35, column 10)
                         (_lhsOpps@_) =
                             []
                     in  ( _lhsOpps)))
-- DataAlt -----------------------------------------------------
{-
   inherited attributes:
      nested               : Bool
      strictPre            : PP_Doc

   chained attributes:

   synthesised attributes:
      pp                   : PP_Doc

-}
{-
   local variables for DataAlt.DataAlt:

-}
{-
   local variables for DataAlt.Record:

-}
-- semantic domain
newtype T_DataAlt = T_DataAlt ((Bool) ->
                               (PP_Doc) ->
                               ( (PP_Doc)))
-- cata
sem_DataAlt :: (DataAlt) ->
               (T_DataAlt)
sem_DataAlt ((DataAlt (_name) (_args))) =
    (sem_DataAlt_DataAlt (_name) (_args))
sem_DataAlt ((Record (_name) (_args))) =
    (sem_DataAlt_Record (_name) (_args))
data Inh_DataAlt = Inh_DataAlt {nested_Inh_DataAlt :: Bool,strictPre_Inh_DataAlt :: PP_Doc}
data Syn_DataAlt = Syn_DataAlt {pp_Syn_DataAlt :: PP_Doc}
wrap_DataAlt :: (T_DataAlt) ->
                (Inh_DataAlt) ->
                (Syn_DataAlt)
wrap_DataAlt ((T_DataAlt (sem))) ((Inh_DataAlt (i1) (i2))) =
    let ( s1) =
            (sem (i1) (i2))
    in  (Syn_DataAlt (s1))
sem_DataAlt_DataAlt :: (String) ->
                       ([String]) ->
                       (T_DataAlt)
sem_DataAlt_DataAlt (name_) (args_) =
    (T_DataAlt (\ _lhsInested
                  _lhsIstrictPre ->
                    let _lhsOpp :: (PP_Doc)
                        -- "PrintCode.ag"(line 94, column 16)
                        (_lhsOpp@_) =
                            name_ >#< hv_sp (map ((_lhsIstrictPre >|<) . pp_parens . text) args_)
                    in  ( _lhsOpp)))
sem_DataAlt_Record :: (String) ->
                      ([(String,String)]) ->
                      (T_DataAlt)
sem_DataAlt_Record (name_) (args_) =
    (T_DataAlt (\ _lhsInested
                  _lhsIstrictPre ->
                    let _lhsOpp :: (PP_Doc)
                        -- "PrintCode.ag"(line 95, column 16)
                        (_lhsOpp@_) =
                            name_ >#< pp_block "{" "}" ","
                                               [ f >#< "::" >#< t | (f,t) <- args_ ]
                    in  ( _lhsOpp)))
-- DataAlts ----------------------------------------------------
{-
   inherited attributes:
      nested               : Bool
      strictPre            : PP_Doc

   chained attributes:

   synthesised attributes:
      pps                  : PP_Docs

-}
{-
   local variables for DataAlts.Cons:

-}
{-
   local variables for DataAlts.Nil:

-}
-- semantic domain
newtype T_DataAlts = T_DataAlts ((Bool) ->
                                 (PP_Doc) ->
                                 ( (PP_Docs)))
-- cata
sem_DataAlts :: (DataAlts) ->
                (T_DataAlts)
sem_DataAlts (list) =
    (Prelude.foldr (sem_DataAlts_Cons) (sem_DataAlts_Nil) ((Prelude.map sem_DataAlt list)))
data Inh_DataAlts = Inh_DataAlts {nested_Inh_DataAlts :: Bool,strictPre_Inh_DataAlts :: PP_Doc}
data Syn_DataAlts = Syn_DataAlts {pps_Syn_DataAlts :: PP_Docs}
wrap_DataAlts :: (T_DataAlts) ->
                 (Inh_DataAlts) ->
                 (Syn_DataAlts)
wrap_DataAlts ((T_DataAlts (sem))) ((Inh_DataAlts (i1) (i2))) =
    let ( s1) =
            (sem (i1) (i2))
    in  (Syn_DataAlts (s1))
sem_DataAlts_Cons :: (T_DataAlt) ->
                     (T_DataAlts) ->
                     (T_DataAlts)
sem_DataAlts_Cons ((T_DataAlt (hd_))) ((T_DataAlts (tl_))) =
    (T_DataAlts (\ _lhsInested
                   _lhsIstrictPre ->
                     let _lhsOpps :: (PP_Docs)
                         _hdIpp :: (PP_Doc)
                         _hdOnested :: (Bool)
                         _hdOstrictPre :: (PP_Doc)
                         _tlIpps :: (PP_Docs)
                         _tlOnested :: (Bool)
                         _tlOstrictPre :: (PP_Doc)
                         ( _hdIpp) =
                             (hd_ (_hdOnested) (_hdOstrictPre))
                         ( _tlIpps) =
                             (tl_ (_tlOnested) (_tlOstrictPre))
                         -- "PrintCode.ag"(line 38, column 10)
                         (_lhsOpps@_) =
                             _hdIpp : _tlIpps
                         -- copy rule (down)
                         (_hdOnested@_) =
                             _lhsInested
                         -- copy rule (down)
                         (_hdOstrictPre@_) =
                             _lhsIstrictPre
                         -- copy rule (down)
                         (_tlOnested@_) =
                             _lhsInested
                         -- copy rule (down)
                         (_tlOstrictPre@_) =
                             _lhsIstrictPre
                     in  ( _lhsOpps)))
sem_DataAlts_Nil :: (T_DataAlts)
sem_DataAlts_Nil  =
    (T_DataAlts (\ _lhsInested
                   _lhsIstrictPre ->
                     let _lhsOpps :: (PP_Docs)
                         -- "PrintCode.ag"(line 39, column 10)
                         (_lhsOpps@_) =
                             []
                     in  ( _lhsOpps)))
-- Decl --------------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pp                   : PP_Doc

-}
{-
   local variables for Decl.Comment:

-}
{-
   local variables for Decl.Data:

-}
{-
   local variables for Decl.Decl:

-}
{-
   local variables for Decl.NewType:

-}
{-
   local variables for Decl.TSig:

-}
{-
   local variables for Decl.Type:

-}
-- semantic domain
newtype T_Decl = T_Decl ((Bool) ->
                         ( (PP_Doc)))
-- cata
sem_Decl :: (Decl) ->
            (T_Decl)
sem_Decl ((Comment (_txt))) =
    (sem_Decl_Comment (_txt))
sem_Decl ((Data (_name) (_alts) (_strict) (_derivings))) =
    (sem_Decl_Data (_name) ((sem_DataAlts (_alts))) (_strict) (_derivings))
sem_Decl ((Decl (_left) (_rhs))) =
    (sem_Decl_Decl ((sem_Lhs (_left))) ((sem_Expr (_rhs))))
sem_Decl ((NewType (_name) (_con) (_tp))) =
    (sem_Decl_NewType (_name) (_con) ((sem_Type (_tp))))
sem_Decl ((TSig (_name) (_tp))) =
    (sem_Decl_TSig (_name) ((sem_Type (_tp))))
sem_Decl ((Type (_name) (_tp))) =
    (sem_Decl_Type (_name) ((sem_Type (_tp))))
data Inh_Decl = Inh_Decl {nested_Inh_Decl :: Bool}
data Syn_Decl = Syn_Decl {pp_Syn_Decl :: PP_Doc}
wrap_Decl :: (T_Decl) ->
             (Inh_Decl) ->
             (Syn_Decl)
wrap_Decl ((T_Decl (sem))) ((Inh_Decl (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_Decl (s1))
sem_Decl_Comment :: (String) ->
                    (T_Decl)
sem_Decl_Comment (txt_) =
    (T_Decl (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     -- "PrintCode.ag"(line 70, column 16)
                     (_lhsOpp@_) =
                         if '\n' `elem` txt_
                           then "{-" >-< vlist (lines txt_) >-< "-}"
                           else "--" >#< txt_
                 in  ( _lhsOpp)))
sem_Decl_Data :: (String) ->
                 (T_DataAlts) ->
                 (Bool) ->
                 ([String]) ->
                 (T_Decl)
sem_Decl_Data (name_) ((T_DataAlts (alts_))) (strict_) (derivings_) =
    (T_Decl (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _altsIpps :: (PP_Docs)
                     _altsOnested :: (Bool)
                     _altsOstrictPre :: (PP_Doc)
                     ( _altsIpps) =
                         (alts_ (_altsOnested) (_altsOstrictPre))
                     -- "PrintCode.ag"(line 58, column 16)
                     (_lhsOpp@_) =
                         "data" >#< name_
                         >#<  ( case _altsIpps of
                                      [] -> empty
                                      (x:xs) ->              "=" >#<  x
                                             >-< vlist (map ("|" >#<) xs)
                                 >-< if null derivings_
                                        then empty
                                        else "deriving" >#< ppTuple False (map text derivings_)
                              )
                     -- "PrintCode.ag"(line 142, column 10)
                     (_altsOstrictPre@_) =
                         if strict_ then pp "!" else empty
                     -- copy rule (down)
                     (_altsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Decl_Decl :: (T_Lhs) ->
                 (T_Expr) ->
                 (T_Decl)
sem_Decl_Decl ((T_Lhs (left_))) ((T_Expr (rhs_))) =
    (T_Decl (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _leftIpp :: (PP_Doc)
                     _leftOnested :: (Bool)
                     _rhsIpp :: (PP_Doc)
                     _rhsOnested :: (Bool)
                     ( _leftIpp) =
                         (left_ (_leftOnested))
                     ( _rhsIpp) =
                         (rhs_ (_rhsOnested))
                     -- "PrintCode.ag"(line 56, column 16)
                     (_lhsOpp@_) =
                         _leftIpp >#< "="
                         >-< indent 4 _rhsIpp
                     -- copy rule (down)
                     (_leftOnested@_) =
                         _lhsInested
                     -- copy rule (down)
                     (_rhsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Decl_NewType :: (String) ->
                    (String) ->
                    (T_Type) ->
                    (T_Decl)
sem_Decl_NewType (name_) (con_) ((T_Type (tp_))) =
    (T_Decl (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _tpIpp :: (PP_Doc)
                     _tpIprec :: (Int)
                     _tpOnested :: (Bool)
                     ( _tpIpp,_tpIprec) =
                         (tp_ (_tpOnested))
                     -- "PrintCode.ag"(line 67, column 16)
                     (_lhsOpp@_) =
                         "newtype" >#< name_ >#< "=" >#< con_ >#< pp_parens _tpIpp
                     -- copy rule (down)
                     (_tpOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Decl_TSig :: (String) ->
                 (T_Type) ->
                 (T_Decl)
sem_Decl_TSig (name_) ((T_Type (tp_))) =
    (T_Decl (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _tpIpp :: (PP_Doc)
                     _tpIprec :: (Int)
                     _tpOnested :: (Bool)
                     ( _tpIpp,_tpIprec) =
                         (tp_ (_tpOnested))
                     -- "PrintCode.ag"(line 69, column 16)
                     (_lhsOpp@_) =
                         name_ >#< "::" >#< _tpIpp
                     -- copy rule (down)
                     (_tpOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Decl_Type :: (String) ->
                 (T_Type) ->
                 (T_Decl)
sem_Decl_Type (name_) ((T_Type (tp_))) =
    (T_Decl (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _tpIpp :: (PP_Doc)
                     _tpIprec :: (Int)
                     _tpOnested :: (Bool)
                     ( _tpIpp,_tpIprec) =
                         (tp_ (_tpOnested))
                     -- "PrintCode.ag"(line 68, column 16)
                     (_lhsOpp@_) =
                         "type" >#< name_ >#< "=" >#<  _tpIpp
                     -- copy rule (down)
                     (_tpOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
-- Decls -------------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pps                  : PP_Docs

-}
{-
   local variables for Decls.Cons:

-}
{-
   local variables for Decls.Nil:

-}
-- semantic domain
newtype T_Decls = T_Decls ((Bool) ->
                           ( (PP_Docs)))
-- cata
sem_Decls :: (Decls) ->
             (T_Decls)
sem_Decls (list) =
    (Prelude.foldr (sem_Decls_Cons) (sem_Decls_Nil) ((Prelude.map sem_Decl list)))
data Inh_Decls = Inh_Decls {nested_Inh_Decls :: Bool}
data Syn_Decls = Syn_Decls {pps_Syn_Decls :: PP_Docs}
wrap_Decls :: (T_Decls) ->
              (Inh_Decls) ->
              (Syn_Decls)
wrap_Decls ((T_Decls (sem))) ((Inh_Decls (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_Decls (s1))
sem_Decls_Cons :: (T_Decl) ->
                  (T_Decls) ->
                  (T_Decls)
sem_Decls_Cons ((T_Decl (hd_))) ((T_Decls (tl_))) =
    (T_Decls (\ _lhsInested ->
                  let _lhsOpps :: (PP_Docs)
                      _hdIpp :: (PP_Doc)
                      _hdOnested :: (Bool)
                      _tlIpps :: (PP_Docs)
                      _tlOnested :: (Bool)
                      ( _hdIpp) =
                          (hd_ (_hdOnested))
                      ( _tlIpps) =
                          (tl_ (_tlOnested))
                      -- "PrintCode.ag"(line 46, column 10)
                      (_lhsOpps@_) =
                          _hdIpp : _tlIpps
                      -- copy rule (down)
                      (_hdOnested@_) =
                          _lhsInested
                      -- copy rule (down)
                      (_tlOnested@_) =
                          _lhsInested
                  in  ( _lhsOpps)))
sem_Decls_Nil :: (T_Decls)
sem_Decls_Nil  =
    (T_Decls (\ _lhsInested ->
                  let _lhsOpps :: (PP_Docs)
                      -- "PrintCode.ag"(line 47, column 10)
                      (_lhsOpps@_) =
                          []
                  in  ( _lhsOpps)))
-- Expr --------------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pp                   : PP_Doc

-}
{-
   local variables for Expr.App:

-}
{-
   local variables for Expr.Case:

-}
{-
   local variables for Expr.Lambda:

-}
{-
   local variables for Expr.Let:

-}
{-
   local variables for Expr.SimpleExpr:

-}
{-
   local variables for Expr.TextExpr:

-}
{-
   local variables for Expr.TupleExpr:

-}
{-
   local variables for Expr.UnboxedTupleExpr:

-}
-- semantic domain
newtype T_Expr = T_Expr ((Bool) ->
                         ( (PP_Doc)))
-- cata
sem_Expr :: (Expr) ->
            (T_Expr)
sem_Expr ((App (_name) (_args))) =
    (sem_Expr_App (_name) ((sem_Exprs (_args))))
sem_Expr ((Case (_expr) (_alts))) =
    (sem_Expr_Case ((sem_Expr (_expr))) ((sem_CaseAlts (_alts))))
sem_Expr ((Lambda (_args) (_body))) =
    (sem_Expr_Lambda (_args) ((sem_Expr (_body))))
sem_Expr ((Let (_decls) (_body))) =
    (sem_Expr_Let ((sem_Decls (_decls))) ((sem_Expr (_body))))
sem_Expr ((SimpleExpr (_txt))) =
    (sem_Expr_SimpleExpr (_txt))
sem_Expr ((TextExpr (_lns))) =
    (sem_Expr_TextExpr (_lns))
sem_Expr ((TupleExpr (_exprs))) =
    (sem_Expr_TupleExpr ((sem_Exprs (_exprs))))
sem_Expr ((UnboxedTupleExpr (_exprs))) =
    (sem_Expr_UnboxedTupleExpr ((sem_Exprs (_exprs))))
data Inh_Expr = Inh_Expr {nested_Inh_Expr :: Bool}
data Syn_Expr = Syn_Expr {pp_Syn_Expr :: PP_Doc}
wrap_Expr :: (T_Expr) ->
             (Inh_Expr) ->
             (Syn_Expr)
wrap_Expr ((T_Expr (sem))) ((Inh_Expr (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_Expr (s1))
sem_Expr_App :: (String) ->
                (T_Exprs) ->
                (T_Expr)
sem_Expr_App (name_) ((T_Exprs (args_))) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _argsIpps :: (PP_Docs)
                     _argsOnested :: (Bool)
                     ( _argsIpps) =
                         (args_ (_argsOnested))
                     -- "PrintCode.ag"(line 86, column 16)
                     (_lhsOpp@_) =
                         pp_parens $ name_ >#< hv_sp _argsIpps
                     -- copy rule (down)
                     (_argsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Expr_Case :: (T_Expr) ->
                 (T_CaseAlts) ->
                 (T_Expr)
sem_Expr_Case ((T_Expr (expr_))) ((T_CaseAlts (alts_))) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _exprIpp :: (PP_Doc)
                     _exprOnested :: (Bool)
                     _altsIpps :: (PP_Docs)
                     _altsOnested :: (Bool)
                     ( _exprIpp) =
                         (expr_ (_exprOnested))
                     ( _altsIpps) =
                         (alts_ (_altsOnested))
                     -- "PrintCode.ag"(line 78, column 16)
                     (_lhsOpp@_) =
                         pp_parens (    "case" >#< pp_parens _exprIpp >#< "of"
                                   >-< (vlist _altsIpps)
                                   )
                     -- copy rule (down)
                     (_exprOnested@_) =
                         _lhsInested
                     -- copy rule (down)
                     (_altsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Expr_Lambda :: ([String]) ->
                   (T_Expr) ->
                   (T_Expr)
sem_Expr_Lambda (args_) ((T_Expr (body_))) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _bodyIpp :: (PP_Doc)
                     _bodyOnested :: (Bool)
                     ( _bodyIpp) =
                         (body_ (_bodyOnested))
                     -- "PrintCode.ag"(line 81, column 16)
                     (_lhsOpp@_) =
                         pp_parens (    "\\" >#< (vlist args_) >#< "->"
                                   >-< indent 4 _bodyIpp
                                   )
                     -- copy rule (down)
                     (_bodyOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Expr_Let :: (T_Decls) ->
                (T_Expr) ->
                (T_Expr)
sem_Expr_Let ((T_Decls (decls_))) ((T_Expr (body_))) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _declsIpps :: (PP_Docs)
                     _declsOnested :: (Bool)
                     _bodyIpp :: (PP_Doc)
                     _bodyOnested :: (Bool)
                     ( _declsIpps) =
                         (decls_ (_declsOnested))
                     ( _bodyIpp) =
                         (body_ (_bodyOnested))
                     -- "PrintCode.ag"(line 75, column 16)
                     (_lhsOpp@_) =
                         pp_parens (    "let" >#< (vlist _declsIpps)
                                   >-< "in " >#< _bodyIpp
                                   )
                     -- copy rule (down)
                     (_declsOnested@_) =
                         _lhsInested
                     -- copy rule (down)
                     (_bodyOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Expr_SimpleExpr :: (String) ->
                       (T_Expr)
sem_Expr_SimpleExpr (txt_) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     -- "PrintCode.ag"(line 87, column 16)
                     (_lhsOpp@_) =
                         text txt_
                 in  ( _lhsOpp)))
sem_Expr_TextExpr :: ([String]) ->
                     (T_Expr)
sem_Expr_TextExpr (lns_) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     -- "PrintCode.ag"(line 88, column 16)
                     (_lhsOpp@_) =
                         vlist (map text lns_)
                 in  ( _lhsOpp)))
sem_Expr_TupleExpr :: (T_Exprs) ->
                      (T_Expr)
sem_Expr_TupleExpr ((T_Exprs (exprs_))) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _exprsIpps :: (PP_Docs)
                     _exprsOnested :: (Bool)
                     ( _exprsIpps) =
                         (exprs_ (_exprsOnested))
                     -- "PrintCode.ag"(line 84, column 16)
                     (_lhsOpp@_) =
                         ppTuple _lhsInested _exprsIpps
                     -- copy rule (down)
                     (_exprsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
sem_Expr_UnboxedTupleExpr :: (T_Exprs) ->
                             (T_Expr)
sem_Expr_UnboxedTupleExpr ((T_Exprs (exprs_))) =
    (T_Expr (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _exprsIpps :: (PP_Docs)
                     _exprsOnested :: (Bool)
                     ( _exprsIpps) =
                         (exprs_ (_exprsOnested))
                     -- "PrintCode.ag"(line 85, column 23)
                     (_lhsOpp@_) =
                         ppUnboxedTuple _lhsInested _exprsIpps
                     -- copy rule (down)
                     (_exprsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp)))
-- Exprs -------------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pps                  : PP_Docs

-}
{-
   local variables for Exprs.Cons:

-}
{-
   local variables for Exprs.Nil:

-}
-- semantic domain
newtype T_Exprs = T_Exprs ((Bool) ->
                           ( (PP_Docs)))
-- cata
sem_Exprs :: (Exprs) ->
             (T_Exprs)
sem_Exprs (list) =
    (Prelude.foldr (sem_Exprs_Cons) (sem_Exprs_Nil) ((Prelude.map sem_Expr list)))
data Inh_Exprs = Inh_Exprs {nested_Inh_Exprs :: Bool}
data Syn_Exprs = Syn_Exprs {pps_Syn_Exprs :: PP_Docs}
wrap_Exprs :: (T_Exprs) ->
              (Inh_Exprs) ->
              (Syn_Exprs)
wrap_Exprs ((T_Exprs (sem))) ((Inh_Exprs (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_Exprs (s1))
sem_Exprs_Cons :: (T_Expr) ->
                  (T_Exprs) ->
                  (T_Exprs)
sem_Exprs_Cons ((T_Expr (hd_))) ((T_Exprs (tl_))) =
    (T_Exprs (\ _lhsInested ->
                  let _lhsOpps :: (PP_Docs)
                      _hdIpp :: (PP_Doc)
                      _hdOnested :: (Bool)
                      _tlIpps :: (PP_Docs)
                      _tlOnested :: (Bool)
                      ( _hdIpp) =
                          (hd_ (_hdOnested))
                      ( _tlIpps) =
                          (tl_ (_tlOnested))
                      -- "PrintCode.ag"(line 30, column 10)
                      (_lhsOpps@_) =
                          _hdIpp : _tlIpps
                      -- copy rule (down)
                      (_hdOnested@_) =
                          _lhsInested
                      -- copy rule (down)
                      (_tlOnested@_) =
                          _lhsInested
                  in  ( _lhsOpps)))
sem_Exprs_Nil :: (T_Exprs)
sem_Exprs_Nil  =
    (T_Exprs (\ _lhsInested ->
                  let _lhsOpps :: (PP_Docs)
                      -- "PrintCode.ag"(line 31, column 10)
                      (_lhsOpps@_) =
                          []
                  in  ( _lhsOpps)))
-- Lhs ---------------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pp                   : PP_Doc

-}
{-
   local variables for Lhs.Fun:

-}
{-
   local variables for Lhs.Pattern3:

-}
{-
   local variables for Lhs.Pattern3SM:

-}
{-
   local variables for Lhs.TupleLhs:

-}
{-
   local variables for Lhs.UnboxedTupleLhs:

-}
-- semantic domain
newtype T_Lhs = T_Lhs ((Bool) ->
                       ( (PP_Doc)))
-- cata
sem_Lhs :: (Lhs) ->
           (T_Lhs)
sem_Lhs ((Fun (_name) (_args))) =
    (sem_Lhs_Fun (_name) ((sem_Exprs (_args))))
sem_Lhs ((Pattern3 (_pat3))) =
    (sem_Lhs_Pattern3 ((sem_Pattern (_pat3))))
sem_Lhs ((Pattern3SM (_pat3))) =
    (sem_Lhs_Pattern3SM ((sem_Pattern (_pat3))))
sem_Lhs ((TupleLhs (_comps))) =
    (sem_Lhs_TupleLhs (_comps))
sem_Lhs ((UnboxedTupleLhs (_comps))) =
    (sem_Lhs_UnboxedTupleLhs (_comps))
data Inh_Lhs = Inh_Lhs {nested_Inh_Lhs :: Bool}
data Syn_Lhs = Syn_Lhs {pp_Syn_Lhs :: PP_Doc}
wrap_Lhs :: (T_Lhs) ->
            (Inh_Lhs) ->
            (Syn_Lhs)
wrap_Lhs ((T_Lhs (sem))) ((Inh_Lhs (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_Lhs (s1))
sem_Lhs_Fun :: (String) ->
               (T_Exprs) ->
               (T_Lhs)
sem_Lhs_Fun (name_) ((T_Exprs (args_))) =
    (T_Lhs (\ _lhsInested ->
                let _lhsOpp :: (PP_Doc)
                    _argsIpps :: (PP_Docs)
                    _argsOnested :: (Bool)
                    ( _argsIpps) =
                        (args_ (_argsOnested))
                    -- "PrintCode.ag"(line 102, column 16)
                    (_lhsOpp@_) =
                        name_ >#< hv_sp _argsIpps
                    -- copy rule (down)
                    (_argsOnested@_) =
                        _lhsInested
                in  ( _lhsOpp)))
sem_Lhs_Pattern3 :: (T_Pattern) ->
                    (T_Lhs)
sem_Lhs_Pattern3 ((T_Pattern (pat3_))) =
    (T_Lhs (\ _lhsInested ->
                let _lhsOpp :: (PP_Doc)
                    _pat3Icopy :: (Pattern)
                    _pat3IisUnderscore :: (Bool)
                    _pat3Ipp :: (PP_Doc)
                    _pat3Ipp' :: (PP_Doc)
                    ( _pat3Icopy,_pat3IisUnderscore,_pat3Ipp,_pat3Ipp') =
                        (pat3_ )
                    -- "PrintCode.ag"(line 98, column 16)
                    (_lhsOpp@_) =
                        _pat3Ipp
                in  ( _lhsOpp)))
sem_Lhs_Pattern3SM :: (T_Pattern) ->
                      (T_Lhs)
sem_Lhs_Pattern3SM ((T_Pattern (pat3_))) =
    (T_Lhs (\ _lhsInested ->
                let _lhsOpp :: (PP_Doc)
                    _pat3Icopy :: (Pattern)
                    _pat3IisUnderscore :: (Bool)
                    _pat3Ipp :: (PP_Doc)
                    _pat3Ipp' :: (PP_Doc)
                    ( _pat3Icopy,_pat3IisUnderscore,_pat3Ipp,_pat3Ipp') =
                        (pat3_ )
                    -- "PrintCode.ag"(line 99, column 16)
                    (_lhsOpp@_) =
                        _pat3Ipp'
                in  ( _lhsOpp)))
sem_Lhs_TupleLhs :: ([String]) ->
                    (T_Lhs)
sem_Lhs_TupleLhs (comps_) =
    (T_Lhs (\ _lhsInested ->
                let _lhsOpp :: (PP_Doc)
                    -- "PrintCode.ag"(line 100, column 16)
                    (_lhsOpp@_) =
                        ppTuple _lhsInested (map text comps_)
                in  ( _lhsOpp)))
sem_Lhs_UnboxedTupleLhs :: ([String]) ->
                           (T_Lhs)
sem_Lhs_UnboxedTupleLhs (comps_) =
    (T_Lhs (\ _lhsInested ->
                let _lhsOpp :: (PP_Doc)
                    -- "PrintCode.ag"(line 101, column 23)
                    (_lhsOpp@_) =
                        ppUnboxedTuple _lhsInested (map text comps_)
                in  ( _lhsOpp)))
-- Pattern -----------------------------------------------------
{-
   inherited attributes:

   chained attributes:

   synthesised attributes:
      copy                 : SELF
      isUnderscore         : Bool
      pp                   : PP_Doc
      pp'                  : PP_Doc

-}
{-
   local variables for Pattern.Alias:
      copy

-}
{-
   local variables for Pattern.Constr:
      copy

-}
{-
   local variables for Pattern.Product:
      copy

-}
{-
   local variables for Pattern.Underscore:
      copy

-}
-- semantic domain
newtype T_Pattern = T_Pattern (( (Pattern),(Bool),(PP_Doc),(PP_Doc)))
-- cata
sem_Pattern :: (Pattern) ->
               (T_Pattern)
sem_Pattern ((Alias (_field) (_attr) (_pat))) =
    (sem_Pattern_Alias (_field) (_attr) ((sem_Pattern (_pat))))
sem_Pattern ((Constr (_name) (_pats))) =
    (sem_Pattern_Constr (_name) ((sem_Patterns (_pats))))
sem_Pattern ((Product (_pos) (_pats))) =
    (sem_Pattern_Product (_pos) ((sem_Patterns (_pats))))
sem_Pattern ((Underscore (_pos))) =
    (sem_Pattern_Underscore (_pos))
data Inh_Pattern = Inh_Pattern {}
data Syn_Pattern = Syn_Pattern {copy_Syn_Pattern :: Pattern,isUnderscore_Syn_Pattern :: Bool,pp_Syn_Pattern :: PP_Doc,pp'_Syn_Pattern :: PP_Doc}
wrap_Pattern :: (T_Pattern) ->
                (Inh_Pattern) ->
                (Syn_Pattern)
wrap_Pattern ((T_Pattern (sem))) ((Inh_Pattern )) =
    let ( s1,s2,s3,s4) =
            (sem )
    in  (Syn_Pattern (s1) (s2) (s3) (s4))
sem_Pattern_Alias :: (Name) ->
                     (Name) ->
                     (T_Pattern) ->
                     (T_Pattern)
sem_Pattern_Alias (field_) (attr_) ((T_Pattern (pat_))) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOisUnderscore :: (Bool)
                    _lhsOpp :: (PP_Doc)
                    _lhsOpp' :: (PP_Doc)
                    _patIcopy :: (Pattern)
                    _patIisUnderscore :: (Bool)
                    _patIpp :: (PP_Doc)
                    _patIpp' :: (PP_Doc)
                    ( _patIcopy,_patIisUnderscore,_patIpp,_patIpp') =
                        (pat_ )
                    -- "PrintCode.ag"(line 155, column 13)
                    (_lhsOpp@_) =
                        if _patIisUnderscore
                         then attrname False field_ attr_ >|< ""
                         else attrname False field_ attr_ >|< "@" >|< _patIpp
                    -- "PrintCode.ag"(line 163, column 15)
                    (_lhsOisUnderscore@_) =
                        False
                    -- "PrintCode.ag"(line 177, column 13)
                    (_lhsOpp'@_) =
                        let attribute | field_ == _LOC || field_ == nullIdent = locname' attr_
                                      | otherwise                             = attrname False field_ attr_
                        in attribute >|< "@" >|< _patIpp'
                    -- self rule
                    (_copy@_) =
                        Alias field_ attr_ _patIcopy
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOisUnderscore,_lhsOpp,_lhsOpp')))
sem_Pattern_Constr :: (Constructor) ->
                      (T_Patterns) ->
                      (T_Pattern)
sem_Pattern_Constr (name_) ((T_Patterns (pats_))) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOisUnderscore :: (Bool)
                    _lhsOpp :: (PP_Doc)
                    _lhsOpp' :: (PP_Doc)
                    _patsIcopy :: (Patterns)
                    _patsIpps :: ([PP_Doc])
                    _patsIpps' :: ([PP_Doc])
                    ( _patsIcopy,_patsIpps,_patsIpps') =
                        (pats_ )
                    -- "PrintCode.ag"(line 153, column 13)
                    (_lhsOpp@_) =
                        pp_parens $ name_ >#< hv_sp _patsIpps
                    -- "PrintCode.ag"(line 161, column 15)
                    (_lhsOisUnderscore@_) =
                        False
                    -- "PrintCode.ag"(line 175, column 13)
                    (_lhsOpp'@_) =
                        pp_parens $ name_ >#< hv_sp (map pp_parens _patsIpps')
                    -- self rule
                    (_copy@_) =
                        Constr name_ _patsIcopy
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOisUnderscore,_lhsOpp,_lhsOpp')))
sem_Pattern_Product :: (Pos) ->
                       (T_Patterns) ->
                       (T_Pattern)
sem_Pattern_Product (pos_) ((T_Patterns (pats_))) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOisUnderscore :: (Bool)
                    _lhsOpp :: (PP_Doc)
                    _lhsOpp' :: (PP_Doc)
                    _patsIcopy :: (Patterns)
                    _patsIpps :: ([PP_Doc])
                    _patsIpps' :: ([PP_Doc])
                    ( _patsIcopy,_patsIpps,_patsIpps') =
                        (pats_ )
                    -- "PrintCode.ag"(line 154, column 13)
                    (_lhsOpp@_) =
                        pp_block "(" ")" "," _patsIpps
                    -- "PrintCode.ag"(line 162, column 15)
                    (_lhsOisUnderscore@_) =
                        False
                    -- "PrintCode.ag"(line 176, column 13)
                    (_lhsOpp'@_) =
                        pp_block "(" ")" "," _patsIpps'
                    -- self rule
                    (_copy@_) =
                        Product pos_ _patsIcopy
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOisUnderscore,_lhsOpp,_lhsOpp')))
sem_Pattern_Underscore :: (Pos) ->
                          (T_Pattern)
sem_Pattern_Underscore (pos_) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOisUnderscore :: (Bool)
                    _lhsOpp :: (PP_Doc)
                    _lhsOpp' :: (PP_Doc)
                    -- "PrintCode.ag"(line 158, column 16)
                    (_lhsOpp@_) =
                        text "_"
                    -- "PrintCode.ag"(line 164, column 15)
                    (_lhsOisUnderscore@_) =
                        True
                    -- "PrintCode.ag"(line 180, column 16)
                    (_lhsOpp'@_) =
                        text "_"
                    -- self rule
                    (_copy@_) =
                        Underscore pos_
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOisUnderscore,_lhsOpp,_lhsOpp')))
-- Patterns ----------------------------------------------------
{-
   inherited attributes:

   chained attributes:

   synthesised attributes:
      copy                 : SELF
      pps                  : [PP_Doc]
      pps'                 : [PP_Doc]

-}
{-
   local variables for Patterns.Cons:
      copy

-}
{-
   local variables for Patterns.Nil:
      copy

-}
-- semantic domain
newtype T_Patterns = T_Patterns (( (Patterns),([PP_Doc]),([PP_Doc])))
-- cata
sem_Patterns :: (Patterns) ->
                (T_Patterns)
sem_Patterns (list) =
    (Prelude.foldr (sem_Patterns_Cons) (sem_Patterns_Nil) ((Prelude.map sem_Pattern list)))
data Inh_Patterns = Inh_Patterns {}
data Syn_Patterns = Syn_Patterns {copy_Syn_Patterns :: Patterns,pps_Syn_Patterns :: [PP_Doc],pps'_Syn_Patterns :: [PP_Doc]}
wrap_Patterns :: (T_Patterns) ->
                 (Inh_Patterns) ->
                 (Syn_Patterns)
wrap_Patterns ((T_Patterns (sem))) ((Inh_Patterns )) =
    let ( s1,s2,s3) =
            (sem )
    in  (Syn_Patterns (s1) (s2) (s3))
sem_Patterns_Cons :: (T_Pattern) ->
                     (T_Patterns) ->
                     (T_Patterns)
sem_Patterns_Cons ((T_Pattern (hd_))) ((T_Patterns (tl_))) =
    (T_Patterns (let _lhsOcopy :: (Patterns)
                     _lhsOpps :: ([PP_Doc])
                     _lhsOpps' :: ([PP_Doc])
                     _hdIcopy :: (Pattern)
                     _hdIisUnderscore :: (Bool)
                     _hdIpp :: (PP_Doc)
                     _hdIpp' :: (PP_Doc)
                     _tlIcopy :: (Patterns)
                     _tlIpps :: ([PP_Doc])
                     _tlIpps' :: ([PP_Doc])
                     ( _hdIcopy,_hdIisUnderscore,_hdIpp,_hdIpp') =
                         (hd_ )
                     ( _tlIcopy,_tlIpps,_tlIpps') =
                         (tl_ )
                     -- "PrintCode.ag"(line 149, column 10)
                     (_lhsOpps@_) =
                         _hdIpp : _tlIpps
                     -- "PrintCode.ag"(line 171, column 10)
                     (_lhsOpps'@_) =
                         _hdIpp' : _tlIpps'
                     -- self rule
                     (_copy@_) =
                         (:) _hdIcopy _tlIcopy
                     -- self rule
                     (_lhsOcopy@_) =
                         _copy
                 in  ( _lhsOcopy,_lhsOpps,_lhsOpps')))
sem_Patterns_Nil :: (T_Patterns)
sem_Patterns_Nil  =
    (T_Patterns (let _lhsOcopy :: (Patterns)
                     _lhsOpps :: ([PP_Doc])
                     _lhsOpps' :: ([PP_Doc])
                     -- "PrintCode.ag"(line 150, column 10)
                     (_lhsOpps@_) =
                         []
                     -- "PrintCode.ag"(line 172, column 10)
                     (_lhsOpps'@_) =
                         []
                     -- self rule
                     (_copy@_) =
                         []
                     -- self rule
                     (_lhsOcopy@_) =
                         _copy
                 in  ( _lhsOcopy,_lhsOpps,_lhsOpps')))
-- Program -----------------------------------------------------
{-
   inherited attributes:
      options              : Options

   chained attributes:

   synthesised attributes:
      output               : PP_Docs

-}
{-
   local variables for Program.Program:

-}
-- semantic domain
newtype T_Program = T_Program ((Options) ->
                               ( (PP_Docs)))
-- cata
sem_Program :: (Program) ->
               (T_Program)
sem_Program ((Program (_decls))) =
    (sem_Program_Program ((sem_Decls (_decls))))
data Inh_Program = Inh_Program {options_Inh_Program :: Options}
data Syn_Program = Syn_Program {output_Syn_Program :: PP_Docs}
wrap_Program :: (T_Program) ->
                (Inh_Program) ->
                (Syn_Program)
wrap_Program ((T_Program (sem))) ((Inh_Program (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_Program (s1))
sem_Program_Program :: (T_Decls) ->
                       (T_Program)
sem_Program_Program ((T_Decls (decls_))) =
    (T_Program (\ _lhsIoptions ->
                    let _lhsOoutput :: (PP_Docs)
                        _declsIpps :: (PP_Docs)
                        _declsOnested :: (Bool)
                        ( _declsIpps) =
                            (decls_ (_declsOnested))
                        -- "PrintCode.ag"(line 27, column 13)
                        (_declsOnested@_) =
                            nest _lhsIoptions
                        -- "PrintCode.ag"(line 53, column 16)
                        (_lhsOoutput@_) =
                            _declsIpps
                    in  ( _lhsOoutput)))
-- Type --------------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pp                   : PP_Doc
      prec                 : Int

-}
{-
   local variables for Type.Arr:
      r
      l

-}
{-
   local variables for Type.List:

-}
{-
   local variables for Type.SimpleType:

-}
{-
   local variables for Type.TupleType:

-}
{-
   local variables for Type.UnboxedTupleType:

-}
-- semantic domain
newtype T_Type = T_Type ((Bool) ->
                         ( (PP_Doc),(Int)))
-- cata
sem_Type :: (Type) ->
            (T_Type)
sem_Type ((Arr (_left) (_right))) =
    (sem_Type_Arr ((sem_Type (_left))) ((sem_Type (_right))))
sem_Type ((List (_tp))) =
    (sem_Type_List ((sem_Type (_tp))))
sem_Type ((SimpleType (_txt))) =
    (sem_Type_SimpleType (_txt))
sem_Type ((TupleType (_tps))) =
    (sem_Type_TupleType ((sem_Types (_tps))))
sem_Type ((UnboxedTupleType (_tps))) =
    (sem_Type_UnboxedTupleType ((sem_Types (_tps))))
data Inh_Type = Inh_Type {nested_Inh_Type :: Bool}
data Syn_Type = Syn_Type {pp_Syn_Type :: PP_Doc,prec_Syn_Type :: Int}
wrap_Type :: (T_Type) ->
             (Inh_Type) ->
             (Syn_Type)
wrap_Type ((T_Type (sem))) ((Inh_Type (i1))) =
    let ( s1,s2) =
            (sem (i1))
    in  (Syn_Type (s1) (s2))
sem_Type_Arr :: (T_Type) ->
                (T_Type) ->
                (T_Type)
sem_Type_Arr ((T_Type (left_))) ((T_Type (right_))) =
    (T_Type (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _lhsOprec :: (Int)
                     _leftIpp :: (PP_Doc)
                     _leftIprec :: (Int)
                     _leftOnested :: (Bool)
                     _rightIpp :: (PP_Doc)
                     _rightIprec :: (Int)
                     _rightOnested :: (Bool)
                     ( _leftIpp,_leftIprec) =
                         (left_ (_leftOnested))
                     ( _rightIpp,_rightIprec) =
                         (right_ (_rightOnested))
                     -- "PrintCode.ag"(line 107, column 16)
                     (_r@_) =
                         if _rightIprec <  2 then pp_parens _rightIpp else _rightIpp
                     -- "PrintCode.ag"(line 107, column 16)
                     (_l@_) =
                         if _leftIprec  <= 2 then pp_parens _leftIpp  else _leftIpp
                     -- "PrintCode.ag"(line 105, column 16)
                     (_lhsOpp@_) =
                         _l     >#< "->" >-< _r
                     -- "PrintCode.ag"(line 105, column 16)
                     (_lhsOprec@_) =
                         2
                     -- copy rule (down)
                     (_leftOnested@_) =
                         _lhsInested
                     -- copy rule (down)
                     (_rightOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp,_lhsOprec)))
sem_Type_List :: (T_Type) ->
                 (T_Type)
sem_Type_List ((T_Type (tp_))) =
    (T_Type (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _lhsOprec :: (Int)
                     _tpIpp :: (PP_Doc)
                     _tpIprec :: (Int)
                     _tpOnested :: (Bool)
                     ( _tpIpp,_tpIprec) =
                         (tp_ (_tpOnested))
                     -- "PrintCode.ag"(line 116, column 16)
                     (_lhsOpp@_) =
                         "[" >|< _tpIpp >|< "]"
                     -- "PrintCode.ag"(line 116, column 16)
                     (_lhsOprec@_) =
                         5
                     -- copy rule (down)
                     (_tpOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp,_lhsOprec)))
sem_Type_SimpleType :: (String) ->
                       (T_Type)
sem_Type_SimpleType (txt_) =
    (T_Type (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _lhsOprec :: (Int)
                     -- "PrintCode.ag"(line 119, column 16)
                     (_lhsOpp@_) =
                         if reallySimple txt_ then text txt_ else pp_parens (text txt_)
                     -- "PrintCode.ag"(line 119, column 16)
                     (_lhsOprec@_) =
                         5
                 in  ( _lhsOpp,_lhsOprec)))
sem_Type_TupleType :: (T_Types) ->
                      (T_Type)
sem_Type_TupleType ((T_Types (tps_))) =
    (T_Type (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _lhsOprec :: (Int)
                     _tpsIpps :: (PP_Docs)
                     _tpsOnested :: (Bool)
                     ( _tpsIpps) =
                         (tps_ (_tpsOnested))
                     -- "PrintCode.ag"(line 110, column 16)
                     (_lhsOpp@_) =
                         ppTuple _lhsInested _tpsIpps
                     -- "PrintCode.ag"(line 110, column 16)
                     (_lhsOprec@_) =
                         5
                     -- copy rule (down)
                     (_tpsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp,_lhsOprec)))
sem_Type_UnboxedTupleType :: (T_Types) ->
                             (T_Type)
sem_Type_UnboxedTupleType ((T_Types (tps_))) =
    (T_Type (\ _lhsInested ->
                 let _lhsOpp :: (PP_Doc)
                     _lhsOprec :: (Int)
                     _tpsIpps :: (PP_Docs)
                     _tpsOnested :: (Bool)
                     ( _tpsIpps) =
                         (tps_ (_tpsOnested))
                     -- "PrintCode.ag"(line 113, column 23)
                     (_lhsOpp@_) =
                         ppUnboxedTuple _lhsInested _tpsIpps
                     -- "PrintCode.ag"(line 113, column 23)
                     (_lhsOprec@_) =
                         5
                     -- copy rule (down)
                     (_tpsOnested@_) =
                         _lhsInested
                 in  ( _lhsOpp,_lhsOprec)))
-- Types -------------------------------------------------------
{-
   inherited attributes:
      nested               : Bool

   chained attributes:

   synthesised attributes:
      pps                  : PP_Docs

-}
{-
   local variables for Types.Cons:

-}
{-
   local variables for Types.Nil:

-}
-- semantic domain
newtype T_Types = T_Types ((Bool) ->
                           ( (PP_Docs)))
-- cata
sem_Types :: (Types) ->
             (T_Types)
sem_Types (list) =
    (Prelude.foldr (sem_Types_Cons) (sem_Types_Nil) ((Prelude.map sem_Type list)))
data Inh_Types = Inh_Types {nested_Inh_Types :: Bool}
data Syn_Types = Syn_Types {pps_Syn_Types :: PP_Docs}
wrap_Types :: (T_Types) ->
              (Inh_Types) ->
              (Syn_Types)
wrap_Types ((T_Types (sem))) ((Inh_Types (i1))) =
    let ( s1) =
            (sem (i1))
    in  (Syn_Types (s1))
sem_Types_Cons :: (T_Type) ->
                  (T_Types) ->
                  (T_Types)
sem_Types_Cons ((T_Type (hd_))) ((T_Types (tl_))) =
    (T_Types (\ _lhsInested ->
                  let _lhsOpps :: (PP_Docs)
                      _hdIpp :: (PP_Doc)
                      _hdIprec :: (Int)
                      _hdOnested :: (Bool)
                      _tlIpps :: (PP_Docs)
                      _tlOnested :: (Bool)
                      ( _hdIpp,_hdIprec) =
                          (hd_ (_hdOnested))
                      ( _tlIpps) =
                          (tl_ (_tlOnested))
                      -- "PrintCode.ag"(line 42, column 10)
                      (_lhsOpps@_) =
                          _hdIpp : _tlIpps
                      -- copy rule (down)
                      (_hdOnested@_) =
                          _lhsInested
                      -- copy rule (down)
                      (_tlOnested@_) =
                          _lhsInested
                  in  ( _lhsOpps)))
sem_Types_Nil :: (T_Types)
sem_Types_Nil  =
    (T_Types (\ _lhsInested ->
                  let _lhsOpps :: (PP_Docs)
                      -- "PrintCode.ag"(line 43, column 10)
                      (_lhsOpps@_) =
                          []
                  in  ( _lhsOpps)))


