-- do not edit; automatically generated by UU.AG
module PrintErrorMessages where

import UU.Pretty
import UU.Scanner.Position(Pos(..), noPos)
import ErrorMessages
import DepTypes
import Options (Options,verbose)
import Data.List(mapAccumL,intersect,(\\))
import GrammarInfo

import UU.Scanner.Position(Pos)
import UU.Pretty(PP_Doc)
import DepTypes(Trace)
import CodeSyntax
import CommonTypes

ppTrace :: Trace -> PP_Doc
ppTrace (tr:rest) = wfill [showLineNr (lineNr tr) ++ ":", "SEM", getName (nt tr), "|", getName (prod tr)
                         , lhsFld tr +.+ lhsAttr tr, "=", "..." +#+ showRhs tr +#+ "..."]
                    >-< ppTrace rest
ppTrace [] = empty

showRhs :: TraceElem -> String
showRhs tr = if null (getName field)
             then "@" ++ getName attr
             else "@" ++ (field +.+ attr)
 where field = rhsFld tr
       attr  = rhsAttr tr
 
showLineNr :: Int -> String
showLineNr i | i==(-1) = "CR"
             | otherwise = show i

showAttrDef f a | f == _LHS = "synthesized attribute " ++ getName a
                | f == _LOC = "local attribute " ++ getName a 
                | otherwise = "inherited attribute " ++ getName a ++ " of field " ++ getName f

showAttrUse f a | f == _LHS = "inherited attribute " ++ getName a
                | f == _LOC = "local attribute " ++ getName a 
                | otherwise = "synthesized attribute " ++ getName a ++ " of field " ++ getName f

ppAttr f a = text (getName f++"."++getName a)
ppAttrUse f a = "@" >|< ppAttr f a

infixr 5 +#+
(+#+) :: String -> String -> String
(+#+) s t = s ++ " " ++ t

infixr 5 +.+
(+.+) :: Identifier -> Identifier -> String
(+.+) s t = getName s ++ "." ++ getName t

wfill = fill . addSpaces. concat . map words
  where addSpaces (x:xs) = x:map addSpace xs
        addSpaces []     = []
        addSpace  [x]    | x `elem` ".,;:!?" = [x]
        addSpace  xs     = ' ':xs

ppError :: Bool           -- class of the error, True:warning False:error
        -> Pos      -- source position
        -> PP_Doc         -- error message
        -> PP_Doc         -- pattern
        -> PP_Doc         -- help, more info
        -> PP_Doc         -- action taken by AG
        -> Bool           -- verbose? show help and action?
        -> PP_Doc
ppError isWarning pos mesg pat hlp act verbose
  = let 
      cl = if isWarning then "warning" else "error"
      position   = case pos of
                         (Pos l c f) | l >= 0    -> f >|< ": line " >|< show l >|< ", column " >|< show c
                                     | otherwise -> empty
      header     = "*** UU.AG" >#< cl >#< position >#< "***"
      message    = "problem  :" >#< mesg
      pattern    = "pattern  :" >#< pat
      help       = "help     :" >#< hlp
      action     = "action   :" >#< act
    in
      if verbose
         then vlist [text "",header,message,pattern,help,action]
         else vlist [text "",header,message]

showPos = show . getPos

ppInterface inter = wfill ["interface:", show inter]

-- Error -------------------------------------------------------
{-
   inherited attributes:
      verbose              : Bool

   chained attributes:

   synthesised attributes:
      isWarning            : Bool
      pp                   : PP_Doc

-}
{-
   local variables for Error.ChildAsLocal:
      isWarning

-}
{-
   local variables for Error.CustomError:

-}
{-
   local variables for Error.CyclicSet:
      isWarning

-}
{-
   local variables for Error.DirectCirc:
      isWarning

-}
{-
   local variables for Error.DupAlt:
      isWarning

-}
{-
   local variables for Error.DupChild:
      isWarning

-}
{-
   local variables for Error.DupInhAttr:
      isWarning

-}
{-
   local variables for Error.DupRule:
      isWarning

-}
{-
   local variables for Error.DupSet:
      isWarning

-}
{-
   local variables for Error.DupSig:
      isWarning

-}
{-
   local variables for Error.DupSynAttr:
      isWarning

-}
{-
   local variables for Error.DupSynonym:
      isWarning

-}
{-
   local variables for Error.InducedCirc:
      isWarning

-}
{-
   local variables for Error.LocLocCirc:
      isWarning

-}
{-
   local variables for Error.MissingRule:
      isWarning

-}
{-
   local variables for Error.MissingTypeSig:
      isWarning

-}
{-
   local variables for Error.ParserError:
      isWarning

-}
{-
   local variables for Error.SuperfluousRule:
      isWarning

-}
{-
   local variables for Error.UndefAlt:
      isWarning

-}
{-
   local variables for Error.UndefAttr:
      isWarning

-}
{-
   local variables for Error.UndefChild:
      isWarning

-}
{-
   local variables for Error.UndefLocal:
      isWarning

-}
{-
   local variables for Error.UndefNont:
      isWarning

-}
-- semantic domain
newtype T_Error = T_Error ((Bool) ->
                           ( (Bool),(PP_Doc)))
-- cata
sem_Error :: (Error) ->
             (T_Error)
sem_Error ((ChildAsLocal (_nt) (_con) (_var))) =
    (sem_Error_ChildAsLocal (_nt) (_con) (_var))
sem_Error ((CustomError (_isWarning) (_pos) (_mesg))) =
    (sem_Error_CustomError (_isWarning) (_pos) (_mesg))
sem_Error ((CyclicSet (_name))) =
    (sem_Error_CyclicSet (_name))
sem_Error ((DirectCirc (_nt) (_inh) (_syn) (_o_visit) (_path))) =
    (sem_Error_DirectCirc (_nt) (_inh) (_syn) (_o_visit) (_path))
sem_Error ((DupAlt (_nt) (_con) (_occ1))) =
    (sem_Error_DupAlt (_nt) (_con) (_occ1))
sem_Error ((DupChild (_nt) (_con) (_name) (_occ1))) =
    (sem_Error_DupChild (_nt) (_con) (_name) (_occ1))
sem_Error ((DupInhAttr (_nt) (_attr) (_occ1))) =
    (sem_Error_DupInhAttr (_nt) (_attr) (_occ1))
sem_Error ((DupRule (_nt) (_con) (_field) (_attr) (_occ1))) =
    (sem_Error_DupRule (_nt) (_con) (_field) (_attr) (_occ1))
sem_Error ((DupSet (_name) (_occ1))) =
    (sem_Error_DupSet (_name) (_occ1))
sem_Error ((DupSig (_nt) (_con) (_attr))) =
    (sem_Error_DupSig (_nt) (_con) (_attr))
sem_Error ((DupSynAttr (_nt) (_attr) (_occ1))) =
    (sem_Error_DupSynAttr (_nt) (_attr) (_occ1))
sem_Error ((DupSynonym (_nt) (_occ1))) =
    (sem_Error_DupSynonym (_nt) (_occ1))
sem_Error ((InducedCirc (_nt) (_inh) (_syn) (_cinter))) =
    (sem_Error_InducedCirc (_nt) (_inh) (_syn) (_cinter))
sem_Error ((LocLocCirc (_nt) (_con) (_attr) (_o_visit) (_path))) =
    (sem_Error_LocLocCirc (_nt) (_con) (_attr) (_o_visit) (_path))
sem_Error ((MissingRule (_nt) (_con) (_field) (_attr))) =
    (sem_Error_MissingRule (_nt) (_con) (_field) (_attr))
sem_Error ((MissingTypeSig (_nt) (_con) (_attr))) =
    (sem_Error_MissingTypeSig (_nt) (_con) (_attr))
sem_Error ((ParserError (_pos) (_problem) (_action))) =
    (sem_Error_ParserError (_pos) (_problem) (_action))
sem_Error ((SuperfluousRule (_nt) (_con) (_field) (_attr))) =
    (sem_Error_SuperfluousRule (_nt) (_con) (_field) (_attr))
sem_Error ((UndefAlt (_nt) (_con))) =
    (sem_Error_UndefAlt (_nt) (_con))
sem_Error ((UndefAttr (_nt) (_con) (_field) (_attr))) =
    (sem_Error_UndefAttr (_nt) (_con) (_field) (_attr))
sem_Error ((UndefChild (_nt) (_con) (_name))) =
    (sem_Error_UndefChild (_nt) (_con) (_name))
sem_Error ((UndefLocal (_nt) (_con) (_var))) =
    (sem_Error_UndefLocal (_nt) (_con) (_var))
sem_Error ((UndefNont (_nt))) =
    (sem_Error_UndefNont (_nt))
data Inh_Error = Inh_Error {verbose_Inh_Error :: Bool}
data Syn_Error = Syn_Error {isWarning_Syn_Error :: Bool,pp_Syn_Error :: PP_Doc}
wrap_Error :: (T_Error) ->
              (Inh_Error) ->
              (Syn_Error)
wrap_Error ((T_Error (sem))) ((Inh_Error (i1))) =
    let ( s1,s2) =
            (sem (i1))
    in  (Syn_Error (s1) (s2))
sem_Error_ChildAsLocal :: (Nonterminal) ->
                          (Constructor) ->
                          (Name) ->
                          (T_Error)
sem_Error_ChildAsLocal (nt_) (con_) (var_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 267, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Nontrivial field ",getName var_, "is used as local at constructor"
                                            , getName con_ , "of nonterminal",getName nt_, "."
                                            ]
                              pat   = "SEM" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< "... = "
                                                      >#< "..." >#< "@" >|< getName var_ >#< "..." )
                              help =  wfill ["A rule in the definitions for alternative" , getName con_ ,"of nonterminal"
                                            , getName nt_ , "contains a nontrivial field name", getName var_, "."
                                            ,"You should use @", getName var_, ".self instead, where self is a SELF-attribute."
                                            ]
                              act  = wfill ["The generated program probably contains a type error or has undefined variables."]
                          in ppError _isWarning (getPos var_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 266, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_CustomError :: (Bool) ->
                         (Pos) ->
                         (PP_Doc) ->
                         (T_Error)
sem_Error_CustomError (isWarning_) (pos_) (mesg_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 311, column 21)
                      (_lhsOisWarning@_) =
                          isWarning_
                      -- "PrintErrorMessages.ag"(line 307, column 21)
                      (_lhsOpp@_) =
                          let pat   =  text "unknown"
                              help = wfill ["not available."]
                              act  = wfill ["unknown"]
                          in ppError isWarning_ pos_ mesg_ pat help act False
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_CyclicSet :: (Name) ->
                       (T_Error)
sem_Error_CyclicSet (name_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 298, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Cyclic definition for nonterminal set", getName name_]
                              pat   = "SET" >#< getName name_ >#< "=" >#< "..." >#< getName name_ >#< "..."
                              help =  wfill ["The defintion for a nonterminal set named" , getName name_
                                            ,"directly or indirectly refers to itself."
                                            ,"Adapt the definition of the nonterminal set, to remove the cyclic dependency."
                                            ]
                              act  = wfill ["The nonterminal set", getName name_, "is considered to be empty."]
                          in ppError _isWarning (getPos name_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 297, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DirectCirc :: (Nonterminal) ->
                        (Name) ->
                        (Name) ->
                        (Bool) ->
                        ([String]) ->
                        (T_Error)
sem_Error_DirectCirc (nt_) (inh_) (syn_) (o_visit_) (path_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 322, column 21)
                      (_lhsOpp@_) =
                          let mesg  = let attrtext = if inh_ == syn_ then "threaded attribute " ++ getName inh_
                                                                     else "inherited attribute " ++ getName inh_ ++ " and synthesized attribute " ++getName  syn_
                                      in wfill ["Direct circular dependency pattern for", attrtext, "of nonterminal", getName nt_]
                              pat   = text "see help"
                              help  = vlist ("The following attributes formed the cycle:": path_)
                              act   | o_visit_ = text "An unuptimized version was generated. It might not run"
                                    | otherwise = text "The generated program might not run."
                          in ppError _isWarning noPos mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 321, column 20)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupAlt :: (Nonterminal) ->
                    (Constructor) ->
                    (Constructor) ->
                    (T_Error)
sem_Error_DupAlt (nt_) (con_) (occ1_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 29, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Repeated definition for alternative", getName con_
                                            ,"of nonterminal", getName nt_, "."
                                            ] >-<
                                      wfill ["First definition:", (showPos occ1_),"."] >-<
                                      wfill ["Other definition:", (showPos con_),"."]
                              pat =     "DATA" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< "...")
                                    >-< indent 2 ("|" >#< getName con_ >#< "...")
                              help =  wfill ["The nonterminal",getName nt_,"has more than one alternative that"
                                            ,"is labelled with the constructor name",getName con_,"."
                                            ,"You should either rename or remove enough of them to make all"
                                            ,"constructors of",getName nt_,"uniquely named."
                                            ]
                              act  = wfill [ "The first alternative of name",getName con_
                                           ,"you have given for nonterminal",getName nt_
                                           ,"is considered valid. All other alternatives have been discarded."
                                           ]
                          in ppError _isWarning (getPos con_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 28, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupChild :: (Nonterminal) ->
                      (Constructor) ->
                      (Name) ->
                      (Name) ->
                      (T_Error)
sem_Error_DupChild (nt_) (con_) (name_) (occ1_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 124, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Repeated declaration for field", getName name_, "of alternative"
                                            ,getName con_, "of nonterminal", getName nt_, "."
                                            ] >-<
                                      wfill ["First definition:", (showPos occ1_),"."] >-<
                                      wfill ["Other definition:", (showPos name_),"."]
                              pat   =   "DATA" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< (getName name_ >|< ":..." >-< getName name_ >|< ":..."))
                              help =  wfill ["The alternative" ,getName con_ , "of nonterminal" ,getName nt_
                                            ,"has more than one field that is named"
                                            , getName name_ ++ ". Possibly they have different types."
                                            ,"You should either rename or remove enough of them to make all fields of"
                                            ,getName con_ , "for nonterminal " , getName nt_ , "uniquely named."
                                            ]
                              act  = wfill ["The last declaration with its corresponding type is considered valid."
                                           ,"All others have been discarded."
                                           ]
                          in ppError _isWarning (getPos name_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 123, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupInhAttr :: (Nonterminal) ->
                        (Name) ->
                        (Name) ->
                        (T_Error)
sem_Error_DupInhAttr (nt_) (attr_) (occ1_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 86, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Repeated declaration of inherited attribute", getName attr_
                                            , "of nonterminal", getName nt_, "."
                                            ] >-<
                                      wfill ["First definition:", (showPos occ1_),"."] >-<
                                      wfill ["Other definition:", (showPos attr_),"."]
                              pat  = "ATTR" >#< getName nt_ >#< "[" >#< getName attr_ >|< ":...,"
                                                            >#< getName attr_ >|< ":... | | ]"
                              help =  wfill ["The identifier" , getName attr_ ,"has been declared"
                                            ,"as an inherited (or chained) attribute for nonterminal"
                                            ,getName nt_ , "more than once, with possibly different types."
                                            ,"Delete all but one or rename them to make them unique."
                                            ]
                              act  = wfill ["One declaration with its corresponding type is considered valid."
                                           ,"All others have been discarded. The generated program will probably not run."
                                           ]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 85, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupRule :: (Nonterminal) ->
                     (Constructor) ->
                     (Name) ->
                     (Name) ->
                     (Name) ->
                     (T_Error)
sem_Error_DupRule (nt_) (con_) (field_) (attr_) (occ1_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 145, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["At constructor",getName con_, "of nonterminal", getName nt_, "there are two or more rules for"
                                            ,showAttrDef field_ attr_,"."
                                            ]  >-<
                                      wfill ["First rule:", (showPos occ1_),"."] >-<
                                      wfill ["Other rule:", (showPos attr_),"."]
                              pat   =   "SEM" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr field_ attr_ >#< "= ...")
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr field_ attr_ >#< "= ...")
                              help =  wfill ["In the rules for alternative" , getName con_ , "of nonterminal" , getName nt_
                                                    ,", there is more than one rule for the" , showAttrDef field_ attr_
                                                    ,". You should either rename or remove enough of them to make all rules for alternative"
                                                    ,getName con_ , "of nonterminal " ,getName  nt_ , "uniquely named."
                                                    ]
                              act  = wfill ["The last rule given is considered valid. All others have been discarded."]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 144, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupSet :: (Nonterminal) ->
                    (Nonterminal) ->
                    (T_Error)
sem_Error_DupSet (name_) (occ1_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 70, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Definition of nonterminal set", getName name_, "clashes with another"
                                            ,"set, a type synonym or a data definition."
                                            ] >-<
                                      wfill ["First definition:", (showPos occ1_),"."] >-<
                                      wfill ["Set definition:"   , (showPos name_),"."]
                              pat =     "SET" >#< getName name_ >#< "=" >#<  "..."
                                    >-< "SET" >#< getName name_ >#< "=" >#<  "..."
                              help =  wfill ["A nonterminal set with name", getName  name_
                                            ,"has been given while there already is a SET, DATA, or TYPE"
                                            ,"definition with the same name."
                                            ,"You should either rename or remove the nonterminal set."
                                            ]
                              act  = wfill [ "The clashing nonterminal set will be ignored."
                                           ]
                          in ppError _isWarning  (getPos name_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 69, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupSig :: (Nonterminal) ->
                    (Constructor) ->
                    (Name) ->
                    (T_Error)
sem_Error_DupSig (nt_) (con_) (attr_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 164, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["At constructor",getName con_, "of nonterminal", getName nt_, "there are two or more typesignatures for"
                                            ,showAttrDef _LOC attr_,"."
                                            ]  >-<
                                      wfill ["First signature:", (showPos attr_),"."]
                              pat   =   "SEM" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr _LOC attr_ >#< "= ...")
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr _LOC attr_ >#< "= ...")
                              help =  wfill ["In the rules for alternative" , getName con_ , "of nonterminal" , getName nt_
                                                    ,", there is more than one rule for the" , showAttrDef _LOC attr_
                                                    ,". You should remove enough of them to make all typesignatures for alternative"
                                                    ,getName con_ , "of nonterminal " ,getName  nt_ , "unique."
                                                    ]
                              act  = wfill ["The last typesignature given is considered valid. All others have been discarded."]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 163, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupSynAttr :: (Nonterminal) ->
                        (Name) ->
                        (Name) ->
                        (T_Error)
sem_Error_DupSynAttr (nt_) (attr_) (occ1_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 105, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Repeated declaration of synthesized attribute", getName attr_
                                            , "of nonterminal", getName nt_, "."
                                            ] >-<
                                      wfill ["First definition:", (showPos occ1_),"."] >-<
                                      wfill ["Other definition:", (showPos attr_),"."]
                              pat  = "ATTR" >#< getName nt_ >#< "[ | |" >#< getName attr_ >|< ":...,"
                                                                >#< getName attr_ >|< ":... ]"
                              help =  wfill ["The identifier" , getName attr_ ,"has been declared"
                                            ,"as a synthesized (or chained) attribute for nonterminal"
                                            ,getName nt_ , "more than once, with possibly different types."
                                            ,"Delete all but one or rename them to make them unique."
                                            ]
                              act  = wfill ["One declaration with its corresponding type is considered valid."
                                           ,"All others have been discarded. The generated program will probably not run."
                                           ]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 104, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_DupSynonym :: (Nonterminal) ->
                        (Nonterminal) ->
                        (T_Error)
sem_Error_DupSynonym (nt_) (occ1_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 52, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Definition of type synonym", getName nt_, "clashes with another"
                                            ,"type synonym."
                                            ] >-<
                                      wfill ["First definition:", (showPos occ1_),"."] >-<
                                      wfill ["Type synonym :"   , (showPos nt_),"."]
                              pat =     "DATA" >#< getName nt_
                                    >-< indent 2 ("|" >#< "...")
                                    >-< "TYPE" >#< getName nt_ >#< "=" >#<  "..."
                              help =  wfill ["A type synonym with name", getName  nt_
                                            ,"has been given while there already is TYPE"
                                            ,"definition with the same name."
                                            ,"You should either rename or remove the type synonym."
                                            ]
                              act  = wfill [ "The clashing type synonym will be ignored."
                                           ]
                          in ppError _isWarning  (getPos nt_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 51, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_InducedCirc :: (Nonterminal) ->
                         (Name) ->
                         (Name) ->
                         (CInterface) ->
                         (T_Error)
sem_Error_InducedCirc (nt_) (inh_) (syn_) (cinter_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 339, column 21)
                      (_lhsOpp@_) =
                          let mesg  = let attrtext = if inh_ == syn_ then "threaded attribute " ++ getName inh_
                                                                     else "inherited attribute " ++ getName inh_ ++ " and synthesized attribute " ++getName  syn_
                                      in wfill ["Induced circular dependency pattern for", attrtext, "of nonterminal",getName  nt_]
                              pat   = text "see help"
                              showInter (CInterface segs) = concat (snd (mapAccumL (\i c -> (i+1,("visit " ++ show i) : map ind (showsSegment c))) 0 segs))
                              help  = vlist (("Interface for nonterminal " ++ getName nt_ ++ ":") : map ind (showInter cinter_))
                              act   = text "Generation of visit functions failed."
                          in ppError _isWarning noPos mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 338, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_LocLocCirc :: (Nonterminal) ->
                        (Constructor) ->
                        (Name) ->
                        (Bool) ->
                        ([String]) ->
                        (T_Error)
sem_Error_LocLocCirc (nt_) (con_) (attr_) (o_visit_) (path_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 314, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Circular dependency pattern for local attribute", getName attr_
                                            , "of alternative", getName con_, "of nonterminal", getName nt_]
                              pat   = text "see help"
                              help  = vlist ("The following attributes formed the cycle:": path_)
                              act   | o_visit_ = text "An unuptimized version was generated. It might not run"
                                    | otherwise = text "The generated program might not run."
                          in ppError _isWarning noPos mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 313, column 20)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_MissingRule :: (Nonterminal) ->
                         (Constructor) ->
                         (Name) ->
                         (Name) ->
                         (T_Error)
sem_Error_MissingRule (nt_) (con_) (field_) (attr_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 222, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Missing rule for", showAttrDef field_ attr_ , "in alternative"
                                            , getName con_ , "of nonterminal",getName nt_ ,"."
                                            ]
                              pat   =   "SEM" >#< nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr field_ attr_ >#< "= ...")
                              help  = wfill ["The", showAttrDef field_ attr_, "in alternative", getName con_
                                            , "of nonterminal", getName nt_, "is missing and cannot be inferred"
                                            ,"by a copy rule, so you should add an appropriate rule."
                                            ]
                              act  = wfill ["The value of the attribute has been set to undefined."]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 221, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_MissingTypeSig :: (Nonterminal) ->
                            (Constructor) ->
                            (Name) ->
                            (T_Error)
sem_Error_MissingTypeSig (nt_) (con_) (attr_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 348, column 21)
                      (_lhsOpp@_) =
                          let mesg = wfill ["Type signature needed, but not found for", showAttrDef _LOC attr_ , "in alternative"
                                            , getName con_ , "of nonterminal",getName nt_ ,"."
                                            ]>-<
                                      wfill ["Location:", (showPos attr_),"."]
                              pat   =   "SEM" >#< nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr _LOC attr_ >#< ": ...")
                              help  = wfill ["The", showAttrDef _LOC attr_, "in alternative", getName con_
                                            ,"of nonterminal", getName nt_, "is needed in two separate visits to", getName nt_
                                            ,"so its type is needed to generate type signatures."
                                            ,"Please supply its type."
                                            ]
                              act  = wfill ["The type signatures of semantic functions are not generated."]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 347, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_ParserError :: (Pos) ->
                         (String) ->
                         (String) ->
                         (T_Error)
sem_Error_ParserError (pos_) (problem_) (action_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 332, column 21)
                      (_lhsOpp@_) =
                          let mesg = text ("parser expecting " ++ problem_)
                              pat  = text ""
                              help = text ""
                              act  = text action_
                           in ppError _isWarning pos_ mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 331, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_SuperfluousRule :: (Nonterminal) ->
                             (Constructor) ->
                             (Name) ->
                             (Name) ->
                             (T_Error)
sem_Error_SuperfluousRule (nt_) (con_) (field_) (attr_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 236, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Rule for non-existing", showAttrDef field_ attr_ , "at alternative"
                                            , getName con_ , "of nonterminal",getName nt_, "."
                                            ]
                              pat   =   "SEM" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr field_ attr_ >#< "= ...")
                              help =  wfill ["There is a rule for" , showAttrDef field_ attr_ , "in the definitions for alternative" , getName con_
                                            ,"of nonterminal" , getName nt_,  ", but this attribute does not exist. Maybe you misspelled it?"
                                            ,"Otherwise either remove the rule or add an appropriate attribute definition."
                                            ]
                              act  = wfill ["The rule has been ignored."]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 235, column 21)
                      (_isWarning@_) =
                          True
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_UndefAlt :: (Nonterminal) ->
                      (Constructor) ->
                      (T_Error)
sem_Error_UndefAlt (nt_) (con_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 193, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Constructor", getName con_, "of nonterminal" ,getName nt_, "is  not defined."
                                            ]
                              pat   =   "DATA" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< "...")
                              help =  wfill ["There are rules for alternative", getName con_ , "of nonterminal" ,getName nt_
                                                    ,", but there is no definition for this alternative in the definitions of the"
                                                    ,"nonterminal" , getName nt_, ". Maybe you misspelled it? Otherwise insert a definition."
                                                    ]
                              act  = wfill ["All rules for the unknown alternative have been ignored."]
                          in ppError _isWarning (getPos con_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 192, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_UndefAttr :: (Nonterminal) ->
                       (Constructor) ->
                       (Name) ->
                       (Name) ->
                       (T_Error)
sem_Error_UndefAttr (nt_) (con_) (field_) (attr_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 282, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Undefined", showAttrUse field_ attr_, "at constructor"
                                            , getName con_ , "of nonterminal",getName nt_, "."
                                            ]
                              pat   = "SEM" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< "<field>.<attr> = "
                                                      >#< "..." >#< ppAttrUse field_ attr_ >#< "...")
                              help =  wfill ["A rule in the definitions for alternative" , getName con_ ,"of nonterminal"
                                            ,getName  nt_ , "contains an attribute that is not defined"
                                            ,"Maybe you misspelled it?"
                                            ,"Otherwise either remove the rule or add an appropriate attribute definition."
                                            ]
                              act  = wfill ["The generated program will not run."]
                          in ppError _isWarning (getPos attr_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 281, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_UndefChild :: (Nonterminal) ->
                        (Constructor) ->
                        (Name) ->
                        (T_Error)
sem_Error_UndefChild (nt_) (con_) (name_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 206, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Constructor", getName con_, "of nonterminal" ,getName nt_
                                            , "does not have a nontrivial field named", getName name_ , "."
                                            ]
                              pat   =   "SEM" >#< nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< ppAttr name_ (identifier "<attr>") >#< "= ...")
                              help =  wfill ["There are rules that define or use attributes of field" , getName name_
                                                    ,"in alternative" , getName con_ , "of nonterminal" , getName nt_
                                                    ,", but there is no field with AG-type in the definition of the alternative."
                                                    ,"Maybe you misspelled it? Otherwise insert the field into the definition,"
                                                    ,"or change its type from an HS-type to an AG-type."
                                                    ]
                              act  = wfill ["All rules for the unknown field have been ignored."]
                          in ppError _isWarning (getPos name_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 205, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_UndefLocal :: (Nonterminal) ->
                        (Constructor) ->
                        (Name) ->
                        (T_Error)
sem_Error_UndefLocal (nt_) (con_) (var_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 251, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Undefined local variable or field",getName var_, "at constructor"
                                            , getName con_ , "of nonterminal",getName nt_, "."
                                            ]
                              pat   = "SEM" >#< getName nt_
                                    >-< indent 2 ("|" >#< getName con_ >#< "<field>.<attr> = "
                                                      >#< "..." >#< "@" >|< getName var_ >#< "..." )
                              help =  wfill ["A rule in the definitions for alternative" , getName con_ ,"of nonterminal"
                                            , getName nt_ , "contains a local variable or field name that is not defined"
                                            ,"Maybe you misspelled it?"
                                            ,"Otherwise either remove the rule or add an appropriate definition."
                                            ]
                              act  = wfill ["The generated program will not run."]
                          in ppError _isWarning (getPos var_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 250, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
sem_Error_UndefNont :: (Nonterminal) ->
                       (T_Error)
sem_Error_UndefNont (nt_) =
    (T_Error (\ _lhsIverbose ->
                  let _lhsOisWarning :: (Bool)
                      _lhsOpp :: (PP_Doc)
                      -- "PrintErrorMessages.ag"(line 182, column 21)
                      (_lhsOpp@_) =
                          let mesg  = wfill ["Nonterminal", getName nt_, "is not defined."
                                            ]
                              pat   = "DATA" >#< getName nt_ >#< "..."
                              help =  wfill ["There are attributes and/or rules for nonterminal" , getName nt_  ,", but there is no definition"
                                                    , "for" ,getName  nt_, ". Maybe you misspelled it? Otherwise insert a definition."
                                                    ]
                              act  = wfill ["Everything regarding the unknown nonterminal has been ignored."]
                          in ppError _isWarning (getPos nt_) mesg pat help act _lhsIverbose
                      -- "PrintErrorMessages.ag"(line 181, column 21)
                      (_isWarning@_) =
                          False
                      -- copy rule (from local)
                      (_lhsOisWarning@_) =
                          _isWarning
                  in  ( _lhsOisWarning,_lhsOpp)))
-- Errors ------------------------------------------------------
{-
   inherited attributes:
      options              : Options

   chained attributes:

   synthesised attributes:
      isWarning            : Bool
      pp                   : PP_Doc

-}
{-
   local variables for Errors.Cons:
      verbose

-}
{-
   local variables for Errors.Nil:
      verbose

-}
-- semantic domain
newtype T_Errors = T_Errors ((Options) ->
                             ( (Bool),(PP_Doc)))
-- cata
sem_Errors :: (Errors) ->
              (T_Errors)
sem_Errors (list) =
    (Prelude.foldr (sem_Errors_Cons) (sem_Errors_Nil) ((Prelude.map sem_Error list)))
data Inh_Errors = Inh_Errors {options_Inh_Errors :: Options}
data Syn_Errors = Syn_Errors {isWarning_Syn_Errors :: Bool,pp_Syn_Errors :: PP_Doc}
wrap_Errors :: (T_Errors) ->
               (Inh_Errors) ->
               (Syn_Errors)
wrap_Errors ((T_Errors (sem))) ((Inh_Errors (i1))) =
    let ( s1,s2) =
            (sem (i1))
    in  (Syn_Errors (s1) (s2))
sem_Errors_Cons :: (T_Error) ->
                   (T_Errors) ->
                   (T_Errors)
sem_Errors_Cons ((T_Error (hd_))) ((T_Errors (tl_))) =
    (T_Errors (\ _lhsIoptions ->
                   let _lhsOisWarning :: (Bool)
                       _lhsOpp :: (PP_Doc)
                       _hdIisWarning :: (Bool)
                       _hdIpp :: (PP_Doc)
                       _hdOverbose :: (Bool)
                       _tlIisWarning :: (Bool)
                       _tlIpp :: (PP_Doc)
                       _tlOoptions :: (Options)
                       ( _hdIisWarning,_hdIpp) =
                           (hd_ (_hdOverbose))
                       ( _tlIisWarning,_tlIpp) =
                           (tl_ (_tlOoptions))
                       -- "PrintErrorMessages.ag"(line 23, column 8)
                       (_verbose@_) =
                           verbose _lhsIoptions
                       -- use rule
                       (_lhsOisWarning@_) =
                           _hdIisWarning && _tlIisWarning
                       -- use rule
                       (_lhsOpp@_) =
                           _hdIpp >-< _tlIpp
                       -- copy rule (from local)
                       (_hdOverbose@_) =
                           _verbose
                       -- copy rule (down)
                       (_tlOoptions@_) =
                           _lhsIoptions
                   in  ( _lhsOisWarning,_lhsOpp)))
sem_Errors_Nil :: (T_Errors)
sem_Errors_Nil  =
    (T_Errors (\ _lhsIoptions ->
                   let _lhsOisWarning :: (Bool)
                       _lhsOpp :: (PP_Doc)
                       -- "PrintErrorMessages.ag"(line 23, column 8)
                       (_verbose@_) =
                           verbose _lhsIoptions
                       -- use rule
                       (_lhsOisWarning@_) =
                           True
                       -- use rule
                       (_lhsOpp@_) =
                           text ""
                   in  ( _lhsOisWarning,_lhsOpp)))


