-- do not edit; automatically generated by UU.AG
module SemHsTokens where

import Char(isPrint,ord)
import UU.DData.Seq as Seq(Seq,empty,single,(<>),toList)
import UU.Scanner.Position(Pos(Pos),line,column)
import UU.Pretty

import HsToken
import ErrorMessages

import CommonTypes
import UU.Scanner.Position(Pos)

isNTname allnts (Just (NT nt)) = nt `elem` allnts
isNTname allnts _              = False

showTokens :: [(Pos,String)] -> [String]
showTokens [] = []
showTokens xs = map showLine . shiftLeft . getLines $ xs

getLines []         = []
getLines ((p,t):xs) =       let (txs,rest)     = span sameLine xs
                                sameLine (q,_) = line p == line q
                            in ((p,t):txs) : getLines rest

shiftLeft lns =        let sh = let m = minimum . checkEmpty . filter (>=1) . map (column.fst.head) $ lns
                                    checkEmpty [] = [1]
                                    checkEmpty x  = x
                                in if m >= 1 then m-1 else 0
                           shift (p,t) = (if column p >= 1 then case p of (Pos l c f) -> Pos l (c - sh) f else p, t)
                       in map (map shift) lns

showLine ts =        let f (p,t) r = let ct = column p
                                     in \c -> spaces (ct-c) ++ t ++ r (length t+ct)
                         spaces x | x < 0 = ""
                                  | otherwise = replicate x ' '
                     in foldr f (const "") ts 1


showStrShort xs = "\"" ++ concatMap f xs ++ "\""
  where f '"' = "\\\""
        f x   = showCharShort' x

showCharShort '\'' = "'" ++ "\\'" ++ "'"
showCharShort c    = "'" ++ showCharShort' c ++ "'"

showCharShort' '\a'  = "\\a"
showCharShort' '\b'  = "\\b"
showCharShort' '\t'  = "\\t"
showCharShort' '\n'  = "\\n"
showCharShort' '\r'  = "\\r"
showCharShort' '\f'  = "\\f"
showCharShort' '\v'  = "\\v"
showCharShort' '\\'  = "\\\\"
showCharShort' x | isPrint x = [x]
                 | otherwise = '\\' : show (ord x)
-- HsToken -----------------------------------------------------
{-
   inherited attributes:
      allfields            : [(Name,Type)]
      allnts               : [Name]
      attrs                : [(Identifier,Identifier)]
      con                  : Identifier
      fieldnames           : [Identifier]
      nt                   : Identifier

   chained attributes:

   synthesised attributes:
      errors               : Seq Error
      tok                  : (Pos,String)
      usedAttrs            : [(Identifier,Identifier)]
      usedFields           : Seq Identifier
      usedLocals           : [Identifier]

-}
{-
   local variables for HsToken.AGField:

-}
{-
   local variables for HsToken.AGLocal:
      errors
      tok
      usedLocals

-}
{-
   local variables for HsToken.CharToken:

-}
{-
   local variables for HsToken.Err:

-}
{-
   local variables for HsToken.HsToken:

-}
{-
   local variables for HsToken.StrToken:

-}
-- semantic domain
newtype T_HsToken = T_HsToken (([(Name,Type)]) ->
                               ([Name]) ->
                               ([(Identifier,Identifier)]) ->
                               (Identifier) ->
                               ([Identifier]) ->
                               (Identifier) ->
                               ( (Seq Error),((Pos,String)),([(Identifier,Identifier)]),(Seq Identifier),([Identifier])))
-- cata
sem_HsToken :: (HsToken) ->
               (T_HsToken)
sem_HsToken ((AGField (_field) (_attr) (_pos))) =
    (sem_HsToken_AGField (_field) (_attr) (_pos))
sem_HsToken ((AGLocal (_var) (_pos))) =
    (sem_HsToken_AGLocal (_var) (_pos))
sem_HsToken ((CharToken (_value) (_pos))) =
    (sem_HsToken_CharToken (_value) (_pos))
sem_HsToken ((Err (_mesg) (_pos))) =
    (sem_HsToken_Err (_mesg) (_pos))
sem_HsToken ((HsToken (_value) (_pos))) =
    (sem_HsToken_HsToken (_value) (_pos))
sem_HsToken ((StrToken (_value) (_pos))) =
    (sem_HsToken_StrToken (_value) (_pos))
data Inh_HsToken = Inh_HsToken {allfields_Inh_HsToken :: [(Name,Type)],allnts_Inh_HsToken :: [Name],attrs_Inh_HsToken :: [(Identifier,Identifier)],con_Inh_HsToken :: Identifier,fieldnames_Inh_HsToken :: [Identifier],nt_Inh_HsToken :: Identifier}
data Syn_HsToken = Syn_HsToken {errors_Syn_HsToken :: Seq Error,tok_Syn_HsToken :: (Pos,String),usedAttrs_Syn_HsToken :: [(Identifier,Identifier)],usedFields_Syn_HsToken :: Seq Identifier,usedLocals_Syn_HsToken :: [Identifier]}
wrap_HsToken :: (T_HsToken) ->
                (Inh_HsToken) ->
                (Syn_HsToken)
wrap_HsToken ((T_HsToken (sem))) ((Inh_HsToken (i1) (i2) (i3) (i4) (i5) (i6))) =
    let ( s1,s2,s3,s4,s5) =
            (sem (i1) (i2) (i3) (i4) (i5) (i6))
    in  (Syn_HsToken (s1) (s2) (s3) (s4) (s5))
sem_HsToken_AGField :: (Name) ->
                       (Name) ->
                       (Pos) ->
                       (T_HsToken)
sem_HsToken_AGField (field_) (attr_) (pos_) =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOtok :: ((Pos,String))
                        _lhsOusedAttrs :: ([(Identifier,Identifier)])
                        _lhsOusedFields :: (Seq Identifier)
                        _lhsOusedLocals :: ([Identifier])
                        -- "SemHsTokens.ag"(line 74, column 15)
                        (_lhsOerrors@_) =
                            if (field_,attr_) `elem` _lhsIattrs
                                  then Seq.empty
                                  else if not(field_ `elem` (_LHS : _LOC: _lhsIfieldnames))
                                          then Seq.single (UndefChild _lhsInt _lhsIcon field_)
                                          else Seq.single (UndefAttr _lhsInt _lhsIcon field_ attr_)
                        -- "SemHsTokens.ag"(line 88, column 13)
                        (_lhsOusedAttrs@_) =
                            [(field_,attr_)]
                        -- "SemHsTokens.ag"(line 114, column 14)
                        (_lhsOtok@_) =
                            (pos_, attrname True field_ attr_)
                        -- use rule
                        (_lhsOusedFields@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedLocals@_) =
                            []
                    in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
sem_HsToken_AGLocal :: (Name) ->
                       (Pos) ->
                       (T_HsToken)
sem_HsToken_AGLocal (var_) (pos_) =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOtok :: ((Pos,String))
                        _lhsOusedAttrs :: ([(Identifier,Identifier)])
                        _lhsOusedFields :: (Seq Identifier)
                        _lhsOusedLocals :: ([Identifier])
                        -- "SemHsTokens.ag"(line 64, column 19)
                        ((_errors@_,_tok@_,_usedLocals@_)) =
                            if var_ `elem` _lhsIfieldnames
                            then if  isNTname _lhsIallnts (lookup var_ _lhsIallfields)
                                 then (Seq.single(ChildAsLocal _lhsInt _lhsIcon var_), (pos_,fieldname var_), []    )
                                 else (Seq.empty, (pos_,fieldname var_), []    )
                            else if (_LOC,var_) `elem` _lhsIattrs
                            then (Seq.empty                                   , (pos_,locname   var_), [var_])
                            else (Seq.single(UndefLocal _lhsInt _lhsIcon var_), (pos_,locname   var_), []    )
                        -- "SemHsTokens.ag"(line 96, column 13)
                        (_lhsOusedFields@_) =
                            if var_ `elem` _lhsIfieldnames
                             then Seq.single var_
                             else Seq.empty
                        -- use rule
                        (_lhsOerrors@_) =
                            _errors
                        -- use rule
                        (_lhsOusedAttrs@_) =
                            []
                        -- use rule
                        (_lhsOusedLocals@_) =
                            _usedLocals
                        -- copy rule (from local)
                        (_lhsOtok@_) =
                            _tok
                    in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
sem_HsToken_CharToken :: (String) ->
                         (Pos) ->
                         (T_HsToken)
sem_HsToken_CharToken (value_) (pos_) =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOtok :: ((Pos,String))
                        _lhsOusedAttrs :: ([(Identifier,Identifier)])
                        _lhsOusedFields :: (Seq Identifier)
                        _lhsOusedLocals :: ([Identifier])
                        -- "SemHsTokens.ag"(line 118, column 16)
                        (_lhsOtok@_) =
                            (pos_, if null value_
                                      then ""
                                      else showCharShort (head value_)
                            )
                        -- use rule
                        (_lhsOerrors@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedAttrs@_) =
                            []
                        -- use rule
                        (_lhsOusedFields@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedLocals@_) =
                            []
                    in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
sem_HsToken_Err :: (String) ->
                   (Pos) ->
                   (T_HsToken)
sem_HsToken_Err (mesg_) (pos_) =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOtok :: ((Pos,String))
                        _lhsOusedAttrs :: ([(Identifier,Identifier)])
                        _lhsOusedFields :: (Seq Identifier)
                        _lhsOusedLocals :: ([Identifier])
                        -- "SemHsTokens.ag"(line 50, column 9)
                        (_lhsOerrors@_) =
                            let m = text mesg_
                            in Seq.single (CustomError False pos_ m)
                        -- "SemHsTokens.ag"(line 124, column 16)
                        (_lhsOtok@_) =
                            (pos_, "")
                        -- use rule
                        (_lhsOusedAttrs@_) =
                            []
                        -- use rule
                        (_lhsOusedFields@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedLocals@_) =
                            []
                    in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
sem_HsToken_HsToken :: (String) ->
                       (Pos) ->
                       (T_HsToken)
sem_HsToken_HsToken (value_) (pos_) =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOtok :: ((Pos,String))
                        _lhsOusedAttrs :: ([(Identifier,Identifier)])
                        _lhsOusedFields :: (Seq Identifier)
                        _lhsOusedLocals :: ([Identifier])
                        -- "SemHsTokens.ag"(line 116, column 14)
                        (_lhsOtok@_) =
                            (pos_, value_)
                        -- use rule
                        (_lhsOerrors@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedAttrs@_) =
                            []
                        -- use rule
                        (_lhsOusedFields@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedLocals@_) =
                            []
                    in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
sem_HsToken_StrToken :: (String) ->
                        (Pos) ->
                        (T_HsToken)
sem_HsToken_StrToken (value_) (pos_) =
    (T_HsToken (\ _lhsIallfields
                  _lhsIallnts
                  _lhsIattrs
                  _lhsIcon
                  _lhsIfieldnames
                  _lhsInt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOtok :: ((Pos,String))
                        _lhsOusedAttrs :: ([(Identifier,Identifier)])
                        _lhsOusedFields :: (Seq Identifier)
                        _lhsOusedLocals :: ([Identifier])
                        -- "SemHsTokens.ag"(line 123, column 16)
                        (_lhsOtok@_) =
                            (pos_, showStrShort value_)
                        -- use rule
                        (_lhsOerrors@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedAttrs@_) =
                            []
                        -- use rule
                        (_lhsOusedFields@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedLocals@_) =
                            []
                    in  ( _lhsOerrors,_lhsOtok,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
-- HsTokens ----------------------------------------------------
{-
   inherited attributes:
      allfields            : [(Name,Type)]
      allnts               : [Name]
      attrs                : [(Identifier,Identifier)]
      con                  : Identifier
      fieldnames           : [Identifier]
      nt                   : Identifier

   chained attributes:

   synthesised attributes:
      errors               : Seq Error
      tks                  : [(Pos,String)]
      usedAttrs            : [(Identifier,Identifier)]
      usedFields           : Seq Identifier
      usedLocals           : [Identifier]

-}
{-
   local variables for HsTokens.Cons:

-}
{-
   local variables for HsTokens.Nil:

-}
-- semantic domain
newtype T_HsTokens = T_HsTokens (([(Name,Type)]) ->
                                 ([Name]) ->
                                 ([(Identifier,Identifier)]) ->
                                 (Identifier) ->
                                 ([Identifier]) ->
                                 (Identifier) ->
                                 ( (Seq Error),([(Pos,String)]),([(Identifier,Identifier)]),(Seq Identifier),([Identifier])))
-- cata
sem_HsTokens :: (HsTokens) ->
                (T_HsTokens)
sem_HsTokens (list) =
    (Prelude.foldr (sem_HsTokens_Cons) (sem_HsTokens_Nil) ((Prelude.map sem_HsToken list)))
data Inh_HsTokens = Inh_HsTokens {allfields_Inh_HsTokens :: [(Name,Type)],allnts_Inh_HsTokens :: [Name],attrs_Inh_HsTokens :: [(Identifier,Identifier)],con_Inh_HsTokens :: Identifier,fieldnames_Inh_HsTokens :: [Identifier],nt_Inh_HsTokens :: Identifier}
data Syn_HsTokens = Syn_HsTokens {errors_Syn_HsTokens :: Seq Error,tks_Syn_HsTokens :: [(Pos,String)],usedAttrs_Syn_HsTokens :: [(Identifier,Identifier)],usedFields_Syn_HsTokens :: Seq Identifier,usedLocals_Syn_HsTokens :: [Identifier]}
wrap_HsTokens :: (T_HsTokens) ->
                 (Inh_HsTokens) ->
                 (Syn_HsTokens)
wrap_HsTokens ((T_HsTokens (sem))) ((Inh_HsTokens (i1) (i2) (i3) (i4) (i5) (i6))) =
    let ( s1,s2,s3,s4,s5) =
            (sem (i1) (i2) (i3) (i4) (i5) (i6))
    in  (Syn_HsTokens (s1) (s2) (s3) (s4) (s5))
sem_HsTokens_Cons :: (T_HsToken) ->
                     (T_HsTokens) ->
                     (T_HsTokens)
sem_HsTokens_Cons ((T_HsToken (hd_))) ((T_HsTokens (tl_))) =
    (T_HsTokens (\ _lhsIallfields
                   _lhsIallnts
                   _lhsIattrs
                   _lhsIcon
                   _lhsIfieldnames
                   _lhsInt ->
                     let _lhsOerrors :: (Seq Error)
                         _lhsOtks :: ([(Pos,String)])
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOusedFields :: (Seq Identifier)
                         _lhsOusedLocals :: ([Identifier])
                         _hdIerrors :: (Seq Error)
                         _hdItok :: ((Pos,String))
                         _hdIusedAttrs :: ([(Identifier,Identifier)])
                         _hdIusedFields :: (Seq Identifier)
                         _hdIusedLocals :: ([Identifier])
                         _hdOallfields :: ([(Name,Type)])
                         _hdOallnts :: ([Name])
                         _hdOattrs :: ([(Identifier,Identifier)])
                         _hdOcon :: (Identifier)
                         _hdOfieldnames :: ([Identifier])
                         _hdOnt :: (Identifier)
                         _tlIerrors :: (Seq Error)
                         _tlItks :: ([(Pos,String)])
                         _tlIusedAttrs :: ([(Identifier,Identifier)])
                         _tlIusedFields :: (Seq Identifier)
                         _tlIusedLocals :: ([Identifier])
                         _tlOallfields :: ([(Name,Type)])
                         _tlOallnts :: ([Name])
                         _tlOattrs :: ([(Identifier,Identifier)])
                         _tlOcon :: (Identifier)
                         _tlOfieldnames :: ([Identifier])
                         _tlOnt :: (Identifier)
                         ( _hdIerrors,_hdItok,_hdIusedAttrs,_hdIusedFields,_hdIusedLocals) =
                             (hd_ (_hdOallfields) (_hdOallnts) (_hdOattrs) (_hdOcon) (_hdOfieldnames) (_hdOnt))
                         ( _tlIerrors,_tlItks,_tlIusedAttrs,_tlIusedFields,_tlIusedLocals) =
                             (tl_ (_tlOallfields) (_tlOallnts) (_tlOattrs) (_tlOcon) (_tlOfieldnames) (_tlOnt))
                         -- "SemHsTokens.ag"(line 110, column 10)
                         (_lhsOtks@_) =
                             _hdItok : _tlItks
                         -- use rule
                         (_lhsOerrors@_) =
                             _hdIerrors Seq.<> _tlIerrors
                         -- use rule
                         (_lhsOusedAttrs@_) =
                             _hdIusedAttrs ++ _tlIusedAttrs
                         -- use rule
                         (_lhsOusedFields@_) =
                             _hdIusedFields Seq.<> _tlIusedFields
                         -- use rule
                         (_lhsOusedLocals@_) =
                             _hdIusedLocals ++ _tlIusedLocals
                         -- copy rule (down)
                         (_hdOallfields@_) =
                             _lhsIallfields
                         -- copy rule (down)
                         (_hdOallnts@_) =
                             _lhsIallnts
                         -- copy rule (down)
                         (_hdOattrs@_) =
                             _lhsIattrs
                         -- copy rule (down)
                         (_hdOcon@_) =
                             _lhsIcon
                         -- copy rule (down)
                         (_hdOfieldnames@_) =
                             _lhsIfieldnames
                         -- copy rule (down)
                         (_hdOnt@_) =
                             _lhsInt
                         -- copy rule (down)
                         (_tlOallfields@_) =
                             _lhsIallfields
                         -- copy rule (down)
                         (_tlOallnts@_) =
                             _lhsIallnts
                         -- copy rule (down)
                         (_tlOattrs@_) =
                             _lhsIattrs
                         -- copy rule (down)
                         (_tlOcon@_) =
                             _lhsIcon
                         -- copy rule (down)
                         (_tlOfieldnames@_) =
                             _lhsIfieldnames
                         -- copy rule (down)
                         (_tlOnt@_) =
                             _lhsInt
                     in  ( _lhsOerrors,_lhsOtks,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
sem_HsTokens_Nil :: (T_HsTokens)
sem_HsTokens_Nil  =
    (T_HsTokens (\ _lhsIallfields
                   _lhsIallnts
                   _lhsIattrs
                   _lhsIcon
                   _lhsIfieldnames
                   _lhsInt ->
                     let _lhsOerrors :: (Seq Error)
                         _lhsOtks :: ([(Pos,String)])
                         _lhsOusedAttrs :: ([(Identifier,Identifier)])
                         _lhsOusedFields :: (Seq Identifier)
                         _lhsOusedLocals :: ([Identifier])
                         -- "SemHsTokens.ag"(line 111, column 10)
                         (_lhsOtks@_) =
                             []
                         -- use rule
                         (_lhsOerrors@_) =
                             Seq.empty
                         -- use rule
                         (_lhsOusedAttrs@_) =
                             []
                         -- use rule
                         (_lhsOusedFields@_) =
                             Seq.empty
                         -- use rule
                         (_lhsOusedLocals@_) =
                             []
                     in  ( _lhsOerrors,_lhsOtks,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))
-- HsTokensRoot ------------------------------------------------
{-
   inherited attributes:
      allfields            : [(Name,Type)]
      allnts               : [Name]
      attrs                : [(Identifier,Identifier)]
      con                  : Identifier
      nt                   : Identifier

   chained attributes:

   synthesised attributes:
      errors               : Seq Error
      textLines            : [String]
      usedAttrs            : [(Identifier,Identifier)]
      usedFields           : [Identifier]
      usedLocals           : [Identifier]

-}
{-
   local variables for HsTokensRoot.HsTokensRoot:

-}
-- semantic domain
newtype T_HsTokensRoot = T_HsTokensRoot (([(Name,Type)]) ->
                                         ([Name]) ->
                                         ([(Identifier,Identifier)]) ->
                                         (Identifier) ->
                                         (Identifier) ->
                                         ( (Seq Error),([String]),([(Identifier,Identifier)]),([Identifier]),([Identifier])))
-- cata
sem_HsTokensRoot :: (HsTokensRoot) ->
                    (T_HsTokensRoot)
sem_HsTokensRoot ((HsTokensRoot (_tokens))) =
    (sem_HsTokensRoot_HsTokensRoot ((sem_HsTokens (_tokens))))
data Inh_HsTokensRoot = Inh_HsTokensRoot {allfields_Inh_HsTokensRoot :: [(Name,Type)],allnts_Inh_HsTokensRoot :: [Name],attrs_Inh_HsTokensRoot :: [(Identifier,Identifier)],con_Inh_HsTokensRoot :: Identifier,nt_Inh_HsTokensRoot :: Identifier}
data Syn_HsTokensRoot = Syn_HsTokensRoot {errors_Syn_HsTokensRoot :: Seq Error,textLines_Syn_HsTokensRoot :: [String],usedAttrs_Syn_HsTokensRoot :: [(Identifier,Identifier)],usedFields_Syn_HsTokensRoot :: [Identifier],usedLocals_Syn_HsTokensRoot :: [Identifier]}
wrap_HsTokensRoot :: (T_HsTokensRoot) ->
                     (Inh_HsTokensRoot) ->
                     (Syn_HsTokensRoot)
wrap_HsTokensRoot ((T_HsTokensRoot (sem))) ((Inh_HsTokensRoot (i1) (i2) (i3) (i4) (i5))) =
    let ( s1,s2,s3,s4,s5) =
            (sem (i1) (i2) (i3) (i4) (i5))
    in  (Syn_HsTokensRoot (s1) (s2) (s3) (s4) (s5))
sem_HsTokensRoot_HsTokensRoot :: (T_HsTokens) ->
                                 (T_HsTokensRoot)
sem_HsTokensRoot_HsTokensRoot ((T_HsTokens (tokens_))) =
    (T_HsTokensRoot (\ _lhsIallfields
                       _lhsIallnts
                       _lhsIattrs
                       _lhsIcon
                       _lhsInt ->
                         let _lhsOerrors :: (Seq Error)
                             _lhsOtextLines :: ([String])
                             _lhsOusedAttrs :: ([(Identifier,Identifier)])
                             _lhsOusedFields :: ([Identifier])
                             _lhsOusedLocals :: ([Identifier])
                             _tokensIerrors :: (Seq Error)
                             _tokensItks :: ([(Pos,String)])
                             _tokensIusedAttrs :: ([(Identifier,Identifier)])
                             _tokensIusedFields :: (Seq Identifier)
                             _tokensIusedLocals :: ([Identifier])
                             _tokensOallfields :: ([(Name,Type)])
                             _tokensOallnts :: ([Name])
                             _tokensOattrs :: ([(Identifier,Identifier)])
                             _tokensOcon :: (Identifier)
                             _tokensOfieldnames :: ([Identifier])
                             _tokensOnt :: (Identifier)
                             ( _tokensIerrors,_tokensItks,_tokensIusedAttrs,_tokensIusedFields,_tokensIusedLocals) =
                                 (tokens_ (_tokensOallfields) (_tokensOallnts) (_tokensOattrs) (_tokensOcon) (_tokensOfieldnames) (_tokensOnt))
                             -- "SemHsTokens.ag"(line 38, column 18)
                             (_tokensOfieldnames@_) =
                                 map fst _lhsIallfields
                             -- "SemHsTokens.ag"(line 100, column 18)
                             (_lhsOusedFields@_) =
                                 Seq.toList _tokensIusedFields
                             -- "SemHsTokens.ag"(line 107, column 18)
                             (_lhsOtextLines@_) =
                                 showTokens _tokensItks
                             -- use rule
                             (_lhsOerrors@_) =
                                 _tokensIerrors
                             -- copy rule (up)
                             (_lhsOusedAttrs@_) =
                                 _tokensIusedAttrs
                             -- copy rule (up)
                             (_lhsOusedLocals@_) =
                                 _tokensIusedLocals
                             -- copy rule (down)
                             (_tokensOallfields@_) =
                                 _lhsIallfields
                             -- copy rule (down)
                             (_tokensOallnts@_) =
                                 _lhsIallnts
                             -- copy rule (down)
                             (_tokensOattrs@_) =
                                 _lhsIattrs
                             -- copy rule (down)
                             (_tokensOcon@_) =
                                 _lhsIcon
                             -- copy rule (down)
                             (_tokensOnt@_) =
                                 _lhsInt
                         in  ( _lhsOerrors,_lhsOtextLines,_lhsOusedAttrs,_lhsOusedFields,_lhsOusedLocals)))


