/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_STIPPLECOMBOBOXWIDGET_H
#define GTK_STIPPLECOMBOBOXWIDGET_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkcombobox.h>
#include <gtk/gtkliststore.h>

G_BEGIN_DECLS
/**
 * STIPPLE_COMBOX_TYPE
 *
 * Returns: the associated #GType to the StippleComboBox objects.
 *
 * Since: 3.4
 */
#define STIPPLE_COMBOX_TYPE         (stippleComboBox_get_type ())
/**
 * STIPPLE_COMBOX:
 *
 * Cast the given object to a #StippleComboBox object.
 *
 * Since: 3.4
 */
#define STIPPLE_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), STIPPLE_COMBOX_TYPE, StippleComboBox))
/**
 * STIPPLE_COMBOX_CLASS
 *
 * Cast the given class to a #StippleComboBoxClass object.
 *
 * Since: 3.4
 */
#define STIPPLE_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STIPPLE_COMBOX_TYPE, StippleComboBoxClass))
/**
 * IS_STIPPLE_COMBOX
 *
 * Returns: if the given object is a valid #StippleComboBox object.
 *
 * Since: 3.4
 */
#define IS_STIPPLE_COMBOX(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STIPPLE_COMBOX_TYPE))
/**
 * IS_STIPPLE_COMBOX_CLASS
 *
 * Returns: if the given class is a valid #StippleComboBoxClass class.
 *
 * Since: 3.4
 */
#define IS_STIPPLE_COMBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STIPPLE_COMBOX_TYPE))

/**
 * StippleComboBox:
 *
 * Private structure to store informations of a #StippleComboBox object.
 *
 * Since: 3.4
 */
typedef struct _StippleComboBox StippleComboBox;
/* typedef struct StippleComboBoxPrivate_struct StippleComboBoxPrivate; */
/**
 * StippleComboBoxClass
 *
 * Private structure to store informations of a #StippleComboBoxClass object.
 *
 * Since: 3.4
 */
typedef struct _StippleComboBoxClass StippleComboBoxClass;

/**
 * stippleComboBox_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #StippleComboBox objects.
 *
 * Since: 3.4
 */
GType stippleComboBox_get_type(void);
/**
 * stippleComboBox_new :
 *
 * A #StippleComboBox widget is like a #GtkComboBox widget, but it is already filled
 * with predefined line patterns (call stipple). Using this widget is
 * a convienient way to share stipples between all part of V_Sim and
 * to give a consistent look of all stipple selection.
 *
 * Returns: a newly created #StippleComboBox widget.
 *
 * Since: 3.4
 */
GtkWidget* stippleComboBox_new();

/**
 * stippleComboBoxSet_selectionByStipple:
 * @stippleComboBox: a #StippleComboBox widget ;
 * @stipple: a pattern value.
 *
 * Use this method to set the ComboBox on the given stipple. This emits a 'stipple-channel'
 * signal if the stipple is changed, which means, a previous stipple has been modified,
 * or a new stipple is selected.
 *
 * Returns: TRUE if the @stipple already exists in the model.
 *
 * Since: 3.4
 */
gboolean stippleComboBoxSet_selectionByStipple(StippleComboBox* stippleComboBox,
					       guint16 stipple);
/**
 * stippleComboBoxGet_selectedStipple:
 * @stippleComboBox: a #StippleComboBox widget.
 *
 * The user can access to the selected #Stipple object using this method.
 *
 * Returns: a pattern value (or 65535).
 *
 * Since: 3.4
 */
guint16 stippleComboBoxGet_selectedStipple(StippleComboBox *stippleComboBox);
/**
 * stippleComboBoxGet_pixbufFromStipple:
 * @stippleComboBox: a #StippleComboBox widget ;
 * @stipple: a pattern value.
 *
 * The @stippleComboBox has little pixbufs to represent the stipple. User methods can
 * use these pixbufs but should considered them read-only.
 *
 * Returns: a pixbuf pointer corresponding to the little image shown on
 *          the @stippleComboBox.
 *
 * Since: 3.4
 */
GdkPixbuf* stippleComboBoxGet_pixbufFromStipple(StippleComboBox *stippleComboBox,
						guint16 stipple);

/**
 * stippleComboBoxBuild_stippleStamp:
 * @stipple: a pattern value.
 *
 * This method is used to create pixbuf representing stipples.A new
 * pixbuf is created.
 *
 * Returns: a pixbuf pointer.
 *
 * Since: 3.4
 */
GdkPixbuf* stippleComboBoxBuild_stippleStamp(guint16 stipple);

/**
 * stippleComboBoxAdd_pattern:
 * @stippleComboBox: a #StippleComboBox widget ;
 * @stipple: a pattern value.
 *
 * Create an entry in the ComboBox for the given @stipple pattern if
 * it does not already exist.
 *
 * Since: 3.4
 */
void stippleComboBoxAdd_pattern(StippleComboBox *stippleComboBox, guint16 stipple);

G_END_DECLS

#endif
