module VagrantPlugins
  module ProviderLibvirt
    module Action
      # This class asks the user to confirm the destruction of a machine
      # that Vagrant manages. This is provided as a built-in on top of
      # {Confirm} because it sets up the proper keys and such so that
      # `vagrant destroy -f` works properly.
      class HaltConfirm < Vagrant::Action::Builtin::Confirm
        def initialize(app, env)
          force_key = :force_confirm_halt
          message   = I18n.t("vagrant_libvirt.package_confirm_halt",
                             name: env[:machine].name)

          super(app, env, message, force_key, allowed: ["y", "n", "Y", "N"])
        end
      end
    end
  end
end

