/* valaccodemacroreplacement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodemacroreplacement.h"
#include <ccode/valaccodemacroreplacement.h>

struct _ValaCCodeMacroReplacementPrivate {
	char* _name;
	char* _replacement;
};
#define VALA_CCODE_MACRO_REPLACEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_MACRO_REPLACEMENT, ValaCCodeMacroReplacementPrivate))
enum  {
	VALA_CCODE_MACRO_REPLACEMENT_DUMMY_PROPERTY,
	VALA_CCODE_MACRO_REPLACEMENT_NAME,
	VALA_CCODE_MACRO_REPLACEMENT_REPLACEMENT
};
static void vala_ccode_macro_replacement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_macro_replacement_parent_class = NULL;
static void vala_ccode_macro_replacement_dispose (GObject * obj);


ValaCCodeMacroReplacement* vala_ccode_macro_replacement_new (const char* n, const char* replace)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeMacroReplacement * self;
	g_return_val_if_fail (n != NULL, NULL);
	g_return_val_if_fail (replace != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, n), __params_it++);
	(__params_it->name = "replacement", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, replace), __params_it++);
	self = g_object_newv (VALA_TYPE_CCODE_MACRO_REPLACEMENT, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_macro_replacement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeMacroReplacement * self;
	self = ((ValaCCodeMacroReplacement*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "#define ");
	vala_ccode_writer_write_string (writer, vala_ccode_macro_replacement_get_name (self));
	vala_ccode_writer_write_string (writer, " ");
	vala_ccode_writer_write_string (writer, vala_ccode_macro_replacement_get_replacement (self));
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_macro_replacement_get_name (ValaCCodeMacroReplacement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self), NULL);
	return self->priv->_name;
}


void vala_ccode_macro_replacement_set_name (ValaCCodeMacroReplacement* self, const char* value)
{
	char* __temp1;
	g_return_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self));
	__temp1 = NULL;
	self->priv->_name = (__temp1 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp1);
}


char* vala_ccode_macro_replacement_get_replacement (ValaCCodeMacroReplacement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self), NULL);
	return self->priv->_replacement;
}


void vala_ccode_macro_replacement_set_replacement (ValaCCodeMacroReplacement* self, const char* value)
{
	char* __temp3;
	g_return_if_fail (VALA_IS_CCODE_MACRO_REPLACEMENT (self));
	__temp3 = NULL;
	self->priv->_replacement = (__temp3 = g_strdup (value), (self->priv->_replacement = (g_free (self->priv->_replacement), NULL)), __temp3);
}


static void vala_ccode_macro_replacement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeMacroReplacement * self;
	self = VALA_CCODE_MACRO_REPLACEMENT (object);
	switch (property_id) {
		case VALA_CCODE_MACRO_REPLACEMENT_NAME:
		g_value_set_string (value, vala_ccode_macro_replacement_get_name (self));
		break;
		case VALA_CCODE_MACRO_REPLACEMENT_REPLACEMENT:
		g_value_set_string (value, vala_ccode_macro_replacement_get_replacement (self));
		break;
	}
}


static void vala_ccode_macro_replacement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeMacroReplacement * self;
	self = VALA_CCODE_MACRO_REPLACEMENT (object);
	switch (property_id) {
		case VALA_CCODE_MACRO_REPLACEMENT_NAME:
		vala_ccode_macro_replacement_set_name (self, g_value_get_string (value));
		break;
		case VALA_CCODE_MACRO_REPLACEMENT_REPLACEMENT:
		vala_ccode_macro_replacement_set_replacement (self, g_value_get_string (value));
		break;
	}
}


static void vala_ccode_macro_replacement_class_init (ValaCCodeMacroReplacementClass * klass)
{
	vala_ccode_macro_replacement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMacroReplacementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_macro_replacement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_macro_replacement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_macro_replacement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_macro_replacement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_MACRO_REPLACEMENT_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_MACRO_REPLACEMENT_REPLACEMENT, g_param_spec_string ("replacement", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_macro_replacement_init (ValaCCodeMacroReplacement * self)
{
	self->priv = VALA_CCODE_MACRO_REPLACEMENT_GET_PRIVATE (self);
}


static void vala_ccode_macro_replacement_dispose (GObject * obj)
{
	ValaCCodeMacroReplacement * self;
	ValaCCodeMacroReplacementClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_MACRO_REPLACEMENT (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->_replacement = (g_free (self->priv->_replacement), NULL));
	klass = VALA_CCODE_MACRO_REPLACEMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_MACRO_REPLACEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_macro_replacement_get_type (void)
{
	static GType vala_ccode_macro_replacement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_macro_replacement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMacroReplacementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_macro_replacement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMacroReplacement), 0, (GInstanceInitFunc) vala_ccode_macro_replacement_init };
		vala_ccode_macro_replacement_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeMacroReplacement", &g_define_type_info, 0);
	}
	return vala_ccode_macro_replacement_type_id;
}




