/* valapointerindirection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valapointerindirection.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaPointerIndirectionPrivate {
	ValaExpression* _inner;
};
#define VALA_POINTER_INDIRECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionPrivate))
enum  {
	VALA_POINTER_INDIRECTION_DUMMY_PROPERTY,
	VALA_POINTER_INDIRECTION_INNER
};
static void vala_pointer_indirection_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_pointer_indirection_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_pointer_indirection_real_is_pure (ValaExpression* base);
static gpointer vala_pointer_indirection_parent_class = NULL;
static void vala_pointer_indirection_dispose (GObject * obj);


/**
 * Creates a new pointer indirection.
 *
 * @param inner pointer to be dereferenced
 * @return      newly created pointer indirection
 */
ValaPointerIndirection* vala_pointer_indirection_new (ValaExpression* inner, ValaSourceReference* source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaPointerIndirection * self;
	g_return_val_if_fail (inner == NULL || VALA_IS_EXPRESSION (inner), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "inner", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, inner), __params_it++);
	self = g_object_newv (VALA_TYPE_POINTER_INDIRECTION, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_pointer_indirection_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaPointerIndirection * self;
	self = VALA_POINTER_INDIRECTION (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_pointer_indirection_get_inner (self)), visitor);
	vala_code_visitor_visit_pointer_indirection (visitor, self);
}


static void vala_pointer_indirection_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaPointerIndirection * self;
	self = VALA_POINTER_INDIRECTION (base);
	g_return_if_fail (old_node == NULL || VALA_IS_EXPRESSION (old_node));
	g_return_if_fail (new_node == NULL || VALA_IS_EXPRESSION (new_node));
	if (vala_pointer_indirection_get_inner (self) == old_node) {
		vala_pointer_indirection_set_inner (self, new_node);
	}
}


static gboolean vala_pointer_indirection_real_is_pure (ValaExpression* base) {
	ValaPointerIndirection * self;
	self = VALA_POINTER_INDIRECTION (base);
	return vala_expression_is_pure (vala_pointer_indirection_get_inner (self));
}


ValaExpression* vala_pointer_indirection_get_inner (ValaPointerIndirection* self) {
	g_return_val_if_fail (VALA_IS_POINTER_INDIRECTION (self), NULL);
	return self->priv->_inner;
}


void vala_pointer_indirection_set_inner (ValaPointerIndirection* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_POINTER_INDIRECTION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_inner), VALA_CODE_NODE (self));
}


static void vala_pointer_indirection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaPointerIndirection * self;
	self = VALA_POINTER_INDIRECTION (object);
	switch (property_id) {
		case VALA_POINTER_INDIRECTION_INNER:
		g_value_set_object (value, vala_pointer_indirection_get_inner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_pointer_indirection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaPointerIndirection * self;
	self = VALA_POINTER_INDIRECTION (object);
	switch (property_id) {
		case VALA_POINTER_INDIRECTION_INNER:
		vala_pointer_indirection_set_inner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_pointer_indirection_class_init (ValaPointerIndirectionClass * klass) {
	vala_pointer_indirection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPointerIndirectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_pointer_indirection_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_pointer_indirection_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_pointer_indirection_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_pointer_indirection_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_pointer_indirection_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_pointer_indirection_real_is_pure;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_POINTER_INDIRECTION_INNER, g_param_spec_object ("inner", "inner", "inner", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_pointer_indirection_init (ValaPointerIndirection * self) {
	self->priv = VALA_POINTER_INDIRECTION_GET_PRIVATE (self);
}


static void vala_pointer_indirection_dispose (GObject * obj) {
	ValaPointerIndirection * self;
	self = VALA_POINTER_INDIRECTION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	G_OBJECT_CLASS (vala_pointer_indirection_parent_class)->dispose (obj);
}


GType vala_pointer_indirection_get_type (void) {
	static GType vala_pointer_indirection_type_id = 0;
	if (G_UNLIKELY (vala_pointer_indirection_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPointerIndirectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_pointer_indirection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPointerIndirection), 0, (GInstanceInitFunc) vala_pointer_indirection_init };
		vala_pointer_indirection_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaPointerIndirection", &g_define_type_info, 0);
	}
	return vala_pointer_indirection_type_id;
}




