/* gstreamer-rtp-0.10.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cprefix = "GST_RTCP_SDES_", cheader_filename = "gst/gst.h")]
	public enum RTCPSDESType {
		INVALID,
		END,
		CNAME,
		NAME,
		EMAIL,
		PHONE,
		LOC,
		TOOL,
		NOTE,
		PRIV,
	}
	[CCode (cprefix = "GST_RTCP_TYPE_", cheader_filename = "gst/gst.h")]
	public enum RTCPType {
		INVALID,
		SR,
		RR,
		SDES,
		BYE,
		APP,
	}
	[CCode (cprefix = "GST_RTP_PAYLOAD_", cheader_filename = "gst/gst.h")]
	public enum RTPPayload {
		PCMU,
		1016,
		G721,
		GSM,
		G723,
		DVI4_8000,
		DVI4_16000,
		LPC,
		PCMA,
		G722,
		L16_STEREO,
		L16_MONO,
		QCELP,
		CN,
		MPA,
		G728,
		DVI4_11025,
		DVI4_22050,
		G729,
		CELLB,
		JPEG,
		NV,
		H261,
		MPV,
		MP2T,
		H263,
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class RTCPPacket {
		public weak Gst.Buffer buffer;
		public uint offset;
		public bool padding;
		public uchar count;
		public Gst.RTCPType type;
		public ushort length;
		public uint item_offset;
		public uint item_count;
		public uint entry_offset;
		public bool add_rb (uint ssrc, uchar fractionlost, int packetslost, uint exthighestseq, uint jitter, uint lsr, uint dlsr);
		public bool bye_add_ssrc (uint ssrc);
		public bool bye_add_ssrcs (uint ssrc, uint len);
		public uint bye_get_nth_ssrc (uint nth);
		public weak string bye_get_reason ();
		public uchar bye_get_reason_len ();
		public uint bye_get_ssrc_count ();
		public bool bye_set_reason (string reason);
		public uchar get_count ();
		public ushort get_length ();
		public bool get_padding ();
		public void get_rb (uint nth, uint ssrc, uchar fractionlost, int packetslost, uint exthighestseq, uint jitter, uint lsr, uint dlsr);
		public uint get_rb_count ();
		public bool move_to_next ();
		public void remove ();
		public uint rr_get_ssrc ();
		public void rr_set_ssrc (uint ssrc);
		public bool sdes_add_entry (Gst.RTCPSDESType type, uchar len, uchar data);
		public bool sdes_add_item (uint ssrc);
		public bool sdes_copy_entry (Gst.RTCPSDESType type, uchar len, uchar data);
		public bool sdes_first_entry ();
		public bool sdes_first_item ();
		public bool sdes_get_entry (Gst.RTCPSDESType type, uchar len, uchar data);
		public uint sdes_get_item_count ();
		public uint sdes_get_ssrc ();
		public bool sdes_next_entry ();
		public bool sdes_next_item ();
		public void set_rb (uint nth, uint ssrc, uchar fractionlost, int packetslost, uint exthighestseq, uint jitter, uint lsr, uint dlsr);
		public void sr_get_sender_info (uint ssrc, uint64 ntptime, uint rtptime, uint packet_count, uint octet_count);
		public void sr_set_sender_info (uint ssrc, uint64 ntptime, uint rtptime, uint packet_count, uint octet_count);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class RTPPayloadInfo {
		public uchar payload_type;
		public weak string media;
		public weak string encoding_name;
		public uint clock_rate;
		public weak string encoding_parameters;
		public uint bitrate;
		public static weak Gst.RTPPayloadInfo for_name (string media, string encoding_name);
		public static weak Gst.RTPPayloadInfo for_pt (uchar payload_type);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class BaseRTPAudioPayload : Gst.BaseRTPPayload {
		public weak Gst.ClockTime base_ts;
		public int frame_size;
		public int frame_duration;
		public int sample_size;
		public weak Gst.Adapter get_adapter ();
		public Gst.FlowReturn push (uchar data, uint payload_len, Gst.ClockTime timestamp);
		public void set_frame_based ();
		public void set_frame_options (int frame_duration, int frame_size);
		public void set_sample_based ();
		public void set_sample_options (int sample_size);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class BaseRTPDepayload : Gst.Element {
		public weak Gst.Pad sinkpad;
		public weak Gst.Pad srcpad;
		public pointer queuelock;
		public bool thread_running;
		public weak GLib.Thread thread;
		public uint clock_rate;
		public weak GLib.Queue queue;
		public weak Gst.Segment segment;
		public bool need_newsegment;
		public Gst.FlowReturn push (Gst.Buffer out_buf);
		public Gst.FlowReturn push_ts (uint timestamp, Gst.Buffer out_buf);
		[NoAccessorMethod]
		public weak uint queue_delay { get; set; }
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public class BaseRTPPayload : Gst.Element {
		public weak Gst.Pad sinkpad;
		public weak Gst.Pad srcpad;
		public weak GLib.Rand seq_rand;
		public weak GLib.Rand ssrc_rand;
		public weak GLib.Rand ts_rand;
		public uint ts_base;
		public ushort seqnum_base;
		public weak string media;
		public weak string encoding_name;
		public bool dynamic;
		public uint clock_rate;
		public int ts_offset;
		public uint current_ssrc;
		public weak Gst.Segment segment;
		[CCode (cname = "gst_basertppayload_is_filled")]
		public bool is_filled (uint size, Gst.ClockTime duration);
		[CCode (cname = "gst_basertppayload_push")]
		public Gst.FlowReturn push (Gst.Buffer buffer);
		[CCode (cname = "gst_basertppayload_set_options")]
		public void set_options (string media, bool dynamic, string encoding_name, uint clock_rate);
		[CCode (cname = "gst_basertppayload_set_outcaps")]
		public bool set_outcaps (string fieldname);
		[NoAccessorMethod]
		public weak int64 max_ptime { get; set; }
		[NoAccessorMethod]
		public weak int64 min_ptime { get; set; }
		[NoAccessorMethod]
		public weak uint mtu { get; set; }
		[NoAccessorMethod]
		public weak uint pt { get; set; }
		[NoAccessorMethod]
		public weak uint seqnum { get; }
		[NoAccessorMethod]
		public weak int seqnum_offset { get; set; }
		[NoAccessorMethod]
		public weak uint ssrc { get; set; }
		[NoAccessorMethod]
		public weak uint timestamp { get; }
		[NoAccessorMethod]
		public weak uint timestamp_offset { get; set; }
	}
	public const int RTCP_MAX_BYE_SSRC_COUNT;
	public const int RTCP_MAX_RB_COUNT;
	public const int RTCP_MAX_SDES;
	public const int RTCP_MAX_SDES_ITEM_COUNT;
	public const int RTCP_VALID_MASK;
	public const int RTCP_VALID_VALUE;
	public const int RTCP_VERSION;
	public const string RTP_PAYLOAD_1016_STRING;
	public const string RTP_PAYLOAD_CELLB_STRING;
	public const string RTP_PAYLOAD_CN_STRING;
	public const string RTP_PAYLOAD_DVI4_11025_STRING;
	public const string RTP_PAYLOAD_DVI4_16000_STRING;
	public const string RTP_PAYLOAD_DVI4_22050_STRING;
	public const string RTP_PAYLOAD_DVI4_8000_STRING;
	public const string RTP_PAYLOAD_DYNAMIC_STRING;
	public const string RTP_PAYLOAD_G721_STRING;
	public const string RTP_PAYLOAD_G722_STRING;
	public const int RTP_PAYLOAD_G723_53;
	public const string RTP_PAYLOAD_G723_53_STRING;
	public const int RTP_PAYLOAD_G723_63;
	public const string RTP_PAYLOAD_G723_63_STRING;
	public const string RTP_PAYLOAD_G723_STRING;
	public const string RTP_PAYLOAD_G728_STRING;
	public const string RTP_PAYLOAD_G729_STRING;
	public const string RTP_PAYLOAD_GSM_STRING;
	public const string RTP_PAYLOAD_H261_STRING;
	public const string RTP_PAYLOAD_H263_STRING;
	public const string RTP_PAYLOAD_JPEG_STRING;
	public const string RTP_PAYLOAD_L16_MONO_STRING;
	public const string RTP_PAYLOAD_L16_STEREO_STRING;
	public const string RTP_PAYLOAD_LPC_STRING;
	public const string RTP_PAYLOAD_MP2T_STRING;
	public const string RTP_PAYLOAD_MPA_STRING;
	public const string RTP_PAYLOAD_MPV_STRING;
	public const string RTP_PAYLOAD_NV_STRING;
	public const string RTP_PAYLOAD_PCMA_STRING;
	public const string RTP_PAYLOAD_PCMU_STRING;
	public const string RTP_PAYLOAD_QCELP_STRING;
	public const int RTP_PAYLOAD_TS41;
	public const string RTP_PAYLOAD_TS41_STRING;
	public const int RTP_PAYLOAD_TS48;
	public const string RTP_PAYLOAD_TS48_STRING;
	public const int RTP_VERSION;
	public static bool rtcp_buffer_add_packet (Gst.Buffer buffer, Gst.RTCPType type, Gst.RTCPPacket packet);
	public static void rtcp_buffer_end (Gst.Buffer buffer);
	public static bool rtcp_buffer_get_first_packet (Gst.Buffer buffer, Gst.RTCPPacket packet);
	public static uint rtcp_buffer_get_packet_count (Gst.Buffer buffer);
	public static weak Gst.Buffer rtcp_buffer_new (uint mtu);
	public static weak Gst.Buffer rtcp_buffer_new_copy_data (pointer data, uint len);
	public static weak Gst.Buffer rtcp_buffer_new_take_data (pointer data, uint len);
	public static bool rtcp_buffer_validate (Gst.Buffer buffer);
	public static bool rtcp_buffer_validate_data (uchar data, uint len);
	public static uint64 rtcp_ntp_to_unix (uint64 ntptime);
	public static uint64 rtcp_unix_to_ntp (uint64 unixtime);
	public static void rtp_buffer_allocate_data (Gst.Buffer buffer, uint payload_len, uchar pad_len, uchar csrc_count);
	public static uint rtp_buffer_calc_header_len (uchar csrc_count);
	public static uint rtp_buffer_calc_packet_len (uint payload_len, uchar pad_len, uchar csrc_count);
	public static uint rtp_buffer_calc_payload_len (uint packet_len, uchar pad_len, uchar csrc_count);
	public static int rtp_buffer_compare_seqnum (ushort seqnum1, ushort seqnum2);
	public static uint rtp_buffer_default_clock_rate (uchar payload_type);
	public static uint64 rtp_buffer_ext_timestamp (uint64 exttimestamp, uint timestamp);
	public static uint rtp_buffer_get_csrc (Gst.Buffer buffer, uchar idx);
	public static uchar rtp_buffer_get_csrc_count (Gst.Buffer buffer);
	public static bool rtp_buffer_get_extension (Gst.Buffer buffer);
	public static bool rtp_buffer_get_extension_data (Gst.Buffer buffer, ushort bits, pointer data, uint wordlen);
	public static uint rtp_buffer_get_header_len (Gst.Buffer buffer);
	public static bool rtp_buffer_get_marker (Gst.Buffer buffer);
	public static uint rtp_buffer_get_packet_len (Gst.Buffer buffer);
	public static bool rtp_buffer_get_padding (Gst.Buffer buffer);
	public static pointer rtp_buffer_get_payload (Gst.Buffer buffer);
	public static weak Gst.Buffer rtp_buffer_get_payload_buffer (Gst.Buffer buffer);
	public static uint rtp_buffer_get_payload_len (Gst.Buffer buffer);
	public static weak Gst.Buffer rtp_buffer_get_payload_subbuffer (Gst.Buffer buffer, uint offset, uint len);
	public static uchar rtp_buffer_get_payload_type (Gst.Buffer buffer);
	public static ushort rtp_buffer_get_seq (Gst.Buffer buffer);
	public static uint rtp_buffer_get_ssrc (Gst.Buffer buffer);
	public static uint rtp_buffer_get_timestamp (Gst.Buffer buffer);
	public static uchar rtp_buffer_get_version (Gst.Buffer buffer);
	public static weak Gst.Buffer rtp_buffer_new_allocate (uint payload_len, uchar pad_len, uchar csrc_count);
	public static weak Gst.Buffer rtp_buffer_new_allocate_len (uint packet_len, uchar pad_len, uchar csrc_count);
	public static weak Gst.Buffer rtp_buffer_new_copy_data (pointer data, uint len);
	public static weak Gst.Buffer rtp_buffer_new_take_data (pointer data, uint len);
	public static void rtp_buffer_pad_to (Gst.Buffer buffer, uint len);
	public static void rtp_buffer_set_csrc (Gst.Buffer buffer, uchar idx, uint csrc);
	public static void rtp_buffer_set_extension (Gst.Buffer buffer, bool extension);
	public static void rtp_buffer_set_marker (Gst.Buffer buffer, bool marker);
	public static void rtp_buffer_set_packet_len (Gst.Buffer buffer, uint len);
	public static void rtp_buffer_set_padding (Gst.Buffer buffer, bool padding);
	public static void rtp_buffer_set_payload_type (Gst.Buffer buffer, uchar payload_type);
	public static void rtp_buffer_set_seq (Gst.Buffer buffer, ushort seq);
	public static void rtp_buffer_set_ssrc (Gst.Buffer buffer, uint ssrc);
	public static void rtp_buffer_set_timestamp (Gst.Buffer buffer, uint timestamp);
	public static void rtp_buffer_set_version (Gst.Buffer buffer, uchar version);
	public static bool rtp_buffer_validate (Gst.Buffer buffer);
	public static bool rtp_buffer_validate_data (uchar data, uint len);
}
