/* list.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gee/list.h>







/**
 * Returns the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be returned
 *
 * @return      the item at the specified index in the list
 */
gpointer gee_list_get (GeeList* self, gint index) {
	return GEE_LIST_GET_INTERFACE (self)->get (self, index);
}


/**
 * Sets the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be set
 */
void gee_list_set (GeeList* self, gint index, gconstpointer item) {
	GEE_LIST_GET_INTERFACE (self)->set (self, index, item);
}


/**
 * Returns the index of the first occurence of the specified item in
 * this list.
 *
 * @return the index of the first occurence of the specified item, or
 *         -1 if the item could not be found
 */
gint gee_list_index_of (GeeList* self, gconstpointer item) {
	return GEE_LIST_GET_INTERFACE (self)->index_of (self, item);
}


/**
 * Inserts an item into this list at the specified position.
 *
 * @param index zero-based index at which item is inserted
 * @param item  item to insert into the list
 */
void gee_list_insert (GeeList* self, gint index, gconstpointer item) {
	GEE_LIST_GET_INTERFACE (self)->insert (self, index, item);
}


/**
 * Removes the item at the specified index of this list.
 *
 * @param index zero-based index of the item to be removed
 */
void gee_list_remove_at (GeeList* self, gint index) {
	GEE_LIST_GET_INTERFACE (self)->remove_at (self, index);
}


static void gee_list_base_init (GeeListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gee_list_get_type (void) {
	static GType gee_list_type_id = 0;
	if (gee_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeListIface), (GBaseInitFunc) gee_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL };
		gee_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_list_type_id, GEE_TYPE_COLLECTION);
	}
	return gee_list_type_id;
}




