/* valaccodecreationmethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodecreationmethodbinding.h>
#include <vala/valamethod.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valablock.h>
#include <vala/valastatement.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaproperty.h>
#include <vala/valasymbol.h>
#include <vala/valapropertyaccessor.h>
#include <gobject/valaccodebinding.h>




struct _ValaCCodeCreationMethodBindingPrivate {
	ValaCreationMethod* _creation_method;
};

#define VALA_CCODE_CREATION_METHOD_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CREATION_METHOD_BINDING, ValaCCodeCreationMethodBindingPrivate))
enum  {
	VALA_CCODE_CREATION_METHOD_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_CREATION_METHOD_BINDING_CREATION_METHOD
};
static void vala_ccode_creation_method_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_creation_method_binding_parent_class = NULL;
static void vala_ccode_creation_method_binding_finalize (GObject * obj);



ValaCCodeCreationMethodBinding* vala_ccode_creation_method_binding_new (ValaCCodeGenerator* codegen, ValaCreationMethod* creation_method) {
	ValaCCodeCreationMethodBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (creation_method), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_CREATION_METHOD_BINDING, 0, NULL);
	vala_ccode_creation_method_binding_set_creation_method (self, creation_method);
	vala_ccode_method_binding_set_method (VALA_CCODE_METHOD_BINDING (self), VALA_METHOD (creation_method));
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_creation_method_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeCreationMethodBinding * self;
	ValaCreationMethod* _tmp0;
	ValaCreationMethod* m;
	self = VALA_CCODE_CREATION_METHOD_BINDING (base);
	_tmp0 = NULL;
	m = (_tmp0 = self->priv->_creation_method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (vala_method_get_body (VALA_METHOD (m)) != NULL && VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
		gint n_params;
		n_params = 0;
		{
			GeeList* stmt_collection;
			int stmt_it;
			stmt_collection = vala_block_get_statements (vala_method_get_body (VALA_METHOD (m)));
			for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
				ValaStatement* stmt;
				stmt = ((ValaStatement*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)));
				{
					ValaProperty* _tmp1;
					gboolean _tmp2;
					ValaProperty* prop;
					_tmp1 = NULL;
					if ((_tmp2 = !(VALA_IS_EXPRESSION_STATEMENT (stmt)) || (_tmp1 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))) == NULL, (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2)) {
						vala_code_node_set_error (VALA_CODE_NODE (m), TRUE);
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (stmt)), "class creation methods only allow property assignment statements");
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
						(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
						(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
						return;
					}
					prop = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)));
					if (vala_symbol_get_access (VALA_SYMBOL (prop)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						vala_code_node_set_error (VALA_CODE_NODE (m), TRUE);
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (stmt)), "class creation methods only allow assignments to public and protected properties");
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
						(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
						(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
						return;
					}
					if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
						n_params++;
					}
					(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				}
			}
			(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
		}
		vala_creation_method_set_n_construction_params (m, n_params);
	}
	VALA_CCODE_BINDING_CLASS (vala_ccode_creation_method_binding_parent_class)->emit (VALA_CCODE_BINDING (VALA_CCODE_METHOD_BINDING (self)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
}


ValaCreationMethod* vala_ccode_creation_method_binding_get_creation_method (ValaCCodeCreationMethodBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_CREATION_METHOD_BINDING (self), NULL);
	return self->priv->_creation_method;
}


void vala_ccode_creation_method_binding_set_creation_method (ValaCCodeCreationMethodBinding* self, ValaCreationMethod* value) {
	ValaCreationMethod* _tmp2;
	ValaCreationMethod* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_CREATION_METHOD_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_creation_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_creation_method == NULL ? NULL : (self->priv->_creation_method = (g_object_unref (self->priv->_creation_method), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "creation-method");
}


static void vala_ccode_creation_method_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeCreationMethodBinding * self;
	self = VALA_CCODE_CREATION_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_CREATION_METHOD_BINDING_CREATION_METHOD:
		g_value_set_object (value, vala_ccode_creation_method_binding_get_creation_method (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_creation_method_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeCreationMethodBinding * self;
	self = VALA_CCODE_CREATION_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_CREATION_METHOD_BINDING_CREATION_METHOD:
		vala_ccode_creation_method_binding_set_creation_method (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_creation_method_binding_class_init (ValaCCodeCreationMethodBindingClass * klass) {
	vala_ccode_creation_method_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeCreationMethodBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_creation_method_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_creation_method_binding_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_ccode_creation_method_binding_finalize;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_creation_method_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_CREATION_METHOD_BINDING_CREATION_METHOD, g_param_spec_object ("creation-method", "creation-method", "creation-method", VALA_TYPE_CREATION_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_creation_method_binding_instance_init (ValaCCodeCreationMethodBinding * self) {
	self->priv = VALA_CCODE_CREATION_METHOD_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_creation_method_binding_finalize (GObject * obj) {
	ValaCCodeCreationMethodBinding * self;
	self = VALA_CCODE_CREATION_METHOD_BINDING (obj);
	(self->priv->_creation_method == NULL ? NULL : (self->priv->_creation_method = (g_object_unref (self->priv->_creation_method), NULL)));
	G_OBJECT_CLASS (vala_ccode_creation_method_binding_parent_class)->finalize (obj);
}


GType vala_ccode_creation_method_binding_get_type (void) {
	static GType vala_ccode_creation_method_binding_type_id = 0;
	if (vala_ccode_creation_method_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCreationMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_creation_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCreationMethodBinding), 0, (GInstanceInitFunc) vala_ccode_creation_method_binding_instance_init };
		vala_ccode_creation_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_BINDING, "ValaCCodeCreationMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_creation_method_binding_type_id;
}




