/* valaccodemethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodbinding.h>
#include <vala/valacodenode.h>
#include <vala/valaattribute.h>
#include <vala/valacreationmethod.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <gee/collection.h>
#include <vala/valasymbol.h>
#include <vala/valainterface.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <vala/valavaluetype.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodestruct.h>
#include <vala/valaclasstype.h>
#include <vala/valatypeparameter.h>
#include <vala/valareferencetype.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodestatement.h>
#include <vala/valaformalparameter.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodereturnstatement.h>
#include <gee/list.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodewhilestatement.h>
#include <vala/valamethodtype.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeMethodBindingPrivate {
	ValaMethod* _method;
};

#define VALA_CCODE_METHOD_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_METHOD_BINDING, ValaCCodeMethodBindingPrivate))
enum  {
	VALA_CCODE_METHOD_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_METHOD_BINDING_METHOD,
	VALA_CCODE_METHOD_BINDING_HAS_WRAPPER
};
static char* vala_ccode_method_binding_get_creturn_type (ValaCCodeMethodBinding* self, const char* default_value);
static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base);
static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition);
static ValaTypeSymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym);
static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params);
static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl);
static gpointer vala_ccode_method_binding_parent_class = NULL;
static void vala_ccode_method_binding_finalize (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



char* vala_ccode_method_binding_get_custom_creturn_type (ValaCCodeMethodBinding* self) {
	ValaAttribute* attr;
	char* _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	attr = vala_code_node_get_attribute (VALA_CODE_NODE (self->priv->_method), "CCode");
	if (attr != NULL) {
		char* type;
		type = vala_attribute_get_string (attr, "type");
		if (type != NULL) {
			char* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = type, (attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL))), _tmp0);
		}
		type = (g_free (type), NULL);
	}
	_tmp1 = NULL;
	return (_tmp1 = NULL, (attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL))), _tmp1);
}


static char* vala_ccode_method_binding_get_creturn_type (ValaCCodeMethodBinding* self, const char* default_value) {
	char* type;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	type = vala_ccode_method_binding_get_custom_creturn_type (self);
	if (type == NULL) {
		const char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = (_tmp0 = default_value, (_tmp0 == NULL ? NULL : g_strdup (_tmp0))), (type = (g_free (type), NULL)), _tmp1);
	}
	return type;
}


ValaCCodeMethodBinding* vala_ccode_method_binding_new (ValaCCodeGenerator* codegen, ValaMethod* method) {
	ValaCCodeMethodBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (method), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_METHOD_BINDING, 0, NULL);
	vala_ccode_method_binding_set_method (self, method);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_method_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeMethodBinding * self;
	ValaMethod* _tmp0;
	ValaMethod* m;
	ValaMethod* _tmp1;
	ValaMethod* old_method;
	ValaDataType* _tmp2;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp4;
	ValaSymbol* _tmp3;
	ValaMethod* _tmp6;
	ValaMethod* _tmp5;
	ValaDataType* _tmp8;
	ValaDataType* _tmp7;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp9;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaSymbol* _tmp19;
	ValaSymbol* _tmp18;
	ValaMethod* _tmp21;
	ValaMethod* _tmp20;
	ValaDataType* _tmp23;
	ValaDataType* _tmp22;
	ValaCCodeFunction* _tmp28;
	char* _tmp27;
	char* _tmp26;
	char* _tmp25;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = VALA_CCODE_METHOD_BINDING (base);
	_tmp0 = NULL;
	m = (_tmp0 = self->priv->_method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_method = (_tmp1 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_return_type = (_tmp2 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	old_method_inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	old_next_temp_var_id = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp4 = (_tmp3 = VALA_SYMBOL (m), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp4);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp6 = (_tmp5 = m, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp6);
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp8 = (_tmp7 = vala_method_get_return_type (m), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp8);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = FALSE;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = 0;
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	_tmp9 = NULL;
	creturn_type = (_tmp9 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp11;
		ValaTypeSymbol* _tmp10;
		ValaClass* cl;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = TRUE;
		_tmp11 = NULL;
		_tmp10 = NULL;
		cl = (_tmp11 = (_tmp10 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, (VALA_IS_CLASS (_tmp10) ? ((ValaClass*) (_tmp10)) : NULL)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
		if (cl != NULL && !vala_class_get_is_compact (cl)) {
			in_gtypeinstance_creation_method = TRUE;
			if (vala_class_get_base_class (cl) == NULL) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp12;
			_tmp12 = NULL;
			creturn_type = (_tmp12 = VALA_DATA_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl))), (creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL))), _tmp12);
		}
		(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (in_gobject_creation_method && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			GeeList* _tmp15;
			cblock = vala_ccode_block_new ();
			{
				GeeList* stmt_collection;
				int stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
					ValaCodeNode* stmt;
					stmt = ((ValaCodeNode*) (VALA_CODE_NODE (gee_list_get (GEE_LIST (stmt_collection), stmt_it))));
					{
						ValaProperty* _tmp13;
						gboolean _tmp14;
						_tmp13 = NULL;
						if ((_tmp14 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp13 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeList* cstmt_collection;
									int cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
			}
			_tmp15 = NULL;
			vala_ccode_method_binding_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size (GEE_COLLECTION ((_tmp15 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))) > 0);
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			{
				GeeList* stmt_collection;
				int stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
					ValaCodeNode* stmt;
					stmt = ((ValaCodeNode*) (VALA_CODE_NODE (gee_list_get (GEE_LIST (stmt_collection), stmt_it))));
					{
						ValaProperty* _tmp16;
						gboolean _tmp17;
						_tmp16 = NULL;
						if ((_tmp17 = !vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp16 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), _tmp17)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeList* cstmt_collection;
									int cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									for (cstmt_it = 0; cstmt_it < gee_collection_get_size (GEE_COLLECTION (cstmt_collection)); cstmt_it = cstmt_it + 1) {
										ValaCCodeNode* cstmt;
										cstmt = ((ValaCCodeNode*) (gee_list_get (GEE_LIST (cstmt_collection), cstmt_it)));
										{
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)), VALA_CCODE_NODE (cblock));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		}
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_creation_method = FALSE;
	}
	inner_error = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error;
	_tmp19 = NULL;
	_tmp18 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp19 = (_tmp18 = vala_symbol_get_parent_symbol (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp19);
	_tmp21 = NULL;
	_tmp20 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (_tmp21 = (_tmp20 = old_method, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method), NULL))), _tmp21);
	_tmp23 = NULL;
	_tmp22 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (_tmp23 = (_tmp22 = old_return_type, (_tmp22 == NULL ? NULL : g_object_ref (_tmp22))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_return_type), NULL))), _tmp23);
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = old_method_inner_error;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->next_temp_var_id = old_next_temp_var_id;
	if (VALA_IS_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
		ValaInterface* _tmp24;
		ValaInterface* iface;
		_tmp24 = NULL;
		iface = (_tmp24 = VALA_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
			(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	_tmp28 = NULL;
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (_tmp28 = vala_ccode_function_new ((_tmp25 = vala_method_get_real_cname (m)), (_tmp27 = vala_ccode_method_binding_get_creturn_type (self, (_tmp26 = vala_data_type_get_cname (creturn_type))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function = (g_object_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), NULL))), _tmp28);
	_tmp27 = (g_free (_tmp27), NULL);
	_tmp26 = (g_free (_tmp26), NULL);
	_tmp25 = (g_free (_tmp25), NULL);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE || (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && VALA_IS_CREATION_METHOD (m))) {
		ValaTypeSymbol* parent_type;
		ValaDataType* this_type;
		ValaCCodeFormalParameter* instance_param;
		parent_type = vala_ccode_method_binding_find_parent_type (self, VALA_SYMBOL (m));
		this_type = NULL;
		if (VALA_IS_CLASS (parent_type)) {
			ValaDataType* _tmp29;
			_tmp29 = NULL;
			this_type = (_tmp29 = VALA_DATA_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (parent_type)))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp29);
		} else {
			if (VALA_IS_INTERFACE (parent_type)) {
				ValaDataType* _tmp30;
				_tmp30 = NULL;
				this_type = (_tmp30 = VALA_DATA_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (parent_type)))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp30);
			} else {
				ValaDataType* _tmp31;
				_tmp31 = NULL;
				this_type = (_tmp31 = VALA_DATA_TYPE (vala_value_type_new (parent_type)), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp31);
			}
		}
		instance_param = NULL;
		if (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m)) {
			ValaObjectType* base_type;
			ValaCCodeFormalParameter* _tmp33;
			char* _tmp32;
			base_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m))))));
			_tmp33 = NULL;
			_tmp32 = NULL;
			instance_param = (_tmp33 = vala_ccode_formal_parameter_new ("base", (_tmp32 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type)))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp33);
			_tmp32 = (g_free (_tmp32), NULL);
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaObjectType* base_type;
				ValaCCodeFormalParameter* _tmp35;
				char* _tmp34;
				base_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m))))));
				_tmp35 = NULL;
				_tmp34 = NULL;
				instance_param = (_tmp35 = vala_ccode_formal_parameter_new ("base", (_tmp34 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type)))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp35);
				_tmp34 = (g_free (_tmp34), NULL);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))) {
					ValaCCodeFormalParameter* _tmp37;
					char* _tmp36;
					_tmp37 = NULL;
					_tmp36 = NULL;
					instance_param = (_tmp37 = vala_ccode_formal_parameter_new ("*self", (_tmp36 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp37);
					_tmp36 = (g_free (_tmp36), NULL);
				} else {
					ValaCCodeFormalParameter* _tmp39;
					char* _tmp38;
					_tmp39 = NULL;
					_tmp38 = NULL;
					instance_param = (_tmp39 = vala_ccode_formal_parameter_new ("self", (_tmp38 = vala_data_type_get_cname (this_type))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp39);
					_tmp38 = (g_free (_tmp38), NULL);
				}
			}
		}
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			char* _tmp41;
			char* _tmp40;
			ValaCCodeDeclaration* _tmp42;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp43;
			_tmp41 = NULL;
			_tmp40 = NULL;
			_tmp42 = NULL;
			vdecl = (_tmp42 = vala_ccode_declaration_new ((_tmp41 = vala_ccode_method_binding_get_creturn_type (self, (_tmp40 = vala_data_type_get_cname (creturn_type))))), (_tmp41 = (g_free (_tmp41), NULL)), (_tmp40 = (g_free (_tmp40), NULL)), _tmp42);
			_tmp43 = NULL;
			vdeclarator = (_tmp43 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), _tmp43);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, vdecl);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(parent_type == NULL ? NULL : (parent_type = (g_object_unref (parent_type), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	} else {
		if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaTypeSymbol* parent_type;
			ValaDataType* this_type;
			ValaDataType* _tmp44;
			char* _tmp45;
			ValaCCodeFormalParameter* _tmp46;
			ValaCCodeFormalParameter* class_param;
			parent_type = vala_ccode_method_binding_find_parent_type (self, VALA_SYMBOL (m));
			this_type = NULL;
			_tmp44 = NULL;
			this_type = (_tmp44 = VALA_DATA_TYPE (vala_class_type_new (VALA_CLASS (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp44);
			_tmp45 = NULL;
			_tmp46 = NULL;
			class_param = (_tmp46 = vala_ccode_formal_parameter_new ("klass", (_tmp45 = vala_data_type_get_cname (this_type))), (_tmp45 = (g_free (_tmp45), NULL)), _tmp46);
			gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
			(parent_type == NULL ? NULL : (parent_type = (g_object_unref (parent_type), NULL)));
			(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
			(class_param == NULL ? NULL : (class_param = (g_object_unref (class_param), NULL)));
		}
	}
	if (in_gtypeinstance_creation_method) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeList* type_param_collection;
			int type_param_it;
			type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
			for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
				{
					ValaCCodeFormalParameter* _tmp49;
					char* _tmp48;
					char* _tmp47;
					ValaCCodeFormalParameter* _tmp52;
					char* _tmp51;
					char* _tmp50;
					ValaCCodeFormalParameter* _tmp55;
					char* _tmp54;
					char* _tmp53;
					_tmp49 = NULL;
					_tmp48 = NULL;
					_tmp47 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.01, FALSE)), (_tmp49 = vala_ccode_formal_parameter_new ((_tmp48 = g_strdup_printf ("%s_type", (_tmp47 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GType")));
					(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
					_tmp48 = (g_free (_tmp48), NULL);
					_tmp47 = (g_free (_tmp47), NULL);
					_tmp52 = NULL;
					_tmp51 = NULL;
					_tmp50 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.02, FALSE)), (_tmp52 = vala_ccode_formal_parameter_new ((_tmp51 = g_strdup_printf ("%s_dup_func", (_tmp50 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GBoxedCopyFunc")));
					(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
					_tmp51 = (g_free (_tmp51), NULL);
					_tmp50 = (g_free (_tmp50), NULL);
					_tmp55 = NULL;
					_tmp54 = NULL;
					_tmp53 = NULL;
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1 * type_param_index + 0.03, FALSE)), (_tmp55 = vala_ccode_formal_parameter_new ((_tmp54 = g_strdup_printf ("%s_destroy_func", (_tmp53 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GDestroyNotify")));
					(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
					_tmp54 = (g_free (_tmp54), NULL);
					_tmp53 = (g_free (_tmp53), NULL);
					type_param_index++;
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
		}
	}
	vala_ccode_method_binding_generate_cparameters (self, m, creturn_type, GEE_MAP (cparam_map), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vdeclarator);
	visible = !vala_symbol_is_internal_symbol (VALA_SYMBOL (m));
	/* generate *_real_* functions for virtual methods
	 also generate them for abstract methods of classes to prevent faulty subclassing*/
	if (!vala_method_get_is_abstract (m) || (vala_method_get_is_abstract (m) && VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol))) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* _tmp56;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp56 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp56 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
		} else {
			ValaCCodeFunction* _tmp57;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, vala_ccode_function_get_modifiers (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp57 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp57 = vala_ccode_function_copy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))));
			(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)))));
			vala_ccode_node_set_line (VALA_CCODE_NODE (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
				ValaClass* _tmp58;
				ValaClass* cl;
				_tmp58 = NULL;
				cl = (_tmp58 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp58 == NULL ? NULL : g_object_ref (_tmp58)));
				if (vala_method_get_overrides (m) || (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m))) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaObjectType* self_target_type;
					ValaCCodeIdentifier* _tmp65;
					ValaCCodeExpression* _tmp66;
					ValaCCodeExpression* cself;
					char* _tmp68;
					char* _tmp67;
					ValaCCodeDeclaration* _tmp69;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp70;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp60;
						ValaMethod* _tmp59;
						ValaReferenceType* _tmp61;
						_tmp60 = NULL;
						_tmp59 = NULL;
						base_method = (_tmp60 = (_tmp59 = vala_method_get_base_method (m), (_tmp59 == NULL ? NULL : g_object_ref (_tmp59))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp60);
						_tmp61 = NULL;
						base_expression_type = (_tmp61 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method)))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp61);
					} else {
						ValaMethod* _tmp63;
						ValaMethod* _tmp62;
						ValaReferenceType* _tmp64;
						_tmp63 = NULL;
						_tmp62 = NULL;
						base_method = (_tmp63 = (_tmp62 = vala_method_get_base_interface_method (m), (_tmp62 == NULL ? NULL : g_object_ref (_tmp62))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp63);
						_tmp64 = NULL;
						base_expression_type = (_tmp64 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method)))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp64);
					}
					self_target_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl));
					_tmp65 = NULL;
					_tmp66 = NULL;
					cself = (_tmp66 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_identifier_new ("base"))), VALA_DATA_TYPE (base_expression_type), VALA_DATA_TYPE (self_target_type), NULL), (_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL))), _tmp66);
					_tmp68 = NULL;
					_tmp67 = NULL;
					_tmp69 = NULL;
					cdecl_ = (_tmp69 = vala_ccode_declaration_new ((_tmp68 = g_strdup_printf ("%s *", (_tmp67 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp68 = (g_free (_tmp68), NULL)), (_tmp67 = (g_free (_tmp67), NULL)), _tmp69);
					_tmp70 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp70 = vala_ccode_variable_declarator_new_with_initializer ("self", cself))));
					(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
					(base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL)));
					(self_target_type == NULL ? NULL : (self_target_type = (g_object_unref (self_target_type), NULL)));
					(cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, VALA_TYPESYMBOL (cl), TRUE, "self");
						vala_ccode_node_set_line (VALA_CCODE_NODE (ccheckstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (ccheckstmt));
						(ccheckstmt == NULL ? NULL : (ccheckstmt = (g_object_unref (ccheckstmt), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						ValaTypeSymbol* _tmp71;
						ValaTypeSymbol* t;
						if (vala_formal_parameter_get_ellipsis (param)) {
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							break;
						}
						_tmp71 = NULL;
						t = (_tmp71 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), (_tmp71 == NULL ? NULL : g_object_ref (_tmp71)));
						if (t != NULL && vala_typesymbol_is_reference_type (t)) {
							if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
								ValaCCodeStatement* type_check;
								type_check = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, t, (vala_code_context_get_non_null (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))), vala_symbol_get_name (VALA_SYMBOL (param)));
								if (type_check != NULL) {
									vala_ccode_node_set_line (VALA_CCODE_NODE (type_check), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
								}
								(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
							} else {
								ValaCCodeConstant* _tmp74;
								ValaCCodeUnaryExpression* _tmp73;
								ValaCCodeIdentifier* _tmp72;
								ValaCCodeAssignment* _tmp75;
								ValaCCodeAssignment* a;
								ValaCCodeExpressionStatement* _tmp76;
								/* ensure that the passed reference for output parameter is cleared*/
								_tmp74 = NULL;
								_tmp73 = NULL;
								_tmp72 = NULL;
								_tmp75 = NULL;
								a = (_tmp75 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))), VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL))), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), (_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL))), _tmp75);
								_tmp76 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp76 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (a)))));
								(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
								(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
							}
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp78;
				ValaCCodeConstant* _tmp77;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp78 = NULL;
				_tmp77 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp78 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_constant_new ("NULL")))))));
				(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
				(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* _tmp79;
				_tmp79 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp79 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
			}
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					GeeList* _tmp80;
					gboolean _tmp81;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					_tmp80 = NULL;
					if ((_tmp81 = n_params > 0 || gee_collection_get_size (GEE_COLLECTION ((_tmp80 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))) > 0, (_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL))), _tmp81)) {
						ValaCCodeIdentifier* _tmp82;
						ValaCCodeFunctionCall* _tmp83;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp84;
						ValaCCodeConstant* _tmp87;
						char* _tmp86;
						GeeList* _tmp85;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp88;
						ValaCCodeDeclaration* _tmp89;
						ValaCCodeVariableDeclarator* _tmp91;
						ValaCCodeIdentifier* _tmp90;
						/* declare construction parameter array*/
						_tmp82 = NULL;
						_tmp83 = NULL;
						cparamsinit = (_tmp83 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new ("g_new0")))), (_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL))), _tmp83);
						_tmp84 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new ("GParameter"))));
						(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
						_tmp87 = NULL;
						_tmp86 = NULL;
						_tmp85 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_constant_new ((_tmp86 = g_strdup_printf ("%i", (n_params + 3 * gee_collection_get_size (GEE_COLLECTION ((_tmp85 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))))))))));
						(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
						_tmp86 = (g_free (_tmp86), NULL);
						(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp88 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp88 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
						(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						_tmp89 = NULL;
						cdecl_ = (_tmp89 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp89);
						_tmp91 = NULL;
						_tmp90 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp91 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_identifier_new ("__params")))))));
						(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
						(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeList* type_param_collection;
						int type_param_it;
						type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
						for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
							ValaTypeParameter* type_param;
							type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
							{
								ValaCCodeConstant* prop_name;
								ValaCCodeIdentifier* param_name;
								ValaCCodeConstant* _tmp94;
								char* _tmp93;
								char* _tmp92;
								ValaCCodeIdentifier* _tmp97;
								char* _tmp96;
								char* _tmp95;
								ValaCCodeExpressionStatement* _tmp100;
								ValaCCodeExpression* _tmp99;
								ValaValueType* _tmp98;
								ValaCCodeConstant* _tmp103;
								char* _tmp102;
								char* _tmp101;
								ValaCCodeIdentifier* _tmp106;
								char* _tmp105;
								char* _tmp104;
								ValaCCodeExpressionStatement* _tmp110;
								ValaCCodeExpression* _tmp109;
								ValaPointerType* _tmp108;
								ValaVoidType* _tmp107;
								ValaCCodeConstant* _tmp113;
								char* _tmp112;
								char* _tmp111;
								ValaCCodeIdentifier* _tmp116;
								char* _tmp115;
								char* _tmp114;
								ValaCCodeExpressionStatement* _tmp120;
								ValaCCodeExpression* _tmp119;
								ValaPointerType* _tmp118;
								ValaVoidType* _tmp117;
								prop_name = NULL;
								param_name = NULL;
								_tmp94 = NULL;
								_tmp93 = NULL;
								_tmp92 = NULL;
								prop_name = (_tmp94 = vala_ccode_constant_new ((_tmp93 = g_strdup_printf ("\"%s-type\"", (_tmp92 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp94);
								_tmp93 = (g_free (_tmp93), NULL);
								_tmp92 = (g_free (_tmp92), NULL);
								_tmp97 = NULL;
								_tmp96 = NULL;
								_tmp95 = NULL;
								param_name = (_tmp97 = vala_ccode_identifier_new ((_tmp96 = g_strdup_printf ("%s_type", (_tmp95 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp97);
								_tmp96 = (g_free (_tmp96), NULL);
								_tmp95 = (g_free (_tmp95), NULL);
								_tmp100 = NULL;
								_tmp99 = NULL;
								_tmp98 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp100 = vala_ccode_expression_statement_new ((_tmp99 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp98 = vala_value_type_new (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtype_type))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
								(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
								(_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL)));
								_tmp103 = NULL;
								_tmp102 = NULL;
								_tmp101 = NULL;
								prop_name = (_tmp103 = vala_ccode_constant_new ((_tmp102 = g_strdup_printf ("\"%s-dup-func\"", (_tmp101 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp103);
								_tmp102 = (g_free (_tmp102), NULL);
								_tmp101 = (g_free (_tmp101), NULL);
								_tmp106 = NULL;
								_tmp105 = NULL;
								_tmp104 = NULL;
								param_name = (_tmp106 = vala_ccode_identifier_new ((_tmp105 = g_strdup_printf ("%s_dup_func", (_tmp104 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp106);
								_tmp105 = (g_free (_tmp105), NULL);
								_tmp104 = (g_free (_tmp104), NULL);
								_tmp110 = NULL;
								_tmp109 = NULL;
								_tmp108 = NULL;
								_tmp107 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp110 = vala_ccode_expression_statement_new ((_tmp109 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp108 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp107 = vala_void_type_new ())), NULL))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
								(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
								(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
								(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
								_tmp113 = NULL;
								_tmp112 = NULL;
								_tmp111 = NULL;
								prop_name = (_tmp113 = vala_ccode_constant_new ((_tmp112 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp111 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL))), _tmp113);
								_tmp112 = (g_free (_tmp112), NULL);
								_tmp111 = (g_free (_tmp111), NULL);
								_tmp116 = NULL;
								_tmp115 = NULL;
								_tmp114 = NULL;
								param_name = (_tmp116 = vala_ccode_identifier_new ((_tmp115 = g_strdup_printf ("%s_destroy_func", (_tmp114 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp116);
								_tmp115 = (g_free (_tmp115), NULL);
								_tmp114 = (g_free (_tmp114), NULL);
								_tmp120 = NULL;
								_tmp119 = NULL;
								_tmp118 = NULL;
								_tmp117 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp120 = vala_ccode_expression_statement_new ((_tmp119 = vala_ccode_binding_get_construct_property_assignment (VALA_CCODE_BINDING (self), prop_name, VALA_DATA_TYPE ((_tmp118 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp117 = vala_void_type_new ())), NULL))), VALA_CCODE_EXPRESSION (param_name)))))));
								(_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL)));
								(_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL)));
								(_tmp118 == NULL ? NULL : (_tmp118 = (g_object_unref (_tmp118), NULL)));
								(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
								(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
								(prop_name == NULL ? NULL : (prop_name = (g_object_unref (prop_name), NULL)));
								(param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
					}
				} else {
					if (in_gtypeinstance_creation_method) {
						ValaClass* _tmp121;
						ValaClass* cl;
						char* _tmp123;
						char* _tmp122;
						ValaCCodeDeclaration* _tmp124;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp125;
						ValaCCodeFunctionCall* _tmp126;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp128;
						char* _tmp127;
						ValaCCodeVariableDeclarator* _tmp132;
						ValaCCodeCastExpression* _tmp131;
						char* _tmp130;
						char* _tmp129;
						_tmp121 = NULL;
						cl = (_tmp121 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp121 == NULL ? NULL : g_object_ref (_tmp121)));
						_tmp123 = NULL;
						_tmp122 = NULL;
						_tmp124 = NULL;
						cdecl_ = (_tmp124 = vala_ccode_declaration_new ((_tmp123 = g_strconcat ((_tmp122 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp123 = (g_free (_tmp123), NULL)), (_tmp122 = (g_free (_tmp122), NULL)), _tmp124);
						_tmp125 = NULL;
						_tmp126 = NULL;
						ccall = (_tmp126 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_identifier_new ("g_type_create_instance")))), (_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL))), _tmp126);
						_tmp128 = NULL;
						_tmp127 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_identifier_new ((_tmp127 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
						(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
						_tmp127 = (g_free (_tmp127), NULL);
						_tmp132 = NULL;
						_tmp131 = NULL;
						_tmp130 = NULL;
						_tmp129 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp132 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp131 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ccall), (_tmp130 = g_strconcat ((_tmp129 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL)))))))));
						(_tmp132 == NULL ? NULL : (_tmp132 = (g_object_unref (_tmp132), NULL)));
						(_tmp131 == NULL ? NULL : (_tmp131 = (g_object_unref (_tmp131), NULL)));
						_tmp130 = (g_free (_tmp130), NULL);
						_tmp129 = (g_free (_tmp129), NULL);
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						/* type, dup func, and destroy func fields for generic types */
						{
							GeeList* type_param_collection;
							int type_param_it;
							type_param_collection = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class);
							for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
								ValaTypeParameter* type_param;
								type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
								{
									ValaCCodeIdentifier* param_name;
									ValaCCodeAssignment* assign;
									ValaCCodeIdentifier* _tmp133;
									ValaCCodeMemberAccess* _tmp134;
									ValaCCodeMemberAccess* priv_access;
									ValaCCodeIdentifier* _tmp137;
									char* _tmp136;
									char* _tmp135;
									ValaCCodeAssignment* _tmp139;
									ValaCCodeMemberAccess* _tmp138;
									ValaCCodeExpressionStatement* _tmp140;
									ValaCCodeIdentifier* _tmp143;
									char* _tmp142;
									char* _tmp141;
									ValaCCodeAssignment* _tmp145;
									ValaCCodeMemberAccess* _tmp144;
									ValaCCodeExpressionStatement* _tmp146;
									ValaCCodeIdentifier* _tmp149;
									char* _tmp148;
									char* _tmp147;
									ValaCCodeAssignment* _tmp151;
									ValaCCodeMemberAccess* _tmp150;
									ValaCCodeExpressionStatement* _tmp152;
									param_name = NULL;
									assign = NULL;
									_tmp133 = NULL;
									_tmp134 = NULL;
									priv_access = (_tmp134 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp133 = vala_ccode_identifier_new ("self"))), "priv"), (_tmp133 == NULL ? NULL : (_tmp133 = (g_object_unref (_tmp133), NULL))), _tmp134);
									_tmp137 = NULL;
									_tmp136 = NULL;
									_tmp135 = NULL;
									param_name = (_tmp137 = vala_ccode_identifier_new ((_tmp136 = g_strdup_printf ("%s_type", (_tmp135 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp137);
									_tmp136 = (g_free (_tmp136), NULL);
									_tmp135 = (g_free (_tmp135), NULL);
									_tmp139 = NULL;
									_tmp138 = NULL;
									assign = (_tmp139 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp138 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (priv_access), vala_ccode_identifier_get_name (param_name)))), VALA_CCODE_EXPRESSION (param_name), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL))), _tmp139);
									(_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL)));
									_tmp140 = NULL;
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp140 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
									(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
									_tmp143 = NULL;
									_tmp142 = NULL;
									_tmp141 = NULL;
									param_name = (_tmp143 = vala_ccode_identifier_new ((_tmp142 = g_strdup_printf ("%s_dup_func", (_tmp141 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp143);
									_tmp142 = (g_free (_tmp142), NULL);
									_tmp141 = (g_free (_tmp141), NULL);
									_tmp145 = NULL;
									_tmp144 = NULL;
									assign = (_tmp145 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp144 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (priv_access), vala_ccode_identifier_get_name (param_name)))), VALA_CCODE_EXPRESSION (param_name), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL))), _tmp145);
									(_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL)));
									_tmp146 = NULL;
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp146 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
									(_tmp146 == NULL ? NULL : (_tmp146 = (g_object_unref (_tmp146), NULL)));
									_tmp149 = NULL;
									_tmp148 = NULL;
									_tmp147 = NULL;
									param_name = (_tmp149 = vala_ccode_identifier_new ((_tmp148 = g_strdup_printf ("%s_destroy_func", (_tmp147 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL))), _tmp149);
									_tmp148 = (g_free (_tmp148), NULL);
									_tmp147 = (g_free (_tmp147), NULL);
									_tmp151 = NULL;
									_tmp150 = NULL;
									assign = (_tmp151 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (priv_access), vala_ccode_identifier_get_name (param_name)))), VALA_CCODE_EXPRESSION (param_name), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL))), _tmp151);
									(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
									_tmp152 = NULL;
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp152 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
									(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
									(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
									(param_name == NULL ? NULL : (param_name = (g_object_unref (param_name), NULL)));
									(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
									(priv_access == NULL ? NULL : (priv_access = (g_object_unref (priv_access), NULL)));
								}
							}
							(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
						}
						(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					} else {
						if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
							ValaClass* _tmp153;
							ValaClass* cl;
							char* _tmp155;
							char* _tmp154;
							ValaCCodeDeclaration* _tmp156;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeIdentifier* _tmp157;
							ValaCCodeFunctionCall* _tmp158;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp160;
							char* _tmp159;
							ValaCCodeVariableDeclarator* _tmp161;
							ValaCCodeIdentifier* _tmp164;
							char* _tmp163;
							char* _tmp162;
							ValaCCodeFunctionCall* _tmp165;
							ValaCCodeFunctionCall* cinitcall;
							ValaCCodeIdentifier* _tmp166;
							ValaCCodeExpressionStatement* _tmp167;
							_tmp153 = NULL;
							cl = (_tmp153 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp153 == NULL ? NULL : g_object_ref (_tmp153)));
							_tmp155 = NULL;
							_tmp154 = NULL;
							_tmp156 = NULL;
							cdecl_ = (_tmp156 = vala_ccode_declaration_new ((_tmp155 = g_strconcat ((_tmp154 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp155 = (g_free (_tmp155), NULL)), (_tmp154 = (g_free (_tmp154), NULL)), _tmp156);
							_tmp157 = NULL;
							_tmp158 = NULL;
							ccall = (_tmp158 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_identifier_new ("g_slice_new0")))), (_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL))), _tmp158);
							_tmp160 = NULL;
							_tmp159 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_identifier_new ((_tmp159 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))));
							(_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL)));
							_tmp159 = (g_free (_tmp159), NULL);
							_tmp161 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp161 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
							(_tmp161 == NULL ? NULL : (_tmp161 = (g_object_unref (_tmp161), NULL)));
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
							_tmp164 = NULL;
							_tmp163 = NULL;
							_tmp162 = NULL;
							_tmp165 = NULL;
							cinitcall = (_tmp165 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_identifier_new ((_tmp163 = g_strdup_printf ("%s_instance_init", (_tmp162 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))))))), (_tmp164 == NULL ? NULL : (_tmp164 = (g_object_unref (_tmp164), NULL))), (_tmp163 = (g_free (_tmp163), NULL)), (_tmp162 = (g_free (_tmp162), NULL)), _tmp165);
							_tmp166 = NULL;
							vala_ccode_function_call_add_argument (cinitcall, VALA_CCODE_EXPRESSION ((_tmp166 = vala_ccode_identifier_new ("self"))));
							(_tmp166 == NULL ? NULL : (_tmp166 = (g_object_unref (_tmp166), NULL)));
							_tmp167 = NULL;
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp167 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinitcall)))));
							(_tmp167 == NULL ? NULL : (_tmp167 = (g_object_unref (_tmp167), NULL)));
							(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
							(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(cinitcall == NULL ? NULL : (cinitcall = (g_object_unref (cinitcall), NULL)));
						} else {
							ValaStruct* _tmp168;
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp169;
							ValaCCodeFunctionCall* _tmp170;
							ValaCCodeFunctionCall* czero;
							ValaCCodeIdentifier* _tmp171;
							ValaCCodeConstant* _tmp172;
							ValaCCodeIdentifier* _tmp175;
							char* _tmp174;
							char* _tmp173;
							ValaCCodeExpressionStatement* _tmp176;
							_tmp168 = NULL;
							st = (_tmp168 = VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp168 == NULL ? NULL : g_object_ref (_tmp168)));
							/* memset needs string.h*/
							vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
							_tmp169 = NULL;
							_tmp170 = NULL;
							czero = (_tmp170 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp169 = vala_ccode_identifier_new ("memset")))), (_tmp169 == NULL ? NULL : (_tmp169 = (g_object_unref (_tmp169), NULL))), _tmp170);
							_tmp171 = NULL;
							vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp171 = vala_ccode_identifier_new ("self"))));
							(_tmp171 == NULL ? NULL : (_tmp171 = (g_object_unref (_tmp171), NULL)));
							_tmp172 = NULL;
							vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp172 = vala_ccode_constant_new ("0"))));
							(_tmp172 == NULL ? NULL : (_tmp172 = (g_object_unref (_tmp172), NULL)));
							_tmp175 = NULL;
							_tmp174 = NULL;
							_tmp173 = NULL;
							vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp175 = vala_ccode_identifier_new ((_tmp174 = g_strdup_printf ("sizeof (%s)", (_tmp173 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))))));
							(_tmp175 == NULL ? NULL : (_tmp175 = (g_object_unref (_tmp175), NULL)));
							_tmp174 = (g_free (_tmp174), NULL);
							_tmp173 = (g_free (_tmp173), NULL);
							_tmp176 = NULL;
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp176 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
							(_tmp176 == NULL ? NULL : (_tmp176 = (g_object_unref (_tmp176), NULL)));
							(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
							(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
						}
					}
				}
			}
			if (vala_code_context_get_module_init_method (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context) == m && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_fragment));
			}
			{
				GeeList* precondition_collection;
				int precondition_it;
				precondition_collection = vala_method_get_preconditions (m);
				for (precondition_it = 0; precondition_it < gee_collection_get_size (GEE_COLLECTION (precondition_collection)); precondition_it = precondition_it + 1) {
					ValaExpression* precondition;
					precondition = ((ValaExpression*) (gee_list_get (GEE_LIST (precondition_collection), precondition_it)));
					{
						ValaCCodeStatement* _tmp177;
						_tmp177 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp177 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
						(_tmp177 == NULL ? NULL : (_tmp177 = (g_object_unref (_tmp177), NULL)));
						(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
					}
				}
				(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		} else {
			if (vala_method_get_is_abstract (m)) {
				ValaCCodeBlock* cblock;
				ValaCCodeStatement* _tmp178;
				ValaCCodeIdentifier* _tmp179;
				ValaCCodeFunctionCall* _tmp180;
				ValaCCodeFunctionCall* type_from_instance_call;
				ValaCCodeIdentifier* _tmp181;
				ValaCCodeIdentifier* _tmp182;
				ValaCCodeFunctionCall* _tmp183;
				ValaCCodeFunctionCall* type_name_call;
				char* _tmp184;
				char* _tmp185;
				char* error_string;
				ValaCCodeIdentifier* _tmp186;
				ValaCCodeFunctionCall* _tmp187;
				ValaCCodeFunctionCall* cerrorcall;
				ValaCCodeConstant* _tmp188;
				ValaCCodeExpressionStatement* _tmp189;
				ValaCCodeReturnStatement* _tmp191;
				ValaCCodeExpression* _tmp190;
				/* generate helpful error message if a sublcass does not implement an abstract method.
				 This is only meaningful for subclasses implemented in C since the vala compiler would
				 complain during compile time of such en error.*/
				cblock = vala_ccode_block_new ();
				/* add a typecheck statement for "self"*/
				_tmp178 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp178 = vala_ccode_method_binding_create_method_type_check_statement (self, m, creturn_type, vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, TRUE, "self"))));
				(_tmp178 == NULL ? NULL : (_tmp178 = (g_object_unref (_tmp178), NULL)));
				/* add critical warning that this method should not have been called*/
				_tmp179 = NULL;
				_tmp180 = NULL;
				type_from_instance_call = (_tmp180 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp179 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE")))), (_tmp179 == NULL ? NULL : (_tmp179 = (g_object_unref (_tmp179), NULL))), _tmp180);
				_tmp181 = NULL;
				vala_ccode_function_call_add_argument (type_from_instance_call, VALA_CCODE_EXPRESSION ((_tmp181 = vala_ccode_identifier_new ("self"))));
				(_tmp181 == NULL ? NULL : (_tmp181 = (g_object_unref (_tmp181), NULL)));
				_tmp182 = NULL;
				_tmp183 = NULL;
				type_name_call = (_tmp183 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_identifier_new ("g_type_name")))), (_tmp182 == NULL ? NULL : (_tmp182 = (g_object_unref (_tmp182), NULL))), _tmp183);
				vala_ccode_function_call_add_argument (type_name_call, VALA_CCODE_EXPRESSION (type_from_instance_call));
				_tmp184 = NULL;
				_tmp185 = NULL;
				error_string = (_tmp185 = g_strdup_printf ("\"Type `%%s' does not implement abstract method `%s'\"", (_tmp184 = vala_method_get_cname (m))), (_tmp184 = (g_free (_tmp184), NULL)), _tmp185);
				_tmp186 = NULL;
				_tmp187 = NULL;
				cerrorcall = (_tmp187 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp186 = vala_ccode_identifier_new ("g_critical")))), (_tmp186 == NULL ? NULL : (_tmp186 = (g_object_unref (_tmp186), NULL))), _tmp187);
				_tmp188 = NULL;
				vala_ccode_function_call_add_argument (cerrorcall, VALA_CCODE_EXPRESSION ((_tmp188 = vala_ccode_constant_new (error_string))));
				(_tmp188 == NULL ? NULL : (_tmp188 = (g_object_unref (_tmp188), NULL)));
				vala_ccode_function_call_add_argument (cerrorcall, VALA_CCODE_EXPRESSION (type_name_call));
				_tmp189 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp189 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cerrorcall)))));
				(_tmp189 == NULL ? NULL : (_tmp189 = (g_object_unref (_tmp189), NULL)));
				/* add return statement*/
				_tmp191 = NULL;
				_tmp190 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp191 = vala_ccode_return_statement_new ((_tmp190 = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), creturn_type, FALSE))))));
				(_tmp191 == NULL ? NULL : (_tmp191 = (g_object_unref (_tmp191), NULL)));
				(_tmp190 == NULL ? NULL : (_tmp190 = (g_object_unref (_tmp190), NULL)));
				vala_ccode_function_set_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function, cblock);
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function));
				(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
				(type_from_instance_call == NULL ? NULL : (type_from_instance_call = (g_object_unref (type_from_instance_call), NULL)));
				(type_name_call == NULL ? NULL : (type_name_call = (g_object_unref (type_name_call), NULL)));
				error_string = (g_free (error_string), NULL);
				(cerrorcall == NULL ? NULL : (cerrorcall = (g_object_unref (cerrorcall), NULL)));
			}
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* _tmp193;
		char* _tmp192;
		ValaCCodeFunction* _tmp194;
		ValaCCodeFunction* vfunc;
		ValaReferenceType* this_type;
		GeeHashMap* _tmp197;
		GeeHashMap* carg_map;
		char* _tmp198;
		ValaCCodeFormalParameter* _tmp199;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp211;
		ValaCCodeMemberAccess* _tmp212;
		ValaCCodeFunctionCall* _tmp213;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp214;
		GeeList* params;
		GeeList* _tmp238;
		gboolean _tmp239;
		gint last_pos;
		gint min_pos;
		ValaCCodeStatement* cstmt;
		GeeList* _tmp253;
		gboolean _tmp254;
		_tmp193 = NULL;
		_tmp192 = NULL;
		_tmp194 = NULL;
		vfunc = (_tmp194 = vala_ccode_function_new ((_tmp192 = vala_method_get_cname (m)), (_tmp193 = vala_data_type_get_cname (creturn_type))), (_tmp193 = (g_free (_tmp193), NULL)), (_tmp192 = (g_free (_tmp192), NULL)), _tmp194);
		vala_ccode_node_set_line (VALA_CCODE_NODE (vfunc), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		this_type = NULL;
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaReferenceType* _tmp195;
			_tmp195 = NULL;
			this_type = (_tmp195 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp195);
		} else {
			ValaReferenceType* _tmp196;
			_tmp196 = NULL;
			this_type = (_tmp196 = VALA_REFERENCE_TYPE (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp196);
		}
		_tmp197 = NULL;
		cparam_map = (_tmp197 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL))), _tmp197);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		_tmp198 = NULL;
		_tmp199 = NULL;
		cparam = (_tmp199 = vala_ccode_formal_parameter_new ("self", (_tmp198 = vala_data_type_get_cname (VALA_DATA_TYPE (this_type)))), (_tmp198 = (g_free (_tmp198), NULL)), _tmp199);
		gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), cparam);
		vblock = vala_ccode_block_new ();
		{
			GeeList* precondition_collection;
			int precondition_it;
			precondition_collection = vala_method_get_preconditions (m);
			for (precondition_it = 0; precondition_it < gee_collection_get_size (GEE_COLLECTION (precondition_collection)); precondition_it = precondition_it + 1) {
				ValaExpression* precondition;
				precondition = ((ValaExpression*) (gee_list_get (GEE_LIST (precondition_collection), precondition_it)));
				{
					ValaCCodeStatement* _tmp200;
					_tmp200 = NULL;
					vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp200 = vala_ccode_method_binding_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
					(_tmp200 == NULL ? NULL : (_tmp200 = (g_object_unref (_tmp200), NULL)));
					(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
				}
			}
			(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
		}
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaInterface* _tmp201;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp205;
			ValaCCodeIdentifier* _tmp204;
			char* _tmp203;
			char* _tmp202;
			_tmp201 = NULL;
			iface = (_tmp201 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp201 == NULL ? NULL : g_object_ref (_tmp201)));
			_tmp205 = NULL;
			_tmp204 = NULL;
			_tmp203 = NULL;
			_tmp202 = NULL;
			vcast = (_tmp205 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp204 = vala_ccode_identifier_new ((_tmp203 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp202 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp205);
			(_tmp204 == NULL ? NULL : (_tmp204 = (g_object_unref (_tmp204), NULL)));
			_tmp203 = (g_free (_tmp203), NULL);
			_tmp202 = (g_free (_tmp202), NULL);
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* _tmp206;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp210;
			ValaCCodeIdentifier* _tmp209;
			char* _tmp208;
			char* _tmp207;
			_tmp206 = NULL;
			cl = (_tmp206 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp206 == NULL ? NULL : g_object_ref (_tmp206)));
			_tmp210 = NULL;
			_tmp209 = NULL;
			_tmp208 = NULL;
			_tmp207 = NULL;
			vcast = (_tmp210 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp209 = vala_ccode_identifier_new ((_tmp208 = g_strdup_printf ("%s_GET_CLASS", (_tmp207 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp210);
			(_tmp209 == NULL ? NULL : (_tmp209 = (g_object_unref (_tmp209), NULL)));
			_tmp208 = (g_free (_tmp208), NULL);
			_tmp207 = (g_free (_tmp207), NULL);
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		_tmp211 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp211 = vala_ccode_identifier_new ("self"))));
		(_tmp211 == NULL ? NULL : (_tmp211 = (g_object_unref (_tmp211), NULL)));
		_tmp212 = NULL;
		_tmp213 = NULL;
		vcall = (_tmp213 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp212 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_vfunc_name (m))))), (_tmp212 == NULL ? NULL : (_tmp212 = (g_object_unref (_tmp212), NULL))), _tmp213);
		_tmp214 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp214 = vala_ccode_identifier_new ("self"))));
		(_tmp214 == NULL ? NULL : (_tmp214 = (g_object_unref (_tmp214), NULL)));
		params = vala_method_get_parameters (m);
		{
			GeeList* param_collection;
			int param_it;
			param_collection = params;
			for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
				{
					ValaCCodeIdentifier* _tmp220;
					if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						ValaArrayType* _tmp215;
						ValaArrayType* array_type;
						char* length_ctype;
						_tmp215 = NULL;
						array_type = (_tmp215 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp215 == NULL ? NULL : g_object_ref (_tmp215)));
						length_ctype = g_strdup ("int");
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
							char* _tmp216;
							_tmp216 = NULL;
							length_ctype = (_tmp216 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp216);
						}
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								char* _tmp217;
								ValaCCodeFormalParameter* _tmp218;
								ValaCCodeFormalParameter* cparam;
								ValaCCodeIdentifier* _tmp219;
								_tmp217 = NULL;
								_tmp218 = NULL;
								cparam = (_tmp218 = vala_ccode_formal_parameter_new ((_tmp217 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp217 = (g_free (_tmp217), NULL)), _tmp218);
								gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
								_tmp219 = NULL;
								gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), VALA_CCODE_EXPRESSION ((_tmp219 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
								(_tmp219 == NULL ? NULL : (_tmp219 = (g_object_unref (_tmp219), NULL)));
								(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
							}
						}
						(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
						length_ctype = (g_free (length_ctype), NULL);
					}
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					_tmp220 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION ((_tmp220 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
					(_tmp220 == NULL ? NULL : (_tmp220 = (g_object_unref (_tmp220), NULL)));
					if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						ValaDelegateType* _tmp221;
						ValaDelegateType* deleg_type;
						ValaDelegate* _tmp222;
						ValaDelegate* d;
						_tmp221 = NULL;
						deleg_type = (_tmp221 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp221 == NULL ? NULL : g_object_ref (_tmp221)));
						_tmp222 = NULL;
						d = (_tmp222 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp222 == NULL ? NULL : g_object_ref (_tmp222)));
						if (vala_delegate_get_has_target (d)) {
							char* _tmp223;
							ValaCCodeFormalParameter* _tmp224;
							ValaCCodeFormalParameter* cparam;
							ValaCCodeIdentifier* _tmp225;
							_tmp223 = NULL;
							_tmp224 = NULL;
							cparam = (_tmp224 = vala_ccode_formal_parameter_new ((_tmp223 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp223 = (g_free (_tmp223), NULL)), _tmp224);
							gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
							_tmp225 = NULL;
							gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), VALA_CCODE_EXPRESSION ((_tmp225 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
							(_tmp225 == NULL ? NULL : (_tmp225 = (g_object_unref (_tmp225), NULL)));
							if (vala_data_type_get_value_owned (VALA_DATA_TYPE (deleg_type))) {
								ValaCCodeFormalParameter* _tmp227;
								char* _tmp226;
								ValaCCodeIdentifier* _tmp228;
								_tmp227 = NULL;
								_tmp226 = NULL;
								cparam = (_tmp227 = vala_ccode_formal_parameter_new ((_tmp226 = vala_ccode_generator_get_delegate_target_destroy_notify_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "GDestroyNotify"), (cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL))), _tmp227);
								_tmp226 = (g_free (_tmp226), NULL);
								gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
								_tmp228 = NULL;
								gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), VALA_CCODE_EXPRESSION ((_tmp228 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
								(_tmp228 == NULL ? NULL : (_tmp228 = (g_object_unref (_tmp228), NULL)));
							}
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
						(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
						(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
		}
		/* return array length if appropriate*/
		if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
			ValaArrayType* _tmp229;
			ValaArrayType* array_type;
			_tmp229 = NULL;
			array_type = (_tmp229 = VALA_ARRAY_TYPE (creturn_type), (_tmp229 == NULL ? NULL : g_object_ref (_tmp229)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp230;
					ValaCCodeFormalParameter* _tmp231;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp232;
					_tmp230 = NULL;
					_tmp231 = NULL;
					cparam = (_tmp231 = vala_ccode_formal_parameter_new ((_tmp230 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result", dim)), "int*"), (_tmp230 = (g_free (_tmp230), NULL)), _tmp231);
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m), FALSE)), cparam);
					_tmp232 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp232 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
					(_tmp232 == NULL ? NULL : (_tmp232 = (g_object_unref (_tmp232), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
				ValaDelegateType* _tmp233;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp234;
				ValaDelegate* d;
				/* return delegate target if appropriate*/
				_tmp233 = NULL;
				deleg_type = (_tmp233 = VALA_DELEGATE_TYPE (creturn_type), (_tmp233 == NULL ? NULL : g_object_ref (_tmp233)));
				_tmp234 = NULL;
				d = (_tmp234 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp234 == NULL ? NULL : g_object_ref (_tmp234)));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp235;
					ValaCCodeFormalParameter* _tmp236;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp237;
					_tmp235 = NULL;
					_tmp236 = NULL;
					cparam = (_tmp236 = vala_ccode_formal_parameter_new ((_tmp235 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result")), "void*"), (_tmp235 = (g_free (_tmp235), NULL)), _tmp236);
					gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
					_tmp237 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp237 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
					(_tmp237 == NULL ? NULL : (_tmp237 = (g_object_unref (_tmp237), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
			}
		}
		_tmp238 = NULL;
		if ((_tmp239 = gee_collection_get_size (GEE_COLLECTION ((_tmp238 = vala_code_node_get_error_types (VALA_CODE_NODE (m))))) > 0, (_tmp238 == NULL ? NULL : (_tmp238 = (g_object_unref (_tmp238), NULL))), _tmp239)) {
			ValaCCodeFormalParameter* cparam;
			ValaCCodeIdentifier* _tmp240;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			gee_map_set (GEE_MAP (cparam_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), FALSE)), cparam);
			_tmp240 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp240 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
			(_tmp240 == NULL ? NULL : (_tmp240 = (g_object_unref (_tmp240), NULL)));
			(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		}
		/* append C parameters and arguments in the right order*/
		last_pos = -1;
		min_pos = 0;
		while (TRUE) {
			ValaCCodeFormalParameter* _tmp241;
			ValaCCodeExpression* _tmp242;
			min_pos = -1;
			{
				GeeSet* pos_collection;
				GeeIterator* pos_it;
				pos_collection = gee_map_get_keys (GEE_MAP (cparam_map));
				pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
				while (gee_iterator_next (pos_it)) {
					gint pos;
					pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
					{
						if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
							min_pos = pos;
						}
					}
				}
				(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
				(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
			}
			if (min_pos == -1) {
				break;
			}
			_tmp241 = NULL;
			vala_ccode_function_add_parameter (vfunc, (_tmp241 = ((ValaCCodeFormalParameter*) (gee_map_get (GEE_MAP (cparam_map), GINT_TO_POINTER (min_pos))))));
			(_tmp241 == NULL ? NULL : (_tmp241 = (g_object_unref (_tmp241), NULL)));
			_tmp242 = NULL;
			vala_ccode_function_call_add_argument (vcall, (_tmp242 = ((ValaCCodeExpression*) (gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos))))));
			(_tmp242 == NULL ? NULL : (_tmp242 = (g_object_unref (_tmp242), NULL)));
			last_pos = min_pos;
		}
		cstmt = NULL;
		if (VALA_IS_VOID_TYPE (creturn_type)) {
			ValaCCodeStatement* _tmp243;
			_tmp243 = NULL;
			cstmt = (_tmp243 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp243);
		} else {
			GeeList* _tmp244;
			gboolean _tmp245;
			_tmp244 = NULL;
			if ((_tmp245 = gee_collection_get_size (GEE_COLLECTION ((_tmp244 = vala_method_get_postconditions (m)))) == 0, (_tmp244 == NULL ? NULL : (_tmp244 = (g_object_unref (_tmp244), NULL))), _tmp245)) {
				ValaCCodeStatement* _tmp246;
				/* pass method return value */
				_tmp246 = NULL;
				cstmt = (_tmp246 = VALA_CCODE_STATEMENT (vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp246);
			} else {
				char* _tmp248;
				char* _tmp247;
				ValaCCodeDeclaration* _tmp249;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp250;
				ValaCCodeStatement* _tmp252;
				ValaCCodeStatement* _tmp251;
				/* store method return value for postconditions */
				_tmp248 = NULL;
				_tmp247 = NULL;
				_tmp249 = NULL;
				cdecl_ = (_tmp249 = vala_ccode_declaration_new ((_tmp248 = vala_ccode_method_binding_get_creturn_type (self, (_tmp247 = vala_data_type_get_cname (creturn_type))))), (_tmp248 = (g_free (_tmp248), NULL)), (_tmp247 = (g_free (_tmp247), NULL)), _tmp249);
				_tmp250 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp250 = vala_ccode_variable_declarator_new_with_initializer ("result", VALA_CCODE_EXPRESSION (vcall)))));
				(_tmp250 == NULL ? NULL : (_tmp250 = (g_object_unref (_tmp250), NULL)));
				_tmp252 = NULL;
				_tmp251 = NULL;
				cstmt = (_tmp252 = (_tmp251 = VALA_CCODE_STATEMENT (cdecl_), (_tmp251 == NULL ? NULL : g_object_ref (_tmp251))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp252);
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		vala_ccode_node_set_line (VALA_CCODE_NODE (cstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
		vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cstmt));
		_tmp253 = NULL;
		if ((_tmp254 = gee_collection_get_size (GEE_COLLECTION ((_tmp253 = vala_method_get_postconditions (m)))) > 0, (_tmp253 == NULL ? NULL : (_tmp253 = (g_object_unref (_tmp253), NULL))), _tmp254)) {
			{
				GeeList* postcondition_collection;
				int postcondition_it;
				postcondition_collection = vala_method_get_postconditions (m);
				for (postcondition_it = 0; postcondition_it < gee_collection_get_size (GEE_COLLECTION (postcondition_collection)); postcondition_it = postcondition_it + 1) {
					ValaExpression* postcondition;
					postcondition = ((ValaExpression*) (gee_list_get (GEE_LIST (postcondition_collection), postcondition_it)));
					{
						ValaCCodeStatement* _tmp255;
						_tmp255 = NULL;
						vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp255 = vala_ccode_method_binding_create_postcondition_statement (self, postcondition))));
						(_tmp255 == NULL ? NULL : (_tmp255 = (g_object_unref (_tmp255), NULL)));
						(postcondition == NULL ? NULL : (postcondition = (g_object_unref (postcondition), NULL)));
					}
				}
				(postcondition_collection == NULL ? NULL : (postcondition_collection = (g_object_unref (postcondition_collection), NULL)));
			}
			if (!(VALA_IS_VOID_TYPE (creturn_type))) {
				ValaCCodeIdentifier* _tmp256;
				ValaCCodeReturnStatement* _tmp257;
				ValaCCodeReturnStatement* cret_stmt;
				_tmp256 = NULL;
				_tmp257 = NULL;
				cret_stmt = (_tmp257 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp256 = vala_ccode_identifier_new ("result")))), (_tmp256 == NULL ? NULL : (_tmp256 = (g_object_unref (_tmp256), NULL))), _tmp257);
				vala_ccode_node_set_line (VALA_CCODE_NODE (cret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
				vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cret_stmt));
				(cret_stmt == NULL ? NULL : (cret_stmt = (g_object_unref (cret_stmt), NULL)));
			}
		}
		if (visible) {
			ValaCCodeFunction* _tmp258;
			_tmp258 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp258 = vala_ccode_function_copy (vfunc))));
			(_tmp258 == NULL ? NULL : (_tmp258 = (g_object_unref (_tmp258), NULL)));
		} else {
			ValaCCodeFunction* _tmp259;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp259 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp259 = vala_ccode_function_copy (vfunc))));
			(_tmp259 == NULL ? NULL : (_tmp259 = (g_object_unref (_tmp259), NULL)));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		if (vala_method_get_is_abstract (m) && vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
			ValaCCodeComment* _tmp260;
			_tmp260 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp260 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
			(_tmp260 == NULL ? NULL : (_tmp260 = (g_object_unref (_tmp260), NULL)));
		}
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(carg_map == NULL ? NULL : (carg_map = (g_object_unref (carg_map), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp261;
		gboolean _tmp262;
		_tmp261 = NULL;
		if ((_tmp262 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) && (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0 || gee_collection_get_size (GEE_COLLECTION ((_tmp261 = vala_class_get_type_parameters (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class)))) > 0), (_tmp261 == NULL ? NULL : (_tmp261 = (g_object_unref (_tmp261), NULL))), _tmp262)) {
			ValaCCodeIdentifier* _tmp264;
			ValaCCodeIdentifier* _tmp263;
			ValaCCodeBinaryExpression* _tmp265;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* _tmp268;
			ValaCCodeUnaryExpression* _tmp267;
			ValaCCodeIdentifier* _tmp266;
			ValaCCodeIdentifier* _tmp269;
			ValaCCodeFunctionCall* _tmp270;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* _tmp273;
			ValaCCodeMemberAccess* _tmp272;
			ValaCCodeIdentifier* _tmp271;
			ValaCCodeExpressionStatement* _tmp274;
			ValaCCodeWhileStatement* _tmp275;
			ValaCCodeIdentifier* _tmp276;
			ValaCCodeFunctionCall* _tmp277;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* _tmp278;
			ValaCCodeExpressionStatement* _tmp279;
			_tmp264 = NULL;
			_tmp263 = NULL;
			_tmp265 = NULL;
			ccond = (_tmp265 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION ((_tmp263 = vala_ccode_identifier_new ("__params_it"))), VALA_CCODE_EXPRESSION ((_tmp264 = vala_ccode_identifier_new ("__params")))), (_tmp264 == NULL ? NULL : (_tmp264 = (g_object_unref (_tmp264), NULL))), (_tmp263 == NULL ? NULL : (_tmp263 = (g_object_unref (_tmp263), NULL))), _tmp265);
			cdofreeparam = vala_ccode_block_new ();
			_tmp268 = NULL;
			_tmp267 = NULL;
			_tmp266 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp268 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp267 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, VALA_CCODE_EXPRESSION ((_tmp266 = vala_ccode_identifier_new ("__params_it"))))))))));
			(_tmp268 == NULL ? NULL : (_tmp268 = (g_object_unref (_tmp268), NULL)));
			(_tmp267 == NULL ? NULL : (_tmp267 = (g_object_unref (_tmp267), NULL)));
			(_tmp266 == NULL ? NULL : (_tmp266 = (g_object_unref (_tmp266), NULL)));
			_tmp269 = NULL;
			_tmp270 = NULL;
			cunsetcall = (_tmp270 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp269 = vala_ccode_identifier_new ("g_value_unset")))), (_tmp269 == NULL ? NULL : (_tmp269 = (g_object_unref (_tmp269), NULL))), _tmp270);
			_tmp273 = NULL;
			_tmp272 = NULL;
			_tmp271 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, VALA_CCODE_EXPRESSION ((_tmp273 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp272 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp271 = vala_ccode_identifier_new ("__params_it"))), "value")))))));
			(_tmp273 == NULL ? NULL : (_tmp273 = (g_object_unref (_tmp273), NULL)));
			(_tmp272 == NULL ? NULL : (_tmp272 = (g_object_unref (_tmp272), NULL)));
			(_tmp271 == NULL ? NULL : (_tmp271 = (g_object_unref (_tmp271), NULL)));
			_tmp274 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp274 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cunsetcall)))));
			(_tmp274 == NULL ? NULL : (_tmp274 = (g_object_unref (_tmp274), NULL)));
			_tmp275 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp275 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cdofreeparam)))));
			(_tmp275 == NULL ? NULL : (_tmp275 = (g_object_unref (_tmp275), NULL)));
			_tmp276 = NULL;
			_tmp277 = NULL;
			cfreeparams = (_tmp277 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp276 = vala_ccode_identifier_new ("g_free")))), (_tmp276 == NULL ? NULL : (_tmp276 = (g_object_unref (_tmp276), NULL))), _tmp277);
			_tmp278 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, VALA_CCODE_EXPRESSION ((_tmp278 = vala_ccode_identifier_new ("__params"))));
			(_tmp278 == NULL ? NULL : (_tmp278 = (g_object_unref (_tmp278), NULL)));
			_tmp279 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE ((_tmp279 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreeparams)))));
			(_tmp279 == NULL ? NULL : (_tmp279 = (g_object_unref (_tmp279), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (g_object_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (g_object_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (g_object_unref (cfreeparams), NULL)));
		}
		if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
			ValaCCodeExpression* cresult;
			char* _tmp280;
			gboolean _tmp281;
			ValaCCodeReturnStatement* creturn;
			cresult = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self"));
			_tmp280 = NULL;
			if ((_tmp281 = (_tmp280 = vala_ccode_method_binding_get_custom_creturn_type (self)) != NULL, (_tmp280 = (g_free (_tmp280), NULL)), _tmp281)) {
				ValaCCodeExpression* _tmp283;
				char* _tmp282;
				_tmp283 = NULL;
				_tmp282 = NULL;
				cresult = (_tmp283 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cresult, (_tmp282 = vala_ccode_method_binding_get_custom_creturn_type (self)))), (cresult == NULL ? NULL : (cresult = (g_object_unref (cresult), NULL))), _tmp283);
				_tmp282 = (g_free (_tmp282), NULL);
			}
			creturn = vala_ccode_return_statement_new (NULL);
			vala_ccode_return_statement_set_return_expression (creturn, cresult);
			vala_ccode_block_add_statement (vala_ccode_function_get_block (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function), VALA_CCODE_NODE (creturn));
			(cresult == NULL ? NULL : (cresult = (g_object_unref (cresult), NULL)));
			(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
		}
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_ccode_method_binding_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp284;
		ValaCCodeFormalParameter* _tmp285;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp291;
		ValaCCodeIdentifier* _tmp290;
		ValaCCodeExpressionStatement* _tmp292;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp293;
		ValaCCodeFunctionCall* _tmp294;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line (VALA_CCODE_NODE (cmain), vala_ccode_node_get_line (VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function)));
		_tmp284 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp284 = vala_ccode_formal_parameter_new ("argc", "int")));
		(_tmp284 == NULL ? NULL : (_tmp284 = (g_object_unref (_tmp284), NULL)));
		_tmp285 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp285 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(_tmp285 == NULL ? NULL : (_tmp285 = (g_object_unref (_tmp285), NULL)));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->context)) {
			ValaCCodeIdentifier* _tmp286;
			ValaCCodeFunctionCall* _tmp287;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp288;
			ValaCCodeExpressionStatement* _tmp289;
			_tmp286 = NULL;
			_tmp287 = NULL;
			thread_init_call = (_tmp287 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp286 = vala_ccode_identifier_new ("g_thread_init")))), (_tmp286 == NULL ? NULL : (_tmp286 = (g_object_unref (_tmp286), NULL))), _tmp287);
			vala_ccode_node_set_line (VALA_CCODE_NODE (thread_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			_tmp288 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((_tmp288 = vala_ccode_constant_new ("NULL"))));
			(_tmp288 == NULL ? NULL : (_tmp288 = (g_object_unref (_tmp288), NULL)));
			_tmp289 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp289 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(_tmp289 == NULL ? NULL : (_tmp289 = (g_object_unref (_tmp289), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (g_object_unref (thread_init_call), NULL)));
		}
		_tmp291 = NULL;
		_tmp290 = NULL;
		_tmp292 = NULL;
		type_init_call = (_tmp292 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp291 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp290 = vala_ccode_identifier_new ("g_type_init"))))))), (_tmp291 == NULL ? NULL : (_tmp291 = (g_object_unref (_tmp291), NULL))), (_tmp290 == NULL ? NULL : (_tmp290 = (g_object_unref (_tmp290), NULL))), _tmp292);
		vala_ccode_node_set_line (VALA_CCODE_NODE (type_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (type_init_call));
		_tmp293 = NULL;
		_tmp294 = NULL;
		main_call = (_tmp294 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp293 = vala_ccode_identifier_new (vala_ccode_function_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->function))))), (_tmp293 == NULL ? NULL : (_tmp293 = (g_object_unref (_tmp293), NULL))), _tmp294);
		if (args_parameter) {
			ValaCCodeIdentifier* _tmp295;
			ValaCCodeIdentifier* _tmp296;
			_tmp295 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp295 = vala_ccode_identifier_new ("argv"))));
			(_tmp295 == NULL ? NULL : (_tmp295 = (g_object_unref (_tmp295), NULL)));
			_tmp296 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp296 = vala_ccode_identifier_new ("argc"))));
			(_tmp296 == NULL ? NULL : (_tmp296 = (g_object_unref (_tmp296), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
		} else {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp297;
			ValaCCodeReturnStatement* _tmp298;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			_tmp297 = NULL;
			_tmp298 = NULL;
			ret_stmt = (_tmp298 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp297 = vala_ccode_constant_new ("0")))), (_tmp297 == NULL ? NULL : (_tmp297 = (g_object_unref (_tmp297), NULL))), _tmp298);
			vala_ccode_node_set_line (VALA_CCODE_NODE (ret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (ret_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
			(ret_stmt == NULL ? NULL : (ret_stmt = (g_object_unref (ret_stmt), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(type_init_call == NULL ? NULL : (type_init_call = (g_object_unref (type_init_call), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
	(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
	(cparam_map == NULL ? NULL : (cparam_map = (g_object_unref (cparam_map), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
}


void vala_ccode_method_binding_generate_cparameters (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* creturn_type, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator) {
	GeeList* _tmp19;
	gboolean _tmp20;
	gint last_pos;
	gint min_pos;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_METHOD (m));
	g_return_if_fail (VALA_IS_DATA_TYPE (creturn_type));
	g_return_if_fail (GEE_IS_MAP (cparam_map));
	g_return_if_fail (VALA_IS_CCODE_FUNCTION (func));
	g_return_if_fail (vdeclarator == NULL || VALA_IS_CCODE_FUNCTION_DECLARATOR (vdeclarator));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaArrayType* _tmp0;
					ValaArrayType* array_type;
					char* length_ctype;
					_tmp0 = NULL;
					array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
					length_ctype = g_strdup ("int");
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						char* _tmp1;
						_tmp1 = NULL;
						length_ctype = (_tmp1 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp1);
					}
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp2;
							ValaCCodeFormalParameter* _tmp3;
							ValaCCodeFormalParameter* cparam;
							_tmp2 = NULL;
							_tmp3 = NULL;
							cparam = (_tmp3 = vala_ccode_formal_parameter_new ((_tmp2 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), cparam);
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
					length_ctype = (g_free (length_ctype), NULL);
				}
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					ValaDelegateType* _tmp4;
					ValaDelegateType* deleg_type;
					ValaDelegate* _tmp5;
					ValaDelegate* d;
					_tmp4 = NULL;
					deleg_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
					_tmp5 = NULL;
					d = (_tmp5 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
					if (vala_delegate_get_has_target (d)) {
						char* _tmp6;
						ValaCCodeFormalParameter* _tmp7;
						ValaCCodeFormalParameter* cparam;
						_tmp6 = NULL;
						_tmp7 = NULL;
						cparam = (_tmp7 = vala_ccode_formal_parameter_new ((_tmp6 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						if (vala_data_type_get_value_owned (VALA_DATA_TYPE (deleg_type))) {
							ValaCCodeFormalParameter* _tmp9;
							char* _tmp8;
							_tmp9 = NULL;
							_tmp8 = NULL;
							cparam = (_tmp9 = vala_ccode_formal_parameter_new ((_tmp8 = vala_ccode_generator_get_delegate_target_destroy_notify_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "GDestroyNotify"), (cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL))), _tmp9);
							_tmp8 = (g_free (_tmp8), NULL);
							gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
						}
						(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
					}
					(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
					(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
				} else {
					if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						char* _tmp10;
						ValaCCodeFormalParameter* _tmp11;
						ValaCCodeFormalParameter* cparam;
						_tmp10 = NULL;
						_tmp11 = NULL;
						cparam = (_tmp11 = vala_ccode_formal_parameter_new ((_tmp10 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
						(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
	}
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY_TYPE (creturn_type)) {
		ValaArrayType* _tmp12;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp12 = NULL;
		array_type = (_tmp12 = VALA_ARRAY_TYPE (creturn_type), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp13;
				ValaCCodeFormalParameter* _tmp14;
				ValaCCodeFormalParameter* cparam;
				_tmp13 = NULL;
				_tmp14 = NULL;
				cparam = (_tmp14 = vala_ccode_formal_parameter_new ((_tmp13 = vala_ccode_generator_get_array_length_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result", dim)), "int*"), (_tmp13 = (g_free (_tmp13), NULL)), _tmp14);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), cparam);
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
		}
		(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
			ValaDelegateType* _tmp15;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp16;
			ValaDelegate* d;
			/* return delegate target if appropriate*/
			_tmp15 = NULL;
			deleg_type = (_tmp15 = VALA_DELEGATE_TYPE (creturn_type), (_tmp15 == NULL ? NULL : g_object_ref (_tmp15)));
			_tmp16 = NULL;
			d = (_tmp16 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp17;
				ValaCCodeFormalParameter* _tmp18;
				ValaCCodeFormalParameter* cparam;
				_tmp17 = NULL;
				_tmp18 = NULL;
				cparam = (_tmp18 = vala_ccode_formal_parameter_new ((_tmp17 = vala_ccode_generator_get_delegate_target_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), "result")), "void*"), (_tmp17 = (g_free (_tmp17), NULL)), _tmp18);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	_tmp19 = NULL;
	if ((_tmp20 = gee_collection_get_size (GEE_COLLECTION ((_tmp19 = vala_code_node_get_error_types (VALA_CODE_NODE (m))))) > 0, (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), FALSE)), cparam);
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp21;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (cparam_map);
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (g_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (g_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp21 = NULL;
		vala_ccode_function_add_parameter (func, (_tmp21 = ((ValaCCodeFormalParameter*) (gee_map_get (cparam_map, GINT_TO_POINTER (min_pos))))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp22;
			_tmp22 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, (_tmp22 = ((ValaCCodeFormalParameter*) (gee_map_get (cparam_map, GINT_TO_POINTER (min_pos))))));
			(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		}
		last_pos = min_pos;
	}
}


static ValaCCodeStatement* vala_ccode_method_binding_create_method_type_check_statement (ValaCCodeMethodBinding* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_ccode_generator_create_type_check_statement (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CODE_NODE (m), return_type, t, non_null, var_name);
}


static ValaCCodeStatement* vala_ccode_method_binding_create_precondition_statement (ValaCCodeMethodBinding* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (precondition), NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (precondition))));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		cdefault = vala_ccode_generator_default_value_for_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp2;
			ValaCCodeStatement* _tmp3;
			ValaCCodeStatement* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return (_tmp4 = (_tmp3 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("0"))))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp4);
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	_tmp5 = NULL;
	return (_tmp5 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp5);
}


static ValaCCodeStatement* vala_ccode_method_binding_create_postcondition_statement (ValaCCodeMethodBinding* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeStatement* _tmp2;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (postcondition), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_assert")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (postcondition))));
	_tmp2 = NULL;
	return (_tmp2 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert))), (cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL))), _tmp2);
}


static ValaTypeSymbol* vala_ccode_method_binding_find_parent_type (ValaCCodeMethodBinding* self, ValaSymbol* sym) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypeSymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static gboolean vala_ccode_method_binding_is_possible_entry_point (ValaCCodeMethodBinding* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter) {
	GeeList* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArrayType* _tmp7;
	ValaArrayType* array_type;
	gboolean _tmp9;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_symbol_get_name (VALA_SYMBOL (m)) == NULL || _vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (m)), "main") != 0) {
		/* method must be called "main"*/
		return FALSE;
	}
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		/* method must be static*/
		return FALSE;
	}
	if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type)) {
			(*return_value) = TRUE;
		} else {
			/* return type must be void or int*/
			return FALSE;
		}
	}
	params = vala_method_get_parameters (m);
	if (gee_collection_get_size (GEE_COLLECTION (params)) == 0) {
		gboolean _tmp3;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (_tmp3 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp3);
	}
	if (gee_collection_get_size (GEE_COLLECTION (params)) > 1) {
		gboolean _tmp4;
		/* method must not have more than one parameter*/
		return (_tmp4 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
	}
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	gee_iterator_next (params_it);
	param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
	if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
		gboolean _tmp5;
		/* parameter must not be an out parameter*/
		return (_tmp5 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp5);
	}
	if (!(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
		gboolean _tmp6;
		/* parameter must be an array*/
		return (_tmp6 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp6);
	}
	_tmp7 = NULL;
	array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
		gboolean _tmp8;
		/* parameter must be an array of strings*/
		return (_tmp8 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp8);
	}
	(*args_parameter) = TRUE;
	return (_tmp9 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp9);
}


static void vala_ccode_method_binding_add_object_creation (ValaCCodeMethodBinding* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccall = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_object_newv")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	if (has_params) {
		ValaCCodeConstant* _tmp5;
		ValaCCodeConstant* _tmp6;
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("__params_it - __params"))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("__params"))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	} else {
		ValaCCodeConstant* _tmp7;
		ValaCCodeConstant* _tmp8;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	}
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdeclaration = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static ValaClass* vala_ccode_method_binding_find_fundamental_class (ValaCCodeMethodBinding* self, ValaClass* cl) {
	ValaClass* _tmp0;
	ValaClass* fundamental_class;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	_tmp0 = NULL;
	fundamental_class = (_tmp0 = cl, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	while (fundamental_class != NULL && vala_class_get_base_class (fundamental_class) != NULL) {
		ValaClass* _tmp2;
		ValaClass* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		fundamental_class = (_tmp2 = (_tmp1 = vala_class_get_base_class (fundamental_class), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (fundamental_class == NULL ? NULL : (fundamental_class = (g_object_unref (fundamental_class), NULL))), _tmp2);
	}
	return fundamental_class;
}


ValaMethod* vala_ccode_method_binding_get_method (ValaCCodeMethodBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), NULL);
	return self->priv->_method;
}


void vala_ccode_method_binding_set_method (ValaCCodeMethodBinding* self, ValaMethod* value) {
	ValaMethod* _tmp2;
	ValaMethod* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_METHOD_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "method");
}


gboolean vala_ccode_method_binding_get_has_wrapper (ValaCCodeMethodBinding* self) {
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_METHOD_BINDING (self), FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (self->priv->_method), "NoWrapper")) == NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
}


static void vala_ccode_method_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		g_value_set_object (value, vala_ccode_method_binding_get_method (self));
		break;
		case VALA_CCODE_METHOD_BINDING_HAS_WRAPPER:
		g_value_set_boolean (value, vala_ccode_method_binding_get_has_wrapper (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_METHOD_BINDING_METHOD:
		vala_ccode_method_binding_set_method (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_method_binding_class_init (ValaCCodeMethodBindingClass * klass) {
	vala_ccode_method_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMethodBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_method_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_method_binding_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_ccode_method_binding_finalize;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_method_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_METHOD, g_param_spec_object ("method", "method", "method", VALA_TYPE_METHOD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_METHOD_BINDING_HAS_WRAPPER, g_param_spec_boolean ("has-wrapper", "has-wrapper", "has-wrapper", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vala_ccode_method_binding_instance_init (ValaCCodeMethodBinding * self) {
	self->priv = VALA_CCODE_METHOD_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_method_binding_finalize (GObject * obj) {
	ValaCCodeMethodBinding * self;
	self = VALA_CCODE_METHOD_BINDING (obj);
	(self->priv->_method == NULL ? NULL : (self->priv->_method = (g_object_unref (self->priv->_method), NULL)));
	G_OBJECT_CLASS (vala_ccode_method_binding_parent_class)->finalize (obj);
}


GType vala_ccode_method_binding_get_type (void) {
	static GType vala_ccode_method_binding_type_id = 0;
	if (vala_ccode_method_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodBinding), 0, (GInstanceInitFunc) vala_ccode_method_binding_instance_init };
		vala_ccode_method_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeMethodBinding", &g_define_type_info, 0);
	}
	return vala_ccode_method_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




