/* valagenieparser.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#ifndef __VALA_VALAGENIEPARSER_H__
#define __VALA_VALAGENIEPARSER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define VALA_GENIE_TYPE_PARSER (vala_genie_parser_get_type ())
#define VALA_GENIE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GENIE_TYPE_PARSER, ValaGenieParser))
#define VALA_GENIE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GENIE_TYPE_PARSER, ValaGenieParserClass))
#define VALA_GENIE_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GENIE_TYPE_PARSER))
#define VALA_GENIE_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GENIE_TYPE_PARSER))
#define VALA_GENIE_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GENIE_TYPE_PARSER, ValaGenieParserClass))

typedef struct _ValaGenieParser ValaGenieParser;
typedef struct _ValaGenieParserClass ValaGenieParserClass;
typedef struct _ValaGenieParserPrivate ValaGenieParserPrivate;

/**
 * Code visitor parsing all Genie source files.
 */
struct _ValaGenieParser {
	ValaCodeVisitor parent_instance;
	ValaGenieParserPrivate * priv;
};

struct _ValaGenieParserClass {
	ValaCodeVisitorClass parent_class;
};


void vala_genie_parser_parse (ValaGenieParser* self, ValaCodeContext* context);
void vala_genie_parser_parse_file (ValaGenieParser* self, ValaSourceFile* source_file);
ValaGenieParser* vala_genie_parser_new (void);
GType vala_genie_parser_get_type (void);


G_END_DECLS

#endif
