/* valaccodestruct.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodestruct.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>




struct _ValaCCodeStructPrivate {
	char* _name;
	GeeList* declarations;
};

#define VALA_CCODE_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructPrivate))
enum  {
	VALA_CCODE_STRUCT_DUMMY_PROPERTY
};
static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_struct_parent_class = NULL;
static void vala_ccode_struct_finalize (ValaCCodeNode* obj);



ValaCCodeStruct* vala_ccode_struct_construct (GType object_type, const char* name) {
	ValaCCodeStruct* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaCCodeStruct*) g_type_create_instance (object_type);
	vala_ccode_struct_set_name (self, name);
	return self;
}


ValaCCodeStruct* vala_ccode_struct_new (const char* name) {
	return vala_ccode_struct_construct (VALA_TYPE_CCODE_STRUCT, name);
}


/**
 * Adds the specified declaration as member to this struct.
 *
 * @param decl a variable declaration
 */
void vala_ccode_struct_add_declaration (ValaCCodeStruct* self, ValaCCodeDeclaration* decl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (decl != NULL);
	gee_collection_add ((GeeCollection*) self->priv->declarations, decl);
}


/**
 * Adds a variable with the specified type and name to this struct.
 *
 * @param type_name field type
 * @param name      member name
 */
void vala_ccode_struct_add_field (ValaCCodeStruct* self, const char* type_name, const char* name) {
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_name != NULL);
	g_return_if_fail (name != NULL);
	decl = vala_ccode_declaration_new (type_name);
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (decl, (ValaCCodeDeclarator*) (_tmp0 = vala_ccode_variable_declarator_new (name, NULL)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	vala_ccode_struct_add_declaration (self, decl);
	(decl == NULL) ? NULL : (decl = (vala_ccode_node_unref (decl), NULL));
}


static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeStruct * self;
	self = (ValaCCodeStruct*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "struct ");
	vala_ccode_writer_write_string (writer, self->priv->_name);
	vala_ccode_writer_write_begin_block (writer);
	{
		GeeIterator* _decl_it;
		_decl_it = gee_iterable_iterator ((GeeIterable*) self->priv->declarations);
		while (gee_iterator_next (_decl_it)) {
			ValaCCodeDeclaration* decl;
			decl = (ValaCCodeDeclaration*) gee_iterator_get (_decl_it);
			vala_ccode_node_write_declaration ((ValaCCodeNode*) decl, writer);
			(decl == NULL) ? NULL : (decl = (vala_ccode_node_unref (decl), NULL));
		}
		(_decl_it == NULL) ? NULL : (_decl_it = (gee_collection_object_unref (_decl_it), NULL));
	}
	vala_ccode_writer_write_end_block (writer);
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_struct_get_name (ValaCCodeStruct* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_struct_set_name (ValaCCodeStruct* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
}


static void vala_ccode_struct_class_init (ValaCCodeStructClass * klass) {
	vala_ccode_struct_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_struct_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeStructPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_struct_real_write;
}


static void vala_ccode_struct_instance_init (ValaCCodeStruct * self) {
	self->priv = VALA_CCODE_STRUCT_GET_PRIVATE (self);
	self->priv->declarations = (GeeList*) gee_array_list_new (VALA_TYPE_CCODE_DECLARATION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_struct_finalize (ValaCCodeNode* obj) {
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->declarations == NULL) ? NULL : (self->priv->declarations = (gee_collection_object_unref (self->priv->declarations), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_struct_parent_class)->finalize (obj);
}


GType vala_ccode_struct_get_type (void) {
	static GType vala_ccode_struct_type_id = 0;
	if (vala_ccode_struct_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStruct), 0, (GInstanceInitFunc) vala_ccode_struct_instance_init, NULL };
		vala_ccode_struct_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeStruct", &g_define_type_info, 0);
	}
	return vala_ccode_struct_type_id;
}




