/* valadbusservermodule.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
*  Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <gobject/valadbusservermodule.h>
#include <vala/valacodenode.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaattribute.h>
#include <vala/valamethod.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <vala/valadatatype.h>
#include <vala/valasymbol.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valastruct.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valavoidtype.h>
#include <gee/collection.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valasignal.h>
#include <vala/valaobjecttype.h>
#include <ccode/valaccodeinitializerlist.h>
#include <vala/valaclass.h>
#include <vala/valacreationmethod.h>
#include <vala/valamember.h>
#include <vala/valaproperty.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaexpression.h>
#include <vala/valamethodtype.h>
#include <vala/valacodevisitor.h>
#include <vala/valamemberaccess.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valadbusmodule.h>




enum  {
	VALA_DBUS_SERVER_MODULE_DUMMY_PROPERTY
};
static gboolean vala_dbus_server_module_is_dbus_visible (ValaDBusServerModule* self, ValaCodeNode* node);
static char* vala_dbus_server_module_dbus_result_name (ValaDBusServerModule* self, ValaMethod* m);
static char* vala_dbus_server_module_generate_dbus_wrapper (ValaDBusServerModule* self, ValaMethod* m, ValaObjectTypeSymbol* sym);
static char* vala_dbus_server_module_generate_dbus_signal_wrapper (ValaDBusServerModule* self, ValaSignal* sig, ValaObjectTypeSymbol* sym, const char* dbus_iface_name);
static void vala_dbus_server_module_generate_register_function (ValaDBusServerModule* self, ValaObjectType* object_type);
static void vala_dbus_server_module_generate_unregister_function (ValaDBusServerModule* self, ValaObjectType* object_type);
static void vala_dbus_server_module_handle_method (ValaDBusServerModule* self, const char* dbus_iface_name, const char* dbus_method_name, const char* handler_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif);
static void vala_dbus_server_module_handle_methods (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif);
static char* vala_dbus_server_module_generate_dbus_property_get_wrapper (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name);
static char* vala_dbus_server_module_generate_dbus_property_get_all_wrapper (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name);
static char* vala_dbus_server_module_generate_dbus_property_set_wrapper (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name);
static char* vala_dbus_server_module_get_dbus_type_introspection (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym);
static char* vala_dbus_server_module_generate_dbus_introspect (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym);
static void vala_dbus_server_module_handle_signals (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, ValaCCodeBlock* block);
static void vala_dbus_server_module_generate_message_function (ValaDBusServerModule* self, ValaObjectType* object_type);
static ValaCCodeExpression* vala_dbus_server_module_get_vtable (ValaDBusServerModule* self, ValaObjectType* object_type);
static ValaCCodeExpression* vala_dbus_server_module_get_path_vtable (ValaDBusServerModule* self, ValaObjectType* object_type);
static void vala_dbus_server_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gboolean vala_dbus_server_module_type_implements_dbus_interface (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym);
static ValaCCodeFragment* vala_dbus_server_module_real_register_dbus_info (ValaCCodeModule* base, ValaObjectTypeSymbol* sym);
static gpointer vala_dbus_server_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaDBusServerModule* vala_dbus_server_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaDBusServerModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaDBusServerModule*) vala_dbus_client_module_construct (object_type, codegen, next);
	return self;
}


ValaDBusServerModule* vala_dbus_server_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_dbus_server_module_construct (VALA_TYPE_DBUS_SERVER_MODULE, codegen, next);
}


static gboolean vala_dbus_server_module_is_dbus_visible (ValaDBusServerModule* self, ValaCodeNode* node) {
	ValaAttribute* dbus_attribute;
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp3;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	dbus_attribute = vala_code_node_get_attribute (node, "DBus");
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (dbus_attribute != NULL) {
		_tmp1 = vala_attribute_has_argument (dbus_attribute, "visible");
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = !vala_attribute_get_bool (dbus_attribute, "visible");
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp2);
	}
	return (_tmp3 = TRUE, (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp3);
}


static char* vala_dbus_server_module_dbus_result_name (ValaDBusServerModule* self, ValaMethod* m) {
	ValaAttribute* dbus_attribute;
	gboolean _tmp0;
	char* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	dbus_attribute = vala_code_node_get_attribute ((ValaCodeNode*) m, "DBus");
	_tmp0 = FALSE;
	if (dbus_attribute != NULL) {
		_tmp0 = vala_attribute_has_argument (dbus_attribute, "result");
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		char* result_name;
		gboolean _tmp1;
		result_name = vala_attribute_get_string (dbus_attribute, "result");
		_tmp1 = FALSE;
		if (result_name != NULL) {
			_tmp1 = _vala_strcmp0 (result_name, "") != 0;
		} else {
			_tmp1 = FALSE;
		}
		if (_tmp1) {
			char* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = result_name, (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp2);
		}
		result_name = (g_free (result_name), NULL);
	}
	_tmp3 = NULL;
	return (_tmp3 = g_strdup ("result"), (dbus_attribute == NULL) ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL)), _tmp3);
}


static char* vala_dbus_server_module_generate_dbus_wrapper (ValaDBusServerModule* self, ValaMethod* m, ValaObjectTypeSymbol* sym) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	ValaCCodeDeclaration* _tmp7;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeDeclaration* _tmp9;
	ValaCCodeVariableDeclarator* _tmp11;
	ValaCCodeConstant* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeFunctionCall* _tmp13;
	ValaCCodeFunctionCall* message_signature;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* signature_check;
	ValaCCodeBlock* signature_error_block;
	ValaCCodeReturnStatement* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIfStatement* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeUnaryExpression* _tmp24;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeUnaryExpression* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp31;
	ValaCCodeIdentifier* _tmp33;
	char* _tmp32;
	ValaCCodeFunctionCall* _tmp34;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp35;
	char* type_signature;
	ValaCCodeConstant* _tmp76;
	char* _tmp75;
	ValaCCodeDeclaration* _tmp96;
	ValaCCodeVariableDeclarator* _tmp97;
	GeeList* _tmp98;
	gboolean _tmp99;
	ValaCCodeIdentifier* _tmp115;
	ValaCCodeFunctionCall* _tmp116;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeIdentifier* _tmp117;
	ValaCCodeExpressionStatement* _tmp120;
	ValaCCodeAssignment* _tmp119;
	ValaCCodeIdentifier* _tmp118;
	ValaCCodeReturnStatement* _tmp122;
	ValaCCodeIdentifier* _tmp121;
	ValaCCodeFunction* _tmp123;
	char* _tmp124;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s", _tmp0 = vala_method_get_cname (m)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	/* declaration*/
	cdecl_ = NULL;
	function = vala_ccode_function_new (wrapper_name, "DBusMessage*");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) sym, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	_tmp7 = NULL;
	cdecl_ = (_tmp7 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp7);
	_tmp8 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp8 = vala_ccode_variable_declarator_new ("iter", NULL)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp9 = NULL;
	cdecl_ = (_tmp9 = vala_ccode_declaration_new ("GError*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new ("error", (ValaCCodeExpression*) (_tmp10 = vala_ccode_constant_new ("NULL")))));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp12 = NULL;
	_tmp13 = NULL;
	message_signature = (_tmp13 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("dbus_message_get_signature"))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (message_signature, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("message")));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp15 = NULL;
	_tmp16 = NULL;
	signature_check = (_tmp16 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("strcmp"))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp16);
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) message_signature);
	signature_error_block = vala_ccode_block_new ();
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_block_add_statement (signature_error_block, (ValaCCodeNode*) (_tmp18 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new ("NULL")))));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp19 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp19 = vala_ccode_if_statement_new ((ValaCCodeExpression*) signature_check, (ValaCCodeStatement*) signature_error_block, NULL)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = NULL;
	_tmp21 = NULL;
	iter_call = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("dbus_message_iter_init"))), (_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("message")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp24 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("iter")))));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp25 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp25 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp27 = NULL;
	_tmp26 = NULL;
	iter_call = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp27);
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("reply")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp30 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("iter")))));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	_tmp31 = NULL;
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp34 = NULL;
	ccall = (_tmp34 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new (_tmp32 = vala_method_get_cname (m)))), (_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)), _tmp32 = (g_free (_tmp32), NULL), _tmp34);
	_tmp35 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("self")));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	/* expected type signature for input parameters*/
	type_signature = g_strdup ("");
	{
		GeeList* _tmp36;
		GeeIterator* _tmp37;
		GeeIterator* _param_it;
		_tmp36 = NULL;
		_tmp37 = NULL;
		_param_it = (_tmp37 = gee_iterable_iterator ((GeeIterable*) (_tmp36 = vala_method_get_parameters (m))), (_tmp36 == NULL) ? NULL : (_tmp36 = (gee_collection_object_unref (_tmp36), NULL)), _tmp37);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			ValaCCodeDeclaration* _tmp39;
			char* _tmp38;
			ValaCCodeVariableDeclarator* _tmp41;
			ValaCCodeExpression* _tmp40;
			gboolean _tmp42;
			gboolean _tmp43;
			gboolean _tmp44;
			char* _tmp49;
			gboolean _tmp50;
			ValaStruct* _tmp54;
			ValaTypeSymbol* _tmp53;
			ValaStruct* st;
			gboolean _tmp55;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp39 = NULL;
			_tmp38 = NULL;
			cdecl_ = (_tmp39 = vala_ccode_declaration_new (_tmp38 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp39);
			_tmp38 = (g_free (_tmp38), NULL);
			_tmp41 = NULL;
			_tmp40 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp41 = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param), _tmp40 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), TRUE))));
			(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
			(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
			vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
			_tmp42 = FALSE;
			_tmp43 = FALSE;
			_tmp44 = FALSE;
			if (_vala_strcmp0 (type_signature, "") == 0) {
				_tmp44 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp44 = FALSE;
			}
			if (_tmp44) {
				_tmp43 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)) != NULL;
			} else {
				_tmp43 = FALSE;
			}
			if (_tmp43) {
				char* _tmp45;
				_tmp45 = NULL;
				_tmp42 = _vala_strcmp0 (_tmp45 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), "DBus.BusName") == 0;
				_tmp45 = (g_free (_tmp45), NULL);
			} else {
				_tmp42 = FALSE;
			}
			if (_tmp42) {
				ValaCCodeIdentifier* _tmp46;
				ValaCCodeFunctionCall* _tmp47;
				ValaCCodeFunctionCall* get_sender;
				ValaCCodeIdentifier* _tmp48;
				/* first parameter is a string parameter called 'sender'
				 pass bus name of sender*/
				_tmp46 = NULL;
				_tmp47 = NULL;
				get_sender = (_tmp47 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("dbus_message_get_sender"))), (_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)), _tmp47);
				_tmp48 = NULL;
				vala_ccode_function_call_add_argument (get_sender, (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("message")));
				(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) get_sender);
				(get_sender == NULL) ? NULL : (get_sender = (vala_ccode_node_unref (get_sender), NULL));
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp49 = NULL;
			if ((_tmp50 = (_tmp49 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))) == NULL, _tmp49 = (g_free (_tmp49), NULL), _tmp50)) {
				char* _tmp52;
				char* _tmp51;
				_tmp52 = NULL;
				_tmp51 = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_formal_parameter_get_parameter_type (param)), _tmp52 = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp51 = vala_code_node_to_string ((ValaCodeNode*) vala_formal_parameter_get_parameter_type (param))));
				_tmp52 = (g_free (_tmp52), NULL);
				_tmp51 = (g_free (_tmp51), NULL);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp54 = NULL;
			_tmp53 = NULL;
			st = (_tmp54 = (_tmp53 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), VALA_IS_STRUCT (_tmp53) ? ((ValaStruct*) _tmp53) : NULL), (_tmp54 == NULL) ? NULL : vala_code_node_ref (_tmp54));
			_tmp55 = FALSE;
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
				_tmp55 = TRUE;
			} else {
				gboolean _tmp56;
				_tmp56 = FALSE;
				if (st != NULL) {
					_tmp56 = !vala_struct_is_simple_type (st);
				} else {
					_tmp56 = FALSE;
				}
				_tmp55 = _tmp56;
			}
			if (_tmp55) {
				ValaCCodeUnaryExpression* _tmp58;
				ValaCCodeIdentifier* _tmp57;
				_tmp58 = NULL;
				_tmp57 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp58 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
				(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
				(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
			} else {
				ValaCCodeIdentifier* _tmp59;
				_tmp59 = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			}
			if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaArrayType* _tmp60;
				ValaArrayType* array_type;
				_tmp60 = NULL;
				array_type = (_tmp60 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp60 == NULL) ? NULL : vala_code_node_ref (_tmp60));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* length_cname;
						ValaCCodeDeclaration* _tmp61;
						ValaCCodeVariableDeclarator* _tmp63;
						ValaCCodeConstant* _tmp62;
						length_cname = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) param), dim);
						_tmp61 = NULL;
						cdecl_ = (_tmp61 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp61);
						_tmp63 = NULL;
						_tmp62 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp63 = vala_ccode_variable_declarator_new (length_cname, (ValaCCodeExpression*) (_tmp62 = vala_ccode_constant_new ("0")))));
						(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
						(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
						vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
							ValaCCodeUnaryExpression* _tmp65;
							ValaCCodeIdentifier* _tmp64;
							_tmp65 = NULL;
							_tmp64 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp65 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new (length_cname)))));
							(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
							(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
						} else {
							ValaCCodeIdentifier* _tmp66;
							_tmp66 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new (length_cname)));
							(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
						}
						length_cname = (g_free (length_cname), NULL);
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
				char* _tmp68;
				char* _tmp67;
				ValaCCodeIdentifier* target;
				ValaCCodeIdentifier* _tmp69;
				ValaCCodeExpression* _tmp70;
				ValaCCodeExpression* expr;
				ValaCCodeExpressionStatement* _tmp72;
				ValaCCodeAssignment* _tmp71;
				_tmp68 = NULL;
				_tmp67 = NULL;
				type_signature = (_tmp68 = g_strconcat (type_signature, _tmp67 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), NULL), type_signature = (g_free (type_signature), NULL), _tmp68);
				_tmp67 = (g_free (_tmp67), NULL);
				target = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
				_tmp69 = NULL;
				_tmp70 = NULL;
				expr = (_tmp70 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp69 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)), _tmp70);
				_tmp72 = NULL;
				_tmp71 = NULL;
				vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp72 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp71 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
				(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
				(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
				(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
			} else {
				ValaCCodeIdentifier* _tmp74;
				ValaCCodeIdentifier* _tmp73;
				_tmp74 = NULL;
				_tmp73 = NULL;
				vala_dbus_module_write_expression ((ValaDBusModule*) self, postfragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) (_tmp74 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
				(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp76 = NULL;
	_tmp75 = NULL;
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) (_tmp76 = vala_ccode_constant_new (_tmp75 = g_strdup_printf ("\"%s\"", type_signature))));
	(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
	_tmp75 = (g_free (_tmp75), NULL);
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		char* _tmp77;
		gboolean _tmp78;
		_tmp77 = NULL;
		if ((_tmp78 = (_tmp77 = vala_data_type_get_type_signature (vala_method_get_return_type (m))) == NULL, _tmp77 = (g_free (_tmp77), NULL), _tmp78)) {
			char* _tmp80;
			char* _tmp79;
			_tmp80 = NULL;
			_tmp79 = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_method_get_return_type (m)), _tmp80 = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp79 = vala_code_node_to_string ((ValaCodeNode*) vala_method_get_return_type (m))));
			_tmp80 = (g_free (_tmp80), NULL);
			_tmp79 = (g_free (_tmp79), NULL);
		} else {
			ValaCCodeDeclaration* _tmp82;
			char* _tmp81;
			ValaCCodeVariableDeclarator* _tmp83;
			ValaCCodeExpressionStatement* _tmp86;
			ValaCCodeAssignment* _tmp85;
			ValaCCodeIdentifier* _tmp84;
			ValaCCodeIdentifier* _tmp94;
			ValaCCodeIdentifier* _tmp93;
			_tmp82 = NULL;
			_tmp81 = NULL;
			cdecl_ = (_tmp82 = vala_ccode_declaration_new (_tmp81 = vala_data_type_get_cname (vala_method_get_return_type (m))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp82);
			_tmp81 = (g_free (_tmp81), NULL);
			_tmp83 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp83 = vala_ccode_variable_declarator_new ("result", NULL)));
			(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
			_tmp86 = NULL;
			_tmp85 = NULL;
			_tmp84 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp86 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp85 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
			(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
			if (VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m))) {
				ValaArrayType* _tmp87;
				ValaArrayType* array_type;
				_tmp87 = NULL;
				array_type = (_tmp87 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp87 == NULL) ? NULL : vala_code_node_ref (_tmp87));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* length_cname;
						ValaCCodeDeclaration* _tmp88;
						ValaCCodeVariableDeclarator* _tmp90;
						ValaCCodeConstant* _tmp89;
						ValaCCodeUnaryExpression* _tmp92;
						ValaCCodeIdentifier* _tmp91;
						length_cname = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, "result", dim);
						_tmp88 = NULL;
						cdecl_ = (_tmp88 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp88);
						_tmp90 = NULL;
						_tmp89 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp90 = vala_ccode_variable_declarator_new (length_cname, (ValaCCodeExpression*) (_tmp89 = vala_ccode_constant_new ("0")))));
						(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
						(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
						vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
						_tmp92 = NULL;
						_tmp91 = NULL;
						vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp92 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp91 = vala_ccode_identifier_new (length_cname)))));
						(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
						(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
						length_cname = (g_free (length_cname), NULL);
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			_tmp94 = NULL;
			_tmp93 = NULL;
			vala_dbus_module_write_expression ((ValaDBusModule*) self, postfragment, vala_method_get_return_type (m), (ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("result")));
			(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
			(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
		}
	} else {
		ValaCCodeExpressionStatement* _tmp95;
		_tmp95 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp95 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
	}
	_tmp96 = NULL;
	cdecl_ = (_tmp96 = vala_ccode_declaration_new ("DBusMessage*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp96);
	_tmp97 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp97 = vala_ccode_variable_declarator_new ("reply", NULL)));
	(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp98 = NULL;
	if ((_tmp99 = gee_collection_get_size ((GeeCollection*) (_tmp98 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp98 == NULL) ? NULL : (_tmp98 = (gee_collection_object_unref (_tmp98), NULL)), _tmp99)) {
		ValaCCodeUnaryExpression* _tmp101;
		ValaCCodeIdentifier* _tmp100;
		ValaCCodeBlock* error_block;
		ValaCCodeIdentifier* _tmp102;
		ValaCCodeFunctionCall* _tmp103;
		ValaCCodeFunctionCall* msgcall;
		ValaCCodeIdentifier* _tmp104;
		ValaCCodeIdentifier* _tmp105;
		ValaCCodeMemberAccess* _tmp107;
		ValaCCodeIdentifier* _tmp106;
		ValaCCodeExpressionStatement* _tmp110;
		ValaCCodeAssignment* _tmp109;
		ValaCCodeIdentifier* _tmp108;
		ValaCCodeReturnStatement* _tmp112;
		ValaCCodeIdentifier* _tmp111;
		ValaCCodeIfStatement* _tmp114;
		ValaCCodeIdentifier* _tmp113;
		_tmp101 = NULL;
		_tmp100 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp101 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp100 = vala_ccode_identifier_new ("error")))));
		(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
		(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
		error_block = vala_ccode_block_new ();
		_tmp102 = NULL;
		_tmp103 = NULL;
		msgcall = (_tmp103 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new ("dbus_message_new_error"))), (_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)), _tmp103);
		_tmp104 = NULL;
		vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp104 = vala_ccode_identifier_new ("message")));
		(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
		_tmp105 = NULL;
		vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new ("DBUS_ERROR_FAILED")));
		(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
		_tmp107 = NULL;
		_tmp106 = NULL;
		vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp107 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp106 = vala_ccode_identifier_new ("error")), "message")));
		(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
		(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
		_tmp110 = NULL;
		_tmp109 = NULL;
		_tmp108 = NULL;
		vala_ccode_block_add_statement (error_block, (ValaCCodeNode*) (_tmp110 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp109 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp108 = vala_ccode_identifier_new ("reply")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
		(_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL));
		(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
		_tmp112 = NULL;
		_tmp111 = NULL;
		vala_ccode_block_add_statement (error_block, (ValaCCodeNode*) (_tmp112 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp111 = vala_ccode_identifier_new ("reply")))));
		(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
		(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
		_tmp114 = NULL;
		_tmp113 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp114 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp113 = vala_ccode_identifier_new ("error")), (ValaCCodeStatement*) error_block, NULL)));
		(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
		(_tmp113 == NULL) ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL));
		(error_block == NULL) ? NULL : (error_block = (vala_ccode_node_unref (error_block), NULL));
		(msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL));
	}
	_tmp115 = NULL;
	_tmp116 = NULL;
	msgcall = (_tmp116 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp115 = vala_ccode_identifier_new ("dbus_message_new_method_return"))), (_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL)), _tmp116);
	_tmp117 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp117 = vala_ccode_identifier_new ("message")));
	(_tmp117 == NULL) ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL));
	_tmp120 = NULL;
	_tmp119 = NULL;
	_tmp118 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp120 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp119 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp118 = vala_ccode_identifier_new ("reply")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
	(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
	(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) postfragment);
	_tmp122 = NULL;
	_tmp121 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp122 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new ("reply")))));
	(_tmp122 == NULL) ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL));
	(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
	_tmp123 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp123 = vala_ccode_function_copy (function)));
	(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp124 = NULL;
	return (_tmp124 = wrapper_name, (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL)), (message_signature == NULL) ? NULL : (message_signature = (vala_ccode_node_unref (message_signature), NULL)), (signature_check == NULL) ? NULL : (signature_check = (vala_ccode_node_unref (signature_check), NULL)), (signature_error_block == NULL) ? NULL : (signature_error_block = (vala_ccode_node_unref (signature_error_block), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), type_signature = (g_free (type_signature), NULL), (msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL)), _tmp124);
}


static char* vala_dbus_server_module_generate_dbus_signal_wrapper (ValaDBusServerModule* self, ValaSignal* sig, ValaObjectTypeSymbol* sym, const char* dbus_iface_name) {
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* wrapper_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp10;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* path;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeConstant* _tmp14;
	ValaCCodeDeclaration* _tmp15;
	ValaCCodeVariableDeclarator* _tmp16;
	ValaCCodeDeclaration* _tmp17;
	ValaCCodeVariableDeclarator* _tmp18;
	ValaCCodeDeclaration* _tmp19;
	ValaCCodeVariableDeclarator* _tmp20;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeConstant* _tmp25;
	char* _tmp24;
	ValaCCodeConstant* _tmp28;
	char* _tmp27;
	char* _tmp26;
	ValaCCodeExpressionStatement* _tmp31;
	ValaCCodeAssignment* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeFunctionCall* _tmp33;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeUnaryExpression* _tmp36;
	ValaCCodeIdentifier* _tmp35;
	ValaCCodeExpressionStatement* _tmp37;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeFunctionCall* _tmp43;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp44;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeConstant* _tmp46;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeFunctionCall* _tmp49;
	ValaCCodeFunctionCall* message_unref;
	ValaCCodeIdentifier* _tmp50;
	ValaCCodeExpressionStatement* _tmp51;
	ValaCCodeFunction* _tmp52;
	char* _tmp53;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (dbus_iface_name != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	wrapper_name = (_tmp2 = g_strdup_printf ("_dbus_%s_%s", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) sym, NULL), _tmp1 = vala_signal_get_cname (sig)), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	/* declaration*/
	cdecl_ = NULL;
	function = vala_ccode_function_new (wrapper_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("_sender", "GObject*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	{
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* _param_it;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_param_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_signal_get_parameters (sig))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			ValaCCodeFormalParameter* _tmp6;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp6 = NULL;
			vala_ccode_function_add_parameter (function, _tmp6 = VALA_CCODE_FORMAL_PARAMETER (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) param)));
			(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
			if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaArrayType* _tmp7;
				ValaArrayType* array_type;
				_tmp7 = NULL;
				array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeFormalParameter* _tmp9;
						char* _tmp8;
						_tmp9 = NULL;
						_tmp8 = NULL;
						vala_ccode_function_add_parameter (function, _tmp9 = vala_ccode_formal_parameter_new (_tmp8 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), dim), "int"));
						(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
						_tmp8 = (g_free (_tmp8), NULL);
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp10 = NULL;
	vala_ccode_function_add_parameter (function, _tmp10 = vala_ccode_formal_parameter_new ("_connection", "DBusConnection*"));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	_tmp11 = NULL;
	_tmp12 = NULL;
	path = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("g_object_get_data"))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp12);
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("_sender")));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("\"dbus_object_path\"")));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp15 = NULL;
	cdecl_ = (_tmp15 = vala_ccode_declaration_new ("const char *"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp15);
	_tmp16 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp16 = vala_ccode_variable_declarator_new ("_path", (ValaCCodeExpression*) path)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp17 = NULL;
	cdecl_ = (_tmp17 = vala_ccode_declaration_new ("DBusMessage"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp18 = vala_ccode_variable_declarator_new ("*_message", NULL)));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp19 = NULL;
	cdecl_ = (_tmp19 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp19);
	_tmp20 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp20 = vala_ccode_variable_declarator_new ("_iter", NULL)));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp21 = NULL;
	_tmp22 = NULL;
	msgcall = (_tmp22 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("dbus_message_new_signal"))), (_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)), _tmp22);
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("_path")));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_constant_new (_tmp24 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp24 = (g_free (_tmp24), NULL);
	_tmp28 = NULL;
	_tmp27 = NULL;
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp28 = vala_ccode_constant_new (_tmp27 = g_strdup_printf ("\"%s\"", _tmp26 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) sig))))));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp27 = (g_free (_tmp27), NULL);
	_tmp26 = (g_free (_tmp26), NULL);
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("_message")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	_tmp32 = NULL;
	_tmp33 = NULL;
	iter_call = (_tmp33 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)), _tmp33);
	_tmp34 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("_message")));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp36 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("_iter")))));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	_tmp37 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp37 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	{
		GeeList* _tmp38;
		GeeIterator* _tmp39;
		GeeIterator* _param_it;
		_tmp38 = NULL;
		_tmp39 = NULL;
		_param_it = (_tmp39 = gee_iterable_iterator ((GeeIterable*) (_tmp38 = vala_signal_get_parameters (sig))), (_tmp38 == NULL) ? NULL : (_tmp38 = (gee_collection_object_unref (_tmp38), NULL)), _tmp39);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			ValaCCodeExpression* expr;
			ValaCCodeIdentifier* _tmp41;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			expr = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
			if (vala_data_type_is_real_struct_type (vala_formal_parameter_get_parameter_type (param))) {
				ValaCCodeExpression* _tmp40;
				_tmp40 = NULL;
				expr = (_tmp40 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, expr), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp40);
			}
			_tmp41 = NULL;
			vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("_iter")), expr);
			(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp42 = NULL;
	_tmp43 = NULL;
	ccall = (_tmp43 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("dbus_connection_send"))), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)), _tmp43);
	_tmp44 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new ("_connection")));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	_tmp45 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new ("_message")));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp46 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp46 = vala_ccode_constant_new ("NULL")));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp47 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp47 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	_tmp48 = NULL;
	_tmp49 = NULL;
	message_unref = (_tmp49 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
	_tmp50 = NULL;
	vala_ccode_function_call_add_argument (message_unref, (ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("_message")));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	_tmp51 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp51 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) message_unref)));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	_tmp52 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp52 = vala_ccode_function_copy (function)));
	(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp53 = NULL;
	return (_tmp53 = wrapper_name, (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL)), (msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (message_unref == NULL) ? NULL : (message_unref = (vala_ccode_node_unref (message_unref), NULL)), _tmp53);
}


static void vala_dbus_server_module_generate_register_function (ValaDBusServerModule* self, ValaObjectType* object_type) {
	ValaObjectTypeSymbol* _tmp0;
	ValaObjectTypeSymbol* sym;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* cfunc;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* get_path;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeConstant* _tmp12;
	ValaCCodeUnaryExpression* register_check;
	ValaCCodeBlock* register_block;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* path_dup;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* set_path;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeConstant* _tmp19;
	ValaCCodeExpressionStatement* _tmp20;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* cregister;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeUnaryExpression* _tmp26;
	ValaCCodeExpression* _tmp25;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeExpressionStatement* _tmp28;
	ValaCCodeIfStatement* _tmp29;
	ValaClass* _tmp31;
	ValaObjectTypeSymbol* _tmp30;
	ValaClass* cl;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_type != NULL);
	_tmp0 = NULL;
	sym = (_tmp0 = vala_object_type_get_type_symbol (object_type), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	cfunc = (_tmp3 = vala_ccode_function_new (_tmp2 = g_strconcat (_tmp1 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), "dbus_register_object", NULL), "void"), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp4 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp5 = vala_ccode_formal_parameter_new ("path", "const char*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp6 = vala_ccode_formal_parameter_new ("object", "void*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) sym)) {
		ValaCCodeFunction* _tmp7;
		((ValaCCodeBaseModule*) self)->dbus_glib_h_needed_in_header = TRUE;
		_tmp7 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp7 = vala_ccode_function_copy (cfunc)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	} else {
		ValaCCodeFunction* _tmp8;
		((ValaCCodeBaseModule*) self)->dbus_glib_h_needed = TRUE;
		vala_ccode_function_set_modifiers (cfunc, vala_ccode_function_get_modifiers (cfunc) | VALA_CCODE_MODIFIERS_STATIC);
		_tmp8 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp8 = vala_ccode_function_copy (cfunc)));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	}
	block = vala_ccode_block_new ();
	vala_ccode_function_set_block (cfunc, block);
	_tmp9 = NULL;
	_tmp10 = NULL;
	get_path = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("g_object_get_data"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (get_path, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("object")));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (get_path, (ValaCCodeExpression*) (_tmp12 = vala_ccode_constant_new ("\"dbus_object_path\"")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	register_check = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) get_path);
	register_block = vala_ccode_block_new ();
	_tmp13 = NULL;
	_tmp14 = NULL;
	path_dup = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("g_strdup"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (path_dup, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("path")));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	_tmp17 = NULL;
	set_path = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_object_set_data"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (set_path, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("object")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (set_path, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("\"dbus_object_path\"")));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	vala_ccode_function_call_add_argument (set_path, (ValaCCodeExpression*) path_dup);
	_tmp20 = NULL;
	vala_ccode_block_add_statement (register_block, (ValaCCodeNode*) (_tmp20 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_path)));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp21 = NULL;
	_tmp22 = NULL;
	cregister = (_tmp22 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("dbus_connection_register_object_path"))), (_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)), _tmp22);
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("connection")));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("path")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp26 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp25 = vala_dbus_server_module_get_path_vtable (self, object_type))));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("object")));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	vala_ccode_block_add_statement (register_block, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cregister)));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp29 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp29 = vala_ccode_if_statement_new ((ValaCCodeExpression*) register_check, (ValaCCodeStatement*) register_block, NULL)));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	vala_dbus_server_module_handle_signals (self, vala_object_type_get_type_symbol (object_type), block);
	_tmp31 = NULL;
	_tmp30 = NULL;
	cl = (_tmp31 = (_tmp30 = sym, VALA_IS_CLASS (_tmp30) ? ((ValaClass*) _tmp30) : NULL), (_tmp31 == NULL) ? NULL : vala_code_node_ref (_tmp31));
	if (cl != NULL) {
		{
			GeeList* _tmp32;
			GeeIterator* _tmp33;
			GeeIterator* _base_type_it;
			_tmp32 = NULL;
			_tmp33 = NULL;
			_base_type_it = (_tmp33 = gee_iterable_iterator ((GeeIterable*) (_tmp32 = vala_class_get_base_types (cl))), (_tmp32 == NULL) ? NULL : (_tmp32 = (gee_collection_object_unref (_tmp32), NULL)), _tmp33);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				ValaObjectType* _tmp35;
				ValaDataType* _tmp34;
				ValaObjectType* base_obj_type;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				_tmp35 = NULL;
				_tmp34 = NULL;
				base_obj_type = (_tmp35 = (_tmp34 = base_type, VALA_IS_OBJECT_TYPE (_tmp34) ? ((ValaObjectType*) _tmp34) : NULL), (_tmp35 == NULL) ? NULL : vala_code_node_ref (_tmp35));
				if (vala_dbus_server_module_type_implements_dbus_interface (self, vala_object_type_get_type_symbol (base_obj_type))) {
					ValaCCodeIdentifier* _tmp38;
					char* _tmp37;
					char* _tmp36;
					ValaCCodeFunctionCall* _tmp39;
					ValaCCodeFunctionCall* base_register;
					ValaCCodeIdentifier* _tmp40;
					ValaCCodeIdentifier* _tmp41;
					ValaCCodeIdentifier* _tmp42;
					ValaCCodeExpressionStatement* _tmp43;
					_tmp38 = NULL;
					_tmp37 = NULL;
					_tmp36 = NULL;
					_tmp39 = NULL;
					base_register = (_tmp39 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new (_tmp37 = g_strconcat (_tmp36 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) vala_object_type_get_type_symbol (base_obj_type)), "dbus_register_object", NULL)))), (_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)), _tmp37 = (g_free (_tmp37), NULL), _tmp36 = (g_free (_tmp36), NULL), _tmp39);
					_tmp40 = NULL;
					vala_ccode_function_call_add_argument (base_register, (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("connection")));
					(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
					_tmp41 = NULL;
					vala_ccode_function_call_add_argument (base_register, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("path")));
					(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
					_tmp42 = NULL;
					vala_ccode_function_call_add_argument (base_register, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("object")));
					(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
					_tmp43 = NULL;
					vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp43 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) base_register)));
					(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
					(base_register == NULL) ? NULL : (base_register = (vala_ccode_node_unref (base_register), NULL));
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				(base_obj_type == NULL) ? NULL : (base_obj_type = (vala_code_node_unref (base_obj_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cfunc);
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
	(cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(get_path == NULL) ? NULL : (get_path = (vala_ccode_node_unref (get_path), NULL));
	(register_check == NULL) ? NULL : (register_check = (vala_ccode_node_unref (register_check), NULL));
	(register_block == NULL) ? NULL : (register_block = (vala_ccode_node_unref (register_block), NULL));
	(path_dup == NULL) ? NULL : (path_dup = (vala_ccode_node_unref (path_dup), NULL));
	(set_path == NULL) ? NULL : (set_path = (vala_ccode_node_unref (set_path), NULL));
	(cregister == NULL) ? NULL : (cregister = (vala_ccode_node_unref (cregister), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static void vala_dbus_server_module_generate_unregister_function (ValaDBusServerModule* self, ValaObjectType* object_type) {
	ValaObjectTypeSymbol* _tmp0;
	ValaObjectTypeSymbol* sym;
	char* _tmp3;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFunction* _tmp4;
	ValaCCodeFunction* cfunc;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFunction* _tmp7;
	ValaCCodeBlock* block;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_type != NULL);
	_tmp0 = NULL;
	sym = (_tmp0 = vala_object_type_get_type_symbol (object_type), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp4 = NULL;
	cfunc = (_tmp4 = vala_ccode_function_new (_tmp3 = g_strconcat (_tmp2 = g_strconcat ("_", _tmp1 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), NULL), "dbus_unregister", NULL), "void"), _tmp3 = (g_free (_tmp3), NULL), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp4);
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp5 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp6 = vala_ccode_formal_parameter_new ("user_data", "void*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp7 = vala_ccode_function_copy (cfunc)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	block = vala_ccode_block_new ();
	vala_ccode_function_set_block (cfunc, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cfunc);
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
	(cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
}


static void vala_dbus_server_module_handle_method (ValaDBusServerModule* self, const char* dbus_iface_name, const char* dbus_method_name, const char* handler_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	ValaCCodeConstant* _tmp6;
	char* _tmp5;
	ValaCCodeBlock* callblock;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeFunctionCall* _tmp8;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeExpressionStatement* _tmp14;
	ValaCCodeAssignment* _tmp13;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIfStatement* cif;
	ValaCCodeIfStatement* _tmp16;
	ValaCCodeIfStatement* _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_iface_name != NULL);
	g_return_if_fail (dbus_method_name != NULL);
	g_return_if_fail (handler_name != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (clastif != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccheck = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("dbus_message_is_method_call"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("message")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new (_tmp3 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp6 = vala_ccode_constant_new (_tmp5 = g_strdup_printf ("\"%s\"", dbus_method_name))));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp5 = (g_free (_tmp5), NULL);
	callblock = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (handler_name))), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("object")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("connection")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("message")));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	vala_ccode_block_add_statement (callblock, (ValaCCodeNode*) (_tmp14 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("reply")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) callblock, NULL);
	if ((*clastif) == NULL) {
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cif);
	} else {
		vala_ccode_if_statement_set_false_statement ((*clastif), (ValaCCodeStatement*) cif);
	}
	_tmp16 = NULL;
	_tmp15 = NULL;
	(*clastif) = (_tmp16 = (_tmp15 = cif, (_tmp15 == NULL) ? NULL : vala_ccode_node_ref (_tmp15)), ((*clastif) == NULL) ? NULL : ((*clastif) = (vala_ccode_node_unref ((*clastif)), NULL)), _tmp16);
	(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
	(callblock == NULL) ? NULL : (callblock = (vala_ccode_node_unref (callblock), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_dbus_server_module_handle_methods (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (dbus_iface_name != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (clastif != NULL);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _m_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_m_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_object_type_symbol_get_methods (sym))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			gboolean _tmp2;
			gboolean _tmp3;
			gboolean _tmp4;
			char* _tmp6;
			char* _tmp5;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			_tmp2 = FALSE;
			_tmp3 = FALSE;
			_tmp4 = FALSE;
			if (VALA_IS_CREATION_METHOD (m)) {
				_tmp4 = TRUE;
			} else {
				_tmp4 = vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE;
			}
			if (_tmp4) {
				_tmp3 = TRUE;
			} else {
				_tmp3 = vala_method_get_overrides (m);
			}
			if (_tmp3) {
				_tmp2 = TRUE;
			} else {
				_tmp2 = vala_symbol_get_access ((ValaSymbol*) m) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp2) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) m)) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_dbus_server_module_handle_method (self, dbus_iface_name, _tmp5 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m)), _tmp6 = vala_dbus_server_module_generate_dbus_wrapper (self, m, sym), block, &(*clastif));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
}


static char* vala_dbus_server_module_generate_dbus_property_get_wrapper (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeDeclaration* _tmp7;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeDeclaration* _tmp9;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeVariableDeclarator* _tmp11;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* message_signature;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* signature_check;
	ValaCCodeConstant* _tmp18;
	ValaCCodeBlock* signature_error_block;
	ValaCCodeReturnStatement* _tmp20;
	ValaCCodeConstant* _tmp19;
	ValaCCodeIfStatement* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeUnaryExpression* _tmp26;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeFunctionCall* _tmp29;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeAssignment* _tmp32;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeFunctionCall* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeUnaryExpression* _tmp38;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeExpressionStatement* _tmp39;
	ValaCCodeDeclaration* _tmp40;
	ValaCCodeVariableDeclarator* _tmp41;
	ValaCCodeIdentifier* target;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeExpression* _tmp43;
	ValaCCodeExpression* expr;
	ValaCCodeExpressionStatement* _tmp45;
	ValaCCodeAssignment* _tmp44;
	ValaCCodeDeclaration* _tmp46;
	ValaCCodeVariableDeclarator* _tmp47;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeExpression* _tmp50;
	ValaCCodeIdentifier* _tmp49;
	ValaCCodeExpressionStatement* _tmp52;
	ValaCCodeAssignment* _tmp51;
	ValaCCodeIfStatement* clastif;
	ValaCCodeFunction* _tmp104;
	char* _tmp105;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (dbus_iface_name != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s_property_get", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) sym, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	cdecl_ = NULL;
	function = vala_ccode_function_new (wrapper_name, "DBusMessage*");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) sym, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	_tmp7 = NULL;
	cdecl_ = (_tmp7 = vala_ccode_declaration_new ("DBusMessage*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp7);
	_tmp8 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp8 = vala_ccode_variable_declarator_new ("reply", NULL)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp9 = NULL;
	cdecl_ = (_tmp9 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("iter", NULL)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp11 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new ("reply_iter", NULL)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new ("subiter", NULL)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp13 = NULL;
	_tmp14 = NULL;
	message_signature = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("dbus_message_get_signature"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (message_signature, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("message")));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	_tmp17 = NULL;
	signature_check = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("strcmp"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) message_signature);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("\"ss\"")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	signature_error_block = vala_ccode_block_new ();
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_block_add_statement (signature_error_block, (ValaCCodeNode*) (_tmp20 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("NULL")))));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp21 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21 = vala_ccode_if_statement_new ((ValaCCodeExpression*) signature_check, (ValaCCodeStatement*) signature_error_block, NULL)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	_tmp23 = NULL;
	iter_call = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("dbus_message_iter_init"))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp23);
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("message")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp26 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("iter")))));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp27 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp27 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	_tmp29 = NULL;
	msgcall = (_tmp29 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("dbus_message_new_method_return"))), (_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)), _tmp29);
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("message")));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp33 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("reply")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	_tmp35 = NULL;
	_tmp34 = NULL;
	iter_call = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp35);
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("reply")));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp38 = NULL;
	_tmp37 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp38 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("reply_iter")))));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp39 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp39 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp40 = NULL;
	cdecl_ = (_tmp40 = vala_ccode_declaration_new ("char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp40);
	_tmp41 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp41 = vala_ccode_variable_declarator_new ("interface_name", NULL)));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
	target = vala_ccode_identifier_new ("interface_name");
	_tmp42 = NULL;
	_tmp43 = NULL;
	expr = (_tmp43 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)), _tmp43);
	_tmp45 = NULL;
	_tmp44 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp45 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	_tmp46 = NULL;
	cdecl_ = (_tmp46 = vala_ccode_declaration_new ("char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp46);
	_tmp47 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp47 = vala_ccode_variable_declarator_new ("property_name", NULL)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
	_tmp48 = NULL;
	target = (_tmp48 = vala_ccode_identifier_new ("property_name"), (target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL)), _tmp48);
	_tmp50 = NULL;
	_tmp49 = NULL;
	expr = (_tmp50 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp50);
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	_tmp52 = NULL;
	_tmp51 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp52 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp51 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	clastif = NULL;
	{
		GeeList* _tmp53;
		GeeIterator* _tmp54;
		GeeIterator* _prop_it;
		_tmp53 = NULL;
		_tmp54 = NULL;
		_prop_it = (_tmp54 = gee_iterable_iterator ((GeeIterable*) (_tmp53 = vala_object_type_symbol_get_properties (sym))), (_tmp53 == NULL) ? NULL : (_tmp53 = (gee_collection_object_unref (_tmp53), NULL)), _tmp54);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp55;
			gboolean _tmp56;
			ValaCCodeBlock* prop_block;
			ValaCCodeFragment* postfragment;
			ValaCCodeIdentifier* _tmp57;
			ValaCCodeFunctionCall* _tmp58;
			ValaCCodeFunctionCall* ccmp;
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeConstant* _tmp61;
			char* _tmp60;
			ValaCCodeConstant* _tmp62;
			ValaCCodeBinaryExpression* _tmp63;
			ValaCCodeBinaryExpression* ccheck1;
			ValaCCodeFunctionCall* _tmp65;
			ValaCCodeIdentifier* _tmp64;
			ValaCCodeIdentifier* _tmp66;
			ValaCCodeConstant* _tmp69;
			char* _tmp68;
			char* _tmp67;
			ValaCCodeConstant* _tmp70;
			ValaCCodeBinaryExpression* _tmp71;
			ValaCCodeBinaryExpression* ccheck2;
			ValaCCodeBinaryExpression* ccheck;
			ValaCCodeFunctionCall* _tmp73;
			ValaCCodeIdentifier* _tmp72;
			ValaCCodeUnaryExpression* _tmp75;
			ValaCCodeIdentifier* _tmp74;
			ValaCCodeIdentifier* _tmp76;
			ValaCCodeConstant* _tmp79;
			char* _tmp78;
			char* _tmp77;
			ValaCCodeUnaryExpression* _tmp81;
			ValaCCodeIdentifier* _tmp80;
			ValaCCodeExpressionStatement* _tmp82;
			ValaCCodeIdentifier* _tmp84;
			char* _tmp83;
			ValaCCodeFunctionCall* _tmp85;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp86;
			ValaCCodeIdentifier* _tmp87;
			ValaCCodeFunctionCall* _tmp89;
			ValaCCodeIdentifier* _tmp88;
			ValaCCodeUnaryExpression* _tmp91;
			ValaCCodeIdentifier* _tmp90;
			ValaCCodeUnaryExpression* _tmp93;
			ValaCCodeIdentifier* _tmp92;
			ValaCCodeExpressionStatement* _tmp94;
			ValaCCodeIfStatement* cif;
			ValaCCodeIfStatement* _tmp96;
			ValaCCodeIfStatement* _tmp95;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp55 = FALSE;
			_tmp56 = FALSE;
			if (vala_property_get_binding (prop) != MEMBER_BINDING_INSTANCE) {
				_tmp56 = TRUE;
			} else {
				_tmp56 = vala_property_get_overrides (prop);
			}
			if (_tmp56) {
				_tmp55 = TRUE;
			} else {
				_tmp55 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp55) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (vala_property_get_get_accessor (prop) == NULL) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			prop_block = vala_ccode_block_new ();
			postfragment = vala_ccode_fragment_new ();
			vala_ccode_block_add_statement (prop_block, (ValaCCodeNode*) postfragment);
			_tmp57 = NULL;
			_tmp58 = NULL;
			ccmp = (_tmp58 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("strcmp"))), (_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)), _tmp58);
			_tmp59 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("interface_name")));
			(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			_tmp61 = NULL;
			_tmp60 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp61 = vala_ccode_constant_new (_tmp60 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
			(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
			_tmp60 = (g_free (_tmp60), NULL);
			_tmp62 = NULL;
			_tmp63 = NULL;
			ccheck1 = (_tmp63 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ccmp, (ValaCCodeExpression*) (_tmp62 = vala_ccode_constant_new ("0"))), (_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)), _tmp63);
			_tmp65 = NULL;
			_tmp64 = NULL;
			ccmp = (_tmp65 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("strcmp"))), (ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL)), _tmp65);
			(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
			_tmp66 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new ("property_name")));
			(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
			_tmp69 = NULL;
			_tmp68 = NULL;
			_tmp67 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp69 = vala_ccode_constant_new (_tmp68 = g_strdup_printf ("\"%s\"", _tmp67 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) prop))))));
			(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
			_tmp68 = (g_free (_tmp68), NULL);
			_tmp67 = (g_free (_tmp67), NULL);
			_tmp70 = NULL;
			_tmp71 = NULL;
			ccheck2 = (_tmp71 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ccmp, (ValaCCodeExpression*) (_tmp70 = vala_ccode_constant_new ("0"))), (_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)), _tmp71);
			ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccheck1, (ValaCCodeExpression*) ccheck2);
			_tmp73 = NULL;
			_tmp72 = NULL;
			iter_call = (_tmp73 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp73);
			(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
			_tmp75 = NULL;
			_tmp74 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp75 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp74 = vala_ccode_identifier_new ("reply_iter")))));
			(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
			(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
			_tmp76 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp76 = vala_ccode_identifier_new ("DBUS_TYPE_VARIANT")));
			(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
			_tmp79 = NULL;
			_tmp78 = NULL;
			_tmp77 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp79 = vala_ccode_constant_new (_tmp78 = g_strdup_printf ("\"%s\"", _tmp77 = vala_data_type_get_type_signature (vala_property_get_property_type (prop))))));
			(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
			_tmp78 = (g_free (_tmp78), NULL);
			_tmp77 = (g_free (_tmp77), NULL);
			_tmp81 = NULL;
			_tmp80 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp81 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new ("subiter")))));
			(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
			(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
			_tmp82 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp82 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
			(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
			_tmp84 = NULL;
			_tmp83 = NULL;
			_tmp85 = NULL;
			ccall = (_tmp85 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new (_tmp83 = vala_property_accessor_get_cname (vala_property_get_get_accessor (prop))))), (_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL)), _tmp83 = (g_free (_tmp83), NULL), _tmp85);
			_tmp86 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp86 = vala_ccode_identifier_new ("self")));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			_tmp87 = NULL;
			vala_dbus_module_write_expression ((ValaDBusModule*) self, postfragment, vala_property_get_property_type (prop), (ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new ("subiter")), (ValaCCodeExpression*) ccall);
			(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
			_tmp89 = NULL;
			_tmp88 = NULL;
			iter_call = (_tmp89 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp88 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp89);
			(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
			_tmp91 = NULL;
			_tmp90 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp91 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new ("reply_iter")))));
			(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
			(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
			_tmp93 = NULL;
			_tmp92 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp93 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp92 = vala_ccode_identifier_new ("subiter")))));
			(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
			(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
			_tmp94 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp94 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
			(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
			cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) prop_block, NULL);
			if (clastif == NULL) {
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) cif);
			} else {
				vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) cif);
			}
			_tmp96 = NULL;
			_tmp95 = NULL;
			clastif = (_tmp96 = (_tmp95 = cif, (_tmp95 == NULL) ? NULL : vala_ccode_node_ref (_tmp95)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp96);
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(prop_block == NULL) ? NULL : (prop_block = (vala_ccode_node_unref (prop_block), NULL));
			(postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL));
			(ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL));
			(ccheck1 == NULL) ? NULL : (ccheck1 = (vala_ccode_node_unref (ccheck1), NULL));
			(ccheck2 == NULL) ? NULL : (ccheck2 = (vala_ccode_node_unref (ccheck2), NULL));
			(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	if (clastif == NULL) {
		ValaCCodeBlock* _tmp97;
		ValaCCodeReturnStatement* _tmp99;
		ValaCCodeConstant* _tmp98;
		_tmp97 = NULL;
		block = (_tmp97 = vala_ccode_block_new (), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp97);
		_tmp99 = NULL;
		_tmp98 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp99 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp98 = vala_ccode_constant_new ("NULL")))));
		(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
		(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
	} else {
		ValaCCodeBlock* else_block;
		ValaCCodeReturnStatement* _tmp101;
		ValaCCodeConstant* _tmp100;
		ValaCCodeReturnStatement* _tmp103;
		ValaCCodeIdentifier* _tmp102;
		else_block = vala_ccode_block_new ();
		_tmp101 = NULL;
		_tmp100 = NULL;
		vala_ccode_block_add_statement (else_block, (ValaCCodeNode*) (_tmp101 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp100 = vala_ccode_constant_new ("NULL")))));
		(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
		(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
		vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) else_block);
		_tmp103 = NULL;
		_tmp102 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp103 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new ("reply")))));
		(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
		(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
		(else_block == NULL) ? NULL : (else_block = (vala_ccode_node_unref (else_block), NULL));
	}
	_tmp104 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp104 = vala_ccode_function_copy (function)));
	(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp105 = NULL;
	return (_tmp105 = wrapper_name, (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (message_signature == NULL) ? NULL : (message_signature = (vala_ccode_node_unref (message_signature), NULL)), (signature_check == NULL) ? NULL : (signature_check = (vala_ccode_node_unref (signature_check), NULL)), (signature_error_block == NULL) ? NULL : (signature_error_block = (vala_ccode_node_unref (signature_error_block), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL)), (target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL)), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp105);
}


static char* vala_dbus_server_module_generate_dbus_property_get_all_wrapper (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	gboolean has_readable_properties;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp8;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeFormalParameter* _tmp9;
	ValaCCodeFormalParameter* _tmp10;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeDeclaration* _tmp13;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeVariableDeclarator* _tmp15;
	ValaCCodeVariableDeclarator* _tmp16;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* message_signature;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* signature_check;
	ValaCCodeConstant* _tmp24;
	ValaCCodeBlock* signature_error_block;
	ValaCCodeReturnStatement* _tmp26;
	ValaCCodeConstant* _tmp25;
	ValaCCodeIfStatement* _tmp27;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeFunctionCall* _tmp29;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeUnaryExpression* _tmp32;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeFunctionCall* _tmp35;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeExpressionStatement* _tmp39;
	ValaCCodeAssignment* _tmp38;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeFunctionCall* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeUnaryExpression* _tmp44;
	ValaCCodeIdentifier* _tmp43;
	ValaCCodeExpressionStatement* _tmp45;
	ValaCCodeDeclaration* _tmp46;
	ValaCCodeVariableDeclarator* _tmp47;
	ValaCCodeIdentifier* target;
	ValaCCodeIdentifier* _tmp48;
	ValaCCodeExpression* _tmp49;
	ValaCCodeExpression* expr;
	ValaCCodeExpressionStatement* _tmp51;
	ValaCCodeAssignment* _tmp50;
	ValaCCodeBlock* prop_block;
	ValaCCodeFunctionCall* _tmp55;
	ValaCCodeIdentifier* _tmp54;
	ValaCCodeUnaryExpression* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeIdentifier* _tmp58;
	ValaCCodeConstant* _tmp59;
	ValaCCodeUnaryExpression* _tmp61;
	ValaCCodeIdentifier* _tmp60;
	ValaCCodeExpressionStatement* _tmp62;
	ValaCCodeFunctionCall* _tmp121;
	ValaCCodeIdentifier* _tmp120;
	ValaCCodeUnaryExpression* _tmp123;
	ValaCCodeIdentifier* _tmp122;
	ValaCCodeUnaryExpression* _tmp125;
	ValaCCodeIdentifier* _tmp124;
	ValaCCodeExpressionStatement* _tmp126;
	ValaCCodeIdentifier* _tmp127;
	ValaCCodeFunctionCall* _tmp128;
	ValaCCodeFunctionCall* ccmp;
	ValaCCodeIdentifier* _tmp129;
	ValaCCodeConstant* _tmp131;
	char* _tmp130;
	ValaCCodeConstant* _tmp132;
	ValaCCodeBinaryExpression* _tmp133;
	ValaCCodeBinaryExpression* ccheck;
	ValaCCodeBlock* else_block;
	ValaCCodeReturnStatement* _tmp135;
	ValaCCodeConstant* _tmp134;
	ValaCCodeIfStatement* _tmp136;
	ValaCCodeReturnStatement* _tmp138;
	ValaCCodeIdentifier* _tmp137;
	ValaCCodeFunction* _tmp139;
	char* _tmp140;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (dbus_iface_name != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s_property_get_all", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) sym, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	has_readable_properties = FALSE;
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* _prop_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		_prop_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_object_type_symbol_get_properties (sym))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp4;
			gboolean _tmp5;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp4 = FALSE;
			_tmp5 = FALSE;
			if (vala_property_get_binding (prop) != MEMBER_BINDING_INSTANCE) {
				_tmp5 = TRUE;
			} else {
				_tmp5 = vala_property_get_overrides (prop);
			}
			if (_tmp5) {
				_tmp4 = TRUE;
			} else {
				_tmp4 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp4) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (vala_property_get_get_accessor (prop) != NULL) {
				has_readable_properties = TRUE;
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	cdecl_ = NULL;
	function = vala_ccode_function_new (wrapper_name, "DBusMessage*");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp8 = vala_ccode_formal_parameter_new ("self", _tmp7 = g_strconcat (_tmp6 = vala_typesymbol_get_cname ((ValaTypeSymbol*) sym, FALSE), "*", NULL)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp9 = NULL;
	vala_ccode_function_add_parameter (function, _tmp9 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_function_add_parameter (function, _tmp10 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ("DBusMessage*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new ("reply", NULL)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp13 = NULL;
	cdecl_ = (_tmp13 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp13);
	_tmp14 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new ("iter", NULL)));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp15 = vala_ccode_variable_declarator_new ("reply_iter", NULL)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp16 = vala_ccode_variable_declarator_new ("subiter", NULL)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	if (has_readable_properties) {
		ValaCCodeVariableDeclarator* _tmp17;
		ValaCCodeVariableDeclarator* _tmp18;
		_tmp17 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp17 = vala_ccode_variable_declarator_new ("entry_iter", NULL)));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		_tmp18 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp18 = vala_ccode_variable_declarator_new ("value_iter", NULL)));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	}
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp19 = NULL;
	_tmp20 = NULL;
	message_signature = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("dbus_message_get_signature"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (message_signature, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("message")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	_tmp23 = NULL;
	signature_check = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("strcmp"))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp23);
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) message_signature);
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) (_tmp24 = vala_ccode_constant_new ("\"s\"")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	signature_error_block = vala_ccode_block_new ();
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_block_add_statement (signature_error_block, (ValaCCodeNode*) (_tmp26 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_constant_new ("NULL")))));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp27 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp27 = vala_ccode_if_statement_new ((ValaCCodeExpression*) signature_check, (ValaCCodeStatement*) signature_error_block, NULL)));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	_tmp29 = NULL;
	iter_call = (_tmp29 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("dbus_message_iter_init"))), (_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)), _tmp29);
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("message")));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp32 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("iter")))));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	_tmp33 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp33 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp34 = NULL;
	_tmp35 = NULL;
	msgcall = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("dbus_message_new_method_return"))), (_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)), _tmp35);
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("message")));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp39 = NULL;
	_tmp38 = NULL;
	_tmp37 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp39 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp38 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("reply")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp41 = NULL;
	_tmp40 = NULL;
	iter_call = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp41);
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("reply")));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp44 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new ("reply_iter")))));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp45 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp45 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp46 = NULL;
	cdecl_ = (_tmp46 = vala_ccode_declaration_new ("char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp46);
	_tmp47 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp47 = vala_ccode_variable_declarator_new ("interface_name", NULL)));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
	target = vala_ccode_identifier_new ("interface_name");
	_tmp48 = NULL;
	_tmp49 = NULL;
	expr = (_tmp49 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
	_tmp51 = NULL;
	_tmp50 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp51 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp50 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	if (has_readable_properties) {
		ValaCCodeDeclaration* _tmp52;
		ValaCCodeVariableDeclarator* _tmp53;
		_tmp52 = NULL;
		cdecl_ = (_tmp52 = vala_ccode_declaration_new ("const char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp52);
		_tmp53 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp53 = vala_ccode_variable_declarator_new ("property_name", NULL)));
		(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
		vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
	}
	prop_block = vala_ccode_block_new ();
	_tmp55 = NULL;
	_tmp54 = NULL;
	iter_call = (_tmp55 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp55);
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	_tmp57 = NULL;
	_tmp56 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp57 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new ("reply_iter")))));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	_tmp58 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("DBUS_TYPE_ARRAY")));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	_tmp59 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp59 = vala_ccode_constant_new ("\"{sv}\"")));
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	_tmp61 = NULL;
	_tmp60 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp61 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new ("subiter")))));
	(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
	(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
	_tmp62 = NULL;
	vala_ccode_block_add_statement (prop_block, (ValaCCodeNode*) (_tmp62 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
	{
		GeeList* _tmp63;
		GeeIterator* _tmp64;
		GeeIterator* _prop_it;
		_tmp63 = NULL;
		_tmp64 = NULL;
		_prop_it = (_tmp64 = gee_iterable_iterator ((GeeIterable*) (_tmp63 = vala_object_type_symbol_get_properties (sym))), (_tmp63 == NULL) ? NULL : (_tmp63 = (gee_collection_object_unref (_tmp63), NULL)), _tmp64);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp65;
			gboolean _tmp66;
			ValaCCodeFragment* postfragment;
			ValaCCodeFunctionCall* _tmp68;
			ValaCCodeIdentifier* _tmp67;
			ValaCCodeUnaryExpression* _tmp70;
			ValaCCodeIdentifier* _tmp69;
			ValaCCodeIdentifier* _tmp71;
			ValaCCodeConstant* _tmp72;
			ValaCCodeUnaryExpression* _tmp74;
			ValaCCodeIdentifier* _tmp73;
			ValaCCodeExpressionStatement* _tmp75;
			ValaCCodeExpressionStatement* _tmp81;
			ValaCCodeAssignment* _tmp80;
			ValaCCodeConstant* _tmp79;
			char* _tmp78;
			char* _tmp77;
			ValaCCodeIdentifier* _tmp76;
			ValaCCodeFunctionCall* _tmp83;
			ValaCCodeIdentifier* _tmp82;
			ValaCCodeUnaryExpression* _tmp85;
			ValaCCodeIdentifier* _tmp84;
			ValaCCodeIdentifier* _tmp86;
			ValaCCodeUnaryExpression* _tmp88;
			ValaCCodeIdentifier* _tmp87;
			ValaCCodeExpressionStatement* _tmp89;
			ValaCCodeFunctionCall* _tmp91;
			ValaCCodeIdentifier* _tmp90;
			ValaCCodeUnaryExpression* _tmp93;
			ValaCCodeIdentifier* _tmp92;
			ValaCCodeIdentifier* _tmp94;
			ValaCCodeConstant* _tmp97;
			char* _tmp96;
			char* _tmp95;
			ValaCCodeUnaryExpression* _tmp99;
			ValaCCodeIdentifier* _tmp98;
			ValaCCodeExpressionStatement* _tmp100;
			ValaCCodeIdentifier* _tmp102;
			char* _tmp101;
			ValaCCodeFunctionCall* _tmp103;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp104;
			ValaCCodeIdentifier* _tmp105;
			ValaCCodeFunctionCall* _tmp107;
			ValaCCodeIdentifier* _tmp106;
			ValaCCodeUnaryExpression* _tmp109;
			ValaCCodeIdentifier* _tmp108;
			ValaCCodeUnaryExpression* _tmp111;
			ValaCCodeIdentifier* _tmp110;
			ValaCCodeExpressionStatement* _tmp112;
			ValaCCodeFunctionCall* _tmp114;
			ValaCCodeIdentifier* _tmp113;
			ValaCCodeUnaryExpression* _tmp116;
			ValaCCodeIdentifier* _tmp115;
			ValaCCodeUnaryExpression* _tmp118;
			ValaCCodeIdentifier* _tmp117;
			ValaCCodeExpressionStatement* _tmp119;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp65 = FALSE;
			_tmp66 = FALSE;
			if (vala_property_get_binding (prop) != MEMBER_BINDING_INSTANCE) {
				_tmp66 = TRUE;
			} else {
				_tmp66 = vala_property_get_overrides (prop);
			}
			if (_tmp66) {
				_tmp65 = TRUE;
			} else {
				_tmp65 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp65) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (vala_property_get_get_accessor (prop) == NULL) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			postfragment = vala_ccode_fragment_new ();
			vala_ccode_block_add_statement (prop_block, (ValaCCodeNode*) postfragment);
			_tmp68 = NULL;
			_tmp67 = NULL;
			iter_call = (_tmp68 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp68);
			(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
			_tmp70 = NULL;
			_tmp69 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp70 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp69 = vala_ccode_identifier_new ("subiter")))));
			(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
			(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
			_tmp71 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp71 = vala_ccode_identifier_new ("DBUS_TYPE_DICT_ENTRY")));
			(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
			_tmp72 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp72 = vala_ccode_constant_new ("NULL")));
			(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
			_tmp74 = NULL;
			_tmp73 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp74 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new ("entry_iter")))));
			(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
			(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
			_tmp75 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp75 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
			(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp79 = NULL;
			_tmp78 = NULL;
			_tmp77 = NULL;
			_tmp76 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp81 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp80 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp76 = vala_ccode_identifier_new ("property_name")), (ValaCCodeExpression*) (_tmp79 = vala_ccode_constant_new (_tmp78 = g_strdup_printf ("\"%s\"", _tmp77 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) prop))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
			(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
			(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
			_tmp78 = (g_free (_tmp78), NULL);
			_tmp77 = (g_free (_tmp77), NULL);
			(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
			_tmp83 = NULL;
			_tmp82 = NULL;
			iter_call = (_tmp83 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new ("dbus_message_iter_append_basic"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp83);
			(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
			_tmp85 = NULL;
			_tmp84 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp85 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new ("entry_iter")))));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
			(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
			_tmp86 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp86 = vala_ccode_identifier_new ("DBUS_TYPE_STRING")));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			_tmp88 = NULL;
			_tmp87 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp88 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new ("property_name")))));
			(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
			(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
			_tmp89 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp89 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
			(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
			_tmp91 = NULL;
			_tmp90 = NULL;
			iter_call = (_tmp91 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp91);
			(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
			_tmp93 = NULL;
			_tmp92 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp93 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp92 = vala_ccode_identifier_new ("entry_iter")))));
			(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
			(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
			_tmp94 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("DBUS_TYPE_VARIANT")));
			(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
			_tmp97 = NULL;
			_tmp96 = NULL;
			_tmp95 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp97 = vala_ccode_constant_new (_tmp96 = g_strdup_printf ("\"%s\"", _tmp95 = vala_data_type_get_type_signature (vala_property_get_property_type (prop))))));
			(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
			_tmp96 = (g_free (_tmp96), NULL);
			_tmp95 = (g_free (_tmp95), NULL);
			_tmp99 = NULL;
			_tmp98 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp99 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp98 = vala_ccode_identifier_new ("value_iter")))));
			(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
			(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
			_tmp100 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp100 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
			(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
			_tmp102 = NULL;
			_tmp101 = NULL;
			_tmp103 = NULL;
			ccall = (_tmp103 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new (_tmp101 = vala_property_accessor_get_cname (vala_property_get_get_accessor (prop))))), (_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)), _tmp101 = (g_free (_tmp101), NULL), _tmp103);
			_tmp104 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp104 = vala_ccode_identifier_new ("self")));
			(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
			_tmp105 = NULL;
			vala_dbus_module_write_expression ((ValaDBusModule*) self, postfragment, vala_property_get_property_type (prop), (ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new ("value_iter")), (ValaCCodeExpression*) ccall);
			(_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL));
			_tmp107 = NULL;
			_tmp106 = NULL;
			iter_call = (_tmp107 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp106 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp107);
			(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
			_tmp109 = NULL;
			_tmp108 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp109 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp108 = vala_ccode_identifier_new ("entry_iter")))));
			(_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL));
			(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
			_tmp111 = NULL;
			_tmp110 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp111 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp110 = vala_ccode_identifier_new ("value_iter")))));
			(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
			(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
			_tmp112 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp112 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
			(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
			_tmp114 = NULL;
			_tmp113 = NULL;
			iter_call = (_tmp114 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp113 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp114);
			(_tmp113 == NULL) ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL));
			_tmp116 = NULL;
			_tmp115 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp116 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp115 = vala_ccode_identifier_new ("subiter")))));
			(_tmp116 == NULL) ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL));
			(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
			_tmp118 = NULL;
			_tmp117 = NULL;
			vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp118 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp117 = vala_ccode_identifier_new ("entry_iter")))));
			(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
			(_tmp117 == NULL) ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL));
			_tmp119 = NULL;
			vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp119 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
			(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	_tmp121 = NULL;
	_tmp120 = NULL;
	iter_call = (_tmp121 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp120 = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp121);
	(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
	_tmp123 = NULL;
	_tmp122 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp123 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp122 = vala_ccode_identifier_new ("reply_iter")))));
	(_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL));
	(_tmp122 == NULL) ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL));
	_tmp125 = NULL;
	_tmp124 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp125 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp124 = vala_ccode_identifier_new ("subiter")))));
	(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
	(_tmp124 == NULL) ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL));
	_tmp126 = NULL;
	vala_ccode_block_add_statement (prop_block, (ValaCCodeNode*) (_tmp126 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp126 == NULL) ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL));
	_tmp127 = NULL;
	_tmp128 = NULL;
	ccmp = (_tmp128 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp127 = vala_ccode_identifier_new ("strcmp"))), (_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL)), _tmp128);
	_tmp129 = NULL;
	vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp129 = vala_ccode_identifier_new ("interface_name")));
	(_tmp129 == NULL) ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL));
	_tmp131 = NULL;
	_tmp130 = NULL;
	vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp131 = vala_ccode_constant_new (_tmp130 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp131 == NULL) ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL));
	_tmp130 = (g_free (_tmp130), NULL);
	_tmp132 = NULL;
	_tmp133 = NULL;
	ccheck = (_tmp133 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ccmp, (ValaCCodeExpression*) (_tmp132 = vala_ccode_constant_new ("0"))), (_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL)), _tmp133);
	else_block = vala_ccode_block_new ();
	_tmp135 = NULL;
	_tmp134 = NULL;
	vala_ccode_block_add_statement (else_block, (ValaCCodeNode*) (_tmp135 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp134 = vala_ccode_constant_new ("NULL")))));
	(_tmp135 == NULL) ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL));
	(_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL));
	_tmp136 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp136 = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) prop_block, (ValaCCodeStatement*) else_block)));
	(_tmp136 == NULL) ? NULL : (_tmp136 = (vala_ccode_node_unref (_tmp136), NULL));
	_tmp138 = NULL;
	_tmp137 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp138 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp137 = vala_ccode_identifier_new ("reply")))));
	(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
	(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
	_tmp139 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp139 = vala_ccode_function_copy (function)));
	(_tmp139 == NULL) ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp140 = NULL;
	return (_tmp140 = wrapper_name, (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (message_signature == NULL) ? NULL : (message_signature = (vala_ccode_node_unref (message_signature), NULL)), (signature_check == NULL) ? NULL : (signature_check = (vala_ccode_node_unref (signature_check), NULL)), (signature_error_block == NULL) ? NULL : (signature_error_block = (vala_ccode_node_unref (signature_error_block), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL)), (target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL)), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), (prop_block == NULL) ? NULL : (prop_block = (vala_ccode_node_unref (prop_block), NULL)), (ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL)), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), (else_block == NULL) ? NULL : (else_block = (vala_ccode_node_unref (else_block), NULL)), _tmp140);
}


static char* vala_dbus_server_module_generate_dbus_property_set_wrapper (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, const char* dbus_iface_name) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeVariableDeclarator* _tmp9;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* message_signature;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeFunctionCall* signature_check;
	ValaCCodeConstant* _tmp16;
	ValaCCodeBlock* signature_error_block;
	ValaCCodeReturnStatement* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIfStatement* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeUnaryExpression* _tmp24;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeExpressionStatement* _tmp31;
	ValaCCodeAssignment* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeDeclaration* _tmp32;
	ValaCCodeVariableDeclarator* _tmp33;
	ValaCCodeIdentifier* target;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeExpression* _tmp35;
	ValaCCodeExpression* expr;
	ValaCCodeExpressionStatement* _tmp37;
	ValaCCodeAssignment* _tmp36;
	ValaCCodeDeclaration* _tmp38;
	ValaCCodeVariableDeclarator* _tmp39;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeExpression* _tmp42;
	ValaCCodeIdentifier* _tmp41;
	ValaCCodeExpressionStatement* _tmp44;
	ValaCCodeAssignment* _tmp43;
	ValaCCodeFunctionCall* _tmp46;
	ValaCCodeIdentifier* _tmp45;
	ValaCCodeUnaryExpression* _tmp48;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeUnaryExpression* _tmp50;
	ValaCCodeIdentifier* _tmp49;
	ValaCCodeExpressionStatement* _tmp51;
	ValaCCodeIfStatement* clastif;
	ValaCCodeFunction* _tmp95;
	char* _tmp96;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (dbus_iface_name != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s_property_set", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) sym, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	function = vala_ccode_function_new (wrapper_name, "DBusMessage*");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) sym, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	cdecl_ = vala_ccode_declaration_new ("DBusMessage*");
	_tmp7 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new ("reply", NULL)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp8 = NULL;
	cdecl_ = (_tmp8 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new ("iter", NULL)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("subiter", NULL)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp11 = NULL;
	_tmp12 = NULL;
	message_signature = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("dbus_message_get_signature"))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp12);
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (message_signature, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("message")));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp14 = NULL;
	_tmp15 = NULL;
	signature_check = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("strcmp"))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp15);
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) message_signature);
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) (_tmp16 = vala_ccode_constant_new ("\"ssv\"")));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	signature_error_block = vala_ccode_block_new ();
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_block_add_statement (signature_error_block, (ValaCCodeNode*) (_tmp18 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new ("NULL")))));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp19 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp19 = vala_ccode_if_statement_new ((ValaCCodeExpression*) signature_check, (ValaCCodeStatement*) signature_error_block, NULL)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = NULL;
	_tmp21 = NULL;
	iter_call = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("dbus_message_iter_init"))), (_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("message")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp24 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("iter")))));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp25 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp25 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp26 = NULL;
	_tmp27 = NULL;
	msgcall = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("dbus_message_new_method_return"))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), _tmp27);
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("message")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp31 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("reply")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp32 = NULL;
	cdecl_ = (_tmp32 = vala_ccode_declaration_new ("char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp32);
	_tmp33 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp33 = vala_ccode_variable_declarator_new ("interface_name", NULL)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
	target = vala_ccode_identifier_new ("interface_name");
	_tmp34 = NULL;
	_tmp35 = NULL;
	expr = (_tmp35 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)), _tmp35);
	_tmp37 = NULL;
	_tmp36 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp37 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp36 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp38 = NULL;
	cdecl_ = (_tmp38 = vala_ccode_declaration_new ("char*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp38);
	_tmp39 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp39 = vala_ccode_variable_declarator_new ("property_name", NULL)));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
	_tmp40 = NULL;
	target = (_tmp40 = vala_ccode_identifier_new ("property_name"), (target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL)), _tmp40);
	_tmp42 = NULL;
	_tmp41 = NULL;
	expr = (_tmp42 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp42);
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp44 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp43 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp46 = NULL;
	_tmp45 = NULL;
	iter_call = (_tmp46 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp46);
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp48 = NULL;
	_tmp47 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp48 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new ("iter")))));
	(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	_tmp50 = NULL;
	_tmp49 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp50 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new ("subiter")))));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	_tmp51 = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp51 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	clastif = NULL;
	{
		GeeList* _tmp52;
		GeeIterator* _tmp53;
		GeeIterator* _prop_it;
		_tmp52 = NULL;
		_tmp53 = NULL;
		_prop_it = (_tmp53 = gee_iterable_iterator ((GeeIterable*) (_tmp52 = vala_object_type_symbol_get_properties (sym))), (_tmp52 == NULL) ? NULL : (_tmp52 = (gee_collection_object_unref (_tmp52), NULL)), _tmp53);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp54;
			gboolean _tmp55;
			ValaCCodeBlock* prop_block;
			ValaCCodeFragment* _tmp56;
			ValaCCodeIdentifier* _tmp57;
			ValaCCodeFunctionCall* _tmp58;
			ValaCCodeFunctionCall* ccmp;
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeConstant* _tmp61;
			char* _tmp60;
			ValaCCodeConstant* _tmp62;
			ValaCCodeBinaryExpression* _tmp63;
			ValaCCodeBinaryExpression* ccheck1;
			ValaCCodeFunctionCall* _tmp65;
			ValaCCodeIdentifier* _tmp64;
			ValaCCodeIdentifier* _tmp66;
			ValaCCodeConstant* _tmp69;
			char* _tmp68;
			char* _tmp67;
			ValaCCodeConstant* _tmp70;
			ValaCCodeBinaryExpression* _tmp71;
			ValaCCodeBinaryExpression* ccheck2;
			ValaCCodeBinaryExpression* ccheck;
			ValaCCodeDeclaration* _tmp73;
			char* _tmp72;
			ValaCCodeVariableDeclarator* _tmp74;
			ValaCCodeIdentifier* _tmp75;
			ValaCCodeExpression* _tmp77;
			ValaCCodeIdentifier* _tmp76;
			ValaCCodeExpressionStatement* _tmp79;
			ValaCCodeAssignment* _tmp78;
			ValaCCodeIdentifier* _tmp81;
			char* _tmp80;
			ValaCCodeFunctionCall* _tmp82;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp83;
			ValaCCodeIdentifier* _tmp84;
			ValaCCodeExpressionStatement* _tmp85;
			ValaCCodeIfStatement* cif;
			ValaCCodeIfStatement* _tmp87;
			ValaCCodeIfStatement* _tmp86;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp54 = FALSE;
			_tmp55 = FALSE;
			if (vala_property_get_binding (prop) != MEMBER_BINDING_INSTANCE) {
				_tmp55 = TRUE;
			} else {
				_tmp55 = vala_property_get_overrides (prop);
			}
			if (_tmp55) {
				_tmp54 = TRUE;
			} else {
				_tmp54 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp54) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (vala_property_get_set_accessor (prop) == NULL) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			prop_block = vala_ccode_block_new ();
			_tmp56 = NULL;
			prefragment = (_tmp56 = vala_ccode_fragment_new (), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), _tmp56);
			vala_ccode_block_add_statement (prop_block, (ValaCCodeNode*) prefragment);
			_tmp57 = NULL;
			_tmp58 = NULL;
			ccmp = (_tmp58 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new ("strcmp"))), (_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)), _tmp58);
			_tmp59 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new ("interface_name")));
			(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			_tmp61 = NULL;
			_tmp60 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp61 = vala_ccode_constant_new (_tmp60 = g_strdup_printf ("\"%s\"", dbus_iface_name))));
			(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
			_tmp60 = (g_free (_tmp60), NULL);
			_tmp62 = NULL;
			_tmp63 = NULL;
			ccheck1 = (_tmp63 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ccmp, (ValaCCodeExpression*) (_tmp62 = vala_ccode_constant_new ("0"))), (_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)), _tmp63);
			_tmp65 = NULL;
			_tmp64 = NULL;
			ccmp = (_tmp65 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("strcmp"))), (ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL)), _tmp65);
			(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
			_tmp66 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new ("property_name")));
			(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
			_tmp69 = NULL;
			_tmp68 = NULL;
			_tmp67 = NULL;
			vala_ccode_function_call_add_argument (ccmp, (ValaCCodeExpression*) (_tmp69 = vala_ccode_constant_new (_tmp68 = g_strdup_printf ("\"%s\"", _tmp67 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) prop))))));
			(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
			_tmp68 = (g_free (_tmp68), NULL);
			_tmp67 = (g_free (_tmp67), NULL);
			_tmp70 = NULL;
			_tmp71 = NULL;
			ccheck2 = (_tmp71 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) ccmp, (ValaCCodeExpression*) (_tmp70 = vala_ccode_constant_new ("0"))), (_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)), _tmp71);
			ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccheck1, (ValaCCodeExpression*) ccheck2);
			_tmp73 = NULL;
			_tmp72 = NULL;
			cdecl_ = (_tmp73 = vala_ccode_declaration_new (_tmp72 = vala_data_type_get_cname (vala_property_get_property_type (prop))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp73);
			_tmp72 = (g_free (_tmp72), NULL);
			_tmp74 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp74 = vala_ccode_variable_declarator_new ("value", NULL)));
			(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
			vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) cdecl_);
			_tmp75 = NULL;
			target = (_tmp75 = vala_ccode_identifier_new ("value"), (target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL)), _tmp75);
			_tmp77 = NULL;
			_tmp76 = NULL;
			expr = (_tmp77 = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, vala_property_get_property_type (prop), (ValaCCodeExpression*) (_tmp76 = vala_ccode_identifier_new ("subiter")), (ValaCCodeExpression*) target), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp77);
			(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
			_tmp79 = NULL;
			_tmp78 = NULL;
			vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp79 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp78 = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
			(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp82 = NULL;
			ccall = (_tmp82 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_identifier_new (_tmp80 = vala_property_accessor_get_cname (vala_property_get_set_accessor (prop))))), (_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)), _tmp80 = (g_free (_tmp80), NULL), _tmp82);
			_tmp83 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp83 = vala_ccode_identifier_new ("self")));
			(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
			_tmp84 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new ("value")));
			(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
			_tmp85 = NULL;
			vala_ccode_block_add_statement (prop_block, (ValaCCodeNode*) (_tmp85 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
			cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) prop_block, NULL);
			if (clastif == NULL) {
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) cif);
			} else {
				vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) cif);
			}
			_tmp87 = NULL;
			_tmp86 = NULL;
			clastif = (_tmp87 = (_tmp86 = cif, (_tmp86 == NULL) ? NULL : vala_ccode_node_ref (_tmp86)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp87);
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(prop_block == NULL) ? NULL : (prop_block = (vala_ccode_node_unref (prop_block), NULL));
			(ccmp == NULL) ? NULL : (ccmp = (vala_ccode_node_unref (ccmp), NULL));
			(ccheck1 == NULL) ? NULL : (ccheck1 = (vala_ccode_node_unref (ccheck1), NULL));
			(ccheck2 == NULL) ? NULL : (ccheck2 = (vala_ccode_node_unref (ccheck2), NULL));
			(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	if (clastif == NULL) {
		ValaCCodeBlock* _tmp88;
		ValaCCodeReturnStatement* _tmp90;
		ValaCCodeConstant* _tmp89;
		_tmp88 = NULL;
		block = (_tmp88 = vala_ccode_block_new (), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp88);
		_tmp90 = NULL;
		_tmp89 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp90 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp89 = vala_ccode_constant_new ("NULL")))));
		(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
		(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
	} else {
		ValaCCodeBlock* else_block;
		ValaCCodeReturnStatement* _tmp92;
		ValaCCodeConstant* _tmp91;
		ValaCCodeReturnStatement* _tmp94;
		ValaCCodeIdentifier* _tmp93;
		else_block = vala_ccode_block_new ();
		_tmp92 = NULL;
		_tmp91 = NULL;
		vala_ccode_block_add_statement (else_block, (ValaCCodeNode*) (_tmp92 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp91 = vala_ccode_constant_new ("NULL")))));
		(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
		(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
		vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) else_block);
		_tmp94 = NULL;
		_tmp93 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp94 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new ("reply")))));
		(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
		(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
		(else_block == NULL) ? NULL : (else_block = (vala_ccode_node_unref (else_block), NULL));
	}
	_tmp95 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp95 = vala_ccode_function_copy (function)));
	(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp96 = NULL;
	return (_tmp96 = wrapper_name, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (message_signature == NULL) ? NULL : (message_signature = (vala_ccode_node_unref (message_signature), NULL)), (signature_check == NULL) ? NULL : (signature_check = (vala_ccode_node_unref (signature_check), NULL)), (signature_error_block == NULL) ? NULL : (signature_error_block = (vala_ccode_node_unref (signature_error_block), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), (msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL)), (target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL)), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp96);
}


static char* vala_dbus_server_module_get_dbus_type_introspection (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym) {
	char* result;
	ValaClass* _tmp1;
	ValaObjectTypeSymbol* _tmp0;
	ValaClass* cl;
	ValaAttribute* dbus;
	char* dbus_iface_name;
	char* _tmp11;
	char* _tmp10;
	char* _tmp55;
	char* _tmp56;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	result = g_strdup ("");
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = sym, VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (cl != NULL) {
		{
			GeeList* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* _base_type_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_base_type_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_class_get_base_types (cl))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				ValaObjectType* _tmp5;
				ValaDataType* _tmp4;
				ValaObjectType* base_obj_type;
				char* _tmp7;
				char* _tmp6;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				_tmp5 = NULL;
				_tmp4 = NULL;
				base_obj_type = (_tmp5 = (_tmp4 = base_type, VALA_IS_OBJECT_TYPE (_tmp4) ? ((ValaObjectType*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				_tmp7 = NULL;
				_tmp6 = NULL;
				result = (_tmp7 = g_strconcat (result, _tmp6 = vala_dbus_server_module_get_dbus_type_introspection (self, vala_object_type_get_type_symbol (base_obj_type)), NULL), result = (g_free (result), NULL), _tmp7);
				_tmp6 = (g_free (_tmp6), NULL);
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				(base_obj_type == NULL) ? NULL : (base_obj_type = (vala_code_node_unref (base_obj_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	}
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) sym, "DBus");
	if (dbus == NULL) {
		char* _tmp8;
		_tmp8 = NULL;
		return (_tmp8 = result, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), _tmp8);
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		char* _tmp9;
		_tmp9 = NULL;
		return (_tmp9 = result, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), dbus_iface_name = (g_free (dbus_iface_name), NULL), _tmp9);
	}
	_tmp11 = NULL;
	_tmp10 = NULL;
	result = (_tmp11 = g_strconcat (result, _tmp10 = g_strdup_printf ("<interface name=\"%s\">\n", dbus_iface_name), NULL), result = (g_free (result), NULL), _tmp11);
	_tmp10 = (g_free (_tmp10), NULL);
	{
		GeeList* _tmp12;
		GeeIterator* _tmp13;
		GeeIterator* _m_it;
		_tmp12 = NULL;
		_tmp13 = NULL;
		_m_it = (_tmp13 = gee_iterable_iterator ((GeeIterable*) (_tmp12 = vala_object_type_symbol_get_methods (sym))), (_tmp12 == NULL) ? NULL : (_tmp12 = (gee_collection_object_unref (_tmp12), NULL)), _tmp13);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			gboolean _tmp14;
			gboolean _tmp15;
			gboolean _tmp16;
			char* _tmp19;
			char* _tmp18;
			char* _tmp17;
			char* _tmp33;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			_tmp14 = FALSE;
			_tmp15 = FALSE;
			_tmp16 = FALSE;
			if (VALA_IS_CREATION_METHOD (m)) {
				_tmp16 = TRUE;
			} else {
				_tmp16 = vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE;
			}
			if (_tmp16) {
				_tmp15 = TRUE;
			} else {
				_tmp15 = vala_method_get_overrides (m);
			}
			if (_tmp15) {
				_tmp14 = TRUE;
			} else {
				_tmp14 = vala_symbol_get_access ((ValaSymbol*) m) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp14) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) m)) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			_tmp19 = NULL;
			_tmp18 = NULL;
			_tmp17 = NULL;
			result = (_tmp19 = g_strconcat (result, _tmp18 = g_strdup_printf ("  <method name=\"%s\">\n", _tmp17 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m))), NULL), result = (g_free (result), NULL), _tmp19);
			_tmp18 = (g_free (_tmp18), NULL);
			_tmp17 = (g_free (_tmp17), NULL);
			{
				GeeList* _tmp20;
				GeeIterator* _tmp21;
				GeeIterator* _param_it;
				_tmp20 = NULL;
				_tmp21 = NULL;
				_param_it = (_tmp21 = gee_iterable_iterator ((GeeIterable*) (_tmp20 = vala_method_get_parameters (m))), (_tmp20 == NULL) ? NULL : (_tmp20 = (gee_collection_object_unref (_tmp20), NULL)), _tmp21);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					gboolean _tmp22;
					const char* _tmp24;
					const char* _tmp25;
					char* direction;
					char* _tmp28;
					char* _tmp27;
					char* _tmp26;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					_tmp22 = FALSE;
					if (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)) != NULL) {
						char* _tmp23;
						_tmp23 = NULL;
						_tmp22 = _vala_strcmp0 (_tmp23 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), "DBus.BusName") == 0;
						_tmp23 = (g_free (_tmp23), NULL);
					} else {
						_tmp22 = FALSE;
					}
					if (_tmp22) {
						/* skip sender parameter
						 (implicit in D-Bus)*/
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						continue;
					}
					_tmp24 = NULL;
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						_tmp24 = "in";
					} else {
						_tmp24 = "out";
					}
					_tmp25 = NULL;
					direction = (_tmp25 = _tmp24, (_tmp25 == NULL) ? NULL : g_strdup (_tmp25));
					_tmp28 = NULL;
					_tmp27 = NULL;
					_tmp26 = NULL;
					result = (_tmp28 = g_strconcat (result, _tmp27 = g_strdup_printf ("    <arg name=\"%s\" type=\"%s\" direction=\"%s\"/>\n", vala_symbol_get_name ((ValaSymbol*) param), _tmp26 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param)), direction), NULL), result = (g_free (result), NULL), _tmp28);
					_tmp27 = (g_free (_tmp27), NULL);
					_tmp26 = (g_free (_tmp26), NULL);
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					direction = (g_free (direction), NULL);
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
				char* _tmp32;
				char* _tmp31;
				char* _tmp30;
				char* _tmp29;
				_tmp32 = NULL;
				_tmp31 = NULL;
				_tmp30 = NULL;
				_tmp29 = NULL;
				result = (_tmp32 = g_strconcat (result, _tmp31 = g_strdup_printf ("    <arg name=\"%s\" type=\"%s\" direction=\"out\"/>\n", _tmp29 = vala_dbus_server_module_dbus_result_name (self, m), _tmp30 = vala_data_type_get_type_signature (vala_method_get_return_type (m))), NULL), result = (g_free (result), NULL), _tmp32);
				_tmp31 = (g_free (_tmp31), NULL);
				_tmp30 = (g_free (_tmp30), NULL);
				_tmp29 = (g_free (_tmp29), NULL);
			}
			_tmp33 = NULL;
			result = (_tmp33 = g_strconcat (result, "  </method>\n", NULL), result = (g_free (result), NULL), _tmp33);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeList* _tmp34;
		GeeIterator* _tmp35;
		GeeIterator* _prop_it;
		_tmp34 = NULL;
		_tmp35 = NULL;
		_prop_it = (_tmp35 = gee_iterable_iterator ((GeeIterable*) (_tmp34 = vala_object_type_symbol_get_properties (sym))), (_tmp34 == NULL) ? NULL : (_tmp34 = (gee_collection_object_unref (_tmp34), NULL)), _tmp35);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp36;
			gboolean _tmp37;
			const char* _tmp38;
			const char* _tmp39;
			char* access;
			char* _tmp43;
			char* _tmp42;
			char* _tmp41;
			char* _tmp40;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp36 = FALSE;
			_tmp37 = FALSE;
			if (vala_property_get_binding (prop) != MEMBER_BINDING_INSTANCE) {
				_tmp37 = TRUE;
			} else {
				_tmp37 = vala_property_get_overrides (prop);
			}
			if (_tmp37) {
				_tmp36 = TRUE;
			} else {
				_tmp36 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp36) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp38 = NULL;
			if (vala_property_get_get_accessor (prop) != NULL) {
				_tmp38 = "read";
			} else {
				_tmp38 = "";
			}
			_tmp39 = NULL;
			if (vala_property_get_set_accessor (prop) != NULL) {
				_tmp39 = "write";
			} else {
				_tmp39 = "";
			}
			access = g_strconcat (_tmp38, _tmp39, NULL);
			_tmp43 = NULL;
			_tmp42 = NULL;
			_tmp41 = NULL;
			_tmp40 = NULL;
			result = (_tmp43 = g_strconcat (result, _tmp42 = g_strdup_printf ("  <property name=\"%s\" type=\"%s\" access=\"%s\"/>\n", _tmp40 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) prop)), _tmp41 = vala_data_type_get_type_signature (vala_property_get_property_type (prop)), access), NULL), result = (g_free (result), NULL), _tmp43);
			_tmp42 = (g_free (_tmp42), NULL);
			_tmp41 = (g_free (_tmp41), NULL);
			_tmp40 = (g_free (_tmp40), NULL);
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			access = (g_free (access), NULL);
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	{
		GeeList* _tmp44;
		GeeIterator* _tmp45;
		GeeIterator* _sig_it;
		_tmp44 = NULL;
		_tmp45 = NULL;
		_sig_it = (_tmp45 = gee_iterable_iterator ((GeeIterable*) (_tmp44 = vala_object_type_symbol_get_signals (sym))), (_tmp44 == NULL) ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL)), _tmp45);
		while (gee_iterator_next (_sig_it)) {
			ValaSignal* sig;
			char* _tmp48;
			char* _tmp47;
			char* _tmp46;
			char* _tmp54;
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			if (vala_symbol_get_access ((ValaSymbol*) sig) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) sig)) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			_tmp48 = NULL;
			_tmp47 = NULL;
			_tmp46 = NULL;
			result = (_tmp48 = g_strconcat (result, _tmp47 = g_strdup_printf ("  <signal name=\"%s\">\n", _tmp46 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) sig))), NULL), result = (g_free (result), NULL), _tmp48);
			_tmp47 = (g_free (_tmp47), NULL);
			_tmp46 = (g_free (_tmp46), NULL);
			{
				GeeList* _tmp49;
				GeeIterator* _tmp50;
				GeeIterator* _param_it;
				_tmp49 = NULL;
				_tmp50 = NULL;
				_param_it = (_tmp50 = gee_iterable_iterator ((GeeIterable*) (_tmp49 = vala_signal_get_parameters (sig))), (_tmp49 == NULL) ? NULL : (_tmp49 = (gee_collection_object_unref (_tmp49), NULL)), _tmp50);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					char* _tmp53;
					char* _tmp52;
					char* _tmp51;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					_tmp53 = NULL;
					_tmp52 = NULL;
					_tmp51 = NULL;
					result = (_tmp53 = g_strconcat (result, _tmp52 = g_strdup_printf ("    <arg name=\"%s\" type=\"%s\"/>\n", vala_symbol_get_name ((ValaSymbol*) param), _tmp51 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), NULL), result = (g_free (result), NULL), _tmp53);
					_tmp52 = (g_free (_tmp52), NULL);
					_tmp51 = (g_free (_tmp51), NULL);
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			_tmp54 = NULL;
			result = (_tmp54 = g_strconcat (result, "  </signal>\n", NULL), result = (g_free (result), NULL), _tmp54);
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	_tmp55 = NULL;
	result = (_tmp55 = g_strconcat (result, "</interface>\n", NULL), result = (g_free (result), NULL), _tmp55);
	_tmp56 = NULL;
	return (_tmp56 = result, (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), dbus_iface_name = (g_free (dbus_iface_name), NULL), _tmp56);
}


static char* vala_dbus_server_module_generate_dbus_introspect (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeVariableDeclarator* _tmp9;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeExpressionStatement* _tmp15;
	ValaCCodeAssignment* _tmp14;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeUnaryExpression* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeExpressionStatement* _tmp21;
	ValaCCodeDeclaration* _tmp22;
	ValaCCodeVariableDeclarator* _tmp23;
	ValaCCodeDeclaration* _tmp24;
	ValaCCodeVariableDeclarator* _tmp25;
	ValaCCodeDeclaration* _tmp26;
	ValaCCodeVariableDeclarator* _tmp27;
	char* xml_data;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeFunctionCall* _tmp29;
	ValaCCodeFunctionCall* str_call;
	ValaCCodeConstant* _tmp32;
	char* _tmp31;
	char* _tmp30;
	ValaCCodeExpressionStatement* _tmp35;
	ValaCCodeAssignment* _tmp34;
	ValaCCodeIdentifier* _tmp33;
	char* _tmp36;
	char* _tmp37;
	char* _tmp39;
	char* _tmp38;
	ValaCCodeFunctionCall* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeConstant* _tmp45;
	char* _tmp44;
	char* _tmp43;
	ValaCCodeExpressionStatement* _tmp46;
	ValaCCodeIdentifier* _tmp47;
	ValaCCodeFunctionCall* _tmp48;
	ValaCCodeFunctionCall* get_path;
	ValaCCodeCastExpression* _tmp50;
	ValaCCodeIdentifier* _tmp49;
	ValaCCodeConstant* _tmp51;
	ValaCCodeIdentifier* _tmp52;
	ValaCCodeFunctionCall* _tmp53;
	ValaCCodeFunctionCall* list_call;
	ValaCCodeIdentifier* _tmp54;
	ValaCCodeUnaryExpression* _tmp56;
	ValaCCodeIdentifier* _tmp55;
	ValaCCodeExpressionStatement* _tmp57;
	ValaCCodeBlock* child_block;
	ValaCCodeFunctionCall* _tmp59;
	ValaCCodeIdentifier* _tmp58;
	ValaCCodeIdentifier* _tmp60;
	ValaCCodeConstant* _tmp63;
	char* _tmp62;
	char* _tmp61;
	ValaCCodeElementAccess* _tmp66;
	ValaCCodeIdentifier* _tmp65;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeExpressionStatement* _tmp67;
	ValaCCodeElementAccess* _tmp70;
	ValaCCodeIdentifier* _tmp69;
	ValaCCodeIdentifier* _tmp68;
	ValaCCodeForStatement* _tmp71;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp74;
	ValaCCodeConstant* _tmp73;
	ValaCCodeIdentifier* _tmp72;
	ValaCCodeUnaryExpression* _tmp76;
	ValaCCodeIdentifier* _tmp75;
	char* _tmp77;
	ValaCCodeFunctionCall* _tmp79;
	ValaCCodeIdentifier* _tmp78;
	ValaCCodeIdentifier* _tmp80;
	ValaCCodeConstant* _tmp83;
	char* _tmp82;
	char* _tmp81;
	ValaCCodeExpressionStatement* _tmp84;
	ValaCCodeFunctionCall* _tmp86;
	ValaCCodeIdentifier* _tmp85;
	ValaCCodeUnaryExpression* _tmp88;
	ValaCCodeIdentifier* _tmp87;
	ValaCCodeIdentifier* _tmp89;
	ValaCCodeUnaryExpression* _tmp92;
	ValaCCodeMemberAccess* _tmp91;
	ValaCCodeIdentifier* _tmp90;
	ValaCCodeExpressionStatement* _tmp93;
	ValaCCodeFunctionCall* _tmp95;
	ValaCCodeIdentifier* _tmp94;
	ValaCCodeIdentifier* _tmp96;
	ValaCCodeConstant* _tmp97;
	ValaCCodeExpressionStatement* _tmp98;
	ValaCCodeReturnStatement* _tmp100;
	ValaCCodeIdentifier* _tmp99;
	ValaCCodeFunction* _tmp101;
	char* _tmp102;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s_introspect", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) sym, NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	function = vala_ccode_function_new (wrapper_name, "DBusMessage*");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("self", _tmp3 = g_strconcat (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) sym, FALSE), "*", NULL)));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	cdecl_ = vala_ccode_declaration_new ("DBusMessage*");
	_tmp7 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new ("reply", NULL)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp8 = NULL;
	cdecl_ = (_tmp8 = vala_ccode_declaration_new ("DBusMessageIter"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new ("iter", NULL)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp10 = NULL;
	_tmp11 = NULL;
	msgcall = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("dbus_message_new_method_return"))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("message")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp15 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("reply")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp16 = NULL;
	_tmp17 = NULL;
	iter_call = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("reply")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp20 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("iter")))));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp21 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	cdecl_ = (_tmp22 = vala_ccode_declaration_new ("GString*"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp22);
	_tmp23 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp23 = vala_ccode_variable_declarator_new ("xml_data", NULL)));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp24 = NULL;
	cdecl_ = (_tmp24 = vala_ccode_declaration_new ("char**"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp24);
	_tmp25 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp25 = vala_ccode_variable_declarator_new ("children", NULL)));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp26 = NULL;
	cdecl_ = (_tmp26 = vala_ccode_declaration_new ("int"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp26);
	_tmp27 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp27 = vala_ccode_variable_declarator_new ("i", NULL)));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	xml_data = g_strdup ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	_tmp28 = NULL;
	_tmp29 = NULL;
	str_call = (_tmp29 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("g_string_new"))), (_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)), _tmp29);
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp32 = vala_ccode_constant_new (_tmp31 = g_strdup_printf ("\"%s\"", _tmp30 = g_strescape (xml_data, "")))));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp31 = (g_free (_tmp31), NULL);
	_tmp30 = (g_free (_tmp30), NULL);
	_tmp35 = NULL;
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp35 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new ("xml_data")), (ValaCCodeExpression*) str_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp36 = NULL;
	xml_data = (_tmp36 = g_strdup ("<node>\n"), xml_data = (g_free (xml_data), NULL), _tmp36);
	_tmp37 = NULL;
	xml_data = (_tmp37 = g_strconcat (xml_data, "<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n", NULL), xml_data = (g_free (xml_data), NULL), _tmp37);
	_tmp39 = NULL;
	_tmp38 = NULL;
	xml_data = (_tmp39 = g_strconcat (xml_data, _tmp38 = vala_dbus_server_module_get_dbus_type_introspection (self, sym), NULL), xml_data = (g_free (xml_data), NULL), _tmp39);
	_tmp38 = (g_free (_tmp38), NULL);
	_tmp41 = NULL;
	_tmp40 = NULL;
	str_call = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("g_string_append"))), (str_call == NULL) ? NULL : (str_call = (vala_ccode_node_unref (str_call), NULL)), _tmp41);
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("xml_data")));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	_tmp45 = NULL;
	_tmp44 = NULL;
	_tmp43 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new (_tmp44 = g_strdup_printf ("\"%s\"", _tmp43 = g_strescape (xml_data, "")))));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp44 = (g_free (_tmp44), NULL);
	_tmp43 = (g_free (_tmp43), NULL);
	_tmp46 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp46 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) str_call)));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	_tmp47 = NULL;
	_tmp48 = NULL;
	get_path = (_tmp48 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new ("g_object_get_data"))), (_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)), _tmp48);
	_tmp50 = NULL;
	_tmp49 = NULL;
	vala_ccode_function_call_add_argument (get_path, (ValaCCodeExpression*) (_tmp50 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new ("self")), "GObject *")));
	(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	_tmp51 = NULL;
	vala_ccode_function_call_add_argument (get_path, (ValaCCodeExpression*) (_tmp51 = vala_ccode_constant_new ("\"dbus_object_path\"")));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	_tmp52 = NULL;
	_tmp53 = NULL;
	list_call = (_tmp53 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new ("dbus_connection_list_registered"))), (_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)), _tmp53);
	_tmp54 = NULL;
	vala_ccode_function_call_add_argument (list_call, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("connection")));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	vala_ccode_function_call_add_argument (list_call, (ValaCCodeExpression*) get_path);
	_tmp56 = NULL;
	_tmp55 = NULL;
	vala_ccode_function_call_add_argument (list_call, (ValaCCodeExpression*) (_tmp56 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp55 = vala_ccode_identifier_new ("children")))));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	_tmp57 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp57 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) list_call)));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	/* add child nodes*/
	child_block = vala_ccode_block_new ();
	_tmp59 = NULL;
	_tmp58 = NULL;
	str_call = (_tmp59 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new ("g_string_append_printf"))), (str_call == NULL) ? NULL : (str_call = (vala_ccode_node_unref (str_call), NULL)), _tmp59);
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	_tmp60 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new ("xml_data")));
	(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
	_tmp63 = NULL;
	_tmp62 = NULL;
	_tmp61 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp63 = vala_ccode_constant_new (_tmp62 = g_strdup_printf ("\"%s\"", _tmp61 = g_strescape ("<node name=\"%s\"/>\n", "")))));
	(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	_tmp62 = (g_free (_tmp62), NULL);
	_tmp61 = (g_free (_tmp61), NULL);
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp64 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp66 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_identifier_new ("children")), (ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new ("i")))));
	(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
	(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
	(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
	_tmp67 = NULL;
	vala_ccode_block_add_statement (child_block, (ValaCCodeNode*) (_tmp67 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) str_call)));
	(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
	_tmp70 = NULL;
	_tmp69 = NULL;
	_tmp68 = NULL;
	_tmp71 = NULL;
	cfor = (_tmp71 = vala_ccode_for_statement_new ((ValaCCodeExpression*) (_tmp70 = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new ("children")), (ValaCCodeExpression*) (_tmp69 = vala_ccode_identifier_new ("i")))), (ValaCCodeStatement*) child_block), (_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)), (_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)), (_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)), _tmp71);
	_tmp74 = NULL;
	_tmp73 = NULL;
	_tmp72 = NULL;
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp74 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp73 = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
	_tmp76 = NULL;
	_tmp75 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp76 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp75 = vala_ccode_identifier_new ("i")))));
	(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
	(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cfor);
	_tmp77 = NULL;
	xml_data = (_tmp77 = g_strdup ("</node>\n"), xml_data = (g_free (xml_data), NULL), _tmp77);
	_tmp79 = NULL;
	_tmp78 = NULL;
	str_call = (_tmp79 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp78 = vala_ccode_identifier_new ("g_string_append"))), (str_call == NULL) ? NULL : (str_call = (vala_ccode_node_unref (str_call), NULL)), _tmp79);
	(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
	_tmp80 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new ("xml_data")));
	(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
	_tmp83 = NULL;
	_tmp82 = NULL;
	_tmp81 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp83 = vala_ccode_constant_new (_tmp82 = g_strdup_printf ("\"%s\"", _tmp81 = g_strescape (xml_data, "")))));
	(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
	_tmp82 = (g_free (_tmp82), NULL);
	_tmp81 = (g_free (_tmp81), NULL);
	_tmp84 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp84 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) str_call)));
	(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
	_tmp86 = NULL;
	_tmp85 = NULL;
	iter_call = (_tmp86 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85 = vala_ccode_identifier_new ("dbus_message_iter_append_basic"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp86);
	(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
	_tmp88 = NULL;
	_tmp87 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp88 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new ("iter")))));
	(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
	(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
	_tmp89 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp89 = vala_ccode_identifier_new ("DBUS_TYPE_STRING")));
	(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
	_tmp92 = NULL;
	_tmp91 = NULL;
	_tmp90 = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp92 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp91 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new ("xml_data")), "str")))));
	(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
	(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
	(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
	_tmp93 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp93 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
	_tmp95 = NULL;
	_tmp94 = NULL;
	str_call = (_tmp95 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("g_string_free"))), (str_call == NULL) ? NULL : (str_call = (vala_ccode_node_unref (str_call), NULL)), _tmp95);
	(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
	_tmp96 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp96 = vala_ccode_identifier_new ("xml_data")));
	(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
	_tmp97 = NULL;
	vala_ccode_function_call_add_argument (str_call, (ValaCCodeExpression*) (_tmp97 = vala_ccode_constant_new ("TRUE")));
	(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
	_tmp98 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp98 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) str_call)));
	(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
	_tmp100 = NULL;
	_tmp99 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp100 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp99 = vala_ccode_identifier_new ("reply")))));
	(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
	(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
	_tmp101 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp101 = vala_ccode_function_copy (function)));
	(_tmp101 == NULL) ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp102 = NULL;
	return (_tmp102 = wrapper_name, (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), (msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL)), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), xml_data = (g_free (xml_data), NULL), (str_call == NULL) ? NULL : (str_call = (vala_ccode_node_unref (str_call), NULL)), (get_path == NULL) ? NULL : (get_path = (vala_ccode_node_unref (get_path), NULL)), (list_call == NULL) ? NULL : (list_call = (vala_ccode_node_unref (list_call), NULL)), (child_block == NULL) ? NULL : (child_block = (vala_ccode_node_unref (child_block), NULL)), (cfor == NULL) ? NULL : (cfor = (vala_ccode_node_unref (cfor), NULL)), _tmp102);
}


static void vala_dbus_server_module_handle_signals (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym, ValaCCodeBlock* block) {
	ValaAttribute* dbus;
	char* dbus_iface_name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (block != NULL);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) sym, "DBus");
	if (dbus == NULL) {
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		return;
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		dbus_iface_name = (g_free (dbus_iface_name), NULL);
		return;
	}
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _sig_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_sig_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_object_type_symbol_get_signals (sym))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_sig_it)) {
			ValaSignal* sig;
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* connect;
			ValaCCodeIdentifier* _tmp4;
			ValaCCodeConstant* _tmp5;
			ValaCCodeCastExpression* _tmp8;
			ValaCCodeIdentifier* _tmp7;
			char* _tmp6;
			ValaCCodeIdentifier* _tmp9;
			ValaCCodeExpressionStatement* _tmp10;
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			if (vala_symbol_get_access ((ValaSymbol*) sig) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) sig)) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			_tmp2 = NULL;
			_tmp3 = NULL;
			connect = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("g_signal_connect"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
			_tmp4 = NULL;
			vala_ccode_function_call_add_argument (connect, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("object")));
			(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
			_tmp5 = NULL;
			vala_ccode_function_call_add_argument (connect, (ValaCCodeExpression*) (_tmp5 = vala_signal_get_canonical_cconstant (sig, NULL)));
			(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
			_tmp8 = NULL;
			_tmp7 = NULL;
			_tmp6 = NULL;
			vala_ccode_function_call_add_argument (connect, (ValaCCodeExpression*) (_tmp8 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = vala_dbus_server_module_generate_dbus_signal_wrapper (self, sig, sym, dbus_iface_name))), "GCallback")));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
			(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp9 = NULL;
			vala_ccode_function_call_add_argument (connect, (ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("connection")));
			(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
			_tmp10 = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) connect)));
			(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			(connect == NULL) ? NULL : (connect = (vala_ccode_node_unref (connect), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
}


static void vala_dbus_server_module_generate_message_function (ValaDBusServerModule* self, ValaObjectType* object_type) {
	ValaObjectTypeSymbol* _tmp0;
	ValaObjectTypeSymbol* sym;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* cfunc;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeIfStatement* clastif;
	char* _tmp11;
	ValaAttribute* dbus;
	ValaCCodeBlock* replyblock;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeConstant* _tmp23;
	ValaCCodeExpressionStatement* _tmp24;
	ValaCCodeFunctionCall* _tmp26;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeExpressionStatement* _tmp28;
	ValaCCodeReturnStatement* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeIfStatement* _tmp32;
	ValaCCodeIfStatement* cif;
	ValaCCodeIfStatement* _tmp34;
	ValaCCodeIfStatement* _tmp33;
	ValaClass* _tmp36;
	ValaObjectTypeSymbol* _tmp35;
	ValaClass* cl;
	ValaCCodeBlock* retblock;
	ValaCCodeReturnStatement* _tmp56;
	ValaCCodeIdentifier* _tmp55;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_type != NULL);
	_tmp0 = NULL;
	sym = (_tmp0 = vala_object_type_get_type_symbol (object_type), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	((ValaCCodeBaseModule*) self)->dbus_glib_h_needed = TRUE;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	cfunc = (_tmp3 = vala_ccode_function_new (_tmp2 = g_strconcat (_tmp1 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), "dbus_message", NULL), "DBusHandlerResult"), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp4 = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp5 = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (cfunc, _tmp6 = vala_ccode_formal_parameter_new ("object", "void*"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) sym)) {
		ValaCCodeFunction* _tmp7;
		_tmp7 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp7 = vala_ccode_function_copy (cfunc)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	} else {
		ValaCCodeFunction* _tmp8;
		vala_ccode_function_set_modifiers (cfunc, vala_ccode_function_get_modifiers (cfunc) | VALA_CCODE_MODIFIERS_STATIC);
		_tmp8 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp8 = vala_ccode_function_copy (cfunc)));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	}
	block = vala_ccode_block_new ();
	vala_ccode_function_set_block (cfunc, block);
	cdecl_ = vala_ccode_declaration_new ("DBusMessage*");
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("reply", (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("NULL")))));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	clastif = NULL;
	_tmp11 = NULL;
	vala_dbus_server_module_handle_method (self, "org.freedesktop.DBus.Introspectable", "Introspect", _tmp11 = vala_dbus_server_module_generate_dbus_introspect (self, sym), block, &clastif);
	_tmp11 = (g_free (_tmp11), NULL);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) sym, "DBus");
	if (dbus != NULL) {
		char* dbus_iface_name;
		dbus_iface_name = vala_attribute_get_string (dbus, "name");
		if (dbus_iface_name != NULL) {
			gboolean need_property_get;
			gboolean need_property_set;
			char* _tmp18;
			need_property_get = FALSE;
			need_property_set = FALSE;
			{
				GeeList* _tmp12;
				GeeIterator* _tmp13;
				GeeIterator* _prop_it;
				_tmp12 = NULL;
				_tmp13 = NULL;
				_prop_it = (_tmp13 = gee_iterable_iterator ((GeeIterable*) (_tmp12 = vala_object_type_symbol_get_properties (sym))), (_tmp12 == NULL) ? NULL : (_tmp12 = (gee_collection_object_unref (_tmp12), NULL)), _tmp13);
				while (gee_iterator_next (_prop_it)) {
					ValaProperty* prop;
					gboolean _tmp14;
					gboolean _tmp15;
					prop = (ValaProperty*) gee_iterator_get (_prop_it);
					_tmp14 = FALSE;
					_tmp15 = FALSE;
					if (vala_property_get_binding (prop) != MEMBER_BINDING_INSTANCE) {
						_tmp15 = TRUE;
					} else {
						_tmp15 = vala_property_get_overrides (prop);
					}
					if (_tmp15) {
						_tmp14 = TRUE;
					} else {
						_tmp14 = vala_symbol_get_access ((ValaSymbol*) prop) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
					}
					if (_tmp14) {
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						continue;
					}
					if (!vala_dbus_server_module_is_dbus_visible (self, (ValaCodeNode*) prop)) {
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						continue;
					}
					if (vala_property_get_get_accessor (prop) != NULL) {
						need_property_get = TRUE;
					}
					if (vala_property_get_set_accessor (prop) != NULL) {
						need_property_set = TRUE;
					}
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				}
				(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
			}
			if (need_property_get) {
				char* _tmp16;
				_tmp16 = NULL;
				vala_dbus_server_module_handle_method (self, "org.freedesktop.DBus.Properties", "Get", _tmp16 = vala_dbus_server_module_generate_dbus_property_get_wrapper (self, sym, dbus_iface_name), block, &clastif);
				_tmp16 = (g_free (_tmp16), NULL);
			}
			if (need_property_set) {
				char* _tmp17;
				_tmp17 = NULL;
				vala_dbus_server_module_handle_method (self, "org.freedesktop.DBus.Properties", "Set", _tmp17 = vala_dbus_server_module_generate_dbus_property_set_wrapper (self, sym, dbus_iface_name), block, &clastif);
				_tmp17 = (g_free (_tmp17), NULL);
			}
			_tmp18 = NULL;
			vala_dbus_server_module_handle_method (self, "org.freedesktop.DBus.Properties", "GetAll", _tmp18 = vala_dbus_server_module_generate_dbus_property_get_all_wrapper (self, sym, dbus_iface_name), block, &clastif);
			_tmp18 = (g_free (_tmp18), NULL);
			vala_dbus_server_module_handle_methods (self, sym, dbus_iface_name, block, &clastif);
		}
		dbus_iface_name = (g_free (dbus_iface_name), NULL);
	}
	replyblock = vala_ccode_block_new ();
	_tmp19 = NULL;
	_tmp20 = NULL;
	ccall = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("dbus_connection_send"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("connection")));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("reply")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("NULL")));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp24 = NULL;
	vala_ccode_block_add_statement (replyblock, (ValaCCodeNode*) (_tmp24 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp26 = NULL;
	_tmp25 = NULL;
	ccall = (_tmp26 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("dbus_message_unref"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp26);
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("reply")));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp28 = NULL;
	vala_ccode_block_add_statement (replyblock, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_block_add_statement (replyblock, (ValaCCodeNode*) (_tmp30 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("DBUS_HANDLER_RESULT_HANDLED")))));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	_tmp31 = NULL;
	_tmp32 = NULL;
	cif = (_tmp32 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("reply")), (ValaCCodeStatement*) replyblock, NULL), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp32);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cif);
	_tmp34 = NULL;
	_tmp33 = NULL;
	clastif = (_tmp34 = (_tmp33 = cif, (_tmp33 == NULL) ? NULL : vala_ccode_node_ref (_tmp33)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp34);
	_tmp36 = NULL;
	_tmp35 = NULL;
	cl = (_tmp36 = (_tmp35 = sym, VALA_IS_CLASS (_tmp35) ? ((ValaClass*) _tmp35) : NULL), (_tmp36 == NULL) ? NULL : vala_code_node_ref (_tmp36));
	if (cl != NULL) {
		{
			GeeList* _tmp37;
			GeeIterator* _tmp38;
			GeeIterator* _base_type_it;
			_tmp37 = NULL;
			_tmp38 = NULL;
			_base_type_it = (_tmp38 = gee_iterable_iterator ((GeeIterable*) (_tmp37 = vala_class_get_base_types (cl))), (_tmp37 == NULL) ? NULL : (_tmp37 = (gee_collection_object_unref (_tmp37), NULL)), _tmp38);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				ValaObjectType* _tmp40;
				ValaDataType* _tmp39;
				ValaObjectType* base_obj_type;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				_tmp40 = NULL;
				_tmp39 = NULL;
				base_obj_type = (_tmp40 = (_tmp39 = base_type, VALA_IS_OBJECT_TYPE (_tmp39) ? ((ValaObjectType*) _tmp39) : NULL), (_tmp40 == NULL) ? NULL : vala_code_node_ref (_tmp40));
				if (vala_dbus_server_module_type_implements_dbus_interface (self, vala_object_type_get_type_symbol (base_obj_type))) {
					ValaCCodeIdentifier* _tmp43;
					char* _tmp42;
					char* _tmp41;
					ValaCCodeFunctionCall* _tmp44;
					ValaCCodeFunctionCall* base_call;
					ValaCCodeIdentifier* _tmp45;
					ValaCCodeIdentifier* _tmp46;
					ValaCCodeIdentifier* _tmp47;
					ValaCCodeIdentifier* _tmp48;
					ValaCCodeBinaryExpression* _tmp49;
					ValaCCodeBinaryExpression* ccheck;
					ValaCCodeBlock* base_block;
					ValaCCodeReturnStatement* _tmp51;
					ValaCCodeIdentifier* _tmp50;
					ValaCCodeIfStatement* _tmp52;
					ValaCCodeIfStatement* _tmp54;
					ValaCCodeIfStatement* _tmp53;
					_tmp43 = NULL;
					_tmp42 = NULL;
					_tmp41 = NULL;
					_tmp44 = NULL;
					base_call = (_tmp44 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (_tmp42 = g_strconcat (_tmp41 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) vala_object_type_get_type_symbol (base_obj_type)), "dbus_message", NULL)))), (_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)), _tmp42 = (g_free (_tmp42), NULL), _tmp41 = (g_free (_tmp41), NULL), _tmp44);
					_tmp45 = NULL;
					vala_ccode_function_call_add_argument (base_call, (ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new ("connection")));
					(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
					_tmp46 = NULL;
					vala_ccode_function_call_add_argument (base_call, (ValaCCodeExpression*) (_tmp46 = vala_ccode_identifier_new ("message")));
					(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
					_tmp47 = NULL;
					vala_ccode_function_call_add_argument (base_call, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new ("object")));
					(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
					_tmp48 = NULL;
					_tmp49 = NULL;
					ccheck = (_tmp49 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) base_call, (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("DBUS_HANDLER_RESULT_HANDLED"))), (_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)), _tmp49);
					base_block = vala_ccode_block_new ();
					_tmp51 = NULL;
					_tmp50 = NULL;
					vala_ccode_block_add_statement (base_block, (ValaCCodeNode*) (_tmp51 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp50 = vala_ccode_identifier_new ("DBUS_HANDLER_RESULT_HANDLED")))));
					(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
					(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
					_tmp52 = NULL;
					cif = (_tmp52 = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) base_block, NULL), (cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)), _tmp52);
					vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) cif);
					_tmp54 = NULL;
					_tmp53 = NULL;
					clastif = (_tmp54 = (_tmp53 = cif, (_tmp53 == NULL) ? NULL : vala_ccode_node_ref (_tmp53)), (clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL)), _tmp54);
					(base_call == NULL) ? NULL : (base_call = (vala_ccode_node_unref (base_call), NULL));
					(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
					(base_block == NULL) ? NULL : (base_block = (vala_ccode_node_unref (base_block), NULL));
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				(base_obj_type == NULL) ? NULL : (base_obj_type = (vala_code_node_unref (base_obj_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	}
	retblock = vala_ccode_block_new ();
	_tmp56 = NULL;
	_tmp55 = NULL;
	vala_ccode_block_add_statement (retblock, (ValaCCodeNode*) (_tmp56 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_identifier_new ("DBUS_HANDLER_RESULT_NOT_YET_HANDLED")))));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	vala_ccode_if_statement_set_false_statement (clastif, (ValaCCodeStatement*) retblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cfunc);
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
	(cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL));
	(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
	(replyblock == NULL) ? NULL : (replyblock = (vala_ccode_node_unref (replyblock), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(retblock == NULL) ? NULL : (retblock = (vala_ccode_node_unref (retblock), NULL));
}


static ValaCCodeExpression* vala_dbus_server_module_get_vtable (ValaDBusServerModule* self, ValaObjectType* object_type) {
	ValaObjectTypeSymbol* _tmp0;
	ValaObjectTypeSymbol* sym;
	ValaCCodeInitializerList* vtable;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp7;
	char* _tmp6;
	char* _tmp5;
	char* _tmp4;
	char* _tmp10;
	char* _tmp9;
	char* _tmp8;
	ValaCCodeExpression* _tmp11;
	ValaCCodeExpression* _tmp12;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_type != NULL, NULL);
	_tmp0 = NULL;
	sym = (_tmp0 = vala_object_type_get_type_symbol (object_type), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	vtable = vala_ccode_initializer_list_new ();
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_initializer_list_append (vtable, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (_tmp2 = g_strconcat (_tmp1 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), "dbus_register_object", NULL))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp1 = (g_free (_tmp1), NULL);
	vala_dbus_server_module_generate_register_function (self, object_type);
	cdecl_ = vala_ccode_declaration_new ("const _DBusObjectVTable");
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp7 = vala_ccode_variable_declarator_new (_tmp6 = g_strconcat (_tmp5 = g_strconcat ("_", _tmp4 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), NULL), "dbus_vtable", NULL), (ValaCCodeExpression*) vtable)));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_constant_declaration, (ValaCCodeNode*) cdecl_);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp11 = NULL;
	_tmp12 = NULL;
	return (_tmp12 = (_tmp11 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp10 = g_strconcat (_tmp9 = g_strconcat ("_", _tmp8 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), NULL), "dbus_vtable", NULL)), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), _tmp8 = (g_free (_tmp8), NULL), _tmp11), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (vtable == NULL) ? NULL : (vtable = (vala_ccode_node_unref (vtable), NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp12);
}


static ValaCCodeExpression* vala_dbus_server_module_get_path_vtable (ValaDBusServerModule* self, ValaObjectType* object_type) {
	ValaObjectTypeSymbol* _tmp0;
	ValaObjectTypeSymbol* sym;
	ValaCCodeInitializerList* vtable;
	ValaCCodeIdentifier* _tmp4;
	char* _tmp3;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	char* _tmp5;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp11;
	char* _tmp10;
	char* _tmp9;
	char* _tmp8;
	char* _tmp14;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeExpression* _tmp15;
	ValaCCodeExpression* _tmp16;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_type != NULL, NULL);
	_tmp0 = NULL;
	sym = (_tmp0 = vala_object_type_get_type_symbol (object_type), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	vtable = vala_ccode_initializer_list_new ();
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_initializer_list_append (vtable, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = g_strconcat (_tmp2 = g_strconcat ("_", _tmp1 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), NULL), "dbus_unregister", NULL))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_initializer_list_append (vtable, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = g_strconcat (_tmp5 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), "dbus_message", NULL))));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp5 = (g_free (_tmp5), NULL);
	vala_dbus_server_module_generate_unregister_function (self, object_type);
	vala_dbus_server_module_generate_message_function (self, object_type);
	cdecl_ = vala_ccode_declaration_new ("const DBusObjectPathVTable");
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp11 = vala_ccode_variable_declarator_new (_tmp10 = g_strconcat (_tmp9 = g_strconcat ("_", _tmp8 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), NULL), "dbus_path_vtable", NULL), (ValaCCodeExpression*) vtable)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp10 = (g_free (_tmp10), NULL);
	_tmp9 = (g_free (_tmp9), NULL);
	_tmp8 = (g_free (_tmp8), NULL);
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_constant_declaration, (ValaCCodeNode*) cdecl_);
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp15 = NULL;
	_tmp16 = NULL;
	return (_tmp16 = (_tmp15 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp14 = g_strconcat (_tmp13 = g_strconcat ("_", _tmp12 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) sym), NULL), "dbus_path_vtable", NULL)), _tmp14 = (g_free (_tmp14), NULL), _tmp13 = (g_free (_tmp13), NULL), _tmp12 = (g_free (_tmp12), NULL), _tmp15), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), (vtable == NULL) ? NULL : (vtable = (vala_ccode_node_unref (vtable), NULL)), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp16);
}


static void vala_dbus_server_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaDBusServerModule * self;
	ValaMethodType* _tmp1;
	ValaDataType* _tmp0;
	ValaMethodType* mtype;
	gboolean _tmp2;
	ValaMemberAccess* _tmp4;
	ValaMemberAccess* ma;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeFunctionCall* _tmp6;
	ValaCCodeFunctionCall* raw_conn;
	GeeList* _tmp7;
	GeeIterator* _tmp8;
	GeeIterator* args_it;
	ValaExpression* path_arg;
	ValaExpression* obj_arg;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* cregister;
	self = (ValaDBusServerModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	mtype = (_tmp1 = (_tmp0 = vala_expression_get_value_type (vala_method_call_get_call (expr)), VALA_IS_METHOD_TYPE (_tmp0) ? ((ValaMethodType*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = FALSE;
	if (mtype == NULL) {
		_tmp2 = TRUE;
	} else {
		char* _tmp3;
		_tmp3 = NULL;
		_tmp2 = _vala_strcmp0 (_tmp3 = vala_method_get_cname (vala_method_type_get_method_symbol (mtype)), "dbus_g_connection_register_g_object") != 0;
		_tmp3 = (g_free (_tmp3), NULL);
	}
	if (_tmp2) {
		VALA_CCODE_MODULE_CLASS (vala_dbus_server_module_parent_class)->visit_method_call ((ValaCCodeModule*) VALA_DBUS_CLIENT_MODULE (self), expr);
		(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
		return;
	}
	((ValaCCodeBaseModule*) self)->dbus_glib_h_needed = TRUE;
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp4 = NULL;
	ma = (_tmp4 = VALA_MEMBER_ACCESS (vala_method_call_get_call (expr)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
	_tmp5 = NULL;
	_tmp6 = NULL;
	raw_conn = (_tmp6 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp6);
	vala_ccode_function_call_add_argument (raw_conn, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
	_tmp7 = NULL;
	_tmp8 = NULL;
	args_it = (_tmp8 = gee_iterable_iterator ((GeeIterable*) (_tmp7 = vala_method_call_get_argument_list (expr))), (_tmp7 == NULL) ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL)), _tmp8);
	gee_iterator_next (args_it);
	path_arg = (ValaExpression*) gee_iterator_get (args_it);
	gee_iterator_next (args_it);
	obj_arg = (ValaExpression*) gee_iterator_get (args_it);
	_tmp9 = NULL;
	_tmp10 = NULL;
	cregister = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new ("_vala_dbus_register_object"))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp10);
	vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) raw_conn);
	vala_ccode_function_call_add_argument (cregister, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) path_arg)));
	vala_ccode_function_call_add_argument (cregister, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) obj_arg)));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) cregister);
	(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(raw_conn == NULL) ? NULL : (raw_conn = (vala_ccode_node_unref (raw_conn), NULL));
	(args_it == NULL) ? NULL : (args_it = (gee_collection_object_unref (args_it), NULL));
	(path_arg == NULL) ? NULL : (path_arg = (vala_code_node_unref (path_arg), NULL));
	(obj_arg == NULL) ? NULL : (obj_arg = (vala_code_node_unref (obj_arg), NULL));
	(cregister == NULL) ? NULL : (cregister = (vala_ccode_node_unref (cregister), NULL));
}


static gboolean vala_dbus_server_module_type_implements_dbus_interface (ValaDBusServerModule* self, ValaObjectTypeSymbol* sym) {
	ValaAttribute* dbus;
	ValaClass* _tmp2;
	ValaObjectTypeSymbol* _tmp1;
	ValaClass* cl;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) sym, "DBus");
	if (dbus != NULL) {
		gboolean _tmp0;
		return (_tmp0 = TRUE, (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), _tmp0);
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	cl = (_tmp2 = (_tmp1 = sym, VALA_IS_CLASS (_tmp1) ? ((ValaClass*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	if (cl != NULL) {
		{
			GeeList* _tmp3;
			GeeIterator* _tmp4;
			GeeIterator* _base_type_it;
			_tmp3 = NULL;
			_tmp4 = NULL;
			_base_type_it = (_tmp4 = gee_iterable_iterator ((GeeIterable*) (_tmp3 = vala_class_get_base_types (cl))), (_tmp3 == NULL) ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)), _tmp4);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				ValaObjectType* _tmp6;
				ValaDataType* _tmp5;
				ValaObjectType* base_obj_type;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				_tmp6 = NULL;
				_tmp5 = NULL;
				base_obj_type = (_tmp6 = (_tmp5 = base_type, VALA_IS_OBJECT_TYPE (_tmp5) ? ((ValaObjectType*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
				if (vala_dbus_server_module_type_implements_dbus_interface (self, vala_object_type_get_type_symbol (base_obj_type))) {
					gboolean _tmp7;
					return (_tmp7 = TRUE, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (base_obj_type == NULL) ? NULL : (base_obj_type = (vala_code_node_unref (base_obj_type), NULL)), (_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL)), (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp7);
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				(base_obj_type == NULL) ? NULL : (base_obj_type = (vala_code_node_unref (base_obj_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	}
	return (_tmp8 = FALSE, (dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp8);
}


static ValaCCodeFragment* vala_dbus_server_module_real_register_dbus_info (ValaCCodeModule* base, ValaObjectTypeSymbol* sym) {
	ValaDBusServerModule * self;
	ValaCCodeFragment* fragment;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* quark;
	ValaCCodeConstant* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* set_qdata;
	ValaCCodeIdentifier* _tmp7;
	char* _tmp6;
	ValaCCodeCastExpression* _tmp11;
	ValaCCodeUnaryExpression* _tmp10;
	ValaCCodeExpression* _tmp9;
	ValaObjectType* _tmp8;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeFragment* _tmp13;
	self = (ValaDBusServerModule*) base;
	g_return_val_if_fail (sym != NULL, NULL);
	fragment = vala_ccode_fragment_new ();
	if (!vala_dbus_server_module_type_implements_dbus_interface (self, sym)) {
		return fragment;
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	quark = (_tmp2 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (quark, (ValaCCodeExpression*) (_tmp3 = vala_ccode_constant_new ("\"DBusObjectVTable\"")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	_tmp5 = NULL;
	set_qdata = (_tmp5 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("g_type_set_qdata"))), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (set_qdata, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new (_tmp6 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) sym, "TYPE_"))));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp6 = (g_free (_tmp6), NULL);
	vala_ccode_function_call_add_argument (set_qdata, (ValaCCodeExpression*) quark);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (set_qdata, (ValaCCodeExpression*) (_tmp11 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp9 = vala_dbus_server_module_get_vtable (self, _tmp8 = vala_object_type_new (sym)))), "void*")));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
	_tmp12 = NULL;
	vala_ccode_fragment_append (fragment, (ValaCCodeNode*) (_tmp12 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_qdata)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp13 = NULL;
	return (_tmp13 = fragment, (quark == NULL) ? NULL : (quark = (vala_ccode_node_unref (quark), NULL)), (set_qdata == NULL) ? NULL : (set_qdata = (vala_ccode_node_unref (set_qdata), NULL)), _tmp13);
}


static void vala_dbus_server_module_class_init (ValaDBusServerModuleClass * klass) {
	vala_dbus_server_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_dbus_server_module_real_visit_method_call;
	VALA_CCODE_MODULE_CLASS (klass)->register_dbus_info = vala_dbus_server_module_real_register_dbus_info;
}


static void vala_dbus_server_module_instance_init (ValaDBusServerModule * self) {
}


GType vala_dbus_server_module_get_type (void) {
	static GType vala_dbus_server_module_type_id = 0;
	if (vala_dbus_server_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusServerModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_server_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusServerModule), 0, (GInstanceInitFunc) vala_dbus_server_module_instance_init, NULL };
		vala_dbus_server_module_type_id = g_type_register_static (VALA_TYPE_DBUS_CLIENT_MODULE, "ValaDBusServerModule", &g_define_type_info, 0);
	}
	return vala_dbus_server_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




