/* valaccodefunctiondeclarator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_DECLARATOR (vala_ccode_declarator_get_type ())
#define VALA_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclarator))
#define VALA_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))
#define VALA_IS_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_IS_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_CCODE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))

typedef struct _ValaCCodeDeclarator ValaCCodeDeclarator;
typedef struct _ValaCCodeDeclaratorClass ValaCCodeDeclaratorClass;
typedef struct _ValaCCodeDeclaratorPrivate ValaCCodeDeclaratorPrivate;

#define VALA_TYPE_CCODE_FUNCTION_DECLARATOR (vala_ccode_function_declarator_get_type ())
#define VALA_CCODE_FUNCTION_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclarator))
#define VALA_CCODE_FUNCTION_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorClass))
#define VALA_IS_CCODE_FUNCTION_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FUNCTION_DECLARATOR))
#define VALA_IS_CCODE_FUNCTION_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FUNCTION_DECLARATOR))
#define VALA_CCODE_FUNCTION_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorClass))

typedef struct _ValaCCodeFunctionDeclarator ValaCCodeFunctionDeclarator;
typedef struct _ValaCCodeFunctionDeclaratorClass ValaCCodeFunctionDeclaratorClass;
typedef struct _ValaCCodeFunctionDeclaratorPrivate ValaCCodeFunctionDeclaratorPrivate;

#define VALA_TYPE_CCODE_FORMAL_PARAMETER (vala_ccode_formal_parameter_get_type ())
#define VALA_CCODE_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameter))
#define VALA_CCODE_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameterClass))
#define VALA_IS_CCODE_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FORMAL_PARAMETER))
#define VALA_IS_CCODE_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FORMAL_PARAMETER))
#define VALA_CCODE_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameterClass))

typedef struct _ValaCCodeFormalParameter ValaCCodeFormalParameter;
typedef struct _ValaCCodeFormalParameterClass ValaCCodeFormalParameterClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

struct _ValaCCodeDeclarator {
	ValaCCodeNode parent_instance;
	ValaCCodeDeclaratorPrivate * priv;
};

struct _ValaCCodeDeclaratorClass {
	ValaCCodeNodeClass parent_class;
	void (*write_initialization) (ValaCCodeDeclarator* self, ValaCCodeWriter* writer);
};

struct _ValaCCodeFunctionDeclarator {
	ValaCCodeDeclarator parent_instance;
	ValaCCodeFunctionDeclaratorPrivate * priv;
};

struct _ValaCCodeFunctionDeclaratorClass {
	ValaCCodeDeclaratorClass parent_class;
};

struct _ValaCCodeFunctionDeclaratorPrivate {
	char* _name;
	GeeList* parameters;
};


static gpointer vala_ccode_function_declarator_parent_class = NULL;

gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void);
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void);
GType vala_ccode_declarator_get_type (void);
GType vala_ccode_function_declarator_get_type (void);
GType vala_ccode_formal_parameter_get_type (void);
#define VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorPrivate))
enum  {
	VALA_CCODE_FUNCTION_DECLARATOR_DUMMY_PROPERTY
};
ValaCCodeDeclarator* vala_ccode_declarator_construct (GType object_type);
void vala_ccode_function_declarator_set_name (ValaCCodeFunctionDeclarator* self, const char* value);
ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_new (const char* name);
ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_construct (GType object_type, const char* name);
void vala_ccode_function_declarator_add_parameter (ValaCCodeFunctionDeclarator* self, ValaCCodeFormalParameter* param);
void vala_ccode_node_write_declaration (ValaCCodeNode* self, ValaCCodeWriter* writer);
static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
void vala_ccode_writer_write_string (ValaCCodeWriter* self, const char* s);
const char* vala_ccode_function_declarator_get_name (ValaCCodeFunctionDeclarator* self);
void vala_ccode_node_write (ValaCCodeNode* self, ValaCCodeWriter* writer);
static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_function_declarator_finalize (ValaCCodeNode* obj);



ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_construct (GType object_type, const char* name) {
	ValaCCodeFunctionDeclarator* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaCCodeFunctionDeclarator*) vala_ccode_declarator_construct (object_type);
	vala_ccode_function_declarator_set_name (self, name);
	return self;
}


ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_new (const char* name) {
	return vala_ccode_function_declarator_construct (VALA_TYPE_CCODE_FUNCTION_DECLARATOR, name);
}


void vala_ccode_function_declarator_add_parameter (ValaCCodeFunctionDeclarator* self, ValaCCodeFormalParameter* param) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	gee_collection_add ((GeeCollection*) self->priv->parameters, param);
}


static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFunctionDeclarator * self;
	self = (ValaCCodeFunctionDeclarator*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self, writer);
}


static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFunctionDeclarator * self;
	gboolean first;
	self = (ValaCCodeFunctionDeclarator*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "(*");
	vala_ccode_writer_write_string (writer, self->priv->_name);
	vala_ccode_writer_write_string (writer, ") (");
	first = TRUE;
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) self->priv->parameters);
		while (TRUE) {
			ValaCCodeFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaCCodeFormalParameter*) gee_iterator_get (_param_it);
			if (!first) {
				vala_ccode_writer_write_string (writer, ", ");
			} else {
				first = FALSE;
			}
			vala_ccode_node_write ((ValaCCodeNode*) param, writer);
			_vala_ccode_node_unref0 (param);
		}
		_gee_collection_object_unref0 (_param_it);
	}
	vala_ccode_writer_write_string (writer, ")");
}


const char* vala_ccode_function_declarator_get_name (ValaCCodeFunctionDeclarator* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void vala_ccode_function_declarator_set_name (ValaCCodeFunctionDeclarator* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
}


static void vala_ccode_function_declarator_class_init (ValaCCodeFunctionDeclaratorClass * klass) {
	vala_ccode_function_declarator_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_function_declarator_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeFunctionDeclaratorPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_function_declarator_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_function_declarator_real_write_declaration;
}


static void vala_ccode_function_declarator_instance_init (ValaCCodeFunctionDeclarator * self) {
	self->priv = VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE (self);
	self->priv->parameters = (GeeList*) gee_array_list_new (VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_function_declarator_finalize (ValaCCodeNode* obj) {
	ValaCCodeFunctionDeclarator * self;
	self = VALA_CCODE_FUNCTION_DECLARATOR (obj);
	_g_free0 (self->priv->_name);
	_gee_collection_object_unref0 (self->priv->parameters);
	VALA_CCODE_NODE_CLASS (vala_ccode_function_declarator_parent_class)->finalize (obj);
}


GType vala_ccode_function_declarator_get_type (void) {
	static GType vala_ccode_function_declarator_type_id = 0;
	if (vala_ccode_function_declarator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFunctionDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_function_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFunctionDeclarator), 0, (GInstanceInitFunc) vala_ccode_function_declarator_instance_init, NULL };
		vala_ccode_function_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_DECLARATOR, "ValaCCodeFunctionDeclarator", &g_define_type_info, 0);
	}
	return vala_ccode_function_declarator_type_id;
}




