/* valaccodemethodmodule.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))

struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTryStatement* current_try;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};


static gpointer vala_ccode_method_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
enum  {
	VALA_CCODE_METHOD_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeStructModule* vala_ccode_struct_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeStructModule* vala_ccode_struct_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method);
static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m);
char* vala_ccode_module_get_custom_creturn_type (ValaCCodeModule* self, ValaMethod* m);
static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value);
static gboolean vala_ccode_method_module_is_gtypeinstance_creation_method (ValaCCodeMethodModule* self, ValaMethod* m);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
ValaCCodeExpression* vala_ccode_base_module_get_result_cexpression (ValaCCodeBaseModule* self, const char* cname);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
void vala_ccode_method_module_generate_method_result_declaration (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
static void vala_ccode_method_module_real_generate_method_result_declaration (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
ValaCCodeStatement* vala_ccode_method_module_complete_async (ValaCCodeMethodModule* self);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_ccode_method_module_real_generate_method_declaration (ValaCCodeBaseModule* base, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_check_type (ValaCCodeBaseModule* self, ValaDataType* type);
ValaTypeSymbol* vala_ccode_base_module_get_current_type_symbol (ValaCCodeBaseModule* self);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
ValaClass* vala_ccode_base_module_get_current_class (ValaCCodeBaseModule* self);
static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
gint vala_ccode_base_module_get_block_id (ValaCCodeBaseModule* self, ValaBlock* b);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
ValaCCodeExpression* vala_ccode_module_get_construct_property_assignment (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression);
void vala_ccode_method_module_generate_vfunc (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, GeeMap* cparam_map, GeeMap* carg_map, const char* suffix, gint direction);
static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
static void vala_ccode_method_module_real_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym);
static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeBaseModule* base, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
ValaCCodeStatement* vala_ccode_base_module_create_postcondition_statement (ValaCCodeBaseModule* self, ValaExpression* postcondition);
ValaCCodeStatement* vala_ccode_base_module_create_type_check_statement (ValaCCodeBaseModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
void vala_ccode_module_visit_method (ValaCCodeModule* self, ValaMethod* m);
static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m);



ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodModule*) vala_ccode_struct_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_module_construct (VALA_TYPE_CCODE_METHOD_MODULE, codegen, next);
}


static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method) {
	ValaCCodeMethodModule * self;
	gboolean result;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (method != NULL, FALSE);
	result = (_tmp1_ = (_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) method, "NoWrapper")) == NULL, _vala_code_node_unref0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	char* result;
	ValaAttribute* attr;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (m != NULL, NULL);
	attr = vala_code_node_get_attribute ((ValaCodeNode*) m, "CCode");
	if (attr != NULL) {
		char* type;
		type = vala_attribute_get_string (attr, "type");
		if (type != NULL) {
			result = type;
			_vala_code_node_unref0 (attr);
			return result;
		}
		_g_free0 (type);
	}
	result = NULL;
	_vala_code_node_unref0 (attr);
	return result;
}


static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value) {
	char* result;
	char* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	type = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, m);
	if (type == NULL) {
		result = g_strdup (default_value);
		_g_free0 (type);
		return result;
	}
	result = type;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_ccode_method_module_is_gtypeinstance_creation_method (ValaCCodeMethodModule* self, ValaMethod* m) {
	gboolean result;
	gboolean _result_;
	ValaSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	cl = _vala_code_node_ref0 ((_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL));
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		_tmp2_ = cl != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = !vala_class_get_is_compact (cl);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_result_ = TRUE;
	}
	result = _result_;
	_vala_code_node_unref0 (cl);
	return result;
}


static void vala_ccode_method_module_real_generate_method_result_declaration (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map) {
	ValaDataType* creturn_type;
	char* _tmp4_;
	char* _tmp3_;
	gboolean _tmp17_;
	GeeList* _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cfunc != NULL);
	g_return_if_fail (cparam_map != NULL);
	creturn_type = _vala_code_node_ref0 (vala_method_get_return_type (m));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSymbol* _tmp0_;
		ValaClass* cl;
		cl = _vala_code_node_ref0 ((_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL));
		if (cl != NULL) {
			ValaDataType* _tmp1_;
			creturn_type = (_tmp1_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) cl), _vala_code_node_unref0 (creturn_type), _tmp1_);
		}
		_vala_code_node_unref0 (cl);
	} else {
		if (vala_data_type_is_real_non_null_struct_type (vala_method_get_return_type (m))) {
			ValaDataType* _tmp2_;
			creturn_type = (_tmp2_ = (ValaDataType*) vala_void_type_new (NULL), _vala_code_node_unref0 (creturn_type), _tmp2_);
		}
	}
	vala_ccode_function_set_return_type (cfunc, _tmp4_ = vala_ccode_method_module_get_creturn_type (self, m, _tmp3_ = vala_data_type_get_cname (creturn_type)));
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m), decl_space);
	if (vala_data_type_is_real_non_null_struct_type (vala_method_get_return_type (m))) {
		char* _tmp6_;
		char* _tmp5_;
		ValaCCodeFormalParameter* _tmp7_;
		ValaCCodeFormalParameter* cparam;
		cparam = (_tmp7_ = vala_ccode_formal_parameter_new ("result", _tmp6_ = g_strconcat (_tmp5_ = vala_data_type_get_cname (vala_method_get_return_type (m)), "*", NULL)), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp7_);
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-3), FALSE)), cparam);
		if (carg_map != NULL) {
			ValaCCodeExpression* _tmp8_;
			gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-3), FALSE)), _tmp8_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "result"));
			_vala_ccode_node_unref0 (_tmp8_);
		}
		_vala_ccode_node_unref0 (cparam);
	} else {
		gboolean _tmp9_;
		_tmp9_ = FALSE;
		if (!vala_method_get_no_array_length (m)) {
			_tmp9_ = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaArrayType* array_type;
			array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_method_get_return_type (m)));
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp10_;
					_tmp10_ = TRUE;
					while (TRUE) {
						char* _tmp11_;
						ValaCCodeFormalParameter* _tmp12_;
						ValaCCodeFormalParameter* cparam;
						if (!_tmp10_) {
							dim++;
						}
						_tmp10_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						cparam = (_tmp12_ = vala_ccode_formal_parameter_new (_tmp11_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _g_free0 (_tmp11_), _tmp12_);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeExpression* _tmp13_;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), _tmp13_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
							_vala_ccode_node_unref0 (_tmp13_);
						}
						_vala_ccode_node_unref0 (cparam);
					}
				}
			}
			_vala_code_node_unref0 (array_type);
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
				ValaDelegateType* deleg_type;
				ValaDelegate* d;
				deleg_type = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (vala_method_get_return_type (m)));
				d = _vala_code_node_ref0 (vala_delegate_type_get_delegate_symbol (deleg_type));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp14_;
					ValaCCodeFormalParameter* _tmp15_;
					ValaCCodeFormalParameter* cparam;
					cparam = (_tmp15_ = vala_ccode_formal_parameter_new (_tmp14_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void**"), _g_free0 (_tmp14_), _tmp15_);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeExpression* _tmp16_;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), _tmp16_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
						_vala_ccode_node_unref0 (_tmp16_);
					}
					_vala_ccode_node_unref0 (cparam);
				}
				_vala_code_node_unref0 (deleg_type);
				_vala_code_node_unref0 (d);
			}
		}
	}
	_tmp17_ = FALSE;
	if ((_tmp19_ = gee_collection_get_size ((GeeCollection*) (_tmp18_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, _gee_collection_object_unref0 (_tmp18_), _tmp19_)) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp20_;
		_tmp20_ = FALSE;
		if (vala_method_get_base_method (m) != NULL) {
			GeeList* _tmp21_;
			_tmp20_ = gee_collection_get_size ((GeeCollection*) (_tmp21_ = vala_code_node_get_error_types ((ValaCodeNode*) vala_method_get_base_method (m)))) > 0;
			_gee_collection_object_unref0 (_tmp21_);
		} else {
			_tmp20_ = FALSE;
		}
		_tmp17_ = _tmp20_;
	}
	if (_tmp17_) {
		ValaCCodeFormalParameter* cparam;
		{
			GeeList* _tmp22_;
			GeeIterator* _tmp23_;
			GeeIterator* _error_type_it;
			_error_type_it = (_tmp23_ = gee_iterable_iterator ((GeeIterable*) (_tmp22_ = vala_code_node_get_error_types ((ValaCodeNode*) m))), _gee_collection_object_unref0 (_tmp22_), _tmp23_);
			while (TRUE) {
				ValaDataType* error_type;
				if (!gee_iterator_next (_error_type_it)) {
					break;
				}
				error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
				vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, error_type, decl_space);
				_vala_code_node_unref0 (error_type);
			}
			_gee_collection_object_unref0 (_error_type_it);
		}
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
		if (carg_map != NULL) {
			ValaCCodeIdentifier* _tmp24_;
			gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
			_vala_ccode_node_unref0 (_tmp24_);
		}
		_vala_ccode_node_unref0 (cparam);
	}
	_vala_code_node_unref0 (creturn_type);
}


void vala_ccode_method_module_generate_method_result_declaration (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map) {
	VALA_CCODE_METHOD_MODULE_GET_CLASS (self)->generate_method_result_declaration (self, m, decl_space, cfunc, cparam_map, carg_map);
}


ValaCCodeStatement* vala_ccode_method_module_complete_async (ValaCCodeMethodModule* self) {
	ValaCCodeStatement* result;
	ValaCCodeBlock* complete_block;
	ValaCCodeBlock* direct_block;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* direct_call;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeMemberAccess* _tmp3_;
	ValaCCodeMemberAccess* async_result_expr;
	ValaCCodeExpressionStatement* _tmp4_;
	ValaCCodeBlock* idle_block;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* idle_call;
	ValaCCodeExpressionStatement* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeMemberAccess* _tmp9_;
	ValaCCodeMemberAccess* state;
	ValaCCodeConstant* zero;
	ValaCCodeBinaryExpression* state_is_zero;
	ValaCCodeIfStatement* dispatch;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* unref;
	ValaCCodeExpressionStatement* _tmp12_;
	ValaCCodeReturnStatement* _tmp14_;
	ValaCCodeConstant* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	complete_block = vala_ccode_block_new ();
	direct_block = vala_ccode_block_new ();
	direct_call = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_simple_async_result_complete"))), _vala_ccode_node_unref0 (_tmp0_), _tmp1_);
	async_result_expr = (_tmp3_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("data")), "_async_result"), _vala_ccode_node_unref0 (_tmp2_), _tmp3_);
	vala_ccode_function_call_add_argument (direct_call, (ValaCCodeExpression*) async_result_expr);
	vala_ccode_block_add_statement (direct_block, (ValaCCodeNode*) (_tmp4_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) direct_call)));
	_vala_ccode_node_unref0 (_tmp4_);
	idle_block = vala_ccode_block_new ();
	idle_call = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("g_simple_async_result_complete_in_idle"))), _vala_ccode_node_unref0 (_tmp5_), _tmp6_);
	vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) async_result_expr);
	vala_ccode_block_add_statement (idle_block, (ValaCCodeNode*) (_tmp7_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) idle_call)));
	_vala_ccode_node_unref0 (_tmp7_);
	state = (_tmp9_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("data")), "_state_"), _vala_ccode_node_unref0 (_tmp8_), _tmp9_);
	zero = vala_ccode_constant_new ("0");
	state_is_zero = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) state, (ValaCCodeExpression*) zero);
	dispatch = vala_ccode_if_statement_new ((ValaCCodeExpression*) state_is_zero, (ValaCCodeStatement*) idle_block, (ValaCCodeStatement*) direct_block);
	vala_ccode_block_add_statement (complete_block, (ValaCCodeNode*) dispatch);
	unref = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("g_object_unref"))), _vala_ccode_node_unref0 (_tmp10_), _tmp11_);
	vala_ccode_function_call_add_argument (unref, (ValaCCodeExpression*) async_result_expr);
	vala_ccode_block_add_statement (complete_block, (ValaCCodeNode*) (_tmp12_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) unref)));
	_vala_ccode_node_unref0 (_tmp12_);
	vala_ccode_block_add_statement (complete_block, (ValaCCodeNode*) (_tmp14_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new ("FALSE")))));
	_vala_ccode_node_unref0 (_tmp14_);
	_vala_ccode_node_unref0 (_tmp13_);
	result = (ValaCCodeStatement*) complete_block;
	_vala_ccode_node_unref0 (direct_block);
	_vala_ccode_node_unref0 (direct_call);
	_vala_ccode_node_unref0 (async_result_expr);
	_vala_ccode_node_unref0 (idle_block);
	_vala_ccode_node_unref0 (idle_call);
	_vala_ccode_node_unref0 (state);
	_vala_ccode_node_unref0 (zero);
	_vala_ccode_node_unref0 (state_is_zero);
	_vala_ccode_node_unref0 (dispatch);
	_vala_ccode_node_unref0 (unref);
	return result;
}


static void vala_ccode_method_module_real_generate_method_declaration (ValaCCodeBaseModule* base, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space) {
	ValaCCodeMethodModule * self;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	GeeHashMap* carg_map;
	ValaSymbol* _tmp4_;
	ValaClass* cl;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp9_;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	if (vala_method_get_is_async_callback (m)) {
		return;
	}
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) m, _tmp0_ = vala_method_get_cname (m)), _g_free0 (_tmp0_), _tmp1_)) {
		return;
	}
	function = (_tmp3_ = vala_ccode_function_new (_tmp2_ = vala_method_get_cname (m), "void"), _g_free0 (_tmp2_), _tmp3_);
	if (vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
		vala_ccode_function_set_modifiers (function, vala_ccode_function_get_modifiers (function) | VALA_CCODE_MODIFIERS_STATIC);
		if (vala_method_get_is_inline (m)) {
			vala_ccode_function_set_modifiers (function, vala_ccode_function_get_modifiers (function) | VALA_CCODE_MODIFIERS_INLINE);
		}
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	cl = _vala_code_node_ref0 ((_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_CLASS (_tmp4_) ? ((ValaClass*) _tmp4_) : NULL));
	_tmp5_ = FALSE;
	_tmp6_ = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		_tmp6_ = cl != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = vala_class_get_is_abstract (cl);
	} else {
		_tmp5_ = FALSE;
	}
	if (!_tmp5_) {
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeIdentifier* _tmp7_;
		vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, decl_space, (GeeMap*) cparam_map, function, NULL, (GeeMap*) carg_map, _tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("fake"))), 3);
		_vala_ccode_node_unref0 (_tmp8_);
		_vala_ccode_node_unref0 (_tmp7_);
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
	}
	_tmp9_ = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		_tmp9_ = cl != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaCCodeFunction* _tmp11_;
		char* _tmp10_;
		GeeHashMap* _tmp12_;
		function = (_tmp11_ = vala_ccode_function_new (_tmp10_ = vala_method_get_real_cname (m), "void"), _vala_ccode_node_unref0 (function), _tmp11_);
		_g_free0 (_tmp10_);
		if (vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
			vala_ccode_function_set_modifiers (function, vala_ccode_function_get_modifiers (function) | VALA_CCODE_MODIFIERS_STATIC);
		}
		cparam_map = (_tmp12_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), _gee_collection_object_unref0 (cparam_map), _tmp12_);
		vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, decl_space, (GeeMap*) cparam_map, function, NULL, NULL, NULL, 3);
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
	}
	_vala_ccode_node_unref0 (function);
	_gee_collection_object_unref0 (cparam_map);
	_gee_collection_object_unref0 (carg_map);
	_vala_code_node_unref0 (cl);
}


static gpointer _gee_collection_object_ref0 (gpointer self) {
	return self ? gee_collection_object_ref (self) : NULL;
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaSymbol* old_symbol;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	GeeArrayList* old_temp_vars;
	GeeArrayList* old_temp_ref_vars;
	GeeMap* old_variable_name_map;
	ValaTryStatement* old_try;
	ValaSymbol* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeMap* _tmp3_;
	ValaTryStatement* _tmp4_;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* creturn_type;
	gboolean _tmp9_;
	gboolean inner_error;
	ValaSymbol* _tmp37_;
	GeeArrayList* _tmp38_;
	GeeArrayList* _tmp39_;
	GeeMap* _tmp40_;
	ValaTryStatement* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	ValaCCodeFunction* _tmp46_;
	char* _tmp45_;
	GeeHashMap* cparam_map;
	gboolean _tmp47_;
	gboolean _tmp242_;
	gboolean _tmp243_;
	gboolean _tmp244_;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	old_symbol = _vala_code_node_ref0 (((ValaCCodeBaseModule*) self)->current_symbol);
	old_method_inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	old_next_temp_var_id = ((ValaCCodeBaseModule*) self)->next_temp_var_id;
	old_temp_vars = _gee_collection_object_ref0 (((ValaCCodeBaseModule*) self)->temp_vars);
	old_temp_ref_vars = _gee_collection_object_ref0 (((ValaCCodeBaseModule*) self)->temp_ref_vars);
	old_variable_name_map = _gee_collection_object_ref0 (((ValaCCodeBaseModule*) self)->variable_name_map);
	old_try = _vala_code_node_ref0 (((ValaCCodeBaseModule*) self)->current_try);
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp0_ = _vala_code_node_ref0 ((ValaSymbol*) m), _vala_code_node_unref0 (((ValaCCodeBaseModule*) self)->current_symbol), _tmp0_);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = FALSE;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = 0;
	((ValaCCodeBaseModule*) self)->temp_vars = (_tmp1_ = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), _gee_collection_object_unref0 (((ValaCCodeBaseModule*) self)->temp_vars), _tmp1_);
	((ValaCCodeBaseModule*) self)->temp_ref_vars = (_tmp2_ = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), _gee_collection_object_unref0 (((ValaCCodeBaseModule*) self)->temp_ref_vars), _tmp2_);
	((ValaCCodeBaseModule*) self)->variable_name_map = (_tmp3_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal), _gee_collection_object_unref0 (((ValaCCodeBaseModule*) self)->variable_name_map), _tmp3_);
	((ValaCCodeBaseModule*) self)->current_try = (_tmp4_ = NULL, _vala_code_node_unref0 (((ValaCCodeBaseModule*) self)->current_try), _tmp4_);
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	vala_ccode_base_module_check_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaTypeSymbol* _tmp5_;
		ValaClass* cl;
		gboolean _tmp6_;
		cl = _vala_code_node_ref0 ((_tmp5_ = vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self), VALA_IS_CLASS (_tmp5_) ? ((ValaClass*) _tmp5_) : NULL));
		_tmp6_ = FALSE;
		if (cl != NULL) {
			_tmp6_ = !vala_class_get_is_compact (cl);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			if (vala_class_get_base_class (cl) == NULL) {
				in_fundamental_creation_method = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = FALSE;
				if (((ValaCCodeBaseModule*) self)->gobject_type != NULL) {
					_tmp7_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		_vala_code_node_unref0 (cl);
	}
	creturn_type = _vala_code_node_ref0 (vala_method_get_return_type (m));
	if (vala_data_type_is_real_non_null_struct_type (vala_method_get_return_type (m))) {
		ValaDataType* _tmp8_;
		creturn_type = (_tmp8_ = (ValaDataType*) vala_void_type_new (NULL), _vala_code_node_unref0 (creturn_type), _tmp8_);
	}
	_tmp9_ = FALSE;
	if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = vala_method_get_binding (m) == MEMBER_BINDING_STATIC;
	}
	if (_tmp9_) {
		((ValaCCodeBaseModule*) self)->in_static_or_class_context = TRUE;
	}
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	((ValaCCodeBaseModule*) self)->in_static_or_class_context = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		gboolean _tmp10_;
		_tmp10_ = FALSE;
		if (in_gobject_creation_method) {
			_tmp10_ = vala_method_get_body (m) != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			if (!vala_creation_method_get_chain_up (VALA_CREATION_METHOD (m))) {
				ValaCCodeBlock* cblock;
				ValaCodeNode* last_stmt;
				gboolean _tmp20_;
				if (vala_block_get_captured (vala_method_get_body (m))) {
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), "Closures are not supported in GObject-style creation methods");
				}
				cblock = vala_ccode_block_new ();
				last_stmt = NULL;
				{
					GeeList* _tmp11_;
					GeeIterator* _tmp12_;
					GeeIterator* _stmt_it;
					_stmt_it = (_tmp12_ = gee_iterable_iterator ((GeeIterable*) (_tmp11_ = vala_block_get_statements (vala_method_get_body (m)))), _gee_collection_object_unref0 (_tmp11_), _tmp12_);
					while (TRUE) {
						ValaCodeNode* stmt;
						ValaCodeNode* _tmp13_;
						ValaExpressionStatement* expr_stmt;
						if (!gee_iterator_next (_stmt_it)) {
							break;
						}
						stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
						expr_stmt = _vala_code_node_ref0 ((_tmp13_ = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp13_) ? ((ValaExpressionStatement*) _tmp13_) : NULL));
						if (expr_stmt != NULL) {
							ValaProperty* prop;
							gboolean _tmp14_;
							prop = vala_expression_statement_assigned_property (expr_stmt);
							_tmp14_ = FALSE;
							if (prop != NULL) {
								_tmp14_ = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
							} else {
								_tmp14_ = FALSE;
							}
							if (_tmp14_) {
								ValaCodeNode* _tmp15_;
								last_stmt = (_tmp15_ = _vala_code_node_ref0 (stmt), _vala_code_node_unref0 (last_stmt), _tmp15_);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (expr_stmt);
					}
					_gee_collection_object_unref0 (_stmt_it);
				}
				if (last_stmt != NULL) {
					{
						GeeList* _tmp16_;
						GeeIterator* _tmp17_;
						GeeIterator* _stmt_it;
						_stmt_it = (_tmp17_ = gee_iterable_iterator ((GeeIterable*) (_tmp16_ = vala_block_get_statements (vala_method_get_body (m)))), _gee_collection_object_unref0 (_tmp16_), _tmp17_);
						while (TRUE) {
							ValaCodeNode* stmt;
							if (!gee_iterator_next (_stmt_it)) {
								break;
							}
							stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeList* _tmp18_;
									GeeIterator* _tmp19_;
									GeeIterator* _cstmt_it;
									_cstmt_it = (_tmp19_ = gee_iterable_iterator ((GeeIterable*) (_tmp18_ = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))))), _gee_collection_object_unref0 (_tmp18_), _tmp19_);
									while (TRUE) {
										ValaCCodeNode* cstmt;
										if (!gee_iterator_next (_cstmt_it)) {
											break;
										}
										cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
										vala_ccode_block_add_statement (cblock, cstmt);
										_vala_ccode_node_unref0 (cstmt);
									}
									_gee_collection_object_unref0 (_cstmt_it);
								}
							} else {
								vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
							}
							if (last_stmt == stmt) {
								_vala_code_node_unref0 (stmt);
								break;
							}
							_vala_code_node_unref0 (stmt);
						}
						_gee_collection_object_unref0 (_stmt_it);
					}
				}
				_tmp20_ = FALSE;
				if (vala_creation_method_get_n_construction_params (VALA_CREATION_METHOD (m)) > 0) {
					_tmp20_ = TRUE;
				} else {
					GeeList* _tmp21_;
					_tmp20_ = gee_collection_get_size ((GeeCollection*) (_tmp21_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)))) > 0;
					_gee_collection_object_unref0 (_tmp21_);
				}
				vala_ccode_method_module_add_object_creation (self, cblock, _tmp20_);
				{
					GeeList* _tmp22_;
					GeeIterator* _tmp23_;
					GeeIterator* _stmt_it;
					_stmt_it = (_tmp23_ = gee_iterable_iterator ((GeeIterable*) (_tmp22_ = vala_block_get_statements (vala_method_get_body (m)))), _gee_collection_object_unref0 (_tmp22_), _tmp23_);
					while (TRUE) {
						ValaCodeNode* stmt;
						if (!gee_iterator_next (_stmt_it)) {
							break;
						}
						stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
						if (last_stmt != NULL) {
							if (last_stmt == stmt) {
								ValaCodeNode* _tmp24_;
								last_stmt = (_tmp24_ = NULL, _vala_code_node_unref0 (last_stmt), _tmp24_);
							}
							_vala_code_node_unref0 (stmt);
							continue;
						}
						if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
							{
								GeeList* _tmp25_;
								GeeIterator* _tmp26_;
								GeeIterator* _cstmt_it;
								_cstmt_it = (_tmp26_ = gee_iterable_iterator ((GeeIterable*) (_tmp25_ = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))))), _gee_collection_object_unref0 (_tmp25_), _tmp26_);
								while (TRUE) {
									ValaCCodeNode* cstmt;
									if (!gee_iterator_next (_cstmt_it)) {
										break;
									}
									cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
									vala_ccode_block_add_statement (cblock, cstmt);
									_vala_ccode_node_unref0 (cstmt);
								}
								_gee_collection_object_unref0 (_cstmt_it);
							}
						} else {
							vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
						}
						_vala_code_node_unref0 (stmt);
					}
					_gee_collection_object_unref0 (_stmt_it);
				}
				{
					GeeList* _tmp27_;
					GeeIterator* _tmp28_;
					GeeIterator* _local_it;
					_local_it = (_tmp28_ = gee_iterable_iterator ((GeeIterable*) (_tmp27_ = vala_block_get_local_variables (vala_method_get_body (m)))), _gee_collection_object_unref0 (_tmp27_), _tmp28_);
					while (TRUE) {
						ValaLocalVariable* local;
						gboolean _tmp29_;
						if (!gee_iterator_next (_local_it)) {
							break;
						}
						local = (ValaLocalVariable*) gee_iterator_get (_local_it);
						_tmp29_ = FALSE;
						if (!vala_local_variable_get_floating (local)) {
							_tmp29_ = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_local_variable_get_variable_type (local));
						} else {
							_tmp29_ = FALSE;
						}
						if (_tmp29_) {
							ValaMemberAccess* ma;
							ValaCCodeExpressionStatement* _tmp32_;
							ValaCCodeExpression* _tmp31_;
							ValaCCodeExpression* _tmp30_;
							ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
							vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
							vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp32_ = vala_ccode_expression_statement_new (_tmp31_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, _tmp30_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma, FALSE))));
							_vala_ccode_node_unref0 (_tmp32_);
							_vala_ccode_node_unref0 (_tmp31_);
							_vala_ccode_node_unref0 (_tmp30_);
							_vala_code_node_unref0 (ma);
						}
						_vala_code_node_unref0 (local);
					}
					_gee_collection_object_unref0 (_local_it);
				}
				vala_code_node_set_ccodenode ((ValaCodeNode*) vala_method_get_body (m), (ValaCCodeNode*) cblock);
				_vala_ccode_node_unref0 (cblock);
				_vala_code_node_unref0 (last_stmt);
			} else {
				ValaCCodeBlock* cblock;
				char* _tmp34_;
				char* _tmp33_;
				ValaCCodeDeclaration* _tmp35_;
				ValaCCodeDeclaration* cdeclaration;
				ValaCCodeVariableDeclarator* _tmp36_;
				cblock = _vala_ccode_node_ref0 (VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_get_body (m))));
				cdeclaration = (_tmp35_ = vala_ccode_declaration_new (_tmp34_ = g_strdup_printf ("%s *", _tmp33_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) VALA_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self)), FALSE))), _g_free0 (_tmp34_), _g_free0 (_tmp33_), _tmp35_);
				vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) (_tmp36_ = vala_ccode_variable_declarator_new ("self", NULL, NULL)));
				_vala_ccode_node_unref0 (_tmp36_);
				vala_ccode_block_prepend_statement (cblock, (ValaCCodeNode*) cdeclaration);
				_vala_ccode_node_unref0 (cblock);
				_vala_ccode_node_unref0 (cdeclaration);
			}
		}
	}
	inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp37_ = _vala_code_node_ref0 (old_symbol), _vala_code_node_unref0 (((ValaCCodeBaseModule*) self)->current_symbol), _tmp37_);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = old_method_inner_error;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = old_next_temp_var_id;
	((ValaCCodeBaseModule*) self)->temp_vars = (_tmp38_ = _gee_collection_object_ref0 (old_temp_vars), _gee_collection_object_unref0 (((ValaCCodeBaseModule*) self)->temp_vars), _tmp38_);
	((ValaCCodeBaseModule*) self)->temp_ref_vars = (_tmp39_ = _gee_collection_object_ref0 (old_temp_ref_vars), _gee_collection_object_unref0 (((ValaCCodeBaseModule*) self)->temp_ref_vars), _tmp39_);
	((ValaCCodeBaseModule*) self)->variable_name_map = (_tmp40_ = _gee_collection_object_ref0 (old_variable_name_map), _gee_collection_object_unref0 (((ValaCCodeBaseModule*) self)->variable_name_map), _tmp40_);
	((ValaCCodeBaseModule*) self)->current_try = (_tmp41_ = _vala_code_node_ref0 (old_try), _vala_code_node_unref0 (((ValaCCodeBaseModule*) self)->current_try), _tmp41_);
	_tmp42_ = FALSE;
	_tmp43_ = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp43_ = TRUE;
	} else {
		_tmp43_ = vala_method_get_is_virtual (m);
	}
	if (_tmp43_) {
		_tmp42_ = TRUE;
	} else {
		gboolean _tmp44_;
		_tmp44_ = FALSE;
		if (vala_method_get_base_method (m) == NULL) {
			_tmp44_ = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp44_ = FALSE;
		}
		_tmp42_ = _tmp44_;
	}
	if (_tmp42_) {
		vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations);
		if (!vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
			vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->header_declarations);
		}
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
			vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->internal_header_declarations);
		}
	}
	((ValaCCodeBaseModule*) self)->function = (_tmp46_ = vala_ccode_function_new (_tmp45_ = vala_method_get_real_cname (m), "void"), _vala_ccode_node_unref0 (((ValaCCodeBaseModule*) self)->function), _tmp46_);
	_g_free0 (_tmp45_);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | VALA_CCODE_MODIFIERS_INLINE);
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, ((ValaCCodeBaseModule*) self)->function, NULL, NULL, NULL, 3);
	_tmp47_ = FALSE;
	if (!vala_method_get_is_abstract (m)) {
		_tmp47_ = TRUE;
	} else {
		gboolean _tmp48_;
		_tmp48_ = FALSE;
		if (vala_method_get_is_abstract (m)) {
			_tmp48_ = VALA_IS_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self));
		} else {
			_tmp48_ = FALSE;
		}
		_tmp47_ = _tmp48_;
	}
	if (_tmp47_) {
		if (!vala_method_get_coroutine (m)) {
			gboolean _tmp49_;
			_tmp49_ = FALSE;
			if (vala_method_get_base_method (m) != NULL) {
				_tmp49_ = TRUE;
			} else {
				_tmp49_ = vala_method_get_base_interface_method (m) != NULL;
			}
			if (_tmp49_) {
				ValaCCodeFunction* _tmp50_;
				vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp50_ = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
				_vala_ccode_node_unref0 (_tmp50_);
			} else {
				if (vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
					vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | VALA_CCODE_MODIFIERS_STATIC);
				}
			}
		}
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			gboolean _tmp122_;
			gboolean _tmp123_;
			gboolean _tmp226_;
			vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_get_body (m))));
			vala_ccode_node_set_line ((ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) cinit);
			if (vala_method_get_coroutine (m)) {
				char* _tmp52_;
				char* _tmp51_;
				ValaCCodeFunction* _tmp53_;
				ValaCCodeFunction* co_function;
				ValaCCodeFormalParameter* _tmp57_;
				char* _tmp56_;
				char* _tmp55_;
				char* _tmp54_;
				ValaCCodeFunction* _tmp58_;
				ValaCCodeMemberAccess* _tmp60_;
				ValaCCodeIdentifier* _tmp59_;
				ValaCCodeSwitchStatement* _tmp61_;
				ValaCCodeSwitchStatement* cswitch;
				ValaCCodeLabel* _tmp62_;
				ValaCCodeExpressionStatement* _tmp65_;
				ValaCCodeFunctionCall* _tmp64_;
				ValaCCodeIdentifier* _tmp63_;
				ValaCCodeCaseStatement* _tmp67_;
				ValaCCodeConstant* _tmp66_;
				ValaCCodeStatement* _tmp68_;
				ValaCCodeBlock* _tmp69_;
				co_function = (_tmp53_ = vala_ccode_function_new (_tmp52_ = g_strconcat (_tmp51_ = vala_method_get_real_cname (m), "_co", NULL), "gboolean"), _g_free0 (_tmp52_), _g_free0 (_tmp51_), _tmp53_);
				vala_ccode_function_add_parameter (co_function, _tmp57_ = vala_ccode_formal_parameter_new ("data", _tmp56_ = g_strconcat (_tmp55_ = vala_symbol_lower_case_to_camel_case (_tmp54_ = vala_method_get_cname (m)), "Data*", NULL)));
				_vala_ccode_node_unref0 (_tmp57_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp54_);
				vala_ccode_function_set_modifiers (co_function, vala_ccode_function_get_modifiers (co_function) | VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp58_ = vala_ccode_function_copy (co_function)));
				_vala_ccode_node_unref0 (_tmp58_);
				cswitch = (_tmp61_ = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp60_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("data")), "_state_"))), _vala_ccode_node_unref0 (_tmp60_), _vala_ccode_node_unref0 (_tmp59_), _tmp61_);
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp62_ = vala_ccode_label_new ("default")));
				_vala_ccode_node_unref0 (_tmp62_);
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp65_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp63_ = vala_ccode_identifier_new ("g_assert_not_reached")))))));
				_vala_ccode_node_unref0 (_tmp65_);
				_vala_ccode_node_unref0 (_tmp64_);
				_vala_ccode_node_unref0 (_tmp63_);
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp67_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp66_ = vala_ccode_constant_new ("0")))));
				_vala_ccode_node_unref0 (_tmp67_);
				_vala_ccode_node_unref0 (_tmp66_);
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function));
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp68_ = vala_ccode_method_module_complete_async (self)));
				_vala_ccode_node_unref0 (_tmp68_);
				vala_ccode_function_set_block (co_function, _tmp69_ = vala_ccode_block_new ());
				_vala_ccode_node_unref0 (_tmp69_);
				vala_ccode_block_add_statement (vala_ccode_function_get_block (co_function), (ValaCCodeNode*) cswitch);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) co_function);
				_vala_ccode_node_unref0 (co_function);
				_vala_ccode_node_unref0 (cswitch);
			}
			if (vala_method_get_closure (m)) {
				ValaSymbol* _tmp70_;
				ValaBlock* closure_block;
				gint block_id;
				closure_block = _vala_code_node_ref0 ((_tmp70_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_BLOCK (_tmp70_) ? ((ValaBlock*) _tmp70_) : NULL));
				while (TRUE) {
					gboolean _tmp71_;
					ValaBlock* _tmp73_;
					ValaSymbol* _tmp72_;
					_tmp71_ = FALSE;
					if (closure_block != NULL) {
						_tmp71_ = !vala_block_get_captured (closure_block);
					} else {
						_tmp71_ = FALSE;
					}
					if (!_tmp71_) {
						break;
					}
					closure_block = (_tmp73_ = _vala_code_node_ref0 ((_tmp72_ = vala_symbol_get_parent_symbol ((ValaSymbol*) closure_block), VALA_IS_BLOCK (_tmp72_) ? ((ValaBlock*) _tmp72_) : NULL)), _vala_code_node_unref0 (closure_block), _tmp73_);
				}
				block_id = vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, closure_block);
				while (TRUE) {
					ValaSymbol* _tmp74_;
					ValaBlock* parent_closure_block;
					gint parent_block_id;
					char* _tmp80_;
					ValaCCodeExpression* _tmp79_;
					char* _tmp78_;
					ValaCCodeMemberAccess* _tmp81_;
					ValaCCodeMemberAccess* parent_data;
					char* _tmp82_;
					ValaCCodeDeclaration* _tmp83_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp85_;
					char* _tmp84_;
					ValaBlock* _tmp86_;
					parent_closure_block = _vala_code_node_ref0 ((_tmp74_ = vala_symbol_get_parent_symbol ((ValaSymbol*) closure_block), VALA_IS_BLOCK (_tmp74_) ? ((ValaBlock*) _tmp74_) : NULL));
					while (TRUE) {
						gboolean _tmp75_;
						ValaBlock* _tmp77_;
						ValaSymbol* _tmp76_;
						_tmp75_ = FALSE;
						if (parent_closure_block != NULL) {
							_tmp75_ = !vala_block_get_captured (parent_closure_block);
						} else {
							_tmp75_ = FALSE;
						}
						if (!_tmp75_) {
							break;
						}
						parent_closure_block = (_tmp77_ = _vala_code_node_ref0 ((_tmp76_ = vala_symbol_get_parent_symbol ((ValaSymbol*) parent_closure_block), VALA_IS_BLOCK (_tmp76_) ? ((ValaBlock*) _tmp76_) : NULL)), _vala_code_node_unref0 (parent_closure_block), _tmp77_);
					}
					if (parent_closure_block == NULL) {
						_vala_code_node_unref0 (parent_closure_block);
						break;
					}
					parent_block_id = vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, parent_closure_block);
					parent_data = (_tmp81_ = vala_ccode_member_access_new_pointer (_tmp79_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp78_ = g_strdup_printf ("_data%d_", block_id)), _tmp80_ = g_strdup_printf ("_data%d_", parent_block_id)), _g_free0 (_tmp80_), _vala_ccode_node_unref0 (_tmp79_), _g_free0 (_tmp78_), _tmp81_);
					_cdecl_ = (_tmp83_ = vala_ccode_declaration_new (_tmp82_ = g_strdup_printf ("Block%dData*", parent_block_id)), _g_free0 (_tmp82_), _tmp83_);
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp85_ = vala_ccode_variable_declarator_new (_tmp84_ = g_strdup_printf ("_data%d_", parent_block_id), (ValaCCodeExpression*) parent_data, NULL)));
					_vala_ccode_node_unref0 (_tmp85_);
					_g_free0 (_tmp84_);
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) _cdecl_);
					closure_block = (_tmp86_ = _vala_code_node_ref0 (parent_closure_block), _vala_code_node_unref0 (closure_block), _tmp86_);
					block_id = parent_block_id;
					_vala_code_node_unref0 (parent_closure_block);
					_vala_ccode_node_unref0 (parent_data);
					_vala_ccode_node_unref0 (_cdecl_);
				}
				if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
					ValaCCodeExpression* _tmp88_;
					char* _tmp87_;
					ValaCCodeMemberAccess* _tmp89_;
					ValaCCodeMemberAccess* cself;
					char* _tmp91_;
					char* _tmp90_;
					ValaCCodeDeclaration* _tmp92_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp93_;
					cself = (_tmp89_ = vala_ccode_member_access_new_pointer (_tmp88_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp87_ = g_strdup_printf ("_data%d_", block_id)), "self"), _vala_ccode_node_unref0 (_tmp88_), _g_free0 (_tmp87_), _tmp89_);
					_cdecl_ = (_tmp92_ = vala_ccode_declaration_new (_tmp91_ = g_strdup_printf ("%s *", _tmp90_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self), FALSE))), _g_free0 (_tmp91_), _g_free0 (_tmp90_), _tmp92_);
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp93_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) cself, NULL)));
					_vala_ccode_node_unref0 (_tmp93_);
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) _cdecl_);
					_vala_ccode_node_unref0 (cself);
					_vala_ccode_node_unref0 (_cdecl_);
				}
				_vala_code_node_unref0 (closure_block);
			} else {
				gboolean _tmp94_;
				_tmp94_ = FALSE;
				if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
					_tmp94_ = !vala_method_get_coroutine (m);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaClass* cl;
					gboolean _tmp95_;
					cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
					_tmp95_ = FALSE;
					if (vala_method_get_overrides (m)) {
						_tmp95_ = TRUE;
					} else {
						gboolean _tmp96_;
						gboolean _tmp97_;
						_tmp96_ = FALSE;
						_tmp97_ = FALSE;
						if (vala_method_get_base_interface_method (m) != NULL) {
							_tmp97_ = !vala_method_get_is_abstract (m);
						} else {
							_tmp97_ = FALSE;
						}
						if (_tmp97_) {
							_tmp96_ = !vala_method_get_is_virtual (m);
						} else {
							_tmp96_ = FALSE;
						}
						_tmp95_ = _tmp96_;
					}
					if (_tmp95_) {
						ValaMethod* base_method;
						ValaReferenceType* base_expression_type;
						ValaObjectType* self_target_type;
						ValaCCodeIdentifier* _tmp102_;
						ValaCCodeExpression* _tmp103_;
						ValaCCodeExpression* cself;
						char* _tmp105_;
						char* _tmp104_;
						ValaCCodeDeclaration* _tmp106_;
						ValaCCodeDeclaration* _cdecl_;
						ValaCCodeVariableDeclarator* _tmp107_;
						base_method = NULL;
						base_expression_type = NULL;
						if (vala_method_get_overrides (m)) {
							ValaMethod* _tmp98_;
							ValaReferenceType* _tmp99_;
							base_method = (_tmp98_ = _vala_code_node_ref0 (vala_method_get_base_method (m)), _vala_code_node_unref0 (base_method), _tmp98_);
							base_expression_type = (_tmp99_ = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), _vala_code_node_unref0 (base_expression_type), _tmp99_);
						} else {
							ValaMethod* _tmp100_;
							ValaReferenceType* _tmp101_;
							base_method = (_tmp100_ = _vala_code_node_ref0 (vala_method_get_base_interface_method (m)), _vala_code_node_unref0 (base_method), _tmp100_);
							base_expression_type = (_tmp101_ = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), _vala_code_node_unref0 (base_expression_type), _tmp101_);
						}
						self_target_type = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
						cself = (_tmp103_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new ("base")), (ValaDataType*) base_expression_type, (ValaDataType*) self_target_type, NULL), _vala_ccode_node_unref0 (_tmp102_), _tmp103_);
						_cdecl_ = (_tmp106_ = vala_ccode_declaration_new (_tmp105_ = g_strdup_printf ("%s *", _tmp104_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _g_free0 (_tmp105_), _g_free0 (_tmp104_), _tmp106_);
						vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp107_ = vala_ccode_variable_declarator_new ("self", cself, NULL)));
						_vala_ccode_node_unref0 (_tmp107_);
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) _cdecl_);
						_vala_code_node_unref0 (base_method);
						_vala_code_node_unref0 (base_expression_type);
						_vala_code_node_unref0 (self_target_type);
						_vala_ccode_node_unref0 (cself);
						_vala_ccode_node_unref0 (_cdecl_);
					} else {
						gboolean _tmp108_;
						_tmp108_ = FALSE;
						if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
							_tmp108_ = !VALA_IS_CREATION_METHOD (m);
						} else {
							_tmp108_ = FALSE;
						}
						if (_tmp108_) {
							ValaCCodeStatement* ccheckstmt;
							ccheckstmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, (ValaTypeSymbol*) cl, TRUE, "self");
							if (ccheckstmt != NULL) {
								vala_ccode_node_set_line ((ValaCCodeNode*) ccheckstmt, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ccheckstmt);
							}
							_vala_ccode_node_unref0 (ccheckstmt);
						}
					}
					_vala_code_node_unref0 (cl);
				}
			}
			{
				GeeList* _tmp109_;
				GeeIterator* _tmp110_;
				GeeIterator* _param_it;
				_param_it = (_tmp110_ = gee_iterable_iterator ((GeeIterable*) (_tmp109_ = vala_method_get_parameters (m))), _gee_collection_object_unref0 (_tmp109_), _tmp110_);
				while (TRUE) {
					ValaFormalParameter* param;
					ValaTypeSymbol* t;
					gboolean _tmp111_;
					if (!gee_iterator_next (_param_it)) {
						break;
					}
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					if (vala_formal_parameter_get_ellipsis (param)) {
						_vala_code_node_unref0 (param);
						break;
					}
					t = _vala_code_node_ref0 (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)));
					_tmp111_ = FALSE;
					if (t != NULL) {
						_tmp111_ = vala_typesymbol_is_reference_type (t);
					} else {
						_tmp111_ = FALSE;
					}
					if (_tmp111_) {
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
							char* _tmp112_;
							ValaCCodeStatement* _tmp113_;
							ValaCCodeStatement* type_check;
							type_check = (_tmp113_ = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, t, !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param)), _tmp112_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), _g_free0 (_tmp112_), _tmp113_);
							if (type_check != NULL) {
								vala_ccode_node_set_line ((ValaCCodeNode*) type_check, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) type_check);
							}
							_vala_ccode_node_unref0 (type_check);
						} else {
							if (!vala_method_get_coroutine (m)) {
								ValaCCodeConstant* _tmp116_;
								ValaCCodeUnaryExpression* _tmp115_;
								ValaCCodeExpression* _tmp114_;
								ValaCCodeAssignment* _tmp117_;
								ValaCCodeAssignment* a;
								ValaCCodeBlock* cblock;
								ValaCCodeExpressionStatement* _tmp118_;
								ValaCCodeConstant* _tmp120_;
								ValaCCodeExpression* _tmp119_;
								ValaCCodeBinaryExpression* _tmp121_;
								ValaCCodeBinaryExpression* condition;
								ValaCCodeIfStatement* if_statement;
								a = (_tmp117_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp115_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, _tmp114_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), (ValaCCodeExpression*) (_tmp116_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (_tmp116_), _vala_ccode_node_unref0 (_tmp115_), _vala_ccode_node_unref0 (_tmp114_), _tmp117_);
								cblock = vala_ccode_block_new ();
								vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp118_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) a)));
								_vala_ccode_node_unref0 (_tmp118_);
								condition = (_tmp121_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp119_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), (ValaCCodeExpression*) (_tmp120_ = vala_ccode_constant_new ("NULL"))), _vala_ccode_node_unref0 (_tmp120_), _vala_ccode_node_unref0 (_tmp119_), _tmp121_);
								if_statement = vala_ccode_if_statement_new ((ValaCCodeExpression*) condition, (ValaCCodeStatement*) cblock, NULL);
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) if_statement);
								_vala_ccode_node_unref0 (a);
								_vala_ccode_node_unref0 (cblock);
								_vala_ccode_node_unref0 (condition);
								_vala_ccode_node_unref0 (if_statement);
							}
						}
					}
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (t);
				}
				_gee_collection_object_unref0 (_param_it);
			}
			_tmp122_ = FALSE;
			_tmp123_ = FALSE;
			if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
				_tmp123_ = !vala_data_type_is_real_non_null_struct_type (vala_method_get_return_type (m));
			} else {
				_tmp123_ = FALSE;
			}
			if (_tmp123_) {
				_tmp122_ = !vala_method_get_coroutine (m);
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				gboolean _tmp124_;
				_tmp124_ = FALSE;
				if (vala_method_get_exit_block (m) == NULL) {
					_tmp124_ = TRUE;
				} else {
					GeeList* _tmp125_;
					_tmp124_ = gee_collection_get_size ((GeeCollection*) (_tmp125_ = vala_basic_block_get_predecessors (vala_method_get_exit_block (m)))) > 0;
					_gee_collection_object_unref0 (_tmp125_);
				}
				if (_tmp124_) {
					char* _tmp126_;
					ValaCCodeDeclaration* _tmp127_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp128_;
					_cdecl_ = (_tmp127_ = vala_ccode_declaration_new (_tmp126_ = vala_data_type_get_cname (vala_method_get_return_type (m))), _g_free0 (_tmp126_), _tmp127_);
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp128_ = vala_ccode_variable_declarator_new ("result", NULL, NULL)));
					_vala_ccode_node_unref0 (_tmp128_);
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) _cdecl_);
					_vala_ccode_node_unref0 (_cdecl_);
				}
			}
			if (inner_error) {
				if (vala_method_get_coroutine (m)) {
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "GError *", "_inner_error_");
				} else {
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp130_;
					ValaCCodeConstant* _tmp129_;
					_cdecl_ = vala_ccode_declaration_new ("GError *");
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp130_ = vala_ccode_variable_declarator_new ("_inner_error_", (ValaCCodeExpression*) (_tmp129_ = vala_ccode_constant_new ("NULL")), NULL)));
					_vala_ccode_node_unref0 (_tmp130_);
					_vala_ccode_node_unref0 (_tmp129_);
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) _cdecl_);
					_vala_ccode_node_unref0 (_cdecl_);
				}
			}
			if (!vala_method_get_coroutine (m)) {
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
			}
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					n_params = vala_creation_method_get_n_construction_params (VALA_CREATION_METHOD (m));
					if (!vala_creation_method_get_chain_up (VALA_CREATION_METHOD (m))) {
						gboolean _tmp131_;
						_tmp131_ = FALSE;
						if (n_params > 0) {
							_tmp131_ = TRUE;
						} else {
							GeeList* _tmp132_;
							_tmp131_ = gee_collection_get_size ((GeeCollection*) (_tmp132_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)))) > 0;
							_gee_collection_object_unref0 (_tmp132_);
						}
						if (_tmp131_) {
							ValaCCodeIdentifier* _tmp133_;
							ValaCCodeFunctionCall* _tmp134_;
							ValaCCodeFunctionCall* cparamsinit;
							ValaCCodeIdentifier* _tmp135_;
							ValaCCodeConstant* _tmp138_;
							char* _tmp137_;
							GeeList* _tmp136_;
							ValaCCodeDeclaration* _cdecl_;
							ValaCCodeVariableDeclarator* _tmp139_;
							ValaCCodeDeclaration* _tmp140_;
							ValaCCodeVariableDeclarator* _tmp142_;
							ValaCCodeIdentifier* _tmp141_;
							cparamsinit = (_tmp134_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp133_ = vala_ccode_identifier_new ("g_new0"))), _vala_ccode_node_unref0 (_tmp133_), _tmp134_);
							vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp135_ = vala_ccode_identifier_new ("GParameter")));
							_vala_ccode_node_unref0 (_tmp135_);
							vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp138_ = vala_ccode_constant_new (_tmp137_ = g_strdup_printf ("%i", n_params + (3 * gee_collection_get_size ((GeeCollection*) (_tmp136_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)))))))));
							_vala_ccode_node_unref0 (_tmp138_);
							_g_free0 (_tmp137_);
							_gee_collection_object_unref0 (_tmp136_);
							_cdecl_ = vala_ccode_declaration_new ("GParameter *");
							vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp139_ = vala_ccode_variable_declarator_new ("__params", (ValaCCodeExpression*) cparamsinit, NULL)));
							_vala_ccode_node_unref0 (_tmp139_);
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) _cdecl_);
							_cdecl_ = (_tmp140_ = vala_ccode_declaration_new ("GParameter *"), _vala_ccode_node_unref0 (_cdecl_), _tmp140_);
							vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp142_ = vala_ccode_variable_declarator_new ("__params_it", (ValaCCodeExpression*) (_tmp141_ = vala_ccode_identifier_new ("__params")), NULL)));
							_vala_ccode_node_unref0 (_tmp142_);
							_vala_ccode_node_unref0 (_tmp141_);
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) _cdecl_);
							_vala_ccode_node_unref0 (cparamsinit);
							_vala_ccode_node_unref0 (_cdecl_);
						}
						{
							GeeList* _tmp143_;
							GeeIterator* _tmp144_;
							GeeIterator* _type_param_it;
							_type_param_it = (_tmp144_ = gee_iterable_iterator ((GeeIterable*) (_tmp143_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)))), _gee_collection_object_unref0 (_tmp143_), _tmp144_);
							while (TRUE) {
								ValaTypeParameter* type_param;
								ValaCCodeConstant* prop_name;
								ValaCCodeIdentifier* param_name;
								ValaCCodeConstant* _tmp147_;
								char* _tmp146_;
								char* _tmp145_;
								ValaCCodeIdentifier* _tmp150_;
								char* _tmp149_;
								char* _tmp148_;
								ValaCCodeExpressionStatement* _tmp153_;
								ValaCCodeExpression* _tmp152_;
								ValaIntegerType* _tmp151_;
								ValaCCodeConstant* _tmp156_;
								char* _tmp155_;
								char* _tmp154_;
								ValaCCodeIdentifier* _tmp159_;
								char* _tmp158_;
								char* _tmp157_;
								ValaCCodeExpressionStatement* _tmp163_;
								ValaCCodeExpression* _tmp162_;
								ValaPointerType* _tmp161_;
								ValaVoidType* _tmp160_;
								ValaCCodeConstant* _tmp166_;
								char* _tmp165_;
								char* _tmp164_;
								ValaCCodeIdentifier* _tmp169_;
								char* _tmp168_;
								char* _tmp167_;
								ValaCCodeExpressionStatement* _tmp173_;
								ValaCCodeExpression* _tmp172_;
								ValaPointerType* _tmp171_;
								ValaVoidType* _tmp170_;
								if (!gee_iterator_next (_type_param_it)) {
									break;
								}
								type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
								prop_name = NULL;
								param_name = NULL;
								prop_name = (_tmp147_ = vala_ccode_constant_new (_tmp146_ = g_strdup_printf ("\"%s-type\"", _tmp145_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (prop_name), _tmp147_);
								_g_free0 (_tmp146_);
								_g_free0 (_tmp145_);
								param_name = (_tmp150_ = vala_ccode_identifier_new (_tmp149_ = g_strdup_printf ("%s_type", _tmp148_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (param_name), _tmp150_);
								_g_free0 (_tmp149_);
								_g_free0 (_tmp148_);
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp153_ = vala_ccode_expression_statement_new (_tmp152_ = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp151_ = vala_integer_type_new (VALA_STRUCT (((ValaCCodeBaseModule*) self)->gtype_type), NULL, NULL)), (ValaCCodeExpression*) param_name))));
								_vala_ccode_node_unref0 (_tmp153_);
								_vala_ccode_node_unref0 (_tmp152_);
								_vala_code_node_unref0 (_tmp151_);
								prop_name = (_tmp156_ = vala_ccode_constant_new (_tmp155_ = g_strdup_printf ("\"%s-dup-func\"", _tmp154_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (prop_name), _tmp156_);
								_g_free0 (_tmp155_);
								_g_free0 (_tmp154_);
								param_name = (_tmp159_ = vala_ccode_identifier_new (_tmp158_ = g_strdup_printf ("%s_dup_func", _tmp157_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (param_name), _tmp159_);
								_g_free0 (_tmp158_);
								_g_free0 (_tmp157_);
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp163_ = vala_ccode_expression_statement_new (_tmp162_ = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp161_ = vala_pointer_type_new ((ValaDataType*) (_tmp160_ = vala_void_type_new (NULL)), NULL)), (ValaCCodeExpression*) param_name))));
								_vala_ccode_node_unref0 (_tmp163_);
								_vala_ccode_node_unref0 (_tmp162_);
								_vala_code_node_unref0 (_tmp161_);
								_vala_code_node_unref0 (_tmp160_);
								prop_name = (_tmp166_ = vala_ccode_constant_new (_tmp165_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp164_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (prop_name), _tmp166_);
								_g_free0 (_tmp165_);
								_g_free0 (_tmp164_);
								param_name = (_tmp169_ = vala_ccode_identifier_new (_tmp168_ = g_strdup_printf ("%s_destroy_func", _tmp167_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (param_name), _tmp169_);
								_g_free0 (_tmp168_);
								_g_free0 (_tmp167_);
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp173_ = vala_ccode_expression_statement_new (_tmp172_ = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp171_ = vala_pointer_type_new ((ValaDataType*) (_tmp170_ = vala_void_type_new (NULL)), NULL)), (ValaCCodeExpression*) param_name))));
								_vala_ccode_node_unref0 (_tmp173_);
								_vala_ccode_node_unref0 (_tmp172_);
								_vala_code_node_unref0 (_tmp171_);
								_vala_code_node_unref0 (_tmp170_);
								_vala_code_node_unref0 (type_param);
								_vala_ccode_node_unref0 (prop_name);
								_vala_ccode_node_unref0 (param_name);
							}
							_gee_collection_object_unref0 (_type_param_it);
						}
					}
				} else {
					if (vala_ccode_method_module_is_gtypeinstance_creation_method (self, m)) {
						ValaClass* cl;
						char* _tmp175_;
						char* _tmp174_;
						ValaCCodeDeclaration* _tmp176_;
						ValaCCodeDeclaration* cdeclaration;
						ValaCCodeVariableDeclarator* _cdecl_;
						cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
						cdeclaration = (_tmp176_ = vala_ccode_declaration_new (_tmp175_ = g_strconcat (_tmp174_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _g_free0 (_tmp175_), _g_free0 (_tmp174_), _tmp176_);
						_cdecl_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
						vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) _cdecl_);
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdeclaration);
						if (!vala_creation_method_get_chain_up (VALA_CREATION_METHOD (m))) {
							ValaCCodeIdentifier* _tmp177_;
							ValaCCodeFunctionCall* _tmp178_;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp179_;
							ValaCCodeCastExpression* _tmp182_;
							char* _tmp181_;
							char* _tmp180_;
							ccall = (_tmp178_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp177_ = vala_ccode_identifier_new ("g_type_create_instance"))), _vala_ccode_node_unref0 (_tmp177_), _tmp178_);
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp179_ = vala_ccode_identifier_new ("object_type")));
							_vala_ccode_node_unref0 (_tmp179_);
							vala_ccode_variable_declarator_set_initializer (_cdecl_, (ValaCCodeExpression*) (_tmp182_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp181_ = g_strconcat (_tmp180_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL))));
							_vala_ccode_node_unref0 (_tmp182_);
							_g_free0 (_tmp181_);
							_g_free0 (_tmp180_);
							{
								GeeList* _tmp183_;
								GeeIterator* _tmp184_;
								GeeIterator* _type_param_it;
								_type_param_it = (_tmp184_ = gee_iterable_iterator ((GeeIterable*) (_tmp183_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)))), _gee_collection_object_unref0 (_tmp183_), _tmp184_);
								while (TRUE) {
									ValaTypeParameter* type_param;
									ValaCCodeIdentifier* param_name;
									ValaCCodeAssignment* assign;
									ValaCCodeIdentifier* _tmp185_;
									ValaCCodeMemberAccess* _tmp186_;
									ValaCCodeMemberAccess* priv_access;
									ValaCCodeIdentifier* _tmp189_;
									char* _tmp188_;
									char* _tmp187_;
									ValaCCodeAssignment* _tmp191_;
									ValaCCodeMemberAccess* _tmp190_;
									ValaCCodeExpressionStatement* _tmp192_;
									ValaCCodeIdentifier* _tmp195_;
									char* _tmp194_;
									char* _tmp193_;
									ValaCCodeAssignment* _tmp197_;
									ValaCCodeMemberAccess* _tmp196_;
									ValaCCodeExpressionStatement* _tmp198_;
									ValaCCodeIdentifier* _tmp201_;
									char* _tmp200_;
									char* _tmp199_;
									ValaCCodeAssignment* _tmp203_;
									ValaCCodeMemberAccess* _tmp202_;
									ValaCCodeExpressionStatement* _tmp204_;
									if (!gee_iterator_next (_type_param_it)) {
										break;
									}
									type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
									param_name = NULL;
									assign = NULL;
									priv_access = (_tmp186_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp185_ = vala_ccode_identifier_new ("self")), "priv"), _vala_ccode_node_unref0 (_tmp185_), _tmp186_);
									param_name = (_tmp189_ = vala_ccode_identifier_new (_tmp188_ = g_strdup_printf ("%s_type", _tmp187_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (param_name), _tmp189_);
									_g_free0 (_tmp188_);
									_g_free0 (_tmp187_);
									assign = (_tmp191_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp190_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (assign), _tmp191_);
									_vala_ccode_node_unref0 (_tmp190_);
									vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp192_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
									_vala_ccode_node_unref0 (_tmp192_);
									param_name = (_tmp195_ = vala_ccode_identifier_new (_tmp194_ = g_strdup_printf ("%s_dup_func", _tmp193_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (param_name), _tmp195_);
									_g_free0 (_tmp194_);
									_g_free0 (_tmp193_);
									assign = (_tmp197_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp196_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (assign), _tmp197_);
									_vala_ccode_node_unref0 (_tmp196_);
									vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp198_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
									_vala_ccode_node_unref0 (_tmp198_);
									param_name = (_tmp201_ = vala_ccode_identifier_new (_tmp200_ = g_strdup_printf ("%s_destroy_func", _tmp199_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), _vala_ccode_node_unref0 (param_name), _tmp201_);
									_g_free0 (_tmp200_);
									_g_free0 (_tmp199_);
									assign = (_tmp203_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp202_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (assign), _tmp203_);
									_vala_ccode_node_unref0 (_tmp202_);
									vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp204_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
									_vala_ccode_node_unref0 (_tmp204_);
									_vala_code_node_unref0 (type_param);
									_vala_ccode_node_unref0 (param_name);
									_vala_ccode_node_unref0 (assign);
									_vala_ccode_node_unref0 (priv_access);
								}
								_gee_collection_object_unref0 (_type_param_it);
							}
							_vala_ccode_node_unref0 (ccall);
						}
						_vala_code_node_unref0 (cl);
						_vala_ccode_node_unref0 (cdeclaration);
						_vala_ccode_node_unref0 (_cdecl_);
					} else {
						if (VALA_IS_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self))) {
							ValaClass* cl;
							char* _tmp206_;
							char* _tmp205_;
							ValaCCodeDeclaration* _tmp207_;
							ValaCCodeDeclaration* cdeclaration;
							ValaCCodeVariableDeclarator* _cdecl_;
							cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
							cdeclaration = (_tmp207_ = vala_ccode_declaration_new (_tmp206_ = g_strconcat (_tmp205_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _g_free0 (_tmp206_), _g_free0 (_tmp205_), _tmp207_);
							_cdecl_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
							vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) _cdecl_);
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdeclaration);
							if (!vala_creation_method_get_chain_up (VALA_CREATION_METHOD (m))) {
								ValaCCodeIdentifier* _tmp208_;
								ValaCCodeFunctionCall* _tmp209_;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp211_;
								char* _tmp210_;
								ccall = (_tmp209_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp208_ = vala_ccode_identifier_new ("g_slice_new0"))), _vala_ccode_node_unref0 (_tmp208_), _tmp209_);
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp211_ = vala_ccode_identifier_new (_tmp210_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
								_vala_ccode_node_unref0 (_tmp211_);
								_g_free0 (_tmp210_);
								vala_ccode_variable_declarator_set_initializer (_cdecl_, (ValaCCodeExpression*) ccall);
								_vala_ccode_node_unref0 (ccall);
							}
							if (vala_class_get_base_class (cl) == NULL) {
								ValaCCodeIdentifier* _tmp214_;
								char* _tmp213_;
								char* _tmp212_;
								ValaCCodeFunctionCall* _tmp215_;
								ValaCCodeFunctionCall* cinitcall;
								ValaCCodeIdentifier* _tmp216_;
								ValaCCodeExpressionStatement* _tmp217_;
								cinitcall = (_tmp215_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp214_ = vala_ccode_identifier_new (_tmp213_ = g_strdup_printf ("%s_instance_init", _tmp212_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL))))), _vala_ccode_node_unref0 (_tmp214_), _g_free0 (_tmp213_), _g_free0 (_tmp212_), _tmp215_);
								vala_ccode_function_call_add_argument (cinitcall, (ValaCCodeExpression*) (_tmp216_ = vala_ccode_identifier_new ("self")));
								_vala_ccode_node_unref0 (_tmp216_);
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp217_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinitcall)));
								_vala_ccode_node_unref0 (_tmp217_);
								_vala_ccode_node_unref0 (cinitcall);
							}
							_vala_code_node_unref0 (cl);
							_vala_ccode_node_unref0 (cdeclaration);
							_vala_ccode_node_unref0 (_cdecl_);
						} else {
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp218_;
							ValaCCodeFunctionCall* _tmp219_;
							ValaCCodeFunctionCall* czero;
							ValaCCodeIdentifier* _tmp220_;
							ValaCCodeConstant* _tmp221_;
							ValaCCodeIdentifier* _tmp224_;
							char* _tmp223_;
							char* _tmp222_;
							ValaCCodeExpressionStatement* _tmp225_;
							st = _vala_code_node_ref0 (VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
							vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
							czero = (_tmp219_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp218_ = vala_ccode_identifier_new ("memset"))), _vala_ccode_node_unref0 (_tmp218_), _tmp219_);
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp220_ = vala_ccode_identifier_new ("self")));
							_vala_ccode_node_unref0 (_tmp220_);
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp221_ = vala_ccode_constant_new ("0")));
							_vala_ccode_node_unref0 (_tmp221_);
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp224_ = vala_ccode_identifier_new (_tmp223_ = g_strdup_printf ("sizeof (%s)", _tmp222_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)))));
							_vala_ccode_node_unref0 (_tmp224_);
							_g_free0 (_tmp223_);
							_g_free0 (_tmp222_);
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp225_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero)));
							_vala_ccode_node_unref0 (_tmp225_);
							_vala_code_node_unref0 (st);
							_vala_ccode_node_unref0 (czero);
						}
					}
				}
			}
			_tmp226_ = FALSE;
			if (vala_code_context_get_module_init_method (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == m) {
				_tmp226_ = ((ValaCCodeBaseModule*) self)->in_plugin;
			} else {
				_tmp226_ = FALSE;
			}
			if (_tmp226_) {
				vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->module_init_fragment);
			}
			{
				GeeList* _tmp227_;
				GeeIterator* _tmp228_;
				GeeIterator* _precondition_it;
				_precondition_it = (_tmp228_ = gee_iterable_iterator ((GeeIterable*) (_tmp227_ = vala_method_get_preconditions (m))), _gee_collection_object_unref0 (_tmp227_), _tmp228_);
				while (TRUE) {
					ValaExpression* precondition;
					ValaCCodeStatement* check_stmt;
					if (!gee_iterator_next (_precondition_it)) {
						break;
					}
					precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
					check_stmt = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, creturn_type, precondition);
					if (check_stmt != NULL) {
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) check_stmt);
					}
					_vala_code_node_unref0 (precondition);
					_vala_ccode_node_unref0 (check_stmt);
				}
				_gee_collection_object_unref0 (_precondition_it);
			}
			_vala_ccode_node_unref0 (cinit);
		} else {
			if (vala_method_get_is_abstract (m)) {
				ValaCCodeBlock* cblock;
				ValaCCodeStatement* check_stmt;
				ValaCCodeIdentifier* _tmp229_;
				ValaCCodeFunctionCall* _tmp230_;
				ValaCCodeFunctionCall* type_from_instance_call;
				ValaCCodeIdentifier* _tmp231_;
				ValaCCodeIdentifier* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeFunctionCall* type_name_call;
				char* _tmp234_;
				char* _tmp235_;
				char* error_string;
				ValaCCodeIdentifier* _tmp236_;
				ValaCCodeFunctionCall* _tmp237_;
				ValaCCodeFunctionCall* cerrorcall;
				ValaCCodeConstant* _tmp238_;
				ValaCCodeExpressionStatement* _tmp239_;
				ValaCCodeReturnStatement* _tmp241_;
				ValaCCodeExpression* _tmp240_;
				cblock = vala_ccode_block_new ();
				check_stmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self), TRUE, "self");
				if (check_stmt != NULL) {
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) check_stmt);
				}
				type_from_instance_call = (_tmp230_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp229_ = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), _vala_ccode_node_unref0 (_tmp229_), _tmp230_);
				vala_ccode_function_call_add_argument (type_from_instance_call, (ValaCCodeExpression*) (_tmp231_ = vala_ccode_identifier_new ("self")));
				_vala_ccode_node_unref0 (_tmp231_);
				type_name_call = (_tmp233_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp232_ = vala_ccode_identifier_new ("g_type_name"))), _vala_ccode_node_unref0 (_tmp232_), _tmp233_);
				vala_ccode_function_call_add_argument (type_name_call, (ValaCCodeExpression*) type_from_instance_call);
				error_string = (_tmp235_ = g_strdup_printf ("\"Type `%%s' does not implement abstract method `%s'\"", _tmp234_ = vala_method_get_cname (m)), _g_free0 (_tmp234_), _tmp235_);
				cerrorcall = (_tmp237_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp236_ = vala_ccode_identifier_new ("g_critical"))), _vala_ccode_node_unref0 (_tmp236_), _tmp237_);
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) (_tmp238_ = vala_ccode_constant_new (error_string)));
				_vala_ccode_node_unref0 (_tmp238_);
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) type_name_call);
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp239_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cerrorcall)));
				_vala_ccode_node_unref0 (_tmp239_);
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp241_ = vala_ccode_return_statement_new (_tmp240_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, creturn_type, FALSE))));
				_vala_ccode_node_unref0 (_tmp241_);
				_vala_ccode_node_unref0 (_tmp240_);
				vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, cblock);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
				_vala_ccode_node_unref0 (cblock);
				_vala_ccode_node_unref0 (check_stmt);
				_vala_ccode_node_unref0 (type_from_instance_call);
				_vala_ccode_node_unref0 (type_name_call);
				_g_free0 (error_string);
				_vala_ccode_node_unref0 (cerrorcall);
			}
		}
	}
	_tmp242_ = FALSE;
	_tmp243_ = FALSE;
	_tmp244_ = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp244_ = TRUE;
	} else {
		_tmp244_ = vala_method_get_is_virtual (m);
	}
	if (_tmp244_) {
		_tmp243_ = !vala_method_get_coroutine (m);
	} else {
		_tmp243_ = FALSE;
	}
	if (_tmp243_) {
		_tmp242_ = vala_method_get_signal_reference (m) == NULL;
	} else {
		_tmp242_ = FALSE;
	}
	if (_tmp242_) {
		GeeHashMap* _tmp245_;
		GeeHashMap* carg_map;
		cparam_map = (_tmp245_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), _gee_collection_object_unref0 (cparam_map), _tmp245_);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vala_ccode_method_module_generate_vfunc (self, m, creturn_type, (GeeMap*) cparam_map, (GeeMap*) carg_map, "", 3);
		_gee_collection_object_unref0 (carg_map);
	}
	if (vala_method_get_entry_point (m)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp246_;
		ValaCCodeFormalParameter* _tmp247_;
		ValaCCodeBlock* main_block;
		ValaCCodeIdentifier* _tmp255_;
		ValaCCodeFunctionCall* _tmp256_;
		ValaCCodeFunctionCall* main_call;
		GeeList* _tmp257_;
		gboolean _tmp258_;
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line ((ValaCCodeNode*) cmain, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		vala_ccode_function_add_parameter (cmain, _tmp246_ = vala_ccode_formal_parameter_new ("argc", "int"));
		_vala_ccode_node_unref0 (_tmp246_);
		vala_ccode_function_add_parameter (cmain, _tmp247_ = vala_ccode_formal_parameter_new ("argv", "char **"));
		_vala_ccode_node_unref0 (_tmp247_);
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_GOBJECT) {
			ValaCCodeFunctionCall* _tmp253_;
			ValaCCodeIdentifier* _tmp252_;
			ValaCCodeExpressionStatement* _tmp254_;
			ValaCCodeExpressionStatement* type_init_call;
			if (vala_code_context_get_thread (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self))) {
				ValaCCodeIdentifier* _tmp248_;
				ValaCCodeFunctionCall* _tmp249_;
				ValaCCodeFunctionCall* thread_init_call;
				ValaCCodeConstant* _tmp250_;
				ValaCCodeExpressionStatement* _tmp251_;
				thread_init_call = (_tmp249_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp248_ = vala_ccode_identifier_new ("g_thread_init"))), _vala_ccode_node_unref0 (_tmp248_), _tmp249_);
				vala_ccode_node_set_line ((ValaCCodeNode*) thread_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
				vala_ccode_function_call_add_argument (thread_init_call, (ValaCCodeExpression*) (_tmp250_ = vala_ccode_constant_new ("NULL")));
				_vala_ccode_node_unref0 (_tmp250_);
				vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) (_tmp251_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) thread_init_call)));
				_vala_ccode_node_unref0 (_tmp251_);
				_vala_ccode_node_unref0 (thread_init_call);
			}
			type_init_call = (_tmp254_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp253_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp252_ = vala_ccode_identifier_new ("g_type_init"))))), _vala_ccode_node_unref0 (_tmp253_), _vala_ccode_node_unref0 (_tmp252_), _tmp254_);
			vala_ccode_node_set_line ((ValaCCodeNode*) type_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) type_init_call);
			_vala_ccode_node_unref0 (type_init_call);
		}
		main_call = (_tmp256_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp255_ = vala_ccode_identifier_new (vala_ccode_function_get_name (((ValaCCodeBaseModule*) self)->function)))), _vala_ccode_node_unref0 (_tmp255_), _tmp256_);
		if ((_tmp258_ = gee_collection_get_size ((GeeCollection*) (_tmp257_ = vala_method_get_parameters (m))) == 1, _gee_collection_object_unref0 (_tmp257_), _tmp258_)) {
			ValaCCodeIdentifier* _tmp259_;
			ValaCCodeIdentifier* _tmp260_;
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp259_ = vala_ccode_identifier_new ("argv")));
			_vala_ccode_node_unref0 (_tmp259_);
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp260_ = vala_ccode_identifier_new ("argc")));
			_vala_ccode_node_unref0 (_tmp260_);
		}
		if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp261_;
			ValaCCodeReturnStatement* _tmp262_;
			ValaCCodeReturnStatement* ret_stmt;
			main_stmt = vala_ccode_expression_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			ret_stmt = (_tmp262_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp261_ = vala_ccode_constant_new ("0"))), _vala_ccode_node_unref0 (_tmp261_), _tmp262_);
			vala_ccode_node_set_line ((ValaCCodeNode*) ret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) ret_stmt);
			_vala_ccode_node_unref0 (main_stmt);
			_vala_ccode_node_unref0 (ret_stmt);
		} else {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			_vala_ccode_node_unref0 (main_stmt);
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cmain);
		_vala_ccode_node_unref0 (cmain);
		_vala_ccode_node_unref0 (main_block);
		_vala_ccode_node_unref0 (main_call);
	}
	_vala_code_node_unref0 (old_symbol);
	_gee_collection_object_unref0 (old_temp_vars);
	_gee_collection_object_unref0 (old_temp_ref_vars);
	_gee_collection_object_unref0 (old_variable_name_map);
	_vala_code_node_unref0 (old_try);
	_vala_code_node_unref0 (creturn_type);
	_gee_collection_object_unref0 (cparam_map);
}


static void vala_ccode_method_module_real_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map) {
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	if (!vala_formal_parameter_get_ellipsis (param)) {
		char* ctypename;
		ValaCCodeFormalParameter* _tmp6_;
		char* _tmp5_;
		ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param));
		vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), decl_space);
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)))) {
			ValaStruct* st;
			gboolean _tmp0_;
			st = _vala_code_node_ref0 (VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))));
			_tmp0_ = FALSE;
			if (!vala_struct_is_simple_type (st)) {
				_tmp0_ = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gboolean _tmp1_;
				_tmp1_ = FALSE;
				if (vala_struct_get_use_const (st)) {
					_tmp1_ = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					char* _tmp2_;
					ctypename = (_tmp2_ = g_strconcat ("const ", ctypename, NULL), _g_free0 (ctypename), _tmp2_);
				}
				if (!vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))) {
					char* _tmp3_;
					ctypename = (_tmp3_ = g_strconcat (ctypename, "*", NULL), _g_free0 (ctypename), _tmp3_);
				}
			}
			_vala_code_node_unref0 (st);
		}
		if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
			char* _tmp4_;
			ctypename = (_tmp4_ = g_strconcat (ctypename, "*", NULL), _g_free0 (ctypename), _tmp4_);
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp6_ = vala_ccode_formal_parameter_new (_tmp5_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), ctypename)));
		_vala_ccode_node_unref0 (_tmp6_);
		_g_free0 (_tmp5_);
		_g_free0 (ctypename);
	} else {
		ValaCCodeFormalParameter* _tmp7_;
		vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp7_ = vala_ccode_formal_parameter_new_with_ellipsis ()));
		_vala_ccode_node_unref0 (_tmp7_);
	}
	gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	_tmp8_ = FALSE;
	if (carg_map != NULL) {
		_tmp8_ = !vala_formal_parameter_get_ellipsis (param);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaCCodeExpression* _tmp9_;
		gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), _tmp9_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)));
		_vala_ccode_node_unref0 (_tmp9_);
	}
}


void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map) {
	VALA_CCODE_METHOD_MODULE_GET_CLASS (self)->generate_parameter (self, param, decl_space, cparam_map, carg_map);
}


static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeBaseModule* base, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction) {
	ValaCCodeMethodModule * self;
	gint last_pos;
	gint min_pos;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (func != NULL);
	if (vala_method_get_closure (m)) {
		ValaSymbol* _tmp0_;
		ValaBlock* closure_block;
		gint block_id;
		char* _tmp5_;
		char* _tmp4_;
		ValaCCodeFormalParameter* _tmp6_;
		ValaCCodeFormalParameter* instance_param;
		closure_block = _vala_code_node_ref0 ((_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_BLOCK (_tmp0_) ? ((ValaBlock*) _tmp0_) : NULL));
		while (TRUE) {
			gboolean _tmp1_;
			ValaBlock* _tmp3_;
			ValaSymbol* _tmp2_;
			_tmp1_ = FALSE;
			if (closure_block != NULL) {
				_tmp1_ = !vala_block_get_captured (closure_block);
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			closure_block = (_tmp3_ = _vala_code_node_ref0 ((_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) closure_block), VALA_IS_BLOCK (_tmp2_) ? ((ValaBlock*) _tmp2_) : NULL)), _vala_code_node_unref0 (closure_block), _tmp3_);
		}
		block_id = vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, closure_block);
		instance_param = (_tmp6_ = vala_ccode_formal_parameter_new (_tmp4_ = g_strdup_printf ("_data%d_", block_id), _tmp5_ = g_strdup_printf ("Block%dData*", block_id)), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _tmp6_);
		gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
		_vala_code_node_unref0 (closure_block);
		_vala_ccode_node_unref0 (instance_param);
	} else {
		gboolean _tmp7_;
		_tmp7_ = FALSE;
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
			_tmp7_ = VALA_IS_CREATION_METHOD (m);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaClass* cl;
			gboolean _tmp8_;
			cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
			_tmp8_ = FALSE;
			if (!vala_class_get_is_compact (cl)) {
				_tmp8_ = vcall == NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaCCodeFormalParameter* _tmp9_;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), _tmp9_ = vala_ccode_formal_parameter_new ("object_type", "GType"));
				_vala_ccode_node_unref0 (_tmp9_);
			}
			_vala_code_node_unref0 (cl);
		} else {
			gboolean _tmp10_;
			_tmp10_ = FALSE;
			if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
				_tmp10_ = TRUE;
			} else {
				gboolean _tmp11_;
				_tmp11_ = FALSE;
				if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
					_tmp11_ = VALA_IS_CREATION_METHOD (m);
				} else {
					_tmp11_ = FALSE;
				}
				_tmp10_ = _tmp11_;
			}
			if (_tmp10_) {
				ValaTypeSymbol* parent_type;
				ValaDataType* this_type;
				ValaCCodeFormalParameter* instance_param;
				gboolean _tmp16_;
				gboolean _tmp17_;
				parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
				this_type = NULL;
				if (VALA_IS_CLASS (parent_type)) {
					ValaDataType* _tmp12_;
					this_type = (_tmp12_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (parent_type)), _vala_code_node_unref0 (this_type), _tmp12_);
				} else {
					if (VALA_IS_INTERFACE (parent_type)) {
						ValaDataType* _tmp13_;
						this_type = (_tmp13_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (parent_type)), _vala_code_node_unref0 (this_type), _tmp13_);
					} else {
						if (VALA_IS_STRUCT (parent_type)) {
							ValaDataType* _tmp14_;
							this_type = (_tmp14_ = (ValaDataType*) vala_struct_value_type_new (VALA_STRUCT (parent_type)), _vala_code_node_unref0 (this_type), _tmp14_);
						} else {
							if (VALA_IS_ENUM (parent_type)) {
								ValaDataType* _tmp15_;
								this_type = (_tmp15_ = (ValaDataType*) vala_enum_value_type_new (VALA_ENUM (parent_type)), _vala_code_node_unref0 (this_type), _tmp15_);
							} else {
								g_assert_not_reached ();
							}
						}
					}
				}
				vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, this_type, decl_space);
				instance_param = NULL;
				_tmp16_ = FALSE;
				_tmp17_ = FALSE;
				if (vala_method_get_base_interface_method (m) != NULL) {
					_tmp17_ = !vala_method_get_is_abstract (m);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					_tmp16_ = !vala_method_get_is_virtual (m);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					ValaObjectType* base_type;
					ValaCCodeFormalParameter* _tmp19_;
					char* _tmp18_;
					base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))));
					instance_param = (_tmp19_ = vala_ccode_formal_parameter_new ("base", _tmp18_ = vala_data_type_get_cname ((ValaDataType*) base_type)), _vala_ccode_node_unref0 (instance_param), _tmp19_);
					_g_free0 (_tmp18_);
					_vala_code_node_unref0 (base_type);
				} else {
					if (vala_method_get_overrides (m)) {
						ValaObjectType* base_type;
						ValaCCodeFormalParameter* _tmp21_;
						char* _tmp20_;
						base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))));
						instance_param = (_tmp21_ = vala_ccode_formal_parameter_new ("base", _tmp20_ = vala_data_type_get_cname ((ValaDataType*) base_type)), _vala_ccode_node_unref0 (instance_param), _tmp21_);
						_g_free0 (_tmp20_);
						_vala_code_node_unref0 (base_type);
					} else {
						gboolean _tmp22_;
						_tmp22_ = FALSE;
						if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
							_tmp22_ = !vala_struct_is_simple_type (VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
						} else {
							_tmp22_ = FALSE;
						}
						if (_tmp22_) {
							ValaCCodeFormalParameter* _tmp24_;
							char* _tmp23_;
							instance_param = (_tmp24_ = vala_ccode_formal_parameter_new ("*self", _tmp23_ = vala_data_type_get_cname (this_type)), _vala_ccode_node_unref0 (instance_param), _tmp24_);
							_g_free0 (_tmp23_);
						} else {
							ValaCCodeFormalParameter* _tmp26_;
							char* _tmp25_;
							instance_param = (_tmp26_ = vala_ccode_formal_parameter_new ("self", _tmp25_ = vala_data_type_get_cname (this_type)), _vala_ccode_node_unref0 (instance_param), _tmp26_);
							_g_free0 (_tmp25_);
						}
					}
				}
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
				_vala_code_node_unref0 (parent_type);
				_vala_code_node_unref0 (this_type);
				_vala_ccode_node_unref0 (instance_param);
			} else {
				if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
					ValaTypeSymbol* parent_type;
					ValaDataType* this_type;
					ValaDataType* _tmp27_;
					char* _tmp28_;
					ValaCCodeFormalParameter* _tmp29_;
					ValaCCodeFormalParameter* class_param;
					parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
					this_type = NULL;
					this_type = (_tmp27_ = (ValaDataType*) vala_class_type_new (VALA_CLASS (parent_type)), _vala_code_node_unref0 (this_type), _tmp27_);
					class_param = (_tmp29_ = vala_ccode_formal_parameter_new ("klass", _tmp28_ = vala_data_type_get_cname (this_type)), _g_free0 (_tmp28_), _tmp29_);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
					_vala_code_node_unref0 (parent_type);
					_vala_code_node_unref0 (this_type);
					_vala_ccode_node_unref0 (class_param);
				}
			}
		}
	}
	if (vala_ccode_method_module_is_gtypeinstance_creation_method (self, m)) {
		gint type_param_index;
		ValaClass* cl;
		type_param_index = 0;
		cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
		{
			GeeList* _tmp30_;
			GeeIterator* _tmp31_;
			GeeIterator* _type_param_it;
			_type_param_it = (_tmp31_ = gee_iterable_iterator ((GeeIterable*) (_tmp30_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))), _gee_collection_object_unref0 (_tmp30_), _tmp31_);
			while (TRUE) {
				ValaTypeParameter* type_param;
				ValaCCodeFormalParameter* _tmp34_;
				char* _tmp33_;
				char* _tmp32_;
				ValaCCodeFormalParameter* _tmp37_;
				char* _tmp36_;
				char* _tmp35_;
				ValaCCodeFormalParameter* _tmp40_;
				char* _tmp39_;
				char* _tmp38_;
				if (!gee_iterator_next (_type_param_it)) {
					break;
				}
				type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), _tmp34_ = vala_ccode_formal_parameter_new (_tmp33_ = g_strdup_printf ("%s_type", _tmp32_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GType"));
				_vala_ccode_node_unref0 (_tmp34_);
				_g_free0 (_tmp33_);
				_g_free0 (_tmp32_);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), _tmp37_ = vala_ccode_formal_parameter_new (_tmp36_ = g_strdup_printf ("%s_dup_func", _tmp35_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GBoxedCopyFunc"));
				_vala_ccode_node_unref0 (_tmp37_);
				_g_free0 (_tmp36_);
				_g_free0 (_tmp35_);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), _tmp40_ = vala_ccode_formal_parameter_new (_tmp39_ = g_strdup_printf ("%s_destroy_func", _tmp38_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GDestroyNotify"));
				_vala_ccode_node_unref0 (_tmp40_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp38_);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp43_;
					char* _tmp42_;
					char* _tmp41_;
					ValaCCodeIdentifier* _tmp46_;
					char* _tmp45_;
					char* _tmp44_;
					ValaCCodeIdentifier* _tmp49_;
					char* _tmp48_;
					char* _tmp47_;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new (_tmp42_ = g_strdup_printf ("%s_type", _tmp41_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					_vala_ccode_node_unref0 (_tmp43_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp41_);
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new (_tmp45_ = g_strdup_printf ("%s_dup_func", _tmp44_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					_vala_ccode_node_unref0 (_tmp46_);
					_g_free0 (_tmp45_);
					_g_free0 (_tmp44_);
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new (_tmp48_ = g_strdup_printf ("%s_destroy_func", _tmp47_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					_vala_ccode_node_unref0 (_tmp49_);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp47_);
				}
				type_param_index++;
				_vala_code_node_unref0 (type_param);
			}
			_gee_collection_object_unref0 (_type_param_it);
		}
		_vala_code_node_unref0 (cl);
	} else {
		gint type_param_index;
		type_param_index = 0;
		{
			GeeList* _tmp50_;
			GeeIterator* _tmp51_;
			GeeIterator* _type_param_it;
			_type_param_it = (_tmp51_ = gee_iterable_iterator ((GeeIterable*) (_tmp50_ = vala_method_get_type_parameters (m))), _gee_collection_object_unref0 (_tmp50_), _tmp51_);
			while (TRUE) {
				ValaTypeParameter* type_param;
				ValaCCodeFormalParameter* _tmp54_;
				char* _tmp53_;
				char* _tmp52_;
				ValaCCodeFormalParameter* _tmp57_;
				char* _tmp56_;
				char* _tmp55_;
				ValaCCodeFormalParameter* _tmp60_;
				char* _tmp59_;
				char* _tmp58_;
				if (!gee_iterator_next (_type_param_it)) {
					break;
				}
				type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), _tmp54_ = vala_ccode_formal_parameter_new (_tmp53_ = g_strdup_printf ("%s_type", _tmp52_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GType"));
				_vala_ccode_node_unref0 (_tmp54_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp52_);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), _tmp57_ = vala_ccode_formal_parameter_new (_tmp56_ = g_strdup_printf ("%s_dup_func", _tmp55_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GBoxedCopyFunc"));
				_vala_ccode_node_unref0 (_tmp57_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp55_);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), _tmp60_ = vala_ccode_formal_parameter_new (_tmp59_ = g_strdup_printf ("%s_destroy_func", _tmp58_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GDestroyNotify"));
				_vala_ccode_node_unref0 (_tmp60_);
				_g_free0 (_tmp59_);
				_g_free0 (_tmp58_);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp63_;
					char* _tmp62_;
					char* _tmp61_;
					ValaCCodeIdentifier* _tmp66_;
					char* _tmp65_;
					char* _tmp64_;
					ValaCCodeIdentifier* _tmp69_;
					char* _tmp68_;
					char* _tmp67_;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp63_ = vala_ccode_identifier_new (_tmp62_ = g_strdup_printf ("%s_type", _tmp61_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					_vala_ccode_node_unref0 (_tmp63_);
					_g_free0 (_tmp62_);
					_g_free0 (_tmp61_);
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) (_tmp66_ = vala_ccode_identifier_new (_tmp65_ = g_strdup_printf ("%s_dup_func", _tmp64_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					_vala_ccode_node_unref0 (_tmp66_);
					_g_free0 (_tmp65_);
					_g_free0 (_tmp64_);
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) (_tmp69_ = vala_ccode_identifier_new (_tmp68_ = g_strdup_printf ("%s_destroy_func", _tmp67_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					_vala_ccode_node_unref0 (_tmp69_);
					_g_free0 (_tmp68_);
					_g_free0 (_tmp67_);
				}
				type_param_index++;
				_vala_code_node_unref0 (type_param);
			}
			_gee_collection_object_unref0 (_type_param_it);
		}
	}
	{
		GeeList* _tmp70_;
		GeeIterator* _tmp71_;
		GeeIterator* _param_it;
		_param_it = (_tmp71_ = gee_iterable_iterator ((GeeIterable*) (_tmp70_ = vala_method_get_parameters (m))), _gee_collection_object_unref0 (_tmp70_), _tmp71_);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				if ((direction & 1) == 0) {
					_vala_code_node_unref0 (param);
					continue;
				}
			} else {
				if ((direction & 2) == 0) {
					_vala_code_node_unref0 (param);
					continue;
				}
			}
			vala_ccode_method_module_generate_parameter (self, param, decl_space, cparam_map, carg_map);
			_vala_code_node_unref0 (param);
		}
		_gee_collection_object_unref0 (_param_it);
	}
	if ((direction & 2) != 0) {
		vala_ccode_method_module_generate_method_result_declaration (self, m, decl_space, func, cparam_map, carg_map);
	}
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp76_;
		min_pos = -1;
		{
			GeeSet* _tmp72_;
			GeeIterator* _tmp73_;
			GeeIterator* _pos_it;
			_pos_it = (_tmp73_ = gee_iterable_iterator ((GeeIterable*) (_tmp72_ = gee_map_get_keys (cparam_map))), _gee_collection_object_unref0 (_tmp72_), _tmp73_);
			while (TRUE) {
				gint pos;
				gboolean _tmp74_;
				if (!gee_iterator_next (_pos_it)) {
					break;
				}
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp74_ = FALSE;
				if (pos > last_pos) {
					gboolean _tmp75_;
					_tmp75_ = FALSE;
					if (min_pos == (-1)) {
						_tmp75_ = TRUE;
					} else {
						_tmp75_ = pos < min_pos;
					}
					_tmp74_ = _tmp75_;
				} else {
					_tmp74_ = FALSE;
				}
				if (_tmp74_) {
					min_pos = pos;
				}
			}
			_gee_collection_object_unref0 (_pos_it);
		}
		if (min_pos == (-1)) {
			break;
		}
		vala_ccode_function_add_parameter (func, _tmp76_ = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
		_vala_ccode_node_unref0 (_tmp76_);
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp77_;
			vala_ccode_function_declarator_add_parameter (vdeclarator, _tmp77_ = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
			_vala_ccode_node_unref0 (_tmp77_);
		}
		if (vcall != NULL) {
			ValaCCodeExpression* arg;
			arg = (ValaCCodeExpression*) gee_map_get (carg_map, GINT_TO_POINTER (min_pos));
			if (arg != NULL) {
				vala_ccode_function_call_add_argument (vcall, arg);
			}
			_vala_ccode_node_unref0 (arg);
		}
		last_pos = min_pos;
	}
}


void vala_ccode_method_module_generate_vfunc (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, GeeMap* cparam_map, GeeMap* carg_map, const char* suffix, gint direction) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* vfunc;
	ValaCCodeBlock* vblock;
	ValaCCodeFunctionCall* vcast;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeMemberAccess* _tmp15_;
	char* _tmp14_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeFunctionCall* vcall;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeStatement* cstmt;
	GeeList* _tmp27_;
	gboolean _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (return_type != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (carg_map != NULL);
	g_return_if_fail (suffix != NULL);
	vfunc = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strconcat (_tmp0_ = vala_method_get_cname (m), suffix, NULL), "void"), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	if (((ValaCCodeBaseModule*) self)->function != NULL) {
		vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	}
	vblock = vala_ccode_block_new ();
	{
		GeeList* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _precondition_it;
		_precondition_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = vala_method_get_preconditions (m))), _gee_collection_object_unref0 (_tmp3_), _tmp4_);
		while (TRUE) {
			ValaExpression* precondition;
			ValaCCodeStatement* check_stmt;
			if (!gee_iterator_next (_precondition_it)) {
				break;
			}
			precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
			check_stmt = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, return_type, precondition);
			if (check_stmt != NULL) {
				vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) check_stmt);
			}
			_vala_code_node_unref0 (precondition);
			_vala_ccode_node_unref0 (check_stmt);
		}
		_gee_collection_object_unref0 (_precondition_it);
	}
	vcast = NULL;
	if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		ValaInterface* iface;
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeIdentifier* _tmp7_;
		char* _tmp6_;
		char* _tmp5_;
		iface = _vala_code_node_ref0 (VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
		vcast = (_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = g_strdup_printf ("%s_GET_INTERFACE", _tmp5_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL))))), _vala_ccode_node_unref0 (vcast), _tmp8_);
		_vala_ccode_node_unref0 (_tmp7_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp5_);
		_vala_code_node_unref0 (iface);
	} else {
		ValaClass* cl;
		ValaCCodeFunctionCall* _tmp12_;
		ValaCCodeIdentifier* _tmp11_;
		char* _tmp10_;
		char* _tmp9_;
		cl = _vala_code_node_ref0 (VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)));
		vcast = (_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new (_tmp10_ = g_strdup_printf ("%s_GET_CLASS", _tmp9_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), _vala_ccode_node_unref0 (vcast), _tmp12_);
		_vala_ccode_node_unref0 (_tmp11_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp9_);
		_vala_code_node_unref0 (cl);
	}
	vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("self")));
	_vala_ccode_node_unref0 (_tmp13_);
	vcall = (_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp14_ = g_strconcat (vala_method_get_vfunc_name (m), suffix, NULL)))), _vala_ccode_node_unref0 (_tmp15_), _g_free0 (_tmp14_), _tmp16_);
	gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("self")));
	_vala_ccode_node_unref0 (_tmp17_);
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, cparam_map, vfunc, NULL, carg_map, vcall, direction);
	cstmt = NULL;
	if (VALA_IS_VOID_TYPE (return_type)) {
		ValaCCodeStatement* _tmp18_;
		cstmt = (_tmp18_ = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall), _vala_ccode_node_unref0 (cstmt), _tmp18_);
	} else {
		GeeList* _tmp19_;
		gboolean _tmp20_;
		if ((_tmp20_ = gee_collection_get_size ((GeeCollection*) (_tmp19_ = vala_method_get_postconditions (m))) == 0, _gee_collection_object_unref0 (_tmp19_), _tmp20_)) {
			ValaCCodeStatement* _tmp21_;
			cstmt = (_tmp21_ = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall), _vala_ccode_node_unref0 (cstmt), _tmp21_);
		} else {
			char* _tmp23_;
			char* _tmp22_;
			ValaCCodeDeclaration* _tmp24_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp25_;
			ValaCCodeStatement* _tmp26_;
			_cdecl_ = (_tmp24_ = vala_ccode_declaration_new (_tmp23_ = vala_ccode_method_module_get_creturn_type (self, m, _tmp22_ = vala_data_type_get_cname (return_type))), _g_free0 (_tmp23_), _g_free0 (_tmp22_), _tmp24_);
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp25_ = vala_ccode_variable_declarator_new ("result", (ValaCCodeExpression*) vcall, NULL)));
			_vala_ccode_node_unref0 (_tmp25_);
			cstmt = (_tmp26_ = _vala_ccode_node_ref0 ((ValaCCodeStatement*) _cdecl_), _vala_ccode_node_unref0 (cstmt), _tmp26_);
			_vala_ccode_node_unref0 (_cdecl_);
		}
	}
	vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
	vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
	if ((_tmp28_ = gee_collection_get_size ((GeeCollection*) (_tmp27_ = vala_method_get_postconditions (m))) > 0, _gee_collection_object_unref0 (_tmp27_), _tmp28_)) {
		{
			GeeList* _tmp29_;
			GeeIterator* _tmp30_;
			GeeIterator* _postcondition_it;
			_postcondition_it = (_tmp30_ = gee_iterable_iterator ((GeeIterable*) (_tmp29_ = vala_method_get_postconditions (m))), _gee_collection_object_unref0 (_tmp29_), _tmp30_);
			while (TRUE) {
				ValaExpression* postcondition;
				ValaCCodeStatement* _tmp31_;
				if (!gee_iterator_next (_postcondition_it)) {
					break;
				}
				postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
				vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) (_tmp31_ = vala_ccode_base_module_create_postcondition_statement ((ValaCCodeBaseModule*) self, postcondition)));
				_vala_ccode_node_unref0 (_tmp31_);
				_vala_code_node_unref0 (postcondition);
			}
			_gee_collection_object_unref0 (_postcondition_it);
		}
		if (!VALA_IS_VOID_TYPE (return_type)) {
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeReturnStatement* _tmp33_;
			ValaCCodeReturnStatement* cret_stmt;
			cret_stmt = (_tmp33_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("result"))), _vala_ccode_node_unref0 (_tmp32_), _tmp33_);
			vala_ccode_node_set_line ((ValaCCodeNode*) cret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
			vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cret_stmt);
			_vala_ccode_node_unref0 (cret_stmt);
		}
	}
	vala_ccode_function_set_block (vfunc, vblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
	_vala_ccode_node_unref0 (vfunc);
	_vala_ccode_node_unref0 (vblock);
	_vala_ccode_node_unref0 (vcast);
	_vala_ccode_node_unref0 (vcall);
	_vala_ccode_node_unref0 (cstmt);
}


static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeStatement* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (vala_method_get_coroutine (m)) {
		result = NULL;
		return result;
	} else {
		result = vala_ccode_base_module_create_type_check_statement ((ValaCCodeBaseModule*) self, (ValaCodeNode*) m, return_type, t, non_null, var_name);
		return result;
	}
}


static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeStatement* result;
	ValaCCodeFunctionCall* ccheck;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (precondition != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) precondition)));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0_;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_return_if_fail")));
		_vala_ccode_node_unref0 (_tmp0_);
	} else {
		ValaCCodeIdentifier* _tmp1_;
		ValaCCodeExpression* cdefault;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("g_return_val_if_fail")));
		_vala_ccode_node_unref0 (_tmp1_);
		cdefault = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			result = NULL;
			_vala_ccode_node_unref0 (cdefault);
			_vala_ccode_node_unref0 (ccheck);
			return result;
		}
		_vala_ccode_node_unref0 (cdefault);
	}
	result = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccheck);
	_vala_ccode_node_unref0 (ccheck);
	return result;
}


static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym) {
	ValaTypeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	while (TRUE) {
		if (!(sym != NULL)) {
			break;
		}
		if (VALA_IS_TYPESYMBOL (sym)) {
			result = _vala_code_node_ref0 (VALA_TYPESYMBOL (sym));
			return result;
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	result = NULL;
	return result;
}


static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* cl;
	gboolean _tmp0_;
	ValaCCodeVariableDeclarator* _cdecl_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp3_;
	char* _tmp9_;
	char* _tmp8_;
	ValaCCodeDeclaration* _tmp10_;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	cl = _vala_code_node_ref0 (VALA_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self)));
	_tmp0_ = FALSE;
	if (!has_params) {
		_tmp0_ = VALA_TYPESYMBOL (vala_class_get_base_class (cl)) != ((ValaCCodeBaseModule*) self)->gobject_type;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
	}
	_cdecl_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
	ccall = (_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("g_object_newv"))), _vala_ccode_node_unref0 (_tmp1_), _tmp2_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("object_type")));
	_vala_ccode_node_unref0 (_tmp3_);
	if (has_params) {
		ValaCCodeConstant* _tmp4_;
		ValaCCodeConstant* _tmp5_;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new ("__params_it - __params")));
		_vala_ccode_node_unref0 (_tmp4_);
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_constant_new ("__params")));
		_vala_ccode_node_unref0 (_tmp5_);
	} else {
		ValaCCodeConstant* _tmp6_;
		ValaCCodeConstant* _tmp7_;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_constant_new ("0")));
		_vala_ccode_node_unref0 (_tmp6_);
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_constant_new ("NULL")));
		_vala_ccode_node_unref0 (_tmp7_);
	}
	vala_ccode_variable_declarator_set_initializer (_cdecl_, (ValaCCodeExpression*) ccall);
	cdeclaration = (_tmp10_ = vala_ccode_declaration_new (_tmp9_ = g_strdup_printf ("%s *", _tmp8_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
	vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) _cdecl_);
	vala_ccode_block_add_statement (b, (ValaCCodeNode*) cdeclaration);
	_vala_code_node_unref0 (cl);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (cdeclaration);
}


static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m) {
	ValaCCodeMethodModule * self;
	gboolean visible;
	ValaDataType* creturn_type;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	visible = !vala_symbol_is_private_symbol ((ValaSymbol*) m);
	vala_ccode_module_visit_method (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaMethod*) m);
	creturn_type = NULL;
	if (VALA_IS_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self))) {
		ValaDataType* _tmp0_;
		creturn_type = (_tmp0_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)), _vala_code_node_unref0 (creturn_type), _tmp0_);
	} else {
		ValaDataType* _tmp1_;
		creturn_type = (_tmp1_ = (ValaDataType*) vala_void_type_new (NULL), _vala_code_node_unref0 (creturn_type), _tmp1_);
	}
	_tmp2_ = FALSE;
	_tmp3_ = FALSE;
	if (VALA_IS_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self))) {
		_tmp3_ = !vala_class_get_is_compact (vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !vala_class_get_is_abstract (vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		char* _tmp4_;
		ValaCCodeFunction* _tmp5_;
		ValaCCodeFunction* vfunc;
		GeeHashMap* cparam_map;
		GeeHashMap* carg_map;
		ValaCCodeBlock* vblock;
		ValaCCodeIdentifier* _tmp7_;
		char* _tmp6_;
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp10_;
		char* _tmp9_;
		ValaCCodeStatement* cstmt;
		vfunc = (_tmp5_ = vala_ccode_function_new (_tmp4_ = vala_method_get_cname ((ValaMethod*) m), "void"), _g_free0 (_tmp4_), _tmp5_);
		vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vblock = vala_ccode_block_new ();
		vcall = (_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = vala_method_get_real_cname ((ValaMethod*) m)))), _vala_ccode_node_unref0 (_tmp7_), _g_free0 (_tmp6_), _tmp8_);
		vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new (_tmp9_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)))));
		_vala_ccode_node_unref0 (_tmp10_);
		_g_free0 (_tmp9_);
		vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, (ValaMethod*) m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, vfunc, NULL, (GeeMap*) carg_map, vcall, 3);
		cstmt = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall);
		vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
		vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
		if (!visible) {
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | VALA_CCODE_MODIFIERS_STATIC);
		}
		vala_ccode_function_set_block (vfunc, vblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
		_vala_ccode_node_unref0 (vfunc);
		_gee_collection_object_unref0 (cparam_map);
		_gee_collection_object_unref0 (carg_map);
		_vala_ccode_node_unref0 (vblock);
		_vala_ccode_node_unref0 (vcall);
		_vala_ccode_node_unref0 (cstmt);
	}
	_tmp11_ = FALSE;
	_tmp12_ = FALSE;
	_tmp13_ = FALSE;
	_tmp14_ = FALSE;
	if (VALA_IS_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self))) {
		_tmp14_ = ((ValaCCodeBaseModule*) self)->gobject_type != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self), ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gboolean _tmp15_;
		_tmp15_ = FALSE;
		if (vala_creation_method_get_n_construction_params (VALA_CREATION_METHOD (m)) > 0) {
			_tmp15_ = TRUE;
		} else {
			GeeList* _tmp16_;
			_tmp15_ = gee_collection_get_size ((GeeCollection*) (_tmp16_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self)))) > 0;
			_gee_collection_object_unref0 (_tmp16_);
		}
		_tmp12_ = _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = !vala_creation_method_get_chain_up (VALA_CREATION_METHOD (m));
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeBinaryExpression* _tmp19_;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeBlock* cdofreeparam;
		ValaCCodeExpressionStatement* _tmp22_;
		ValaCCodeUnaryExpression* _tmp21_;
		ValaCCodeIdentifier* _tmp20_;
		ValaCCodeIdentifier* _tmp23_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeFunctionCall* cunsetcall;
		ValaCCodeUnaryExpression* _tmp27_;
		ValaCCodeMemberAccess* _tmp26_;
		ValaCCodeIdentifier* _tmp25_;
		ValaCCodeExpressionStatement* _tmp28_;
		ValaCCodeWhileStatement* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeFunctionCall* cfreeparams;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeExpressionStatement* _tmp33_;
		ccond = (_tmp19_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("__params_it")), (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("__params"))), _vala_ccode_node_unref0 (_tmp18_), _vala_ccode_node_unref0 (_tmp17_), _tmp19_);
		cdofreeparam = vala_ccode_block_new ();
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("__params_it")))))));
		_vala_ccode_node_unref0 (_tmp22_);
		_vala_ccode_node_unref0 (_tmp21_);
		_vala_ccode_node_unref0 (_tmp20_);
		cunsetcall = (_tmp24_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("g_value_unset"))), _vala_ccode_node_unref0 (_tmp23_), _tmp24_);
		vala_ccode_function_call_add_argument (cunsetcall, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("__params_it")), "value")))));
		_vala_ccode_node_unref0 (_tmp27_);
		_vala_ccode_node_unref0 (_tmp26_);
		_vala_ccode_node_unref0 (_tmp25_);
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp28_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cunsetcall)));
		_vala_ccode_node_unref0 (_tmp28_);
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp29_ = vala_ccode_while_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cdofreeparam)));
		_vala_ccode_node_unref0 (_tmp29_);
		cfreeparams = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("g_free"))), _vala_ccode_node_unref0 (_tmp30_), _tmp31_);
		vala_ccode_function_call_add_argument (cfreeparams, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("__params")));
		_vala_ccode_node_unref0 (_tmp32_);
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp33_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreeparams)));
		_vala_ccode_node_unref0 (_tmp33_);
		_vala_ccode_node_unref0 (ccond);
		_vala_ccode_node_unref0 (cdofreeparam);
		_vala_ccode_node_unref0 (cunsetcall);
		_vala_ccode_node_unref0 (cfreeparams);
	}
	if (VALA_IS_CLASS (vala_ccode_base_module_get_current_type_symbol ((ValaCCodeBaseModule*) self))) {
		ValaCCodeExpression* cresult;
		char* _tmp34_;
		gboolean _tmp35_;
		ValaCCodeReturnStatement* creturn;
		cresult = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
		if ((_tmp35_ = (_tmp34_ = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)) != NULL, _g_free0 (_tmp34_), _tmp35_)) {
			ValaCCodeExpression* _tmp37_;
			char* _tmp36_;
			cresult = (_tmp37_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cresult, _tmp36_ = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)), _vala_ccode_node_unref0 (cresult), _tmp37_);
			_g_free0 (_tmp36_);
		}
		creturn = vala_ccode_return_statement_new (NULL);
		vala_ccode_return_statement_set_return_expression (creturn, cresult);
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) creturn);
		_vala_ccode_node_unref0 (cresult);
		_vala_ccode_node_unref0 (creturn);
	}
	_vala_code_node_unref0 (creturn_type);
}


static void vala_ccode_method_module_class_init (ValaCCodeMethodModuleClass * klass) {
	vala_ccode_method_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->method_has_wrapper = vala_ccode_method_module_real_method_has_wrapper;
	VALA_CCODE_MODULE_CLASS (klass)->get_custom_creturn_type = vala_ccode_method_module_real_get_custom_creturn_type;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_method_result_declaration = vala_ccode_method_module_real_generate_method_result_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_method_declaration = vala_ccode_method_module_real_generate_method_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_ccode_method_module_real_visit_method;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_ccode_method_module_real_generate_parameter;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_cparameters = vala_ccode_method_module_real_generate_cparameters;
	VALA_CCODE_MODULE_CLASS (klass)->visit_creation_method = vala_ccode_method_module_real_visit_creation_method;
}


static void vala_ccode_method_module_instance_init (ValaCCodeMethodModule * self) {
}


GType vala_ccode_method_module_get_type (void) {
	static GType vala_ccode_method_module_type_id = 0;
	if (vala_ccode_method_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodModule), 0, (GInstanceInitFunc) vala_ccode_method_module_instance_init, NULL };
		vala_ccode_method_module_type_id = g_type_register_static (VALA_TYPE_CCODE_STRUCT_MODULE, "ValaCCodeMethodModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_module_type_id;
}




