/* main.c generated by valac 0.10.0, the Vala compiler
 * generated from main.vala, do not modify */

/* valaprojectgenerator.vala
 *
 * Copyright (C) 2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Andrea Del Signore <sejerpz@tin.it>
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gen-project.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <config.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _gen_project_project_options_unref0(var) ((var == NULL) ? NULL : (var = (gen_project_project_options_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VALA_TYPE_GEN_PROJECT_DIALOG (vala_gen_project_dialog_get_type ())
#define VALA_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialog))
#define VALA_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))
#define VALA_IS_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_IS_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_GEN_PROJECT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))

typedef struct _ValaGenProjectDialog ValaGenProjectDialog;
typedef struct _ValaGenProjectDialogClass ValaGenProjectDialogClass;
#define _vala_gen_project_dialog_unref0(var) ((var == NULL) ? NULL : (var = (vala_gen_project_dialog_unref (var), NULL)))


extern char* option_project_path;
char* option_project_path = NULL;
extern gboolean option_version;
gboolean option_version = FALSE;
extern gboolean option_list_templates;
gboolean option_list_templates = FALSE;
extern gint option_template_id;
gint option_template_id = 0;
extern char* option_author;
char* option_author = NULL;
extern char* option_email;
char* option_email = NULL;
extern char** option_files;
extern gint option_files_length1;
char** option_files = NULL;
gint option_files_length1 = 0;
static gint _option_files_size_ = 0;
extern GenProjectProjectLicense option_project_license;
GenProjectProjectLicense option_project_license = 0;

gboolean option_parse_callback (const char* option_name, const char* value, void* data, GError** error);
gint _vala_main (char** args, int args_length1);
ValaGenProjectDialog* vala_gen_project_dialog_new (void);
ValaGenProjectDialog* vala_gen_project_dialog_construct (GType object_type);
gpointer vala_gen_project_dialog_ref (gpointer instance);
void vala_gen_project_dialog_unref (gpointer instance);
GParamSpec* vala_param_spec_gen_project_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_gen_project_dialog (GValue* value, gpointer v_object);
void vala_value_take_gen_project_dialog (GValue* value, gpointer v_object);
gpointer vala_value_get_gen_project_dialog (const GValue* value);
GType vala_gen_project_dialog_get_type (void) G_GNUC_CONST;
GtkResponseType vala_gen_project_dialog_ask_parameters (ValaGenProjectDialog* self, GenProjectProjectOptions* options);
static int _vala_strcmp0 (const char * str1, const char * str2);

const GOptionEntry options[9] = {{"projectdir", 'p', 0, G_OPTION_ARG_FILENAME, &option_project_path, "Project directory", "DIRECTORY"}, {"template-id", 't', 0, G_OPTION_ARG_INT, &option_template_id, "Project TYPE id. See --list-templates for a list of avalable templates", "TYPE"}, {"list-templates", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_list_templates, "Print a list of avalable project templates", NULL}, {"license", 'l', 0, G_OPTION_ARG_CALLBACK, (void*) option_parse_callback, "License TYPE: gpl2, gpl3, lgpl2, lgpl3", "TYPE"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_version, "Display version number", NULL}, {"author", 'a', 0, G_OPTION_ARG_STRING, &option_author, "Author name", "NAME"}, {"email", 'e', 0, G_OPTION_ARG_STRING, &option_email, "Author email address", "EMAIL"}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &option_files, "Project NAME", "NAME"}, {NULL}};


gboolean option_parse_callback (const char* option_name, const char* value, void* data, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (_vala_strcmp0 (option_name, "--license") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (option_name, "-l") == 0;
	}
	if (_tmp0_) {
		if (_vala_strcmp0 (value, "gpl2") == 0) {
			option_project_license = GEN_PROJECT_PROJECT_LICENSE_GPL2;
		} else {
			if (_vala_strcmp0 (value, "gpl3") == 0) {
				option_project_license = GEN_PROJECT_PROJECT_LICENSE_GPL3;
			} else {
				if (_vala_strcmp0 (value, "lgpl2") == 0) {
					option_project_license = GEN_PROJECT_PROJECT_LICENSE_LGPL2;
				} else {
					if (_vala_strcmp0 (value, "lgpl3") == 0) {
						option_project_license = GEN_PROJECT_PROJECT_LICENSE_LGPL3;
					} else {
						char* _tmp1_;
						GError* _tmp2_;
						_inner_error_ = (_tmp2_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _tmp1_ = g_strdup_printf (_ ("license of type %s is not available"), value)), _g_free0 (_tmp1_), _tmp2_);
						{
							if (_inner_error_->domain == G_OPTION_ERROR) {
								g_propagate_error (error, _inner_error_);
								return FALSE;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
					}
				}
			}
		}
	} else {
		char* _tmp3_;
		GError* _tmp4_;
		_inner_error_ = (_tmp4_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_UNKNOWN_OPTION, _tmp3_ = g_strdup_printf (_ ("unknown option %s"), option_name)), _g_free0 (_tmp3_), _tmp4_);
		{
			if (_inner_error_->domain == G_OPTION_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	GenProjectProjectOptions* project_options;
	ValaGenProjectDialog* dialog;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
	project_options = NULL;
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, NULL);
	{
		GenProjectProjectOptions* _tmp0_;
		GOptionContext* opt_context;
		project_options = (_tmp0_ = gen_project_project_options_new (), _gen_project_project_options_unref0 (project_options), _tmp0_);
		opt_context = g_option_context_new ("- Vala Project Generator");
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_gen_project_project_options_unref0 (project_options);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		project_options->version = option_version;
		if (option_author != NULL) {
			char* _tmp1_;
			project_options->author = (_tmp1_ = g_strdup (option_author), _g_free0 (project_options->author), _tmp1_);
		}
		if (option_email != NULL) {
			char* _tmp2_;
			project_options->email = (_tmp2_ = g_strdup (option_email), _g_free0 (project_options->email), _tmp2_);
		}
		if (option_project_license != 0) {
			project_options->license = option_project_license;
		}
		if (option_project_path != NULL) {
			char* _tmp3_;
			project_options->path = (_tmp3_ = g_strdup (option_project_path), _g_free0 (project_options->path), _tmp3_);
		}
		if (option_files != NULL) {
			char* _tmp4_;
			if (option_files[1] != NULL) {
				_inner_error_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, _ ("Just a single project name can be specified on the command line"));
				{
					_g_option_context_free0 (opt_context);
					if (_inner_error_->domain == G_OPTION_ERROR) {
						goto __catch0_g_option_error;
					}
					_g_option_context_free0 (opt_context);
					_gen_project_project_options_unref0 (project_options);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			project_options->name = (_tmp4_ = g_strdup (option_files[0]), _g_free0 (project_options->name), _tmp4_);
			if (option_project_path == NULL) {
				char* _tmp5_;
				project_options->path = (_tmp5_ = g_get_current_dir (), _g_free0 (project_options->path), _tmp5_);
			}
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, _ ("Run '%s --help' to see a full list of available command line options.\n"), args[0]);
			result = 1;
			_g_error_free0 (e);
			_gen_project_project_options_unref0 (project_options);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_gen_project_project_options_unref0 (project_options);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (option_version) {
		fprintf (stdout, "vala-gen-project %s\n", PACKAGE_VERSION);
		result = 0;
		_gen_project_project_options_unref0 (project_options);
		return result;
	}
	if (option_list_templates) {
		GenProjectTemplates* templates;
		templates = gen_project_templates_load (NULL, 0);
		fprintf (stdout, "%s", _ ("Available project templates\n"));
		{
			GList* definition_collection;
			GList* definition_it;
			definition_collection = gen_project_templates_get_definitions (templates);
			for (definition_it = definition_collection; definition_it != NULL; definition_it = definition_it->next) {
				GenProjectTemplateDefinition* definition;
				definition = _g_object_ref0 ((GenProjectTemplateDefinition*) definition_it->data);
				{
					char* _tmp6_;
					fprintf (stdout, "%s", _tmp6_ = g_strdup_printf (_ ("\tname '%s' - id %d\n"), gen_project_template_definition_get_name (definition), gen_project_template_definition_get_id (definition) + 1));
					_g_free0 (_tmp6_);
					_g_object_unref0 (definition);
				}
			}
		}
		result = 0;
		_g_object_unref0 (templates);
		_gen_project_project_options_unref0 (project_options);
		return result;
	}
	if (option_template_id > 0) {
		GenProjectTemplates* templates;
		GenProjectTemplateDefinition* _tmp7_;
		templates = gen_project_templates_load (NULL, 0);
		project_options->template = (_tmp7_ = NULL, _g_object_unref0 (project_options->template), _tmp7_);
		{
			GList* definition_collection;
			GList* definition_it;
			definition_collection = gen_project_templates_get_definitions (templates);
			for (definition_it = definition_collection; definition_it != NULL; definition_it = definition_it->next) {
				GenProjectTemplateDefinition* definition;
				definition = _g_object_ref0 ((GenProjectTemplateDefinition*) definition_it->data);
				{
					if ((gen_project_template_definition_get_id (definition) + 1) == option_template_id) {
						GenProjectTemplateDefinition* _tmp8_;
						project_options->template = (_tmp8_ = _g_object_ref0 (definition), _g_object_unref0 (project_options->template), _tmp8_);
						_g_object_unref0 (definition);
						break;
					}
					_g_object_unref0 (definition);
				}
			}
		}
		if (project_options->template == NULL) {
			fprintf (stdout, _ ("Cannot find template id %d\n"), option_template_id);
			fprintf (stdout, _ ("Run '%s --list-templates' to see a full list of available templates.\n"), args[0]);
			result = 1;
			_g_object_unref0 (templates);
			_gen_project_project_options_unref0 (project_options);
			return result;
		}
		_g_object_unref0 (templates);
	}
	dialog = vala_gen_project_dialog_new ();
	if (project_options->name != NULL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = vala_gen_project_dialog_ask_parameters (dialog, project_options) == GTK_RESPONSE_OK;
	}
	if (_tmp9_) {
		GenProjectProjectGenerator* generator;
		generator = gen_project_project_generator_new (project_options);
		gen_project_project_generator_create_project (generator);
		result = 0;
		_g_object_unref0 (generator);
		_vala_gen_project_dialog_unref0 (dialog);
		_gen_project_project_options_unref0 (project_options);
		return result;
	}
	result = 1;
	_vala_gen_project_dialog_unref0 (dialog);
	_gen_project_project_options_unref0 (project_options);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




