/* vbfgroup.c generated by valac 0.10.0, the Vala compiler
 * generated from vbfgroup.vala, do not modify */

/*
 *  vbfgroup.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VBF_TYPE_GROUP (vbf_group_get_type ())
#define VBF_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_GROUP, VbfGroup))
#define VBF_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_GROUP, VbfGroupClass))
#define VBF_IS_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_GROUP))
#define VBF_IS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_GROUP))
#define VBF_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_GROUP, VbfGroupClass))

typedef struct _VbfGroup VbfGroup;
typedef struct _VbfGroupClass VbfGroupClass;
typedef struct _VbfGroupPrivate VbfGroupPrivate;

#define VBF_TYPE_CONFIG_NODE (vbf_config_node_get_type ())
#define VBF_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNode))
#define VBF_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))
#define VBF_IS_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE))
#define VBF_IS_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE))
#define VBF_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))

typedef struct _VbfConfigNode VbfConfigNode;
typedef struct _VbfConfigNodeClass VbfConfigNodeClass;

#define VBF_TYPE_PROJECT (vbf_project_get_type ())
#define VBF_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PROJECT, VbfProject))
#define VBF_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PROJECT, VbfProjectClass))
#define VBF_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PROJECT))
#define VBF_IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PROJECT))
#define VBF_PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PROJECT, VbfProjectClass))

typedef struct _VbfProject VbfProject;
typedef struct _VbfProjectClass VbfProjectClass;

#define VBF_TYPE_PACKAGE (vbf_package_get_type ())
#define VBF_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PACKAGE, VbfPackage))
#define VBF_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PACKAGE, VbfPackageClass))
#define VBF_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PACKAGE))
#define VBF_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PACKAGE))
#define VBF_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PACKAGE, VbfPackageClass))

typedef struct _VbfPackage VbfPackage;
typedef struct _VbfPackageClass VbfPackageClass;

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;

#define VBF_TYPE_VARIABLE (vbf_variable_get_type ())
#define VBF_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_VARIABLE, VbfVariable))
#define VBF_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_VARIABLE, VbfVariableClass))
#define VBF_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_VARIABLE))
#define VBF_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_VARIABLE))
#define VBF_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_VARIABLE, VbfVariableClass))

typedef struct _VbfVariable VbfVariable;
typedef struct _VbfVariableClass VbfVariableClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _VbfConfigNodePrivate VbfConfigNodePrivate;
typedef struct _VbfProjectPrivate VbfProjectPrivate;

#define VBF_TYPE_IPROJECT_BACKEND (vbf_iproject_backend_get_type ())
#define VBF_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackend))
#define VBF_IS_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_IPROJECT_BACKEND))
#define VBF_IPROJECT_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackendIface))

typedef struct _VbfIProjectBackend VbfIProjectBackend;
typedef struct _VbfIProjectBackendIface VbfIProjectBackendIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _VbfTargetPrivate VbfTargetPrivate;

#define VBF_TYPE_TARGET_TYPES (vbf_target_types_get_type ())
typedef struct _VbfPackagePrivate VbfPackagePrivate;

#define VBF_TYPE_MODULE (vbf_module_get_type ())
#define VBF_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_MODULE, VbfModule))
#define VBF_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_MODULE, VbfModuleClass))
#define VBF_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_MODULE))
#define VBF_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_MODULE))
#define VBF_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_MODULE, VbfModuleClass))

typedef struct _VbfModule VbfModule;
typedef struct _VbfModuleClass VbfModuleClass;

#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())

struct _VbfGroup {
	GObject parent_instance;
	VbfGroupPrivate * priv;
	char* name;
	char* id;
	VbfProject* project;
};

struct _VbfGroupClass {
	GObjectClass parent_class;
};

struct _VbfGroupPrivate {
	ValaList* packages;
	ValaList* include_dirs;
	ValaList* built_libraries;
	ValaList* targets;
	ValaList* variables;
	ValaList* subgroups;
};

struct _VbfConfigNode {
	GObject parent_instance;
	VbfConfigNodePrivate * priv;
	VbfConfigNode* parent;
};

struct _VbfConfigNodeClass {
	GObjectClass parent_class;
	char* (*to_string) (VbfConfigNode* self);
};

struct _VbfIProjectBackendIface {
	GTypeInterface parent_iface;
	gboolean (*probe) (VbfIProjectBackend* self, const char* project_file);
	VbfProject* (*open) (VbfIProjectBackend* self, const char* project_file);
	void (*refresh) (VbfIProjectBackend* self, VbfProject* project);
	char* (*get_configure_command) (VbfIProjectBackend* self);
	char* (*get_build_command) (VbfIProjectBackend* self);
	char* (*get_clean_command) (VbfIProjectBackend* self);
};

struct _VbfProject {
	VbfConfigNode parent_instance;
	VbfProjectPrivate * priv;
	char* id;
	char* name;
	char* url;
	char* version;
	char* working_dir;
	VbfIProjectBackend* backend;
};

struct _VbfProjectClass {
	VbfConfigNodeClass parent_class;
};

typedef enum  {
	VBF_TARGET_TYPES_PROGRAM,
	VBF_TARGET_TYPES_LIBRARY,
	VBF_TARGET_TYPES_DATA,
	VBF_TARGET_TYPES_BUILT_SOURCES
} VbfTargetTypes;

struct _VbfTarget {
	GObject parent_instance;
	VbfTargetPrivate * priv;
	char* id;
	char* name;
	VbfTargetTypes type;
	gboolean no_install;
	VbfGroup* group;
};

struct _VbfTargetClass {
	GObjectClass parent_class;
};

struct _VbfPackage {
	GObject parent_instance;
	VbfPackagePrivate * priv;
	char* id;
	char* name;
	char* constraint;
	VbfConfigNode* version;
	VbfTarget* parent_target;
	VbfGroup* parent_group;
	VbfModule* parent_module;
};

struct _VbfPackageClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;


static gpointer vbf_group_parent_class = NULL;

GType vbf_group_get_type (void) G_GNUC_CONST;
GType vbf_config_node_get_type (void) G_GNUC_CONST;
GType vbf_project_get_type (void) G_GNUC_CONST;
GType vbf_package_get_type (void) G_GNUC_CONST;
GType vbf_target_get_type (void) G_GNUC_CONST;
GType vbf_variable_get_type (void) G_GNUC_CONST;
#define VBF_GROUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VBF_TYPE_GROUP, VbfGroupPrivate))
enum  {
	VBF_GROUP_DUMMY_PROPERTY
};
VbfGroup* vbf_group_new (VbfProject* project, const char* id);
VbfGroup* vbf_group_construct (GType object_type, VbfProject* project, const char* id);
GType vbf_iproject_backend_get_type (void) G_GNUC_CONST;
ValaList* vbf_group_get_targets (VbfGroup* self);
gboolean vbf_group_contains_target (VbfGroup* self, const char* id);
VbfTarget* vbf_group_get_target_for_id (VbfGroup* self, const char* id);
GType vbf_target_types_get_type (void) G_GNUC_CONST;
void vbf_group_add_target (VbfGroup* self, VbfTarget* target);
ValaList* vbf_group_get_packages (VbfGroup* self);
void vbf_group_add_package (VbfGroup* self, VbfPackage* package);
GType vbf_module_get_type (void) G_GNUC_CONST;
ValaList* vbf_group_get_include_dirs (VbfGroup* self);
void vbf_group_add_include_dir (VbfGroup* self, const char* dir);
ValaList* vbf_group_get_built_libraries (VbfGroup* self);
void vbf_group_add_built_library (VbfGroup* self, const char* dir);
ValaList* vbf_group_get_subgroups (VbfGroup* self);
ValaList* vbf_group_get_variables (VbfGroup* self);
void vbf_group_add_variable (VbfGroup* self, VbfVariable* variable);
GType vbf_file_types_get_type (void) G_GNUC_CONST;
gboolean vbf_group_has_sources_of_type (VbfGroup* self, VbfFileTypes type);
gboolean vbf_target_has_sources_of_type (VbfTarget* self, VbfFileTypes type);
static void vbf_group_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


VbfGroup* vbf_group_construct (GType object_type, VbfProject* project, const char* id) {
	VbfGroup * self;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (project != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	self = (VbfGroup*) g_object_new (object_type, NULL);
	self->project = project;
	self->id = (_tmp0_ = g_strdup (id), _g_free0 (self->id), _tmp0_);
	self->name = (_tmp1_ = string_replace (id, project->id, ""), _g_free0 (self->name), _tmp1_);
	if (g_str_has_prefix (self->name, "/")) {
		char** _tmp2_;
		char** _tmp3_;
		gint _tmp3__length1;
		char* _tmp4_;
		self->name = (_tmp4_ = g_strdup ((_tmp3_ = _tmp2_ = g_strsplit (self->name, "/", 0), _tmp3__length1 = _vala_array_length (_tmp2_), _tmp3_)[1]), _g_free0 (self->name), _tmp4_);
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	} else {
		char** _tmp5_;
		char** _tmp6_;
		gint _tmp6__length1;
		char* _tmp7_;
		self->name = (_tmp7_ = g_strdup ((_tmp6_ = _tmp5_ = g_strsplit (self->name, "/", 0), _tmp6__length1 = _vala_array_length (_tmp5_), _tmp6_)[0]), _g_free0 (self->name), _tmp7_);
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	}
	if (_vala_strcmp0 (self->name, "") == 0) {
		char* _tmp8_;
		self->name = (_tmp8_ = g_strconcat ("/ - ", project->name, NULL), _g_free0 (self->name), _tmp8_);
	}
	return self;
}


VbfGroup* vbf_group_new (VbfProject* project, const char* id) {
	return vbf_group_construct (VBF_TYPE_GROUP, project, id);
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaList* vbf_group_get_targets (VbfGroup* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->targets);
	return result;
}


gboolean vbf_group_contains_target (VbfGroup* self, const char* id) {
	gboolean result = FALSE;
	VbfTarget* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	result = (_tmp1_ = (_tmp0_ = vbf_group_get_target_for_id (self, id)) != NULL, _g_object_unref0 (_tmp0_), _tmp1_);
	return result;
}


VbfTarget* vbf_group_get_target_for_id (VbfGroup* self, const char* id) {
	VbfTarget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	{
		ValaIterator* _target_it;
		_target_it = vala_iterable_iterator ((ValaIterable*) self->priv->targets);
		while (TRUE) {
			VbfTarget* target;
			if (!vala_iterator_next (_target_it)) {
				break;
			}
			target = (VbfTarget*) vala_iterator_get (_target_it);
			if (_vala_strcmp0 (target->id, id) == 0) {
				result = target;
				_vala_collection_object_unref0 (_target_it);
				return result;
			}
			_g_object_unref0 (target);
		}
		_vala_collection_object_unref0 (_target_it);
	}
	result = NULL;
	return result;
}


void vbf_group_add_target (VbfGroup* self, VbfTarget* target) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	vala_collection_add ((ValaCollection*) self->priv->targets, target);
}


ValaList* vbf_group_get_packages (VbfGroup* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->packages);
	return result;
}


void vbf_group_add_package (VbfGroup* self, VbfPackage* package) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_collection_add ((ValaCollection*) self->priv->packages, package);
	package->parent_group = self;
}


ValaList* vbf_group_get_include_dirs (VbfGroup* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->include_dirs);
	return result;
}


void vbf_group_add_include_dir (VbfGroup* self, const char* dir) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	vala_collection_add ((ValaCollection*) self->priv->include_dirs, dir);
}


ValaList* vbf_group_get_built_libraries (VbfGroup* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->built_libraries);
	return result;
}


void vbf_group_add_built_library (VbfGroup* self, const char* dir) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	vala_collection_add ((ValaCollection*) self->priv->built_libraries, dir);
}


ValaList* vbf_group_get_subgroups (VbfGroup* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->subgroups);
	return result;
}


ValaList* vbf_group_get_variables (VbfGroup* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->variables);
	return result;
}


void vbf_group_add_variable (VbfGroup* self, VbfVariable* variable) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	vala_collection_add ((ValaCollection*) self->priv->variables, variable);
}


gboolean vbf_group_has_sources_of_type (VbfGroup* self, VbfFileTypes type) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaIterator* _target_it;
		_target_it = vala_iterable_iterator ((ValaIterable*) self->priv->targets);
		while (TRUE) {
			VbfTarget* target;
			if (!vala_iterator_next (_target_it)) {
				break;
			}
			target = (VbfTarget*) vala_iterator_get (_target_it);
			if (vbf_target_has_sources_of_type (target, type)) {
				result = TRUE;
				_g_object_unref0 (target);
				_vala_collection_object_unref0 (_target_it);
				return result;
			}
			_g_object_unref0 (target);
		}
		_vala_collection_object_unref0 (_target_it);
	}
	result = FALSE;
	return result;
}


static void vbf_group_class_init (VbfGroupClass * klass) {
	vbf_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VbfGroupPrivate));
	G_OBJECT_CLASS (klass)->finalize = vbf_group_finalize;
}


static void vbf_group_instance_init (VbfGroup * self) {
	self->priv = VBF_GROUP_GET_PRIVATE (self);
	self->project = NULL;
	self->priv->packages = (ValaList*) vala_array_list_new (VBF_TYPE_PACKAGE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->include_dirs = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->built_libraries = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->targets = (ValaList*) vala_array_list_new (VBF_TYPE_TARGET, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->variables = (ValaList*) vala_array_list_new (VBF_TYPE_VARIABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->subgroups = (ValaList*) vala_array_list_new (VBF_TYPE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
}


static void vbf_group_finalize (GObject* obj) {
	VbfGroup * self;
	self = VBF_GROUP (obj);
	_g_free0 (self->name);
	_g_free0 (self->id);
	_vala_collection_object_unref0 (self->priv->packages);
	_vala_collection_object_unref0 (self->priv->include_dirs);
	_vala_collection_object_unref0 (self->priv->built_libraries);
	_vala_collection_object_unref0 (self->priv->targets);
	_vala_collection_object_unref0 (self->priv->variables);
	_vala_collection_object_unref0 (self->priv->subgroups);
	G_OBJECT_CLASS (vbf_group_parent_class)->finalize (obj);
}


GType vbf_group_get_type (void) {
	static volatile gsize vbf_group_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_group_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfGroup), 0, (GInstanceInitFunc) vbf_group_instance_init, NULL };
		GType vbf_group_type_id;
		vbf_group_type_id = g_type_register_static (G_TYPE_OBJECT, "VbfGroup", &g_define_type_info, 0);
		g_once_init_leave (&vbf_group_type_id__volatile, vbf_group_type_id);
	}
	return vbf_group_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




