/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * The editor widget was written by Thomas Mailund, so bugs should be
 * reported to <mailund@daimi.au.dk>, not the gtk ppl.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GTKEDITOR_H
#define GTKEDITOR_H

#include <gdk/gdk.h>
#include <gtk/gtktext.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_EDITOR(obj) GTK_CHECK_CAST (obj, gtk_editor_get_type (), GtkEditor)
#define GTK_EDITOR_CLASS(klass) \
  GTK_CHECK_CLASS_CAST (klass, gtk_editor_get_type (), GtkEditorClass)
#define GTK_IS_EDITOR(obj) GTK_CHECK_TYPE (obj, gtk_editor_get_type ())


  typedef struct _GtkEditor        GtkEditor;
  typedef struct _GtkEditorClass   GtkEditorClass;

  /* --<syntax tables>---------------------------------------------------- */
  typedef struct _GtkEditorSyntaxTable GtkEditorSyntaxTable;
  typedef struct _GtkEditorSTEntry GtkEditorSTEntry;

  void          gtk_editor_install_stable (GtkEditor       *editor,
					   GList           *entries);
  GList        *gtk_editor_stentry_new    (const gchar     *name,
					   const gchar     *start,
					   const gchar     *end,
					   gboolean         nest,
					   GdkFont         *font,
					   const GdkColor  *fore,
					   const GdkColor  *back,
					   GList           *next);
  void          gtk_editor_free_stentries (GList           *entries);


  /* --<highlight patterns>----------------------------------------------- */
  typedef struct _GtkEditorHilitePatterns GtkEditorHilitePatterns;

  void          gtk_editor_install_patterns (GtkEditor     *editor,
					     GList         *entries);
  GList        *gtk_editor_pentry_new     (const gchar     *name,
					   const gchar     *pattern,
					   GdkFont         *font,
					   const GdkColor  *fore,
					   const GdkColor  *back,
					   GList           *next);
  void          gtk_editor_free_pentries  (GList           *entries);


       
  /* --<the widget>------------------------------------------------------- */
  struct _GtkEditor
  {
    GtkText text;

    /* --<indenter stuff>------------------------------------------------- */
    /* one_line_ind is used for one line indenter, and is called when
     * TAB is pressed.  If the function pointer is NULL, this is
     * ignored.  This functionallity is not really implemented
     * yet...the function is called alright, but there should be some
     * other API.
     */
    void (*one_line_ind) (GtkEditor *editor);

    /* --<hilite stuff>--------------------------------------------------- */
    /* Automatic highlighting. If this flag is true (default)
     * highlighting is done automatically, when nothing else is
     * happening.  Hightlighting takes a while, so on slow boxes, you
     * might consider turning this off, and handle hightligthing
     * yourself.  This can be done by calling gtk_editor_hilite_buffer. */
    gint hilite_when_idle : 1;

    /* The syntax table associated to the object */
    GtkEditorSyntaxTable *stable;

    /* and the patterns... */
    GtkEditorHilitePatterns *patterns;

    /* don't worry about this */
    guint hilite_time;
    guint changed_from, changed_to;
    
  };

  struct _GtkEditorClass
  {
    GtkTextClass parent_class;
  };


  /* --<prototypes>------------------------------------------------------- */
  /* widget stuff */
  guint          gtk_editor_get_type               (void);
  GtkWidget*     gtk_editor_new                    (GtkAdjustment *hadj,
						    GtkAdjustment *vadj);
  
  /* search stuff */
  gboolean      gtk_editor_search_from_point       (GtkEditor     *editor,
						    gchar         *string,
						    gboolean       casein);
  gboolean      gtk_editor_search_back_from_point  (GtkEditor     *editor, 
						    gchar         *string,
						    gboolean       casein);
  gint          gtk_editor_regex_search_from_point (GtkEditor     *editor,
						    gchar         *regex);
  gint     gtk_editor_regex_search_back_from_point (GtkEditor     *editor,
						    gchar         *regex);


  /* syntax highlighting */
  gboolean       gtk_editor_check_pattern          (const gchar   *pattern);
  void           gtk_editor_hilite_buffer          (GtkEditor     *editor);
  void           gtk_editor_hilite_screen          (GtkEditor     *editor);
  void           gtk_editor_hilite_interval        (GtkEditor     *editor,
						    guint          from,
						    guint          to);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_EDITOR_H__ */
