/* 
Visual Development Kit (VDK)
version 0.01
summer '98
*/ 
#include "vdk/scrolledForm.h"
#include "vdk/vdkobj.h"

VDKScrolledForm::VDKScrolledForm(VDKApplication* app, 
				 int w, int h,
				 gchar* title, 
				 int mode,
				 GtkWindowType display):
  VDKForm(app,title,mode,display)
{
scrolledWindow = new VDKObject(this,gtk_scrolled_window_new(NULL,NULL));
gtk_widget_set_usize(scrolledWindow->Widget(),w,h);
gtk_container_border_width(GTK_CONTAINER(scrolledWindow->Widget()),1);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledWindow->Widget()),
			       GTK_POLICY_AUTOMATIC,
			       GTK_POLICY_ALWAYS);
VDKForm::Add(scrolledWindow);
}


VDKScrolledForm::VDKScrolledForm(VDKForm* owner, 
				 int w, int h,
				 gchar* title, 
				 int mode,
				 GtkWindowType display) :
  VDKForm(owner,title,mode,display)
{
scrolledWindow = 
  new VDKObject(this,gtk_scrolled_window_new(NULL,NULL));
gtk_widget_set_usize(scrolledWindow->Widget(),w,h);
gtk_container_border_width(GTK_CONTAINER(scrolledWindow->Widget()),1);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledWindow->Widget()),
			       GTK_POLICY_AUTOMATIC,
			       GTK_POLICY_ALWAYS);
VDKForm::Add(scrolledWindow);
}  
 
void 
VDKScrolledForm::Add(VDKObject* obj, int ,int ,int)
{
items.add(obj);
gtk_container_add(GTK_CONTAINER(scrolledWindow->Widget()),obj->Widget());
gtk_widget_show(obj->Widget());
obj->Parent(this);
}

  
void VDKScrolledForm::AddWithViewport(VDKObject* obj)
{
  gtk_scrolled_window_add_with_viewport(
	 GTK_SCROLLED_WINDOW( scrolledWindow->Widget()),
	 obj->Widget());
  gtk_container_set_focus_hadjustment ( 
	 GTK_CONTAINER (obj->Widget()),
	 gtk_scrolled_window_get_hadjustment 
	 (GTK_SCROLLED_WINDOW (scrolledWindow->Widget())));
  gtk_container_set_focus_vadjustment (
	 GTK_CONTAINER (obj->Widget()),
	 gtk_scrolled_window_get_vadjustment 
	 (GTK_SCROLLED_WINDOW (scrolledWindow->Widget())));
  gtk_widget_show(obj->Widget());
  obj->Parent(this);
}
