/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/coolbutton.h"

extern void PixSize(int* width, int* height, char* filename); 
void VDKCoolButton::EnterEvent(GtkWidget *wid, GdkEvent* ev, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  g_return_if_fail(ev != NULL);

  VDKCoolButton* cool = 
    reinterpret_cast<VDKCoolButton*> (gp);

  GtkWidget* button = cool->button->Widget();
  GtkWidget* pixmap = cool->pixmap->Widget();
  GtkWidget* parent = cool->parent;
  VDKPixmapButton* pixbutton = cool->button;
  if(!pixbutton->Enabled)
    return;
  if(wid != pixmap || 
     ev->type != GDK_ENTER_NOTIFY || 
     GTK_WIDGET_VISIBLE(button))
    return ;
  gtk_widget_hide(pixmap);
  if(! cool->packed)
    {
      cool->packed = true;
      gtk_box_pack_start(GTK_BOX(parent), button,FALSE,FALSE,0);
      pixbutton->Cursor = curHandPtr;
    }
  gtk_widget_show(button);
  return ;
}


void VDKCoolButton::LeaveButton(GtkWidget *wid , gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);

  VDKCoolButton* cool = 
    reinterpret_cast<VDKCoolButton*> (gp);
  g_return_if_fail(cool != NULL);

  GtkWidget* button = cool->button->Widget();
  GtkWidget* pixmap = cool->pixmap->Widget();
  if(wid != button)
    return ;
  if(GTK_WIDGET_HAS_GRAB(button))
     {
       gtk_grab_remove(button);
       gtk_widget_set_state(button,GTK_STATE_NORMAL);
       return;
     }
  gtk_widget_hide(button);
  gtk_widget_show(pixmap);
  return ;
}
/*
============================
WARNING:
#define CHILD_SPACING   1
#define DEFAULT_SPACING 3
should be checked
against new Gtk+ releases.
both defined in gtkbutton.c
============================ 
*/
#include "vdk/coolbar.h"
#define CHILD_SPACING   1
#define DEFAULT_SPACING   3
VDKCoolButton::VDKCoolButton(VDKForm* owner,
			     VDKBox *parent,
			     char** pixdata,
			     char** pixgrayed,
			     char* tip):
  VDKObject(owner),parent(parent->Widget())
{ 
  bar = NULL;
  GtkWidget* butwid;
  int width,height;
  pixmap = new VDKPixmap(owner,pixdata);
  normalPix = new VDKRawPixmap(owner,pixdata);
  if(pixgrayed)
    grayedPix = new VDKRawPixmap(owner,pixgrayed);
  else
    grayedPix = NULL;
  button = new VDKPixmapButton(owner,pixdata,NULL,tip);
  butwid = button->Widget(); 
  owner->Objects().add(pixmap);
  owner->Objects().add(button);
  widget = pixmap->Widget(); 
  // enflates pixmap to avoid flickering
  sscanf (pixdata[0],"%d %d", &width, &height);
  width += (GTK_CONTAINER (butwid)->border_width + CHILD_SPACING +
			GTK_WIDGET (butwid)->style->klass->xthickness) * 2;
  height += (GTK_CONTAINER (butwid)->border_width + CHILD_SPACING +
			 GTK_WIDGET (butwid)->style->klass->ythickness) * 2;
  if (GTK_WIDGET_CAN_DEFAULT (butwid))
    {
      width += 
	(GTK_WIDGET (butwid)->style->klass->xthickness * 2 +
	 DEFAULT_SPACING);
      height += 
	(GTK_WIDGET (butwid)->style->klass->ythickness * 2 +
	 DEFAULT_SPACING);
    }
  //
  pixmap->SetSize(width+2,height); // +2 just for fun
  
  gtk_widget_set_events(pixmap->Widget(),
			GDK_ENTER_NOTIFY_MASK ||
			GDK_LEAVE_NOTIFY_MASK);
  gtk_signal_connect (GTK_OBJECT (pixmap->Widget()), "enter_notify_event",
		      GTK_SIGNAL_FUNC(VDKCoolButton::EnterEvent),this);
  gtk_signal_connect (GTK_OBJECT (button->Widget()), "leave",
		      GTK_SIGNAL_FUNC(VDKCoolButton::LeaveButton),this);
  packed = false;

} 

void VDKCoolButton::Enable(bool flag)
{
if(!flag  && grayedPix)
  pixmap->SetPixmap(grayedPix);
else
  pixmap->SetPixmap(normalPix);
button->Enabled = flag;  
}















