
/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <string.h>
#include "treeviewcompo.h"
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define VERBOSE 1
// in pixmap.cc
extern char *mini_ofolder_xpm[];
extern char *mini_cfolder_xpm[];
// in src/pixdata.cc
extern char *testo_xpm[];
static char buff[256];

enum
{
  COLUMN_TOGGLE,
  COLUMN_TEXT,
  COLUMN_PIXBUF
};
///////////////////////////////////////////////////

DEFINE_SIGNAL_LIST(TreeViewComponent,VDKBox);
DEFINE_EVENT_LIST(TreeViewComponent,VDKBox);
DEFINE_SIGNAL_MAP(TreeViewComponent,VDKBox) 
  ON_SIGNAL(tree,realize_signal,OnTreeRealized),
  ON_SIGNAL(tree,click_column_signal,OnColumnClicked),
  ON_SIGNAL(tree,select_row_signal,OnRowSelected),
  ON_SIGNAL(tree,row_activated_signal,OnRowSelected),
  ON_SIGNAL(remove,clicked_signal,OnRemoveClicked),
  ON_SIGNAL(clear,clicked_signal,OnClearClicked),
  ON_SIGNAL(addrow,clicked_signal,OnAddrowClicked),
  ON_SIGNAL(addchild,clicked_signal,OnAddchildClicked),
  ON_SIGNAL(expand,clicked_signal,OnExpandClicked),
  ON_SIGNAL(view,clicked_signal,OnViewClicked),
  ON_SIGNAL(trasverse,clicked_signal,OnTrasverseClicked)
END_SIGNAL_MAP

// treeview model data
enum
{
  EDITABLE = 0,
  FIRST_NAME,
  LAST_NAME,
  DATE_OF_BIRTH,
  AGE,
  PARENT,
  MAX_COL
};

static struct
{
  char* title;
  int ordinal_number;
  GType gtype;
  bool viewable, editable;
} data_structure[] =
{
  {"Editable",      EDITABLE,              G_TYPE_BOOLEAN,  true, false},
  {"First name",    FIRST_NAME,            G_TYPE_STRING,   true, true},
  {"Last name",     LAST_NAME,             G_TYPE_STRING,   true, true},
  {"Date of birth", DATE_OF_BIRTH,         G_TYPE_STRING,   true, false},
  {"Age",           AGE,                   G_TYPE_STRING,   true, false},
  {"Parent",        PARENT   ,             G_TYPE_STRING,   false,false},
  {NULL,-1,0,false,false}
};

static struct
{ 
  char *firstname;
  char *lastname;
  char* parent;
  calendardate dateob; // date of birth
} persons[] =  

{
{"Tiziana",  "Tonti",       NULL,     MakeDate("19590529")},
{"Mario",    "Motta",       NULL,     MakeDate("19481118")},
{"Filippo",  "Manzaroli",   "Tiziana",MakeDate("19811105")}, 
{"Veronica", "Motta",       "both",   MakeDate("19901122")}, 
{"Martina",  "Motta",       "both",   MakeDate("20000120")},   
{"Pietro",   "Motta",       "both",   MakeDate("19960303")},   
{"Serena",   "Motta",       "Mario",  MakeDate("19750618")}, 
{"Giacomo",  "Motta",       "Veronica",   MakeDate("19981019")},
{"Daniele",  "Manzaroli",   "Tiziana",MakeDate("19780925")}, 
{ NULL,NULL, NULL, calendardate ()}
};

/*
===============================================================
*/

void 
TreeViewComponent::recurse(GtkTreeIter* iter)
{
  VDKTreeViewModel* model = tree->Model;
  VDKTreeViewModelIterator ti(model,iter);
  for(;ti;ti++)
    {
      PrintRow(ti.current());
      if(ti.HasChild())
	recurse (ti.current());
    }
}

bool
TreeViewComponent::OnTrasverseClicked (VDKObject* sender)
{
  recurse(NULL);
  return true;
}


void
TreeViewComponent::PrintRow(GtkTreeIter* iter)
{
  VDKTreeViewModel* model = tree->Model;
  VDKTreeViewModelTuple tuple;
  model->GetTuple(iter,tuple);
  for(int t = 0 ; t < tuple.size(); t++)
    {
      char* val = (char*) tuple[t];
      sprintf(buff,"[%s]", val ? val : "invalid");
      textview->TextInsert(buff);
    }
  textview->TextInsert("\n");
}

bool
TreeViewComponent::OnExpandClicked(VDKObject* sender)
{
  tree->GetSelections();
  if(tree->Selections().size() == 1)
    {
      tree->Expand(&(tree->Selections()[0]),true);
    }
  tree->Selections().flush();
  return true;
}

static int count = 0;
bool
TreeViewComponent::OnAddrowClicked(VDKObject* sender)
{
  int t = 0;
  for(;persons[t].firstname;t++)
    ;
  int rdn = rand()%t;
  VDKTreeViewModel* model = tree->Model;
  /*
    appends as top level sibling
  */
  GtkTreeIter iter;
  model->AppendBlank(&iter);
  SetData(model,&iter,rdn);
  return true;
}

bool
TreeViewComponent::OnAddchildClicked(VDKObject* sender)
{
  VDKTreeViewModel* model = tree->Model;
  tree->GetSelections();
  if(tree->Selections().size() == 1)
    {
      GtkTreeIter iter;
      model->AppendBlank(&iter,&(tree->Selections()[0]));
      int t = 0;
      for(;persons[t].firstname;t++)
	;
      int rdn = rand()%t;
      SetData(model,&iter,rdn);
      tree->Expand(&(tree->Selections()[0]));
    }

  return true;
}

bool
TreeViewComponent::OnClearClicked(VDKObject* sender)
{
  VDKTreeViewModel* model = tree->Model;
  model->Clear();
  tree->Selections().flush();
}

bool
TreeViewComponent::OnViewClicked(VDKObject* sender)
{
  tree->GetSelections();
  VDKTreeViewIterListIterator li(tree->Selections());
  for(;li;li++)
      PrintRow(&li.current());
  tree->Selections().flush();
  return true;
}
/*
 */
bool
TreeViewComponent::OnRemoveClicked(VDKObject* sender)
{
  tree->RemoveSelected();
  return true;

}

bool
TreeViewComponent::OnTreeRealized(VDKObject* sender)
{
  VDKTreeView* tree = dynamic_cast<VDKTreeView*>(sender);
  // makes model
  VDKTreeViewModel* model;
  int t;
  GType* types = new GType[MAX_COL];
  for(t=0; data_structure[t].title; t++)
    types[t] = data_structure[t].gtype;
  tree->Model = (model = new VDKTreeViewModel(types,MAX_COL));
  delete[] types;
  // makes treeview columns
  VDKTreeViewColumn* column = NULL;
  for(t=0; data_structure[t].title; t++)
    {
      if(data_structure[t].viewable)
	column = new VDKTreeViewColumn(
				       tree,
				       data_structure[t].ordinal_number, 
				       data_structure[t].title,
				       data_structure[t].editable,
				       EDITABLE);
    }
  // makes date of birth column sortable and clickable
  (*tree->Columns())[DATE_OF_BIRTH]->ActiveTitle();
  (*tree->Columns())[DATE_OF_BIRTH]->Sortable = true;
  // sets some column properties
  
  //  (*tree->Columns())[EDITABLE]->Width = 60;
  gtk_tree_view_column_set_visible ((*tree->Columns())[EDITABLE]->GtkColumn(),false);
  (*tree->Columns())[AGE]->Width = 20;
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW(tree->WrappedWidget()), TRUE);
  // load model
  t = 0;
  calendardate today;
  GtkTreeIter iter,parent_iter;  
  for (;persons[t].firstname;t++)
  {
    if (persons[t].parent ==  NULL)
      {
        model->AppendBlank(&iter,NULL);
	SetData(model,&iter,t);
      }
    else if ( (strcmp (persons[t].parent, "both")))
      {
	if(model->Find (&parent_iter, FIRST_NAME, persons[t].parent))
	  {
	    model->AppendBlank(&iter,&parent_iter);
	    SetData(model,&iter,t);
	  }
	else
	  continue;
      }
    else
      { 
	if (model->Find (&parent_iter, FIRST_NAME, "Mario"))
	  {
	    model->AppendBlank(&iter,&parent_iter);
	    SetData(model,&iter,t);
	  }
	if (model->Find (&parent_iter, FIRST_NAME, "Tiziana"))
	  {
	    model->AppendBlank(&iter,&parent_iter);
	    SetData(model,&iter,t);
	  }
      }
  }
  /*
    expands tree and selects root node
  */
    tree->Expand ();
    if(model->Root(&iter))
      tree->SelectNode(&iter);
    return true;
}

/*
 */
void 
TreeViewComponent::SetData (VDKTreeViewModel* model, GtkTreeIter* iter,  int t)
{
  calendardate today;
  sprintf (buff, "%d",today.Year ()- persons[t].dateob.Year ());
  model->SetData ( iter, 
		   EDITABLE, true,
		   FIRST_NAME, persons[t].firstname, 
		   LAST_NAME, persons[t].lastname, 
		   PARENT, persons[t].parent, 
		   DATE_OF_BIRTH, persons[t].dateob.AsString(), 
		   AGE, buff,
		   -1);
}
/*
 */
bool
TreeViewComponent::OnColumnClicked(VDKObject* sender)
{
  int sel = int(tree->SelectedColumn);
  printf("\nClicked column:%d", sel);
  fflush(stdout);
  return true;
}

bool
TreeViewComponent::OnRowSelected(VDKObject* sender)
{
  VDKTreeView* tree = dynamic_cast<VDKTreeView*>(sender);
  if(tree->Selections().size() == 0)
    tree->GetSelections();
  if(tree->Selections().size() == 1)
    {
      VDKTreeViewModelTuple tuple;
      VDKTreeViewIter p_iter;
      VDKTreeViewIter iter = tree->Selections()[0];

      VDKTreeViewModel* model = tree->Model;
      if(iter.Parent(&p_iter))
	{
	model->GetTuple(&p_iter,tuple);
	char* val = (char*) tuple[1];
	printf("\nhas parent:%s",val ? val : "invalid");
	fflush(stdout);
	}
      if(iter.Child(&p_iter))
	{
	model->GetTuple(&p_iter,tuple);
	char* val = (char*) tuple[1];
	printf("\nhas child:%s",val ? val : "invalid");
	fflush(stdout);
	}
      PrintRow(&iter);
    }
  tree->Selections().flush();
  return true;
}
/* 
 */
///////////////////////////////////////////////////

void    
TreeViewComponent::Setup() 
{
  /*
    make a new scrolled to be filled with tree
  */
  VDKScrolled *scrolled = new VDKScrolled(Owner());
  /*
    makes a tree with a void data model (will be completed on tree realize signal)
  */
  tree = new VDKTreeView(Owner(),NULL/*,GTK_SELECTION_MULTIPLE*/);
  tree->SetSize(-1,200);
  /*
    add tree to scrolled and scrolled to component box
  */
  scrolled->AddWithoutViewport(tree,l_justify,false,false,0);
  Add(scrolled);
  Add(new VDKSeparator(Owner()));
  /*
    adds a textview
  */
  textview = new VDKTextView(Owner());
  textview->SetSize(-1,100);
  Add(textview);
  /*
    adds buttons
  */
  Add(new VDKSeparator(Owner()),l_justify,false,false,0);
  VDKBox* hbox = new VDKBox(Owner(),h_box);
  remove = new VDKCustomButton(Owner(),"Remove selected");
  hbox->Add(remove,l_justify,TRUE,FALSE,5);
  view = new VDKCustomButton(Owner(),"View selected");
  hbox->Add(view,l_justify,TRUE,FALSE,5);
  clear = new VDKCustomButton(Owner(),"Clear");
  hbox->Add(clear,l_justify,TRUE,FALSE,5);
  addrow = new VDKCustomButton(Owner(),"Add a row");
  hbox->Add(addrow,l_justify,TRUE,FALSE,5);
  addchild = new VDKCustomButton(Owner(),"Add a child");
  hbox->Add(addchild,l_justify,TRUE,FALSE,5);
  expand = new VDKCustomButton(Owner(),"Expand");
  hbox->Add(expand,l_justify,TRUE,FALSE,5);
  trasverse = new VDKCustomButton(Owner(),"Trasverse");
  hbox->Add(trasverse,l_justify,TRUE,FALSE,5);
  Add(hbox,l_justify,false,false,0);
  /*
    connect to edited signal
    using libsigc extension
  */
#ifdef USE_SIGCPLUSPLUS
    tree->OnCellEdited.connect(slot(*this,&TreeViewComponent::OnCellEdited));
    tree->OnCellToggled.connect(slot(*this,&TreeViewComponent::OnCellToggled));
#endif
    /*
      initialize random generator
    */
    srand(time(NULL));
}

#ifdef USE_SIGCPLUSPLUS
void
TreeViewComponent::OnCellEdited(VDKObject* sender,
				GtkTreeIter* iter, 
				int col, char* new_text)
{
  VDKTreeView* tree = dynamic_cast<VDKTreeView*>(sender);
  if(!sender)
    return;
  else
    {
      VDKTreeViewModel* model = tree->Model;
      char* old_text = model->GetCell(iter,col);
      printf("\nedited column:%d\n\told text:%s\n\tnew text:%s",
	     col, old_text,new_text);
      fflush(stdout);
      model->SetCell(iter, col, new_text);
    }
}
/*
 */
void
TreeViewComponent::OnCellToggled(VDKObject* sender,
				GtkTreeIter* iter, 
				int col, bool toggled)
{
  VDKTreeView* tree = dynamic_cast<VDKTreeView*>(sender);
  if(!sender)
    return;
  else
    {
      VDKTreeViewModel* model = tree->Model;
      toggled = !toggled;
      model->SetCell(iter, EDITABLE, toggled ? "true" : "false");
      printf("\ntoggled column:%d\n\tvalue:%s", col, toggled ? "true" : "false");
      fflush(stdout);
    }
}
#endif




/*
  VDKTreeView*
  TreeViewComponent::MakeTree(VDKScrolled* scrolled) 
  {
  int i,z;
  GType* types = new GType[MAX_TITLES];
  GtkTreeIter iter;
  VDKTreeView *tree = new VDKTreeView(Owner(),NULL,GTK_SELECTION_SINGLE);
  types[0] = G_TYPE_STRING;
  types[1] = G_TYPE_BOOLEAN;
  types[2] = GDK_TYPE_PIXBUF;
  tree->Model = new VDKTreeViewModel(types,MAX_TITLES);
  delete types;
  VDKTreeViewColumn* column = NULL;
  column = new VDKTreeViewColumn(tree,0,"Title",true,1);
  column->Foreground = VDKRgb("navy blue");
  VDKFont* font = new VDKFont(Owner(),"courier Medium 10");
  column->Font = font;

  column = new VDKTreeViewColumn(tree,1,"Toggle");
  column->Width = 40;
  column = new VDKTreeViewColumn(tree,2,"Pixbuf");
  // sets columns 0 & 1 active
  (*tree->Columns())[0]->ActiveTitle();
  (*tree->Columns())[0]->Sortable = true;
  (*tree->Columns())[1]->ActiveTitle();
  // set a widget on 3rd column
  VDKBox* cbox = new VDKBox(Owner(),h_box);
  cbox->Add(new VDKImage(Owner(),"loadfile.xpm"));
  cbox->Add(new VDKLabel(Owner(),"Pixbuffed column"),l_justify,true,10,10);
  cbox->Visible = true;
  AddItem(cbox);
  gtk_tree_view_column_set_widget (column->GtkColumn(), cbox->WrappedWidget());
  VDKPixbuf* pixbuf = new VDKPixbuf(Owner(),"loadfile.xpm");
  VDKTreeViewModel* model = tree->Model;
  for(i = 1; i <= MAX_ROWS; i++)
    {
      sprintf(buff,"This is row %d",i);
      iter = *model->AppendBlank();
      model->SetData(&iter, 0, buff, 1,FALSE, 2, NULL, -1);
      for(z = 1; z <= MAX_DEPTH; z++)
	{
	  sprintf(buff,"Row %d - depth:%d",i,z);
	  iter = *model->AppendBlank(&iter);
	  model->SetData(&iter, 0, buff, 1, z%2 ? FALSE : TRUE, 2, pixbuf->AsGdkPixbuf(), -1);
	}
    }
  return tree;
  }
  */

/*
  dynamic signal connections, notice that since these signal are handled
  by VDK overriding GTK+ system it's necessary set last arg to false.

  SignalConnect(tree,"click_column_signal",&TreeViewComponent::OnColumnClicked,false);
  SignalConnect(tree,"select_row_signal",&TreeViewComponent::OnRowSelected,false);
  SignalConnect(tree,"row_activated_signal",&TreeViewComponent::OnRowSelected,false);
*/
/*
  g_signal_connect_data(tree->Widget(),
  "realize", G_CALLBACK(OnRealize),this,NULL,(GConnectFlags) 0);
*/
