/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_types_h
#define _vdkb_types_h

#include <vdk/vdkobj.h>
#include <vdk/value_sem_list.h>
#include <vdk/vdkstring.h>

#if HAVE_CONFIG_H
#include <config.h>
#endif

// project types
enum {
    vdk_project ,
    console_project,
    vdk_gnome_project ,
    shared_project,
    static_project
};

//
typedef struct FormEventHandlers
{
  char *items[2];
  char* method;
};

typedef struct VDKBDefaultColors
{
  char* colorname;
  int red,green,blue;
};

typedef struct OpState
{
int state, action,action_target;
VDKObject *source,*target;
};

extern OpState OperationalState;

// states
enum { op_ready = 0, op_stand_by };
// actions
enum { act_nope = 0, act_add_widget };
// targets
enum { tgt_no_target = 0 };
// form type
enum { type_vdk_form, type_vdk_gnomeform };
/*
tools palette
*/
/* containers widgets */
#define CONTAINERS_TOOL_BEGIN 0x2000 /* 8 k */

#define CONTAINERS_TOOL_VBOX      CONTAINERS_TOOL_BEGIN
#define CONTAINERS_TOOL_HBOX      CONTAINERS_TOOL_BEGIN+1
#define CONTAINERS_TOOL_FRAME     CONTAINERS_TOOL_BEGIN+2
#define CONTAINERS_TOOL_TABLE     CONTAINERS_TOOL_BEGIN+3
#define CONTAINERS_TOOL_VPANED    CONTAINERS_TOOL_BEGIN+4
#define CONTAINERS_TOOL_HPANED    CONTAINERS_TOOL_BEGIN+5
#define CONTAINERS_TOOL_NBOOK     CONTAINERS_TOOL_BEGIN+6
#define CONTAINERS_TOOL_HANDLE    CONTAINERS_TOOL_BEGIN+7
#define CONTAINERS_TOOL_TOOLBAR   CONTAINERS_TOOL_BEGIN+8
#define CONTAINERS_TOOL_SCROLLED  CONTAINERS_TOOL_BEGIN+9
#define CONTAINERS_TOOL_MENUBAR   CONTAINERS_TOOL_BEGIN+10
#define CONTAINERS_TOOL_VRADIOBG  CONTAINERS_TOOL_BEGIN+11
#define CONTAINERS_TOOL_HRADIOBG  CONTAINERS_TOOL_BEGIN+12
#define CONTAINERS_TOOL_FIXED     CONTAINERS_TOOL_BEGIN+13

#define CONTAINERS_TOOL_END       CONTAINERS_TOOL_FIXED
#define IS_A_CONTAINER(x) \
(( (x) >= CONTAINERS_TOOL_BEGIN) && ( (x) <= CONTAINERS_TOOL_END))

/* button widgets */
#define BUTTON_TOOL_BEGIN 0x2400 /* 9 k */

#define BUTTON_TOOL_CUSTOM_BUTTON  BUTTON_TOOL_BEGIN
#define BUTTON_TOOL_SPIN_BUTTON    BUTTON_TOOL_BEGIN+1
#define BUTTON_TOOL_CHECK_BUTTON   BUTTON_TOOL_BEGIN+2
#define BUTTON_TOOL_RADIO_BUTTON   BUTTON_TOOL_BEGIN+3
#define BUTTON_TOOL_END            BUTTON_TOOL_RADIO_BUTTON

/* text widgets */
#define IS_A_BUTTON(x) \
(( (x) >= BUTTON_TOOL_BEGIN) && ( (x) <= BUTTON_TOOL_END))

#define TEXT_TOOL_BEGIN 0x2800 /* 10 k */

#define TEXT_TOOL_LABEL  TEXT_TOOL_BEGIN
#define TEXT_TOOL_ENTRY  TEXT_TOOL_BEGIN+1
#define TEXT_TOOL_TEXT   TEXT_TOOL_BEGIN+2

#define TEXT_TOOL_END    TEXT_TOOL_TEXT

#define IS_A_TEXT(x) \
(( (x) >= TEXT_TOOL_BEGIN) && ( (x) <= TEXT_TOOL_END))

/* miscellanous widgets */
#define MISC_TOOL_BEGIN 0x2C00 /* 11 k */

#define MISC_TOOL_CANVAS       MISC_TOOL_BEGIN
#define MISC_TOOL_PIXMAP       MISC_TOOL_BEGIN+1
#define MISC_TOOL_IMAGE        MISC_TOOL_BEGIN+2
#define MISC_TOOL_PROGRESS     MISC_TOOL_BEGIN+3
#define MISC_TOOL_SLIDER       MISC_TOOL_BEGIN+4
#define MISC_TOOL_STATUSBAR    MISC_TOOL_BEGIN+5
#define MISC_TOOL_TIMER        MISC_TOOL_BEGIN+6
#define MISC_TOOL_CUSTOMLIST   MISC_TOOL_BEGIN+7
#define MISC_TOOL_COMBOBOX     MISC_TOOL_BEGIN+8
#define MISC_TOOL_CUSTOMTREE   MISC_TOOL_BEGIN+9
#define MISC_TOOL_HSEPARATOR   MISC_TOOL_BEGIN+10
#define MISC_TOOL_VSEPARATOR   MISC_TOOL_BEGIN+11
#define MISC_TOOL_PLACEHOLDER  MISC_TOOL_BEGIN+12
#define MISC_TOOL_END          MISC_TOOL_PLACEHOLDER
/*
#define MISC_TOOL_TREEVIEW     MISC_TOOL_BEGIN+13
#define MISC_TOOL_MENU_ITEM    MISC_TOOL_BEGIN+14
#define MISC_TOOL_GRID         MISC_TOOL_BEGIN+15
#define MISC_TOOL_END          MISC_TOOL_MENU_ITEM
*/
#define IS_A_MISC(x) \
(( (x) >= MISC_TOOL_BEGIN) && ( (x) <= MISC_TOOL_END))

/* plugin support */
#define PLUGIN_TOOL_BEGIN 0x3000  /* 12 k */

/* gnome support */
#if HAVE_GNOME
#define GNOME_TOOL_BEGIN 0x3400 /* 13 k */
#define GNOME_TOOL_STATUSBAR   GNOME_TOOL_BEGIN
#define GNOME_TOOL_DATEEDIT    GNOME_TOOL_BEGIN+1
#define GNOME_TOOL_ENTRY       GNOME_TOOL_BEGIN+2
#define GNOME_TOOL_END         GNOME_TOOL_ENTRY
#define IS_A_GNOME(x) \
(( (x) >= GNOME_TOOL_BEGIN) && ( (x) <= GNOME_TOOL_END))
#endif

/* xdb tools */
#if USE_XDB
#define XDB_TOOL_BEGIN 0x3800 /* 14 k */
#define XDB_TOOL_ENTRY         XDB_TOOL_BEGIN
#define XDB_TOOL_CUSTOMLIST    XDB_TOOL_BEGIN+1
#define XDB_TOOL_CHECK_BUTTON  XDB_TOOL_BEGIN+2
#define XDB_TOOL_MEMO          XDB_TOOL_BEGIN+3
#define XDB_TOOL_END           XDB_TOOL_MEMO
#define IS_A_XDB(x) \
(( (x) >= XDB_TOOL_BEGIN) && ( (x) <= XDB_TOOL_END))
#endif

/*
 main form toolbar buttons
*/
#define NEW_PROJECT_BUTTON   0
#define NEW_UNIT_BUTTON      1
#define NEW_FORM_BUTTON      2
#define OPEN_PRJ_BUTTON      3
#define OPEN_FILE_BUTTON     4
#define SAVE_PRJ_BUTTON      5
#define SAVE_FILE_BUTTON     6
/*
 main form toolbar1 buttons
*/
//#define ADD_TO_PROJECT       0
//#define REMOVE_FROM__PROJECT 1
#define UNIT_LIST            0
#define TOGGLE_FORM_UNIT     1
#define FORM_LIST            2
#define RUN_PRJ_BUTTON       3
/*
 project manager toolbar buttons
*/
#define ADD_UNIT_BUTTON        1
#define REMOVE_UNIT_BUTTON     2
#define ACTIVATE_EDITOR_BUTTON 3
#define FORM_PROPS_BUTTON      4
/*
 class viewer toolbar buttons
*/
//#define ADD_FUNCTION_BUTTON    0
#define DECLARATION_BUTTON     0
#define DEFINITION_BUTTON      1
#define UPDATE_CLASS_BUTTON    2
/*
 locale
*/
#define ITALIAN 0
#define ENGLISH 1
#define FRENCH 2
#define SPANISH 3
#define GERMAN 4
#define JAPANESE 5
#define VDKB_USAGE "\nVDK Builder usage: vkdb2 [arg] &\n\
arg:\n\
-it = italian\n\
-en = english\n\
-fr = french\n\
-sp = spanish\n\
-de = german\n\
(default english)\n"

/*
misc
*/
#define CORRECT_PROJECT_FILE (char*) "#VDK Builder 0.1# project file#"
#define VDKB_RESOURCE_FILE (char*) "res/vdkbrc"
#define VDKB_PLUGIN_FILE (char*) "res/plugins.db"
#define VDKB_TOKENS_FILE (char*) "res/tokens.db"
#define VDKB_HINT_FILE     (char*) "res/cpphints"
#define VDKB_LOGO          (char*) "res/logo.png"
#define VDKB_HELP_INDEX    (char*) "res/index.htm"
#define VDKBVERSION        (char*) "VDKBuilder 2.0.5"
#define APPNAME            (char*) "VDKBuilder"
#define VDKB_LOCKFILE       (char*) ".vdkblock"
#define VDKB_RGB           (char*) "rgb.txt"
#define CHECK_TRUE         (char*) "true"
#define CHECK_FALSE        (char*) "false"
#define CHECK_YES          (char*) "yes"
#define CHECK_NO           (char*) "no"
#define SOURCE_END_MARK    "#!#\n"
/*
vdkb  maker
*/
typedef VDKValueList<VDKString> VDKBStringList;
typedef VDKValueListIterator<VDKString> VDKBStringListIterator;
/*
 ide defaults
*/
#define DEFAULTS_FILE      (char*) "res/vdkbide.defaults"
#define FORM_EXT           (char*) "frm"
#endif

/*
defines for parser
*/
#define PARSER_CLASS            "class:"
#define PARSER_THIS             "this:"
#define PARSER_PARENT           "parent:"

// statements
#define STATEMENT_ADD           "Add"
#define STATEMENT_ADD_NO_VIEWPORT           "AddWithoutViewport"
#define STATEMENT_VISIBLE       "Visible"

// common to all widgets
#define NORMALBACKGROUND        "NormalBackground"
#define PRELIGHTBACKGROUND      "PrelightBackground"
#define INSENSITIVEBACKGROUND   "InsensitiveBackground"
#define ACTIVEBACKGROUND        "ActiveBackground"
#define SELECTEDBACKGROUND      "SelectedBackground"
#define FOREGROUND              "Foreground"
#define FONT                    "Font"
#define ENABLED                 "Enabled"
#define CURSOR                  "Cursor"
#define USIZE                   "Usize"
#define VISIBLE                 "Visible"
#define BACKPIX                 "BackgroundPixmap"
#define TITLE                   "Title"
#define JUSTIFY_INTERNAL         "_justify"
#define EXPAND_INTERNAL         "_Expand"
#define DECLARE_PUBLIC          "declare_public"
#define FILL_INTERNAL           "_Fill"
#define PADDING_INTERNAL        "_Padding"
#define TIP                     "Tip"
#define TAG                     "Tag"
#define LABEL                   "Label"
#define TABLEROW                "TableRow"
#define TABLECOL                "TableCol"


/*
defines for properties
*/
// common to all widgets

#define PROP_NORMALBACKGROUND        "NormalBackground:"
#define PROP_PRELIGHTBACKGROUND      "PrelightBackground:"
#define PROP_INSENSITIVEBACKGROUND   "InsensitiveBackground:"
#define PROP_ACTIVEBACKGROUND        "ActiveBackground:"
#define PROP_SELECTEDBACKGROUND      "SelectedBackground:"
#define PROP_FOREGROUND              "Foreground:"
#define PROP_FONT                    "Font:"
#define PROP_ENABLED                 "Enabled:"
#define PROP_CURSOR                  "Cursor:"
#define PROP_USIZE                   "Usize:"
#define PROP_VISIBLE                 "Visible:"
#define PROP_TITLE                   "Title:"
#define PROP_BACKPIX                 "BackgroundPixmap:"
#define PROP_JUSTIFY_INTERNAL        "_justify:"
#define PROP_EXPAND_INTERNAL         "_Expand:"
#define PROP_FILL_INTERNAL           "_Fill:"
#define PROP_PADDING_INTERNAL        "_Padding:"
#define PROP_TIP                     "Tip:"
#define PROP_TAG                     "Tag:"
#define PROP_LABEL                   "Label:"
#define PROP_TABLEROW                "TableRow:"
#define PROP_TABLECOL                "TableCol:"
#define PROP_DECLARE_PUBLIC          "declare_public:"

/*
specific to widgets
*/
#define PROP_FOCUSWIDGET             "FocusWidget:"
#define PROP_FREEZE_USIZE            "FreezeUsize:"
#define PROP_DISPLAY_TYPE            "DisplayType:"
#define PROP_WINPOS                  "InitialPosition:"
#define PROP_CAPTION                 "Caption:"
#define PROP_CAPTIONWRAP             "CaptionWrap:"
#define PROP_RELIEF                  "Relief:"
#define PROP_PIXMAPPED_INTERNAL      "pixmapped:"
#define PROP_CB_TYPE_INTERNAL        "cbtype:"
#define PROP_CB_POS_INTERNAL         "labelpos:"

#define PROP_EDITABLE                "Editable:"
#define PROP_SORTED                  "Sorted:"
#define PROP_HIDDEN                  "Hidden:"
#define PROP_CASESENSITIVE           "CaseSensitive:"

#define PROP_GLYPH                   "Glyph:"
#define PROP_GLYPH_BYDATA            "GlyphBydata:"
#define PROP_VPOLICY                 "VPolicy:"
#define PROP_HPOLICY                 "HPolicy:"
#define PROP_BORDERSHADOW            "BorderShadow:"
#define PROP_ROWHEIGHT               "RowHeight:"
#define PROP_AUTORESIZE              "AutoResize:"
#define PROP_SELECTIONMODE           "SelectionMode:"
#define PROP_COLUMNS_INTERNAL        "Columns:"
#define PROP_TITLES_INTERNAL         "Titles:"

#define PROP_TEXT                    "Text:"
#define PROP_EDITABLE                "Editable:"
#define PROP_HIDDEN                  "Hidden:"
#define PROP_MAXCHARS                "MaxChars:"

#define PROP_COLWIDTH                "ColWidth:"
#define PROP_ROWS_INTERNAL           "Rows:"
#define PROP_COLUMNS_INTERNAL        "Columns:"
#define PROP_COLVISIBLE              "ColVisible:"
#define PROP_ROWVISIBLE              "RowVisible:"
#define PROP_VIEWPORT_INTERNAL       "Viewport:"

#define PROP_BARBLOCKCOUNT           "BlockCount:"
#define PROP_BARSTYLE                "BarStyle:"
#define PROP_BARORIENTATION          "BarOrientation:"
#define PROP_BARACTIVITYMODE         "ActivityMode:"
#define PROP_BARMIN                  "Min:"
#define PROP_BARMAX                  "Max:"

#define PROP_PHOLDER_CTOR            "Ctor:"

#define PROP_SHADOW                  "Shadow:"

#define PROP_SEPARATOR_MODE          "mode:"

#define PROP_SLIDER_DIGITS           "Digits:"
#define PROP_SLIDER_STEP             "Step:"
#define PROP_SLIDER_LOWER            "Lower:"
#define PROP_SLIDER_UPPER            "Upper:"
#define PROP_SLIDER_UPDATE_POLICY    "UpdatePolicy:"
#define PROP_SLIDER_DEFVALUE         "DefValue:"

#define PROP_SPIN_CLIMB              "Climb:"

#define PROP_JUSTIFY                 "Justify:"

#define PROP_WORDWRAP                "WordWrap:"

// for containers
#define PROP_BORDERWIDTH             "BorderWidth:"
#define PROP_HAVEGRID                "have_grid:"
#define PROP_GRIDHSPACE              "h_grid_spacing:"
#define PROP_GRIDVSPACE              "v_grid_spacing:"
#define PROP_EVENTAWARE              "event-aware:"   
#define PROP_DOCKABLE                "dockable:"
#define PROP_ALIGN                   "Align:"
#define PROP_ROWSPACING              "RowSpacing:"
#define PROP_COLSPACING              "ColSpacing:"
#define PROP_HOMOGENEOUS             "Homogeneous:"
#define PROP_SCROLLABLE              "Scrollable:"
#define PROP_POPUP                   "PopUp:"
#define PROP_TBORIENTATION           "Orientation:"
#define PROP_TBSTYLE                 "Style:"
#define PROP_TBSPACING               "Spacing:"
// for gnome support
// vdkgnome application bar
#define PROP_STATUS_INTERNAL         "_status:"
#define PROP_PROGRESS_INTERNAL       "_progress:"
// vdkgnome date edit
#define PROP_SHOWTIME_INTERNAL         "_showtime:"
#define PROP_FORMAT24_INTERNAL         "_format24:"
// vdkgnome entry
#define PROP_HISTORY_INTERNAL         "_history:"
#define PROP_MAXSAVED                 "MaxSaved:"
// vdkxdb support
#define PROP_ASSIGNTABLE               "assign-table:"
#define PROP_ASSIGNFIELD               "assign-field:"
// 
/*
props names
*/
#define FREEZE_USIZE                 "FreezeUsize"
#define FOCUSWIDGET                  "FocusWidget"
#define DISPLAY_TYPE                 "DisplayType"
#define WINPOS                       "InitialPosition"
#define CAPTION                      "Caption"
#define CAPTIONWRAP                  "CaptionWrap"
#define RELIEF                       "Relief"
#define PIXMAPPED_INTERNAL           "pixmapped"
#define CB_TYPE_INTERNAL             "cbtype"
#define CB_POS_INTERNAL              "labelpos"
#define EDITABLE                     "Editable"
#define SORTED                       "Sorted"
#define HIDDEN                       "Hidden"
#define CASESENSITIVE                "CaseSensitive"

#define GLYPH                        "Glyph"
#define GLYPH_BYDATA                 "GlyphBydata"

#define VPOLICY                      "VPolicy"
#define HPOLICY                      "HPolicy"
#define BORDERSHADOW                 "BorderShadow"
#define ROWHEIGHT                    "RowHeight"
#define AUTORESIZE                   "AutoResize"
#define SELECTIONMODE                "SelectionMode"
#define TITLES_INTERNAL              "Titles"

#define TEXT                         "Text"
#define EDITABLE                     "Editable"
#define HIDDEN                       "Hidden"
#define MAXCHARS                     "MaxChars"

#define COLWIDTH                     "ColWidth"
#define ROWS_INTERNAL                "Rows"
#define COLUMNS_INTERNAL             "Columns"
#define COLVISIBLE                   "ColumnTitleVisible"
#define ROWVISIBLE                   "RowTitleVisible"
#define VIEWPORT_INTERNAL            "Viewport"

#define BARBLOCKCOUNT                "BlockCount"
#define BARSTYLE                     "BarStyle"
#define BARORIENTATION               "BarOrientation"
#define BARACTIVITYMODE              "ActivityMode"
#define BARMIN                       "Min"
#define BARMAX                       "Max"

#define PHOLDER_CTOR                 "Ctor"

#define SHADOW                       "Shadow"

#define SEPARATOR_MODE               "mode"

#define SLIDER_DIGITS                "Digits"
#define SLIDER_STEP                  "Step"
#define SLIDER_LOWER                 "Lower"
#define SLIDER_UPPER                 "Upper"
#define SLIDER_UPDATE_POLICY         "UpdatePolicy"
#define SLIDER_DEFVALUE              "DefValue"

#define SPIN_CLIMB                   "Climb"

#define JUSTIFY                      "Justify"

#define WORDWRAP                     "WordWrap"
// for containers
#define BORDERWIDTH                  "BorderWidth"
#define HAVEGRID                     "have_grid"
#define GRIDHSPACE                   "h_grid_spacing"
#define GRIDVSPACE                   "v_grid_spacing"
#define EVENTAWARE                   "event-aware"
#define DOCKABLE                     "dockable"
#define ALIGN                        "Align"
#define ROWSPACING                   "RowSpacing"
#define COLSPACING                   "ColSpacing"
#define HOMOGENEOUS                  "Homogeneous"
#define SCROLLABLE                   "Scrollable"
#define POPUP                        "PopUp"
#define TBORIENTATION                "Orientation"
#define TBSTYLE                      "Style"
#define TBSPACING                    "Spacing"
// for gnome support
// vdkgnome application bar
#define STATUS_INTERNAL         "_status"
#define PROGRESS_INTERNAL       "_progress"
// vdkgnome date edit
#define SHOWTIME_INTERNAL         "_showtime"
#define FORMAT24_INTERNAL         "_format24"
// vdkgnome entry
#define HISTORY_INTERNAL         "_history"
#define MAXSAVED                 "MaxSaved"
// vdkxdb support
#define ASSIGNTABLE              "assign-table"
#define ASSIGNFIELD              "assign-field"
/*
Signals names && nicknames
Default response method name will be made by:
On<object name><nickname>.
For instance if object name = <Abutton> and nickname = <Click>
default response method name will be: <OnAbuttonClick>
*/
#define SIGNAL_REALIZE               "realize_signal"
#define SIGNAL_CLICKED               "clicked_signal"
#define SIGNAL_ENTER                 "enter_signal"
#define SIGNAL_LEAVE                 "leave_signal"
#define SIGNAL_TOGGLED               "toggled_signal"
#define SIGNAL_ACTIVATE              "activate_signal"
#define SIGNAL_CHANGED               "changed_signal"
#define SIGNAL_SELECTION_CHANGED     "selection_changed_signal"
#define SIGNAL_FOCUS_IN              "focus_in_signal"
#define SIGNAL_FOCUS_OUT             "focus_out_signal"
#define SIGNAL_SELECT_ROW            "select_row_signal"
#define SIGNAL_UNSELECT_ROW          "unselect_row_signal"
#define SIGNAL_CLICK_COLUMN          "click_column_signal"
#define SIGNAL_SELECT_NODE           "select_node_signal"
#define SIGNAL_UNSELECT_NODE         "unselect_node_signal"
#define SIGNAL_VALUE_CHANGED         "value_changed_signal"
#define SIGNAL_REALIZED              "realize_signal"
#define SIGNAL_DATE_CHANGED          "date_changed"
#define SIGNAL_TIME_CHANGED          "time_changed"
#define SIGNAL_ROW_ACTIVATED         "row_activated_signal"

#define NICK_REALIZE                 "Realize"
#define NICK_CLICKED                 "Click"
#define NICK_ENTER                   "Enter"
#define NICK_LEAVE                   "Leave"
#define NICK_TOGGLED                 "Toggled"
#define NICK_ACTIVATE                "Activate"
#define NICK_CHANGED                 "Changed"
#define NICK_SELECTION_CHANGED       "SelectionChanged"
#define NICK_FOCUS_IN                "FocusIn"
#define NICK_FOCUS_OUT               "FocusOut"
#define NICK_SELECT_ROW              "SelectRow"
#define NICK_ROW_ACTIVATED           "RowActivated"
#define NICK_UNSELECT_ROW            "UnselectRow"
#define NICK_CLICK_COLUMN            "ClickColumn"
#define NICK_SELECT_NODE             "SelectNode"
#define NICK_UNSELECT_NODE           "UnselectNode"
#define NICK_VALUE_CHANGED           "ValueChanged"
#define NICK_REALIZED                "Realize"
#define NICK_DATE_CHANGED            "DateChanged"
#define NICK_TIME_CHANGED            "TimeChanged"
