/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_evcontain.h>
//#include <vdkb2/vdkb_labelbutton.h>
#include <vdkb2/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_paned.h>
#include <vdkb2/vdkb_notebook.h>
#include <vdkb2/vdkb_table.h>
#include <vdkb2/vdkb_frame.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>

static char buff[128];
extern char* wi_widget_prompts[];

int VDKBEventBox::Counter = 0;
#define VERBOSE 0
/*
 properties
 */
char* vdkbox_props[] = { EVENTAWARE,DOCKABLE,0 };

DEFINE_EVENT_LIST(VDKBEventBox,VDKBEventContainer);
DEFINE_SIGNAL_LIST(VDKBEventBox,VDKBEventContainer);


/*
 */
bool
VDKBEventBox:: DelBox(VDKObject* sender)
{
  // not good OOP design here :-(
  // sorry.
  // box embedded can't be deleted
  bool cantDelete = (sender != NULL) && dynamic_cast<VDKBPaned*>(Parent());
  if(! cantDelete)
    cantDelete = (sender != NULL) && dynamic_cast<VDKBGuiNotebook*>(Parent());
  if(! cantDelete)
    cantDelete = (sender != NULL) && dynamic_cast<VDKBTable*>(Parent());
  if(! cantDelete)
    cantDelete = (sender != NULL) && dynamic_cast<VDKBFrame*>(Parent());
  if(cantDelete)
    {
    //FIX ME: lang support
      Owner()->Application()->MessageBox(APPNAME,
			 _("Embedded boxes shouldn't be deleted"),
			  MB_ICONINFORMATION|MB_OK,
			  _(user_messages[user_ok]));
      return true;
    }
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  // call ancestor delete box
  VDKBEventContainer::DelBox(this);
  // notify to inspector that object was deleted
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
VDKBEventBox::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}
/*
 */
bool
VDKBEventBox::Split(VDKObject* sender)
{
  VDKBGuiForm* owner = dynamic_cast<VDKBGuiForm*>(Owner());
  if(owner)
    {
      int mode = Mode();
      for(sprintf(buff,"%cbox%d",mode == v_box ? 'v': 'h',
		  VDKBEventBox::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"%cbox%d", mode == v_box ? 'v': 'h',
		 VDKBEventBox::Counter);
      VDKBEventBox* newbox = new VDKBEventBox(buff,this,mode);
      Add(newbox);
      sprintf(buff,"%cbox%d",
	      mode == v_box ? 'v': 'h',
	      VDKBEventBox::Counter);
      newbox = new VDKBEventBox(buff,this,mode);
      Add(newbox);
      //      owner->Changed = true;
    }
  return true;
}
/*
 */
bool
VDKBEventBox::AddVBox(VDKObject* sender)
{
  VDKBGuiForm* owner = dynamic_cast<VDKBGuiForm*>(Owner());
  if(owner)
    {
      for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      VDKBEventBox* newbox = new VDKBEventBox(buff,this);
      Add(newbox);
      owner->Changed = true;
    }
  return true;
}
/*
 */
bool
VDKBEventBox::AddHBox(VDKObject* sender)
{
  VDKBGuiForm* owner = dynamic_cast<VDKBGuiForm*>(Owner());
  if(owner)
    {
      for(sprintf(buff,"hbox%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"hbox%d",VDKBEventBox::Counter);
      VDKBEventBox* newbox = new VDKBEventBox(buff,this,h_box);
      Add(newbox);
      owner->Changed = true;
    }
  return true;
}

/*
======================================================================
 */
extern bool onDraggingAnObjectIntoAFixed;
// plm patch
// extern GtkWidget *grabbed_widget;
extern "C"
{
GtkWidget* get_event_widget (GtkWidget *widget,
			     GdkWindow *window,
			     gint x, gint y,
			     gint * x_return,
			     gint * y_return);
}


bool
VDKBEventBox::OnButtonPressed(VDKObject* sender, GdkEvent* ev)
{
  //  VDKBEventContainer* container = NULL;
  GdkEventButton* event = (GdkEventButton*) ev;
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
  		       "button_press_event");
#if VERBOSE
  printf("\nVDKBEventBox::ButtonPressed");
  fflush(stdout);
#endif
  // pass to ancestor so widget will be marked
  // ** WARNING ** do not pass <sender>,
  // since this is the canvas  when box
  // is empty  and is destroyed
  // and replaced by an widget before HandleFixed
  // manages it
  VDKBEventContainer::OnButtonPressed(this,ev);
  // we allow only button 1 (3 is rerved for pop menu)
  if((event->button == 1) )
    // if the box is contained into a fixed
    // allows moving/resizing job
    onDraggingAnObjectIntoAFixed = HandleFixed(this, event);
  return true;
}
/*
overrides VDKObject::OnMouseMove to pass
<this> since normal sender is <canvas>
(boc place holder)
 */
bool
VDKBEventBox::OnMouseMove(VDKObject* sender, GdkEvent* ev)
{
#if VERBOSE
  printf("\nVDKBEventBox::OnMouseMove");
  fflush(stdout);
#endif
  VDKBObject::OnMouseMove(this,ev);
  return true;
}

/*
 */
bool
VDKBEventBox::OnButtonReleased(VDKObject* sender, GdkEvent* event)
{
#if VERBOSE
  printf("\nVDKBEventBox::OnButtonRelease");
  fflush(stdout);
#endif
  /*
    plm patch
  if(grabbed_widget)
    {
      gtk_grab_remove(grabbed_widget);
      grabbed_widget = NULL;
    }
  */
  SetCursor(curDefault);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
			       "button_release_event");
  onDraggingAnObjectIntoAFixed = false;
  return true;
}
///////////////////////////////////////////////////////////////////////
/*
Makes an insensitive empty box.
(used by VDKBForm::Setup()
 */
VDKBEventBox::VDKBEventBox(char* name,
			   VDKForm* owner,bool empty):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  AddBox();
}
/*
Makes a box thats is owned by a form
 */
VDKBEventBox::VDKBEventBox(char* name,
			   VDKForm* owner, int mode, int w, int h):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  Init(w,h);
}
/*
makes a box owned by another box
 */
VDKBEventBox::VDKBEventBox(char* name,
			   VDKBEventContainer* outer, int mode, int w, int h):
    VDKBEventContainer(name,outer->Owner())
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  VDKBEventContainer::mode = mode;
  Init(w,h);
 }
/*
 */
void
VDKBEventBox::Init(int w, int h)
{
  int t;
  bool haveMenu = true;
  PreviewFlag = true;
  // add to VDKBox properties box properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkbox_props[t]; t++)
    proplist.add(VDKBProperty(vdkbox_props[t]));
  AddBox();
  AddCanvas(w,h);
  // makes a pop menu, excluding embedded boxes into tables
  // that can't be splitted, swapped or removed
  // FIX ME: see if it is possible remove this limitation
  //  if(outerbox != NULL)
  //  haveMenu = (dynamic_cast<VDKBTable*>(outerbox) == NULL);
  haveMenu = true;
  if(haveMenu)
    {
      popmenu = new VDKBContainerPopMenu(this);
      bool canDelete = true;
      // boxes embedded into a table, paned, frame
      // and notebook shouldn't be deleted
      if(outerbox)
	canDelete =
	  (! dynamic_cast<VDKBPaned*>(outerbox)) &&
	  (! dynamic_cast<VDKBGuiNotebook*>(outerbox)) &&
	  (! dynamic_cast<VDKBFrame*>(outerbox)) &&
	  (! dynamic_cast<VDKBTable*>(outerbox)) ;
      setsize = new VDKMenuItem(popmenu,_(wi_widget_prompts[19]));
      selectparent =  new VDKMenuItem(popmenu,_(wi_widget_prompts[20]));
      SignalConnect(selectparent,"activate",
		&VDKBEventBox::SelectParentContainer);
	
      if(canDelete)
	{
	  popmenu->Separator();
	  delBox = new VDKMenuItem(popmenu,_(wi_widget_prompts[21]));
	}
      else
	delBox = NULL;
      if(canDelete)
	SignalConnect(delBox,"activate",&VDKBEventBox::DelBox);
      SignalConnect(setsize,"activate",&VDKBEventBox::SetBoxSize);
      /*
	assign this as parent so this can receive signals
      */
      popmenu->Parent(this);
      popmenu->Setup();
      /*
	better add it to owner, so will be surely
	destroyed even if never popped
      */
      Owner()->AddItem(popmenu);
    }
  else
    popmenu = NULL;
  // since box is created with a canvas inside
  // we connect the canvas
  if(canvas)
    {
      // these handlers ovverride VDKObject ones
      slot = EventConnect(canvas,"button_press_event",
			  &VDKBEventBox::OnButtonPressed);
      EventConnect(canvas,"button_release_event",
		   &VDKBObject::ButtonReleased);
      // others are inherited by VDKObject.
      EventConnect(canvas,"motion_notify_event", &VDKBEventBox::OnMouseMove);
      EventConnect("leave_notify_event",&VDKBObject::OnLeave);
      EventConnect("enter_notify_event",&VDKBObject::OnEnter);
    }
  // these handlers ovverride VDKObject ones
  EventConnect("button_press_event",
	       &VDKBEventBox::OnButtonPressed);
  EventConnect("motion_notify_event",&VDKBEventBox::OnMouseMove);
  // others are inherited by VDKObject.
  EventConnect("button_release_event",&VDKBObject::ButtonReleased);
  EventConnect("enter_notify_event",&VDKBObject::OnEnter);
  EventConnect("leave_notify_event",&VDKBObject::OnLeave);
}
////////////////////////////////////////
/*
 */
void
VDKBEventBox::AddBox()
{
  switch(mode)
    {
    case v_box:
      container = gtk_vbox_new(FALSE,0);
      break;
    case h_box:
      container = gtk_hbox_new(FALSE,0);
      break;
    default:
      container = gtk_vbox_new(FALSE,0);
    }
  gtk_container_add(GTK_CONTAINER(widget),container);
}

/*
 */
void
VDKBEventBox::AddCanvas(int w, int h)
{

  canvas = new VDKBCanvas(Name(),Owner(),w,h);
  VDKRgb gray70("gray70");
  if(gray70.IsValid())
    canvas->NormalBackground = gray70;
  Add(canvas);

}
/*
 */
void
VDKBEventBox::Add(VDKObject* obj, int justify,
		 int expand, int fill , int padding)
{
  // avoid to destroy himself
  if(canvas && canvas != obj)
    {
      boxlist.remove(canvas);
      if(slot)
	gtk_signal_disconnect(GTK_OBJECT(canvas->WrappedWidget()),slot);
      RemoveObject(canvas);
      canvas = NULL;
      VDKRgb gray70("gray70");
      if(gray70.IsValid())
      NormalBackground = gray70;
    }
  switch(justify)
    {
    case l_justify:
      gtk_box_pack_start(GTK_BOX(container),
			 obj->Widget(),expand,fill,padding);
      break;
    case r_justify:
      gtk_box_pack_end(GTK_BOX(container),
		       obj->Widget(),expand,fill,padding);
      break;
    default:
      gtk_box_pack_start(GTK_BOX(container),
			 obj->Widget(),expand,fill,padding);
    }
  VDKRgb gray70("gray70");
  if(gray70.IsValid())
    obj->NormalBackground = gray70;
  gtk_widget_show(container);
  VDKBEventContainer::Add(obj,justify,expand,fill,padding);
 }
/*
 */
void
VDKBEventBox::AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  // for now we use defaults:
  if(!forceArgs)
    {
      justify = l_justify;
      expand = PreviewFlag ? true : false;
      fill = PreviewFlag ? true : false;
      padding = PreviewFlag ? true : false;
    }
  if(canvas)
     {
       boxlist.remove(canvas);
       RemoveObject(canvas);
       canvas = NULL;
       VDKRgb gray70("gray70");
       if(gray70.IsValid())
	 NormalBackground = gray70;
    }

  switch(justify)
    {
    case l_justify:
      gtk_box_pack_start(GTK_BOX(container),
			 wid->Widget(),expand,fill,padding);
      break;
    case r_justify:
      gtk_box_pack_end(GTK_BOX(container),
		       wid->Widget(),expand,fill,padding);
      break;
    default:
      gtk_box_pack_start(GTK_BOX(container),
			 wid->Widget(),expand,fill,padding);
    }
  // adding a nested box set border width to 0
  VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(wid);
  if(vdkbobj)
    {
      VDKBEventBox* box = dynamic_cast<VDKBEventBox*>(vdkbobj);
      if(box)
	{
	  box->BorderWidth(0);
	  box->SetPropValue(BORDERWIDTH,"0");
	}
    }
  gtk_widget_show(container);
  VDKBEventContainer::Add(wid,l_justify,expand,fill,padding);
}
/*
 */
void
VDKBEventBox::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBEventContainer::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\tmode:%s;", mode == v_box ? "v_box" : "h_box");
  fprintf(fp,"\n\t%s%s;", PROP_EVENTAWARE,(char*) GetProp(EVENTAWARE));
  fprintf(fp,"\n\t%s%s;", PROP_DOCKABLE,(char*) GetProp(DOCKABLE));
  // not good oop design here :-(
  // store notebook page tab label
  if(dynamic_cast<VDKBGuiNotebook*>(Parent()))
     fprintf(fp,"\n\t%s\"%s\";",PROP_LABEL, (char*) GetProp(LABEL));
}

char*
VDKBEventBox::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_mode[16];
  char obj_parent[128];
  char temp[256];
  char bw[16];
  char arg[16];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_mode,buffer,"mode:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];

  if(parser.GetParam(arg,buffer,PROP_EVENTAWARE) && !strcmp(arg,CHECK_TRUE))
    sprintf(temp,"\n%s = new VDKEventBox(this,%s);",obj_name,obj_mode);
  else if(parser.GetParam(arg,buffer,PROP_DOCKABLE) && !strcmp(arg,CHECK_TRUE))
    sprintf(temp,"\n%s = new VDKDockerBox(this,%s);",obj_name,obj_mode);
  else
    sprintf(temp,"\n%s = new VDKBox(this,%s);",obj_name,obj_mode);

  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  bool adjArg = true;
  // has parent
  if(strcmp(obj_parent,NIHIL_PROP))
    {
      // bad OOP design here :-(
      // but in seek of semplicity..
      // boxes embedded into notebooks act differently
      char* object = parser.GetWidget(obj_parent);
      char obj_class[32];
      if(object)
	{
	  // parent is a notebook
	  if(parser.GetParam(obj_class,object,PARSER_CLASS)
	     && !strcmp(obj_class,"VDKNotebook"))
	    {
	      bool nls_support = parser.CheckNLSSupport();
	      char label[128];
	      if(!parser.GetParam(label,buffer, PROP_LABEL))
		 *label = '\0';
	      if(nls_support)
		sprintf(temp,"\n%s->AddPage(%s,_(\"%s\"));",
			obj_parent,
			obj_name,
			*label ? label : obj_name);
	      else
		sprintf(temp,"\n%s->AddPage(%s,\"%s\");",
			obj_parent,
			obj_name,
			*label ? label : obj_name);
	      adjArg = false;
	    }
	  // other
	  else if(parser.GetParam(obj_class,object,PARSER_CLASS) &&
	      !strcmp(obj_class,"VDKTable"))
	    {
	      int row,col;
	      if(parser.GetParam(arg,buffer,PROP_TABLEROW) &&
		 strcmp(arg,NIHIL_PROP))
		row = atoi(arg);
	      else
		row = 0;
	      if(parser.GetParam(arg,buffer,PROP_TABLECOL) &&
		 strcmp(arg,NIHIL_PROP))
		col = atoi(arg);
	      else
		col = 0;
	      sprintf(temp,"\n%s->AddToCell(%s,%d,%d);",
		      obj_parent,obj_name,row,col);
	      adjArg = false;
	    }
	  else
	    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
	  delete[] object;
	}
      // other parents
      else
	sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
    }
  else
    sprintf(temp,"\nAdd(%s",obj_name);

  strcat(source,temp);

  if(adjArg)
    {
      // prepares arguments for add widget to container
      char justify[16],expand[16],fill[16],padding[16];
      if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
	 parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
	 parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
	 parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
	{
	  sprintf(temp,",%s,%s,%s,%s);",
		  justify,expand,fill,padding);
	  strcat(source,temp);
	}
      else
	{
	  sprintf(temp,");");
	  strcat(source,temp);
	}
    }

  if(parser.GetParam(bw,buffer,PROP_BORDERWIDTH) &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }

  return source;
}
/*
 */
bool
VDKBEventBox::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_mode[16];
  char obj_parent[128];
  VDKBEventBox* box;
  int mode;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_mode,buffer,"mode:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  mode = !strcmp(obj_mode,"h_box") ? h_box : v_box;
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = 0;
  int fill = 0,padding = 0;
  int expand = 0;
  int bw; // border width
  char arg[32];
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_BORDERWIDTH) &&
     strcmp(arg,NIHIL_PROP))
      bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new VDKBEventBox(obj_name,owner->InnerBox(),mode);
      // call ancestor to set common properties
      VDKBObject::CreateWidget(box,buffer,parser);
      owner->AddWidget(box,justification,expand,fill,padding);
      if(size.X() > 0 || size.Y() > 0)
	box->ObjectFromVDK()->SetSize(size.X(),size.Y());
      if(bw >= 0)
	{
	  box->BorderWidth(bw);
	  box->SetPropValue(BORDERWIDTH,arg);
	}
      if(parser.GetParam(arg,buffer,PROP_EVENTAWARE)
	 && !strcmp(arg,CHECK_TRUE))
	box->SetPropValue(EVENTAWARE,arg);
    }
  else
    // has a parent, will be added to parent.
    // Parent should be a container
    {
      // get parent container address
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new VDKBEventBox(obj_name,container,mode);
	  // bad OOP design here :-(
	  // but in seek of semplicity..
	  // we use justification for row
	  // and expand for col to add boxes
	  char* object = parser.GetWidget(obj_parent);
	  char obj_class[32];
	  if(object)
	    {
	      // parent is a table
	      if(parser.GetParam(obj_class,object,PARSER_CLASS)
		 && !strcmp(obj_class,"VDKTable"))
		{
		  if(parser.GetParam(arg,buffer,PROP_TABLEROW) &&
		     strcmp(arg,NIHIL_PROP))
		    justification = atoi(arg);
		  else
		    justification = 0;
		  if(parser.GetParam(arg,buffer,PROP_TABLECOL) &&
		     strcmp(arg,NIHIL_PROP))
		    expand = atoi(arg);
		  else
		    expand = 0;
		}
	    }
	  // call ancestor to set common properties
	  VDKBObject::CreateWidget(box,buffer,parser);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  if(size.X() > 0 || size.Y() > 0)
	    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
	  box->outerbox = container;
	  if(bw >= 0)
	    {
	      box->BorderWidth(bw);
	      box->SetPropValue(BORDERWIDTH,arg);
	    }

	  if(parser.GetParam(arg,buffer,PROP_EVENTAWARE)
	     && !strcmp(arg,CHECK_TRUE))
	    box->SetPropValue(EVENTAWARE,arg);

	  if(parser.GetParam(arg,buffer,PROP_DOCKABLE)
	     && !strcmp(arg,CHECK_TRUE))
	    box->SetPropValue(DOCKABLE,arg);
	}
      else
	return false; // FIX ME: user warning
    }
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////

/*
 */
bool
VDKBEventBox::OnSetEventBox(VDKObject*)
{
  VDKString True = CHECK_TRUE;
  if(evboxCb->Checked && (GetProp(DOCKABLE) == True))
    {
      Owner()->Application()->MessageBox(
					 APPNAME,
_("Dockable and EventBox properties are\n\
mutually exclusive,\nEventBox won't be changed"),
					 MB_ICONINFORMATION|MB_OK,
					 _(user_messages[user_ok]),
					 NULL,
					 5000);
      evboxCb->Checked = false;
    }
  else
    {
      SetPropValue(EVENTAWARE, evboxCb->Checked ? CHECK_TRUE : CHECK_FALSE);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
VDKBEventBox::OnSetDockable(VDKObject*)
{
  VDKString True = CHECK_TRUE;
  if(dockCb->Checked &&(GetProp(EVENTAWARE) == True))
    {
      Owner()->Application()->MessageBox(
					 APPNAME,
_("Dockable and EventBox properties are\n\
mutually exclusive\nDockable won't be changed"),
					 MB_ICONINFORMATION|MB_OK,
					 _(user_messages[user_ok]),
					 NULL,
					 5000);
      dockCb->Checked = false;
    }
  else
    {
      SetPropValue(DOCKABLE, dockCb->Checked ? CHECK_TRUE : CHECK_FALSE);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own properties controls.
 */
VDKObjectContainer*
VDKBEventBox::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKString True = CHECK_TRUE;
  VDKBox* bframe = dynamic_cast<VDKBox*>(VDKBEventContainer::ExtraWidget(isp));
  if(!bframe)
    return NULL;
  VDKTable *table = new VDKTable(inspector,1,2);
  evboxCb = new VDKCheckButton(inspector,"Event box");
  evboxCb->SetTip(_("Make it a VDKEventBox"));
  table->AddToCell(evboxCb,0,0);
  evboxCb->Checked = GetProp(EVENTAWARE) == True;
  evboxCb->Parent(this);
  SignalConnect(evboxCb,"toggled",&VDKBEventBox::OnSetEventBox);

  dockCb = new VDKCheckButton(inspector,"Dockable");
  dockCb->SetTip(_("Make it a VDKDockerBox"));
  table->AddToCell(dockCb,0,1);
  dockCb->Checked = GetProp(DOCKABLE) == True;
  dockCb->Parent(this);
  SignalConnect(dockCb,"toggled",&VDKBEventBox::OnSetDockable);

  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
VDKBEventBox::MakeWidgetV(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable box counter
  // to ensure unicity
  int result = 0;
  VDKBEventBox* box = NULL;
  if(owner->Active)
    {
      for(sprintf(buff,"vbox%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"vbox%d",VDKBEventBox::Counter);
      box = new VDKBEventBox(buff,owner,v_box);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      box->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      box->SetPropValue(EXPAND_INTERNAL,buff);
	      sprintf(buff,"%d,%d",80,80);
	      box->SetPropValue(USIZE,buff);
	      box->SetSize(80,25);
	      // others than justify and flag unuseful
	      container->AddWidget(box,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(box);
	  box->outerbox = container;
	}
      // target isn't a container
      else if(! owner->Active->AddToParent(box,ev))
	result =  2;
    }
  else
    // no active widget
    result =  3;
 // 0 on success
  if(result && box)
    box->Destroy();
 return result;
}

/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
VDKBEventBox::MakeWidgetH(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable box counter
  // to ensure unicity
  int result = 0;
  VDKBEventBox* box = NULL;
  if(owner->Active)
    {
      for(sprintf(buff,"hbox%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"hbox%d",VDKBEventBox::Counter);
      box = new VDKBEventBox(buff,owner,h_box);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      box->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      box->SetPropValue(EXPAND_INTERNAL,buff);
	      sprintf(buff,"%d,%d",80,80);
	      box->SetPropValue(USIZE,buff);
	      box->SetSize(80,25);
	      // others than justify and flag unuseful
	      container->AddWidget(box,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(box);
	  box->outerbox = container;
	}
      // target isn't a container
      else if(! owner->Active->AddToParent(box,ev))
	result = 2;
    }
  else
    // no active widget
    result =  3;
 // 0 on success
  if(result && box)
    box->Destroy();
 return result;
}







