/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_object.h>
#include <vdk/vdkutils.h>
#include <vdk/widcontain.h>
#include <vdkb2/vdkb_types.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_evcontain.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_fixed.h>
#include <vdkb2/vdkb_scrolled.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>
#include <vdkb2/vdkb_notebook.h>
#include <vdkb2/vdkb_frame.h>
static char buff[256];
#define VERBOSE 0


// plm 07/09/2000
VDKPoint drag_offset;
VDKPoint SelectedWidgetOrig;
VDKPoint WindowOrig;
VDKBEventContainer* container = NULL;
VDKBFixed* fixed_wid = NULL;
VDKBObject* SelectedWidget = NULL;

/* The cursors used when selecting/adding/moving/resizing widgets */
/*
static GdkCursor *cursor_selector = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
static GdkCursor *cursor_add_widget = gdk_cursor_new (GDK_PLUS);
static GdkCursor *cursor_add_to_fixed = gdk_cursor_new (GDK_TCROSS);
static GdkCursor *cursor_move = gdk_cursor_new (GDK_FLEUR);
static GdkCursor *cursor_top_left = gdk_cursor_new (GDK_TOP_LEFT_CORNER);
static GdkCursor *cursor_top_right = gdk_cursor_new (GDK_TOP_RIGHT_CORNER);
static GdkCursor *cursor_bottom_left = gdk_cursor_new (GDK_BOTTOM_LEFT_CORNER);
static GdkCursor *cursor_bottom_right = gdk_cursor_new (GDK_BOTTOM_RIGHT_CORNER);
*/
/*
 */
char* vdkbclass_names[] =
{
  "form",
  "gnomeform",
  0
};
/*
 */
// VDKBCLASSES_OFFSET is 1024
int
ClassTypeLookup(char* word)
{
int t=0;
for(;vdkbclass_names[t];t++)
  if(!strcmp(word,vdkbclass_names[t]))
     return VDKB_GUI_CLASSES_OFFSET+t;
return -1;
}
/*
 */
char* vdkobj_props[] =
{
NORMALBACKGROUND,PRELIGHTBACKGROUND,
INSENSITIVEBACKGROUND,ACTIVEBACKGROUND,
SELECTEDBACKGROUND,FOREGROUND,
FONT,ENABLED,
CURSOR,USIZE,VISIBLE,
JUSTIFY_INTERNAL, EXPAND_INTERNAL,
FILL_INTERNAL,PADDING_INTERNAL,
TIP,TAG,LABEL,TABLEROW,TABLECOL,
DECLARE_PUBLIC,
0
};

char* vdkobj_signals[] = { SIGNAL_REALIZE,0 };
char* vdkobj_nicknames[] = { NICK_REALIZE,0 };

//////////////////////////////////////////////
VDKBObject::VDKBObject(char* name):name(name)
{
  int t;
  for(t=0;vdkobj_props[t];t++)
    proplist.add(VDKBProperty(vdkobj_props[t]));
  for(t=0; vdkobj_signals[t]; t++)
    siglist.add(VDKBSignal(vdkobj_signals[t],
			   this,
			   vdkobj_nicknames[t]));
  // set adding  props to default value
  SetPropValue(VISIBLE,CHECK_TRUE);
  SetPropValue(ENABLED,CHECK_TRUE);
  SetPropValue(JUSTIFY_INTERNAL,"0"); // l_justify or side in packer or x in fixed
  SetPropValue(EXPAND_INTERNAL,"1"); // or anchor in packer or y in fixed
  SetPropValue(FILL_INTERNAL,"1"); // or options in packer
  SetPropValue(PADDING_INTERNAL,"0"); // or border width in packer
  object = NULL;
	// plm
	Marked = false;
}

/*
 */
VDKBObject::~VDKBObject()
{
}


/*
 */

VDKString VDKBObject::nihil_property = NIHIL_PROP;

void
VDKBObject::SetPropValue(const char* prop, const char* value)
{
  VDKBProperty  p(prop);
  VDKBProperty* pp;
  if( (pp = proplist.find(p)))
    pp->Value(value);
}

/*
 */
VDKString&
VDKBObject::GetProp(char* prop)
{
  VDKBProperty  p(prop);
  VDKBProperty* pp;
  //VDKString value = NIHIL_PROP;
  if( (pp = proplist.find(p)))
    //value = pp->Value();
    //return value;
    return pp->Property();
  else
    return VDKBObject::nihil_property;
}


/*
widget selection stuff,
shameless stolen to
Damon Chaplin, glade author
*/
// into vdkb_widsel.c
extern "C"
{
  extern void
  paint_selection (GdkWindow * window, GdkGC * gc, gint x, gint y,
		   gint width, gint height);
  extern void
  clear_widget_selection (GtkWidget * widget);

  extern GdkWindow*
  get_widget_window (GtkWidget *parent, GtkWidget *widget);
}

/*
 */
void
  VDKBObject::ClearMark()
{
#if VERBOSE
  printf("\nVDKBObject::ClearMark()");
  fflush(stdout);
#endif
  clear_widget_selection (object->Widget());
	// plm
	Marked = false;
}

/*
 */
void
VDKBObject::Mark()
{
if(object && GTK_WIDGET_DRAWABLE(object->Widget()))
  {
    GdkWindow *window;
    GdkGC *gc;
    gint x, y, w, h;
    GtkWidget* widget,  *ancestor;
    widget = ancestor = object->Widget();
    gc =  widget->style->black_gc;
    gdk_gc_set_subwindow (gc, GDK_INCLUDE_INFERIORS);
    window = get_widget_window (ancestor->parent, ancestor);
    if (window && ancestor->parent)
      {
	x = ancestor->allocation.x;
	y = ancestor->allocation.y;
	w = ancestor->allocation.width;
	h = ancestor->allocation.height;
      }
    else
      {
	x = 0;
	y = 0;
	gdk_window_get_size (window, &w, &h);
      }
    paint_selection (window, gc, x, y, w, h);
    /* Reset gc - maybe we should remember the current setting */
    gdk_gc_set_subwindow (gc, GDK_CLIP_BY_CHILDREN);
	// plm
	Marked = true;
  }
}

/*
===========================================================
 */
/*

 */
void
VDKBObject::WriteBgProp(char* propname, GtkStateType state, FILE* fp)
{
  VDKString nihilProp = NIHIL_PROP;
  VDKString prop = GetProp(propname);
  /*
  char color[32];	
  if( prop == nihilProp)	
  {	
  VDKRgb rgb = object->GetBackground(state);
  if(rgb.red > 0)
  {
  sprintf(color,"%d,%d,%d",rgb.red,rgb.green,rgb.blue);
  fprintf(fp,"\n\t%s:%s;",propname,color);
  }
  else
  fprintf(fp,"\n\t%s:%s;",propname,(char*) nihilProp);
  }
  else
  */
  fprintf(fp,"\n\t%s:%s;",propname,(char*) prop);

}
/*
 */
void
VDKBObject::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  char* oname = (char*) Name();


  fprintf(fp,"\n[object]\n{\n\tthis:%s;\n\tclass:%s;",
	  oname,(char*) VDKName());
  fprintf(fp,"\n\tparent:%s;",
	  parentobj ? (char*) parentobj->Name(): NIHIL_PROP);
  if(!object)
    return;
  // jump these props for containers
  else if(!dynamic_cast<VDKBEventContainer*>(this))
    {
      VDKString prop;
      VDKString nihilProp = NIHIL_PROP;
      VDKRgb rgb;
      WriteBgProp(NORMALBACKGROUND,GTK_STATE_NORMAL,fp);
      WriteBgProp(PRELIGHTBACKGROUND,GTK_STATE_PRELIGHT,fp);
      WriteBgProp(INSENSITIVEBACKGROUND,GTK_STATE_INSENSITIVE,fp);
      WriteBgProp(ACTIVEBACKGROUND,GTK_STATE_ACTIVE,fp);
      WriteBgProp(SELECTEDBACKGROUND,GTK_STATE_ACTIVE,fp);
      fprintf(fp,"\n\t%s%s;",
	      PROP_FOREGROUND,
	      (char*) GetProp(FOREGROUND));
      fprintf(fp,"\n\t%s\"%s\";",
	       PROP_FONT,
	      (char*) GetProp( FONT));
      fprintf(fp,"\n\t%s%s;",
	      PROP_ENABLED,
	      (char*) GetProp(ENABLED));
      fprintf(fp,"\n\t%s%s;",
	      PROP_CURSOR,
	      (char*) GetProp(CURSOR));
      fprintf(fp,"\n\tTip:\"%s\";",
	      (char*) GetProp("Tip"));
    }
  fprintf(fp,"\n\t%s%s;",
	  PROP_VISIBLE,
	  (char*) GetProp(VISIBLE));

  WriteCommonOnFrm(fp, parentobj);
 }
/*
 */
void
VDKBObject::WriteCommonOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKString Nihil = NIHIL_PROP;
  // these are common to all widgets
  fprintf(fp,"\n\t%s%s;",
	  PROP_JUSTIFY_INTERNAL,
	  (char*) GetProp(JUSTIFY_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_EXPAND_INTERNAL,
	  (char*) GetProp( EXPAND_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_FILL_INTERNAL,
	  (char*) GetProp(FILL_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_PADDING_INTERNAL,
	  (char*) GetProp(PADDING_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_TAG,
	  (char*) GetProp(TAG));
  fprintf(fp,"\n\t%s%s;",
	  PROP_DECLARE_PUBLIC,
	  (char*) GetProp(DECLARE_PUBLIC));
  //
#if VERBOSE
  printf("\nwriting common properties of:%s", (char*) Name());
  fflush(stdout);
#endif
   if(GetProp(TABLEROW) != Nihil)
        fprintf(fp,"\n\t%s%s;",PROP_TABLEROW,
		(char*) GetProp(TABLEROW));
   if(GetProp(TABLECOL) != Nihil)
        fprintf(fp,"\n\t%s%s;",PROP_TABLECOL,
		(char*) GetProp(TABLECOL));
  // does not write size for scrolled window
  // and scrolled window childs.
  // with fixed exception
  bool isScrolled = dynamic_cast<VDKBScrolled*>(this);
  bool isParentFixed = parentobj && dynamic_cast<VDKBFixed*>(parentobj);

  if( isScrolled && !isParentFixed)
    {
#if VERBOSE
      printf("\n%s: - size not stored", (char*) Name());
      fflush(stdout);
#endif
      fprintf(fp,"\n\t%s%s;", PROP_USIZE,NIHIL_PROP);
      return;
    }
  // see note below
  if(parentobj)
    {
      VDKObject* p =  parentobj->ObjectFromVDK();
      if(p && dynamic_cast<VDKBScrolled*>(p))
	{
#if VERBOSE
	  printf("\nparent of:%s is a scrolled - size not stored",
		 (char*) Name());
	  fflush(stdout);
#endif
	  fprintf(fp,"\n\t%s%s;", PROP_USIZE,NIHIL_PROP);
	  return;
	}
    }
  fprintf(fp,"\n\t%s%s;",  PROP_USIZE, (char*) GetProp( USIZE));
#if VERBOSE
  printf("\n%s:size stored - %s", (char*) Name(), 
	 (char*) GetProp( USIZE));
  fflush(stdout);
#endif
  
  /*
    // changed: mm version in 1.2.1
    // Search for a parent scrolled at all upper levels
    // substituted with nearest level only
    if(parentobj)
    {
    VDKObject* p;
    for (p = parentobj->ObjectFromVDK(); p ; p = p->Parent())
    {
    bool isFixed = dynamic_cast<VDKBFixed*>(p);
    if(isFixed)
    break;
    else if(dynamic_cast<VDKBScrolled*>(p))
    {
    #if VERBOSE
    printf("\nparent of:%s is a scrolled - size not stored", (char*) Name());
    fflush(stdout);
    #endif
    fprintf(fp,"\n\t%s%s;",
    PROP_USIZE,NIHIL_PROP);
    return;
    }
    }
    }
  */
}
/*
 */
void
VDKBObject::CreateWidget(VDKBObject* gui_object,
			 char* buffer,VDKBParser& parser)
{
  char arg[128];
  VDKRgb color;
  if(! gui_object->ObjectFromVDK())
    return;
  color = parser.Color(buffer,PROP_NORMALBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_NORMALBACKGROUND))
	gui_object->SetPropValue(NORMALBACKGROUND,arg);
	gui_object->ObjectFromVDK()->NormalBackground = color;
    }
  color = parser.Color(buffer,PROP_PRELIGHTBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_PRELIGHTBACKGROUND))
	gui_object->SetPropValue(PRELIGHTBACKGROUND,arg);
      gui_object->ObjectFromVDK()->PrelightBackground = color;
    }
  color = parser.Color(buffer,PROP_INSENSITIVEBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_INSENSITIVEBACKGROUND))
	gui_object->SetPropValue(INSENSITIVEBACKGROUND,arg);
      gui_object->ObjectFromVDK()->InsensitiveBackground = color;
    }
  color = parser.Color(buffer,PROP_ACTIVEBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_ACTIVEBACKGROUND))
	gui_object->SetPropValue(ACTIVEBACKGROUND,arg);
      gui_object->ObjectFromVDK()->ActiveBackground = color;
    }

  color = parser.Color(buffer,PROP_SELECTEDBACKGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_SELECTEDBACKGROUND))
	gui_object->SetPropValue(SELECTEDBACKGROUND,arg);
      gui_object->ObjectFromVDK()->SelectedBackground = color;
    }
  color = parser.Color(buffer,PROP_FOREGROUND);
  if(color.red >= 0)
    {
      if( parser.GetParam(arg,buffer,PROP_FOREGROUND))
	gui_object->SetPropValue(FOREGROUND,arg);
      gui_object->ObjectFromVDK()->Foreground = color;
    }
// other props here
 if(parser.GetParam(arg,buffer,PROP_ENABLED) && strcmp(arg,NIHIL_PROP))
   gui_object->SetPropValue(ENABLED,arg);
 if(parser.GetParam(arg,buffer,PROP_VISIBLE) && strcmp(arg,NIHIL_PROP))
   gui_object->SetPropValue(VISIBLE,arg);
 if(parser.GetParam(arg,buffer,PROP_TAG) && strcmp(arg,NIHIL_PROP))
   gui_object->SetPropValue("Tag",arg);
 // avoid in case of form
 if( dynamic_cast<VDKBGuiForm*>(gui_object) == NULL)
   {
     if(
	parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL) &&
	strcmp(arg,NIHIL_PROP)
	)
       gui_object->SetPropValue(JUSTIFY_INTERNAL,arg);
     if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL)
	&& strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue( EXPAND_INTERNAL,arg);
     if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL)
	&& strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue("_Fill",arg);
     if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL)
	&& strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue("_Padding",arg);
     if(parser.GetParam(arg,buffer,PROP_TIP) && strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue("Tip",arg);
     if(parser.GetParam(arg,buffer,PROP_DECLARE_PUBLIC) && 
	strcmp(arg,NIHIL_PROP))
       gui_object->SetPropValue(DECLARE_PUBLIC,arg);
   }
 //
 if(parser.GetParam(arg,buffer,PROP_FONT) && strcmp(arg,NIHIL_PROP))
   {
     VDKFont* font = new VDKFont(gui_object->ObjectFromVDK()->Owner(),arg);
     if((char*) font)
       {
	 gui_object->SetPropValue( FONT,arg);
	 gui_object->ObjectFromVDK()->Font = font;
       }
     else
       font->Destroy();
   }
 //
 // get size
 // avoid in case of form
 if( dynamic_cast<VDKBGuiForm*>(gui_object) == NULL)
   {
     VDKPoint size = parser.Size(buffer);
     if(size.X() > 0 || size.Y() > 0)
       {
	 if(parser.GetParam(arg,buffer,PROP_USIZE))
	   gui_object->SetPropValue(USIZE,arg);
	 gui_object->ObjectFromVDK()->SetSize(size.X(),size.Y());
       }
   }
}
/*
 */
char*
VDKBObject::CreateSource(char* buffer,VDKBParser& parser,char* obj_name)
{
  char* source = new char [4096];
  char tmp[256];
  char arg[128];
  VDKRgb color;
  *source = '\0';
  // set widget name to be used by rc if any
  sprintf(tmp,"\ngtk_widget_set_name (GTK_WIDGET(%s->WrappedWidget()), \"%s\");",
	  obj_name,obj_name);
  strcpy(source,tmp);
  //
  color = parser.Color(buffer,PROP_NORMALBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->NormalBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,PROP_PRELIGHTBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->PrelightBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,PROP_INSENSITIVEBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->InsensitiveBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,PROP_INSENSITIVEBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->ActiveBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,PROP_SELECTEDBACKGROUND);
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->SelectedBackground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }

  color = parser.Color(buffer,"Foreground:");
  if(color.red >= 0)
    {
      sprintf(tmp,"\n%s->Foreground = VDKRgb(%d,%d,%d);",
	      obj_name,
	      color.red,color.green,color.blue);
      strcat(source,tmp);
    }
  // other props here
  // set enabled only if == false
  if(parser.GetParam(arg,buffer,PROP_ENABLED) && !strcmp(arg,CHECK_FALSE) )
    {
      sprintf(tmp,"\n%s->Enabled = %s;", obj_name,arg);
      strcat(source,tmp);
    }

  if(parser.GetParam(arg,buffer,PROP_CURSOR) && strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp,"\n%s->Cursor = %s;", obj_name,arg);
      strcat(source,tmp);
    }

  if(parser.GetParam(arg,buffer,PROP_TIP) && strcmp(arg,NIHIL_PROP))
    {
      bool nls_support = parser.CheckNLSSupport();
      if(nls_support)
	sprintf(tmp, "\n%s->SetTip(_(\"%s\"));", obj_name,arg);
      else
	sprintf(tmp, "\n%s->SetTip(\"%s\");", obj_name,arg);
      strcat(source,tmp);
    }
  if(parser.GetParam(arg,buffer,PROP_TAG) && strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp, "\n%s->Tag = %s;", obj_name,arg);
      strcat(source,tmp);
    }
  // font
    if(parser.GetParam(arg,buffer,"Font:") && strcmp(arg,NIHIL_PROP))
    {
      sprintf(tmp,
	      "\nVDKFont* %s_font = new VDKFont(this,\"%s\");", obj_name,arg);
      strcat(source,tmp);
      sprintf(tmp, "\n%s->Font = %s_font;", obj_name,obj_name);
      strcat(source,tmp);
    }
    VDKPoint size = parser.Size(buffer);
    if(size.X() > 0 || size.Y() > 0)
      {
	sprintf(tmp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
	strcat(source,tmp);
      }
    return source;
}

/*
 */
void
VDKBObject::WriteOnFrmEnd(FILE* fp)
{
 fprintf(fp,"\n}");
}

/*
 */
void
VDKBObject::PopObjectBrowser()
{
  if(object)
    object->Owner()->Application()->MessageBox(APPNAME,
					       _("Sorry, not yet implemented"),
					       MB_OK| MB_ICONINFORMATION);
}
/*
This should be override by subclasses in order
to add their own controls to inspector.
At this level results in a unuseful call
 */
VDKObjectContainer*
VDKBObject::ExtraWidget(VDKBObjectInspector* isp)
{
#ifdef VDKBDEBUG
printf("\n** WARNING **\nUnuseful call VDKBObject::ExtraWidget(%p)",
       isp);
fflush(stdout);
#endif
return (VDKObjectContainer*) NULL;
}

/*
 */
bool
VDKBObject::AddToParent(VDKObject* obj, GdkEvent* ev)
{
  VDKBObject* vdkbobj =
    dynamic_cast<VDKBObject*> (ObjectFromVDK()->Parent());
  char* p = (char*) vdkbobj->GetProp(VISIBLE);
  bool hidden = (p && !strcmp(p,CHECK_FALSE));
  if(vdkbobj)
    {
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(vdkbobj);
      if(container)
	{
	  // flag true will force args to AddWidget
	  bool flag = false;
	  VDKBProjectManager* prjman = NULL;
	  VDKBGuiForm* ownerform =
	    dynamic_cast<VDKBGuiForm*>(ObjectFromVDK()->Owner());
	  if(ownerform)
	     prjman = dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	  if(prjman && prjman->objInspector)
	    flag = prjman->objInspector->preview->Checked;
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      VDKBObject* self =
		dynamic_cast<VDKBObject*>(obj);
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      if(self)
		self->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      if(self)
		self->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(obj,int(event->x),
				   int(event->y),
				   flag,true,true);
	      if(hidden)
		obj->Visible = false;

	    }
	  else
	    {
	      container->AddWidget(obj,
				   l_justify,
				   flag,flag,true,flag);
	      if(hidden)
		obj->Visible = false;
	    }
	  VDKBObject* self =
	    dynamic_cast<VDKBObject*>(obj);
	  if(self)
	    {
	      VDKBEventContainer* self_container =
		dynamic_cast<VDKBEventContainer*>(self);
	      if(self_container)
		  self_container->Outerbox(container);
	    }
	  return true;
	}
      else
	return false;
    }
  else
    return false;
}
/*
=======================================
COMMON RESPONSE METHODS FOR ALL OBJECTS
=======================================
*/
void
VDKBObject::SetupSignals(VDKObject* obj)
{
  // obsolete
}

bool 
VDKBObject::BaseExposeEvent(VDKObject* sender, GdkEvent* ev)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(sender->Owner());
  VDKBObject* self = dynamic_cast<VDKBObject*>(sender);
  GdkEventExpose* event = (GdkEventExpose*) ev;
  if(ownerform && ownerform->Active == self && event->count == 0)
      self->Mark();
  return true;
}
/*
FIXED MOVING STUFF
 */
// Constants for drag actions
#define DRAG_ACTION_NONE		0
#define DRAG_ACTION_MOVE		1
#define DRAG_ACTION_RESIZE		2
#define DRAG_ACTION_RESIZE_H	3
#define DRAG_ACTION_RESIZE_V	4
 
int dragAction = 0;
bool onDraggingAnObjectIntoAFixed = false;

static VDKPoint last_position;
static VDKPoint old_size;

extern "C"
{
GtkWidget* get_event_widget (GtkWidget *widget,
			     GdkWindow *window,
			     gint x, gint y,
			     gint * x_return,
			     gint * y_return);
void
fixed_draw_grid (GtkWidget * widget,
		 int grid_horz_spacing,
		 int grid_vert_spacing,
		 int grid_style);
}
/*
  - handle mouse button click
 */

bool
VDKBObject::ButtonPressed(VDKObject* sender, GdkEvent* ev)
{
  GdkEventButton* event = (GdkEventButton*) ev;
  bool stop = true;
#if HAVE_GNOME
  stop = ! dynamic_cast<VDKGnomeDateEdit*>(sender);
#endif
  VDKBGuiNotebook* nbook = dynamic_cast<VDKBGuiNotebook*>(sender);
  stop = nbook == NULL;
  // if(stop)
  //   gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),"button_press_event");
  /*
    checks widget parent container
    to wich propagate message.
  */
  if(sender)
    container = dynamic_cast<VDKBEventContainer*>(sender->Parent());
  /*
    if check is done successfully, calls
    VDKBEventContainer::OnButtonPress() that:
    - Mark()  widget
    - set this as owner form active widget
    - if button pressed is 1 (left)
    propagates message to owner form if
    operational state shows that we are waiting for dropping
    a widget to gui.
    - else if button pressed is 3 (right)
    invokes virtual function Popmenu() that raises a
    popmenu.
  */
  if(container)
    {
      container->OnButtonPressed(sender,ev);
      HandleFixed(sender,event);
     }
  return stop; //true;
}


/*
  - handle mouse button click release
 */
// into vdkb_form.cc
extern SizeTipWin* sizetipwin;
bool
VDKBObject::ButtonReleased(VDKObject* sender, GdkEvent* ev)
{
	if(sizetipwin) {
		sizetipwin->Close();
		sizetipwin->Destroy();
		sizetipwin = NULL;
	}
	// Fixing an obscure bug here, stopping signal
	// on a  scrollable notebook will hang
	// agreed isn't an elegant way to fix bugs
	// but i can't do better for now :-(
	bool stop = true;
	VDKBGuiNotebook* nbook = dynamic_cast<VDKBGuiNotebook*>(sender);
	stop = nbook == NULL;
	/*
	if(nbook) 
	{
	GtkNotebook* gtknotebook = GTK_NOTEBOOK(sender->Widget());
	stop =  !(gtknotebook->scrollable);
	}
	*/
#if HAVE_GNOME
	stop = stop ? !dynamic_cast<VDKGnomeDateEdit*>(sender): stop;
#endif  
	// if(stop)
	// gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),"button_release_event");
	// plm
	if (Marked) Mark();
	// fixed widget stuff:
	// ungrab the mouse if were grabbed
	// during ButtonPressed
	GtkWidget* grabbed = gtk_grab_get_current();
	if(grabbed)
	  gtk_grab_remove(grabbed/*object->Widget()*/);
	// resets default cursor and global flags
	ObjectFromVDK()->SetCursor(curDefault);
	onDraggingAnObjectIntoAFixed = false;
	dragAction = DRAG_ACTION_NONE;
	SelectedWidget = NULL;
	//  mark object and draw grid on fixed
	if( container && fixed_wid) {
		bool have_grid = false;
		int horz_spacing = 1,vert_spacing = 1;
		VDKString isTrue = CHECK_TRUE;
		if(fixed_wid && fixed_wid->GetProp("have_grid") == isTrue) {
			have_grid = true;
			horz_spacing = atoi((char*) fixed_wid->GetProp("h_grid_spacing"));
			vert_spacing = atoi((char*) fixed_wid->GetProp("v_grid_spacing"));
		}
		if(have_grid)
			fixed_draw_grid (fixed_wid->Container(), horz_spacing,
				vert_spacing, 1); // dots

	}
	container = NULL;
	fixed_wid = NULL;
	return stop;// true;
}
/*
  - handle enter event
 */
bool
VDKBObject::OnEnter(VDKObject* sender, GdkEvent* ev)
{
  /*
    since gtk widgets  shouldn't react to events,
    signal is stopped here.
  */

#if VERBOSE
  printf("\nVDKBObject::OnEnter");
  fflush(stdout);
#endif
    gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
  			       "enter_notify_event");
 return true;
}
/*
  - handle leave event
 */
bool
VDKBObject::OnLeave(VDKObject* sender, GdkEvent* ev)
{
  /*
    since gtk widgets  shouldn't react to events,
    signal is stopped here.
  */

#if VERBOSE
  printf("\nVDKBObject::OnLeave");
  fflush(stdout);
#endif
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
  			       "leave_notify_event");
  return true;
}
/*


================================================



================================================
 */
/*
valid only for fixed containers
 */

bool
VDKBObject::HandleFixed(VDKObject* sender, GdkEventButton *event)
{
  fixed_wid = dynamic_cast<VDKBFixed*>(container);
  if( container && (event->button == 1) && fixed_wid) 
    {
      int x = -1,y = -1;
      // Grab the concerned widget
      gtk_grab_add(object->Widget());
      // Get offset coordinates
      GtkWidget* Widget = get_event_widget (sender->Widget(),
					    event->window, int(event->x), int(event->y), &x, &y);
      if(Widget) 
	{
	  // Save offset coordinates
	  drag_offset = VDKPoint(x,y);
	  GtkWidget* widget = object->Widget();
	  // Save selected widget relative coordinates
	  SelectedWidgetOrig = VDKPoint(widget->allocation.x,
					widget->allocation.y);
	  // Save selected widget pointer
	  SelectedWidget = (VDKBObject*)this;
	  // Save the window origin absolute position
	  WindowOrig = VDKPoint(int(event->x_root) - SelectedWidgetOrig.x - drag_offset.x,
				int(event->y_root) - SelectedWidgetOrig.y - drag_offset.y);
#if VERBOSE
	  printf("\nVDKBObject::HandleFixed - %s - widget orig(%d,%d) - window orig(%d,%d)",
		 gtk_widget_get_name (widget),
		 widget->allocation.x,widget->allocation.y,
		 WindowOrig.x, WindowOrig.y);
	  fflush(stdout);
#endif
	  const int width = widget->allocation.width-8;
	  const int height = widget->allocation.height-8;
	  // Calculate handles rectangles positions
	  VDKRect rs_corner(width,height,8,8);
	  VDKRect ls_corner(0, height, 8, 8);
	  VDKRect rn_corner(width, 0, 8, 8);
	  VDKPoint mouse(x,y);
	  if(rs_corner.Contains(mouse)) 
	    {
	      dragAction = DRAG_ACTION_RESIZE; // resize
	      object->SetCursor((VDKCursorType) GDK_BOTTOM_RIGHT_CORNER);
	    }
	  else if (ls_corner.Contains(mouse)) 
	    {
	      dragAction = DRAG_ACTION_RESIZE_V; // resize_vert
	      object->SetCursor((VDKCursorType) GDK_SB_V_DOUBLE_ARROW);
	    }
	  else if (rn_corner.Contains(mouse)) 
	    {
	      dragAction = DRAG_ACTION_RESIZE_H; // resize_horiz
	      object->SetCursor((VDKCursorType) GDK_SB_H_DOUBLE_ARROW);
	    }
	  else 
	    {
	      dragAction = DRAG_ACTION_MOVE; // move
	      object->SetCursor((VDKCursorType) GDK_FLEUR);
	    }
	  // We are dragging into a fixed
	  onDraggingAnObjectIntoAFixed = true;
	}
      else 
	{
	  drag_offset = VDKPoint(0,0);
	  onDraggingAnObjectIntoAFixed = false;
	}
      return onDraggingAnObjectIntoAFixed;
    }
  return false;
}



/*
here we use native mouse routines for moving and
resizing drawbacks:
*/
bool
VDKBObject::OnMouseMove(VDKObject* sender, GdkEvent* ev)
{
  int event_x = 0, event_y = 0;
  GdkEventMotion *event = (GdkEventMotion*) ev;
#if VERBOSE
      printf("\n(0) VDKBObject::OnMouseMove - Received...");
      fflush(stdout);
#endif
  // Redirect event to selected widget if it exists
  // if the event is happening in a non grabbed widget
  // STUB
  if (SelectedWidget && (gtk_grab_get_current() != sender->Widget())) 
    {
#if VERBOSE
      printf("\n(0) VDKBObject::OnMouseMove - Mouse move event redirection...");
      fflush(stdout);
#endif
      SelectedWidget->OnMouseMove(SelectedWidget->ObjectFromVDK(), ev);
      return false;
    }
  
#if VERBOSE
  printf("\n(1) VDKBObject::OnMouseMove - %s - pos(%d,%d) - root(%d,%d) - win_orig(%d,%d) - wid_orig(%d,%d)",
	 gtk_widget_get_name (object->Widget()),
	 int(event->x), int(event->y),
	 int(event->x_root), int(event->y_root),
	 WindowOrig.x, WindowOrig.y,
	 SelectedWidgetOrig.x, SelectedWidgetOrig.y);
  fflush(stdout);
#endif
  
  // this code interest only those widgets contained into a fixed.
  // extern <bool onDraggingAnObjectIntoAFixed> flag is set to true by
  // VDKOBject::ButtonPressed handler or should be set by
  // an overridden one in subclasses
  if (onDraggingAnObjectIntoAFixed) 
    {
      // Compute new position
      switch(dragAction) {
      case DRAG_ACTION_MOVE: 
	// move
	// Calculation based on screen coordinates (absolute)
	// This way is used instead of relative coordinates because
	// some widgets are composed of few windows. So when the mouse
	// is near the frontier between two windows, event x or y change
	// of coordinate system, so the moving widget is jumping everywhere
	// in function of the coordinate system used.
	//
	event_x = int(event->x_root) - WindowOrig.x - drag_offset.x;
	event_y = int(event->y_root) - WindowOrig.y - drag_offset.y;
	break;
      case DRAG_ACTION_RESIZE: // resize
	event_x = int(event->x_root) - WindowOrig.x - SelectedWidgetOrig.x;
	event_y = int(event->y_root) - WindowOrig.y - SelectedWidgetOrig.y;
	break;
      case DRAG_ACTION_RESIZE_H: // resize_horiz
	event_x = int(event->x_root) - WindowOrig.x - SelectedWidgetOrig.x;
	event_y = object->Widget()->allocation.height;
	break;
      case DRAG_ACTION_RESIZE_V: // resize_vert
	event_x = object->Widget()->allocation.width;
	event_y = int(event->y_root) - WindowOrig.y - SelectedWidgetOrig.y;
	break;
      }
      // Ensure values won't be negatives
      if (event_x < 0) event_x = 0;
      if (event_y < 0) event_y = 0;
      // grid work
      int horz_spacing = 0,vert_spacing = 0;
      bool isShift = event->state & GDK_SHIFT_MASK;
      VDKString isTrue = CHECK_TRUE;
      bool have_grid = fixed_wid->GetProp("have_grid") == isTrue;
      if(have_grid && isShift) 
	{
	  horz_spacing = atoi((char*) fixed_wid->GetProp("h_grid_spacing"));
	  vert_spacing = atoi((char*) fixed_wid->GetProp("v_grid_spacing"));
	  // snaps to grid
	  event_x += horz_spacing / 2;
	  event_x -= event_x % horz_spacing;
	  event_y += vert_spacing / 2;
	  event_y -= event_y % vert_spacing;
	}
      
      VDKPoint new_position(event_x,event_y);
#if VERBOSE
      printf("\n(2) VDKBObject::OnMouseMove - %s - x:%d,y:%d",
	     gtk_widget_get_name (object->Widget()),
	     event_x, event_y);
      fflush(stdout);
#endif
      // here we move or resize
      switch(dragAction) 
	{
	case DRAG_ACTION_MOVE: // move
	  gtk_fixed_move(GTK_FIXED(fixed_wid->Container()),
			 object->Widget(),
			 new_position.x,
			 new_position.y);
	  // corrects GTK+ bug. Some widgets do not move unless
	  // you call gtk_widget_set_uposition()
	  gtk_widget_set_uposition (object->Widget(),
				    new_position.x, new_position.y);
	  // update widget properties
	  sprintf(buff,"%d",new_position.x);
	  SetPropValue(JUSTIFY_INTERNAL,buff);
	  sprintf(buff,"%d",new_position.y);
	  SetPropValue( EXPAND_INTERNAL,buff);
	  break;
	case DRAG_ACTION_RESIZE: // resize
	case DRAG_ACTION_RESIZE_H: // resize_horiz
	case DRAG_ACTION_RESIZE_V: // resize_vert
	  // Set new widget size
	  object->Usize = new_position;
	  // Set property value
	  sprintf(buff,"%d,%d",new_position.x,new_position.y);
	  SetPropValue(USIZE,buff);
	  // show size tip win
	  if(!sizetipwin) 
	    {
	      sprintf(buff,_("Min.size:%d,%d"),new_position.x,new_position.y);
	      int x, y;
	      GtkWidget* wid = GTK_WIDGET(object->Widget());
	      gdk_window_get_deskrelative_origin(wid->window, &x,&y);
	      sizetipwin = new SizeTipWin(object->Owner(),buff);
	      sizetipwin->Setup();
	      sizetipwin->Position = VDKPoint(x,y);
	      sizetipwin->Show();
	    }
	  else sizetipwin->Update(new_position);
	  break;
	}
    }
  return true;
}







