/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_toolbar_h
#define _vdkb_toolbar_h

#include <vdkb2/vdkb_evcontain.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdk/menu.h>
#include <vdk/toolbar.h>

struct ToolButtonData
{
  GtkWidget* button;
  VDKString pix,tip,text;
};

typedef VDKValueList<ToolButtonData> TBDList;
typedef VDKValueListIterator<ToolButtonData> TBDListIterator;

class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBToolbar: public VDKBEventContainer
{
 protected:
  VDKToolbar* toolbar;
  VDKMenuItem *delBox;
  VDKMenuItem *addbutton,*removebutton,*delwidget,*setsize;
  // property controls used by object inspector
  VDKSpinButton *spacing;
  VDKEntry *label;
  VDKCombo* shadow,*align;
  VDKCustomButton* set;
  VDKBEventBox* innerbox;
  VDKCombo *orientation,*style,*relief;
  VDKCheckButton* bydata;
  void Init();
  static void OnButtonSignal(GtkWidget *wid, gpointer gp);
  bool LoadButtons(char* buffer,VDKBParser& parser);
 public:
  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static void CreateButtons(char* buffer,
			   VDKBParser& parser, 
			   char* source,
			   char* obj_name);
  TBDList buttonlist;
  int ButtonSelected;
  VDKObjectContainer*  ExtraWidget(VDKBObjectInspector* isp);
  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKBToolbar(char* name, VDKForm* owner);
  VDKBToolbar(char* name, VDKBEventContainer* outer);
  virtual ~VDKBToolbar() {}
  void AddBox();
  void PopMenu() { popmenu->Popup(); }

  void Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);

  bool AddNewWidget(VDKObject* sender);

  bool DelBox(VDKObject* sender);

  bool AddButton(VDKObject* sender);
  
  bool RemoveButton(VDKObject* sender);

  bool OnSetStyle(VDKObject*);
  
  bool OnSetOrientation(VDKObject*);

  bool OnSetRelief(VDKObject*);

  bool OnSetSpacing(VDKObject*);

  virtual int Type() { return vdkbtoolbar_class; }

  virtual int isA() { return vdkbtoolbar_class; }

  void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);

  virtual char* VDKName() { return "VDKToolbar"; }
  bool SetBoxSize(VDKObject* sender);
  bool OnToggleBydata(VDKObject*);
  // designer
  DECLARE_EVENT_LIST(VDKBToolbar);
  DECLARE_SIGNAL_LIST(VDKBToolbar);
};

#endif

