#include <stdlib.h>
#include "bounce.h"
#include "spdif.h"
#include "shm_memory_tool.h"

static inline ssize_t safein  (int fd, uint_8 *ptr, size_t s)
{
    ssize_t r = 0;
    do {
	r = read (fd, ptr, s);
    } while (r < 0 && (errno == EINTR || errno == EAGAIN));

    return r;
}

static inline ssize_t safeout (int fd, const uint_8 *ptr, size_t s)
{
    ssize_t p = 0;
    while (s > 0) {
	p = write (fd, ptr, s);
	if (p < 0) {
	    if (errno == EPIPE)
		exit (0);
	    if (errno == EINTR || errno == EAGAIN)
		continue;
	    goto out;
	}
	ptr += p;
	s -= p;
    }
out:
    return p;
}

#define MAP_MEM		(MAP_SHARED|MAP_NORESERVE|MAP_LOCKED)

#define BOUNCE_SIZE	(16*64*1024)
#define TRANSFER_SZ	(64*1024)
#define READ_SIZE	(4*1024)

static uint_8 *buf, *tmp, *in;
static cBounce * bounce;
static volatile bool active = false;

static pthread_t lthread;

static void *action(void *dummy)
{
    ssize_t len;
    cPsleep msleep;

    realtime("action")
    active = true;
    bounce->takeio();
    while (active) {

	if (!bounce->poll(30))
	    continue;

	if (!active)
	    break;

	if ((len = bounce->fetch(tmp, TRANSFER_SZ))) {
	    safeout(1, tmp, len);
	}
    }
    while ((len = bounce->fetch(tmp, TRANSFER_SZ))) {
	safeout(1, tmp, len);
    }
    bounce->leaveio();
    return NULL;
}

int main()
{
    cPsleep Sleep;
    ssize_t len, submit = 0;
    bool wakeup = false;

    buf = (uint_8*)shm_malloc(sizeof(uint_8)*BOUNCE_SIZE, MAP_MEM);
    tmp = (uint_8*)shm_malloc(sizeof(uint_8)*TRANSFER_SZ, MAP_MEM);
    in  = (uint_8*)shm_malloc(sizeof(uint_8)*READ_SIZE,   MAP_MEM);
    bounce = new cBounce(buf, BOUNCE_SIZE);

    if (!buf || !tmp || !in || !bounce)
	goto out;

    bounce->bank(0);
    bounce->flush();

    pthread_create(&lthread, NULL, &action, NULL);
    pthread_detach(lthread);
    pthread_setschedparam(lthread, SCHED_RR, 0);

    while ((len = safein(0, in, READ_SIZE)) > 0) {
	if (!bounce->store(in, len, wakeup))
	    Sleep.msec(10);
	submit += len;
	wakeup  = false;
	if (submit >= TRANSFER_SZ) {
	    wakeup = true;
	    submit %= TRANSFER_SZ;
	}
    }

    active = false;
    bounce->signal();
    Sleep.msec(30);
    pthread_cancel(lthread);

out:
    if (buf) shm_free(buf);
    if (tmp) shm_free(tmp);
    if (in)  shm_free(in);
    if (bounce) delete bounce;

    return 0;
}
