/*
 * console.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: console.c,v 1.1 2004/10/24 12:57:09 chelli-guest Exp $
 */


#include <getopt.h>

#include <vdr/plugin.h>


#include "engine.h"
#include "config.h"
#include "menu.h"
#include "i18n.h"


static const char *VERSION        = "0.5.1";
static const char *DESCRIPTION    = "Expands VDR to a Console on TV";
static const char *MAINMENUENTRY  = "Consoles";

cConsoles* gl_pConsoles = NULL;


class cPluginConsole : public cPlugin {
private:
public:
  cPluginConsole(void);
  virtual ~cPluginConsole();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return tr(DESCRIPTION); }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Start(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void) { return tr(MAINMENUENTRY); }
  virtual cOsdMenu *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
};



cPluginConsole::cPluginConsole(void)
{}



cPluginConsole::~cPluginConsole() {
  delete gl_pConsoles;
  gl_pConsoles = NULL;
}


const char *cPluginConsole::CommandLineHelp(void) {

  return NULL;  
}


bool cPluginConsole::ProcessArgs(int argc, char *argv[]) {

  return true;
}


bool cPluginConsole::Start(void) {

  RegisterI18n(Phrases);

  gl_ConsoleCommands.Load( AddDirectory( ConfigDirectory(), "commands.conf" ) );

  gl_pConsoles = new cConsoles();
  if ( gl_pConsoles ) {

    gl_pConsoles->Start();
    return true;
  }
  return false;
}


void cPluginConsole::Housekeeping(void) {
  // Perform any cleanup or other regular tasks.
}



cOsdMenu *cPluginConsole::MainMenuAction(void) {

  if ( ! cKbdRemote::KbdAvailable() ) {
    esyslog("console: no keyboard avaiable!");
    return NULL;
  }
  return new cMenuConsoleList();
}


cMenuSetupPage *cPluginConsole::SetupMenu(void) {

  return new cMenuConsoleSetup();
}


bool cPluginConsole::SetupParse(const char *Name, const char *Value) {

  if      (!strcasecmp(Name, "TextColor"))             config.TextColor = atoi(Value);
  else if (!strcasecmp(Name, "BoldTextColor"))         config.BoldTextColor = atoi(Value);
  else if (!strcasecmp(Name, "TextBackColor"))         config.TextBackColor = atoi(Value);
  else if (!strcasecmp(Name, "CompressText"))          config.CompressText = atoi(Value);
  else if (!strcasecmp(Name, "AutoEnterKeyboardMode")) config.AutoEnterKeyboardMode = atoi(Value);
  else if (!strcasecmp(Name, "BellTimeout"))           config.BellTimeout = atoi(Value);
  else
     return false;

  return true;
}


VDRPLUGINCREATOR(cPluginConsole); // Don't touch this!
