/*
	This file has some own functionality and is used as backward
	compatibility for vdr prior to version 1.5.7 language support.
 */

#include "i18n.h"

namespace vdrlive {

I18n& LiveI18n()
{
    static I18n instance;
    return instance;
}

I18n::I18n()
  : m_encoding(
#if VDRVERSNUM >= 10503
        cCharSetConv::SystemCharacterTable() ? cCharSetConv::SystemCharacterTable() : "UTF-8"
#else
        I18nCharSets()[::Setup.OSDLanguage]
#endif
        )
{
    // fix encoding spelling for html standard.
    std::string const iso("iso");
    if (m_encoding.find(iso) != std::string::npos) {
        if (iso.length() == m_encoding.find_first_of("0123456789")) {
            m_encoding.insert(iso.length(), "-");
        }
    }
}

#if VDRVERSNUM < 10507
#include "i18n-generated.h"
#endif

#ifdef NEVER
const tI18nPhrase Phrases[] = {
    { "Live Interactive VDR Environment",
      "Live Interactive VDR Environment",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Environnement interactif Live VDR", // Franais Patrice Staudt 16.06.2007
      "", // Norsk
      "Live-integroitu VDR-ymprist",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "What's running at",
      "Was luft um",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Qu'y a t'il au programme vers", // Franais
      "", // Norsk
      "Menossa kello",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "%I:%M %p", // Time formatting string (Hour:Minute suffix)
      "%H:%M Uhr", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "%H:%M", // Franais
      "", // Norsk
      "%H:%M",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "%I:%M:%S %p", // Time formatting string (Hour:Minute:Seconds suffix)
      "%H:%M:%S Uhr", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "%H:%M:%S", // Franais
      "", // Norsk
      "%H:%M:%S",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "%a, %b %d", // English
      "%a, %d.%m.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "%a, %d.%m.", // Franais
      "", // Norsk
      "%a, %d.%m.",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "%A, %b %d %Y", // English
      "%A, %d.%m.%Y", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "%A, %d.%m.%Y", // Franais
      "", // Norsk
      "%A, %d.%m.%Y",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "%b %d %y", // English
      "%d.%m.%y", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "%d.%m.%y", // Franais
      "", // Norsk
      "%d.%m.%y",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "%A, %x", // English
      "%A, %x", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "%A, %x", // Franais
      "", // Norsk
      "%A, %x",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Date", // English
      "Datum", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Date", // Franais
      "", // Norsk
      "Pivmr",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Time", // English
      "Zeit", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Temps", // Franais
      "", // Norsk
      "Kellonaika",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Recordings", // English
      "Aufnahmen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Enregistrements", // Franais
      "", // Norsk
      "Tallenteet",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "List of recordings", // English
      "Liste der Aufnahmen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Liste des enregistrements", // Franais
      "", // Norsk
      "Tallennelistaus",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "No recordings found", // English
      "Keine Aufnahmen vorhanden", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Pas d'enregistrement", // Franais
      "", // Norsk
      "Tallenteita ei lydy",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "playing recording", // English
      "Wiedergabe", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Lire l'enregistrement", // Franais
      "", // Norsk
      "Toistetaan tallennetta",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "stop playback", // English
      "Anhalten", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "arrter la lecture", // Franais
      "", // Norsk
      "Lopeta toisto",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "resume playback", // English
      "Fortsetzen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "continuer", // Franais
      "", // Norsk
      "Jatka toistoa",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "pause playback", // English
      "Pause", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "pause", // Franais
      "", // Norsk
      "Pysyt toisto",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "fast forward", // English
      "Suchlauf vorwrts", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "avance rapide", // Franais
      "", // Norsk
      "Pikakelaus eteenpin",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "fast rewind", // English
      "Suchlauf rckwrts", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "retour rapide", // Franais
      "", // Norsk
      "Pikakelaus taaksepin",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Remote Control", // English
      "Fernbedienung", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Tlcommande", // Franais
      "", // Norsk
      "Kauko-ohjain",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Interval", // English
      "Intervall", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Intervalle", // Franais
      "", // Norsk
      "Pivitysvli",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Save", // English
      "Speichern", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Sauvegarde", // Franais
      "", // Norsk
      "Tallenna",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Menu", // English
      "Men", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Menu", // Franais
      "", // Norsk
      "Valikko",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Exit", // English
      "Zurck", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Quitter", // Franais
      "", // Norsk
      "Poistu",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Back", // English
      "Zurck", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Retour", // Franais
      "", // Norsk
      "Takaisin",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Ok", // English
      "Ok", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Ok", // Franais
      "", // Norsk
      "Ok",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Vol+", // English
      "Laut+", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vol+", // Franais
      "", // Norsk
      "ni+",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Vol-", // English
      "Laut-", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vol-", // Franais
      "", // Norsk
      "ni-",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Mute", // English
      "Stumm", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Muet", // Franais
      "", // Norsk
      "Mykist",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "New timer", // English
      "Neuen Timer anlegen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Nouvelle programmation", // Franais
      "", // Norsk
      "Luo uusi ajastin",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Edit", // English
      "ndern", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Changer", // Franais
      "", // Norsk
      "Muokkaa",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Weekday", // English
      "Wochentag", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Jour de la semaine", // Franais
      "", // Norsk
      "Viikonpiv",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Use VPS", // English
      "VPS verwenden", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Utiliser VPS", // Franais
      "", // Norsk
      "Kyt VPS-toimintoa",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Monday", // English
      "Montag", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Lundi", // Franais
      "", // Norsk
      "Maanantai",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Tuesday", // English
      "Dienstag", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Mardi", // Franais
      "", // Norsk
      "Tiistai",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Wednesday", // English
      "Mittwoch", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Mercredi", // Franais
      "", // Norsk
      "Keskiviikko",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Thursday", // English
      "Donnerstag", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Jeudi", // Franais
      "", // Norsk
      "Torstai",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Friday", // English
      "Freitag", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vendredi", // Franais
      "", // Norsk
      "Perjantai",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Saturday", // English
      "Samstag", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Samedi", // Franais
      "", // Norsk
      "Lauantai",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Sunday", // English
      "Sonntag", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Dimanche", // Franais
      "", // Norsk
      "Sunnuntai",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Yes", // English
      "Ja", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Oui", // Franais
      "", // Norsk
      "kyll",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "No", // English
      "Nein", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Non", // Franais
      "", // Norsk
      "ei",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Searchtimers", // English
      "Suchtimer", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Recherche", // Franais
      "", // Norsk
      "Hakuajastimet",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "retrieving status ...", // English
      "Hole Status ...", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "mise  jours de l'tat", // Franais
      "", // Norsk
      "Haetaan tietoja ...",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "previous channel", // English
      "Sender zurck", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "chane prcdent", // Franais
      "", // Norsk
      "Edellinen kanava",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "next channel", // English
      "Sender vor", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Chane suivante", // Franais
      "", // Norsk
      "Seuraava kanava",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Record this", // English
      "Diese Sendung aufnehmen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Enregistrer cette mission", // Franais
      "", // Norsk
      "Tallenna ohjelma",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Edit this", // English
      "Timer editieren", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Changer cette programmation", // Franais
      "", // Norsk
      "Muokkaa ajastinta",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Click to view details.", // English
      "Fr Details klicken.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Clic pour voire les dtails.", // Franais
      "", // Norsk
      "Napsauta katsoaksesi listietoja.",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "more", // English
      "mehr", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "plus", // Franais
      "", // Norsk
      "listietoja",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Switch to this channel.", // English
      "Zu diesem Kanal umschalten.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Changer vers cette chane. ", // Franais
      "", // Norsk
      "Vaihda kanavalle",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "play this recording.", // English
      "Diese Aufnahme abspielen.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "lire cette enregistrement.", // Franais
      "", // Norsk
      "Toista tallenne",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Toggle updates on/off.", // English
      "Statusabfrage ein- oder ausschalten.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Activer/Dsactiver l'update du status", // Franais
      "", // Norsk
      "Aseta tilannekysely plle/pois",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "no epg info for current event!", // English
      "Keine Infos zur Sendung!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Pas d'infos pour l'mission!", // Franais
      "", // Norsk
      "Lhetyksell ei ole ohjelmatietoja!",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "no epg info for current channel!", // English
      "Dieser Kanal hat kein EPG!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Cette chane n'a pas d'EPG!", // Franais
      "", // Norsk
      "Kanavalla ei ole ohjelmatietoja!",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "no current channel!", // English
      "Keinen Kanal gefunden!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "pas de chane trouv!", // Franais
      "", // Norsk
      "Kanavaa ei lydy!",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "error retrieving status info!", // English
      "Fehler: Status nicht verfgbar!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "erreur: pas d'information d'tat!", // Franais
      "", // Norsk
      "Virhe: tilannetietoja ei saatavilla!",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "No server response!", // English
      "Der Server antwortet nicht!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Palvelin ei vastaa!", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Failed to update infobox!", // English
      "Kann Infobox nicht aktualisieren!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Infolaatikon pivitys eponnistui!", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "loading data", // English
      "Daten nachladen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "ladataan tietja", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "an error occured!", // English
      "Es ist ein Fehler aufgetreten!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "virhe havaittu!", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Request succeeded!", // English
      "Aktion durchgefhrt!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Request failed!", // English
      "Aktion fehlgeschlagen!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Show live logo image", // English
      "Zeige das Live Logo", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Nyt Live-logo", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Use ajax technology", // English
      "Verwende AJAX Technologie", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Kyt AJAX-tekniikkaa", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Show dynamic VDR information box", // English
      "Zeige dynamische VDR Status Box", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Nyt dynaaminen VDR:n infolaatikko", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "View the schedule of this channel", // English
      "Zeige Programm dieses Kanals", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Regarder le programme de cette chane", // Franais
      "", // Norsk
      "Nyt ohjelmisto kanavalta",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "No schedules available for this channel", // English
      "Fr diesen Kanal liegen keine EPG-Informationen vor", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Tlle kanavalle ei ole saatavilla ohjelmistoa", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Search term", // English
      "Suchbegriff", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Mot cl", // Franais
      "", // Norsk
      "Hakuehto",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Search mode", // English
      "Suchmodus", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Mode de recherche", // Franais
      "", // Norsk
      "Hakutapa",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "phrase",
      "Ausdruck",
      "",// TODO
      "frase",// Italiano
      "uitdruk",
      "",// TODO
      "Phrase",
      "",// TODO
      "fraasi",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "all words",
      "alle Worte",
      "",// TODO
      "tutte le parole",// Italiano
      "alle woorden",
      "",// TODO
      "tout les mots",
      "",// TODO
      "kaikki sanat",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "at least one word",
      "ein Wort",
      "",// TODO
      "almeno una parola",// Italiano
      "ten minste een woord",
      "",// TODO
      "un mot",
      "",// TODO
      "yksi sana",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },

    { "match exactly",
      "exakt",
      "",// TODO
      "esatta corrispondenza",// Italiano
      "precies passend",
      "",// TODO
      "correspond exactement",
      "",// TODO
      "tsmllinen",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Ees  ti
      "",// TODO Dansk
      "",// TODO esky (Czec  h)

    },
    { "regular expression",
      "regulrer Ausdruck",
      "",// TODO
      "espressione regolare",// Italiano
      "reguliere uitdruk  king",
      "",// TODO
      "expression rguliere",
      "",// TODO
      "snnllinen lauseke",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Ees  ti
      "",// TODO Dansk
      "",// TODO esky (Czec  h)
    },
    { "Match case",
      "Gro/klein",
      "",// TODO
      "Mai    uscolo/Minuscolo",// Italiano
      "Idem case",
      "",// TODO
      "Maj/Minuscule",
      "",// TODO
      "Huomioi kirjainkoko",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Tolerance",
      "Toleranz",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "Tolrance",// TODO
      "",// TODO
      "Toleranssi",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "fuzzy",
      "unscharf",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "imprcis",
      "",// TODO
      "sumea",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Search in", // English
      "Suche in", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Recherche dans", // Franais
      "", // Norsk
      "Hae kentist",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Title", // English
      "Titel", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Titre", // Franais
      "", // Norsk
      "Otsikko",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Episode", // English
      "Episode", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "pisode", // Franais
      "", // Norsk
      "Jakson nimi",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Description", // English
      "Beschreibung", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Description", // Franais
      "", // Norsk
      "Kuvaus",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Show schedule of channel", // English
      "Zeige Programm dieses Kanals", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Montrer le programme de la chane", // Franais
      "", // Norsk
      "Nyt kanavan ohjelmisto",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Use channel",
      "Verw. Kanal",
      "",// TODO
      "Utilizzare canale",// Italiano
      "Gebruik kanaal",
      "",// TODO
      "Utiliser la chane",
      "",// TODO
      "Kyt kanavaa",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "interval",
      "Bereich",
      "",// TODO
      "intervallo",// Italiano
      "interval",
      "",// TODO
      "intervalle",// Francais Pat
      "",// TODO
      "kyll",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "channel group",
      "Kanalgruppe",
      "",// TODO
      "gruppo canali",// Italiano
      "kanaal groep",
      "",// TODO
      "Groupe de chanes",// Francais Pat
      "",// TODO
      "kanavaryhm",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "only FTA",
      "ohne PayTV",
      "",// TODO
      "solo FTA",// Italiano
      "alleen FTA",
      "",// TODO
      "sans TV-Payante",
      "",// TODO
      "vapaat kanavat",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "from channel",
      "von Kanal",
      "",// TODO
      "da canale",// Italiano
      "van kanaal",
      "",// TODO
      "de la chane",
      "",// TODO
      "Kanavasta",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "to channel",
      "bis Kanal",
      "",// TODO
      "a canale",// Italiano
      "tot kanaal",
      "",// TODO
      " la chane",
      "",// TODO
      "Kanavaan",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Use extended EPG info",
      "Verw. erweiterte EPG Info",
      "",// TODO
      "Utilizzare informazioni EPG estesa",// Italiano
      "Gebruik uitgebreide EPG info",
      "",// TODO
      "Utiliser les infos EPG avances",// Francais Pat
      "",// TODO
      "Kyt laajennettua ohjelmaopasta",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Use time",
      "Verw. Uhrzeit",
      "",// TODO
      "Utilizzare l'orario",// Italiano
      "Gebruik tijd",
      "",// TODO
      "Utiliser l'heure",
      "",// TODO
      "Kyt aloitusaikaa",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Start after",
      "Start nach",
      "",// TODO
      "Comincia dopo",// Italiano
      "Start na",
      "",// TODO
      "Dpart aprs",
      "",// TODO
      "Aloitusaika aikaisintaan",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Start before",
      "Start vor",
      "",// TODO
      "Comincia prima",// Italiano
      "Start voor",
      "",// TODO
      "Dpart avant",
      "",// TODO
      "Aloitusaika viimeistn",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Use duration",
      "Verw. Dauer",
      "",// TODO
      "Utilizzare durata",// Italiano
      "Gebruiks duur",
      "",// TODO
      "Dure d'utilisation",
      "",// TODO
      "Kyt kestoaikaa",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Max. duration",
      "Max. Dauer",
      "",// TODO
      "Durata Massima",// Italiano
      "Max. duur",
      "",// TODO
      "Dure max.",
      "",// TODO
      "Kestoaika enintn",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Min. duration",
      "Min. Dauer",
      "",// TODO
      "Durata Minima",// Italiano
      "Min. duur",
      "",// TODO
      "Dure min.",
      "",// TODO
      "Kestoaika vhintn",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Use day of week",
      "Verw. Wochentag",
      "",// TODO
      "Utilizzare giorno della settimana",// Italiano
      "Gebruik dag van de week",
      "",// TODO
      "Utiliser les jours de la semaine",
      "",// TODO
      "Kyt viikonpiv",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Use blacklists",
      "Verw. Ausschlusslisten",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "Utiliser la liste des exclus",
      "",// TODO
      "Kyt mustia listoja",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Use in favorites menu",
      "In Favoritenmen verw.",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "Utiliser dans le menu favoris",
      "",// TODO
      "Kyt suosikkina",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Use as search timer",
      "Als Suchtimer verwenden",
      "",// TODO
      "Utilizzare come timer di ricerca",// Italiano
      "Gebruik als zoek timer",
      "",// TODO
      "Utiliser la recherche",
      "",// TODO
      "Kyt hakuajastimena",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Record",
      "Aufnehmen",
      "Posnemi",
      "Registra",
      "Opnemen",
      "Gravar",
      "Enregistre",
      "Ta opp",
      "Tallenna",
      "Nagraj",
      "Grabar",
      "",
      "Inspelning",
      "nregistr.",
      "Felvenni",
      "Gravar",
      "",
      "Snimi",
      "Salvesta",
      "Optag",
      "Nahrt",
    },
    { "Switch only",
      "Nur umschalten",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "Seulement changer de chaine",
      "",// TODO
      "Kanavanvaihto",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Announce only",
      "Nur ankndigen",
      "",// TODO
      "Solo annuncio (niente timer)",// Italiano
      "Alleen aankondigen (geen timer)",
      "",// TODO
      "Annoncer seulement le dbut de l'mission",
      "",// TODO
      "Muistutus",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Series recording",
      "Serienaufnahme",
      "",// TODO
      "Registrazione serie",// Italiano
      "Serie's opnemen",
      "",// TODO
      "Enregistrement de srie",
      "",// TODO
      "Sarjatallennus",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Directory",
      "Verzeichnis",
      "",// TODO
      "Cartella",// Italiano
      "Directory",
      "",// TODO
      "Dossier",
      "",// TODO
      "Hakemisto",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Delete recordings after ... days",
      "Aufn. nach ... Tagen lschen",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Effacer l'enregistrement aprs ... jours",// Francais Pat
      "",// TODO
      "Poista tallenteet ... pivn jlkeen",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Keep ... recordings",
      "Behalte ... Aufnahmen",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Garder .... les enregistrements",
      "",// TODO
      "Silyt ... tallennetta",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Pause when ... recordings exist",
      "Pause, wenn ... Aufnahmen exist.",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "Pause, lorsque ... l'enregistrement existe.",
      "",// TODO
      "Keskeyt ... tallenteen jlkeen",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Switch ... minutes before start",
      "Umschalten ... Minuten vor Start",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "Changer ... minutes avant le dbut",
      "",// TODO
      "Vaihda ... minuuttia ennen alkua",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Avoid repeats",
      "Vermeide Wiederholung",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Eviter les rptitions",// Francais Pat
      "",// TODO
      "Est uusinnat",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Allowed repeats",
      "Erlaubte Wiederholungen",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Rptitions autorises",// Francais Pat
      "",// TODO
      "Sallittujen uusintojen lukumr",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Only repeats within ... days",
      "Nur Wiederh. innerhalb ... Tagen",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Que rptition, pendant ... jours",// Francais Pat
      "",// TODO
      "Vain uusinnat ... pivn sisll",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Compare title",
      "Vergleiche Titel",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Comparer titres",// Francais Pat
      "",// TODO
      "Vertaa nime",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Compare subtitle",
      "Vergleiche Untertitel",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Comparer les sous-titres",// Francais Pat
      "",// TODO
      "Vertaa jakson nime",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)

    },
    { "Compare summary",
      "Vergleiche Beschreibung",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Comparer les descriptions",// Francais Pat
      "",// TODO
      "Vertaa kuvausta",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Compare",
      "Vergleiche",
      "",// TODO
      "",// Italiano
      "",// TODO
      "",// TODO
      "Comparer",// Francais Pat
      "",// TODO
      "Vertaa",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Selection",
      "Auswahl",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "Selection",// Francais Pat
      "",// TODO
      "valittu",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)

    },
    { "all",
      "alle",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "tous",// Francais Pat
      "",// TODO
      "kaikki",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "Search results",
      "Suchergebnisse",
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Rsultats", // Franais
      "", // Norsk
      "Hakutulokset",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "No search results",
      "keine Suchergebnisse",
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "pas de rsultat de recherche", // Franais
      "", // Norsk
      "Ei hakutuloksia",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Power", // English
      "Ausschalten", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "teindre", // Franais
      "", // Norsk
      "Virta",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Begin Recording", // English
      "Sofortaufnahme", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Enregistrement direct", // Franais
      "", // Norsk
      "Aloita tallennus",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Up", // English
      "Hoch", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vers le haut", // Franais
      "", // Norsk
      "Yls",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Down", // English
      "Runter", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vers le bas", // Franais
      "", // Norsk
      "Alas",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Left", // English
      "Links", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Gauche", // Franais
      "", // Norsk
      "Vasen",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Right", // English
      "Rechts", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Droite", // Franais
      "", // Norsk
      "Oikea",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Red", // English
      "Rot", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Rouge", // Franais
      "", // Norsk
      "Punainen",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Green", // English
      "Grn", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vert", // Franais
      "", // Norsk
      "Vihre",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Yellow", // English
      "Gelb", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Jaune", // Franais
      "", // Norsk
      "Keltainen",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Blue", // English
      "Blau", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Bleu", // Franais
      "", // Norsk
      "Sininen",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "New",
      "Neu",
      "Novo",
      "Nuovo",
      "Nieuw",
      "Novo",
      "Nouveau",
      "Ny",
      "Uusi",
      "Nowy",
      "Nuevo",
      "N",
      "Ny",
      "Nou",
      "j",
      "Nou",
      "",
      "Novi",
      "Uus",
      "Ny",
      "Nov",
    },
    { "Toggle timer active/inactive",
      "Timer aktiv/inaktiv schalten",
      "",
      "",
      "",
      "",
      "Programmation basculer actif/inactif",
      "",
      "Aseta ajastin plle/pois",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Delete timer",
      "Timer lschen",
      "",
      "",
      "",
      "",
      "Effacer la programmation",
      "",
      "Poista ajastin",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Edit timer",
      "Timer bearbeiten",
      "",
      "",
      "",
      "",
      "Editer la programmation",
      "",
      "Muokkaa ajastinta",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Toggle search timer actions (in)active",
      "Aktionen des Suchtimers (de)aktivieren",
      "",
      "",
      "",
      "",
      "Actions de la programmation de recherche (in)actives",
      "",
      "Aseta hakuajastin plle/pois",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Browse search timer results",
      "Suchtimerergebnisse betrachten",
      "",
      "",
      "",
      "",
      "Passer en revue les rsultats de programmation de recherche",
      "",
      "Selaa hakutuloksia",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Delete search timer",
      "Suchtimer lschen",
      "",
      "",
      "",
      "",
      "Effacer la programmation de recherche",
      "",
      "Poista hakuajastin",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Expression",
      "Suchbegriff",
      "",
      "",
      "",
      "",
      "Expression de recherche",
      "",
      "Hakutermi",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Edit search timer",
      "Suchtimer bearbeiten",
      "",
      "",
      "",
      "",
      "Editer l'expression de recherche",
      "",
      "Muokkaa hakuajastinta",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "New search timer",
      "Neuen Suchtimer anlegen",
      "",
      "",
      "",
      "",
      "Crer nouvelle programmation de recherche",
      "",
      "Luo uusi hakuajastin",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Delete this search timer?", // English
      "Diesen Suchtimer lschen?", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Effacer cette programmation de recherche?", // Franais
      "", // Norsk
      "Poistetaanko tm hakuajastin?",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Cancel",
      "Abbrechen",
      "",
      "",
      "",
      "",
      "Interrompre",
      "",
      "Peru",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },

    { "All",
      "Alle",
      "",
      "",
      "",
      "",
      "Tout",
      "",
      "Kaikki",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
    },
    { "Test", // English
      "Testen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Tester", // Franais
      "", // Norsk
      "Testaa",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "The time the show may start at the latest", // English
      "Die Zeit, zu der die Sendung sptestens angefangen haben muss", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "L'heure lorsque l'mission doit commencer au plus tard", // Franais
      "", // Norsk
      "Lhetyksen aloitusaika viimeistn",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "The time the show may start at the earliest", // English
      "Die Zeit, zu der die Sendung frhestens anfangen darf", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "L'heure lorsque l'mission doit commencer au plus tt", // Franais
      "", // Norsk
      "Lhetyksen aloitusaika aikaisintaan",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Search text too short - use anyway?",
      "Suchtext zu kurz - trotzdem verwenden?",
      "",// TODO
      "Il testo da cercare  troppo corto.  Continuare lo stesso?",// Italiano
      "Zoek tekst tekort - toch gebruiken?",
      "",// TODO
      "Texte de recherche est trop court - l'utiliser quand mme?",
      "",// TODO
      "Liian suppea hakuehto - etsitnk silti?",
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO
      "",// TODO Eesti
      "",// TODO Dansk
      "",// TODO esky (Czech)
    },
    { "User", // English
      "Benutzer", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Utilisateur", // Franais
      "", // Norsk
      "Kyttj",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Password", // English
      "Passwort", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Mot de passe", // Franais
      "", // Norsk
      "Salasana",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Last channel to display", // English
      "Letzer angezeigter Kanal", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Dernire chane affiche", // Franais
      "", // Norsk
      "Nyt viimeisen kanava",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Use authentication", // English
      "Authentifizierung nutzen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Utiliser l'authentification", // Franais
      "", // Norsk
      "Kyt autentikointia",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "No limit", // English
      "Alle zeigen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Afficher tout", // Franais
      "", // Norsk
      "ei rajoitusta",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Admin login", // English
      "Admin Login", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Ouverture Admin", // Franais
      "", // Norsk
      "Yllpidon kyttjtunnus",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Admin password", // English
      "Admin Passwort", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Mot de passe de l'Admin", // Franais
      "", // Norsk
      "Yllpidon salasana",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "VDR Live Login", // English
      "VDR Live Login", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Session VDR Live", // Franais
      "", // Norsk
      "VDR Live - sisnkirjautuminen",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Logout", // English
      "Abmelden", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Fin de la session", // Franais
      "", // Norsk
      "Kirjaudu ulos",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Login", // English
      "Anmelden", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Session", // Franais
      "", // Norsk
      "Kirjaudu sisn",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Search", // English
      "Suchen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Recherche", // Franais
      "", // Norsk
      "Etsi",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Extended search", // English
      "Erweiterte Suche", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Recherche tendue", // Franais
      "", // Norsk
      "Laajennettu haku",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Search settings", // English
      "Einstellungen zur Suche", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Rglages de recherche", // Franais
      "", // Norsk
      "Hakuasetukset",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "On archive DVD No.", // English
      "Auf Archiv-DVD Nr.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Sur le DVD archive no", // Franais
      "", // Norsk
      "Arkistointi-DVD:ll numero",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Starts between", // English
      "Beginnt zwischen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Dpart entre", // Franais
      "", // Norsk
      "Alkaa vlill",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Wrong username or password", // English
      "Falscher Benutzername oder Passwort", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Nom de l'utilisateur ou mot de passei sont erron", // Franais
      "", // Norsk
      "Vr kyttjtunnus tai salasana",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Required minimum version of epgsearch: ", // English
      "Bentigte Mindestversion von epgsearch: ", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Version minimum requise d'epgsearch: ", // Franais
      "", // Norsk
      "Vaadittava versio EPGSearch-laajennoksesta: ",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "EPGSearch version outdated! Please update.", // English
      "EPGSearch-Version zu alt, bitte updaten!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Version EPGSearch prime! Mettre  jour Svp.", // Franais
      "", // Norsk
      "EPGSearch-laajennos pitisi pivitt!",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Search for repeats.", // English
      "Nach Wiederholungen suchen.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Recherche de rptitions.", // Franais
      "", // Norsk
      "Etsi toistuvat",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "What's on",
      "Was luft",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Actuellement", // Franais
      "", // Norsk
      "Menossa",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "What's on?",
      "Was luft?",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Actuellement?", // Franais
      "", // Norsk
      "Menossa?",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Now",
      "Jetzt",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "maintenant", // Franais
      "", // Norsk
      "Nyt",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Next",
      "als Nchstes",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "prochainement", // Franais
      "", // Norsk
      "Seuraavaksi",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "additional fixed times in 'What's on?'",
      "zustzliche Zeitpunkte in 'Was luft?'",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "priodes fixes additionnelles dans 'actuellement?'", // Franais
      "", // Norsk
      "Lisajankohdat 'Menossa?'-sivulle",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Format is HH:MM. Separate multiple times with a semicolon",
      "Format ist HH:MM. Mehrere Zeiten durch Semikolon trennen",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Le format est HH:MM . Plusieurs priodes spares avec un point-virgule", // Franais
      "", // Norsk
      "Kyt HH:MM formaattia ja erota ajankohdat puolipisteell",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "at",
      "um",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "kello",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Authors",
      "Autoren",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Auteur", // Franais
      "", // Norsk
      "Tekijt",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Project leader",
      "Projektleiter",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Chef de projet", // Franais
      "", // Norsk
      "Projektipllikk",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Webserver",
      "Webserver",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Serveur Web", // Franais
      "", // Norsk
      "HTTP-palvelin",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Content",
      "Inhalte",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Contenu", // Franais
      "", // Norsk
      "Sislt",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Graphics",
      "Grafiken",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Graphiques", // Franais
      "", // Norsk
      "Grafiikka",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Information",
      "Informationen",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Information", // Franais
      "", // Norsk
      "Tietoja",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "LIVE version",
      "LIVE Version",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Version LIVE", // Franais
      "", // Norsk
      "LIVE-versio",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "VDR version",
      "VDR Version",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Version VDR", // Franais
      "", // Norsk
      "VDR-versio",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Features",
      "Untersttze Plugins",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Soutien des plugins", // Franais
      "", // Norsk
      "Tuetut laajennokset",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Homepage",
      "Homepage",
      "", // Slovenski
      "", // Italiono
      "", // Nederlands
      "", // Portugus
      "Page d'accueil", // Franais
      "", // Norsk
      "Kotisivu",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Couldn't find timer. Maybe you mistyped your request?", // English
      "Konnte Timer nicht finden. Evtl. fehlerhafte Anforderung?", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "N'a pas pu trouver la programmation. Peut-tre vous avez une erreur dans votre requte?", // Franais
      "", // Norsk
      "Ajastinta ei lydy. Kirjoititko varmasti oikein?",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Couldn't find channel or no channels available. Maybe you mistyped your request?", // English
      "Konnte Kanal nicht finden oder keine Kanle verfgbar. Ist die Anfrage korrekt?", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "N'a pas pu trouver la chane. Votre requte est t'elle corrte? ", // Franais
      "", // Norsk
      "Kanavaa ei lydy. Kirjoititko varmasti oikein?",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Page error", // English
      "Seitenfehler", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Erreur de page", // Franais
      "", // Norsk
      "Sivuvirhe",
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "If you encounter any bugs or would like to suggest new features, please use our bugtracker", // English
      "Fr Fehler oder Verbesserungsvorschlge steht unser Bugtracker bereit", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Si vous rencontrez n'importe quels bogue ou voudriez suggrer de nouveaux dispositifs, employer notre bugtracker svp", // Franais
      "", // Norsk
      "Voit raportoida sek virheet ett parannusehdotukset suoraan havaintotietokantaan", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Bugs and suggestions", // English
      "Fehlerberichte und Vorschlge", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Bogues et suggestions", // Franais
      "", // Norsk
      "Virheraportoinnit ja parannusehdotukset", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Find more at the Internet Movie Database.", // English
      "Weitere Informationen in der Internet Movie Database.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Trouver plus d'information du film dans la base de donnes film IMDB.", // Franais
      "", // Norsk
      "Hae IMDB:st", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Details view", // English
      "Ausfhrliche Ansicht", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vue dtaile", // Franais
      "", // Norsk
      "Ruudukkonkym", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "List view", // English
      "Listenansicht", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Vue en liste", // Franais
      "", // Norsk
      "Listankym", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "No timer defined", // English
      "Keine Timer vorhanden", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Aucune programmation dfinie", // Franais
      "", // Norsk
      "Ajastinta ei ole mritelty", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Start page", // English
      "Startseite", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Page de dpart", // Franais
      "", // Norsk
      "Aloitussivu", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "active", // English
      "aktiv", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "actif", // Franais
      "", // Norsk
      "kytss", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "required", // English
      "erforderlich", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "requis", // Franais
      "", // Norsk
      "vaadittava", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Local net (no login required)", // English
      "Lokales Netz (keine Anmeldung notwendig)", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Rseau local (non requis)", // Franais
      "", // Norsk
      "Paikallinen verkko (ei autentikointia)", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Theme", // English
      "Thema", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Thme", // Franais
      "", // Norsk
      "Ulkoasu", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Please set login and password!", // English
      "Bitte Login und Passwort angeben!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Entre le nom d'utilisateur et le mot de passe svp!", // Franais
      "", // Norsk
      "Aseta kyttjtunnus sek salasana!", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Please set a title for the timer!", // English
      "Bitte einen Titel fr den Timer angeben!", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Veuillez indiquer un titre pour la programmation!", // Franais
      "", // Norsk
      "Aseta nimi ajastimelle!", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Setup saved.", // English
      "Einstellungen gespeichert.", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Paramtre sauvegard", // Franais
      "", // Norsk
      "Asetukset tallennettu.", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Trigger search timer update", // English
      "Suchtimer-Update starten", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "Mise  jour des recherches de programmation maintenant", // Franais
      "", // Norsk
      "Pivit hakuajastimet", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Electronic program guide information", // English
      "Elektronische Programminformation", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Ohjelmaoppaan tiedot", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Epg error", // English
      "EPG Fehler", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "Ohjelmaoppaan virhe", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
    },
    { "Auto-delete search timer", // English
      "Suchtimer automatisch lschen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugu?s
      "", // Fran?ais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espa?ol
      "", // Greek
      "", // Svenska
      "", // Rom?n?
      "", // Magyar
      "", // Catal?
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "after ... recordings", // English
      "nach ... Aufnahmen", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugu?s
      "", // Fran?ais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espa?ol
      "", // Greek
      "", // Svenska
      "", // Rom?n?
      "", // Magyar
      "", // Catal?
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "after ... days after first rec.", // English
      "nach ... Tagen nach erster Aufnahme", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugu?s
      "", // Fran?ais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espa?ol
      "", // Greek
      "", // Svenska
      "", // Rom?n?
      "", // Magyar
      "", // Catal?
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "user defined", // English
      "benutzer-definiert", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "from date", // English
      "ab Datum", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "to date", // English
      "bis Datum", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "mm/dd/yyyy", // English - Dateformat for Datepicker, use 'mm' for month, 'dd' for day, 'yyyy' for year
      "dd.mm.yyyy", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "January", // English
      "Januar", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "February", // English
      "Februar", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "March", // English
      "Mrz", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "April", // English
      "April", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "May", // English
      "Mai", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "June", // English
      "Juni", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "July", // English
      "Juli", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "August", // English
      "August", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "September", // English
      "September", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "October", // English
      "Oktober", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "November", // English
      "November", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    { "December", // English
      "Dezember", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    /*
      { "", // English
      "", // Deutsch
      "", // Slovenski
      "", // Italiano
      "", // Nederlands
      "", // Portugus
      "", // Franais
      "", // Norsk
      "", // Finnish
      "", // Polski
      "", // Espaol
      "", // Greek
      "", // Svenska
      "", // Romn
      "", // Magyar
      "", // Catal
      "", // Russian
      "", // Hrvatski
      "", // Eesti
      "", // Dansk
      "", // Czech
      },
    */
    { 0 },
};
#endif

} // namespace vdrlive
