#ifndef _CARDINFO_H
#define _CARDINFO_H

#include <stdio.h>			// Header File For Standard Input/Output
#include <string>
#include <iostream>
#include <fstream>
#include <cmath>
#include <cassert>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>

using namespace std;

#include <vector>

//#include "utility.h"
//#include "globals.h"

#define NUM_CARDINFOTYPES 4
namespace CARDINFOTYPE
{
	enum TYPE
	{
		MULTITEXTURE = 0,
		TEXTUREUNITS = 1,
		ANISOTROPY = 2,
		MAXANISOTROPY = 3
	};
}
	
class CARDCAPABILITY
{
public:
	//CARDINFOTYPE::TYPE type;
	int data;
};

class CARDINFO
{
private:
	vector <CARDCAPABILITY> db;
	bool dbvalid;
	
	void ResetDB();
	bool isExtensionSupported(string extstring);

public:
	CARDINFO() {ResetDB();}
	void BuildCardInfo();
	int GetCapability(CARDINFOTYPE::TYPE capability);
	void PrintCardInfo(ostream & out);
};

#endif
