#ifndef _VGUI_CALIBRATE_H
#define _VGUI_CALIBRATE_H

/* calibrate.h */
#include "controls.h"
#include "gui/gui.h"

namespace VGUI
{
	class CalSet
	{
	private:
		float upper_value, lower_value, cur_value;

	public:
		CalSet() { upper_value = lower_value = 0.0f; }
		CalSet( float upper, float lower ) : upper_value( upper ), lower_value( lower ) { }
		~CalSet() { }
		float GetUpperValue() { return upper_value; }
		void SetUpperValue( float new_upper_value ) { upper_value = new_upper_value; }
		float GetLowerValue() { return lower_value; }
		void SetLowerValue( float new_lower_value ) { lower_value = new_lower_value; }
		float GetCurrentValue() { return cur_value; }
		void SetCurrentValue( float new_cur_value ) { cur_value = new_cur_value; }
	};

	class Calibrate : public Widget
	{
	private:
		map< int, map<int, CalSet*> > calibrations;
		TEXTURE_HANDLE axis_field_tex, joy_cursor_tex, joy_cal_box_tex;
		float field_width, field_height, cursor_width, cursor_height;
		int cur_joy_idx;

	public:
		Calibrate();
		Calibrate( Widget *w );
		~Calibrate();

		void Draw();
		void Draw( float opacity );
		void Save();
		void ResetValue();
		void GrabJoyMove( Uint8 joy_idx, Uint8 joy_axis, bool joy_positive, float joy_value );
		void HookIncValuePress() { }
		void HookDecValuePress() { }
		void HookIncValueRelease();
		void HookDecValueRelease();
	};
}

#endif // _VGUI_CALIBRATE_H
