#ifndef _VGUI_MULTIIMAGE_H
#define _VGUI_MULTIIMAGE_H

/* image.h */
#include "gui.h"

namespace VGUI
{
	class MultiImage : public Widget
	{
	public:
		MultiImage() {}
		MultiImage( Widget* w );
		~MultiImage();
		void Draw();
		void Draw( float opacity );
		bool MouseOver( float x, float y );
		string MousePress( float x, float y );
		string MouseRelease( float x, float y );
		void ResetValue();
		void HookIncValuePress();
		void HookDecValuePress();
		void HookIncValueRelease();
		void HookDecValueRelease();
		void Release();

		vector<string> GetFilenameList() { return filename_list; }
		vector<string> GetValueList() { return value_list; }
		string GetValue() { return value_list[cur_option]; }
		string GetSetting() { return setting; }
		void SetFilenameList( vector<string> new_filename_list ) { filename_list = new_filename_list; Load(); }
		void SetValueList( vector<string> new_value_list ) { value_list = new_value_list; }
		void SetValue( string new_value ) { for( unsigned int i = 0; i < filename_list.size(); i++ ) if( filename_list[i] == new_value ) cur_option = i; return; }
		void SetSetting( string new_setting ) { setting = new_setting; }

	private:
		void Load();

		vector<string> filename_list;
		vector<string> value_list;
		vector<TEXTURE_HANDLE> img_tex_list;
		unsigned int cur_option, last_option;
		string setting;
		bool l_down, r_down;
		Uint32 press_time;
	};
}


#endif // _VGUI_MULTIIMAGE_H
