#ifndef _VGUI_WIDGET_H
#define _VGUI_WIDGET_H

/* widget.h */
#include <map>
#include <string>
#include <GL/gl.h>
#include <SDL/SDL.h>
#include "multiplay.h"
#include "textures.h"
#include "font.h"
#include "gamestate.h"
#include "settings.h"
#include "configfile.h"
#include "globals.h"

namespace VGUI
{
	class Location
	{
	private:
		float xpct, ypct;

	public:
		Location();
		~Location();
		Location(float _xpct, float _ypct) { xpct = _xpct; ypct = _ypct; }
	
		float GetXPercent() { return xpct; }
		float GetYPercent() { return ypct; }

		void SetXPercent( float new_xpct ) { xpct = new_xpct; }
		void SetYPercent( float new_ypct ) { ypct = new_ypct; }
	};


	class Widget
	{
	protected:
		Location center;
		string name;
		string text;
		string type;
		string tip;
		float rel_width;
		float rel_height;
		bool enabled;
		bool selected;
		bool is_default;
		bool is_cancel;
		bool has_icon;
		bool width_auto;
		bool height_auto;
		int font_size;
		float color_r;
		float color_g;
		float color_b;
	
	public:
		Widget();
		~Widget() { }

		virtual void Save( void ) { }
		virtual void Draw( void ) { }
		virtual void Draw( float opacity ) { }
		virtual void IncValuePress( void ) { }
		virtual void DecValuePress( void ) { }
		virtual void IncValueRelease( void ) { }
		virtual void DecValueRelease( void ) { }
		virtual void HookIncValuePress( void ) { }
		virtual void HookDecValuePress( void ) { }
		virtual void HookIncValueRelease( void ) { }
		virtual void HookDecValueRelease( void ) { }
		virtual void HookRelease( void ) { }
		virtual void BackspacePress() { }
		virtual void DeletePress() { }
		virtual void BackspaceRelease() { }
		virtual void DeleteRelease() { }
		virtual string GetAction( void ) { return ""; }
		virtual string GetHook( void ) { return ""; }
		virtual int GetNumCols( void ) { return 0; }
		virtual void SetValue( bool val ) { }
		virtual void SetValue( string val ) { }
		virtual void SetValue( float val ) { }
		virtual void SetDefaultValue( bool val ) { }
		virtual void SetDefaultValue( string val ) { }
		virtual void SetDefaultValue( float val ) { }
		virtual void SetSetting( string new_setting ) { }
		virtual void SetSaved( bool new_saved ) { }
		virtual bool GetSaved() { return true; }
		virtual void SetNumCols( int new_num_cols ) { }
		virtual void TogValue( void ) { }
		virtual bool MouseOver( float x, float y ) { return false; }
		virtual void Press( void ) { }
		virtual void Release( void ) { }
		virtual string MousePress( float x, float y ) { return ""; }
		virtual string MouseRelease( float x, float y ) { return ""; }
		virtual void ResetValue() { }
		virtual void ClearCar() { }
		virtual void EnterText( SDLKey key ) { }
		virtual void GrabKey( SDLKey key ) { }
		virtual void GrabMouseMovement( string direction ) { }
		virtual void GrabMouseButton( int button_idx ) { }
		virtual void GrabJoyButton( Uint8 joy_idx, Uint8 joy_btn ) { }
		virtual void GrabJoyMove( Uint8 joy_idx, Uint8 joy_axis, bool joy_positive, float joy_value ) { }
		virtual void SelectIcon( unsigned int new_selected_icon ) { }
		virtual bool GetAdding() { return false; }

		Location GetCenter() { return center; }
		string GetName() { return name; }
		string GetText() { return text; }
		string GetType() { return type; }
		string GetTip() { return tip; }
		float GetRelWidth() { return rel_width; }
		float GetRelHeight() { return rel_height; }
		bool GetEnabled() { return enabled; }
		bool GetSelected() { return selected; }
		bool GetDefault() { return is_default; }
		bool GetCancel() { return is_cancel; }
		bool GetHasIcon() { return has_icon; }
		bool GetWidthAuto() { return width_auto; }
		bool GetHeightAuto() { return height_auto; }
		int GetFontSize() { return font_size; }
		float GetColorR() { return color_r; }
		float GetColorG() { return color_g; }
		float GetColorB() { return color_b; }

		void SetCenter( Location new_center ) { center = new_center; }
		void SetName( string new_name ) { name = new_name; }
		void SetText( string new_text ) { text = new_text; }
		void SetType( string new_type ) { type = new_type; }
		void SetTip( string new_tip ) { tip = new_tip; }
		void SetRelWidth( float new_rel_width ) { rel_width = new_rel_width; }
		void SetRelHeight( float new_rel_height ) { rel_height = new_rel_height; }
		void SetEnabled( bool new_enabled ) { enabled = new_enabled; }
		void SetSelected( bool new_selected ) { selected = new_selected; }
		void SetDefault( bool new_is_default ) { is_default = new_is_default; }
		void SetCancel( bool new_is_cancel ) { is_cancel = new_is_cancel; }
		void SetHasIcon( bool new_has_icon ) { has_icon = new_has_icon; }
		void SetWidthAuto( bool new_width_auto ) { width_auto = new_width_auto; }
		void SetHeightAuto( bool new_height_auto ) { height_auto = new_height_auto; }
		void SetFontSize( int new_font_size ) { font_size = new_font_size; }
		void SetColor( float r, float g, float b ) { color_r = r; color_g = g; color_b = b; }
	};
}

#endif // _VGUI_WIDGET_H
