/***************************************************************************
 *            textures.h
 *
 *  Thu Dec  1 17:46:28 2005
 *  Copyright  2005  Joe Venzon
 *  joe@venzon.net
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _TEXTURES_H

#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#include <SDL/SDL.h>
#ifdef __APPLE__
#include <SDL_image/SDL_image.h>
#else
#include <SDL/SDL_image.h>
#endif
#include <math.h>
#include <string>
#include <fstream>
#include <iostream>

#include <list>

#include "utility.h"

#include "globals.h"

using namespace std;

class TEXTURE
{
private:
	GLuint tex_id;
	bool loaded;
	
public:
	TEXTURE() { file = ""; mipmap = loaded = false; tex_id = 0; w = h = 0; references = 0;}
	//TEXTURE( string filename, GLuint id ) { TEXTURE( filename, id, true ); }
	//TEXTURE( string filename, GLuint id, bool mip ) { file = filename; tex_id = id; mipmap = mip; loaded = true; }
	~TEXTURE() { Unload(); }
	
	int references;
	int w, h;
	bool mipmap;
	string file;
	
	//void SetTexID(GLuint new_tex_id) { tex_id = new_tex_id; loaded=true;}
	//void Set(string filename, GLuint id, bool mip) { file = filename; tex_id = id; mipmap = mip; loaded = true; }
	//void Unload() {if( loaded ) {glDeleteTextures( 1, &tex_id );loaded=false;}}
	void Load();
	void Unload();
	void Activate();
};

class TEXTURE_HANDLE
{
private:
	TEXTURE * tex;
	
public:
	TEXTURE_HANDLE() {tex = NULL;}
	TEXTURE_HANDLE(const TEXTURE_HANDLE & other);
	~TEXTURE_HANDLE();
	
	bool Load( string new_tex_file ) { return Load( new_tex_file, true ); }
	bool Load( string new_tex_file, bool mipmap ) { int w, h; return Load( new_tex_file, mipmap, w, h ); }
	bool Load( string new_tex_file, bool mipmap, int &w, int &h );
	
	void Unload();
	void Activate();
	
	TEXTURE_HANDLE & CopyFrom(const TEXTURE_HANDLE & other);
	TEXTURE_HANDLE & operator=(const TEXTURE_HANDLE & other) {return CopyFrom(other);}
};

class TEXTURES
{
private:
	list <TEXTURE> textures;

	TEXTURE * FindTexture(string texname);
	
public:
	//TEXTURES() { }
	//~TEXTURES() {}
	//void DeleteAll();
	//void Delete( GLuint tex_id );
	//void Delete( string file );
	
	/*GLuint Load( string new_tex_file ) { return Load( new_tex_file, true ); }
	GLuint Load( string new_tex_file, bool mipmap ) { int w, h; return Load( new_tex_file, mipmap, w, h ); }
	GLuint Load( string new_tex_file, bool mipmap, int &w, int &h );*/
	
	//GLuint Load( string new_tex_file ) { return Load( new_tex_file, true ); }
	//GLuint Load( string new_tex_file, bool mipmap ) { int w, h; return Load( new_tex_file, mipmap, w, h ); }
	TEXTURE * LoadTexture( string new_tex_file, bool mipmap, int &w, int &h );
	void UnloadTexture(TEXTURE * textodel);
	
	void ReloadAll();
};

#define _TEXTURES_H
#endif /* _TEXTURES_H */
