//  Gl_Texture_Image.h - an interface to OpenGL texture objects.
//
//	Vamos Automotive Simulator
//  Copyright (C) 2003 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _GL_TEXTURE_IMAGE_H_
#define _GL_TEXTURE_IMAGE_H_

#include <vamos/geometry/Texture_Image.h>
#include "textures.h"
#include "globals.h"

#include <iostream>

#ifdef WIN32
# define WINDOWS_LEAN_AND_MEAN 1
# define NOMINMAX 1               // Do not define MS' min()/max() macros.
# include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>

namespace Vamos_Geometry
{
  class Gl_Texture_Image : public Texture_Image
  {
	TEXTURE_HANDLE m_texture_name;
	  
  protected:
		  

  public:
	Gl_Texture_Image (std::string file_name, 
					  bool smooth = false, bool mip_map = false,
					  double width = 1.0, double height = 1.0);
	Gl_Texture_Image (const Gl_Texture_Image& image);
	//~Gl_Texture_Image ();

	const Gl_Texture_Image& operator = (const Gl_Texture_Image& image);
	
	void activate ();
	// Don't delete the texture in the destructor.  We don't
	// necessarily want to delete the texture when the object goes out
	// of scope.
	void remove () { m_texture_name.Unload(); }

	// Set texture the texture wrap parameter to GL_CLAMP_TO_EDGE.
	// GL_REPEAT is the default.
	void clamp_to_edge ();

	// Draw the image to the stencil buffer.
	void draw_stencil ();
  };
  
  class Facade : public Gl_Texture_Image
  {
    bool m_draw_back;
    double m_x_offset;
    double m_y_offset;
    double m_z_offset;

  public:
    Facade (std::string image_name, bool draw_back = false);
    // If `draw_back' is true, draw a solid-color rectangle for the
    // back of the image.

    void set_radius (double radius);
    void set_x_offset (double offset) { m_x_offset = offset; }
    void set_y_offset (double offset) { m_y_offset = offset; }
    void set_z_offset (double offset) { m_z_offset = offset; }
    void draw ();
  };
}

#endif // not _GL_TEXTURE_IMAGE_H_
