//	Vamos Automotive Simulator
//  Copyright (C) 2001--2002 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _INTERPOLATOR_H_
#define _INTERPOLATOR_H_

#include <vamos/geometry/Two_Point.h>
#include <vector>

namespace Vamos_Geometry
{
  class Interpolator
  {
  public:
	// Construct an empty curve.
	Interpolator () {};

	// Construct a cuvre from an array of points.
	Interpolator (const std::vector <Two_Point>& points) {};

	//virtual ~Interpolator () {};

	// Add a point to the curve.
	virtual void load (const Two_Point& point) = 0;

	// Add multiple points to the curve.
	virtual void load (const std::vector <Two_Point>& points) = 0;
  
	// Remove all points from the curve.
	virtual void clear () = 0;

	// Remove points with x > LIMIT.
	virtual void remove_greater (double limit) = 0;

	// Scale all of the x values by FACTOR.
	virtual void scale (double factor) = 0;

	// Return the y value at the x value DIST
	virtual double interpolate (double dist) const = 0;

	// Return the normal to the tanget at DIST.
	virtual Two_Point normal (double dist) const = 0;
  };
}

#endif
